<?php
class SelectCoreElementorProcessHolder extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_process_holder'; 
	}

	public function get_title() {
		return esc_html__( 'Process', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-process-holder';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_items',
			[
				'label'     => esc_html__( 'Number of Process Items', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'three' => esc_html__( 'Three', 'select-core'),
					'four' => esc_html__( 'Four', 'select-core'),
					'five' => esc_html__( 'Five', 'select-core')
				),
				'default' => 'three'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'number',
			[
				'label'     => esc_html__( 'Number', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'text',
			[
				'label'     => esc_html__( 'Text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);

		$repeater->add_control(
			'highlighted',
			[
				'label'     => esc_html__( 'Highlight Item?', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'process_item',
			[
				'label'     => esc_html__( 'Process Item', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['holder_classes'] = array(
			'qodef-process-holder',
			'qodef-process-holder-items-'.$params['number_of_items']
		);
		?>
		<div <?php mixtape_qodef_class_attribute($params['holder_classes']); ?>>
			<div class="qodef-process-inner clearfix">
				<?php foreach ( $params['process_item'] as $item ) {

					$item['item_classes'] = array(
						'qodef-process-item-holder'
					);

					if($item['highlighted'] === 'yes') {
						$item['item_classes'][] = 'qodef-pi-highlighted';
					}
					echo qodef_core_get_shortcode_template_part('templates/process-item-template', 'process', '', $item);
				} ?>
			</div>
		</div>
		<?php
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorProcessHolder() );