<?php
class SelectCoreElementorMessage extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_message'; 
	}

	public function get_title() {
		return esc_html__( 'Message', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-message';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'normal' => esc_html__( 'Normal', 'select-core'),
					'with_icon' => esc_html__( 'With Icon', 'select-core')
				),
				'default' => 'normal'
			]
		);

		mixtape_qodef_icon_collections()->getElementorParamsArray( $this, '', '' );
		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Icon Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'with_icon' )
				]
			]
		);

		$this->add_control(
			'icon_background_color',
			[
				'label'     => esc_html__( 'Icon Background Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'type' => array( 'with_icon' )
				]
			]
		);

		$this->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'border_color',
			[
				'label'     => esc_html__( 'Border Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'border_width',
			[
				'label'     => esc_html__( 'Border Width (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default value is 0', 'select-core' )
			]
		);

		$this->add_control(
			'close_icon_color',
			[
				'label'     => esc_html__( 'Close Icon Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'close_icon_hover_color',
			[
				'label'     => esc_html__( 'Close Icon Hover Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'content',
			[
				'label'     => esc_html__( 'Content', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

        $params['content'] = preg_replace('#^<\/p>|<p>$#', '', $params['content']); // delete p tag before and after content

		//Extract params for use in method
		extract($params);
		//Get HTML from template based on type of team
		$iconPackName = mixtape_qodef_icon_collections()->getIconCollectionParamNameByKey($params['icon_pack']);
		$message_classes = '';
		
		if ($type == 'with_icon') {
			$message_classes .= ' qodef-with-icon';
			$params['icon'] = $params[$iconPackName];
			$params['icon_attributes'] = $this->getIconStyle($params);
		}
		$params['message_classes'] = $message_classes;
		$params['message_styles'] = $this->getHolderStyle($params);
		$params['close_icon_style'] = $this->getCloseColorStyle($params);
		$params['close_icon_holder_style'] = $this->getCloseHolderColorStyle($params);


		echo qodef_core_get_shortcode_template_part('templates/message-holder-template', 'message', '', $params);
	}

	private function getIconStyle($params){
		$iconStyles = array();

        if(!empty($params['icon_color'])) {
            $iconStyles[] = 'color: '.$params['icon_color'];
        }

        if(!empty($params['icon_background_color'])) {
            $iconStyles[] = 'background-color:'.$params['icon_background_color'].'';
        }

        return implode(';', $iconStyles);
	}

	private function getHolderStyle($params){
		$holderStyles = array();
		
		if(!empty($params['background_color'])) {
            $holderStyles[] = 'background-color: '.$params['background_color'];
        }

        if(!empty($params['border_color'])) {
            $holderStyles[] = 'border-color:'.$params['border_color'].'';
        }
		if(!empty($params['border_width'])) {
            $holderStyles[] = 'border-width:'.$params['border_width'].'px';
		}

        return implode(';', $holderStyles);
	}

	private function getCloseColorStyle($params) {
		$close_icon_style = array();

		if($params['close_icon_color'] != '') {
			$close_icon_style[] = 'color: '.$params['close_icon_color'];
		}

		return $close_icon_style;
	}

	private function getCloseHolderColorStyle($params) {
		$close_icon_style = array();

		if($params['close_icon_hover_color'] != '') {
			$close_icon_style[] = 'color: '.$params['close_icon_hover_color'];
		}

		return $close_icon_style;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorMessage() );