<?php
class SelectCoreElementorClients extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_clients'; 
	}

	public function get_title() {
		return esc_html__( 'Clients', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-clients';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'columns',
			[
				'label'     => esc_html__( 'Columns', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'two-columns' => esc_html__( 'Two', 'select-core'),
					'three-columns' => esc_html__( 'Three', 'select-core'),
					'four-columns' => esc_html__( 'Four', 'select-core'),
					'five-columns' => esc_html__( 'Five', 'select-core'),
					'six-columns' => esc_html__( 'Six', 'select-core')
				),
				'default' => 'two-columns'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'hover_type',
			[
				'label'     => esc_html__( 'Hover Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'roll-over' => esc_html__( 'Roll Over', 'select-core'),
					'fade' => esc_html__( 'Fade', 'select-core'),
					'zoom' => esc_html__( 'Image Zoom', 'select-core')
				),
				'default' => 'roll-over',
				'condition' => [
					'image!' => ''
				]
			]
		);

		$repeater->add_control(
			'hover_image',
			[
				'label'     => esc_html__( 'Hover Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'condition' => [
					'hover_type' => array( 'roll-over', 'fade' )
				]
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Link Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'_self' => esc_html__( 'Self', 'select-core'),
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'client',
			[
				'label'     => esc_html__( 'Client', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		?>
		<div class="qodef-clients clearfix qodef-clients-<?php echo esc_attr($params['columns']); ?>">
				<?php foreach ( $params['client'] as $client ) {
					$client['image_alt']            = !empty($client['image']) ? get_post_meta($client['image']['id'], '_wp_attachment_image_alt', true) : '';
					$client['hover_image_alt']      = !empty($client['hover_image']) ? get_post_meta($client['hover_image']['id'], '_wp_attachment_image_alt', true) : '';

					$client['image']        = !empty($client['image']) ? $client['image']['url'] : $client['image'];
					$client['hover_image']  = !empty($client['hover_image']) ? $client['hover_image']['url'] : $client['hover_image'];

					$client['class']  = !empty($client['hover_type']) ? 'qodef-clients-'. $client['hover_type'] : 'qodef-hover-opacity';

					echo qodef_core_get_shortcode_template_part( 'templates/client-template', 'clients', '', $client );
				} ?>
		</div>
		<?php

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorClients() );