<?php
class SelectCoreElementorBoxedIcons extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_boxed_icons'; 
	}

	public function get_title() {
		return esc_html__( 'Boxed Icons', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-boxed-icons';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number_of_columns',
			[
				'label'     => esc_html__( 'Columns', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'4' => esc_html__( '4 Columns', 'select-core'),
					'8' => esc_html__( '8 Columns', 'select-core')
				),
				'default' => '4'
			]
		);

		$this->add_control(
			'skin',
			[
				'label'     => esc_html__( 'Skin', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'dark' => esc_html__( 'Dark', 'select-core'),
					'light' => esc_html__( 'Light', 'select-core')
				),
				'default' => 'dark'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'background_color',
			[
				'label'     => esc_html__( 'Background Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		mixtape_qodef_icon_collections()->getElementorParamsArray( $repeater, '', '' );


		$repeater->add_control(
			'custom_icon',
			[
				'label'     => esc_html__( 'Custom Icon', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$repeater->add_control(
			'icon_title',
			[
				'label'     => esc_html__( 'Icon Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'icon_title_color',
			[
				'label'     => esc_html__( 'Icon Title Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'icon_title!' => ''
				]
			]
		);

		$repeater->add_control(
			'icon_size',
			[
				'label'     => esc_html__( 'Icon Size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'qodef-icon-tiny' => esc_html__( 'Tiny', 'select-core'),
					'qodef-icon-small' => esc_html__( 'Small', 'select-core'),
					'qodef-icon-medium' => esc_html__( 'Medium', 'select-core'),
					'qodef-icon-large' => esc_html__( 'Large', 'select-core'),
					'qodef-icon-huge' => esc_html__( 'Very Large', 'select-core')
				),
				'default' => 'qodef-icon-tiny'
			]
		);

		$repeater->add_control(
			'custom_icon_size',
			[
				'label'     => esc_html__( 'Custom Icon Size (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Icon Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$repeater->add_control(
			'icon_hover_color',
			[
				'label'     => esc_html__( 'Icon Hover Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'target',
			[
				'label'     => esc_html__( 'Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Self', 'select-core'),
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => '_self',
				'condition' => [
					'link!' => ''
				]
			]
		);

		$this->add_control(
			'boxed_icon',
			[
				'label'     => esc_html__( 'Boxed Icon', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$classes = array('qodef-boxed-icons', 'clearfix');

		if( $params['skin'] === 'light' ) {
			$classes[] .= 'qodef-bi-skin-light' ;
		}

		if($params['number_of_columns'] != ''){
			$classes[] .= 'qodef-bi-' . $params['number_of_columns'] . '-columns' ;
		}
		?>
		<div <?php mixtape_qodef_class_attribute( $classes ); ?>>
		<?php
			foreach ( $params['boxed_icon'] as $icon ) {
				$icon['custom_icon']        = !empty($icon['custom_icon']) ? $icon['custom_icon']['id'] : $icon['custom_icon'];
				$icon['icon_parameters']    = $this->getIconParameters($icon);
				$icon['holder_style']       = $this->getIconHolderStyle($icon);
				$icon['icon_title_style']   = $this->getIconTitleStyle($icon);

				echo qodef_core_get_shortcode_template_part( 'templates/boxed-icon-template', 'boxed-icons',  '', $icon );

			}
		?>
		</div>

<?php

	}

	private function getIconParameters($params) {
		$params_array = array();

		if(empty($params['custom_icon'])) {
			$iconPackName = mixtape_qodef_icon_collections()->getIconCollectionParamNameByKey($params['icon_pack']);

			$params_array['icon_pack']   = $params['icon_pack'];
			$params_array[$iconPackName] = $params[$iconPackName];

			if(!empty($params['icon_size'])) {
				$params_array['size'] = $params['icon_size'];
			}

			if(!empty($params['custom_icon_size'])) {
				$params_array['custom_size'] = $params['custom_icon_size'];
			}



			$params_array['icon_color'] = $params['icon_color'];

			if(!empty($params['icon_hover_color'])) {
				$params_array['hover_icon_color'] = $params['icon_hover_color'];
			}
		}

		return $params_array;
	}

	private function getIconHolderStyle($params) {
		$style = array();

		if($params['background_color'] != '') {
			$style[] = 'background-color:'.$params['background_color'];
		}

		return $style;
	}

	private function getIconTitleStyle($params) {
		$style = array();

		if($params['icon_title_color'] != '') {
			$style[] = 'color:'.$params['icon_title_color'];
		}

		return $style;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorBoxedIcons() );