<?php
class SelectCoreElementorAccordion extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_accordion'; 
	}

	public function get_title() {
		return esc_html__( 'Accordion', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-accordion';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'el_class',
			[
				'label'     => esc_html__( 'Extra class name', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'select-core' )
			]
		);

		$this->add_control(
			'style',
			[
				'label'     => esc_html__( 'Style', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'accordion' => esc_html__( 'Accordion', 'select-core'),
					'toggle' => esc_html__( 'Toggle', 'select-core')
				),
				'default' => 'accordion)'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter accordion section title.', 'select-core' )
			]
		);

		$repeater->add_control(
			'el_id',
			[
				'label'     => esc_html__( 'Section ID', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter optional row ID. Make sure it is unique, and it is valid as w3c specification: <a target="_blank" href="http://www.w3schools.com/tags/att_global_id.asp">link</a> (Must not have spaces)', 'select-core' )
			]
		);

		$repeater->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'p' => esc_html__( 'p', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'text',
			[
				'label'       => esc_html__( 'Text', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::WYSIWYG,
			]
		);

		$this->add_control(
			'accordion_tab',
			[
				'label'     => esc_html__( 'Accordion Tab', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
 		$acc_class = $this->getAccordionClasses($params);
		$params['acc_class'] = $acc_class;
		?>

		<div class="qodef-accordion-holder clearfix <?php echo esc_attr( $params['acc_class'] ); ?>">
			<?php foreach ( $params['accordion_tab'] as $tab ) {
				$tab['content'] = $tab['text'];
				$tab['title_tag'] = ! empty( $tab['title_tag'] ) ? $tab['title_tag'] : 'h5';
				echo qodef_core_get_shortcode_template_part( 'templates/accordion-template', 'accordions', '', $tab );
			} ?>
		</div>
		<?php
	}

	private function getAccordionClasses($params){
		
		$acc_class = array();
		$style = $params['style'];
		switch($style) {
			case 'toggle':
				$acc_class[] = 'qodef-toggle';
				$acc_class[] = 'qodef-initial';
				break;
			default:
				$acc_class[] = 'qodef-accordion';
				$acc_class[] = 'qodef-initial';
		}

		if(!empty($params['el_class'])) {
			$acc_class[] = $params['el_class'];
		}

		return implode(' ',$acc_class);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorAccordion() );