<?php
class SelectCoreElementorEventsList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_events_list'; 
	}

	public function get_title() {
		return esc_html__( 'Events List', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-events-list';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'design_options',
			[
				'label' => esc_html__( 'Design Options', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'h1' => esc_html__( 'h1', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core')
				),
				'default' => 'h5'
			]
		);

		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'border_color',
			[
				'label'     => esc_html__( 'Border Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'query_and_layout_options',
			[
				'label' => esc_html__( 'Query and Layout Options', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Number of Events Per Page', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( '(enter -1 to show all)', 'select-core' )
			]
		);

		$this->add_control(
			'order_by',
			[
				'label'     => esc_html__( 'Order By', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'start-date' => esc_html__( 'Start Date', 'select-core'),
					'menu_order' => esc_html__( 'Menu Order', 'select-core'),
					'title' => esc_html__( 'Title', 'select-core'),
					'date' => esc_html__( 'Date', 'select-core')
				),
				'default' => 'start-date'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'select-core'),
					'DESC' => esc_html__( 'DESC', 'select-core')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'event_status',
			[
				'label'     => esc_html__( 'Show Event by Status', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'all' => esc_html__( 'All', 'select-core'),
					'upcoming' => esc_html__( 'Current and Upcoming', 'select-core'),
					'past' => esc_html__( 'Past', 'select-core')
				),
				'default' => 'all'
			]
		);

		$this->add_control(
			'show_load_more',
			[
				'label'     => esc_html__( 'Show Load More', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

        $query_array = $this->getQueryArray($params);
        $query_results = new \WP_Query($query_array);
        $params['query_results'] = $query_results;

        $data_atts = $this->getDataAtts($params);
        $data_atts['data-max-num-pages'] = $query_results->max_num_pages;

		$params['text_color_style']	= $this->getEventsListTextColor($params);
		$params['border_color_style']	= $this->getEventsListBorderColor($params);
        $classes = $this->getEventsClasses($params);
        ?>

		<div class="qodef-events-list-holder-outer <?php echo esc_attr($classes); ?>" <?php echo mixtape_qodef_get_inline_attrs($data_atts); ?>>
		<div class="qodef-events-list-holder clearfix">
			<?php
		        if($query_results->have_posts()):
		            while ( $query_results->have_posts() ) : $query_results->the_post();
		                $current_id = get_the_ID();
						$params['title'] = get_the_title($current_id);
						$params['date'] = get_post_meta($current_id, 'qodef_event_item_date', true);
						$params['link'] = get_post_meta($current_id, 'qodef_event_item_link', true);
						$params['target'] = get_post_meta($current_id, 'qodef_event_item_target', true);
						$params['tickets_status'] = get_post_meta($current_id, 'qodef_event_item_tickets_status', true);

						echo qodef_core_get_cpt_shortcode_template_part('events','events-list-template', '', $params);

		            endwhile;
		        else: ?>
					<p><?php esc_html_e( 'Sorry, no events matched your criteria.','select-core' ); ?></p>
		        <?php
		        endif;
		    ?>

       </div>
			<?php
		        if($params['show_load_more'] == 'yes'){
		            echo qodef_core_get_cpt_shortcode_template_part('events','load-more-template', '', $params);
		        }
	            wp_reset_postdata();
			?>
		</div>
		<?php
	}

    public function getQueryArray($params){
        $meta_query = array();
        $order_by = $params['order_by'];

        if ($params['order_by'] == 'start-date'){
            $order_by = 'meta_value';
        }

        $query_array = array(
            'post_type' => 'event',
            'orderby' => $order_by,
            'order' => $params['order'],
            'posts_per_page' => $params['number']
        );

        if ($params['order_by'] == 'start-date'){
            $query_array['meta_key'] = 'qodef_event_item_date_and_time'; //here because has to be added to query
        }

        //display date by event status, ex. end date larger then todays date or if it doesn't exist compare start date
        switch ($params['event_status']) {
            case 'upcoming':
                $meta_query = array(
                    'key' => 'qodef_event_item_date_and_time',
                    'value' => date("Y-m-d H:i"),
                    'compare' => '>=',
                    'type'    => 'DATETIME'
                );
                break;
            case 'past':
                $meta_query = array(
                    'key' => 'qodef_event_item_date_and_time',
                    'value' => date("Y-m-d H:i"),
                    'compare' => '<',
                    'type'    => 'DATETIME'
                );
                break;
        }

        if (is_array($meta_query) && count($meta_query)){
            $query_array['meta_query'][] = $meta_query;
        }

        $paged = '';
        if(empty($params['next_page'])) {
            if(get_query_var('paged')) {
                $paged = get_query_var('paged');
            } elseif(get_query_var('page')) {
                $paged = get_query_var('page');
            }
        }

        if(!empty($params['next_page'])){
            $query_array['paged'] = $params['next_page'];

        } else{
            $query_array['paged'] = 1;
        }

        return $query_array;
    }

    private function getEventsListTextColor($params) {

        $text_color = array();

        if ($params['text_color'] !== '') {
            $text_color[] = 'color:' . $params['text_color'];
        }
        return implode(';', $text_color);
    }

    private function getEventsListBorderColor($params) {

        $border_color = array();

        if ($params['border_color'] !== '') {
            $border_color[] = 'border-color:' . $params['border_color'];
        }

        return implode(';', $border_color);
    }

    public function getDataAtts($params){

        $data_attr = array();

        if(get_query_var('paged')) {
            $paged = get_query_var('paged');
        } elseif(get_query_var('page')) {
            $paged = get_query_var('page');
        } else {
            $paged = 1;
        }

        if(!empty($paged)) {
            $data_attr['data-next-page'] = $paged+1;
        }

        if(!empty($params['order_by'])){
            $data_attr['data-order-by'] = $params['order_by'];
        }

        if(!empty($params['order'])){
            $data_attr['data-order'] = $params['order'];
        }

        if(!empty($params['event_status'])){
            $data_attr['data-event-status'] = $params['event_status'];
        }

        if(!empty($params['number'])){
            $data_attr['data-number'] = $params['number'];
        }

        if(!empty($params['title_tag'])){
            $data_attr['data-title-tag'] = $params['title_tag'];
        }

        if(!empty($params['text_color'])){
            $data_attr['data-text-color'] = $params['text_color'];
        }

        if(!empty($params['border_color'])){
            $data_attr['data-border-color'] = $params['border_color'];
        }

        return $data_attr;
    }

    public function getEventsClasses($params){
        $classes = array();
       
        if($params['show_load_more'] == 'yes') {
            $classes[] = "qodef-events-load-more";
        }

        return implode(' ',$classes);

    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorEventsList() );