<?php
class SelectCoreElementorTabs extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_tabs'; 
	}

	public function get_title() {
		return esc_html__( 'Tabs', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-tabs';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label'     => esc_html__('Style', 'select-core'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'horizontal_tab' => esc_html__( 'Horizontal', 'select-core'),
					'vertical_tab' => esc_html__( 'Vertical', 'select-core')
				),
				'default' => 'horizontal_tab'
			]
		);

		$this->add_control(
			'title_layout',
			[
				'label'     => esc_html__( 'Title Layout', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'without_icon' => esc_html__( 'Without Icon', 'select-core'),
					'with_icon' => esc_html__( 'With Icon', 'select-core'),
					'only_icon' => esc_html__( 'Only Icon', 'select-core')
				),
				'default' => 'without_icon'
			]
		);

		$repeater = new \Elementor\Repeater();

		mixtape_qodef_icon_collections()->getElementorParamsArray( $repeater, '', '' );

		$repeater->add_control(
			'tab_title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);
		$repeater->add_control(
			'tab_text',
			[
				'label'       => esc_html__( 'Text', 'select-core' ),
				'type'        => \Elementor\Controls_Manager::WYSIWYG,
			]
		);
		$this->add_control(
			'tab',
			[
				'label'     => esc_html__( 'Tab', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['tab_class'] = $this->getTabClass($params);
		$params['tab_title_layout'] = $this->getTabTitleLayoutClass($params);

		?>


			<div class="qodef-tabs <?php echo esc_attr($params['tab_class']); ?> <?php echo esc_attr($params['tab_title_layout']); ?> clearfix">
				<ul class="qodef-tabs-nav">

					<?php foreach ( $params['tab'] as $tab ) { ?>
						<li>
							<?php if ( ! empty( $tab['tab_title'] ) ) { ?>
								<a href="#tab-<?php echo sanitize_title($tab['tab_title'])?>">
									<?php if($params['tab_class'] === 'qodef-vertical-tab' && ($params['tab_title_layout'] === 'qodef-tab-with-icon' || $params['tab_title_layout'] === 'qodef-tab-only-icon')) { ?>
										<span class="qodef-icon-frame"></span>
									<?php } ?>

									<?php if($tab['tab_title'] !== '' && $params['tab_title_layout'] !== 'qodef-tab-only-icon') { ?>
										<h4 class="qodef-tab-text-after-icon">
											<?php echo esc_attr($tab['tab_title'])?>
										</h4>
									<?php } ?>

									<?php if($params['tab_class'] !== 'qodef-vertical-tab' && ($params['tab_title_layout'] === 'qodef-tab-with-icon' || $params['tab_title_layout'] === 'qodef-tab-only-icon')) { ?>
										<span class="qodef-icon-frame"></span>
									<?php } ?>
								</a>
							<?php } ?>
						</li>
					<?php } ?>
				</ul>
				<?php foreach ( $params['tab'] as $tab ) {

					$rand_number         = rand( 0, 1000 );
					$tab['tab_title'] = $tab['tab_title'] . '-' . $rand_number;
					$tab['content'] = $tab['tab_text'];

					$iconPackName = mixtape_qodef_icon_collections()->getIconCollectionParamNameByKey($tab['icon_pack']);
					$tab['icon'] = $tab[$iconPackName];

					echo qodef_core_get_shortcode_template_part( 'templates/tab-content', 'tabs', '', $tab );
				} ?>
			</div>
		<?php
	}

	private function getTabClass($params){
		$tabStyle = $params['style'];
		$tabClass = '';
		
		switch ($tabStyle) {
			case 'vertical_tab':
				$tabClass = 'qodef-vertical-tab';
				break;
			default :
				$tabClass = 'qodef-horizontal-tab';
				break;
		}

		return $tabClass;
	}

	private function getTabTitleLayoutClass($params){
		$tabTitleLayout = $params['title_layout'];
		$tabIconClass = '';

		switch ($tabTitleLayout) {
			case 'with_icon':
				$tabIconClass = 'qodef-tab-with-icon';
				break;
			case 'only_icon':
				$tabIconClass = 'qodef-tab-only-icon';
				break;
			default :
				$tabIconClass = 'qodef-tab-without-icon';
				break;
		}

		return $tabIconClass;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorTabs() );