<?php
class SelectCoreElementorPricingTables extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_pricing_tables'; 
	}

	public function get_title() {
		return esc_html__( 'Pricing Tables', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-pricing-tables';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'columns',
			[
				'label'     => esc_html__( 'Columns', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'qodef-two-columns' => esc_html__( 'Two', 'select-core'), 
					'qodef-three-columns' => esc_html__( 'Three', 'select-core'), 
					'qodef-four-columns' => esc_html__( 'Four', 'select-core')
				),
				'default' => 'qodef-two-columns'
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$repeater->add_control(
			'price',
			[
				'label'     => esc_html__( 'Price', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default value is 100', 'select-core' ),
				'default'   => 100
			]
		);

		$repeater->add_control(
			'currency',
			[
				'label'     => esc_html__( 'Currency', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default mark is $', 'select-core' ),
				'default'   => '$'
			]
		);

		$repeater->add_control(
			'price_period',
			[
				'label'     => esc_html__( 'Price Period', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Default label is &quot;per month&quot;', 'select-core' ),
				'default'   => esc_html__('Per Month', 'select-core'),
			]
		);

		$repeater->add_control(
			'show_button',
			[
				'label'     => esc_html__( 'Show Button', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'select-core'), 
					'yes' => esc_html__( 'Yes', 'select-core'), 
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => ''
			]
		);

		$repeater->add_control(
			'button_text',
			[
				'label'     => esc_html__( 'Button Text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'     => esc_html__( 'Button Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_button' => array( 'yes' )
				]
			]
		);

		$repeater->add_control(
			'active',
			[
				'label'     => esc_html__( 'Active', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'), 
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);

		$repeater->add_control(
			'active_text',
			[
				'label'     => esc_html__( 'Active text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Best choice', 'select-core' ),
				'condition' => [
					'active' => array( 'yes' )
				],
				'default'   => esc_html__('Best choice', 'select-core'),
			]
		);

		$repeater->add_control(
			'content',
			[
				'label'     => esc_html__( 'Content', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::WYSIWYG
			]
		);

		$this->add_control(
			'pricing_table',
			[
				'label'     => esc_html__( 'Pricing Table', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::REPEATER,
				'fields'     => $repeater->get_controls(),
				'title_field'     => esc_html__( 'Item', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		?>

		<div class="qodef-pricing-tables clearfix <?php echo esc_attr( $params['columns'] ); ?>">
			<?php foreach ( $params['pricing_table'] as $table ) {

				$pricing_table_clasess		= 'qodef-price-table';

				if($table['active'] == 'yes') {
					$pricing_table_clasess .= ' qodef-active';
				}

				$table['pricing_table_classes'] = $pricing_table_clasess;
				$table['content'] = preg_replace('#^<\/p>|<p>$#', '', $table['content']);

				echo qodef_core_get_shortcode_template_part( 'templates/pricing-table-template','pricing-table', '', $table );
			} ?>
		</div>
		<?php
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorPricingTables() );