<?php

if ( ! function_exists( 'mixtape_qodef_load_shortcode_interface' ) ) {
	function mixtape_qodef_load_shortcode_interface() {
		include_once QODE_CORE_ABS_PATH . '/shortcodes/lib/shortcode-interface.php';
	}

	add_action( 'mixtape_qodef_before_options_map', 'mixtape_qodef_load_shortcode_interface' );
}

if ( ! function_exists( 'mixtape_qodef_load_shortcodes' ) ) {
	/**
	 * Loades all shortcodes by going through all folders that are placed directly in shortcodes folder
	 * and loads load.php file in each. Hooks to mixtape_qodef_after_options_map action
	 *
	 * @see http://php.net/manual/en/function.glob.php
	 */
	function mixtape_qodef_load_shortcodes() {
		if ( qodef_core_theme_installed() ) {
			foreach ( glob( QODE_CORE_ABS_PATH . '/shortcodes/*/load.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}

			QodeCore\Lib\ShortcodeLoader::getInstance()->load();
		}

		do_action( 'mixtape_qodef_shortcode_loader' );
	}

	add_action( 'mixtape_qodef_before_options_map', 'mixtape_qodef_load_shortcodes' );
}


if ( ! function_exists( 'select_core_load_elementor_shortcodes' ) ) {
	/**
	 * Function that loads elementor files inside shortcodes folder
	 */
	function select_core_load_elementor_shortcodes() {

		if( qodef_core_is_theme_registered() ) {
			foreach ( glob( QODE_CORE_ABS_PATH . '/shortcodes/*/elementor-*.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}

			foreach ( glob( QODE_CORE_ABS_PATH . '/shortcodes/*/*/elementor-*.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}

			foreach ( glob( QODE_CORE_CPT_PATH . '/*/shortcodes/elementor-*.php' ) as $shortcode_load ) {
				include_once $shortcode_load;
			}
		}
	}

	add_action( 'elementor/widgets/widgets_registered', 'select_core_load_elementor_shortcodes' );
}

if ( ! function_exists( 'select_core_add_elementor_widget_categories' ) ) {
	/**
	 * Registers category group
	 */
	function select_core_add_elementor_widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'select',
			[
				'title' => esc_html__( 'Select', 'select-core' ),
				'icon'  => 'fa fa-plug',
			]
		);

	}

	add_action( 'elementor/elements/categories_registered', 'select_core_add_elementor_widget_categories' );
}

if( ! function_exists( 'select_core_remove_widgets_for_elementor') ) {
	function select_core_remove_widgets_for_elementor( $black_list ) {

		$black_list[] = 'MixtapeEdgeInstagramWidget';
		$black_list[] = 'MixtapeEdgeLatestCauses';
		$black_list[] = 'MixtapeEdgeLatestPosts';
		$black_list[] = 'MixtapeEdgeSearchOpener';
		$black_list[] = 'MixtapeEdgeSeparatorWidget';
		$black_list[] = 'MixtapeEdgeSideAreaOpener';
		$black_list[] = 'MixtapeEdgeSocialIconWidget';
		$black_list[] = 'MixtapeEdgeStickySidebar';

		return $black_list;
	}

	add_filter('elementor/widgets/black_list', 'select_core_remove_widgets_for_elementor');
}

if ( ! function_exists( 'select_core_return_elementor_templates' ) ) {
	/**
	 * Function that returns all Elementor saved templates
	 */
	function select_core_return_elementor_templates() {
		return Elementor\Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
	}
}

if ( ! function_exists( 'select_core_generate_elementor_templates_control' ) ) {
	/**
	 * Function that adds Template Elementor Control
	 */
	function select_core_generate_elementor_templates_control( $object ) {
		$templates = select_core_return_elementor_templates();

		//if ( ! empty( $templates ) ) {
		$options = [
			'0' => '— ' . esc_html__( 'Select', 'qode-cpt' ) . ' —',
		];

		$types = [];

		if ( ! empty( $templates ) ) {

			foreach ( $templates as $template ) {
				$options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
				$types[ $template['template_id'] ]   = $template['type'];
			}
		};

		$object->add_control(
			'template_id',
			[
				'label'       => esc_html__( 'Choose Template', 'qode-cpt' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '0',
				'options'     => $options,
				'types'       => $types,
				'label_block' => 'true'
			]
		);

	}
}

if( ! function_exists('select_core_elementor_icons_style') ){
	function select_core_elementor_icons_style(){

		wp_enqueue_style( 'mixtape-qodef-elementor', QODE_CORE_URL_PATH . '/assets/css/admin/qodef-elementor.css');

	}

	add_action( 'elementor/editor/before_enqueue_scripts', 'select_core_elementor_icons_style' );
}

if ( ! function_exists( 'select_core_add_elementor_shortcodes_custom_styles' ) ) {
	function select_core_add_elementor_shortcodes_custom_styles() {

			$style = '';
			$shortcode_name_array = array();
			$shortcodes_icon_styles = array();

			foreach ( glob( QODE_CORE_ABS_PATH . '/shortcodes/*/elementor-*.php' ) as $shortcode_load ) {
			    $aux_array['name'] = str_replace(array('elementor-','.php'),'', basename( $shortcode_load ));
                $aux_array['directory'] = basename(dirname($shortcode_load));

                $shortcode_name_array[] = $aux_array;
			}

			foreach ( glob( QODE_CORE_ABS_PATH . '/shortcodes/*/*/elementor-*.php' ) as $shortcode_load ) {
			    $aux_array['name'] = str_replace(array('elementor-','.php'),'', basename( $shortcode_load ));
                $aux_array['directory'] = basename(dirname($shortcode_load));

                $shortcode_name_array[] = $aux_array;
			}
			foreach ( glob( QODE_CORE_CPT_PATH . '/shortcodes/elementor-*.php' ) as $shortcode_load ) {
			    $aux_array['name'] = str_replace(array('elementor-','.php'),'', basename( $shortcode_load ));
                $aux_array['directory'] = basename(dirname($shortcode_load));

                $shortcode_name_array[] = $aux_array;
			}

            foreach ( glob( QODE_CORE_ABS_PATH . '/post-types/*/shortcodes/elementor-*.php' ) as $shortcode_load ) {
                $aux_array['name'] = str_replace(array('elementor-','.php'),'', basename( $shortcode_load ));
                $aux_array['directory'] = basename(dirname($shortcode_load, 2));

                $shortcode_name_array[] = $aux_array;
            }

			$pie_chart_shortcodes = ['pie-chart', 'pie-chart-doughnut', 'pie-chart-pie', 'pie-chart-with-icon'];
			$album_shortcodes = ['album', 'album-player', 'albums-list', 'artists-list'];

			foreach ( $shortcode_name_array as $shortcode_name ) {

				if(file_exists( QODE_CORE_ABS_PATH . '/shortcodes/'.$shortcode_name['directory'].'/assets/img/dashboard_icon.png' )) {
					$shortcodes_icon_styles[] = '.mixtape-elementor-custom-icon.mixtape-elementor-' . $shortcode_name['name'] . ' {
                        background-image: url( "' .  QODE_CORE_URL_PATH . '/shortcodes/'.$shortcode_name['directory'].'/assets/img/dashboard_icon.png" );
                    }';
				} elseif (file_exists( QODE_CORE_ABS_PATH . '/post-types/'.$shortcode_name['directory'].'/shortcodes/assets/img/dashboard_icon.png' )) {
                    $shortcodes_icon_styles[] = '.mixtape-elementor-custom-icon.mixtape-elementor-' . $shortcode_name['name'] . ' {
                        background-image: url( "' .  QODE_CORE_URL_PATH . '/post-types/'.$shortcode_name['directory'].'/shortcodes/assets/img/dashboard_icon.png" );
                    }';
                }

				if( in_array($shortcode_name['name'], $pie_chart_shortcodes) ) {
                    if(file_exists( QODE_CORE_ABS_PATH . '/shortcodes/piecharts/'.$shortcode_name['directory'].'/assets/img/dashboard_icon.png' )) {
                        $shortcodes_icon_styles[] = '.mixtape-elementor-custom-icon.mixtape-elementor-' . $shortcode_name['name'] . ' {
                            background-image: url( "' .  QODE_CORE_URL_PATH . '/shortcodes/piecharts/'.$shortcode_name['directory'].'/assets/img/dashboard_icon.png" );
                        }';
                    }
                }

				if( in_array($shortcode_name['name'], $album_shortcodes )) {
                    if(file_exists( QODE_CORE_ABS_PATH . '/post-types/albums/shortcodes/assets/' . $shortcode_name['name'] . '/img/dashboard_icon.png' )) {
                        $shortcodes_icon_styles[] = '.mixtape-elementor-custom-icon.mixtape-elementor-' . $shortcode_name['name'] . ' {
                            background-image: url( "' .  QODE_CORE_URL_PATH . '/post-types/albums/shortcodes/assets/' . $shortcode_name['name'] . '/img/dashboard_icon.png" );
                        }';
                    }
                }
			}

			if (!empty($shortcodes_icon_styles)) {
				$style = implode(' ', $shortcodes_icon_styles);
			}

			if (!empty($style)) {
				wp_add_inline_style('mixtape-qodef-elementor', $style);
			}
	}

	add_action( 'elementor/editor/before_enqueue_scripts', 'select_core_add_elementor_shortcodes_custom_styles', 15 );
}

if ( ! function_exists( 'select_core_load_elementor_cpt_shortcodes_icons' ) ) {
	/**
	 * Function that loads elementor files inside shortcodes folder
	 */
	function select_core_load_elementor_cpt_shortcodes_icons() {
			$style = '';
			$shortcode_name_array = array();
			$shortcodes_icon_styles = array();

			foreach ( glob( QODE_CORE_CPT_PATH . '/shortcodes/elementor-*.php' ) as $shortcode_load ) {
				$shortcode_name_array[] = str_replace(array('elementor-','.php'),'',basename( $shortcode_load ));
			}

			foreach ( $shortcode_name_array as $shortcode_name ) {
				if(strpos($shortcode_name, 'portfolio') !== false){
					$cpt_name = 'portfolio';
				}elseif(strpos($shortcode_name, 'event') !== false){
					$cpt_name = 'events';
				}else{
					$cpt_name = $shortcode_name;
				}

				if(file_exists( EDGE_CORE_CPT_PATH . '/' . $cpt_name . '/shortcodes/img/' . $shortcode_name . '-dashboard_icon.png' )) {
					$shortcodes_icon_styles[] = '.mixtape-elementor-custom-icon.mixtape-elementor-' . $shortcode_name . ' {
                        background-image: url( "' . EDGE_CORE_CPT_URL_PATH . '/' . $cpt_name . '/shortcodes/img/' . $shortcode_name . '-dashboard_icon.png" );
                    }';
				}
			}

			if (!empty($shortcodes_icon_styles)) {
				$style = implode(' ', $shortcodes_icon_styles);
			}

			if ( ! empty( $style ) ) {
				wp_add_inline_style( 'mixtape-edge-elementor', $style );
			}
	}

	//add_action( 'elementor/editor/before_enqueue_scripts', 'select_core_load_elementor_cpt_shortcodes_icons' );
}

//function that maps "Anchor" option for section
if( ! function_exists('select_core_map_mixtape_section_options') ){
	function select_core_map_mixtape_section_options( $section, $args ){
		$animations = array(
			'' => esc_html__('No animation','mixtape'),
			'qodef-element-from-left' => esc_html__('Elements Shows From Left Side','mixtape'),
			'qodef-element-from-right' => esc_html__('Elements Shows From Right Side','mixtape'),
			'qodef-element-from-top' => esc_html__('Elements Shows From Top Side','mixtape'),
			'qodef-element-from-bottom' => esc_html__('Elements Shows From Bottom Side','mixtape'),
			'qodef-element-from-fade' => esc_html__('Elements Shows From Fade','mixtape')
		);


		$section->start_controls_section(
			'mixtape_section_options',
			[
				'label' => esc_html__( 'Mixtape Section Options', 'mixtape' ),
				'tab'   => \Elementor\Controls_Manager::TAB_ADVANCED,
			]
		);

		$section->add_control(
			'mixtape_anchor_id',
			[
				'label' => esc_html__( 'Mixtape Anchor ID', 'mixtape' ),
				'type'  => Elementor\Controls_Manager::TEXT,
			]
		);

		$section->add_control(
			'mixtape_enable_grid_row',
			[
				'label'        => esc_html__( 'Make this row "In Grid"', 'mixtape' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options'      => [
					'no'      => esc_html__( 'No', 'mixtape' ),
					'inner' => esc_html__( 'Yes', 'mixtape' ),
				],
				'prefix_class' => 'qodef-elementor-container-'
			]
		);

		$section->add_control(
			'mixtape_header_style',
			[
				'label'        => esc_html__( 'Header Style', 'mixtape' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => '',
				'options'      => [
					'' => esc_html__( 'Default', 'mixtape' ),
					'qodef-light-header' => esc_html__( 'Light', 'mixtape' ),
					'qodef-dark-header' => esc_html__( 'Dark', 'mixtape' ),
				]
			]
		);

		$prefix_classes = 'qodef-section';

		if(mixtape_qodef_options()->getOptionValue('parallax_on_off') == 'off'){
			$prefix_classes .= ' qodef-parallax-section-holder-touch-disabled';
		}

		$section->add_control(
			'mixtape_enable_parallax',
			[
				'label'        => esc_html__( 'Enable Parallax', 'mixtape' ),
				'type'         => Elementor\Controls_Manager::SELECT,
				'default'      => 'no',
				'options'      => [
					'no'     => esc_html__( 'No', 'mixtape' ),
					'holder' => esc_html__( 'Yes', 'mixtape' ),
				],
				'prefix_class' => $prefix_classes . ' qodef-parallax-section-'
			]
		);

		$section->add_control(
			'mixtape_parallax_image',
			[
				'label'              => esc_html__( 'Parallax Image', 'mixtape' ),
				'type'               => Elementor\Controls_Manager::MEDIA,
				'condition'          => [
					'mixtape_enable_parallax' => 'holder'
				],
				'frontend_available' => true,
				'selectors' => [
					'{{WRAPPER}}.qodef-parallax-section-holder' => 'background-image: url("{{URL}}") !important;'
				]
			]
		);

		$section->add_control(
			'mixtape_parallax_speed',
			[
				'label'     => esc_html__( 'Parallax Speed', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::TEXT,
				'condition' => [
					'mixtape_enable_parallax' => 'holder'
				],
				'default'   => '0'
			]
		);

		$section->add_control(
			'mixtape_parallax_height',
			[
				'label'     => esc_html__( 'Parallax Section Height (px)', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::TEXT,
				'condition' => [
					'mixtape_enable_parallax' => 'holder'
				],
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}}.qodef-parallax-section-holder' => 'min-height: {{VALUE}}px; height: auto;'
				]

			]
		);

        $section->add_control(
            'mixtape_parallax_background_size',
            [
                'label'        => esc_html__( 'Parallax Background Size', 'mixtape' ),
                'type'         => Elementor\Controls_Manager::SELECT,
                'default'      => 'no',
                'options'      => [
                    'auto'       => esc_html__( 'Default', 'mixtape' ),
                    'cover'      => esc_html__( 'Cover', 'mixtape' ),
                    'contain'    => esc_html__( 'Contain', 'mixtape' ),
                ],
                'condition' => [
                    'mixtape_enable_parallax' => 'holder'
                ],
                'selectors' => [
                    '{{WRAPPER}}.qodef-parallax-section-holder' => 'background-size: {{VALUE}};'
                ]
            ]
        );

		$section->add_control(
			'mixtape_css_animation',
			[
				'label'     => esc_html__( 'CSS Animation', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::SELECT,
				'default'   => '',
				'options'   => $animations,
				'condition' => [
					'mixtape_enable_parallax' => 'no'
				],
				'render_type' => 'template',
				'prefix_class' => 'qodef-elementor-admin-animation qodef-elementor-admin-'
			]
		);

		$section->add_control(
			'mixtape_transition_delay',
			[
				'label'     => esc_html__( 'Transition delay (ms)', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::TEXT,
				'default'   => '',
				'condition' => [
					'mixtape_css_animation!' => ''
				],
				'render_type' => 'template',
			]
		);

		$section->add_control(
			'enable_grunge_effect',
			[
				'label'     => esc_html__( 'Enable Grunge Effect on Row', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::SELECT,
				'default'   => 'no',
				'options'   => [
					'no' => esc_html__('No','mixtape'),
					'yes' => esc_html__('Yes','mixtape'),
				],
				'condition' => [
					'mixtape_enable_parallax' => 'no'
				]
			]
		);

		$section->add_control(
			'grunge_effect_top',
			[
				'label'     => esc_html__( 'Grunge Effect Top', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::SELECT,
				'default'   => 'yes',
				'options'   => [
					'no' => esc_html__('No','mixtape'),
					'yes' => esc_html__('Yes','mixtape'),
				],
				'condition' => [
					'enable_grunge_effect' => 'yes'
				]
			]
		);

		$section->add_control(
			'grunge_effect_bottom',
			[
				'label'     => esc_html__( 'Grunge Effect Bottom', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::SELECT,
				'default'   => 'yes',
				'options'   => [
					'no' => esc_html__('No','mixtape'),
					'yes' => esc_html__('Yes','mixtape'),
				],
				'condition' => [
					'enable_grunge_effect' => 'yes'
				]
			]
		);

		$section->add_control(
			'grunge_effect_background',
			[
				'label'     => esc_html__( 'Grunge Effect Background', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::COLOR,
				'condition' => [
					'enable_grunge_effect' => 'yes'
				]
			]
		);

		$section->add_control(
			'mixtape_box_shadow',
			[
				'label'     => esc_html__( 'Box Shadow', 'mixtape' ),
				'type'      => Elementor\Controls_Manager::SELECT,
				'default'   => 'no-shadow',
				'options'   => [
					'no-shadow' => esc_html__('No','mixtape'),
					'shadow' => esc_html__('Yes','mixtape'),
				],
				'prefix_class' => 'qodef-section-with-'
			]
		);

		$section->end_controls_section();
	}

	add_action('elementor/element/section/_section_responsive/after_section_end', 'select_core_map_mixtape_section_options', 10, 2);
}

//function that renders "Anchor" option for section
if( ! function_exists('select_core_render_section_anchor_option') ) {
	function select_core_render_section_anchor_option( $element )   {
		if( 'section' !== $element->get_name() ) {
			return;
		}

		$params = $element->get_settings_for_display();

		if( ! empty( $params['mixtape_anchor_id'] ) ){
			$element->add_render_attribute( '_wrapper', 'data-qodef-anchor', $params['mixtape_anchor_id'] );
		}
	}

	add_action( 'elementor/frontend/section/before_render', 'select_core_render_section_anchor_option');
}

//function that renders "Header Style" option for section
if( ! function_exists('select_core_render_section_header_style_option') ) {
	function select_core_render_section_header_style_option( $element )   {
		if( 'section' !== $element->get_name() ) {
			return;
		}

		$params = $element->get_settings_for_display();

		if( ! empty( $params['mixtape_header_style'] ) ){
			$element->add_render_attribute( '_wrapper', 'data-qodef_header_style', $params['mixtape_header_style'] );
		}
	}

	add_action( 'elementor/frontend/section/before_render', 'select_core_render_section_header_style_option');
}

//frontend function for "Parallax"
if ( ! function_exists( 'select_core_render_section_parallax_option' ) ) {
	function select_core_render_section_parallax_option( $element ) {
		if ( 'section' !== $element->get_name() ) {
			return;
		}

		$params = $element->get_settings_for_display();

		if ( ! empty( $params['mixtape_parallax_image']['id'] ) ) {
			$parallax_image_src = $params['mixtape_parallax_image']['url'];
			$parallax_speed     = ! empty( $params['mixtape_parallax_speed'] ) ? $params['mixtape_parallax_speed'] : 0;
			$parallax_height    = ! empty( $params['mixtape_parallax_height'] ) ? $params['mixtape_parallax_height'] : 0;
			$parallax_background_size = ! empty( $params['mixtape_parallax_background_size'] ) ? $params['mixtape_parallax_background_size'] : 'auto';

			$element->add_render_attribute( '_wrapper', 'style', 'background-image: url(' . $parallax_image_src . ');' );
			$element->add_render_attribute( '_wrapper', 'style', 'min-height: ' . $parallax_height . 'px; height:auto;' );
			$element->add_render_attribute( '_wrapper', 'style', 'background-size: ' . $parallax_background_size . ';' );
			$element->add_render_attribute( '_wrapper', 'class', 'parallax_section_holder' );
			$element->add_render_attribute( '_wrapper', 'data-qodef-parallax-speed', $parallax_speed );
		}
	}

	add_action( 'elementor/frontend/section/before_render', 'select_core_render_section_parallax_option' );
}

//function that renders helper hidden input for parallax data attribute section
if ( ! function_exists( 'select_core_generate_parallax_helper' ) ) {
	function select_core_generate_parallax_helper( $template, $widget ) {
		if ( 'section' === $widget->get_name() ) {
			$template_preceding = "
            <# if( settings.mixtape_enable_parallax == 'holder' ){
		        let parallaxSpeed = settings.mixtape_parallax_speed !== '' ? settings.mixtape_parallax_speed : '0';
	            let parallaxImage = settings.mixtape_parallax_image.url !== '' ? settings.mixtape_parallax_image.url : '0'
	        #>
		        <input type='hidden' class='qodef-parallax-helper-holder' data-parallax-bg-speed='{{ parallaxSpeed }}' data-parallax-bg-image='{{ parallaxImage }}'/>
		    <# } #>";
			$template           = $template_preceding . " " . $template;
		}

		return $template;
	}

	add_action( 'elementor/section/print_template', 'select_core_generate_parallax_helper', 10, 2 );
}
//
//function that renders helper hidden input for section animation
if ( ! function_exists( 'select_core_generate_section_animation_helper' ) ) {
	function select_core_generate_section_animation_helper( $template, $widget ) {
		if ( 'section' === $widget->get_name() ) {
			$template_preceding = "
            <# if( settings.mixtape_css_animation !== '' ){
		        let animationType = settings.mixtape_css_animation;
	            let transitionDelay = settings.mixtape_transition_delay !== '' ? settings.mixtape_transition_delay : '0'
	        #>
		        <input type='hidden' class='qodef-section-animation-helper-holder' data-animation='{{ animationType }}' data-delay='{{ transitionDelay }}'/>
		    <# } #>";
			$template           = $template_preceding . " " . $template;
		}

		return $template;
	}

	add_action( 'elementor/section/print_template', 'select_core_generate_section_animation_helper', 10, 2 );
}

if ( ! function_exists( 'select_core_return_elementor_templates' ) ) {
	/**
	 * Function that returns all Elementor saved templates
	 */
	function select_core_return_elementor_templates() {
		return Elementor\Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
	}
}

if ( ! function_exists( 'select_core_generate_elementor_templates_control' ) ) {
	/**
	 * Function that adds Template Elementor Control
	 */
	function select_core_generate_elementor_templates_control( $object ) {
		$templates = select_core_return_elementor_templates();

		if ( ! empty( $templates ) ) {
			$options = [
				'0' => '— ' . esc_html__( 'Select', 'select-core' ) . ' —',
			];

			$types = [];

			foreach ( $templates as $template ) {
				$options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
				$types[ $template['template_id'] ]   = $template['type'];
			}

			$object->add_control(
				'template_id',
				[
					'label'       => esc_html__( 'Choose Template', 'select-core' ),
					'type'        => \Elementor\Controls_Manager::SELECT,
					'default'     => '0',
					'options'     => $options,
					'types'       => $types,
					'label_block' => 'true'
				]
			);
		};
	}
}

if ( ! function_exists( 'mixtape_core_render_section_background_before' ) ) {
	function mixtape_core_render_section_background_before( $section ) {
		ob_start();
	}
	add_action( 'elementor/frontend/section/before_render', 'mixtape_core_render_section_background_before');
}

if ( ! function_exists( 'mixtape_core_render_section_background_after' ) ) {
	function mixtape_core_render_section_background_after( $section ) {

		$content = ob_get_clean();

		$params = $section->get_settings_for_display();

		extract( $params );

		if ( $enable_grunge_effect == 'yes' ) {
			$grunge_effect_style = '';
			if ( $grunge_effect_background != "" ) {
				$grunge_effect_style = 'fill:' . $grunge_effect_background;
			}
		}

		$svg_top_output = '';
		if ( $enable_grunge_effect == 'yes' && $grunge_effect_top == 'yes' ) {
			$svg_top_output .= '<svg class="qodef-grunge-effect qodef-grunge-effect-top" preserveAspectRatio="none" width="1920px" height="52px" viewBox="0 0 1920 52" enable-background="new 0 0 1920 52" ' . mixtape_qodef_get_inline_attr( $grunge_effect_style, 'style' ) . '>';
			$svg_top_output .= '<polygon points="406.54,13.503 406.398,13.307 405.751,13.302 405.88,13.496 "/>
				<polygon points="241.93,10.933 241.795,10.751 241.246,10.74 241.382,10.918 "/>
					<path d="M268.944,15.952c1.75-0.069,0.83-0.479,0.252-0.568c-0.142-0.021-0.296-0.031-0.461-0.038
						c-0.247-0.003-0.412,0.007-0.653,0.035c0.017,0.21,0.566,0.378,0.742,0.577C268.861,15.955,268.901,15.955,268.944,15.952z"/>
					<path d="M255.257,17.744c-1.162-0.021-2.01-0.006-1.551,0.416c0.019,0,0.036,0,0.049,0
						C255.363,18.252,255.287,17.867,255.257,17.744z"/>
					<path d="M675.027,28.849c-0.917-0.167-2.096-0.133-3.134-0.204c-0.011,0.063-0.024,0.175,0.283,0.267
						C672.859,29.106,674.628,29.037,675.027,28.849z"/>
					<path d="M45.177,41.515c0.15,0.018,0.321,0.003,0.477,0.015c-0.161-0.109-0.339-0.185-0.726-0.219
						c-0.067-0.006-0.138-0.006-0.218-0.011c0.052,0.052,0.108,0.103,0.209,0.151C44.982,41.478,45.057,41.501,45.177,41.515z"/>
					<polygon points="132.24,46.371 131.982,46.181 131.576,46.164 131.84,46.353 "/>
					<path d="M40.624,41.96c0.429-0.052,1.232-0.04,2.054,0.104c-0.372-0.276-1.105-0.365-1.404-0.394
						c-0.409-0.026-1.04-0.022-0.708,0.295C40.585,41.965,40.605,41.96,40.624,41.96z"/>
					<path d="M45.389,42.27c-0.123-0.061-0.28-0.138-0.402-0.2l-0.289-0.023c0.039,0.043,0.092,0.081,0.168,0.121
						C44.982,42.219,44.996,42.219,45.389,42.27z"/>
					<path d="M114.323,50.784c-0.176-0.055-0.271-0.112-0.389-0.175c-0.2-0.092-0.313-0.112-0.437-0.121
						c-0.047,0-0.088,0-0.129,0.003c0.082,0.061,0.177,0.121,0.306,0.176C113.935,50.767,114.141,50.775,114.323,50.784z"/>
					<path d="M69.304,49.443c0.101-0.031,0.342-0.018,0.389-0.018c-0.218-0.086-0.501-0.201-0.719-0.286
						c-0.041,0.051,0.095,0.197-0.188,0.154c0.072,0.037,0.137,0.071,0.219,0.105C69.175,49.478,69.232,49.467,69.304,49.443z"/>
					<path d="M36.533,49.119c-0.274-0.182-0.602-0.268-0.814-0.291c-0.218-0.017-0.206,0.034-0.165,0.055
						C36.014,49.104,36.403,49.113,36.533,49.119z"/>
					<path d="M16.978,47.404c0.302,0.144,0.553,0.172,0.638,0.13c0.066-0.034,0.025-0.107-0.129-0.21
						c-0.33-0.018-0.4-0.099-0.648-0.136c-0.262-0.025-0.121,0.066-0.062,0.102C16.831,47.327,16.904,47.367,16.978,47.404z"/>
					<polygon points="18.989,47.657 18.724,47.484 18.307,47.427 18.577,47.605 "/>
					<path d="M16.687,47.468c0.06-0.049-0.013-0.141-0.221-0.276c-0.151,0.029-0.003,0.095-0.24,0.115
						c-0.111,0.012-0.301-0.037-0.386-0.058c0.043,0.023,0.092,0.049,0.135,0.072C16.316,47.49,16.603,47.524,16.687,47.468z"/>
					<path d="M15.353,47.461c0,0,0.002,0,0.006,0c0.044-0.036-0.174-0.2-0.336-0.229c-0.002,0-0.002,0-0.002,0
						c-0.041,0.009,0.205,0.175,0.286,0.212C15.314,47.45,15.33,47.459,15.353,47.461z"/>
					<path d="M3.569,45.781c0.055,0.032,0.122,0.073,0.184,0.101c0.294,0.156,0.344,0.146,0.489,0.121
						c0.084-0.018,0.144-0.022,0.295,0.021c-0.183-0.093-0.407-0.198-0.658-0.247C3.747,45.75,3.646,45.756,3.569,45.781z"/>
					<path d="M2.448,45.658c0.034,0.052,0.102,0.098,0.171,0.149c0.011-0.003,0.017-0.006,0.026-0.008
						c0.296-0.05,0.701,0.12,0.767,0.037c0.044-0.063,0.072-0.101-0.619-0.236C2.674,45.581,2.35,45.522,2.448,45.658z"/>
					<path d="M1912.804,30.979c0.107-0.042,0.084-0.092,0.072-0.112c-0.045-0.008-0.094-0.014-0.154-0.02
						c-0.309-0.028-0.578,0.04-0.885,0.017c-0.043,0.023-0.08,0.047-0.053,0.075C1911.874,31.025,1912.569,31.07,1912.804,30.979z"/>
					<path d="M1909.522,34.379c0.164-0.052,0.234-0.155,0.27-0.207c-0.791-0.04-0.717,0.12-0.705,0.141
						C1909.13,34.382,1909.321,34.441,1909.522,34.379z"/>
					<path d="M1817.087,28.618c0.016-0.045,0.094-0.187-0.469-0.241c-0.26-0.018-0.506-0.008-0.781,0.026
						c-0.018,0.037-0.023,0.071,0.006,0.109C1815.96,28.642,1816.515,28.687,1817.087,28.618z"/>
					<path d="M1813.118,28.59l0.406-0.063c0.176-0.092-0.174-0.136-0.34-0.149c-0.449-0.034-0.865,0.012-0.768,0.144
						c0.006,0.006,0.012,0.012,0.02,0.015C1812.634,28.55,1812.909,28.576,1813.118,28.59z"/>
					<path d="M1284.741,36.257c-0.027-0.003-0.064-0.003-0.104-0.003c-1.117-0.031-1.279,0.149-1.553,0.419
						c0.025-0.002,0.049-0.005,0.072-0.008C1284.618,36.475,1284.702,36.464,1284.741,36.257z"/>
					<path d="M1279.798,36.478c-0.686,0.041-0.84,0.133-0.863,0.262c0.369,0.012,0.863,0.028,1.227,0.041L1279.798,36.478
						z"/>
					<path d="M1281.813,37.302c-0.836-0.018-1.037,0.253-0.746,0.385c0.285,0.124,0.9,0.093,1.1,0.081
						c-0.328-0.081-0.307-0.127-0.152-0.222C1282.159,37.454,1282.167,37.396,1281.813,37.302z"/>
					<path d="M1238.339,39.329c0.736,0,0.482-0.298,1.236-0.246c-0.08-0.139-0.457-0.201-1.391-0.23
						c-0.213-0.005-0.416-0.008-0.623-0.011c-0.273,0.224-0.273,0.224,0,0.465C1237.798,39.312,1238.101,39.326,1238.339,39.329z"/>
					<path d="M1258.567,40.856c0.223-0.02,0.33-0.028,0.33-0.073c0-0.075-0.246-0.13-0.33-0.196
						c0.543,0.037,0.641,0.047,1.143,0.184c0.365,0.092,0.744,0.196,1.758,0.173c0.117-0.163,0.529-0.31,0.529-0.482
						c0.004-0.126-0.082-0.167-0.512-0.345c-1.41-0.006-2.678,0.181-4.096,0.152c-1.369-0.025-2.477-0.21-3.732-0.302
						c-0.006,0.058,0,0.126,0,0.181c-0.111,0.026-0.219,0.021-0.779-0.129c-0.906-0.241-0.906-0.241-0.906,0.275c0.018,0,0.039,0,0.061,0
						C1253.032,40.306,1256.587,40.47,1258.567,40.856z"/>
					<path d="M1251.196,40.073c-0.373-0.008-0.871-0.026-1.234-0.037v0.289c0,0,0.01,0,0.025,0
						C1250.435,40.341,1251.271,40.363,1251.196,40.073z"/>
					<path d="M1231.329,40.047c1.006,0.006,0.951-0.212,0.385-0.35c-0.914,0.012-0.791,0.195-0.59,0.281
						C1231.181,40.008,1231.253,40.026,1231.329,40.047z"/>
					<polygon points="1264.323,40.76 1263.542,40.736 1263.542,40.915 1264.317,40.94 "/>
					<path d="M731.453,36.836c-0.154-0.005-0.3-0.011-0.454-0.014c-0.365,0-0.737,0.009-0.966,0.115
						c-0.308,0.146-0.129,0.302-0.249,0.456c0.036-0.002,0.076-0.005,0.106-0.008C731.128,37.308,731.907,37.233,731.453,36.836z"/>
					<path d="M730.893,39.02c0.023,0,0.042,0,0.057,0c1.057-0.046,1.471,0.264,2.501,0.229
						c-0.284-1.143-0.355-1.45-1.682-1.93c-0.311,0.003-0.558,0.003-0.924,0.135c-0.348,0.118-0.907,0.078-1.438,0.026
						c0.337,0.315,0.909,0.614,1.214,0.93C730.858,38.651,730.88,38.767,730.893,39.02z"/>
					<path d="M760.457,39.054c1.32,0.006,1.121-0.334,0.583-0.46c-0.018-0.005-0.046-0.008-0.065-0.011
						c-0.801,0.011-0.813,0.16-0.529,0.471C760.446,39.054,760.446,39.054,760.457,39.054z"/>
					<path d="M1180.517,45.968c0.061-0.042,0.055-0.092,0.045-0.14c-0.658-0.021-0.998-0.078-1.27-0.21
						c-0.98,0.018-0.672,0.179-0.494,0.244C1179.233,46.025,1180.282,46.181,1180.517,45.968z"/>
					<path d="M731.341,39.476c0.159,0.055,0.92,0.238,1.479,0.04c-0.313-0.086-0.712-0.197-1.02-0.283
						C730.775,39.27,731.282,39.455,731.341,39.476z"/>
					<path d="M1182.04,47.348c0.869-0.125,0.74-0.199,0.184-0.363c-0.633-0.184-1.012-0.32-0.73-0.579
						c-0.375,0.014-1.529,0.058-0.092,0.688C1181.603,47.181,1181.813,47.261,1182.04,47.348z"/>
					<path d="M1176.181,46.824c-0.389-0.092-0.178-0.281-0.939-0.304c-0.111-0.006-0.234,0-0.346,0.002
						c-0.008,0.037-0.016,0.112,0.146,0.176C1175.317,46.811,1175.933,46.824,1176.181,46.824z"/>
					<path d="M740.104,40.162c0.018-0.146-0.406-0.253-0.642-0.379l-1.148,0.083c0.01,0.037,0.028,0.115,0.234,0.181
						C738.944,40.174,739.721,40.168,740.104,40.162z"/>
					<path d="M722.593,39.794l0.319-0.085c0-0.092-0.355-0.118-0.649-0.121c-0.471-0.006-0.918,0.058-0.529,0.187
						c0.01,0.003,0.022,0.009,0.034,0.014C722.022,39.788,722.345,39.791,722.593,39.794z"/>
					<path d="M1178.54,48.449c-0.156,0.185-0.309,0.379,0.398,0.626c1.369,0.471,1.369,0.471,1.449,0.609
						c0.254,0.006,0.59,0.017,0.848,0.023c1.283-0.149-0.246-0.896-1.811-1.058c-0.229-0.439-1.102-0.912-3.234-1.734
						c-0.029-0.003-0.068-0.006-0.096-0.006C1174.604,46.95,1178.479,48.433,1178.54,48.449z"/>
					<path d="M723.632,40.191c-0.396-0.029-0.78-0.066-1.197-0.075c-0.507,0-0.678,0.065-0.642,0.238
						c0.034,0,0.076,0,0.105,0.003C724.009,40.38,724.009,40.38,723.632,40.191z"/>
					<polygon points="715.415,40.38 715.272,40.196 714.447,40.188 714.589,40.372 "/>
					<path d="M738.997,40.702c0,0,0.089-0.175-0.442-0.181c-0.471,0-0.365,0.129-0.647,0.172
						c-0.012,0.003-0.024,0.003-0.035,0.003c-0.061,0.006-0.113,0.009-0.178,0.009c0.035,0.023,0.07,0.042,0.142,0.065
						C738.17,40.875,738.897,40.831,738.997,40.702z"/>
					<path d="M712.285,40.478c-0.146-0.085-0.429-0.149-0.607-0.227c-0.418,0.055-0.553,0.166-0.473,0.379
						c0.356,0.004,0.839,0.009,1.198,0.012C712.408,40.616,712.414,40.547,712.285,40.478z"/>
					<path d="M722.523,40.841c1.09-0.041,0.612-0.259,0.123-0.34c-0.249-0.04-0.442-0.043-0.531-0.046
						c-0.283,0-0.429,0.022-0.63,0.08C721.804,40.627,722.216,40.747,722.523,40.841z"/>
					<path d="M1184.017,48.478c0.852-0.168,0.73-0.536-0.246-0.82c-0.27,0.006-0.861,0.008-0.83,0.184
						c0.039,0.241,0.75,0.43,0.977,0.654C1183.948,48.49,1183.983,48.484,1184.017,48.478z"/>
					<path d="M719.742,41.376c0.606,0.01,1.231-0.003,0.961-0.28c-0.361-0.006-0.844-0.009-1.203-0.015l0.218,0.295
						C719.724,41.38,719.729,41.376,719.742,41.376z"/>
					<polygon points="716.428,41.25 716.276,41.046 715.456,41.041 715.604,41.242 "/>
					<path d="M735.207,41.727c-0.306,0.003-0.548,0.026-0.772,0.075c0.524,0.037,1.209,0.089,1.733,0.127
						C735.997,41.805,735.678,41.739,735.207,41.727z"/>
					<path d="M1181.493,49.075c0.037,0.028,0.078,0.058,0.148,0.084c0.242,0.094,0.717,0.141,1.582,0.151
						c0.1-0.246-0.656-0.289-0.896-0.299C1181.989,49.007,1181.737,49.024,1181.493,49.075z"/>
					<path d="M735.082,42.276c0.019-0.035-0.04-0.058-0.099-0.087c-0.012-0.002-0.025-0.005-0.042-0.012
						c-0.087-0.029-0.188-0.058-0.289-0.083c-0.418,0.095-0.377,0.158-0.277,0.189C734.546,42.339,735.042,42.345,735.082,42.276z"/>
					<path d="M696.553,42.276c0.119-0.139-0.046-0.19-0.612-0.202c-0.366,0-0.732,0.029-1.097,0
						c0.011,0,0.023,0.006,0.035,0.012C695.269,42.219,695.945,42.256,696.553,42.276z"/>
					<path d="M735.46,42.657c-0.914-0.003-0.925,0.161-0.936,0.385c0.005,0,0.011,0,0.022-0.003
						c0.744-0.008,1.285,0.173,2.076,0.115c-0.272-0.063-0.637-0.144-0.908-0.207l0.176-0.272
						C735.743,42.666,735.608,42.661,735.46,42.657z"/>
					<path d="M695.503,42.447c-0.534,0.029-0.317,0.125-0.199,0.167c0.237,0.078,0.801,0.173,1.249,0.132
						c-0.012-0.103-0.165-0.137-0.542-0.184C695.727,42.531,695.586,42.505,695.503,42.447z"/>
					<path d="M1903.05,32.196c1.252,0.144,1.697,0.112,1.936-0.133c0.232-0.017,0.363-0.017,0.918,0.026
						c0.83,0.064,1.072,0.041,1.279-0.118c-1.154-0.2-1.756-0.1-2.486,0.064c-0.152-0.047-0.369-0.104-0.521-0.149
						c0.693-0.023,1.074-0.173,1.48-0.578c-0.383-0.034-0.885-0.083-1.268-0.123c-0.08,0.222-0.313,0.275-0.783,0.345
						c-0.494,0.068-0.719,0.121-0.801,0.324c0.039,0,0.094,0,0.137,0.003c0.545,0,0.742,0.012,0.748,0.052
						c0.004,0.018-0.055,0.041-0.09,0.058C1903.427,32.044,1903.228,32.118,1903.05,32.196z"/>
					<path d="M1899.985,31.903c0.006,0.006,0.012,0.003,0.027,0.006c0.914,0.109,1.613-0.121,2.492-0.083
						c0.104-0.078,0.246-0.188,0.35-0.267c0.012-0.038,0.154-0.075-0.025-0.109c-0.227,0.022-0.545,0.246-0.615,0.351
						c-0.119-0.073-0.281-0.167-0.402-0.241c-0.436-0.033-0.912,0.034-1.334-0.023c0.123,0.115,0.092,0.135-0.098,0.184
						C1900.153,31.782,1900.087,31.826,1899.985,31.903z"/>
					<path d="M1244.597,40.162c1.428,0.023,2.137,0.012,2.447-0.212c-0.365,0.011-0.914,0.028-1.324,0
						c-0.592-0.034-1.051-0.127-1.592-0.179c-0.426,0.115-1.055,0.187-1.234,0.345c-0.486-0.012-0.502-0.026-0.771-0.218
						c-0.117-0.087-0.365-0.121-0.848-0.121c-0.025,0.462-0.025,0.534,0.389,0.678C1242.04,40.15,1242.89,40.134,1244.597,40.162z"/>
					<path d="M723.13,39.283c0.382,0.012,0.777,0.023,1.155,0.052c-0.135-0.068-0.359-0.181-1.363-0.166
						c-0.894,0.014-1.308-0.058-1.684-0.141c-0.188,0.037-0.26,0.06-0.212,0.105c0.024,0.003,0.03,0.007,0.036,0.012
						C721.332,39.212,721.897,39.237,723.13,39.283z"/>
					<path d="M1262.056,36.71c-0.092-0.005-0.24-0.011-0.367-0.063c-0.209-0.086-0.221-0.354,0.324-0.351
						c0,0.146,0.066,0.27,0.373,0.391C1262.28,36.699,1262.175,36.71,1262.056,36.71z"/>
					<polygon points="750.155,40.65 750.026,40.467 750.862,40.472 750.991,40.656 "/>
					<path d="M753.644,37.135c-0.095-0.005-0.224-0.005-0.343-0.04c-0.152-0.045-0.245-0.129-0.329-0.215
						c0.966-0.025,1.551,0.043,1.731,0.201C754.351,37.104,754.016,37.135,753.644,37.135z"/>
					<path d="M757.912,43.568c0.118,0.172,0.111,0.249-0.241,0.278c-0.419-0.147-0.501-0.239-0.55-0.405
						c-0.034-0.135-0.093-0.195-0.382-0.279c0.524,0.039,1.213,0.09,1.739,0.128C757.746,43.264,757.775,43.385,757.912,43.568z"/>
					<polygon points="772.353,40.409 773.188,40.414 773.307,40.602 772.469,40.593 "/>
					<path d="M773.154,42.206c-0.054-0.005-0.095-0.014-0.129-0.021c-0.154-0.055-0.262-0.182-0.203-0.245
						c0.043-0.037,0.153-0.074,0.52,0.058c0.012,0.003,0.023,0.009,0.042,0.015c0.005,0.006,0.022,0.008,0.034,0.014
						C773.342,42.08,773.236,42.148,773.154,42.206z"/>
					<polygon points="772.712,41.546 773.813,41.373 773.608,41.739 "/>
					<path d="M775.83,44.323c-0.138-0.003-0.273-0.003-0.389-0.015c-0.024,0-0.059-0.005-0.078-0.005
						c-0.042-0.053-0.089-0.13-0.135-0.185c0.283-0.141,0.672-0.08,0.824-0.046C776.353,44.137,776.736,44.325,775.83,44.323z"/>
					<path d="M775.109,43.938c-0.118-0.181,0.154-0.243,0.638-0.283c0.188,0.089,0.452,0.207,0.649,0.296L775.109,43.938z
						"/>
					<path d="M781.988,43.246c0.831,0.178,0.707,0.487-0.006,0.565c-0.184-0.052-0.366-0.103-0.524-0.16
						C780.745,43.396,781.322,43.304,781.988,43.246z"/>
					<path d="M783.315,44.936c-0.047,0.005-0.108,0.011-0.16,0.014c0.146-0.152-0.064-0.262-0.76-0.506
						c-0.707-0.244-0.866-0.358,0.502-0.425c-0.383,0.136-0.208,0.256,0.359,0.49C783.687,44.693,784.063,44.849,783.315,44.936z"/>
					<path d="M713.492,44.137c-0.016,0-0.04,0-0.059,0.003c-0.088-0.09-0.754-0.224-0.217-0.276
						c0.112,0.072,0.418,0.118,0.494,0.192C713.729,44.076,713.765,44.107,713.492,44.137z"/>
					<path d="M715.545,43.487c-0.12,0-0.294-0.006-0.579-0.061c-0.036-0.006-0.071-0.014-0.106-0.02
						c0.454-0.279,0.454-0.279-0.435-0.569c1.12-0.008,1.12-0.008,0.524-0.378c0.359,0.005,0.836,0.011,1.197,0.011
						c0.241,0.322,0.483,0.638,0.73,0.956C716.417,43.427,716.003,43.484,715.545,43.487z"/>
					<path d="M719.742,43.82c-0.06,0-0.107,0-0.166,0c-0.012,0-0.012,0-0.023,0c0.236-0.261,0.141-0.379-0.507-0.66
						c1.12,0.072,1.731,0.247,2.075,0.583C720.625,43.743,720.225,43.82,719.742,43.82z"/>
					<path d="M1.714,51.391c-0.224-0.09-0.375-0.185-0.599-0.271c0.044,0.037,0.103,0.089,0.147,0.126
						c-0.083,0-0.38-0.137-0.858-0.401C0.359,50.816,0.3,50.781,0.25,50.753c0.249,0.028,1.56,0.591,1.498,0.646
						C1.734,51.396,1.723,51.391,1.714,51.391z"/>
					<path d="M2.571,51.643c-0.144-0.051-0.188-0.118-0.372-0.166c-0.034,0.028,0.078,0.052,0.019,0.08
						C2.058,51.534,2.067,51.493,2,51.459c-0.115-0.063-0.384-0.213-0.313-0.229c0.123-0.025,0.903,0.379,0.89,0.413H2.571z"/>
					<polygon points="1889.911,31.576 1890.507,31.634 1890.274,31.812 1889.683,31.757 "/>
					<path d="M1889.595,31.921c0.016,0,0.037,0,0.055,0.003c0.039,0.006,0.078,0.048,0.078,0.052
						c-0.01,0.037-0.025,0.101,0.381,0.203c0.424,0.104,1.041,0.161,1.4,0.282c0.127,0.04,0.092,0.058-0.029,0.077
						c-1.076-0.146-1.076-0.146-2.213-0.207C1889.229,32.233,1889.401,31.97,1889.595,31.921z"/>
					<path d="M1871.187,30.931c1.686,0.037,2.861,0.318,4.316,0.467c0.756,0.078,0.789,0.07,1.131,0.023
						c0.236-0.034,3.645-0.014,3.664-0.014c0.902,0.061,1.551,0.218,2.365,0.315c0.523-0.21,1.445-0.336,2.098-0.52
						c0.674,0.046,0.996,0.2,1.604,0.261c0.148,0.015,0.295,0.025,0.459,0.025c-0.453,0.377-0.828,0.5-2.002,0.747
						c-0.447-0.092-0.744-0.121-0.844-0.126c-0.723-0.052-0.984-0.052-1.998-0.034c-1.166,0.022-1.326-0.018-1.496-0.058
						c-0.326-0.081-0.652-0.161-1.115-0.184c-0.359-0.018-0.813,0.065-1.166,0.092c-0.682-0.086-0.828-0.302-1.668-0.351
						c-1.008,0.17-1.008,0.17-1.518,0.063c-0.006,0-0.016,0.003-0.021,0.006c0.016-0.006,0.039-0.011,0.012-0.017
						c-0.006-0.003-0.012,0-0.018,0c-0.02,0-0.023,0.003-0.02,0.006c0,0.005,0.014,0.005,0.025,0.011
						c-0.123,0.023-0.254,0.041-0.389,0.058c-0.189-0.017-0.453-0.04-0.648-0.058c-0.543,0.044-0.709,0.058-0.867,0.052
						c-0.08,0-0.1-0.034-0.129-0.052c-0.23-0.16-0.658-0.194-0.75-0.203c-0.734-0.052-1.436,0.203-2.15,0.037
						c-0.41-0.098-0.588-0.133-0.871-0.149c-0.584-0.044-1.148,0.213-1.588,0.068c-0.008-0.005-0.023-0.008-0.039-0.017
						C1867.888,31.261,1868.872,30.879,1871.187,30.931z"/>
					<path d="M1861.403,30.64c0.525,0.063,0.99,0.149,1.539,0.202c0.385,0.034,0.611,0.037,1.031,0.024
						c-0.383,0.235-0.891,0.309-1.697,0.248c-0.207-0.121-0.785-0.19-0.924-0.319C1861.292,30.737,1861.337,30.695,1861.403,30.64z"/>
					<path d="M1859.79,30.496c-0.029,0.069,0.074,0.104,0.48,0.161c0.449,0.055,0.699,0.096,0.5,0.227
						c-0.523-0.095-0.875-0.049-1.096-0.008c-0.506,0.097-0.896,0.051-1.037,0.034c-0.006,0-0.018-0.003-0.018-0.003
						C1858.979,30.767,1859.394,30.635,1859.79,30.496z"/>
					<path d="M1857.36,29.876c-0.1,0.081-0.23,0.187-0.33,0.27c-0.107,0.003-0.225,0.006-0.342,0
						c-0.061-0.005-0.201-0.023-0.25-0.086c-0.012-0.011-0.012-0.028-0.012-0.04C1856.438,29.913,1856.853,29.755,1857.36,29.876z"/>
					<path d="M1855.532,30.227c0.242,0.149,0.146,0.322-0.547,0.265c-0.137-0.013-0.262-0.023-0.371-0.041
						c-0.025-0.006-0.055-0.012-0.07-0.012C1854.733,30.292,1855.058,30.221,1855.532,30.227z"/>
					<path d="M1840.319,29.836c0.078,0.031-0.105,0.087-0.482,0.063c-0.111-0.012-0.406-0.04-0.57-0.149
						c-0.006-0.006-0.012-0.012-0.021-0.018C1839.833,29.761,1840.231,29.799,1840.319,29.836z"/>
					<path d="M1728.3,37.641c0.404,0.028,0.945,0.063,1.346,0.092c-0.387,0.216,0.047,0.448-0.271,0.661
						c-0.619-0.043-1.156-0.081-1.334-0.265C1727.868,37.957,1728.165,37.732,1728.3,37.641z"/>
					<path d="M1725.216,37.802c0.836,0.029,1.529,0.108,1.002,0.465c-0.217-0.022-0.848-0.08-1.025-0.252
						C1725.106,37.925,1725.181,37.842,1725.216,37.802z"/>
					<path d="M1723.788,38.095c0.422,0.029,0.99,0.069,1.41,0.098c-0.006,0.045-0.184,0.232-0.42,0.459
						c-0.152-0.006-0.307-0.006-0.447-0.014c-0.189-0.015-0.611-0.049-0.736-0.176C1723.476,38.336,1723.681,38.175,1723.788,38.095z"/>
					<path d="M1718.896,38.002c1.426-0.014,2.926,0.106,4.002,0.313c-0.516,0.233-1.514,0.503-3.354,0.457
						c-0.625-0.08-0.813-0.271-1.584-0.311c-0.303-0.018-0.627,0-0.904-0.039c-0.047-0.01-0.117-0.018-0.139-0.029
						c-0.025-0.007-0.025-0.018-0.039-0.023C1716.856,38.33,1717.12,38.02,1718.896,38.002z"/>
					<path d="M1713.681,38.009c0.105-0.052,0.375-0.188,1.289-0.018c0.258,0.047,0.258,0.047,0.879,0.416
						c-0.342,0.026-0.627,0.084-0.982,0.104c-0.307,0.018-0.463,0.015-0.727-0.003c-0.158-0.009-0.313-0.022-0.455-0.046
						c-0.021,0-0.047-0.002-0.07-0.005C1713.663,38.308,1713.378,38.151,1713.681,38.009z"/>
					<path d="M1711.8,38.031c0.088,0.115,0.352,0.225,0.391,0.345c0.021,0.106-0.156,0.207-0.232,0.247
						c-0.463-0.029-0.732-0.132-1.168-0.173c-0.027,0-0.076-0.006-0.111-0.006C1710.868,38.146,1711.083,38.012,1711.8,38.031z"/>
					<path d="M1707.733,38.049c-0.338,0.034-0.566,0.04-0.996,0.015c-0.818-0.066-1.104-0.198-1.197-0.268
						c-0.119-0.086-0.061-0.152-0.018-0.195C1706.647,37.478,1708.063,37.71,1707.733,38.049z"/>
					<path d="M1425.616,37.865c-0.613-0.146-0.613-0.146-0.605-0.179c0.281,0.046,0.617,0.043,0.924,0.055
						c0.732,0.012,1.074,0.02,1.037,0.121c-0.422,0.055-0.686,0.155-1.143,0.204c-0.342,0.034-0.447-0.021-0.482-0.041
						c-0.018-0.011-0.037-0.026-0.049-0.034C1425.772,37.974,1425.983,37.948,1425.616,37.865z"/>
					<path d="M1431.771,37.744c-0.371-0.021-0.617-0.075-0.695-0.109c-0.16-0.065,0.096-0.105,0.768-0.114
						C1432.382,37.732,1432.03,37.75,1431.771,37.744z"/>
					<polygon points="1417.071,37.555 1417.813,37.587 1417.765,37.768 1417.024,37.736 "/>
					<path d="M1413.44,37.498c0.297,0.039,0.518,0.063,0.859,0.079c0.396,0.013,0.803-0.005,1.203,0.023
						c0.318,0.023,0.494,0.058,0.705,0.104c-0.789,0.018-0.93,0.098-0.459,0.27c-0.729-0.063-1.148,0-1.461,0.046
						c-0.41,0.058-0.768,0.109-1.658,0.016c-0.031-0.004-0.074-0.01-0.096-0.013c-0.107-0.092-0.254-0.215-0.363-0.304
						c0.363-0.05,0.822-0.003,1.164-0.066C1413.511,37.621,1413.47,37.543,1413.44,37.498z"/>
					<path d="M1412.534,36.516c-0.217,0.003-0.426,0-0.627-0.012c-0.383-0.017-0.846-0.058-1.131-0.213
						c-0.072-0.04-0.119-0.086-0.166-0.129C1411.577,36.005,1412.638,36.246,1412.534,36.516z"/>
					<path d="M1405.39,37.641c-0.119,0.023-0.342,0.061-0.582,0.052c-0.102-0.006-0.201-0.014-0.279-0.052
						c-0.041-0.022-0.082-0.046-0.059-0.068C1404.522,37.522,1404.847,37.446,1405.39,37.641z"/>
					<path d="M1348.181,38.829c-0.195-0.008-0.766-0.028-1.016-0.146c-0.049-0.028-0.08-0.06-0.092-0.092
						c0.043-0.008,0.082-0.02,0.129-0.025c0.578-0.083,1.633-0.017,1.428,0.264C1348.478,38.824,1348.331,38.832,1348.181,38.829z"/>
					<path d="M1327.063,36.464l-0.031,0.184c-0.129,0.021-0.201,0.023-0.387,0.018c-0.074-0.007-0.24-0.013-0.381-0.087
						c-0.057-0.025-0.102-0.052-0.109-0.083c0.008-0.003,0.008-0.123,0.359-0.136C1326.61,36.354,1326.61,36.354,1327.063,36.464z"/>
					<path d="M1312.075,38.482c-0.359-0.015-0.561-0.025-0.863-0.08c-0.209-0.035-0.303-0.052-0.707,0.008
						c-0.031,0.003-0.068,0.013-0.094,0.018c-0.072-0.041-0.23-0.138,0.236-0.178C1311.126,38.209,1312.476,38.273,1312.075,38.482z"/>
					<path d="M1306.644,37.54c-0.068-0.003-0.146-0.005-0.221-0.008c-0.012,0-0.02,0-0.031,0
						c0.025-0.139,0.277-0.21,0.861-0.244c0.111,0.057,0.258,0.138,0.373,0.194C1307.276,37.485,1307.005,37.549,1306.644,37.54z"/>
					<path d="M1307.157,38.135l-0.416,0.348c-0.145-0.096-0.631-0.112-0.832-0.195c-0.156-0.061-0.072-0.129,0.033-0.192
						C1306.312,38.106,1306.79,38.12,1307.157,38.135z"/>
					<path d="M1305.71,36.765c-0.098-0.025-0.178-0.052-0.25-0.08c-0.295-0.132-0.262-0.158,0.324-0.571
						c0.797,0.065,1.232,0.104,1.568,0.178C1307.606,36.349,1308.62,36.76,1305.71,36.765z"/>
					<path d="M1305.183,37.399c-0.623-0.023-1.037-0.034-1.189-0.105c-0.09-0.044-0.039-0.089-0.02-0.118
						c0.256,0.012,0.588,0.023,0.848,0.032L1305.183,37.399z"/>
					<polygon points="1296.171,37.189 1297.009,37.219 1296.991,37.417 1296.153,37.389 "/>
					<path d="M1295.845,36.618c-0.076-0.022-0.145-0.045-0.205-0.068c-0.207-0.098-0.33-0.293,0.627-0.282
						C1296.765,36.412,1296.813,36.63,1295.845,36.618z"/>
					<path d="M1297.317,38.077c0.012,0.006,0.027,0.012,0.043,0.015c0.424,0.127,0.527,0.287-0.27,0.267
						c-0.164-0.006-0.33-0.011-0.484-0.025c-0.021-0.003-0.063-0.003-0.088-0.009C1296.476,38.187,1296.714,38.111,1297.317,38.077z"/>
					<path d="M1294.743,37.328c-0.281-0.009-0.447-0.04-0.504-0.063c-0.152-0.06,0.205-0.112,0.32-0.123
						c0.205,0.028,0.412,0.061,0.564,0.103C1295.347,37.313,1295.101,37.337,1294.743,37.328z"/>
					<path d="M1293.644,38.049c0.359,0.152-0.219,0.188-0.666,0.175c-0.271-0.012-0.447-0.031-0.531-0.065
						c-0.049-0.018-0.049-0.038-0.035-0.058C1292.839,38.106,1293.202,38.035,1293.644,38.049z"/>
					<path d="M1290.95,36.458c-0.025,0.074-0.111,0.111-0.277,0.115c-0.385-0.023-0.725-0.179-0.82-0.225
						c-0.07-0.034-0.137-0.068-0.143-0.103C1289.716,36.165,1289.948,36.223,1290.95,36.458z"/>
					<path d="M1290.692,37.059c0.793-0.055,1.316-0.066,2.197,0.025c-0.078,0.315-0.891,0.305-3.32,0.27
						c-0.309-0.101-0.762-0.172-1.014-0.287c-0.092-0.04-0.141-0.086-0.178-0.132C1289.288,37.13,1289.776,37.121,1290.692,37.059z"/>
					<path d="M1291.567,38.164c-0.336,0.063-0.549,0.071-0.654,0.068c-0.049-0.003-0.164-0.009-0.248-0.043
						c-0.061-0.022-0.082-0.049-0.061-0.078C1290.644,38.072,1290.962,37.971,1291.567,38.164z"/>
					<path d="M1279.47,42.635l-0.451-0.209c2.9,0.24,6.105,0.103,8.977,0.378c0.285-0.065,0.213-0.172,0.531-0.229
						c0.123-0.023,0.459-0.087,2.279,0.263c0.365,0.075,0.391,0.136,0.438,0.265c-3.922-0.049-7.867-0.017-11.787-0.108
						c0.043-0.038,0.045-0.099-0.061-0.133c-0.184-0.063-0.523-0.087-0.752-0.138c-0.035-0.012-0.072-0.025-0.107-0.035
						C1278.755,42.611,1278.995,42.62,1279.47,42.635z"/>
					<path d="M1276.196,42.426c0.49,0.137,1.303,0.2,1.641,0.372c0.246,0.124-0.207,0.199-0.432,0.235
						c0.117-0.131,0.033-0.188-0.695-0.146c-0.908,0.049-1.191-0.05-1.285-0.084C1275.294,42.759,1275.374,42.494,1276.196,42.426z"/>
					<path d="M1274.14,42.27c0.236,0.213,0.41,0.489-0.648,0.463c-0.566-0.021-1.014-0.109-1.168-0.164
						c-0.023-0.006-0.045-0.014-0.051-0.022c-0.092-0.041-0.072-0.104,1.031-0.018C1273.323,42.379,1273.552,42.308,1274.14,42.27z"/>
					<path d="M1270.872,42.609c-0.104,0.16-1.424,0.134-1.984,0.114c-0.047,0-4.203-0.175-4.861-0.351
						c-0.391-0.109,0.045-0.293,0.885-0.299c1.436-0.017,2.604,0.189,3.959,0.242c0.578,0.014,1.182-0.029,1.721,0.052
						C1270.827,42.399,1270.989,42.426,1270.872,42.609z"/>
					<path d="M1258.065,38.457c2.137,0.105,2.137,0.105,3.273-0.07c2.229,0.294,4.879,0.199,7.248,0.359
						c-2.619,0.066-5.232,0.127-7.863,0.106c-0.111,0.081-0.264,0.187-0.379,0.268c-2.346-0.164-2.346-0.164-3.256-0.472
						C1257.378,38.591,1257.767,38.515,1258.065,38.457z"/>
					<path d="M1229.251,39.186c2.998,0.086,3.607-0.293,4.449-0.827c0.076,0.173,0.307,0.402,0.537,0.565
						c0.482-0.171,1.125-0.401,1.596-0.573c1.014,0.055,1.014,0.055,3.35-0.113c1.736,0.346,1.779,0.386,2.086,0.713
						c0.455-0.149,0.455-0.149,3.318-0.557c2.014,0.227,2.227,0.252,2.328,0.74c4.604,0.741,10.746,0.167,15.352,0.913
						c1.936-0.166,3.885,0.081,5.814-0.018c-0.094,0.107-0.225,0.251-0.318,0.356c-0.402,0.023-0.934,0.052-1.32,0.078
						c-0.014,0.08-0.014,0.189-0.023,0.267c2.004,0.373,2.004,0.373,2.238,0.672c-3.83-0.074-4.926-0.247-5.955-0.601
						c-0.646,0.251-0.646,0.563-1.455,0.802c-5.268-0.579-11.232-0.603-16.66-1.062c-0.125,0.074-0.297,0.177-0.42,0.252
						c-0.158-0.086-0.355-0.189-0.512-0.272c-1.592,0.123-3.326,0.065-4.895,0.209c-0.486,0.635-0.486,0.635,0.191,1.071
						c4.631,0.204,5.01,0.192,6.424,0.149c0.424,0.101,0.967,0.233,1.387,0.336c-0.162,0.075-0.373,0.173-0.525,0.247
						c-4.693-0.258-4.693-0.258-6.99-0.104c2.15,0.265,2.15,0.265,3.322,0.655c-0.301,0.037-0.707,0.086-1.002,0.12
						c43.904,1.332,69.951,2.148,97.232,3.139c-0.063-0.003-0.139-0.003-0.201-0.006c-29.615-0.947-69.48-1.736-98.705-3.179
						c-0.678-0.069-2.088-0.207-3.936-0.643c-0.932,0.071-1.664,0.235-2.664,0.27c-0.625,0.026-1.223-0.075-1.475-0.115
						c0.613-0.071,0.693-0.089,0.73-0.299c0.029-0.212,0.254-0.235,0.926-0.304c-0.371,0.017-0.857,0.04-1.232,0.058
						c0.195-0.371-0.729-0.696-0.879-1.052c0.395-0.006,1.008-0.017,1.264-0.086c0.867-0.242-0.637-0.735-2.523-0.686
						c-0.09-0.325-0.006-0.445,0.371-0.55c-0.26-0.068-0.449-0.097-1.055-0.154l-0.182-0.016l0.131,3.271
						c-0.111-0.987-0.256-2.303-0.369-3.29c-0.264-0.026-0.611-0.063-0.879-0.087c0.055-0.06,0.137-0.141,0.197-0.204
						c0.271-0.025,0.637-0.063,0.908-0.089c-0.025-0.123-0.014-0.262,0.018-0.401L1229.251,39.186z"/>
					<path d="M1261.845,42.447c-0.27,0.053-0.604,0.07-1.082,0.058c-0.156-0.005-0.627-0.022-0.863-0.12
						c-0.059-0.029-0.096-0.061-0.119-0.092C1260.331,42.195,1261.737,42.212,1261.845,42.447z"/>
					<path d="M1248.7,42.89c-0.039,0.109-0.158,0.438-1.992,0.394c-0.201-0.008-0.627-0.022-1.145-0.095
						c-0.047-0.003-0.105-0.011-0.15-0.017C1245.917,42.937,1246.966,42.919,1248.7,42.89z"/>
					<polygon points="782.385,51.022 783.22,51.028 783.355,51.209 782.525,51.201 "/>
					<polygon points="784.793,51.511 783.739,51.212 785.012,51.226 "/>
					<path d="M892.957,48.231c-0.213,0.167-0.259,0.301-0.302,0.626c-0.028,0.256-0.064,0.545-0.507,0.735
						c-0.023,0.011-0.064,0.023-0.088,0.031C891.017,49.153,890.564,48.269,892.957,48.231z"/>
					<path d="M891.753,47.382c0.224-0.089,0.926-0.096,1.179,0.115c-0.364,0.021-0.849,0.051-1.208,0.073
						C891.694,47.539,891.59,47.45,891.753,47.382z"/>
					<path d="M892.403,50.833c0.007,0.109,0.111,0.172,0.341,0.276c0.071,0.028,0.178,0.06,0.166,0.1
						c-0.011,0.05-0.283,0.066-0.619,0.087c-0.1-0.021-0.194-0.044-0.277-0.073C891.636,51.094,891.436,50.845,892.403,50.833z"/>
					<path d="M892.579,49.725c0.141,0.109,0.26,0.232-0.047,0.238c-0.276-0.009-0.454-0.063-0.5-0.077
						C891.954,49.86,891.624,49.73,892.579,49.725z"/>
					<path d="M1182.894,44.872l-0.836,0.065c0.063-0.222,0.08-0.301,0.807-0.25
						C1182.874,44.745,1182.88,44.814,1182.894,44.872z"/>
					<path d="M1180.63,44.171c-0.254-0.115-0.701-0.197-0.984-0.31c-0.248-0.092-0.113-0.136,0.221-0.179
						c0.344,0.104,0.154,0.287,0.947,0.322c0.109,0.003,0.217-0.007,0.33-0.007c-0.117,0.109-0.283,0.248-0.408,0.351
						C1180.765,44.32,1180.825,44.251,1180.63,44.171z"/>
					<path d="M1227.351,47.557c-0.398-0.018-0.799-0.035-1.211-0.049c-0.029,0-0.072,0-0.102,0
						c-0.043-0.256,0.275-0.267,1.361-0.178C1227.368,47.404,1227.376,47.479,1227.351,47.557z"/>
					<path d="M1224.237,48.157c-0.057-0.003-0.092-0.018-0.115-0.023c-0.051-0.023-0.082-0.04-0.094-0.061
						c-0.029-0.095,0.141-0.246,0.318-0.215C1224.581,47.903,1224.499,48.145,1224.237,48.157z"/>
					<path d="M1221.86,46.927c0.424,0,0.77-0.085,1.223-0.054c0.078,0.52,0.086,0.54-0.328,0.629
						c-1.426-0.038-1.889-0.167-1.957-0.19c-0.236-0.079,0.148-0.108,0.318-0.12c0.111,0.029,0.381,0.109,0.66,0.115
						C1222.177,47.314,1222.478,47.141,1221.86,46.927z"/>
					<path d="M1212.958,47.318c-0.104,0.006-0.502,0.022-0.801-0.08c-0.023-0.009-0.047-0.023-0.072-0.029
						c0.813-0.097,1.158-0.31,1.959-0.408c0-0.028-0.006-0.063-0.012-0.092c1.52,0.092,2.145,0.251,2.557,0.356
						c-0.033-0.299,0.377-0.281,3.006-0.187c0.223,0.006,0.436,0,0.65,0.003c0.016,0.184,0.033,0.367,0.059,0.551
						c-2.6-0.098-3.023-0.132-5.779-0.333C1214.009,47.175,1213.585,47.283,1212.958,47.318z"/>
					<polygon points="1214.173,47.909 1212.946,47.875 1212.923,47.694 1214.149,47.729 "/>
					<path d="M1234.448,42.999c0.066-0.095,0.146-0.109,0.293-0.138c0.109,0.049,0.184,0.101,0.254,0.155
						c-0.135,0.086-0.322,0.195-0.457,0.278C1234.509,43.206,1234.472,43.089,1234.448,42.999z"/>
					<path d="M1261.485,45.032c0.184,0.018,0.398,0.012,0.795-0.011c1.752-0.109,1.676,0.079,1.648,0.174
						c-0.373-0.068-0.646-0.079-1.227-0.054c-0.344,0.017-0.711,0.034-1.117-0.08C1261.548,45.053,1261.517,45.038,1261.485,45.032z"/>
					<path d="M1270.438,48.501c-1.025,0.058-1.24-0.028-1.438-0.115c-0.566-0.229-0.289-0.511,0.67-0.7
						c-0.025,0.077-0.02,0.155,0.203,0.17c0.646,0.009,1.367-0.153,1.943,0.009c0.307,0.089,0.313,0.109,0.307,0.629
						C1271.493,48.44,1271.146,48.461,1270.438,48.501z"/>
					<path d="M1278.456,46.035c-1.088-0.044-1.555-0.141-1.746-0.214c-0.143-0.054-0.154-0.089-0.164-0.134
						c1.334-0.075,2.666-0.029,4.09,0.025C1280.776,46.063,1279.007,46.049,1278.456,46.035z"/>
					<path d="M1280.187,46.91c-0.17-0.114-0.338-0.117-0.711-0.075c-0.295,0.032-0.598,0.055-0.842-0.042
						c-0.006,0-0.275-0.216,0.787-0.278c0.049,0.034,0.189,0.063,0.572,0.135C1280.704,46.778,1280.917,46.854,1280.187,46.91z"/>
					<path d="M1228.817,38.209c0.156,0.248,0.092,0.388-0.713,0.374c-0.152-0.006-0.307-0.012-0.447-0.023
						c-0.021-0.003-0.045-0.006-0.068-0.011c0-0.112,0-0.265-0.006-0.377L1228.817,38.209z"/>
					<path d="M1224.642,37.997c0.658,0.215,0.223,0.229,0,0.227c-0.383-0.015-0.674-0.065-0.754-0.097
						C1223.687,38.06,1223.944,38.015,1224.642,37.997z"/>
					<path d="M1071.159,38.887c-0.07-0.017-0.129-0.031-0.189-0.052c-0.113-0.04-0.119-0.074-0.006-0.097
						c0.262-0.058,1.461-0.04,1.434,0.068C1072.022,38.829,1071.526,38.864,1071.159,38.887z"/>
					<path d="M1001.851,41.099c-0.207-0.227,0.021-0.345,0.734-0.368c-0.006,0.146-0.086,0.305-0.684,0.365
						C1001.89,41.096,1001.868,41.099,1001.851,41.099z"/>
					<path d="M1018.407,42.185c-0.52-0.087-0.613-0.104-0.543-0.256c0.695-0.066,1.285-0.199,2.119-0.184
						c0.652,0.011,1.041,0.148,1.299,0.243c-0.824,0.061-1.402,0.132-1.77,0.31c-0.51,0.245-0.307,0.516-0.461,0.771
						c-0.504-0.021-0.896-0.04-1.205-0.108c-0.324-0.075-0.361-0.17-0.385-0.299c-0.033-0.207-0.105-0.259-0.34-0.365
						c0.148-0.012,0.34-0.018,0.783,0.037c0.207,0.029,0.359,0.074,0.594,0.093c0.146,0.008,0.191-0.013,0.232-0.036
						C1018.946,42.284,1018.536,42.206,1018.407,42.185z"/>
					<path d="M1021.87,39.763c0.336,0.153,0.545,0.204,1.313,0.279c-0.332,0.074-0.508,0.098-0.781,0.095
						c-0.252-0.016-0.393-0.037-0.789-0.21c-0.141-0.061-0.564-0.247-1.484-0.213c-0.02,0.003-0.037,0.003-0.047,0.003
						c-0.602-0.738-0.602-0.738,0.176-0.942c-0.201-0.082-0.219-0.089-0.641-0.131c-0.826-0.087-0.85-0.118-0.82-0.273
						c0.494-0.094,0.908-0.089,1.625,0.023c0.793,0.121,0.961,0.126,1.436,0.132c-0.025,0.339-1.191,0.586-1.398,0.907
						C1021.247,39.533,1021.495,39.594,1021.87,39.763z"/>
					<path d="M1019.833,39.835c0.211,0.071,0.43,0.081,0.643,0.086c0.184,0.003,0.361,0.003,0.527-0.005
						c-0.109,0.344,0.787,0.683,0.211,1.033c-0.119,0.077-0.498,0.311-2.301,0.253c-0.012,0-0.023,0-0.029,0
						c-0.254-0.259-0.254-0.374-0.217-0.66c0.051-0.356-0.027-0.534-0.273-0.856C1019.126,39.651,1019.433,39.702,1019.833,39.835z"/>
					<path d="M1018.782,43.441c-0.131,0.022-0.193,0.029-0.395,0.022c-0.066,0-0.238-0.005-0.428-0.074
						c-0.357-0.133-0.055-0.243,0.324-0.241c0.129,0.032,0.299,0.081,0.428,0.108L1018.782,43.441z"/>
					<path d="M1017.368,40.3c-0.023,0.063-0.225,0.096-0.293,0.106c-0.273,0.043-0.615,0.049-0.896,0.089
						c-0.02,0-0.043,0.006-0.057,0.006c-0.049-0.195-0.756-0.322-1.023-0.488c0.236-0.005,0.736-0.012,1.27,0.023
						C1017.452,40.11,1017.429,40.174,1017.368,40.3z"/>
					<path d="M1016.644,40.875c-0.123,0.021-0.211,0.025-0.393,0.021c-0.072-0.002-0.25-0.005-0.424-0.076
						c-0.084-0.032-0.16-0.061-0.16-0.095c-0.008-0.244,0.688-0.087,0.918-0.034L1016.644,40.875z"/>
					<polygon points="1015.14,43.852 1014.269,43.838 1014.194,43.64 1015.071,43.654 "/>
					<path d="M1014.704,43.936c0.137,0.264-0.146,0.442-0.965,0.617c-0.018,0.006-0.047,0.009-0.066,0.014
						C1013.71,43.995,1013.71,43.936,1014.704,43.936z"/>
					<path d="M1030.767,39.995c0.545,0.021,0.688,0.023,1.184,0.09c0.531,0.065,0.934,0.175,1.449,0.246
						c-0.166,0.342,0.33,0.688,0.018,1.034c-0.195,0.212-0.885,0.296-1.252,0.342l-0.904-0.109
						C1031.142,41.063,1030.876,40.529,1030.767,39.995z"/>
					<path d="M1164.694,49.488c0.627,0.006,1.371,0.058,1.359,0.302c-0.111,0.01-0.213,0.01-0.324,0.01
						c-0.123-0.006-0.354-0.013-0.537-0.087C1165.003,49.644,1164.966,49.552,1164.694,49.488z"/>
					<polygon points="1036.931,37.761 1036.585,37.939 1035.651,37.739 "/>
					<path d="M1019.396,37.448c2.088-0.151,2.088-0.151,2.973-0.146c0.061,0.139,0.398,0.253,0.514,0.391
						c-0.67,0.068-0.787,0.081-1.057,0.419c0.43,0.013,0.93,0.018,1.381,0.029c-0.838,0.04-1.643,0.092-2.355,0.184
						c-0.117-0.068-0.264-0.16-0.375-0.235C1019.608,37.63,1019.608,37.63,1019.396,37.448z"/>
					<path d="M892.744,44.868c0.041,0.01,0.095,0.021,0.129,0.032c0.526,0.126,0.377,0.2-0.07,0.195
						c-0.224-0.003-0.335-0.026-0.372-0.04C892.272,45.009,892.379,44.946,892.744,44.868z"/>
					<path d="M982.11,47.422c1.496,0.025,3.055,0.052,4.58,0.08c-3.355-0.052-6.742-0.104-10.16-0.151
						C978.392,47.372,980.192,47.398,982.11,47.422z"/>
					<path d="M792.203,51.678c-1.473-0.092-1.473-0.092-1.686-0.156c-0.16-0.054-0.183-0.114-0.2-0.149
						C791.525,51.367,792.073,51.453,792.203,51.678z"/>
					<path d="M789.839,50.253c0.549,0.187,1.067,0.362,0.377,0.38c-0.028,0.002-0.065,0-0.087,0.002
						c-0.025-0.015-0.055-0.022-0.083-0.034c-0.012-0.004-0.024-0.009-0.036-0.012c-0.006-0.003-0.025-0.009-0.035-0.014
						c-0.024-0.007-0.048-0.018-0.071-0.023c-0.018-0.006-0.023-0.012-0.048-0.018C789.338,50.345,789.327,50.264,789.839,50.253z"/>
					<path d="M788.915,49.038c-0.584-0.003-0.879-0.008-1.097-0.065c-0.224-0.063-0.2-0.142-0.166-0.311
						c0.04-0.185,0.083-0.355-1.208-0.298c-0.029-0.038-0.076-0.094-0.071-0.128c0.055-0.204,1.067-0.151,1.08-0.149
						c0.507,0.093,0.642,0.248,0.813,0.498C788.429,48.814,788.537,48.936,788.915,49.038z"/>
					<path d="M785.625,46.101c0.671,0.534,0.459,1.125,1.927,1.611c-0.5,0.238-0.676,0.313-1.219,0.333
						c-0.107-0.003-0.295-0.009-0.531-0.049c-0.012-0.003-0.695-0.155,0.19-0.204c0.541-0.029,0.518-0.043,0.218-0.224
						c-1.48-0.88-1.48-0.88-1.551-0.968c-0.036-0.052-0.06-0.109-0.06-0.161C784.576,46.188,785.341,46.124,785.625,46.101z"/>
					<path d="M783.539,50.385c0.07,0.021,0.14,0.041,0.205,0.063c0.019,0.01,0.043,0.019,0.064,0.023
						c0.343,0.133,0.425,0.235,0.461,0.374c-0.313-0.006-1.145-0.015-1.602-0.154c-0.355-0.115-0.355-0.259-0.343-0.316
						C782.683,50.374,783.173,50.379,783.539,50.385z"/>
					<path d="M760.15,49.3c-0.046,0.08-0.11,0.188-0.165,0.27l-0.447-0.095C759.426,49.325,759.62,49.271,760.15,49.3z"/>
					<path d="M757.416,47.109c0.071,0.034,0.183,0.065,0.171,0.108c-0.019,0.049-0.366,0.072-0.571,0.083
						c-0.106-0.018-0.19-0.046-0.273-0.071c-0.021-0.009-0.058-0.021-0.081-0.026c-0.036-0.018-0.932-0.358,0.448-0.278
						C757.175,46.987,757.285,47.049,757.416,47.109z"/>
					<path d="M756.433,45.762c0.016,0.006,0.029,0.012,0.041,0.018c0.119,0.052,0.111,0.08,0.036,0.167
						c-0.114,0.108-0.12,0.184,0.099,0.32c-0.323,0-0.595,0.047-0.914,0.052c-0.07-0.002-0.141-0.011-0.188-0.022
						c-0.047-0.012-0.072-0.029-0.106-0.04c0.112-0.047,0.059-0.092-0.154-0.207c-0.129-0.081-0.281-0.17-0.224-0.232
						C755.07,45.75,755.913,45.604,756.433,45.762z"/>
					<polygon points="751.604,47.065 751.746,47.249 750.544,47.238 750.401,47.055 "/>
					<path d="M748.988,45.438c0.342-0.161,0.937-0.075,0.943-0.072c0.235,0.04,0.2,0.282-0.795,0.282
						c-0.153-0.007-0.408-0.012-0.609-0.069c-0.036-0.012-0.082-0.035-0.116-0.046C748.734,45.532,748.846,45.504,748.988,45.438z"/>
					<path d="M231.698,43.573c-0.377,0.029-0.672,0.018-1.886-0.092c-0.517-0.052-1.032-0.095-1.58-0.12
						c-0.519,0.212-1.145,0.224-3.364,0.167c-1.311-0.033-1.716-0.013-2.171,0.057c-0.046-0.221-0.11-0.232-0.216-0.253
						c-0.259,0.018-0.342,0.087-0.614,0.098c-0.164,0.007-0.271-0.006-0.399-0.055c0.755-0.428-2.382-0.376-3.313-0.629
						c-0.059-0.02-0.131-0.045-0.178-0.063c0.991,0.009,6.095,0.08,8.7,0.379c0.167-0.063,0.396-0.155,1.379-0.149
						c1.31,0.006,2.523,0.12,3.784,0.173C232,43.255,232.264,43.531,231.698,43.573z"/>
					<path d="M215.066,42.626c-0.024-0.006-0.049-0.012-0.07-0.015c0.67-0.106,1.896-0.036,2.711,0.244
						C216.773,42.821,215.878,42.774,215.066,42.626z"/>
					<path d="M233.991,40.856c0.019-0.022,0.089-0.086,0.63,0.069c-0.059,0.035-0.142,0.072-0.294,0.069
						c-0.094,0-0.165-0.018-0.218-0.038C234.02,40.929,233.985,40.88,233.991,40.856z"/>
					<path d="M724.397,51.169c-0.312,0.407-0.312,0.407,0.579,0.654c-0.426,0.015-0.844,0.032-1.273,0.032
						c-0.343-0.007-0.621-0.021-1.014-0.149c-0.089-0.028-0.165-0.057-0.243-0.089C723.573,51.574,723.343,51.226,724.397,51.169z"/>
					<path d="M719.021,46.565c0.266-0.051,0.408-0.08,0.583-0.08c0.294,0.006,0.513,0.111,0.631,0.172
						c-0.365,0.035-0.683,0.092-1.108,0.096c-0.094-0.004-0.27-0.01-0.395-0.044c-0.078-0.023-0.099-0.045-0.135-0.068
						C718.75,46.617,718.892,46.595,719.021,46.565z"/>
					<path d="M715.272,44.596c1.108-0.068,3.95,0.477,3.147,0.813c-0.177-0.081-0.447-0.201-1.16,0.058
						c-0.237,0.089-0.425,0.146-0.644,0.076c-0.045-0.014-0.082-0.028-0.116-0.045c0.542-0.035,0.471-0.058-0.024-0.139
						c-0.496-0.08-0.572-0.104-0.59-0.16c0.814,0.029,0.973-0.106,1.049-0.173c-0.849-0.08-1.19-0.29-1.932-0.399
						C715.084,44.613,715.168,44.603,715.272,44.596z"/>
					<path d="M715.227,45.848c-0.224,0.044-0.353,0.052-0.577,0.052c-0.685-0.011-1.338-0.201-2.052-0.431
						c-0.017-0.006-0.042-0.012-0.047-0.015C713.858,45.469,714.766,45.604,715.227,45.848z"/>
					<path d="M711.459,51.597c-0.902-0.068-1.921,0.233-2.692,0.006c-0.03-0.009-0.066-0.023-0.095-0.028
						c0.66-0.038,1.249-0.142,1.968-0.135C711.195,51.447,711.359,51.542,711.459,51.597z"/>
					<polygon points="709.614,50 709.786,50.198 708.602,50.185 708.437,49.989 "/>
					<path d="M710.364,50.851c-0.578-0.029-0.684,0.112-1.02,0.169c-0.414-0.06-0.896-0.135-1.239-0.25
						c-0.472-0.16-0.501-0.33-0.517-0.413C709.367,50.296,709.975,50.561,710.364,50.851z"/>
					<polygon points="695.558,44.906 695.481,44.889 695.469,44.797 "/>
					<path d="M635.906,43.55c-3.41-0.034-6.77-0.068-10.103-0.103C629.109,43.481,632.526,43.516,635.906,43.55z"/>
					<path d="M622.226,43.413c-93.73-0.939-157.455-1.608-208.651-2.24C465.42,41.811,529.933,42.488,622.226,43.413z"/>
					<path d="M393.935,18.163c-0.326,0.08-0.985,0.215-1.852,0.215c-0.207-0.005-0.689-0.018-1.096-0.167
						c-0.159-0.06-0.254-0.126-0.343-0.188C390.991,17.962,393.633,17.792,393.935,18.163z"/>
					<path d="M386.625,19.722c0.047,0.216-0.159,0.294-1.408,0.288c-0.59-0.012-1.173-0.034-1.75-0.058
						c-0.491-0.018-0.95-0.034-1.279-0.028c-0.237,0.008-0.501,0.068-0.909,0.165c-0.359,0.09-0.463,0.104-0.825,0.147
						c-0.271,0.031-0.753,0.028-0.955,0.025c-0.194-0.103-0.589-0.166-0.895-0.246c-0.26-0.069-0.294-0.121-0.366-0.219
						c0.573-0.141,1.12-0.253,2.559-0.264c0.83-0.01,2.122,0.063,2.604,0.086C384.863,19.696,385.475,19.704,386.625,19.722z"/>
					<path d="M377.105,17.729c0.56,0,3.383,0.026,4.208,0.435c-1.237,0.299-2.623,0.445-4.113,0.439
						c-0.573-0.018-1.626-0.046-2.712-0.339c-0.118-0.029-0.248-0.074-0.354-0.106C376.021,17.755,376.139,17.729,377.105,17.729z"/>
					<path d="M359.105,19.429c0.565,0.127,0.772,0.219,0.801,0.351c0.048,0.23-0.636,0.425-0.602,0.655
						c-0.335-0.023-1.037-0.072-1.521-0.253C356.358,19.659,358.822,19.449,359.105,19.429z"/>
					<path d="M355.499,21.956c0.306-0.025,0.583-0.005,0.788,0.012c0.089,0.109,0.219,0.259,0.308,0.371
						c-1.179-0.018-1.532-0.026-1.845-0.13c-0.169-0.061-0.218-0.127-0.241-0.172C354.883,22.037,355.167,21.985,355.499,21.956z"/>
					<path d="M317.681,18.074c0.371-0.181,1.144-0.29,1.531-0.466c1.239,0.115,1.416,0.081,3.597-0.327
						c2.233,0.175,3.979-0.2,5.987-0.272c0.862,0.16,1.363,0.416,2.5,0.505c2.976,0.003,2.976,0.003,4.066-0.112
						c0.638,0.156,1.097,0.225,2.052,0.305c0.082,0.232,0.118,0.331,1.145,0.505c0.859,0.149,0.907,0.173,0.753,0.356
						c-1.91-0.045-3.661,0.144-5.517,0.184c-4.417-0.836-4.417-0.836-6.437-0.93c-2.471-0.121-4.079,0.141-4.998,0.382l-1.498-0.026
						c-0.696,0.092-1.138,0.265-1.974,0.311c-0.266,0.017-0.691,0.02-1.255-0.13C317.287,18.266,317.681,18.074,317.681,18.074z"/>
					<path d="M336.017,20.003c-0.342,0.041-0.571,0.052-1.053,0.047c-0.19-0.003-0.578-0.012-1.263-0.074
						c-0.036-0.004-0.082-0.007-0.119-0.013c-0.07-0.052-0.211-0.154,0.095-0.232C334.162,19.61,335.94,19.653,336.017,20.003z"/>
					<path d="M325.686,21.132l-1.196-0.02c-0.065-0.046-0.23-0.167,0.017-0.238
						C324.784,20.796,325.598,20.851,325.686,21.132z"/>
					<path d="M306.424,17.525c0.896-0.339,3.831-0.528,4.797,0.316c-0.401,0.111-1.114,0.232-3.147,0.203
						c-0.33-0.005-1.097-0.022-1.792-0.092c-0.065-0.005-0.141-0.018-0.194-0.022C306.046,17.839,305.988,17.689,306.424,17.525z"/>
					<path d="M298.359,21.04c-0.96,0.405-3.417,0.21-4.279,0.061c-0.076-0.012-0.164-0.029-0.234-0.04
						c1.2-0.489,5.55-0.104,5.592-0.098c0.471-0.447,2.823-0.392,4.296-0.021c-0.782,0.17-1.272,0.21-2.367,0.199
						C300.363,21.118,299.369,21.063,298.359,21.04z"/>
					<path d="M299.799,21.7c-0.596,0.089-0.992,0.112-1.634,0.102c-0.418-0.01-0.818-0.029-1.23-0.047
						c-0.061-0.003-0.142-0.006-0.203-0.008c0-0.015-0.01-0.029-0.01-0.037C296.687,21.33,298.814,21.477,299.799,21.7z"/>
					<path d="M292.384,18.887c0.022-0.241,0.235-0.29,0.736-0.348c0.377,0.127,0.377,0.127,0.189,0.563
						c2.64,0.442,4.768,0.575,9.918,0.908c-0.306,0.356-0.877,0.425-3.217,0.388c-1.551-0.021-1.886,0.008-2.434,0.071
						c-1.739-0.45-4.62-0.574-6.118-1.097c-0.101-0.035-0.213-0.084-0.302-0.115C292.207,19.24,292.349,19.165,292.384,18.887z"/>
					<path d="M290.909,19.943c0.531,0.049,0.813,0.055,1.087-0.038c0.353,0.294-0.501,0.371-1.063,0.369
						c-0.689-0.021-1.049-0.127-1.196-0.186c-0.1-0.039-0.165-0.086-0.207-0.129C289.685,19.929,290.003,19.86,290.909,19.943z"/>
					<path d="M254.203,18.731c-1.157,0.066-1.157,0.066-1.469-0.126c0.862,0.009,1.232-0.028,1.503-0.146
						c-0.112-0.012-0.271-0.023-0.378-0.034c-1.461-0.173-4.833-1.615,1.12-1.987c0.2,0.06,0.483,0.144,0.784,0.178
						c0.951,0.103,2.046,0.081,3.012,0.173c0.802,0.074,1.302,0.252,2.145,0.314c0.241,0.019,1.273,0.006,0.861-0.255
						c-0.294-0.188-1.313-0.154-1.746-0.301c1.05,0.054,2.335-0.179,3.183,0.108c1.433,0.482,1.433,0.482,2.859,0.514
						c1.893,0.026,3.766-0.111,5.67-0.031l4.426,0.311c0.448,0.04,0.53,0.08,0.673,0.154c-1.852,0.107-2.77,0.165-7.026,0.098
						c-5.199-0.08-8.954-0.135-10.845,0.293c1.201,0.164,2.77,0.123,3.865,0.351c-0.118,0.265-0.955,0.472-1.201,0.729
						c-1.828-0.061-3.29-0.365-5.164-0.399c-0.877-0.018-0.885,0.199-1.439,0.271c-0.194-0.026-0.341-0.071-0.482-0.112
						c-0.131,0.028-0.325,0.058-0.461,0.086l0.431,0.189c3.62,0.109,7.256-0.017,10.882,0.035c0.029-0.193,0.052-0.201,0.718-0.448
						c2.428,0.143,2.428,0.143,2.965,0.232c-0.143,0.117-0.448,0.227-0.389,0.353c2.179,0.34,7.061,0.408,9.141,0.438
						c7.585,0.108,7.829,0.201,8.464,0.459c-0.548,0.379-2.128,0.228-3.354,0.031c-0.235,0.044-0.235,0.044-3.708,0.204
						c-0.359-0.083-1.114-0.252-2.056-0.259c-1.02-0.011-1.97,0.109-3.002,0.086c-1.691-0.039-3.328-0.16-5.044-0.165
						c-3.908-0.019-7.803-0.075-11.711-0.063c-1.439,0.006-2.005,0.126-2.464,0.224c0.524,0.204,0.524,0.204,1.19,1.025
						c-6.312-0.015-6.312-0.015-7.008-0.046c-0.607-0.405-1.137-0.606-2.352-0.595c-0.012,0.003-0.036,0-0.051,0.003
						c-0.12-0.262,0.876-0.469,0.682-0.738c-0.029-0.037-0.294-0.058-0.429-0.086c-0.759-0.155-0.873-0.264-1.403-0.778
						C250.766,19.32,252.723,19.133,254.203,18.731z"/>
					<path d="M265.036,18.384c-0.144-0.02-0.144-0.02-0.531,0.075c-0.171,0.04-0.248,0.037-0.4-0.018
						c-0.013-0.006-0.023-0.012-0.047-0.021c-0.03-0.017-0.071-0.04-0.101-0.057C264.793,18.252,264.882,18.237,265.036,18.384z"/>
					<polygon points="266.249,27.148 265.742,27.136 265.566,26.958 266.071,26.971 "/>
					<path d="M257.225,23.314c-0.289-0.037-0.619-0.032-1.143-0.02c-0.537,0.011-0.968,0.017-1.243-0.078
						c-0.129-0.043-0.178-0.095-0.224-0.146c0.248,0.063,0.412,0.086,0.712,0.095c0.448,0.006,0.866-0.054,1.327-0.02
						C256.937,23.169,257.119,23.261,257.225,23.314z"/>
					<path d="M252.193,23.119c0.459,0.003,0.872-0.078,1.348-0.043c0.36,0.022,0.524,0.093,0.708,0.178
						c-1.025-0.058-2.251,0.075-3.1-0.155c0.53-0.114,0.2-0.166-0.661-0.275c-0.437-0.057-1.037-0.135-1.357-0.246
						c-0.199-0.075-0.224-0.133-0.234-0.176c1.267-0.043,4.349-0.089,5.463,0.396c-1.032-0.009-1.238,0.039-2.399,0.318
						C252.045,23.116,252.115,23.116,252.193,23.119z"/>
					<path d="M244.902,24.618c0.14,0.123,0.199,0.27-0.326,0.262c-0.064,0-0.122-0.003-0.194-0.003
						c-0.012-0.003-0.023,0-0.03-0.003C244.063,24.621,244.488,24.595,244.902,24.618z"/>
					<path d="M240.834,33.736c0.389,0.017,1.203,0.187,0.706,0.263l-1-0.206
						C240.551,33.771,240.563,33.724,240.834,33.736z"/>
					<path d="M234.28,36.271c-0.189-0.003-0.378-0.008-0.566-0.014c-0.023,0.003-0.061,0-0.082,0
						c-0.083-0.061-0.195-0.146-0.173-0.218c0.065-0.219,1.41-0.023,1.422-0.018C234.893,36.021,235.563,36.291,234.28,36.271z"/>
					<path d="M232.429,29.554c-0.482-0.068-0.884,0.023-0.884,0.023c-0.182,0.047-0.325,0.068-0.501,0.006
						c-0.057-0.02-0.1-0.04-0.146-0.063C231.002,29.479,232.04,29.331,232.429,29.554z"/>
					<path d="M230.041,29.595c-0.124-0.005-0.289-0.052-0.412-0.092c-0.006-0.003-0.025-0.006-0.041-0.012
						c0.283-0.111,0.464-0.089,0.578-0.049c0,0,0.005,0.003,0.011,0.006C230.33,29.522,230.201,29.595,230.041,29.595z"/>
					<path d="M238.169,22.462c-2.533-0.058-3.212-0.075-3.855-0.333c-0.094-0.038-0.175-0.081-0.248-0.121
						C237.639,22.318,237.639,22.318,238.169,22.462z"/>
					<path d="M233.053,18.844c0.152,0.087,0.367,0.197,0.52,0.286l-0.542-0.014c-0.065-0.022-0.143-0.049-0.189-0.072
						C232.488,18.89,232.901,18.857,233.053,18.844z"/>
					<path d="M412.142,41.155c-1.74-0.022-3.47-0.042-5.182-0.063C408.686,41.113,410.386,41.133,412.142,41.155z"/>
					<path d="M192.421,43.723c0.465,0.275-0.391,0.278-0.566,0.275c-0.626-0.024-0.966-0.126-1.099-0.171
						c-0.164-0.064-0.199-0.115-0.228-0.156C191.158,43.688,191.789,43.706,192.421,43.723z"/>
					<path d="M187.258,50.833c-5.389-0.229-8.713-0.551-9.036-0.62c-0.184-0.04-0.361-0.109-0.478-0.161
						c0.602,0.058,0.913,0.063,2.652,0.086C185.399,50.201,186.656,50.626,187.258,50.833z"/>
					<path d="M176.884,41.871c-0.013,0.003-0.024,0.003-0.036,0.008c-0.237-0.413-0.237-0.413-0.118-0.448
						C177.52,41.655,177.172,41.828,176.884,41.871z"/>
					<path d="M168.3,40.831c2.57,0.095,4.51,0.225,7.411,0.497c0.212,0.189,0.169,0.241-0.184,0.235
						c-0.925-0.028-0.925-0.028-0.931,0.08c-0.201-0.138-0.272-0.166-0.708-0.261c-0.171-0.038-0.317-0.078-0.436-0.123
						c0,0.017-0.006,0.037-0.012,0.051c-0.083,0.167-0.667,0.136-0.978,0.115c-0.602-0.029-1.085-0.118-1.657-0.166
						c-0.301-0.026-0.625-0.023-0.924-0.05c-0.095-0.008-0.235-0.022-0.33-0.031c-0.226-0.023-0.484-0.078-0.649-0.12
						C168.672,41.001,168.46,40.903,168.3,40.831z"/>
					<path d="M159,49.386c0.013,0,0.414,0.144-0.154,0.129c-0.435-0.017-1.095-0.126-1.373-0.226
						c-0.04-0.016-0.076-0.029-0.11-0.047C158.318,49.271,158.711,49.282,159,49.386z"/>
					<path d="M150.759,41.776c-0.211-0.006-0.423,0.005-0.634,0.003c-0.078-0.003-0.213-0.009-0.326-0.055
						c-0.052-0.018-0.082-0.04-0.111-0.063C150.006,41.695,150.444,41.742,150.759,41.776z"/>
					<path d="M147.555,41.271c0.129,0.034,0.342,0.16,0.141,0.158c-0.095-0.006-0.2-0.023-0.484-0.106
						c-0.01-0.005-0.034-0.012-0.046-0.018C147.271,41.244,147.401,41.233,147.555,41.271z"/>
					<path d="M151.469,46.873c-1.657,0.037-3.06,0.009-6.143-0.278c-0.094-0.009-0.212-0.022-0.307-0.029
						c-0.27-0.224-0.124-0.241,0.685-0.235c0.104,0.081,0.258,0.19,0.365,0.271c0-0.028-0.012-0.063,0.013-0.086
						c0.027-0.041,0.11-0.092,0.469-0.081c0.744,0.026,1.308,0.161,2.063,0.184c0.554,0.021,1.109,0.003,1.651,0.034
						c0.059,0.006,0.141,0.01,0.199,0.013C151.008,46.701,151.31,46.813,151.469,46.873z"/>
					<path d="M144.358,46.376c0.173,0.081,0.402,0.189,0.579,0.275l-0.425-0.017c-0.071-0.023-0.141-0.049-0.2-0.069
						C143.948,46.416,144.242,46.388,144.358,46.376z"/>
					<path d="M142.213,46.287c0,0,0.801-0.021,0.496,0.192l-0.417-0.012l-0.03-0.014
						C142.014,46.353,142.084,46.302,142.213,46.287z"/>
					<path d="M13.681,51.175c-0.709-0.167-1.836-0.188-2.52-0.358c-0.129-0.035-0.129-0.035-0.824-0.609
						c0.173,0.089,0.406,0.206,0.586,0.298l-0.58-0.367c0.007,0,0.017,0,0.025-0.003c1.083,0.078,0.745,0.391,1.633,0.5
						c0.005-0.009,0.021-0.015,0.033-0.02c0.003-0.006,0-0.006,0.003-0.012c0.042-0.219,0.042-0.219-0.215-0.405
						c0.305,0.181,0.351,0.187,0.486,0.198c0.043-0.012,0.099-0.022,0.144-0.034c0.124-0.006,0.167-0.004,0.35,0.061
						c-0.138-0.102,0.065-0.216-0.229-0.308c-1.068-0.345-1.426-0.281-1.541-0.258c-0.342-0.201-0.769-0.391-1.1-0.587
						c0.068,0.026,0.121,0.058,0.271,0.069c-0.062-0.063-0.177-0.121-0.148-0.189c0.284,0.109,0.349,0.115,0.484,0.123
						c0.062-0.021,0.062-0.021-0.171-0.49c0.499,0.045,0.86,0.178,2.061,0.614c-0.064-0.115-0.489-0.213-0.372-0.339
						c0.019,0.006,0.048,0.011,0.065,0.017c0.333-0.037,1.509-0.092,2.182,0.081c0.169,0.046,0.241,0.112,0.562,0.123
						c0.129-0.026,0.172-0.071,0.359-0.086c0.197,0.049,0.178,0.146,0.596,0.146c0.095-0.029,0.153-0.058,0.243-0.087
						c0.812,0.013,1.003,0.214,1.635,0.282c0.043-0.012,0.1-0.023,0.148-0.034c0.032,0.006,0.076,0.006,0.102,0.006
						c0.238,0.074,0.551,0.181,0.789,0.255c0.359,0.072,0.721-0.063,1.081,0c0.442,0.078,0.731,0.192,1.255,0.247
						c0.032,0.003,0.076,0.009,0.108,0.015c0.478,0.034,0.749-0.108,1.228-0.069c0.359,0.026,0.283,0.155,0.745,0.161
						c0.118-0.029,0.182-0.066,0.28-0.098c1.014-0.021,1.603,0.414,2.579,0.221c0.421,0.178,0.667,0.259,1.09,0.358l-0.217-0.258
						c0.891,0.322,2.253,0.557,3.094,0.887c0.009-0.005,0.03-0.014,0.043-0.02c0.027,0,0.069-0.005,0.095-0.005
						c0.189,0.008,1.598,0.364,1.23,0.474c-0.104-0.015-0.234-0.035-0.65-0.225c0.189,0.17,0.218,0.218,0.142,0.265
						c-0.042,0.003-0.099,0.011-0.142,0.008c-0.423-0.017-0.602-0.117-0.989-0.148c-0.602-0.05-1.163,0.086-1.767,0.018
						c-0.638-0.07-1.007-0.288-1.937-0.199c-0.194-0.021-0.2-0.022-0.402-0.083c0.131,0.133,0.122,0.138,0.052,0.192
						c-0.178,0.009-0.21,0.006-0.69-0.089c-0.227-0.043-0.462-0.086-0.715-0.12c-0.347-0.047-0.626,0.079-0.976,0.02
						c-0.427-0.071-0.418-0.221-0.972-0.271c-0.093,0.035-0.255,0.09-0.9,0.016c-0.093-0.013-0.218-0.029-0.304-0.041
						c-0.761-0.108-1.391-0.258-2.169-0.355c-0.391-0.052-0.649-0.069-1.179-0.046c-0.817,0.028-1.213,0.005-2.175-0.38
						c0.136,0.086,0.312,0.201,0.449,0.285c-0.804-0.182-1.268-0.182-1.375-0.006c-0.246-0.164-0.186-0.348-0.544-0.509
						c-0.489-0.02-0.271,0.118-0.017,0.278c-0.054,0.204-0.051,0.207,0.783,0.54l-0.252-0.244c0.498,0.253,1.243,0.472,1.58,0.738
						c-0.154-0.012-0.154-0.012-0.938-0.29c0.175,0.123,0.599,0.227,0.582,0.367c-0.383-0.152-0.52-0.189-0.696-0.218
						c-0.029,0.006-0.068,0.009-0.09,0.011c-0.019,0.029-0.025,0.053-0.012,0.078c-0.258-0.152-0.673-0.29-1.017-0.434
						c0.064,0.154,0.432,0.296,0.354,0.457c-0.249-0.149-0.332-0.308-0.709-0.445c-0.049,0.003-0.113,0.006-0.164,0.006
						C13.463,50.963,13.611,51.068,13.681,51.175z"/>
					<path d="M9.453,49.65c-0.079-0.023-0.271-0.075-0.472-0.081c-0.247-0.006-0.465-0.04-0.908-0.212
						c-0.391-0.152,0.272-0.351,0.303-0.359c0.237,0.118,0.564,0.227,0.836,0.342c-0.081-0.063-0.216-0.173-0.131-0.198
						c0.093-0.025,0.363,0.043,0.363,0.043c0.175,0.058,0.297,0.144,0.427,0.204c0.118,0.078,0.24,0.152,0.291,0.235
						c0.034,0.049-0.06,0.092-0.051,0.142c-0.375-0.122-0.629-0.254-1.003-0.374C9.212,49.47,9.35,49.569,9.453,49.65z"/>
					<path d="M6.841,49.167c0.021,0.007,0.039,0.012,0.077,0.018c0.241-0.04-0.142-0.092-0.027-0.144
						c0.122,0.012,0.177,0.055,0.641,0.391c-0.192-0.034-0.299-0.058-0.5-0.155C6.962,49.242,6.903,49.205,6.841,49.167z"/>
					<polygon points="6.986,49.328 6.759,49.282 6.452,49.093 6.685,49.136 "/>
					<path d="M1.473,45.917c-0.004,0-0.007,0-0.007,0c-0.127-0.075-0.268-0.149-0.341-0.229
						c-0.027-0.029-0.013-0.04,0.043-0.032C1.18,45.658,1.859,45.899,1.473,45.917z"/>
					<path d="M0.788,45.79c0,0-0.003,0-0.008,0c-0.143-0.034-0.186-0.08-0.262-0.12c-0.072-0.037,0.003-0.052,0.003-0.052
						C0.6,45.618,0.841,45.773,0.788,45.79z"/>
					<path d="M3.806,37.652c0.229,0.074,0.297,0.08,0.57,0.115c0.175,0.006,0.24,0.012,0.477,0.103
						c-0.201,0.006-0.191,0.081-0.439,0.069c-0.04,0-0.151-0.012-0.313-0.098C3.979,37.781,3.892,37.716,3.806,37.652z"/>
					<path d="M3.845,37.805c-0.122-0.015-0.23-0.041-0.524-0.21c-0.013-0.002-0.016-0.005-0.021-0.012
						C3.517,37.614,3.649,37.632,3.845,37.805z"/>
					<path d="M2.946,37.856c-0.05-0.009-0.08-0.015-0.116-0.025c-0.071-0.021-0.253-0.162-0.155-0.213
						c0.056-0.035,0.188-0.015,0.3,0.04C3.049,37.698,3.124,37.87,2.946,37.856z"/>
					<path d="M1.74,37.756c-0.145-0.098-0.445-0.308-0.345-0.33c0.003-0.003,0.377,0.008,0.613,0.227
						c0.075,0.074-0.044,0.061-0.137,0.052c-0.104-0.015-0.203-0.025-0.147,0.035C1.728,37.744,1.737,37.75,1.74,37.756z"/>
					<polygon points="1.942,37.546 2.241,37.587 2.509,37.784 2.206,37.741 "/>
					<path d="M19.511,41.046c0.002-0.005,0.012-0.005,0.504,0.139l0.646,0.028l-0.003,0.04
						c0.084-0.037,0.197-0.086,0.289-0.12c0.185,0.066,0.442,0.149,0.625,0.212l-0.525-0.051l-0.388-0.041l-0.002,0.029l-0.266-0.04
						c-0.004-0.003-0.004-0.003-0.007-0.006c-0.002,0-0.002-0.003-0.012-0.003c0-0.003,0-0.003-0.017-0.015h-0.291l-0.224-0.052
						L19.511,41.046z"/>
					<path d="M30.671,45.263c0.013,0,0.031-0.003,0.05-0.007c0.362,0.058,0.332,0.178,0.758,0.219
						c0.026-0.046,0.051-0.109,0.073-0.157l0.918,0.335c0.101,0.023,0.28,0.023,0.356,0.052c0.136,0.058,0.322,0.185,0.366,0.247
						c-0.003,0.003-0.017,0.006-0.023,0.009c-0.209-0.065-0.288-0.152-0.562-0.21c0.008,0.069,0.013,0.163,0.022,0.235
						c-0.524-0.052-0.989-0.166-1.996-0.427c-0.07,0.06-0.208,0.188-1.243,0.117c-0.473-0.035-0.473-0.035-1.184-0.29
						c-0.308-0.044-0.504-0.008-0.695,0.031c-0.437,0.087-0.745,0.098-1.321-0.058c-0.258-0.068-0.228-0.338-0.147-0.396
						c0.221-0.173,0.806-0.121,1.026-0.102c0.289,0.026,0.289,0.026,0.99,0.279l0.066-0.161c0.702-0.034,1.067,0.052,2.607,0.425
						C30.691,45.357,30.604,45.313,30.671,45.263z"/>
					<path d="M34.776,46.692c0.523,0.08,0.847,0.224,1.217,0.401c-0.4-0.08-0.784-0.131-1.456-0.144
						c-1.367-0.017-1.96-0.224-2.435-0.385c0.127,0.086,0.295,0.201,0.423,0.288c-0.24-0.058-0.29-0.061-0.472-0.063
						c-0.212,0.055-0.248,0.16,0.182,0.58c-0.036,0-3.727,0.091-5.779-0.517c0.011,0.034,0.031,0.068-0.036,0.097
						c-0.09,0.047-0.339,0.023-0.682-0.14c-0.159-0.072,0.144-0.133,0.127-0.204c-0.035-0.086-0.34-0.179-0.375-0.19
						c-0.305-0.089-0.351-0.114-0.574-0.275c0.38-0.141,0.389-0.144,1.065-0.132c0.791,0.015,1.377,0.145,2.115,0.187
						c0.583,0.034,0.642,0.021,0.838-0.031c0.065-0.018,0.132-0.034,0.249-0.034c0.049,0,0.11,0.005,0.16,0.011
						c0.344,0.021,0.98,0.126,1.863,0.271c1.05,0.169,1.384,0.2,1.888,0.25C33.647,46.692,34.246,46.611,34.776,46.692z"/>
					<polygon points="33.488,45.831 33.745,45.856 34,46.031 33.748,46.009 "/>
					<path d="M36.299,46.893c0.343,0.007,0.491,0.034,0.672,0.13c-0.205-0.015-0.386,0.04-0.594,0.009
						c-0.143-0.023-0.289-0.071-0.493-0.17c-0.017-0.008-0.036-0.017-0.052-0.026C35.958,46.864,36.133,46.879,36.299,46.893z"/>
					<path d="M35.887,46.055c0.162,0.043,0.286,0.055,0.4-0.026c0.033-0.022,0.079-0.04,0.236,0.026
						c0.334,0.138,0.049,0.195-0.082,0.187c-0.164-0.02-0.382-0.111-0.504-0.166C35.925,46.069,35.906,46.06,35.887,46.055z"/>
					<path d="M39.695,48.699c0.012,0,1.546,0.061,1.913-0.06c2.234,0.398,6.866,0.906,9.39,0.775
						c0.283,0.063,0.235,0.178,0.666,0.223c0.99,0.102,2.104,0.073,3.109,0.156c0.821,0.068,0.821,0.068,6.81,0.37
						c4.703,0.238,4.703,0.238,4.952,0.31c0.512,0.152,0.37,0.343-0.249,0.322c-9.654-0.658-10.167-0.663-11.129-0.163
						c1.262,0.143,1.84,0.255,2.69,0.524c-0.767-0.105-0.767-0.105-1.145-0.252c0.101,0.055,0.189,0.105,0.26,0.16
						c-0.046,0.006-0.118,0.015-0.159,0.021c-0.089-0.009-0.218-0.023-0.325-0.028c-0.029,0.008-0.076,0.02-0.112,0.028
						c0.019,0.014,0.042,0.034,0.053,0.046c-0.849-0.029-1.496-0.093-3.439-0.311c-1.845-0.206-1.988-0.201-2.692-0.172
						c-0.544,0.021-0.693,0.018-1.057-0.012l-6.016-0.497c-0.9-0.083-1.723-0.209-2.71-0.235c0.006,0.026-0.019,0.061-0.052,0.084
						c-0.007-0.003-1.736-0.195-1.763-0.199c-0.53-0.051-1.125-0.008-1.663-0.054c-1.103-0.096-1.986-0.282-3.08-0.382
						c-0.571,0.105-0.958-0.112-1.184-0.316c0.153-0.048,0.24-0.071,0.988,0.021c1.655,0.201,1.686,0.055,1.529-0.213
						c-1.458-0.247-3.312-0.296-4.883-0.488h-0.002c0,0-0.401-0.152-0.177-0.296c0.4-0.031,0.522-0.043,1.45,0.049
						C31.706,48.113,39.518,48.691,39.695,48.699z"/>
					<path d="M37.09,46.95c0.365,0.081,0.518,0.047,0.53,0.044c0.146-0.038,0.238-0.026,0.51,0.134
						c-0.185,0.029-0.3,0.023-0.397,0.019c-0.095-0.006-0.289-0.029-0.592-0.173C37.125,46.968,37.1,46.956,37.09,46.95z"/>
					<path d="M40.732,47.203l0.388,0.189c-0.221-0.022-0.329-0.034-0.473-0.097c-0.081-0.038-0.136-0.075-0.182-0.115
						C40.541,47.186,40.647,47.198,40.732,47.203z"/>
					<path d="M40.706,43.301c0.042,0.029,0.095,0.065,0.137,0.095c0.118,0.052,0.234,0.104,0.351,0.152
						c0.037,0.021,0.153,0.031,0.097,0.055c-0.073-0.012-0.484-0.163-0.616-0.224c-0.019-0.013-0.038-0.018-0.056-0.029
						C40.487,43.28,40.597,43.292,40.706,43.301z"/>
					<path d="M41.313,47.977c0.227,0.157,0.327,0.258,0.07,0.24c-0.023-0.002-0.04-0.002-0.062-0.002l-0.006-0.004
						c-0.123-0.083-0.283-0.189-0.403-0.27L41.313,47.977z"/>
					<path d="M42.217,48.307c-0.043-0.01-0.073-0.021-0.114-0.026c-0.082-0.012-0.257-0.141-0.143-0.187
						c0.076-0.028,0.293-0.028,0.389,0.054C42.034,48.131,42.537,48.323,42.217,48.307z"/>
					<path d="M47.543,48.415c0.857,0.104,1.674-0.092,2.531-0.017c0.613,0.058,1.04,0.16,1.654,0.347
						c0.507-0.268,0.507-0.268,1.143-0.231c-0.648-0.395-0.648-0.395-0.521-0.445c0.255,0.014,0.557,0.031,0.625,0.267
						c0.095,0.327,0.575,0.342,1.523,0.364c2.388,0.063,2.388,0.063,2.664,0.106c0.071,0.012,0.165,0.025,0.236,0.038
						c0.401,0.065,0.767,0.157,1.062,0.235c-0.195-0.13-0.497-0.248-0.684-0.377c1.543-0.044,2.18-0.063,3.542,0.166
						c0.884-0.326,2.404-0.003,3.601-0.003c1.061-0.315,2.229,0.238,3.418,0.313l0.188-0.157c0.347-0.007,0.577,0.074,0.938,0.061
						c0.207,0.111,0.49,0.261,0.689,0.372c0.566,0.104,1.338,0.098,1.898,0.202c0.424,0.074,0.748,0.215,1.002,0.327
						c-3.365,0.115-6.731-0.089-12.401-0.747c-0.259,0.275-1.349,0.132-2.204-0.075c-0.072,0.047-0.165,0.104-0.431,0.104
						c-0.131,0-3.729-0.087-4.009-0.102c-1.406-0.071-1.406-0.071-2.277-0.333l-0.305,0.13c-2.083,0-3.561-0.334-5.348-0.497
						c-0.079-0.008-0.187-0.015-0.266-0.023c-0.076-0.146-0.056-0.151,0.089-0.215c0.062-0.006,0.138-0.011,0.194-0.011
						C46.69,48.236,47.043,48.357,47.543,48.415z"/>
					<path d="M46.358,44.579c0.037-0.047,0.639,0.043,0.642,0.045c0.008,0,0.413,0.21,0.129,0.196
						c-0.232-0.023-0.544-0.115-0.701-0.184C46.39,44.619,46.347,44.603,46.358,44.579z"/>
					<path d="M48.354,44.97c0,0,0.464-0.037,0.445,0.206l-0.289-0.025l-0.027-0.015
						C48.274,45.038,48.271,44.986,48.354,44.97z"/>
					<path d="M56.873,46.175l-0.558-0.293l-0.414-0.103c0.153-0.006,0.271-0.014,0.389-0.071
						c0.106-0.053,0.118-0.058,0.236-0.056c-0.3-0.161-0.718-0.315-0.955-0.481c0.224,0.039,0.513,0.097,0.731,0.137
						c-0.095,0.087,0.042,0.155,0.401,0.29c0.364,0.147,0.542,0.228,0.66,0.356C56.938,46,57.386,46.195,56.873,46.175z"/>
					<path d="M58.229,47.585c-0.243,0.043-0.383,0.058-0.596,0.043c-0.106-0.005-0.294-0.022-0.518-0.12
						c-0.083-0.034-0.218-0.068-0.172-0.118C57.051,47.272,57.799,47.425,58.229,47.585z"/>
					<path d="M55.718,45.839l0.418,0.199c-0.399-0.05-0.399-0.05-0.519-0.096c-0.089-0.04-0.148-0.083-0.199-0.123
						C55.513,45.825,55.629,45.831,55.718,45.839z"/>
					<path d="M56.195,48.433c-0.212,0.034-0.367,0.058-0.59,0.042c-0.129-0.008-0.306-0.036-0.513-0.129
						c-0.064-0.028-0.123-0.057-0.169-0.091C55.17,48.177,55.624,48.239,56.195,48.433z"/>
					<path d="M54.318,45.325c-0.229-0.187-0.135-0.267-0.104-0.29c0.047-0.031,0.236-0.105,0.743,0.178
						C54.767,45.245,54.512,45.291,54.318,45.325z"/>
					<path d="M54.893,48.49c-0.006,0-0.006,0-0.012,0.003c-0.227-0.124-0.529-0.244-0.679-0.377
						c0.125,0.01,0.288,0.023,0.411,0.031C54.798,48.271,54.993,48.427,54.893,48.49z"/>
					<path d="M54.448,48.545c-0.017-0.016-0.261-0.142-0.442-0.204c-0.143-0.047-0.235-0.058-0.264-0.023
						c-0.003,0-0.003,0.003-0.003,0.006c-0.08-0.058-0.257-0.201-0.224-0.247c0.029-0.04,0.175,0,0.297,0.04
						C54.135,48.223,54.847,48.564,54.448,48.545z"/>
					<path d="M53.862,45.813c-0.302,0-0.348-0.068-0.546-0.104c-0.185-0.022-0.158,0.04-0.109,0.121
						c-0.476-0.123-0.653-0.155-1.09-0.207c-0.178-0.018-0.352-0.041-0.51-0.068c-0.184-0.033-0.184-0.033-0.464-0.534
						c0.24,0.132,0.378,0.178,0.59,0.2c0.135,0.007,0.249-0.006,0.365-0.017c0.296-0.034,0.546-0.058,0.915,0.023
						c0.099,0.021,0.891,0.419,0.955,0.487C53.968,45.716,54.012,45.816,53.862,45.813z"/>
					<path d="M59.354,45.256c0.195,0.078,0.195,0.078,0.661,0.466c1.036,0.052,1.905,0.209,2.953,0.259
						c0.542,0.028,0.767-0.034,0.913-0.075c0.348,0.115,1.557,0.66,1.179,0.824c-0.23-0.083-0.623-0.135-0.896-0.212
						c-0.129-0.032-0.141-0.106-0.317-0.124c-0.319-0.038-0.749-0.018-1.31,0.052c-0.949,0.12-1.603-0.034-2.192-0.201
						c-0.036,0.152-0.219,0.155-0.801,0.006c-0.543-0.136-0.795-0.17-0.967-0.133c-0.012,0-0.019,0.003-0.03,0.007
						c-0.431-0.362-0.431-0.466,0.454-0.457C59.826,45.672,59.872,45.612,59.354,45.256z"/>
					<path d="M81.659,46.273c1.366,0.074,2.569,0.241,3.92,0.315c1.219,0.068,2.517-0.029,3.7,0.092
						c0.061,0.005,0.136,0.018,0.195,0.023c0.459,0.06,0.684,0.178,1.143,0.235c0.596,0.074,1.314,0.068,1.91,0.146
						c0.16,0.02,0.355,0.052,0.502,0.077c0.642,0.117,1.09,0.311,1.525,0.488c-2.31,0.02-4.444-0.184-6.672-0.27
						c0.307,0.215,0.229,0.231,0.07,0.264c-0.519-0.018-0.942-0.104-1.478-0.114c-1.021-0.029-2.059,0.022-3.079-0.023
						c-1.691-0.075-4.078-0.247-4.096-0.247c-0.435-0.038-0.318-0.138-0.448-0.206c-0.371-0.217-0.441-0.241-0.708-0.282
						c-0.183,0.072-0.183,0.072-1.591-0.265c-0.418,0.081-0.34,0.265-1.108,0.271c-0.405-0.172-1.172-0.496-0.86-0.675
						c0.201-0.112,1.15-0.173,2.322,0.336c-0.164-0.142,0.272-0.271,0.189-0.408c0.83,0.178,1.416,0.213,2.43,0.136
						c0.742-0.058,1.154-0.055,1.626,0.021c-0.013,0.017-0.037,0.045-0.055,0.068C81.293,46.259,81.481,46.267,81.659,46.273z"/>
					<path d="M108.452,49.478c3.531,0.281,4.551,0.265,5.045,0.259c-0.082-0.061-0.189-0.135-0.271-0.192l0.767,0.284
						c0.423-0.104,0.423-0.104,1.862,0.08c0.106-0.054,0.354-0.184,1.097-0.108c3.159,0.299,3.478,0.428,3.896,0.585
						c0.172-0.022,0.69-0.095,1.728-0.017c1.19,0.092,2.205,0.275,3.466,0.327c0.412,0.014,0.83-0.038,1.238,0.006
						c0.307,0.028,0.565,0.163,0.701,0.228c-0.885-0.053-1.775-0.09-2.681-0.125l-7.438-0.235c-0.778-0.006-0.813,0.127-0.849,0.242
						c1.592,0.247,4.745,0.551,6.795,0.487c1.61-0.055,2.487,0,3.766,0.472c-2.87,0.138-5.577-0.13-8.376-0.173
						c0.083,0.053,0.184,0.121,0.184,0.173c-0.16,0.037-0.412,0.034-0.589,0.063c-0.024,0.052,0.046,0.114,0.11,0.16
						c-9.165-0.367-9.165-0.367-11.021-0.563c-0.243,0.09-0.553,0.112-1.384,0.095c-1.78-0.548-2.152-0.714-2.429-0.962
						c2.57-0.037,5.127,0.333,7.716,0.018c1.066,0.149,1.515,0.216,1.395-0.097c-6.471-0.405-6.871-0.483-8.05-0.704l0.059,0.163
						c-0.118,0.023-0.224,0.047-0.519,0.032c-0.767-0.038-1.239-0.192-1.976-0.238c-0.725-0.044-1.473,0.029-2.198-0.018
						c-0.153-0.008-0.471-0.034-0.86-0.106c-0.046-0.009-0.106-0.02-0.154-0.031c0.685-0.022-0.07-0.241,0.52-0.311
						c0.553,0.204,0.553,0.204,1.309,0.328C102.653,49.174,104.32,49.147,108.452,49.478z"/>
					<path d="M105.747,48.44c0.006-0.014,0.019-0.025,0.041-0.04c0.119-0.055,0.461-0.043,0.825,0.169L105.747,48.44z"/>
					<polygon points="107.74,47.767 108.08,47.783 108.323,47.953 107.981,47.938 "/>
					<path d="M113.581,48.157c-0.006,0-0.184,0.079-0.484-0.023c-0.065-0.026-0.148-0.058-0.2-0.083
						c-0.36-0.17-0.336-0.342,0.235-0.296c0.059,0.08,0.27,0.12,0.589,0.178c0.289,0.052,0.378,0.075,0.167,0.104l-0.508-0.109
						C113.467,47.99,113.64,48.105,113.581,48.157z"/>
					<path d="M126.806,49.345c0.237,0.01,0.556,0.023,0.795,0.029c0.29,0.189,0.07,0.235-0.099,0.235
						c-0.059-0.006-0.212-0.014-0.4-0.089C126.959,49.467,126.876,49.405,126.806,49.345z"/>
					<polygon points="99.516,48.234 99.117,47.95 99.476,47.967 100.059,48.26 "/>
					<path d="M128.599,49.46c0.046-0.011,0.105-0.006,0.165,0c0.2,0.021,0.365,0.052,0.553,0.075
						c0.19,0.155,0.2,0.189,0.16,0.212c0,0-0.005,0.006-0.017,0.006c-0.019,0-0.047,0.006-0.072,0.003
						c-0.224-0.011-0.365-0.055-0.564-0.077c-0.013,0-0.037,0-0.047-0.006C128.675,49.604,128.505,49.483,128.599,49.46z"/>
					<polygon points="129.719,49.546 130.084,49.562 130.696,49.84 130.097,49.816 "/>
					<path d="M136.155,49.92c1.45,0.04,2.806,0.169,4.244,0.224c0.694,0.026,0.955,0.034,1.391,0.023
						c1.826,0.388,4.254,0.603,4.638,0.62c1.256,0.055,1.539,0.126,2.082,0.391c-0.224,0.074-0.525,0.178-2.505,0.026
						c-1.632-0.127-2.116-0.072-2.434,0.065c-0.413-0.178-0.731-0.247-1.403-0.319c-0.107,0.021-0.42,0.078-0.955,0.032
						c-0.632-0.054-1.179-0.149-1.811-0.207c-0.744-0.069-1.539-0.095-2.282-0.166c-0.224-0.018-0.519-0.047-0.736-0.069
						c-0.429-0.043-0.96-0.127-1.278-0.206c-0.36-0.093-0.649-0.248-0.837-0.359C134.604,49.942,135.122,49.892,136.155,49.92z"/>
					<path d="M135.152,49.147c0.129-0.092,0.259-0.083,0.353-0.061c0.178,0.046,0.249,0.166,0.054,0.166
						c-0.1-0.005-0.277-0.063-0.372-0.094C135.177,49.156,135.165,49.15,135.152,49.147z"/>
					<path d="M137.593,49.239c0-0.201,0.247-0.212,1.02-0.146c0.92,0.083,1.114,0.011,1.232-0.023
						c0.095,0.044,0.165,0.075,0.448,0.121c0.413,0.069,0.537,0.106,0.672,0.264c-0.123,0.034-0.237,0.047-0.531,0.037
						c-0.989-0.054-1.708-0.261-2.806-0.255C137.618,49.239,137.605,49.236,137.593,49.239z"/>
					<path d="M141.86,49.395c0.472-0.058-0.106-0.268,0.482-0.262c0.696,0.012,0.272,0.229,0.814,0.282
						c0.26-0.018,0.146-0.087,0.306-0.115c0.307-0.055,0.472,0.149,0.461,0.188c-0.083,0.182-1.615,0.013-2.018-0.079
						C141.895,49.402,141.872,49.397,141.86,49.395z"/>
					<path d="M150.087,51.589c0.437,0.123,0.755,0.33,0.319,0.35c-0.076-0.02-0.152-0.043-0.211-0.066
						C149.912,51.758,149.675,51.594,150.087,51.589z"/>
					<path d="M152.434,51.833c0.402-0.102,0.915-0.006,1.645,0.307c-0.353-0.012-0.943-0.032-1.569-0.272
						C152.488,51.855,152.453,51.844,152.434,51.833z"/>
					<path d="M144.865,51.502c0.019-0.025,0.108-0.046,0.525,0.084c-0.03,0.034-0.077,0.071-0.194,0.068
						c-0.094-0.005-0.142-0.023-0.189-0.041C144.903,51.579,144.854,51.528,144.865,51.502z"/>
					<path d="M145.467,51.5c0.532,0.002,0.968,0.021,1.297,0.223c-0.294-0.008-0.79-0.022-1.272-0.212
						C145.486,51.508,145.473,51.505,145.467,51.5z"/>
					<path d="M148.768,51.93c-0.801-0.04-1.566-0.212-1.891-0.321c-0.053-0.017-0.123-0.046-0.172-0.063
						c0.461-0.086,0.786-0.037,1.369,0.061c0.536,0.092,0.776,0.101,1.219,0.117C149.451,51.907,149.098,51.936,148.768,51.93z"/>
					<path d="M131.375,50.141c-0.042-0.008-0.089-0.021-0.129-0.028c0.27-0.071,0.27-0.071-0.431-0.434
						c0.366,0.025,0.742,0.046,1.12,0.061c0.36,0.014,0.719,0.02,1.072,0.026c0.148,0.16,0.636,0.292,0.837,0.447
						C133.467,50.327,132.058,50.287,131.375,50.141z"/>
					<path d="M72.977,49.374c-0.03,0.004-0.054,0.006-0.083,0.012c-0.012-0.021-0.03-0.046-0.042-0.063
						c-0.135-0.312,1.298-0.038,1.98,0.092c-0.188,0.022-0.305,0.025-0.653,0.002C73.195,49.357,73.195,49.357,72.977,49.374z"/>
					<path d="M73.395,50c0,0-0.011,0-0.024,0c-0.218-0.132-0.276-0.2-0.211-0.241c0,0,0.011,0,0.011-0.003
						c0.059-0.017,0.154-0.025,0.412,0C73.901,49.949,73.831,49.954,73.395,50z"/>
					<path d="M75.304,51.014c0.095,0.009,0.188,0.021,0.294,0.025c0.089,0.006,0.165-0.008,0.254-0.011
						c0.017,0.006,0.047,0.011,0.064,0.017c0.006,0,0.017,0.007,0.023,0.013c0.065,0.034,0.119,0.063,0.165,0.1
						c-0.095-0.006-0.224-0.014-0.319-0.02c-0.07,0.051-0.164,0.126-0.547,0.126c-0.731,0-1.25-0.12-1.87-0.181
						c-0.618-0.061-0.672-0.063-1.048,0.003c-0.265,0.043-0.36,0.052-0.732,0.04c-0.788-0.021-1.496-0.104-2.244-0.155
						c-0.289-0.021-0.602-0.015-0.901-0.028c-0.331-0.018-0.685-0.053-1.122-0.21c-0.129-0.042-0.264-0.109-0.37-0.157
						c0.484-0.061,0.985-0.092,3.084,0.017C71.12,50.654,73.335,50.819,75.304,51.014z"/>
					<polygon points="75.033,49.269 75.35,49.289 75.611,49.467 75.286,49.443 "/>
					<path d="M75.657,49.392c0.224,0.037,0.532,0.086,0.767,0.12c-0.024,0.052-0.082,0.063-0.235,0.058
						c-0.118-0.008-0.237-0.037-0.354-0.086C75.771,49.454,75.706,49.423,75.657,49.392z"/>
					<path d="M82.483,48.532c0.177,0.152,0.376,0.359,0.106,0.354c-0.142-0.011-0.283-0.045-0.425-0.103
						C82.012,48.72,81.6,48.487,82.483,48.532z"/>
					<path d="M83.237,48.731c0.106,0.021,0.212,0.028,0.331,0.034c0.313,0.018,0.483,0.025,0.625,0.195
						c-0.129,0.003-0.424,0.009-0.76-0.133C83.356,48.797,83.297,48.766,83.237,48.731z"/>
					<path d="M88.06,48.607c0.519,0.009,0.743,0.129,1.202,0.164c0.078,0,0.154,0,0.213-0.015
						c0-0.003,0.011-0.005,0.019-0.009c0.004,0,0.01-0.006,0.016-0.009c0.184,0.129,0.507,0.244,0.697,0.371
						c-0.944-0.028-0.991-0.025-1.792,0.08c-0.167-0.08-0.391-0.195-0.555-0.275c0.013,0.04,0.053,0.12-0.036,0.12
						c-0.308,0.015-0.218-0.092-0.482-0.1v0.002c-0.03,0.04,0.035,0.074,0.076,0.112c-0.254-0.038-0.643-0.095-1.426-0.089
						c-0.348,0.006-0.772,0.009-1.416-0.127c-0.051-0.011-0.104-0.022-0.159-0.034c0.66-0.286,1.416-0.23,3.679-0.048
						C88.035,48.702,87.893,48.604,88.06,48.607z"/>
					<path d="M89.886,48.674c0.036-0.006,0.065,0,0.095,0.003c0.329,0.037,1.154,0.456,0.918,0.471
						c-0.129-0.117-0.495-0.207-0.742-0.307C90.027,48.788,89.945,48.731,89.886,48.674z"/>
					<path d="M89.592,50.69c-0.083-0.007-0.283-0.019-0.672-0.122c-0.023-0.006-0.042-0.014-0.059-0.017
						c0.288-0.003,0.689,0.011,0.859,0.068C89.803,50.644,89.846,50.701,89.592,50.69z"/>
					<path d="M88.589,49.954c-0.571-0.068-0.778-0.037-1.156,0.017c-0.01,0-0.034,0.007-0.047,0.007
						c-0.034-0.035-0.116-0.109-0.034-0.161C87.494,49.716,88.111,49.739,88.589,49.954z"/>
					<path d="M86.255,50c-0.07-0.006-0.258-0.017-0.482-0.104c-0.237-0.092-0.213-0.114-0.201-0.126
						c0.072-0.069,0.401-0.072,0.714,0.037C86.868,50.012,86.267,50,86.255,50z"/>
					<path d="M85.212,49.874c-0.241-0.017-0.395-0.08-0.419-0.087c-0.035-0.011-0.059-0.028-0.083-0.045
						c0.177-0.021,0.349-0.102,0.542-0.052C85.294,49.695,85.753,49.896,85.212,49.874z"/>
					<path d="M75.164,47.936c1.997,0.112,3.695,0.391,5.67,0.521c0.224,0.011,0.448,0.019,0.678,0.019
						c0.053,0.095,0.11,0.21,0.053,0.285c-0.154,0.166-0.708,0.103-1.486,0.012c-0.872-0.101-0.872-0.101-3.159-0.115
						c-1.355-0.006-4.992-0.229-7.816-0.413c-1.921-0.127-3.795-0.293-5.752-0.392c-0.482-0.022-0.913,0.064-1.403,0.038
						c-0.218-0.015-0.673-0.066-1.213-0.296c-0.059-0.025-0.136-0.063-0.189-0.089c0.023,0,0.065,0.003,0.095,0.003
						c0.353-0.081-0.025-0.189,0.199-0.275c0.141,0.031,0.141,0.079,0.236,0.115c1.097-0.036,1.645-0.058,5.434,0.209
						c1.473,0.101,2.925,0.224,4.444,0.29C72.339,47.909,73.778,47.858,75.164,47.936z"/>
					<path d="M72.474,49.199c0.154,0.216-0.046,0.227-0.522,0.198c-0.254-0.018-0.502-0.032-0.632,0.025
						c-0.024,0.009-0.035,0.021-0.047,0.029C70.878,49.024,71.314,49.075,72.474,49.199z"/>
					<path d="M54.599,51.718c-0.301-0.023-0.607-0.047-0.906-0.068c-0.021-0.003-0.046-0.007-0.064-0.007
						c-0.087-0.057-0.203-0.132-0.292-0.189c0.322,0.023,0.649,0.052,0.977,0.075C54.399,51.586,54.515,51.663,54.599,51.718z"/>
					<path d="M50.502,51.393c-0.207-0.037-0.343-0.049-0.622-0.021c-0.159,0.019-0.274,0.029-0.487-0.057
						c-0.162-0.069-0.269-0.144-0.38-0.213c0.15,0.023,0.321,0.041,0.495,0.058C49.981,51.172,50.221,51.229,50.502,51.393z"/>
					<path d="M32.645,49.874c-0.055-0.014-0.119-0.04-0.176-0.058c1.271,0.173,2.685-0.051,3.966,0.075
						c0.512,0.051,0.987,0.12,1.527,0.154c1.825,0.121,3.404,0.386,5.27,0.482c0.315,0.018,0.319-0.074,0.495-0.109
						c1.361,0.023,4.315,0.445,4.747,0.639c0.007,0.002,0.342,0.204-0.376,0.148c-2.008-0.172-4.124-0.281-6.095-0.477
						c-0.542-0.052-0.542-0.052-0.712,0.052c-0.08,0.052-0.198,0.046-0.823-0.072c-0.192-0.037-0.359-0.079-0.613-0.1
						c-0.246-0.015-0.501-0.018-0.752-0.023c-1.084-0.023-1.621-0.058-2.565-0.293c-0.164,0.086-0.24,0.109-0.443,0.12
						c-0.655-0.181-1.049-0.24-1.836-0.28C33.702,50.106,33.26,50.072,32.645,49.874z"/>
					<path d="M32.357,51.487l0.517,0.282c-0.013,0.034-0.125,0.063-0.332,0.04c-0.091-0.009-0.163-0.029-0.219-0.047
						c-0.131-0.054-0.143-0.116-0.152-0.149c0.146,0.041,0.342,0.093,0.49,0.13L32.357,51.487z"/>
					<polygon points="32.051,49.92 31.79,49.747 32.253,49.794 32.523,49.971 "/>
					<path d="M31.446,49.13c-0.062,0.052-0.389-0.011-0.737-0.169c-0.024-0.012-0.062-0.028-0.086-0.046
						c0.089,0.028,0.215,0.04,0.337,0.052C31.491,48.983,31.452,49.127,31.446,49.13z"/>
					<path d="M29.688,48.346c-0.05-0.002-0.16-0.017-0.326-0.091c-0.197-0.093-0.326-0.184-0.452-0.281
						c0.109,0.024,0.255,0.027,0.388,0.04c0.166,0.017,0.343,0.045,0.516,0.12C30.259,48.335,29.742,48.354,29.688,48.346z"/>
					<path d="M28.843,48.194c-0.18-0.021-0.359-0.037-0.542-0.058c-0.011-0.003-0.024-0.003-0.039-0.003
						c-0.083-0.058-0.2-0.136-0.28-0.189l-0.006-0.069c0.047,0.023,0.122,0.044,0.208,0.058C28.375,47.97,28.521,48.008,28.843,48.194z"
						/>
					<path d="M25.825,43.324c0.075-0.003,0.127,0.006,0.167,0.02c0.165,0.043,0.152,0.106,0.306,0.155
						c0.202,0.063,0.537,0.098,0.733,0.166c0.209,0.068,0.342,0.149,0.472,0.225c-0.386-0.104-0.658-0.127-1.111-0.101
						c-0.269,0.018-0.513,0.009-0.865-0.083c-0.02-0.007-0.047-0.015-0.067-0.021c0.05-0.12,0.103-0.184,0.575-0.095
						C26,43.502,25.779,43.419,25.825,43.324z"/>
					<path d="M27.477,44.603c-0.118,0.027-0.168,0.036-0.254,0.027c-0.041-0.006-0.132-0.017-0.315-0.103
						c-0.1-0.053-0.189-0.107-0.271-0.161C26.934,44.383,27.194,44.412,27.477,44.603z"/>
					<path d="M25.426,45.276c-0.077-0.014-0.116-0.031-0.15-0.052c-0.015-0.009-0.03-0.015-0.042-0.02
						c-0.025-0.018-0.062-0.038-0.084-0.052c0.02-0.009,0.032-0.018,0.037-0.029c0.047-0.034,0.119-0.068,0.267-0.008
						C25.796,45.26,25.432,45.276,25.426,45.276z"/>
					<path d="M25.329,43.82c-0.143-0.017-0.209-0.048-0.286-0.08c-0.112-0.046-0.305-0.19-0.28-0.238
						c0.04-0.061,0.442,0.006,0.448,0.009C25.225,43.511,25.659,43.849,25.329,43.82z"/>
					<path d="M24.735,42.648c-0.172-0.089-0.3-0.184-0.418-0.275c0.11,0,0.098-0.028,0.135-0.043
						c0.075-0.034,0.24,0.012,0.24,0.012c0.25,0.135,0.457,0.327,0.65,0.465C25.122,42.787,24.978,42.77,24.735,42.648z"/>
					<path d="M24.612,46.244c-0.046-0.022-0.092-0.049-0.127-0.072c0.059,0.016,0.143,0.029,0.231,0.037
						c0.218,0.007,0.356,0.058,0.508,0.204C25.089,46.405,24.88,46.379,24.612,46.244z"/>
					<path d="M24.556,48.634c-0.186-0.029-0.552-0.207-0.656-0.259c-0.013-0.009-0.022-0.011-0.03-0.018
						c-0.024-0.012-0.047-0.022-0.073-0.034c0.262,0.015,0.471,0.052,0.721,0.184C24.784,48.645,24.556,48.634,24.556,48.634z"/>
					<polygon points="24.981,46.698 24.906,46.525 25.449,46.824 25.237,46.801 "/>
					<path d="M25.199,48.708l-0.221-0.026c-0.019-0.008-0.033-0.02-0.053-0.025c-0.16-0.08-0.224-0.141-0.157-0.155
						C24.777,48.501,25.169,48.507,25.199,48.708z"/>
					<path d="M26.109,48.587c0.185,0.133,0.227,0.201-0.082,0.176c0,0-0.604-0.101-0.682-0.129
						C25.192,48.576,25.844,48.569,26.109,48.587z"/>
					<path d="M26.191,48.516c0.879,0.129,1.188,0.29,1.19,0.292c0.022,0.016-0.005,0.09-0.323,0.055
						c-0.067-0.005-0.283-0.034-0.534-0.148C26.381,48.65,26.28,48.585,26.191,48.516z"/>
					<path d="M25.891,41.781l-0.799-0.077l-1.34-0.135l-2.173-0.225c0.758,0.004,1.765,0.007,2.517,0.007
						c0.012,0.077,0.03,0.181,0.041,0.258l1.2,0.117c0.141-0.057,0.325-0.134,0.462-0.194c0.077,0.08,0.177,0.187,0.252,0.265
						L25.891,41.781z"/>
					<path d="M12.622,44.498c-0.491-0.08-1.136-0.1-1.586-0.198c-0.675-0.146-0.989-0.33-1.047-0.364
						c-0.062-0.043-0.121-0.098-0.05-0.138c0.175,0.006,0.249,0.046,0.415,0.051c0.189,0.013,0.363-0.017,0.55-0.011
						c0.055,0.006,0.129,0.009,0.178,0.011c0.122,0.007,0.279,0.021,0.391,0.032c0.739,0.083,1.374,0.198,2.044,0.302
						c-0.015-0.009-0.02-0.028-0.015-0.038c0.003,0,0.704,0.222,0.76,0.359c-0.317-0.022-0.574-0.074-0.869-0.115
						c-0.823,0.139,0.073,0.437,0.33,0.491c0.248,0.05,0.593,0.009,0.866,0.04c0.955,0.112,1.822,0.262,2.783,0.368
						c0.051,0.006,0.126,0.015,0.176,0.02c0.176,0.021,0.351,0.037,0.531,0.052c0.787,0.074,1.459,0.196,2.245,0.271
						c0.233,0.018,0.328,0.022,0.555-0.018c0.141-0.022,0.28-0.046,0.471-0.012c0.386,0.075,0.877,0.316,0.88,0.322
						c0.122,0.077-0.11,0.155-0.024,0.235c-0.528-0.133-0.85-0.155-1.371-0.152c-0.437,0-0.817,0-2.3-0.206
						c-1.23-0.176-2.533-0.316-3.779-0.479c-0.224,0.011-0.264,0.12-0.537,0.085c-0.464-0.057-0.744-0.16-1.154-0.234
						c-0.254-0.041-0.609-0.013-0.863-0.061c-0.169-0.031-0.37-0.12-0.44-0.159c-0.013-0.005-0.944-0.477,0.532-0.24
						c0.579,0.092,0.636,0.052,0.688,0.022C12.98,44.731,13.18,44.596,12.622,44.498z"/>
					<polygon points="8.117,45.205 7.979,45.256 7.74,44.998 "/>
					<path d="M7.734,44.584c-0.092-0.018-0.132-0.036-0.174-0.057c-0.045-0.023-0.083-0.05-0.118-0.074
						c0.038-0.018,0.095-0.041,0.135-0.055l0.03,0.014c0.006,0.003,0.015,0.006,0.021,0.012c0.05,0.029,0.092,0.054,0.127,0.083
						C7.812,44.556,7.829,44.596,7.734,44.584z"/>
					<path d="M7.393,43.74c-0.036-0.012-0.073-0.028-0.101-0.041c0.375-0.042,0.741-0.079,1.268,0.016
						c0.262,0.048,0.262,0.048,0.593,0.33c-0.195-0.037-0.652-0.098-0.744-0.104C8.112,43.921,7.779,43.881,7.393,43.74z"/>
					<path d="M9.288,43.987c-0.254-0.155-0.235-0.179-0.153-0.189c0.07-0.012,0.056-0.028,0.047-0.041
						c0.079,0.05,0.179,0.099,0.204,0.155c0.013,0.023-0.106,0.044-0.104,0.069C9.282,43.984,9.288,43.987,9.288,43.987z"/>
					<path d="M9.45,45.325c0.013,0.012,0.022,0.089-0.319,0.043c-0.176-0.029-0.333-0.077-0.478-0.146
						c-0.004-0.006-0.02-0.012-0.031-0.017C8.864,45.202,9.26,45.193,9.45,45.325z"/>
					<path d="M7.714,41.902c-0.198-0.026-0.207-0.115-0.318-0.16c-0.183-0.07-0.437-0.133-0.606-0.207
						c-0.578-0.247-0.458-0.456,1.034-0.098c0.544,0.132,0.701,0.16,0.81,0.149c0.248,0.114,0.571,0.229,0.897,0.339
						c0.013-0.058,0.022-0.115,0.083-0.173c0.307-0.272,1.166,0.086,1.489,0.218c-0.053-0.042-0.169-0.085-0.096-0.132
						c0,0,0.135-0.078,0.798,0.145c0.265,0.086,0.396,0.131,0.695,0.184c0.414,0.074,0.972,0.06,1.397,0.131
						c0.05,0.003,0.109,0.019,0.146,0.023c0.472,0.102,0.782,0.244,1.077,0.385C14.663,42.706,13.438,42.706,7.714,41.902z"/>
					<path d="M5.8,41.596c-0.167,0.146-1.298-0.296-1.938-0.581c-0.029-0.014-0.075-0.031-0.104-0.043
						c0.162,0.026,0.646,0.121,1.073,0.121c0.184,0.006,0.739,0.008,1.414,0.167c0.114,0.022,0.099,0.079,0.139,0.113
						c0.059,0.05,0.165,0.115,0.251,0.159c0.16,0.084,0.533,0.138,0.564,0.238c0,0-0.006,0.045-0.236,0.017
						c-0.307-0.058-0.515-0.12-1.216-0.378C5.792,41.472,5.877,41.532,5.8,41.596z"/>
					<path d="M6.08,44.814c-0.076,0.04-0.149,0.034-0.227,0.026c-0.056-0.016-0.197-0.038-0.491-0.199
						c-0.022-0.005-0.034-0.018-0.053-0.022c0.031,0.005,0.062,0.011,0.092,0.02c0.218,0.043,0.244,0.015,0.237-0.031
						C5.772,44.671,5.948,44.752,6.08,44.814z"/>
					<path d="M2.525,44.188c0.167,0.008,0.126,0.051,0.167,0.074c0.008,0.003,0.014,0.006,0.02,0.012
						c0.137,0.077,0.251,0.158,0.313,0.241c0.006,0.003,0.01,0.009,0.013,0.012C2.692,44.331,2.5,44.202,2.525,44.188z"/>
					<path d="M2.439,44.412c-0.143-0.029-0.316-0.115-0.411-0.166c-0.087-0.052-0.166-0.099-0.241-0.149
						c0.207,0.068,0.235,0.058,0.293,0.037c0.079-0.021,0.253,0.011,0.408,0.17C2.531,44.344,2.608,44.436,2.439,44.412z"/>
					<path d="M2.835,44.191c0.019-0.009,0.491,0.003,0.755,0.29c0.07,0.08-0.062,0.061-0.132,0.048
						c-0.094-0.017-0.191-0.036-0.286-0.048C3.049,44.458,2.83,44.191,2.835,44.191z"/>
					<path d="M3.024,40.501c-0.275-0.074-0.347-0.213-0.494-0.305c0.029,0.032,0.093,0.101,0.019,0.129
						c-0.084,0.026-0.281-0.002-0.534-0.14c-0.114-0.058-0.2-0.12-0.284-0.185c0.607,0.007,1.192,0.058,1.816,0.049
						c0.227,0.118,0.742,0.411,0.653,0.469c-0.208-0.078-0.347-0.084-0.504-0.018C3.523,40.569,3.296,40.569,3.024,40.501z"/>
					<path d="M1.374,40.317c-0.233-0.103-0.341-0.123-0.513-0.132c-0.272-0.015-0.272-0.015-0.396-0.075
						c-0.069-0.034-0.116-0.065-0.162-0.098c0.242,0.006,0.3,0.069,0.5,0.087c0.279,0.025-0.136-0.139-0.315-0.207
						c0.257-0.029,0.118-0.086,0.201-0.13c0.11-0.054,0.344,0.078,0.765,0.348c-0.05-0.009-0.105-0.021-0.18-0.025
						C1.196,40.104,1.192,40.134,1.374,40.317z"/>
					<polygon points="1.277,39.933 1.463,39.961 1.734,40.156 1.548,40.128 "/>
					<path d="M9.509,41.081c0.095-0.055,0.277-0.149,1.219,0.006c0.022-0.018,0.034-0.041,0.058-0.063
						c0.17-0.139,1.051-0.346,3.024,0.361c0.007-0.021,0.013-0.041,0.046-0.058c0.109-0.055,0.31,0.105,0.419,0.192
						c-0.906-0.037-1.761,0.111-2.674,0.043c-0.283-0.022-0.892-0.104-1.812-0.391C9.706,41.145,9.595,41.11,9.509,41.081z"/>
					<polygon points="15.809,44.475 16.125,44.513 16.404,44.705 16.086,44.665 "/>
					<path d="M17.041,44.545c0.106,0.077,0.238,0.148,0.416,0.218c0.08,0.034,0.19,0.06,0.217,0.098
						c0,0,0.016,0.052-0.106,0.04c-0.565-0.08-0.647-0.242-1.093-0.342c-0.007-0.003-0.025-0.003-0.028-0.009
						c0,0-0.043-0.043,0.051-0.034c0.175,0.022,0.254,0.063,0.402,0.089C17.094,44.639,17.061,44.584,17.041,44.545z"/>
					<path d="M17.908,44.733c0.119-0.037,0.389,0.115,0.386,0.121c0.01,0.04-0.125,0.086-0.175,0.12
						C17.85,44.831,17.85,44.752,17.908,44.733z"/>
					<path d="M22.052,43.41c-0.224-0.063-0.184-0.153-0.334-0.222c-0.141-0.068-0.351-0.126-0.533-0.184
						c0.039,0.04,0.098,0.101,0.033,0.104c-0.261,0.022-0.224-0.077-0.479-0.069c-0.087,0.095,0.233,0.19,0.018,0.288
						c-0.018,0.005-0.049,0.011-0.073,0.017c-0.221-0.126-0.464-0.253-0.639-0.382c0.218,0.046,0.224,0.046,0.353,0.046
						c0.024-0.166-0.442-0.302-0.545-0.462c0.292,0.123,0.451,0.166,0.705,0.2c0.319,0.028,0.624-0.042,0.942-0.006
						c0.249,0.034,0.414,0.081,0.699,0.21c-0.17,0.055-0.192,0.061,0.085,0.23c0.13,0.076,0.38,0.146,0.34,0.232
						C22.581,43.508,22.061,43.413,22.052,43.41z"/>
					<polygon points="22.868,44.986 23.145,45.182 22.896,45.153 22.618,44.961 "/>
					<path d="M23.106,48.398c-0.041-0.018-0.088-0.047-0.164-0.032c-0.108,0.02-0.033,0.054-0.083,0.077
						c-0.015,0.013-0.047,0.015-0.192-0.058c-0.129-0.063-0.132-0.068-0.07-0.1C22.635,48.263,22.792,48.202,23.106,48.398z"/>
					<polygon points="20.889,48.194 20.675,48.165 20.412,47.99 20.628,48.019 "/>
					<polygon points="13.509,47.293 13.803,47.335 14.092,47.524 13.803,47.484 "/>
					<polygon points="13.706,47.474 13.515,47.444 13.219,47.249 13.417,47.277 "/>
					<path d="M13.091,47.396c-0.046-0.006-0.088-0.014-0.122-0.025c-0.231-0.066-0.201-0.187-0.271-0.271
						c0.161,0.081,0.317,0.155,0.424,0.235C13.216,47.41,13.128,47.401,13.091,47.396z"/>
					<path d="M12.329,47.348l-0.174-0.026l-0.027-0.015c-0.212-0.108-0.247-0.16-0.199-0.173
						C11.928,47.134,12.192,47.131,12.329,47.348z"/>
					<path d="M10.422,47.134c-0.072,0.052-0.271-0.011-0.854-0.194C9.543,46.934,9.52,46.922,9.5,46.919
						C9.617,46.778,10.05,47.076,10.422,47.134z"/>
					<polygon points="10.251,46.963 10.528,47.002 10.792,47.181 10.513,47.134 "/>
					<path d="M9.848,50.327c0.312-0.08,1.012,0.354,1.015,0.363c0,0-0.081,0.082-0.365,0.034
						c-0.096-0.021-0.323-0.063-0.722-0.274c-0.079-0.042-0.149-0.082-0.224-0.123C9.677,50.356,9.736,50.351,9.848,50.327z"/>
					<path d="M22.902,52.039c-0.284-0.046-0.55-0.154-0.724-0.241c-0.033-0.018-0.081-0.04-0.115-0.06
						c0.096,0.024,0.342,0.092,0.512,0.048c0.216-0.055,0.483,0.083,0.49,0.086C23.065,51.872,23.351,52.091,22.902,52.039z"/>
					<polygon points="20.941,51.795 21.113,51.82 21.417,52.011 21.235,51.984 "/>
					<path d="M21.321,51.563c0.226,0.126,0.494,0.247,0.673,0.376l-0.297-0.037
						C21.143,51.563,21.275,51.563,21.321,51.563z"/>
					<path d="M37.906,41.179c0.505,0.201,0.53,0.434,0.879,0.643c-0.127-0.011-0.282-0.021-0.508-0.132
						C37.917,41.521,37.578,41.167,37.906,41.179z"/>
					<path d="M39.9,41.756c-0.69-0.126-0.755-0.503-0.624-0.551c0.533,0.129,1.139,0.238,1.633,0.375
						c-0.227-0.097-0.227-0.097-0.204-0.27c0.149-0.006,0.215,0.003,0.431,0.158c0.067,0.054,0.135,0.104,0.258,0.152
						c0.024,0,0.05,0.003,0.075,0.006c-0.325-0.385-0.325-0.385-0.21-0.435c2.843,0.276,2.843,0.276,3.297,0.181
						c-0.2-0.079-0.2-0.079-0.626-0.151c-0.629-0.101-0.923-0.365-0.043-0.327c1.08,0.043,1.889,0.272,1.839,0.399
						c-0.073,0.221,0.896,0.224,0.909,0.227c0.163-0.072,0.174-0.077,0.23-0.244c0.076-0.241,0.129-0.252,0.415-0.291
						c1.559,0.642,1.559,0.642,1.948,0.736c0.029,0,0.059-0.003,0.083-0.003c0.073-0.092-0.308-0.17-0.083-0.259
						c0.026,0,0.071,0,0.098,0.006c0.683,0.098,1.231,0.241,1.932,0.339c0.675,0.098,1.548,0.105,2.093,0.259
						c0.875,0.241,1.053,0.479,0.383,0.517c-0.326,0.021-0.623,0.006-1.147-0.037c-0.016,0-2.254-0.175-3.999-0.204
						c-0.122,0.074,0.115,0.155-0.073,0.229c-0.013,0-0.634-0.014-1.271-0.155c0,0.013,0,0.029-0.005,0.041
						c-0.025,0.085-0.16,0.092-0.201,0.098c-0.095,0.003-0.095,0.003-1.023-0.149c-0.351-0.058-0.539-0.066-0.892,0.086
						c-0.162,0.071-0.342,0.149-0.616,0.138c-0.504-0.025-0.709-0.149-1.179-0.184c-0.731-0.053-1.518-0.012-2.237-0.074
						c-0.314-0.029-0.908-0.081-1.748-0.279c-0.092-0.022-0.207-0.051-0.294-0.074c0.257-0.102,0.395-0.155,0.948-0.009
						C39.882,41.926,39.916,41.842,39.9,41.756z"/>
					<path d="M43.418,41.202c-1.08-0.081-1.08-0.081-1.351-0.196c-0.064-0.031-0.126-0.063-0.181-0.097
						c-0.337-0.201,0.221-0.144,0.86-0.075c0.062,0.007,0.113-0.006,0.168-0.003C43.065,40.943,43.268,41.09,43.418,41.202z"/>
					<path d="M56.391,41.8c0.283,0.108,0.625,0.298,0.264,0.28c-0.065-0.006-0.116-0.011-0.165-0.022
						c-0.012,0-0.022-0.003-0.041-0.006C56.431,41.978,56.408,41.874,56.391,41.8z"/>
					<path d="M68.857,42.426c0.583-0.047,0.718-0.055,1.271-0.029c0.679,0.029,1.594,0.108,2.194,0.16
						c3.007,0.262,3.007,0.262,3.891,0.155c0.246-0.034,0.246-0.034,1.756,0.121c0.258,0.025,0.542,0.046,0.825,0.063
						c3.641,0.138,3.641,0.138,4.761,0.345c-0.2,0.247-0.578,0.305-2.434,0.181c-0.925-0.063-1.879-0.129-2.033,0.023
						c0.053,0.015,0.118,0.034,0.188,0.049c0.319,0.049,0.672-0.083,0.955-0.003c0.301,0.083,0.141,0.272,0.813,0.267
						c0.19-0.005,0.254,0,0.425,0.052c-0.465,0.05-1.238,0.129-2.828,0.053c-1.391-0.069-2.711-0.193-4.079-0.265
						c-3.172-0.173-6.473-0.178-9.625-0.374c-1.079-0.063-1.079-0.063-2.121-0.333c-0.726-0.068-1.622-0.063-2.158-0.224
						c-0.047,0.315-0.047,0.315-0.437,0.305c-0.354-0.253-1.138-0.46-1.65-0.689c-0.013,0.017-0.019,0.046-0.047,0.063
						c-0.201,0.16-0.69,0.028-1.049-0.133c-0.206-0.092-0.359-0.189-0.513-0.286c0.319-0.029,0.849-0.081,1.774-0.05
						c1.726,0.061,3.294,0.256,5.028,0.313c0.966,0.034,2.003-0.141,2.94,0.04C68.066,42.491,68.066,42.491,68.857,42.426z"/>
					<path d="M119.363,45.521c-0.167-0.095-0.207-0.126-0.159-0.189c0.165,0.006,0.389,0.018,0.554,0.023
						c0.377,0.224,0.319,0.286,0.034,0.355c-0.194,0.046-0.283,0.074-0.252,0.161c0.112-0.012,0.159,0.011,0.218,0.028
						c0.16,0.037,0.771,0.247,0.342,0.247c-0.129-0.087-0.501-0.121-0.719-0.187c-0.166-0.05-0.166-0.05-0.395-0.382
						c0.254,0.022,0.429,0.031,0.454,0.003C119.463,45.559,119.399,45.538,119.363,45.521z"/>
					<path d="M120.996,45.621c0.116,0.031,0.211,0.135-0.013,0.126c-0.07-0.002-0.165-0.008-0.412-0.092
						c-0.023-0.005-0.036-0.012-0.047-0.015C120.707,45.59,120.866,45.583,120.996,45.621z"/>
					<path d="M111.812,44.59c0.565,0.296,2.169,0.4,2.583,0.718c-1.204-0.058-2.153,0.302-3.432,0.109
						c-0.019,0.098-0.029,0.181-0.496,0.201c-0.718,0.025-1.26-0.08-1.89-0.127c-0.767-0.058-1.344,0.092-2.059,0.099
						c-0.965,0.006-2.339-0.081-2.886-0.118c-1.793-0.13-2.287-0.106-2.678-0.075c-1.498-0.623-2.604-0.307-2.617-0.301
						c-1.33-0.281-1.861-0.253-3.454-0.166c-0.277-0.153-0.442-0.162-0.742-0.146c-0.165-0.044-0.106-0.102-0.218-0.146
						c-1.409,0.028-1.444-0.316-2.221-0.458c-0.648,0.204-1.416,0.159-2.099-0.129c-0.053-0.022-0.118-0.052-0.165-0.073
						c1.992,0.103,2.587,0.131,2.534-0.303c-1.143,0.028-1.143,0.028-1.509-0.163c1.049-0.003,2.01,0.172,3.1,0.078
						c0.744,0.231,1.179,0.255,1.451,0.068c0.329,0.204,0.437,0.212,0.801,0.175c2.387-0.27,3.512,0.074,3.996,0.218
						c0.235-0.073,0.767-0.097,0.743-0.218c0.271,0.084,0.153,0.207,0.554,0.281c0.437,0.075,0.979,0.058,1.48,0.081
						c2.493,0.097,3,0.092,6.944,0.042C110.269,44.603,111.447,44.711,111.812,44.59z"/>
					<path d="M101.633,46.626l-0.548-0.025c-0.372-0.271-0.106-0.259,0.17-0.245
						C101.367,46.437,101.521,46.549,101.633,46.626z"/>
					<path d="M100.744,46.586c-0.86-0.043-0.86-0.043-0.966-0.086c-0.118-0.046-0.161-0.095-0.207-0.147
						C100.001,46.376,100.354,46.423,100.744,46.586z"/>
					<path d="M83.792,40.596c-0.172-0.012-0.402-0.037-0.66-0.158c-0.049-0.021-0.083-0.039-0.119-0.06
						C83.544,40.433,83.62,40.438,83.792,40.596z"/>
					<path d="M83.539,43.921c-0.619,0.066-0.619,0.066-0.867,0.056c-0.095-0.007-0.376-0.023-0.653-0.145
						c-0.053-0.025-0.101-0.049-0.148-0.075c0.294-0.123,0.442-0.184,1.038-0.126C83.485,43.688,83.343,43.823,83.539,43.921z"/>
					<path d="M122.438,46.06c0.148-0.063,0.608-0.06,0.885,0.128c-0.289-0.007-0.289,0.089-0.572,0.079
						c-0.083,0-0.176-0.008-0.242-0.017C122.38,46.229,122.315,46.109,122.438,46.06z"/>
					<path d="M138.442,40.656c0.389,0.13,0.672,0.305,0.207,0.295c-0.083-0.002-0.16-0.011-0.22-0.02
						c-0.021,0-0.04-0.006-0.046-0.006C138.395,40.843,138.419,40.736,138.442,40.656z"/>
					<polygon points="137.175,40.61 137.415,40.802 136.787,40.776 136.544,40.587 "/>
					<path d="M133.161,45.727c0.776,0.035,1.59,0.019,2.344,0.075c0.131,0.012,0.308,0.023,0.431,0.035
						c1.197,0.094,2.188,0.283,3.413,0.367c0.442,0.028,0.92-0.017,1.351,0.034c0.482,0.06,0.688,0.178,0.891,0.293
						c-3.008,0.025-5.861-0.428-8.942-0.146c0.629,0.106,0.913,0.284,1.513,0.399c-1.731,0.012-3.193-0.33-5.021-0.189
						c-0.296-0.087-0.684-0.207-0.978-0.293c-0.012,0.051-0.036,0.121-0.165,0.132c-0.342,0.037-0.661-0.028-0.997-0.011
						c-0.207-0.408-0.207-0.408-0.96-0.563c0.083,0.092-0.343,0.169-0.143,0.265c0.484,0.04,0.632,0.215,0.672,0.287
						c-0.541,0.071-0.63-0.145-0.972-0.207c-0.748,0.339-3.813-0.546-3.943-0.583c-0.118-0.031-0.271-0.083-0.39-0.117
						c1.049-0.07,2.188-0.023,3.219-0.121c0.755-0.075,0.802-0.099,1.237-0.313c0.083,0.058,0.183,0.133,0.259,0.187
						c0.202,0.026,0.402,0.047,0.615,0.058c0.883,0.025,1.78-0.029,2.663,0.023C130.661,45.414,131.74,45.658,133.161,45.727z"/>
					<path d="M3.131,49.11c-0.158-0.08-0.096-0.178-0.209-0.265c0.2,0.127,0.402,0.255,0.652,0.383
						C3.45,49.185,3.226,49.159,3.131,49.11z"/>
					<path d="M7.618,50.023c-0.021-0.006-0.055-0.012-0.083-0.018c-0.016,0.083,0.197,0.155,0.267,0.235
						c-0.017,0-0.037,0.004-0.051,0.006c-0.529-0.154-0.543-0.355-0.968-0.517c0.021,0.022,0.042,0.055,0.047,0.077
						c-0.021,0.006-0.041,0.012-0.062,0.014c-0.025,0-0.062,0-0.083,0c-0.015,0-0.032,0.007-0.043,0.007
						c-0.399-0.146-0.772-0.276-1.375-0.351c-0.887-0.112-1.464-0.379-1.929-0.592c0.363,0.221,0.356,0.225,0.326,0.271
						c-0.022,0-0.049,0.005-0.07,0.005c-0.003,0.006-0.006,0.013-0.015,0.018c-0.427-0.27-1.022-0.525-1.231-0.813
						c0.064,0.037,0.059,0.083,0.229,0.108c-0.014-0.019-0.049-0.042,0.01-0.06c0.371,0.152,0.533,0.33,1.019,0.468
						c-0.242-0.169-0.237-0.181-0.215-0.215c0.082,0.011,0.156,0.017,0.482,0.146c-0.09-0.106-0.099-0.13-0.005-0.146
						c0.324,0.011,0.408,0.092,0.689,0.118c0.021-0.003,0.042-0.006,0.056-0.01c0.019-0.037-0.073-0.074,0.052-0.108
						c0.614,0.089,1.289,0.362,1.421,0.417c0.323,0.134,0.298,0.295,0.574,0.433c0.178,0.089,0.508,0.149,0.75,0.228
						c0.497,0.154,1.129,0.29,1.513,0.462c0.006,0.006,0.475,0.313,0.292,0.365c-0.05-0.004-0.113-0.01-0.157-0.015
						C8.146,50.356,8.146,50.356,7.618,50.023z"/>
					<path d="M748.988,44.699c-0.571,0-0.655,0.106-0.571,0.252c0.437-0.005,0.857-0.014,1.287-0.021
						C749.464,44.852,749.17,44.786,748.988,44.699z"/>
					<path d="M704.777,42.845c-0.089-0.007-0.196-0.012-0.279-0.018c0.083,0.126,0.202,0.321,1.863,0.311
						c-0.177,0.043-0.418,0.068-0.507,0.126c0.182,0.063,0.477,0.101,0.719,0.149c-0.064,0.137-0.248,0.132-0.754,0.051
						c-0.535-0.079-0.896-0.103-1.25-0.068c-0.053,0.272,0.019,0.511,0.26,0.839l4.728,0.049c-0.873-0.155-1.262-0.325-2.004-0.698
						C706.679,43.141,706.102,42.937,704.777,42.845z M705.305,43.729c-0.051-0.017-0.099-0.034-0.141-0.051
						c0.985,0.028,1.35,0.04,1.35,0.209C705.961,43.878,705.606,43.832,705.305,43.729z"/>
					<path d="M43.472,43.439c0.039-0.061,0.1-0.09,0.326-0.084c0.194,0.006,0.343,0.034,0.503,0.058
						c0.366,0.055,0.604,0.061,1.416,0.086c-0.844-0.066-1.961-0.155-2.806-0.219c0.026,0.006,0.052,0.015,0.073,0.021
						C43.132,43.348,43.273,43.401,43.472,43.439z"/>
					<path d="M52.201,44.183c-0.04-0.069-0.117-0.138-0.07-0.206c-0.27-0.019-0.629-0.047-0.897-0.067
						c0.009,0.003,0.021,0.003,0.026,0.007C51.743,43.998,51.922,44.027,52.201,44.183z"/>
					<path d="M112.01,47.232c-0.072-0.007-0.154-0.01-0.224-0.012c0.052,0.018,0.129,0.034,0.168,0.052
						C112.008,47.255,111.995,47.243,112.01,47.232z"/>
					<path d="M85.101,45.975c-0.129,0.011-0.259,0.017-0.39,0.022l0.62,0.034c-0.07-0.017-0.135-0.031-0.207-0.048
						C85.124,45.983,85.106,45.978,85.101,45.975z"/>
					<path d="M1768.022,29.991c0.105-0.053,0.355-0.173,0.129-0.259c-0.324-0.121-0.982-0.146-1.418-0.241
						c-0.049,0.069-0.107,0.167-0.043,0.253C1766.856,29.957,1767.675,29.979,1768.022,29.991z"/>
					<path d="M1764.958,29.761c0.285-0.154-0.043-0.187-0.83-0.27c0.01,0.018,0.016,0.041,0.025,0.058
						C1764.269,29.687,1764.622,29.735,1764.958,29.761z"/>
					<path d="M1055.021,1.459c0.307,0.126,1.158,0.063,1.242-0.034c0.137-0.139-0.404-0.149-1.299-0.167
						C1054.919,1.304,1054.845,1.39,1055.021,1.459z"/>
					<path d="M1722.964,29.802c0.023-0.044,0.08-0.173-0.701-0.235c-0.385-0.023-0.717-0.018-0.986,0.023
						c-0.012,0.036-0.023,0.074,0.037,0.108C1721.515,29.842,1722.415,29.894,1722.964,29.802z"/>
					<path d="M1044.972,2.685c0.098,0.241,0.088,0.371-0.232,0.531c0.039-0.005,0.078-0.011,0.109-0.018
						c1-0.184,1.418-0.533,1.248-1.045C1044.907,2.234,1044.843,2.372,1044.972,2.685z"/>
					<path d="M1711.175,30.87c0.713,0.006,0.484-0.201,0.131-0.282c-0.09-0.022-0.201-0.039-0.318-0.049
						c-0.096-0.009-0.189-0.009-0.279-0.006c-0.066,0.034-0.109,0.066-0.098,0.104c0,0.002,0,0.005,0.012,0.008
						C1710.728,30.732,1711.198,30.767,1711.175,30.87z"/>
					<path d="M1673.345,29.577c-0.021-0.155-0.15-0.163-0.582-0.189c-1.668-0.086-2.139,0.356-2.078,0.396
						c0.309,0.207,0.717,0.391,2.217,0.413C1673.042,29.991,1673.38,29.79,1673.345,29.577z"/>
					<path d="M1667.739,29.569c-0.051-0.331-0.057-0.383-0.627-0.425c-0.381-0.021-0.615,0.1-0.486,0.191
						C1666.669,29.365,1666.896,29.509,1667.739,29.569z"/>
					<path d="M1080.712,6.372c0.035,0,0.078-0.003,0.113-0.003c1.578-0.069,1.625-0.431,1.637-0.546
						c-0.682-0.022-1.037-0.08-1.295-0.224c-0.566,0.037-0.535,0.189-0.443,0.437C1080.79,6.197,1080.813,6.283,1080.712,6.372z"/>
					<path d="M1662.901,29.848c0.012,0.005,0.035,0.009,0.047,0.015c0.402,0.123,1.051,0.157,1.369,0.169
						c0.057-0.08,0.146-0.189,0.211-0.271c-0.283,0.018-0.486-0.028-0.736-0.045C1662.638,29.644,1662.878,29.825,1662.901,29.848z"/>
					<path d="M1574.815,25.195c0.076-0.114,0.176-0.268,0.246-0.379c0.236,0.098,0.455,0.179,0.992,0.224
						c0.879,0.075,1.838,0.015,2.711,0.087c-0.166-0.322-0.383-0.322-1.422-0.189c-0.244-0.193-0.551-0.276-1.215-0.322
						c-1.318-0.058-2.393,0.196-2.066,0.394C1574.208,25.104,1574.606,25.161,1574.815,25.195z"/>
					<path d="M1056.571,5.835c-0.393-0.005-0.916-0.018-1.314-0.028l-0.008,0.398c0.014,0,0.029,0.003,0.039,0.003
						C1055.741,6.231,1056.767,6.242,1056.571,5.835z"/>
					<path d="M1660.298,29.882c0.01,0,0.027,0,0.047-0.003c0.205-0.014,0.67-0.074,0.473-0.255
						c-0.061-0.013-0.127-0.018-0.189-0.023c-0.525-0.023-0.525,0.16-1.043,0.135c0,0.02,0.006,0.038,0.029,0.058
						C1659.677,29.848,1659.89,29.899,1660.298,29.882z"/>
					<path d="M1054.597,6.622c0.26,0.184,0.307,0.264,0.15,0.447c0.033,0,0.072-0.005,0.098-0.011
						c0.896-0.126,1.129,0.065,1.213,0.138c1.875-0.144,0.721-0.522-0.402-0.884c-0.389-0.013-0.914-0.023-1.307-0.032
						C1054.343,6.412,1054.378,6.462,1054.597,6.622z M1055.243,6.702l0.826,0.018v0.189l-0.83-0.018L1055.243,6.702z"/>
					<polygon points="1564.489,24.639 1563.353,24.578 1563.224,24.775 1564.366,24.839 "/>
					<path d="M1071.337,6.96c-0.436-0.034-0.68-0.056-0.781-0.131l-0.422,0.385l1.721,0.039
						C1072.233,7.064,1072.011,7.013,1071.337,6.96z"/>
					<path d="M1510.165,22.548c0,0,0.02,0,0.025,0.003c0.691,0.055,1.152,0.003,1.305-0.015
						c0.506-0.061,0.764-0.089,1.49,0.058c0.082-0.138-0.738-0.25-1.525-0.293C1510.429,22.258,1509.993,22.341,1510.165,22.548z"/>
					<path d="M1626.737,29.106c-0.117-0.092-0.117-0.138-0.098-0.218c0.049-0.087,0-0.155-0.316-0.294
						c-0.637,0.026-0.695,0.236-0.543,0.351C1625.97,29.084,1626.392,29.118,1626.737,29.106z"/>
					<path d="M1575.044,25.993c-0.053-0.005-0.119-0.011-0.166-0.011c-0.729-0.038-1.07,0.029-1.143,0.224
						c0,0,0.018,0,0.023,0C1574.368,26.243,1574.95,26.24,1575.044,25.993z"/>
					<path d="M1541.567,24.374c0.088-0.04,0.119-0.092,0.143-0.141c-0.656-0.031-1.299-0.065-1.953-0.101
						c0,0.035,0.031,0.066,0.063,0.095C1540.114,24.414,1541.175,24.569,1541.567,24.374z"/>
					<path d="M1572.604,26.143c0.236-0.16-0.213-0.201-0.791-0.232c-0.068-0.003-0.16-0.009-0.24-0.014
						c0.018,0.011,0.029,0.022,0.035,0.034C1571.8,26.077,1572.218,26.12,1572.604,26.143z"/>
					<path d="M1538.585,24.747c-0.688-0.281-0.779-0.35-0.834-0.619c-0.469-0.023-1.107-0.058-1.578-0.081
						c-0.043,0.068-0.123,0.23,0.086,0.38C1536.649,24.689,1537.769,24.736,1538.585,24.747z"/>
					<path d="M1498.788,22.24c-0.084-0.043-0.084-0.043-0.361-0.058c-0.773-0.031-1.102,0.067-1.125,0.342
						c0.014,0,0.029,0.006,0.047,0.006C1498.431,22.638,1499.106,22.415,1498.788,22.24z"/>
					<path d="M1060.868,8.589c0.037-0.249-0.836-0.283-1.014-0.29c-0.314-0.003-0.496,0.012-0.701,0.046
						c0.008,0.029,0.041,0.055,0.082,0.081c0.006,0.003,0.018,0.006,0.029,0.011C1059.495,8.534,1059.96,8.581,1060.868,8.589z"/>
					<path d="M1522.151,25.658c-0.107-0.061-0.236-0.144-0.33-0.204l-0.732-0.034c-0.059,0.025-0.135,0.074-0.064,0.114
						C1521.099,25.585,1521.099,25.585,1522.151,25.658z"/>
					<path d="M1511.093,25.305c-0.059,0.132-0.566,0.225-0.578,0.358c0.037-0.003,0.084-0.005,0.119-0.008
						c0.691-0.063,1.197-0.052,1.779-0.034c0.426,0.011,0.639,0.008,0.896-0.01c-0.211-0.152-0.725-0.235-1.814-0.289
						C1511.354,25.311,1511.222,25.308,1511.093,25.305z"/>
					<path d="M1506.942,25.37c-1.082-0.111-2.273-0.149-3.395-0.232c0.15,0.099,0.246,0.161,0.309,0.331
						c0.021,0.065,0.045,0.135,0.168,0.194c0.174,0.09,0.504,0.152,0.787,0.21c0.896-0.12,0.959-0.109,1.748,0.021
						c0.611,0.1,1.027,0.118,1.377,0.129c0.35-0.155,0.434-0.241,0.344-0.359c-0.018-0.014-0.031-0.025-0.051-0.037
						C1508.065,25.546,1507.839,25.462,1506.942,25.37z"/>
					<path d="M1513.157,26.758c0.422,0.037,0.777-0.052,1.201-0.034c-0.082-0.064-0.188-0.149-0.266-0.214
						c-0.588,0.026-0.854,0.096-0.949,0.248C1513.144,26.758,1513.157,26.761,1513.157,26.758z"/>
					<path d="M1396.907,22.077c0.088-0.003,0.203-0.006,0.289-0.006c1.137-0.031,2.32,0.135,3.432-0.046
						c0.197-0.322-1.252-0.367-1.818-0.554c-1.035,0.181-1.203,0.209-2.119,0.113c-0.213,0.13-0.158,0.176,0.086,0.279
						C1396.995,21.956,1396.987,21.996,1396.907,22.077z"/>
					<path d="M1392.843,21.808c-0.055-0.006-0.115-0.012-0.178-0.012c-0.604-0.023-0.639,0.095-0.693,0.272
						c0.246-0.021,0.568-0.043,0.805-0.063L1392.843,21.808z"/>
					<path d="M1394.979,22.95c0.99-0.179,0-0.454-0.908-0.498c-0.635-0.019-0.9,0.07-1.049,0.142
						c0.02,0,0.035,0.005,0.053,0.012C1394.321,22.921,1394.321,22.921,1394.979,22.95z"/>
					<path d="M1390.101,22.74c0.109,0.037,0.109,0.037,1.613,0.078c-0.094-0.136-0.426-0.207-1.148-0.236
						c-0.154-0.008-0.301-0.012-0.453-0.012C1390.052,22.614,1389.944,22.688,1390.101,22.74z"/>
					<path d="M1398.005,23.68c1.123,0.02,2.188-0.075,3.293-0.083c-1.031-0.142-1.916-0.216-2.869-0.259
						c-1.209-0.043-2.057-0.009-2.846,0.117c0.08,0.018,0.201,0.034,0.281,0.047C1396.933,23.659,1397.601,23.673,1398.005,23.68z"/>
					<path d="M1389.849,23.622c0.668,0.063,1.076,0.04,1.436,0.017c0.412-0.028,0.582-0.028,0.939-0.02
						c-0.027-0.078-0.701-0.146-1.359-0.175c-0.906-0.032-1.277,0.025-1.104,0.168C1389.778,23.615,1389.815,23.619,1389.849,23.622z"/>
					<polygon points="1023.397,13.496 1023.394,13.307 1022.497,13.29 1022.503,13.479 "/>
					<path d="M1325.771,22.563c0.047-0.043-0.033-0.09-0.07-0.112c-0.584-0.012-1.129,0.074-1.715,0.035
						c-0.018,0.017-0.006,0.037,0.031,0.051C1324.286,22.648,1325.618,22.692,1325.771,22.563z"/>
					<path d="M1242.183,21.322c0.607-0.055,0.615-0.248,0.615-0.33c0.01-0.309-0.475-0.598-0.584-0.903
						c-0.508,0.312-0.328,0.911-0.174,1.241C1242.079,21.327,1242.14,21.325,1242.183,21.322z"/>
					<polygon points="1253.433,21.401 1253.063,21.187 1252.188,21.271 1252.626,21.472 "/>
					<path d="M1401.212,26.878c-0.02-0.012-0.045-0.028-0.066-0.04c-0.248-0.114-0.549-0.161-1.225-0.195
						c-0.955-0.034-1.936,0.009-2.877-0.052c-0.484,0.115-0.621,0.218-0.604,0.454c0.152-0.052,0.357-0.114,0.508-0.167
						c0.426,0.189,0.848,0.207,1.688,0.179c0.682-0.029,1.004-0.041,1.047,0.118c0.52-0.07,0.957-0.063,1.615-0.026
						C1401.329,27.016,1401.312,26.971,1401.212,26.878z"/>
					<path d="M1289.853,22.656c-0.057-0.034-0.154-0.063-0.246-0.092c-0.57,0.018-0.873,0.099-0.91,0.251
						c0.025,0.003,0.061,0.003,0.086,0.008C1289.911,22.927,1290.089,22.783,1289.853,22.656z"/>
					<path d="M765.096,12.228c-0.028-0.187-0.595-0.265-1.114-0.27c-0.317-0.003-0.525,0.016-0.689,0.057
						c0.01,0.006,0.018,0.012,0.035,0.012C763.699,12.17,764.512,12.21,765.096,12.228z"/>
					<path d="M759.213,12.232c0.182,0.069,0.442,0.087,0.767,0.05c-0.031-0.089-0.066-0.213-0.089-0.305
						c-0.107-0.012-0.224-0.02-0.336-0.022C758.95,11.958,758.996,12.159,759.213,12.232z"/>
					<path d="M1395.55,26.617c-0.381-0.009-0.668,0.065-1.047,0.055c-0.031,0.034-0.09,0.115,0.039,0.188
						c0.178,0.095,0.639,0.145,1.521,0.167c0.119-0.138-0.211-0.264-0.316-0.396C1395.687,26.625,1395.616,26.619,1395.55,26.617z"/>
					<path d="M1385.468,26.731c0.137,0.056,0.412,0.084,0.623,0.095c0.596,0.04,1.221,0.04,1.828,0.063
						c0.16-0.31-1.676-0.224-2.406-0.373C1385.421,26.583,1385.302,26.663,1385.468,26.731z"/>
					<path d="M1321.372,25.152c0.154,0.081,0.637,0.192,1.168,0.167c0.107-0.106-0.033-0.144-0.375-0.192
						c-0.277-0.043-0.383-0.069-0.408-0.129C1321.163,25.012,1321.286,25.108,1321.372,25.152z"/>
					<path d="M1013.44,17.878c1.754-0.021,2.584-0.267,2.465-0.723c-0.746-0.023-1.09-0.074-1.391-0.213
						c-1.32,0.078-1.324,0.438-1.195,0.936C1013.349,17.878,1013.396,17.878,1013.44,17.878z"/>
					<path d="M1232.228,23.237c0.145,0.071,0.547,0.135,0.682,0.04c0.078-0.061,0.023-0.149-0.012-0.201
						C1231.952,23.07,1232.144,23.196,1232.228,23.237z"/>
					<path d="M1316.497,26.345c0.01,0.008,0.057,0.016,0.078,0.022c0.492,0.121,1.377,0.108,2.24,0.087
						c1.889-0.047,2.105,0.017,2.229,0.051c1.197-0.333-1.107-0.517-2.104-0.557C1315.976,25.862,1316.483,26.339,1316.497,26.345z"/>
					<path d="M1282.888,25.127c0.762,0.086,0.781-0.015,0.801-0.104c0.021-0.118,0.066-0.164,0.422-0.155
						c-0.092-0.069-0.199-0.098-0.422-0.109c-0.885-0.02-1.063,0.305-0.873,0.356C1282.827,25.121,1282.864,25.121,1282.888,25.127z"/>
					<path d="M1242.22,23.803c0.092,0.046,0.326,0.111,0.775,0.061c0.109-0.149-0.297-0.267-0.42-0.402
						C1242.159,23.461,1241.933,23.677,1242.22,23.803z"/>
					<path d="M1014.476,18.57c0.064,0.089-0.066,0.219-0.145,0.303c0.043-0.007,0.092-0.018,0.139-0.023
						c0.541-0.092,0.73-0.271,1.451-0.325c0.471-0.034,1.182,0.066,1.447,0.107c-0.354-0.122-0.871-0.222-1.172-0.356
						c-0.201-0.089-0.195-0.188-0.195-0.253c-0.756,0.034-1.338,0.184-2.168,0.167C1014.003,18.32,1014.374,18.433,1014.476,18.57z"/>
					<path d="M1316.075,26.146c-0.371-0.014-0.865-0.031-1.23-0.043l-0.061,0.276c0,0,0.012,0,0.023,0
						C1315.575,26.41,1316.079,26.384,1316.075,26.146z"/>
					<path d="M1311.519,25.988c-0.082-0.006-0.166-0.012-0.246-0.018c-0.473-0.012-0.508,0.041-0.658,0.264
						c0.266-0.017,0.609-0.045,0.871-0.063L1311.519,25.988z"/>
					<path d="M1286.175,25.135c-0.588,0.009-0.604,0.306-0.258,0.377c0.223,0.046,0.465,0.018,0.588,0.005
						c-0.129,0.084-0.307,0.196-0.447,0.279c-0.627-0.164-2.266-0.164-2.279-0.167c-0.443,0.003-0.639-0.008-1.043-0.037
						c0.068,0.143,0.08,0.166-0.238,0.281c-0.33,0.115-0.314,0.139-0.242,0.278c0.043,0,0.096,0.004,0.135,0.007
						c0.531,0.024,0.896,0.14,1.488,0.137c0.129-0.1,0.258-0.135,0.836-0.16c0.637-0.023,0.891-0.049,1.32-0.152
						c0.611,0.003,0.848,0.092,1.025,0.187c0.27,0.141,0.41,0.21,1.037,0.083c-0.141-0.077-0.395-0.135-0.529-0.206
						c0.258-0.078,0.658-0.109,0.988-0.167c0.086-0.184-0.092-0.236-0.848-0.35c-0.713-0.109-0.848-0.185-0.684-0.368
						C1286.774,25.155,1286.431,25.144,1286.175,25.135z"/>
					<path d="M1397.774,29.291c-0.191,0.045-0.787,0.178-0.357,0.396c0.404,0.204,1.959,0.491,3.408,0.299
						c-0.17-0.275-0.646-0.333-1.613-0.396C1398.351,29.535,1397.964,29.479,1397.774,29.291z"/>
					<path d="M1308.548,26.459c0.133-0.112,0.318-0.262,0.459-0.373l-1.234-0.04c-0.109,0.06-0.213,0.131-0.055,0.197
						C1307.919,26.326,1308.419,26.355,1308.548,26.459z"/>
					<path d="M1006.089,19.114c0.041-0.003,0.1-0.007,0.141-0.013c0.566-0.063,0.531-0.171,0.482-0.286
						c-0.059-0.162,0.023-0.245,1.086-0.251c-0.152-0.095-0.369-0.218-0.521-0.313l-1.303-0.022
						C1005.38,18.539,1005.649,18.792,1006.089,19.114z"/>
					<path d="M1290.229,26.832c0.008-0.006,0.084-0.103-0.293-0.12c-0.215-0.006-0.418,0.018-0.68,0.055
						c0.018,0.005,0.043,0.011,0.055,0.014C1289.827,26.947,1290.169,26.907,1290.229,26.832z"/>
					<path d="M1103.103,22.278c0.074,0.034,0.178,0.063,0.283,0.089c0.84-0.018,0.867-0.17,0.639-0.29
						c-0.012-0.006-0.025-0.012-0.037-0.018c-0.059-0.029-0.129-0.052-0.217-0.074C1102.833,22.002,1102.864,22.175,1103.103,22.278z"/>
					<path d="M1286.304,27.269c0.318,0.164,0.93,0.187,1.141,0.195c0.227-0.16-0.195-0.189-1.209-0.241
						C1286.253,27.237,1286.28,27.254,1286.304,27.269z"/>
					<polygon points="1282.077,27.285 1282.933,27.314 1282.962,27.117 1282.108,27.085 "/>
					<path d="M1421.024,32.702c-0.6-0.078-0.982-0.112-1.559-0.139c-1.537-0.051-2.998,0.092-4.514,0.092
						c0.141,0.099,0.258,0.184,0.049,0.432c-0.158,0.184-0.266,0.304,0.061,0.411c0.188,0.06,0.49,0.094,0.775,0.126
						c-0.191-0.066-0.346-0.123-0.26-0.193c0.145-0.105,0.574-0.16,0.848-0.244c0.539,0.047,0.566,0.216,1.154,0.244
						c0.564,0.034,0.738-0.098,0.689-0.137c-0.111-0.095-0.633-0.145-0.588-0.254c0.004-0.022,0.092-0.076,0.691-0.06
						c1.234,0.031,1.234,0.031,1.375-0.037c0.012,0.057,0.049,0.112,0.111,0.167c0.035,0.021,0.066,0.039,0.102,0.063
						c0.258,0.126,0.354,0.158,0.813,0.287c0.508-0.104,0.412-0.161,0.037-0.339C1420.347,32.896,1420.583,32.814,1421.024,32.702z"/>
					<path d="M1231.442,26.567c0.213,0.09,0.715,0.139,1.514,0.149c0.01-0.085,0.018-0.207,0.031-0.292
						c-0.129-0.012-0.26-0.018-0.402-0.023c-0.453-0.008-0.838,0.049-1.26,0.063C1231.337,26.505,1231.358,26.533,1231.442,26.567z"/>
					<path d="M1266.479,27.835c-0.107-0.061-0.248-0.146-0.367-0.21l-0.863-0.028c-0.021,0.034-0.068,0.086,0.033,0.131
						C1265.405,27.78,1265.405,27.78,1266.479,27.835z"/>
					<path d="M1234.544,27.183c0.197,0.098,0.537,0.195,0.885,0.178c0.02-0.08-0.023-0.129-0.201-0.225
						c-0.207-0.113-0.344-0.191-0.156-0.355c-0.059-0.006-0.113-0.009-0.174-0.012C1234.036,26.758,1234.177,27.01,1234.544,27.183z"/>
					<polygon points="1062.872,23.116 1062.048,23.099 1062.071,23.288 1062.882,23.306 "/>
					<path d="M1234.612,27.613c-0.637-0.098-1.449-0.077-2.109-0.152c0.037,0.021,0.082,0.046,0.125,0.063
						c0.27,0.125,0.605,0.162,0.91,0.199c0.51,0.063,0.75,0.104,0.572,0.355C1235.099,28.11,1234.386,27.765,1234.612,27.613z"/>
					<path d="M1225.312,28.005c0.117-0.023,0.275-0.058,0.402-0.081l0.012-0.184l-0.402,0.079l-1.246-0.131
						c-0.217,0.045-0.557,0.117-0.369,0.166C1224.134,27.969,1224.946,27.863,1225.312,28.005z"/>
					<path d="M1280.905,30.091c0.248-0.089,0.414-0.129,1.191-0.048c0.342-0.058,0.217-0.089-0.4-0.115
						c-0.908-0.025-2.006,0.021-1.643,0.155c0.092,0.037,0.238,0.063,0.387,0.092C1280.636,30.169,1280.716,30.158,1280.905,30.091z"/>
					<polygon points="1276.677,29.865 1275.894,29.842 1275.872,30.025 1276.655,30.052 "/>
					<path d="M1225.255,28.957l1.26-0.058c0.012-0.003,0.27-0.471-0.756-0.505c-0.471-0.009-0.885,0.046-1.332,0.063
						C1224.673,28.607,1225.005,28.808,1225.255,28.957z"/>
					<path d="M1051.495,24.914c0.838-0.006,0.502-0.149-0.047-0.391c-0.236,0-0.848,0-0.25,0.271
						C1051.296,24.833,1051.403,24.87,1051.495,24.914z"/>
					<polygon points="975.435,24.679 975.392,24.475 974.501,24.461 974.544,24.661 "/>
					<path d="M1277.657,32.168c0.033,0.034,0.066,0.063,0.135,0.092c0.32,0.132,1.098,0.146,1.545,0.146
						c0.242-0.152-0.012-0.181-0.709-0.207C1278.306,32.19,1277.97,32.196,1277.657,32.168z"/>
					<path d="M975.886,26.625c0.25,0.089,1.135,0.162,1.258,0.029c0.123-0.145-0.178-0.281-0.08-0.42
						c-0.115-0.011-0.234-0.019-0.352-0.022C975.769,26.212,975.546,26.493,975.886,26.625z"/>
					<path d="M1040.013,28.102c0.258,0.101,0.602,0.063,0.756,0.046c-0.014-0.063-0.025-0.143-0.037-0.2l-0.42-0.104
						C1039.815,27.84,1039.767,28.005,1040.013,28.102z"/>
					<path d="M975.976,27.085c0.018,0.012,0.063,0.017,0.088,0.022c0.729,0.146,2.133,0.093,2.031-0.191
						c-0.016-0.032-0.039-0.061-0.082-0.093c-0.18-0.002-0.371-0.008-0.557-0.015C975.386,26.78,975.968,27.085,975.976,27.085z"/>
					<path d="M1038.114,29.721c0.596,0.034,1.064-0.097,1.652-0.063c-0.141-0.253-0.648-0.377-1.77-0.42
						c0.039,0.161,0.061,0.322,0.096,0.482C1038.104,29.721,1038.11,29.721,1038.114,29.721z"/>
					<path d="M1280.8,35.706c0.07,0.027,0.178,0.051,0.295,0.068c0.252-0.052,0.602-0.12,0.848-0.172
						c-0.104-0.069-0.221-0.098-0.459-0.11C1280.997,35.481,1280.587,35.607,1280.8,35.706z"/>
					<path d="M964.567,28.149c-1.023,0.032-0.08,0.417-0.068,0.424c0.053,0.021,0.113,0.045,0.199,0.063
						C965.749,28.618,964.817,28.21,964.567,28.149z"/>
					<path d="M1038.919,29.828c-0.215,0.002-0.607,0.002-0.744,0.134c-0.178,0.173,0.059,0.346,0.07,0.517
						c0.012-0.003,0.043-0.005,0.061-0.005c0.766-0.104,1.137-0.184,1.521-0.535C1039.554,29.904,1039.188,29.859,1038.919,29.828z"/>
					<path d="M1037.622,31.427c1.07,0.068,1.236-0.061,0.941-0.178c-0.08-0.035-0.248-0.08-0.518-0.093
						c-0.545,0-0.531,0.05-0.496,0.265C1037.573,31.424,1037.604,31.427,1037.622,31.427z"/>
					<path d="M1037.856,32.438c0.125,0.04,0.248-0.034,0.291-0.098c0.063-0.104-0.043-0.206-0.172-0.212
						C1037.679,32.136,1037.646,32.38,1037.856,32.438z"/>
					<polygon points="1038.765,32.972 1039.577,32.985 1039.53,32.785 1038.724,32.771 "/>
					<polygon points="759.939,34.941 760.788,34.953 760.675,34.767 759.833,34.758 "/>
					<path d="M752.96,35.499c0.012,0.006,0.023,0.009,0.035,0.014c0.33,0.106,0.648,0.061,0.761,0.047
						c-0.053-0.089-0.129-0.207-0.183-0.296c-0.106-0.013-0.214-0.018-0.332-0.023C752.748,35.243,752.729,35.396,752.96,35.499z"/>
					<path d="M1309.62,28.223c0.32,0.131,1.109,0,1.309-0.149c0.154-0.115-0.08-0.173-0.17-0.196
						c-0.279,0.128-0.512,0.173-1.268,0.128C1309.487,28.056,1309.46,28.152,1309.62,28.223z"/>
					<polygon points="1310.765,27.86 1310.759,27.877 1310.831,27.863 "/>
					<path d="M1311.942,28.196c0.59,0.011,1.109-0.089,1.711-0.049c0.129-0.149-0.141-0.187-0.66-0.244
						c-0.537-0.061-0.732-0.112-0.555-0.262c-1.002,0-1.313,0.072-1.607,0.222c0.049,0.003,0.111,0.003,0.152,0.003
						C1312.052,27.924,1311.979,28.113,1311.942,28.196z"/>
					<path d="M1500.53,22.632c1.369-0.062,1.369-0.062,7.498,0.111c0.957-0.299,0.957-0.299,1.77-0.213
						c-0.432-0.232-0.578-0.31-1.463-0.354c0.432-0.191,0.873-0.267,1.816-0.301c-0.473-0.046-0.969-0.08-1.469-0.104
						c-1.943-0.083-1.943-0.083-9.059,0.08c0.129,0.268,0.336,0.534,0.398,0.804C1500.177,22.646,1500.378,22.635,1500.53,22.632z"/>
					<path d="M1489.438,22.215c0.006,0.028-0.283,0.104-0.59,0.192c0.049,0,0.109-0.003,0.158-0.006
						c0.951-0.028,2.176,0.006,3.863,0.101c0.24-0.095,0.295-0.142,0.262-0.241c-0.021-0.068,0-0.089,0.303-0.121
						c-0.354-0.068-0.766-0.106-1.697-0.151c-0.918-0.044-1.908-0.066-3.029-0.071c0.104,0.12,0.225,0.194,0.588,0.255
						C1489.356,22.183,1489.431,22.192,1489.438,22.215z"/>
					<path d="M1490.452,25.233c0.568,0.134,1.396,0.221,2.492,0.261c0.221-0.046,0.533-0.052,0.732-0.104
						c0.176-0.044,0.184-0.065,0.207-0.138c0.814,0.172,1.473,0.253,3.012,0.229c1.371-0.018,1.955,0.052,2.711,0.327
						c1.018,0.019,1.797-0.209,2.859-0.146c0.057-0.083,0.141-0.198,0.199-0.283c-0.848-0.112-1.451-0.162-2.605-0.222
						c-1.996-0.089-4.127-0.037-5.986-0.284c-0.934,0.234-1.83,0.308-3.82,0.305C1490.312,25.195,1490.394,25.213,1490.452,25.233z"/>
					<path d="M1284.915,23.335c0.139,0.052,0.424,0.018,0.846-0.047c0.426-0.054,0.555-0.065,0.744-0.065
						c-0.08-0.077-0.152-0.101-0.33-0.111c-0.107,0-0.234,0-0.652,0.079c-0.215,0.041-0.479,0.095-0.68,0.07
						C1284.854,23.285,1284.86,23.312,1284.915,23.335z"/>
					<path d="M767.318,13.936c0.041-0.005,0.095-0.008,0.129-0.017c1.19-0.17,0.365-0.633-0.79-0.775
						c-0.354,0.054-0.249,0.126,0.153,0.305C767.26,13.649,767.448,13.775,767.318,13.936z"/>
					<path d="M1270.812,28.495c-0.766,0.042-1.088,0.049-1.441-0.089c-0.051,0-0.135,0.005-0.193,0.005
						c-0.041,0.006-0.082,0.006-0.129,0.013c-0.059,0.011-0.098,0.017-0.025,0.045c0.201,0.063,0.566,0.098,0.732,0.173
						c0.141,0.063,0.068,0.095-0.031,0.144c1.729-0.023,2.082-0.012,3.791,0.121c0.117-0.121,0.023-0.155-0.389-0.236
						c-0.361-0.065-0.402-0.092-0.412-0.161c-0.197-0.022-0.404-0.04-0.625-0.048C1271.733,28.452,1271.438,28.455,1270.812,28.495z"/>
					<path d="M1276.485,31.473c-0.076,0.145,0.287,0.265,0.422,0.396c0.014,0,0.039-0.006,0.055-0.012
						c0.359-0.08,1.182-0.132,1.188-0.075c-0.006,0.029-0.285,0.081-0.459,0.113c0.129,0.151,0.809,0.031,1.084-0.055
						c0.303-0.095,0.27-0.161,0.252-0.196C1278.067,31.671,1277.368,31.508,1276.485,31.473z"/>
					<path d="M1038.429,28.969c0.502,0.089,1.113,0.112,1.705,0.126c-0.16-0.141-0.178-0.212,0.068-0.344
						c0.207-0.115,0.225-0.144,0.229-0.225c-0.629-0.034-0.781-0.215-1.441-0.241c-0.537-0.006-0.623,0.046-0.592,0.061
						c0.092,0.031,0.662,0.061,1.139,0.055c-0.088,0.089-0.262,0.126-0.637,0.189C1037.776,28.785,1038.423,28.964,1038.429,28.969z"/>
					<path d="M1029.581,27.935c0.232,0.07,0.447,0.144,0.674,0.213c0.016,0.005,0.037,0.012,0.059,0.018
						c0.758,0.229,1.428,0.341,2.369,0.401c-0.506-0.244-0.35-0.281,0.225-0.373c-0.381-0.006-0.822-0.013-1.266-0.021
						c1.375,0.022,1.457,0.006,1.824-0.071c-0.49-0.488-0.643-0.784-0.631-1.255c-1.381-0.158-1.709-0.198-2.682-0.253
						c-0.137-0.197,0.193-0.404-0.07-0.601c-0.055-0.039-0.289-0.097-0.855-0.086c-0.051-0.04-0.105-0.103-0.051-0.146
						c0.264-0.034,0.623-0.006,0.852-0.065c0.131-0.032,0-0.104-0.049-0.145c-0.32-0.034-0.646-0.06-0.986-0.074
						c-0.842-0.021-1.574,0.104-2.402,0.104c-0.111,0.075-0.252,0.173-0.32,0.25c-0.402,0.434-0.178,0.882-0.625,1.313
						c-0.32,0.31-0.875,0.413-0.932,0.425c-0.377,0.063-0.738,0.126-0.258,0.308c0.152,0.057,0.33,0.109,0.416,0.172
						c1.16,0.021,2.719,0.049,3.873,0.071C1028.78,27.986,1028.962,27.947,1029.581,27.935z"/>
					<path d="M977.118,30.826c0.996-0.681,0.996-0.681,1.174-0.893c0.061-0.068,0.117-0.163,0.129-0.235
						c0.141-0.655-0.395-0.729-1.068-0.824c-1.598-0.227-0.947-0.413-0.941-0.416c0.225-0.061,1.209,0.043,1.23,0.194
						c0.236-0.068,0.285-0.079,0.201-0.2c-0.166-0.225,0.014-0.235,0.975-0.259c-0.268-0.175-0.408-0.228-1.607-0.46
						c-0.092-0.017-0.197-0.04-0.289-0.054c-0.785,0.082-1.676,0.333-0.645,0.657c-0.225-0.04-0.385-0.06-0.699-0.08
						c0.273,1.024,0.633,2.395,0.902,3.423c0.092-0.012,0.221-0.023,0.303-0.041C978.032,31.393,976.724,31.091,977.118,30.826z"/>
					<polygon points="965.405,31.231 965.401,31.234 965.405,31.237 "/>
					<path d="M747.396,33.759c-1.71,0.052-2.069,0.329-2.493,0.651c0.023,0.009,0.052,0.015,0.071,0.021
						c0.159,0.045,0.288,0.092,0.417,0.141c1.049,0.012,2.464,0.025,3.514,0.037c-0.419-0.172-0.807-0.361-1.414-0.79
						C747.454,33.799,747.426,33.775,747.396,33.759z"/>
					<path d="M1101.46,18.37c-0.158-0.013-0.471-0.058-0.617-0.084c-0.604-0.109-0.049-0.126,0.215-0.131
						c-0.063-0.013-0.129-0.019-0.203-0.023c-0.072,0-0.146,0-0.213,0c-0.756,0.037-2.605,0.511-0.855,0.775
						c-0.195-0.01-0.701-0.034-0.822,0.034c-0.068,0.037-0.063,0.074-0.02,0.188c0.033,0.075,0.057,0.152,0.041,0.23l2.104,0.049
						C1101.077,19.06,1101.796,18.724,1101.46,18.37z"/>
					<path d="M1294.958,29.81h-0.01c-0.037,0.003-0.061,0.009-0.061,0.021l0.123-0.022
						C1294.991,29.808,1294.972,29.808,1294.958,29.81z"/>
					<path d="M0.997,5.422c0.238-0.087-0.311-0.225-0.603-0.299c-0.016,0.014-0.043,0.052,0.08,0.132
						C0.62,5.347,0.917,5.45,0.997,5.422z"/>
					<path d="M3.437,12.359c0.056-0.04,0.113-0.04,0.195-0.034c-0.106-0.179-0.244-0.227-0.511-0.287
						c-0.206-0.046-0.286-0.075-0.385-0.149c-0.435,0.046,0.33,0.482,0.339,0.482C3.308,12.429,3.378,12.4,3.437,12.359z"/>
					<path d="M2.344,12.749c0.411,0.058,0.801,0.125,1.193,0.19c1.809,0.293,2.676,0.373,2.688,0.373
						c0.472,0.031,0.573-0.028,0.439-0.27c-0.892-0.115-1.739-0.253-2.7-0.345c-0.857-0.069-1.262-0.063-1.789,0.035
						C2.224,12.735,2.294,12.744,2.344,12.749z"/>
					<path d="M0.858,12.785c0.125-0.016,0.105-0.052,0.21-0.067c-0.091-0.111-0.329-0.146-0.395-0.152
						c-0.406-0.036-0.047,0.202-0.044,0.202S0.753,12.796,0.858,12.785z"/>
					<path d="M2.445,15.371C0.624,15.2,0.624,15.2,0.099,15.225c0.062,0.07,0.124,0.139,0.246,0.204
						c0.323,0.176,0.792,0.204,0.969,0.115c0.067-0.031,0.053-0.068,0.047-0.103c1.063,0.243,1.807,0.249,2.744,0.26
						C3.615,15.547,3.229,15.452,2.445,15.371z"/>
					<path d="M4.923,15.639c-0.033-0.006-0.324-0.017-0.04,0.144c0.267,0.157,0.612,0.259,0.718,0.213
						C5.707,15.949,5.74,15.73,4.923,15.639z"/>
					<path d="M1.003,16.477c0.059,0.07,0.125,0.139,0.227,0.202c0.243,0.148,0.494,0.148,0.588,0.148
						C1.648,16.641,1.567,16.621,1.003,16.477z"/>
					<polygon points="6.376,17.354 6.077,17.052 5.678,17.017 6.113,17.327 "/>
					<polygon points="5.046,17.833 5.253,18.033 5.78,18.082 5.58,17.881 "/>
					<path d="M4.088,17.925c0.015,0.014,0.036,0.031,0.061,0.046c0.138,0.08,0.401,0.12,0.479,0.074
						c0.03-0.018,0.014-0.167-0.249-0.192C4.195,17.842,4.192,17.901,4.088,17.925z"/>
					<path d="M0.726,17.595c0.186,0.045,0.428,0.105,0.613,0.152c-0.192-0.145-0.257-0.17-0.318-0.182
						C0.891,17.561,0.847,17.598,0.726,17.595z"/>
					<path d="M4.966,19.208c0.195-0.06,0.383-0.04,1.422,0.061c-0.407-0.319-0.995-0.408-1.168-0.425
						c-0.462-0.035-0.555,0.092-0.286,0.373C4.947,19.217,4.959,19.211,4.966,19.208z"/>
					<path d="M6.585,25.805c-0.162-0.115-0.238-0.149-0.34-0.167c-0.238-0.012-0.194,0.063-0.329,0.086
						c-0.125,0.023-0.251-0.006-0.303-0.017c0.021,0.011,0.062,0.027,0.084,0.04c0.277,0.126,0.388,0.132,0.446,0.137
						C6.399,25.901,6.405,25.821,6.585,25.805z"/>
					<path d="M2.703,27.234c0.016,0.011,0.033,0.02,0.049,0.029c0.172,0.097,0.332,0.154,0.507,0.184
						c0.208,0.034,0.423-0.006,0.629,0.005c-0.203-0.094-0.448-0.195-0.76-0.232C2.97,27.203,2.845,27.209,2.703,27.234z"/>
					<path d="M1.411,23.104l1.382,0.144c-0.157-0.034-0.316-0.063-0.504-0.092C1.949,23.116,1.641,23.107,1.411,23.104z"
						/>
					<path d="M23.212,4.741c0.027,0.015,0.056,0.025,0.081,0.037c0.804,0.373,1.958-0.04,1.971-0.087
						c0,0-0.243-0.378-1.898-0.501c-0.151-0.01-0.307-0.021-0.467-0.029c0.033,0.086,0.117,0.169,0.201,0.255
						C23.344,4.675,23.366,4.732,23.212,4.741z"/>
					<path d="M12.995,7.104c0.922,0.148,1.721,0.276,2.399,0.284c0.774,0.009,0.626-0.241,0.63-0.244
						c-0.006-0.002-0.312-0.276-1.205-0.522c-0.572-0.158-1.375-0.253-2.055-0.38c-0.171,0.173-0.135,0.346,0.148,0.851
						C12.942,7.099,12.972,7.099,12.995,7.104z"/>
					<path d="M16.083,8.063c0.012,0,0.029-0.003,0.045-0.006c0.165-0.006,0.324,0.003,0.48,0.015
						c0.102,0.009,0.226,0.04,0.318,0.011c0.1-0.028,0.014-0.16-0.035-0.24c-0.175,0.008-0.299,0.075-0.5,0.039
						c-0.138-0.024-0.253-0.117-0.332-0.187C15.904,7.704,15.796,7.753,16.083,8.063z"/>
					<path d="M15.038,7.793c0.009,0.003,0.014,0.007,0.021,0.013c0.265,0.114,0.439,0.16,0.485,0.132
						c0.047-0.029-0.085-0.167-0.3-0.189C15.19,7.748,15.12,7.751,15.038,7.793z"/>
					<path d="M7.095,7.242C7.253,7.337,7.47,7.46,7.625,7.555C7.823,7.449,7.993,7.357,7.501,7.09
						C7.467,7.082,7.424,7.075,7.375,7.069C7.003,7.047,7.474,7.266,7.095,7.242z"/>
					<path d="M24.579,13.944c-0.073-0.012-0.146-0.017-0.221-0.022c-0.388-0.029-0.415,0.048-0.114,0.275
						c0.009,0.006,0.012,0.003,0.02,0.006C24.724,14.249,24.812,14.174,24.579,13.944z"/>
					<path d="M25.143,14.252c0.065,0.034,0.25,0.031,0.25,0.031c0.153-0.018,0.146-0.058,0.274-0.075
						c-0.082-0.103-0.357-0.131-0.413-0.137C25.033,14.06,24.906,14.111,25.143,14.252z"/>
					<path d="M22.055,14.3c-0.061-0.113-0.134-0.258-0.189-0.372c-0.593,0.097-0.919,0.149-1.338-0.104
						c-0.356,0.204-0.717,0.271-2.003,0.149c-1.236-0.12-1.403-0.1-1.63-0.074c0.076,0.029,0.169,0.063,0.25,0.087
						c0.648,0.218,1.141,0.28,1.535,0.314c0.26,0.023,0.26,0.023,1.736-0.024C21.178,14.255,21.503,14.252,22.055,14.3z"/>
					<path d="M14.442,13.789c-0.097,0-0.175,0.003-0.713-0.103c-0.95-0.187-1.403-0.244-1.411,0.028
						c0.019,0,0.047,0,0.067,0.003c0.143,0.003,0.561,0.014,1.146,0.105c0.926,0.144,1.26,0.127,1.699,0.035
						c-0.153-0.132-0.231-0.175-0.342-0.192C14.569,13.677,14.771,13.783,14.442,13.789z"/>
					<path d="M15.378,13.873c0.021,0.015,0.049,0.031,0.07,0.046c0.095,0.054,0.319,0.189,0.855,0.141
						c0.062-0.003,0.296-0.018,0.627,0.028c-0.209-0.092-0.485-0.195-0.933-0.235C15.753,13.836,15.55,13.841,15.378,13.873z"/>
					<path d="M9.93,13.681c0.202-0.164,0.555-0.127,1.249-0.031c0.584,0.077,0.795,0.077,0.998,0.054
						c-0.466-0.184-0.755-0.255-1.236-0.302c-0.544-0.042-1.125,0.015-1.662-0.031c-0.617-0.058-1.105-0.166-1.747-0.215
						c-0.03-0.003-0.071-0.003-0.101-0.009c-0.274-0.012-0.437,0-0.534,0.011c0.041,0.019,0.094,0.044,0.132,0.061
						c0.521,0.216,0.929,0.222,1.486,0.23C9.125,13.456,9.436,13.496,9.93,13.681z"/>
					<path d="M21.255,15.047c0.014,0.007,0.027,0.009,0.042,0.015c0.307,0.129,0.46,0.139,0.501,0.104
						c0.033-0.032-0.081-0.141-0.274-0.158C21.414,14.999,21.329,15.024,21.255,15.047z"/>
					<path d="M20.692,15.082c0.062-0.035,0.019-0.096-0.132-0.185l-0.347,0.069c0.01,0.017,0.034,0.04,0.067,0.058
						C20.4,15.094,20.616,15.122,20.692,15.082z"/>
					<path d="M18.715,14.771c-1.193-0.126-1.521-0.086-1.738-0.061c0.019,0.009,0.052,0.021,0.073,0.031
						c0.721,0.265,2.569,0.5,2.88,0.254c0.061-0.047,0.049-0.095,0.033-0.145C19.351,14.829,18.715,14.771,18.715,14.771z"/>
					<path d="M15.986,15.788c0.044,0.049,0.083,0.098,0.175,0.146c0.105,0.055,0.221,0.072,0.365,0.1
						c0.32,0.062,0.409,0.122,0.51,0.282c0.177-0.058,0.299-0.098,0.692-0.115c0.459-0.022,0.915,0.026,1.374,0.018
						c-0.294-0.198-0.489-0.27-0.855-0.308C18.01,15.9,18.01,15.9,17.248,15.979C16.339,15.742,16.339,15.742,15.986,15.788z"/>
					<polygon points="15.384,15.829 15.674,15.851 15.495,15.67 15.21,15.647 "/>
					<path d="M13.519,15.523c0.003,0.007,0.012,0.01,0.018,0.013c0.136,0.086,0.323,0.184,0.555,0.188
						c-0.098-0.149-0.254-0.188-0.509-0.212c-0.03-0.003-0.064-0.006-0.098-0.009C13.496,15.51,13.509,15.518,13.519,15.523z"/>
					<polygon points="24.391,16.44 24.085,16.417 24.282,16.615 24.582,16.639 "/>
					<polygon points="19.941,16.55 19.667,16.265 19.249,16.23 19.519,16.511 "/>
					<path d="M21.549,16.959c-0.409-0.021-0.574,0.081-0.498,0.306c0.016,0,0.04,0.003,0.056,0.006
						c0.287,0.014,1.203,0.086,1.734,0.131C22.337,17.092,21.862,16.994,21.549,16.959z"/>
					<path d="M18.674,16.891c-0.437-0.108-1.095-0.166-1.494-0.286c0.067,0.113,0.163,0.263,0.23,0.372
						c0.017,0,0.034,0.003,0.05,0c0.191,0.006,0.636,0.023,1.633,0.192c0.828,0.138,1.167,0.153,1.513,0.062
						c-0.386-0.288-0.653-0.395-1.107-0.442C19.272,16.775,19.004,16.772,18.674,16.891z"/>
					<path d="M27.56,17.729c0.107-0.057-0.092-0.194-0.175-0.249c-0.146,0.065-0.347,0.078-0.682,0.026
						c0.029,0.031,0.059,0.058,0.11,0.086C27.037,17.718,27.443,17.789,27.56,17.729z"/>
					<path d="M22.942,17.224c0.029,0.055,0.073,0.109,0.169,0.156c0.195,0.103,0.448,0.113,0.537,0.063
						c0.062-0.031,0.07-0.104-0.188-0.256L22.942,17.224z"/>
					<polygon points="25.941,17.448 26.135,17.649 26.746,17.694 26.549,17.493 "/>
					<path d="M23.792,17.385c0.016,0.022,0.042,0.046,0.086,0.069c0.129,0.063,0.336,0.086,0.404,0.039
						c0.053-0.034,0.008-0.092-0.142-0.178L23.792,17.385z"/>
					<path d="M8.459,16.272c-0.003-0.048-0.107-0.146-0.342-0.266l0.018,0.275c0.006,0,0.02,0.006,0.03,0.006
						C8.355,16.327,8.462,16.325,8.459,16.272z"/>
					<path d="M7.903,16.167c-0.169-0.112-0.423-0.241-1.029-0.299c-0.619-0.052-1.028,0.006-1.104,0.018
						c0.021,0.006,0.052,0.018,0.073,0.022C6.418,16.063,7.628,16.219,7.903,16.167z"/>
					<path d="M20.652,18.269c0.572-0.143-0.38-0.447-0.799-0.493c-0.314-0.023-0.63,0.017-0.943-0.006
						c-0.25-0.018-0.454-0.077-0.55-0.104c-0.089,0.075-0.199,0.176-0.286,0.249c-0.854-0.243-0.854-0.243-1.185-0.277
						c0.129,0.091,0.297,0.206,0.42,0.295c-0.933-0.388-1.226-0.348-1.316-0.283c-0.119,0.079-0.056,0.114,0.105,0.2
						c0.249,0.141,0.638,0.259,0.781,0.207c0.078-0.031,0.032-0.108,0.003-0.16c0.578,0.355,0.845,0.517,1.162,0.369
						c0.083,0.01,0.083,0.01,0.258,0.271c0.075,0.109,0.192,0.146,0.392,0.133c-0.144-0.142-0.34-0.337-0.485-0.479
						c0.301-0.055,0.602-0.063,1.314,0.04C20.303,18.341,20.459,18.318,20.652,18.269z"/>
					<polygon points="15.414,17.608 15.069,17.396 15.081,17.672 "/>
					<path d="M12.211,18.132c0.518-0.013,0.419-0.403,0.036-0.472c-0.027-0.005-0.059-0.008-0.089-0.011
						c-0.31-0.018-0.488,0.12-0.745,0.063c0.068,0.068,0.146,0.137,0.27,0.206C11.816,17.993,12.017,18.062,12.211,18.132z"/>
					<path d="M8.33,17.915c0.294,0.122,0.501,0.153,0.599,0.159c0.515,0.04,0.666-0.092,1.048-0.115
						c0.778-0.044,0.686,0.218,1.335,0.241c0.123,0,0.168-0.043,0.168-0.043c0.002,0-0.025-0.164-0.458-0.232
						c-0.541-0.086-0.491-0.27-0.485-0.27c0.206,0.017,0.165,0.086,0.4,0.097c0.003,0,0.304-0.224-1.453-0.393
						c-0.544-0.044-0.908-0.055-1.44-0.037c0.19,0.188,0.274,0.275,0.209,0.447C8.211,17.867,8.211,17.867,8.33,17.915z"/>
					<path d="M15.944,18.577c0.414-0.026,0.604-0.026,0.858,0.031c-0.402-0.195-0.634-0.248-1.114-0.259
						c-0.359-0.009-0.553-0.046-0.879-0.167c0.095,0.096,0.183,0.19,0.342,0.276C15.414,18.608,15.648,18.594,15.944,18.577z"/>
					<path d="M14.129,18.384l-0.14-0.27c-0.035-0.009-0.075-0.017-0.121-0.023C13.868,18.091,13.515,18.098,14.129,18.384
						z"/>
					<path d="M21.62,20.366c0.111,0.057,0.246,0.068,0.417,0.079c0.068-0.008,0.136-0.005,0.204,0
						c-0.163-0.132-0.336-0.194-0.602-0.224c-0.053-0.003-0.112-0.005-0.17-0.005C21.499,20.268,21.532,20.316,21.62,20.366z"/>
					<path d="M24.889,20.738c0.098,0.058,0.227,0.101,0.266,0.081c0.053-0.028-0.154-0.19-0.221-0.241
						C24.625,20.578,24.846,20.71,24.889,20.738z"/>
					<path d="M17.844,20.016c0.024,0.019,0.057,0.045,0.096,0.06c0.159,0.084,0.338,0.084,0.532,0.089
						c0.151,0.003,0.319-0.012,0.461,0.018c-0.103-0.069-0.194-0.098-0.399-0.118C18.302,20.047,18.043,20.055,17.844,20.016z"/>
					<path d="M26.881,23.708c-0.111,0-0.2-0.012-0.282-0.025c0.02,0.014,0.051,0.031,0.076,0.045
						c0.3,0.152,0.719,0.233,0.854,0.164c0.131-0.072-0.25-0.206-0.33-0.215C27.064,23.667,26.997,23.702,26.881,23.708z"/>
					<path d="M8.61,23.357c0.006,0,0.018,0,0.021,0.003c0.298,0.05,0.406,0.021,0.333-0.089
						c-0.05-0.081-0.12-0.189-0.389-0.225C8.281,23.03,8.6,23.353,8.61,23.357z"/>
					<path d="M6.735,23.013c0.042,0.052,0.086,0.106,0.18,0.156c0.053,0.027,0.118,0.056,0.237,0.068
						c0.132,0.017,0.289,0.008,0.423,0.017c-0.168-0.138-0.337-0.194-0.636-0.229C6.871,23.019,6.808,23.019,6.735,23.013z"/>
					<path d="M21.604,25.066c0.175,0.015,0.347,0.003,0.562-0.017c0.498-0.041,0.602-0.026,1.51,0.103
						c1.213,0.176,1.95,0.281,2.271,0.129c0.121-0.063,0.121-0.16,0.123-0.235c-0.089-0.017-0.179-0.032-0.286-0.04
						c-0.313-0.011-0.38,0.026-0.488,0.155c-0.903-0.247-1.533-0.281-2.606-0.281c-0.507,0-1.273,0.005-1.94-0.086
						c0.039,0.02,0.089,0.045,0.128,0.063C21.04,24.935,21.293,25.04,21.604,25.066z"/>
					<path d="M18.37,24.744c0.127-0.071-0.03-0.191-0.097-0.249c-0.869,0.034-0.869,0.034-1.022,0.08
						c0.021,0.017,0.046,0.037,0.086,0.058C17.606,24.778,18.203,24.846,18.37,24.744z"/>
					<path d="M17.041,24.942c0.183-0.092-0.198-0.557-1.017-0.637c-0.171-0.018-0.345-0.015-0.643,0.028
						c0.089,0.095,0.209,0.189,0.369,0.281C16.212,24.877,16.848,25.04,17.041,24.942z"/>
					<polygon points="13.072,24.202 12.867,24.019 12.6,23.995 12.799,24.179 "/>
					<path d="M20.516,24.896c0.029-0.012,0.042-0.026,0.044-0.04c-0.194-0.043-0.451-0.092-0.65-0.132
						c0.043,0.034,0.092,0.063,0.146,0.098C20.235,24.914,20.428,24.948,20.516,24.896z"/>
					<path d="M25.303,26.643c0.182,0.092,0.317,0.104,0.423,0.034c0.048-0.028,0.073-0.06,0.099-0.094
						c0.122,0.036,0.279,0.089,0.399,0.123c-0.041-0.139-0.243-0.225-0.593-0.259C25.438,26.438,24.842,26.413,25.303,26.643z"/>
					<path d="M24.066,26.52c0.042-0.038-0.056-0.136-0.265-0.155c-0.118-0.009-0.194,0.009-0.259,0.037
						c0.014,0.003,0.03,0.012,0.036,0.012C23.837,26.522,24.021,26.56,24.066,26.52z"/>
					<path d="M13.288,26.122c0.043,0.01,0.102,0.016,0.146,0.019c0.592,0.065,1.094-0.104,1.686-0.038
						c0.304,0.038,0.602,0.127,0.98,0.242c0.54,0.16,0.84,0.238,1.317,0.229c0.133-0.093-0.086-0.178-0.086-0.27
						c0.184,0.065,0.316,0.108,0.547,0.149c0.459,0.082,0.757-0.075,1.137-0.112c0.134-0.016,0.542-0.056,1.355,0.442
						c0.266,0.157,0.266,0.157,0.532,0.154c0.128-0.089,0.128-0.089-0.563-0.807c-1.704-0.109-3.127-0.351-4.739-0.5
						c-1.839-0.144-2.852-0.176-3.631,0.021c0.072,0.037,0.159,0.08,0.227,0.115C12.726,26.017,13.054,26.086,13.288,26.122z"/>
					<path d="M20.863,26.24c0.007,0.007,0.016,0.01,0.019,0.012c0.228,0.127,0.455,0.152,0.655,0.161
						c-0.108-0.161-0.237-0.201-0.483-0.221c-0.099-0.006-0.216-0.006-0.3-0.026C20.784,26.192,20.824,26.218,20.863,26.24z"/>
					<path d="M23.142,26.709c-0.269-0.015-0.347,0.003-0.064,0.222c0.202,0.154-0.033,0.131-0.187,0.116
						c0.03,0.021,0.073,0.044,0.111,0.064c0.07,0.034,0.236,0.118,0.438,0.065c0.215-0.06,0.434,0.04,0.725,0.224
						c0.297,0.023,0.297,0.023,0.77-0.111c-0.221-0.192-0.411-0.216-0.846-0.235C23.557,27.033,23.377,26.971,23.142,26.709z"/>
					<path d="M18.761,26.588c-0.043-0.003-0.085,0-0.116,0.009c0.027,0.028,0.064,0.061,0.116,0.092
						c0.156,0.08,0.494,0.135,0.608,0.222C19.587,26.86,19.09,26.625,18.761,26.588z"/>
					<polygon points="12.015,26.924 12.37,27.131 12.63,27.156 12.309,26.878 "/>
					<path d="M10.04,27.751c-0.105,0.029-0.007,0.104,0.092,0.158c0.119,0.066,0.45,0.204,0.618,0.164
						c-0.095-0.144-0.181-0.167-0.369-0.184C10.248,27.875,10.153,27.857,10.04,27.751z"/>
					<path d="M11.262,28.032c0.009,0.007,0.022,0.012,0.025,0.012c0.356,0.201,0.715,0.247,0.958,0.258
						c-0.168-0.188-0.21-0.188-0.715-0.226C11.418,28.067,11.333,28.056,11.262,28.032z"/>
					<path d="M16.287,29.021c0.273,0.229,0.513,0.431,0.761,0.56c0.013,0.01,0.031,0.018,0.046,0.026
						c0.16-0.092,0.913-0.063,0.842-0.185c-0.005-0.014-0.056-0.028-0.082-0.039c-0.192-0.092-0.377-0.179-0.57-0.271
						c-0.221-0.104-0.439-0.206-0.667-0.311c-0.013,0-0.029,0-0.043,0c-0.07,0.013-0.062,0.034-0.008,0.133
						c0.057,0.098,0.046,0.115-0.019,0.129C16.422,29.058,16.358,29.037,16.287,29.021z"/>
					<path d="M15.065,29.233c0.092-0.058,0.517,0.017,0.556-0.047c0.035-0.068-0.126-0.209-0.396-0.241
						c-0.155-0.008-0.159,0.04-0.267,0.05c-0.138,0.011-0.283-0.026-0.361-0.044c0.14,0.086,0.32,0.201,0.459,0.287
						C15.06,29.238,15.06,29.236,15.065,29.233z"/>
					<path d="M19.198,29.525c0.002,0,0.119-0.149-0.338-0.194c-0.207-0.016-0.442,0.031-0.298,0.103
						C18.727,29.52,19.107,29.574,19.198,29.525z"/>
					<path d="M16.462,29.46c0.07-0.135-0.289-0.25-0.432-0.376c-0.115-0.012-0.271-0.026-0.388-0.034
						c0.096,0.098,0.202,0.194,0.376,0.289C16.168,29.417,16.319,29.46,16.462,29.46z"/>
					<path d="M153.041,36.671c0.243,0.1,0.667,0.191,0.795,0.114c0.042-0.025,0.042-0.025-0.741-0.316
						C152.611,36.481,152.931,36.624,153.041,36.671z"/>
					<path d="M19.255,29.796c0.099-0.046,0.029-0.13-0.006-0.172c-0.064,0.074-0.086,0.068-0.534-0.01
						c-0.31-0.054-0.499-0.024-0.345,0.052C18.647,29.808,19.104,29.876,19.255,29.796z"/>
					<path d="M1.653,13.7c0.117,0.063,0.231,0.083,0.273,0.089c0.101,0.015,0.232,0.013,0.342,0.018
						c0.308,0.017,0.561,0.063,0.839,0.098c0.612,0.072,0.841,0.126,1.397,0.282c0.065-0.052,0.146-0.115,0.211-0.167
						c0.548,0.212,1.744,0.462,1.906,0.264c0.022-0.025,0.01-0.063,0.006-0.092c0.169-0.022,0.248,0.034,0.388,0.145
						c0.149,0.12,0.242,0.131,0.334,0.108c0.013,0,0.025,0,0.036,0.003c0.042,0.009,0.081,0.017,0.14,0.02
						c0.037-0.011,0.079-0.022-0.007-0.148c-0.025-0.053-0.232-0.101-0.022-0.149c0.067,0,0.112,0.006,0.151,0.015
						c-0.354-0.099-0.618-0.157-0.914-0.188c-0.394-0.026-0.526,0.015-0.514,0.161c-0.32-0.086-0.551-0.19-0.94-0.265
						c-0.27-0.052-0.303,0.012-0.313,0.029c-0.016,0.043,0.003,0.083,0.027,0.123c-0.229-0.123-0.645-0.353-2.171-0.358
						c-0.837,0-1.176-0.092-1.338-0.139C1.53,13.6,1.573,13.652,1.653,13.7z"/>
					<path d="M22.383,26.474c-0.002,0-0.008,0.002-0.008,0.002c-0.006-0.051,0.006-0.103,0.212-0.058
						c0.192,0.041,0.214,0.115,0.51,0.136c0.165,0.011,0.133-0.089,0.133-0.089c-0.033-0.052-0.156-0.098-0.363-0.146
						c-0.21-0.049-0.275-0.089-0.352-0.17c-0.317-0.011-0.202,0.095-0.326,0.138c-0.1,0.035-0.275,0.003-0.459-0.034
						c0.046,0.053,0.079,0.104,0.188,0.152c0.165,0.077,0.557,0.112,0.708,0.187c0.02,0,0.04,0,0.062,0
						C22.734,26.545,22.411,26.476,22.383,26.474z"/>
					<path d="M3.826,25.023c0.182,0.003,0.277,0.014,0.385,0.114c0.248-0.135,0.561-0.166,1.487,0.08
						c0.538,0.145,0.742,0.162,0.866,0.075c0.51,0.184,0.876,0.386,1.416,0.566c0,0,0.152,0.045,0.362,0.024
						c0.48-0.045,0.527-0.048,0.89,0.185c0.003-0.144-0.313-0.281-0.111-0.426c0.176-0.005,0.176-0.005,0.691,0.285
						c0.126,0.071,0.239,0.146,0.445,0.204c0.042-0.084-0.254-0.146-0.292-0.225c-0.03-0.063,0.167-0.115,0.244-0.169
						c0.033,0.012,0.076,0.025,0.1,0.037c0.228,0.101,0.289,0.218,0.513,0.322c0.126,0.061,0.218,0.079,0.332,0.068
						c-0.359-0.336-0.319-0.396,0.223-0.348c0.5,0.044,0.61,0.015,0.352-0.275c-1.931-0.232-2.388-0.284-3.023-0.126
						c-0.767-0.222-1.263-0.296-2.321-0.364c-1.117-0.07-1.649-0.147-2.576-0.466c-0.698,0.195-0.607,0.238-0.329,0.373
						C3.517,24.978,3.609,25.023,3.826,25.023z"/>
					<path d="M7.974,26.921c0,0,0.104-0.008,0.332,0.021c0.271,0.04,0.498,0.092,0.764,0.129
						c0.504,0.072,0.636,0.015,0.798-0.058c0.121-0.055,0.207-0.086,0.339-0.089c0.788-0.022,1.209,0.156,1.905,0.181
						c-0.234-0.134-0.414-0.207-0.855-0.27c-0.24-0.032-0.525-0.037-0.784-0.055c-1.058-0.077-1.97-0.221-2.968-0.326
						C3.735,26.071,2.4,26.02,1.521,26.025c0.022,0.075,0.055,0.178,0.081,0.256c-0.003-0.003-0.269-0.259-0.747-0.33
						c-0.28,0.014-0.129,0.089,0.08,0.194c0.473,0.23,0.843,0.302,1.05,0.343c0.052,0.011,0.132,0.021,0.19,0.031
						c0.319,0.043,0.675,0.071,1.019,0.105c0.281,0.029,0.464,0.092,0.676,0.142c0.521,0.126,0.663,0.131,0.807,0.106
						c0.442,0.149,0.613,0.231,0.915,0.514c0.246,0,0.389,0.055,0.575,0.221c0.318,0.009,0.528,0.028,1.268,0.133
						c0.108,0.017,0.221,0.031,0.331,0.045c0.271,0.029,0.591,0.041,0.859,0.075c0.274,0.04,0.488,0.098,0.801,0.124
						c0.146,0.008,0.336,0.025,0.367-0.058c0.002-0.016-0.054-0.199-0.207-0.221c-0.266-0.047-0.289,0.079-0.465,0.113
						c-0.204-0.218-0.237-0.235-0.669-0.355c-0.504-0.141-0.685-0.284-1.05-0.571c0.183,0.097,0.417,0.227,0.592,0.321
						C7.855,27.073,7.74,26.952,7.974,26.921z M7.829,27.355l0.344,0.298l-0.251-0.025L7.458,27.32L7.829,27.355z M7.238,27.35
						c-0.061,0.022-0.138,0.04-0.206,0.057c-0.059,0.018-0.107,0.038-0.151,0.058c-0.004,0-0.007,0.006-0.01,0.006
						c-0.017,0.012-0.036,0.022-0.047,0.034c-0.002,0.003-0.007,0.009-0.01,0.012c-0.175-0.184-0.303-0.367-0.421-0.551
						c0.411-0.018,0.937,0.339,0.94,0.341C7.354,27.326,7.275,27.335,7.238,27.35z"/>
					<path d="M18.205,29.425c0.029,0.016,0.073,0.032,0.097,0.016c0.044-0.029-0.038-0.202-0.277-0.351l0.081,0.27
						C18.132,29.383,18.161,29.405,18.205,29.425z"/>
					<path d="M17.021,16.854c-0.425-0.146-1.418-0.491-3.549-0.555c-1.114-0.425-0.739-0.603-0.524-0.66
						c0.042,0,0.104,0,0.144,0c-0.624-0.247-1.107-0.325-2.333-0.38c-0.86-0.039-1.305-0.068-1.961-0.221
						c-0.049-0.011-0.114-0.028-0.167-0.042c-0.386,0.169-0.929,0.2-2.947-0.07c-1.253-0.171-1.758-0.2-2.169-0.131
						c0.02,0.014,0.049,0.034,0.076,0.052c0.086,0.051,0.34,0.207,0.655,0.166c0.5-0.063,0.743,0.12,0.955,0.287
						c0.014-0.043,0.011-0.086,0.115-0.126c0.02,0,0.05,0,0.07-0.003c0.469,0.088,0.593,0.232,0.994,0.33
						c0.07-0.046,0.162-0.104,0.229-0.148c0.653,0.255,0.936,0.234,1.325,0.209c0.78-0.052,1.105,0.14,1.162,0.181
						c0.134,0.087,0.134,0.087-0.431,0.311c0.917,0.364,0.985,0.373,4.709,0.683c0.071-0.049,0.163-0.114,0.231-0.164
						c0.689,0.089,0.869,0.322,1.848,0.325C15.982,16.896,16.455,16.782,17.021,16.854z M11.049,16.007
						c-0.062-0.038-0.179-0.067-0.144-0.109c0-0.003,0.362-0.213,0.427-0.222c0.221,0.17,0.626,0.331,0.752,0.509
						C11.234,16.112,11.234,16.112,11.049,16.007z"/>
					<path d="M6.645,23.599c-0.691-0.097-1.344-0.206-2.063-0.293c-0.541-0.058-0.541-0.058-0.905,0.037l4.043,0.399
						c-0.083-0.034-0.237-0.109-0.403-0.132C7.1,23.578,6.862,23.631,6.645,23.599z"/>
					<path d="M158.411,6.96h0.005c0.82,0.064,0.596-0.184,0.26-0.562c-0.055-0.003-0.112-0.007-0.16-0.012
						c-0.566-0.006-0.448,0.148-0.129,0.571C158.399,6.96,158.411,6.96,158.411,6.96z"/>
					<path d="M187.374,11.516c0.013,0,0.024,0.005,0.024,0.005c0.755,0.069,0.647-0.212,0.3-0.391
						c-0.177-0.086-0.211-0.092-0.448-0.103c-0.135,0-0.229,0.017-0.205,0.092C187.08,11.257,187.314,11.384,187.374,11.516z"/>
					<path d="M118.843,9.579c0.654,0.044,1.032,0.047,0.59-0.27c-0.059-0.003-0.123-0.006-0.182-0.009
						c-0.519-0.015-0.648,0.061-0.459,0.278C118.814,9.579,118.826,9.579,118.843,9.579z"/>
					<path d="M75.722,7.779c-0.07-0.164-0.14-0.173-0.747-0.229c0.016,0.008,0.041,0.022,0.058,0.031
						C75.298,7.735,75.528,7.769,75.722,7.779z"/>
					<path d="M107.964,9.915c0.116,0.106-0.102,0.233,0.3,0.327c0.777,0.183,1.58,0.204,2.346,0.207
						c1.308,0.003,1.686,0.044,2.099,0.109c0-0.083-0.013-0.191-0.019-0.275c-0.205-0.101-0.631-0.308-1.562-0.463
						c-1.133-0.184-2.523-0.243-3.714-0.401c0.036,0.043,0.072,0.098,0.113,0.138C107.651,9.677,107.828,9.792,107.964,9.915z"/>
					<path d="M31.152,6.116c-0.363-0.194-0.685-0.278-1.176-0.315c-0.304-0.018-0.62-0.012-0.932-0.018
						c0.032,0.012,0.064,0.029,0.092,0.04C29.509,5.973,30.259,6.214,31.152,6.116z"/>
					<path d="M31.799,6.15c0.042-0.034-0.093-0.149-0.32-0.171c-0.095-0.004-0.165,0.011-0.246,0.045
						c0.013,0.006,0.03,0.012,0.048,0.018C31.603,6.165,31.762,6.18,31.799,6.15z"/>
					<path d="M129.317,11.162c-0.046-0.207-0.27-0.244-0.776-0.284c-0.343-0.028-0.507-0.055-0.649-0.136
						c-0.118,0.021-0.425,0.066-0.146,0.187C128.057,11.067,128.852,11.185,129.317,11.162z"/>
					<path d="M143.18,12.013c0,0,0.584,0.048,0.769,0.025c0.064-0.007,0.364-0.141-0.19-0.225
						c-0.353-0.049-0.565-0.058-0.66-0.06c-0.448-0.009-0.625,0.057-0.566,0.227c0.012,0,0.019-0.003,0.023-0.003
						C142.72,11.969,142.986,11.992,143.18,12.013z"/>
					<path d="M141.766,11.857c0,0-0.105-0.178-0.79-0.207c-0.012,0-0.942-0.021-0.543,0.163
						C140.875,12.018,141.743,11.918,141.766,11.857z"/>
					<path d="M158.447,12.848c-0.577-0.391-2.029-0.494-2.841-0.522c-0.554-0.015-0.874-0.006-1.226,0.025
						c0.012,0.011,0.047,0.026,0.064,0.034C155.229,12.749,156.372,12.788,158.447,12.848z"/>
					<path d="M29.626,6.826c0.188,0.112,0.456,0.154,0.585,0.089c0.124-0.068-0.257-0.244-0.66-0.272
						c-0.042-0.003-0.076-0.003-0.118-0.006C29.472,6.702,29.524,6.763,29.626,6.826z"/>
					<polygon points="27.895,6.817 27.728,6.616 27.403,6.593 27.571,6.794 "/>
					<path d="M22.036,6.98c1.506,0.228,2.595,0.38,3.956,0.438C26.65,7.68,26.813,8,27.875,8.21
						c0.021,0,0.049,0,0.067-0.003c0.1-0.026,0.11-0.061,0.117-0.092c0.492,0.161,0.786,0.293,1.216,0.539
						c1.777-0.456,3.803,0.139,5.713,0.019c-0.304-0.219-0.426-0.308-1.17-0.442c-0.775-0.147-0.857-0.179-1.228-0.365
						c-0.202,0-0.674,0.003-1.881-0.227c-0.927-0.179-1.282-0.202-1.45-0.092c-0.408-0.145-0.77-0.299-1.067-0.465
						c-0.157-0.087-0.157-0.087-0.348-0.089c-0.182,0.037-0.178,0.117,0.041,0.364c-0.035,0.006-0.091,0.014-0.129,0.02
						c-0.622-0.077,0.03-0.396-0.755-0.353c-0.083-0.012-0.172-0.021-0.267-0.018c0.042,0.092,0.348,0.172,0.322,0.272
						c-0.095,0.009-0.218,0.026-0.334-0.014c-0.041-0.015-0.085-0.031-0.114-0.047c-0.27-0.123,0.026-0.313-0.79-0.369
						c-1.103-0.078-1.463-0.078-1.74,0.065c-0.896-0.23-1.213-0.27-1.562-0.305c-0.037-0.003-0.096-0.005-0.141-0.005
						c-0.05,0.051-0.118,0.123-0.167,0.178c-0.322,0.006-0.448-0.081-0.767-0.078C21.241,6.86,21.715,6.933,22.036,6.98z"/>
					<path d="M148.756,14.008c1.58,0.127,3.265,0.143,4.88,0.238c7.403,0.428,7.403,0.428,8.759,1.046
						c7.238,0.361,7.238,0.361,8.063,0.134c-1.357-0.321-1.214-0.718-1.145-0.833c0.061-0.083,0.171-0.257-1.801-0.607
						c-2.837-0.5-6.52-0.472-9.656-0.788c-0.294,0.23,0.59,0.437,0.295,0.673c-0.744-0.184-1.898-0.275-2.263-0.54
						c-3.361-0.018-3.561-0.018-4.421,0.428c-1.587-0.238-3.49-0.158-5.212-0.262c0.154,0.062,0.319,0.149,0.507,0.204
						C147.413,13.898,148.062,13.953,148.756,14.008z"/>
					<path d="M95.297,11.449c0.283,0.026,1.13,0.105,2.582,0.141c3.052,0.077,4.055,0.35,4.715,0.533
						c0.164-0.021,0.377-0.054,0.542-0.079c-0.1-0.235-0.129-0.316-0.754-0.422c-0.478-0.084-0.478-0.084-0.877-0.302
						c-0.502-0.086-0.89-0.13-1.562-0.161c-1.333-0.037-2.253,0.021-2.8,0.175c-1.632-0.181-2.241-0.249-2.104,0.089
						C95.114,11.429,95.214,11.441,95.297,11.449z"/>
					<path d="M110.263,11.911c0.064-0.046-0.03-0.111-0.078-0.149c-0.311-0.031-0.542-0.101-0.907-0.12
						c-0.078,0-0.561,0.022-0.249,0.158C109.337,11.929,110.128,12.021,110.263,11.911z"/>
					<path d="M103.832,12.348c0.329,0.012,0.647,0.026,0.979,0.037c-0.366-0.215-0.709-0.31-1.186-0.33
						c-0.094-0.003-0.182-0.003-0.283,0c0.124,0.087,0.29,0.201,0.419,0.288C103.785,12.346,103.808,12.348,103.832,12.348z"/>
					<path d="M77.508,11.806c0.249-0.01,0.584-0.026,0.831-0.01c0.809,0.047,1.315,0.13,2.34,0.293
						c0.577,0.099,0.942,0.144,1.185,0.139c0.359-0.018,0.488-0.139,0.949-0.106c0.154,0.012,0.294,0.055,0.359,0.075
						c-0.135-0.129-0.229-0.184-0.73-0.25c-0.342-0.052-0.636-0.115-0.995-0.158c-0.055-0.009-0.12-0.014-0.166-0.02
						c-0.707-0.081-1.498-0.069-2.247-0.112c-1.697-0.095-2.457-0.514-4.178-0.601c-0.989-0.046-2.033-0.021-2.971-0.13
						c0.071,0.034,0.143,0.084,0.212,0.118C73.702,11.854,77.474,11.809,77.508,11.806z"/>
					<path d="M35.299,9.474c0.03,0.014,0.07,0.034,0.1,0.049c0.129-0.018,0.129-0.018,0.049-0.247
						c0.004,0,0.007,0,0.013,0c0.135,0.055,0.19,0.12,0.345,0.178c0.008,0.003,0.092,0.015,0.116-0.014
						c0.046-0.038-0.08-0.158-0.197-0.271c-0.064-0.061-0.14-0.124-0.165-0.192c-0.013,0-0.026,0-0.04,0
						C34.935,8.948,34.899,9.241,35.299,9.474z"/>
					<path d="M102.93,12.953c-0.861-0.028-1.321-0.028-2.021,0.013c0.082,0.061,0.212,0.14,0.342,0.2
						c0.334,0.144,0.753,0.222,1.16,0.296c1.127,0.212,1.48,0.33,1.811,0.756c0.525,0.04,0.879,0.101,1.874,0.313
						c0.684,0.146,1.333,0.287,1.827,0.299c0.567,0.011,0.855-0.135,0.99-0.207c0.402-0.194,0.473-0.21,0.874-0.281
						c-0.619-0.345-1.438-0.672-2.123-1.011C103.632,12.985,103.632,12.985,102.93,12.953z"/>
					<path d="M110.333,13.804l-0.159-0.181c-0.046-0.005-0.095-0.012-0.148-0.015c-0.289-0.009-0.182,0.112-0.03,0.279
						C110.098,13.861,110.233,13.83,110.333,13.804z"/>
					<path d="M46.594,10.946c0.317,0.018,0.633,0.037,0.949,0.055c-0.362-0.25-0.632-0.419-1.07-0.45
						c-0.093-0.003-0.19,0-0.277,0.008c0.101,0.115,0.232,0.268,0.333,0.383C46.55,10.944,46.574,10.946,46.594,10.946z"/>
					<path d="M41.214,10.823c0.006,0.003,0.009,0.008,0.013,0.011c0.033,0.021,0.06,0.041,0.086,0.061
						c0.103-0.045,0.244-0.108,0.349-0.152c-0.211-0.126-0.455-0.197-0.853-0.243C40.871,10.622,40.904,10.643,41.214,10.823z"/>
					<path d="M28.131,9.763c-0.112-0.082-0.169-0.108-0.263-0.12c-0.238-0.006-0.342,0.115-0.533,0.063
						c0.043,0.04,0.089,0.075,0.146,0.109c0.121,0.072,0.207,0.075,0.263,0.068C27.995,9.867,27.961,9.799,28.131,9.763z"/>
					<path d="M74.374,12.531c0.021,0.013,0.052,0.023,0.082,0.034c0.312,0.139,0.695,0.184,0.955,0.21
						c0.701,0.067,1.456,0.049,2.182,0.084c-0.308-0.11-0.826-0.241-2.088-0.311C74.975,12.526,74.668,12.526,74.374,12.531z"/>
					<path d="M44.846,11.371c0.144-0.079,0.144-0.178,0.355-0.258c0.146-0.058,0.262-0.055,0.446-0.049
						c0.003-0.037,0-0.078-0.173-0.101c-0.014-0.004-0.039-0.006-0.059-0.009c-0.306-0.031-0.653-0.009-0.967-0.037
						c-0.531-0.052-0.872-0.17-1.43-0.213c-0.098-0.003-0.188,0-0.283,0.006c0.101,0.075,0.207,0.149,0.33,0.218
						C43.661,11.271,44.407,11.636,44.846,11.371z"/>
					<path d="M36.668,10.499c0.065-0.035,0.036-0.092-0.106-0.173l-0.417,0.065c0.016,0.021,0.038,0.044,0.072,0.061
						C36.348,10.524,36.583,10.538,36.668,10.499z"/>
					<path d="M35.377,10.47c0.026,0.018,0.064,0.037,0.106,0.052c0.121-0.018,0.283-0.046,0.403-0.063
						c-0.055-0.089-0.3-0.115-0.367-0.121C35.307,10.326,35.195,10.37,35.377,10.47z"/>
					<path d="M83.132,13.227c0.135,0.069,0.27,0.075,0.377,0.021c0.058-0.032,0.082-0.069,0.104-0.106
						c-0.229-0.069-0.366-0.098-0.495-0.104C82.794,13.026,83.132,13.227,83.132,13.227z"/>
					<path d="M84.971,13.761c0.27,0,0.824,0.034,0.93,0.046c0.448,0.046,1.12,0.026,1.304-0.005
						c0.158-0.023,0.617-0.168-0.195-0.362c-0.378-0.093-0.897-0.155-1.521-0.185c-0.507-0.02-0.779-0.014-0.991,0.023
						c0.131,0.144,0.295,0.336,0.425,0.482C84.941,13.761,84.953,13.761,84.971,13.761z"/>
					<path d="M177.833,17.315c0.23,0.015,0.454,0,0.678,0.007c-0.249-0.11-0.607-0.176-1.145-0.21
						c0.012,0.031,0.024,0.095,0.129,0.143C177.59,17.296,177.72,17.307,177.833,17.315z"/>
					<path d="M125.109,15.788c0.383,0.052,0.459-0.026,0.459-0.026c0-0.003-0.058-0.187-0.942-0.221
						c-0.249-0.008-0.507-0.008-0.761-0.018c0.011,0.003,0.03,0.01,0.042,0.01C124.308,15.619,124.638,15.725,125.109,15.788z"/>
					<polygon points="67.347,14.295 66.982,14.082 66.88,14.364 "/>
					<path d="M76.4,16.055c0.107-0.068-0.365-0.151-0.365-0.151c-0.153-0.003-0.07,0.097,0.03,0.149
						C76.159,16.099,76.295,16.124,76.4,16.055z"/>
					<path d="M139.03,19.918c0.283,0.063,0.549-0.041,0.809-0.067c-0.078-0.1-0.454-0.123-0.56-0.129
						C138.607,19.702,138.984,19.905,139.03,19.918z"/>
					<path d="M73.335,17.281c0.59,0.27,1.262,0.264,2.371,0.259c-0.214-0.144-0.461-0.204-0.973-0.233
						c-0.49-0.021-1.014,0.006-1.467-0.06C73.288,17.259,73.312,17.271,73.335,17.281z"/>
					<path d="M24.868,15.316c0.063,0.023,0.141,0.058,0.202,0.081c0.737,0.282,1.305,0.29,1.967,0.299
						c0.501,0.008,1.274,0.052,1.397,0.063c0.07,0.006,0.163,0.018,0.237,0.023c1.233,0.139,2.474,0.271,3.705,0.408
						c0.676,0.077,1.333,0.166,1.994,0.247c0.064-0.047,0.18-0.126,0.448-0.132c0.465-0.018,0.797,0.079,1.249,0.076
						c-0.363-0.22-0.529-0.327-4.491-0.681C29.041,15.53,27.261,15.432,24.868,15.316z"/>
					<path d="M45.766,17.618c-0.163,0.048-0.343,0.1-0.77,0.071c-0.81-0.052-1.393-0.207-2.218-0.254
						c-0.757-0.039-1.503,0.122-2.263,0.01c-1.959-0.285-1.959-0.285-3.789-0.382c-1.908-0.104-2.724-0.161-3.809-0.275
						C32.348,16.988,32.321,17,32.14,17c-0.645,0.021-0.943-0.141-1.539-0.149c-0.462-0.006-0.75,0.307-0.06,0.439
						c0.647,0.124,1.206,0.172,1.443,0.192c0.073,0.006,0.171,0.011,0.244,0.018c1.002,0.074,2.063,0.068,3.091,0.108
						c1.274,0.047,1.37,0.063,2.098,0.213c0.531,0.104,0.798,0.158,1.133,0.151c0.341,0.296,1.108,0.429,1.694,0.486
						c0.361,0.04,0.745,0.043,1.125,0.058c1.289,0.054,2.104,0.31,3.321,0.394c0.163,0.014,0.227-0.037,0.257-0.063
						c0.132-0.109,0.181-0.152,1.91,0.061c1.415,0.171,1.949,0.241,2.761,0.212c0.069-0.246-0.227-0.485-0.238-0.729
						c1.06-0.003,2.089,0.086,3.159,0.069c0.86-0.021,1.005-0.055,1.435-0.155c-2.18-0.185-4.193-0.454-6.336-0.654
						C46.073,17.534,46.073,17.534,45.766,17.618z M39.53,17.878c-0.003-0.005-0.012-0.008-0.02-0.011
						c0.099,0.023,0.185,0.026,0.247,0.014c0.339,0.023,0.53,0.034,0.583,0.21C40.202,18.074,39.821,18.027,39.53,17.878z M45.188,18.502
						c-0.044-0.003-0.082-0.009-0.118-0.015c-0.333-0.058-0.327-0.206-0.465-0.296c0.145,0.032,0.329,0.026,0.365,0.023
						c0.428-0.023,0.517,0.071,0.551,0.111C45.128,18.31,45.581,18.52,45.188,18.502z"/>
					<path d="M28.277,17.098c0.817,0.114,1.091,0.338,1.769,0.479c0.064-0.02,0.154-0.055,0.212-0.074l-0.468-0.486
						c-0.206-0.058-0.478-0.132-0.777-0.154c-0.373-0.026-0.718,0.034-1.087,0.022c-0.462-0.201-0.772-0.275-1.316-0.327
						c-0.61-0.028-1.215,0.026-1.819,0.006c0.076,0.052,0.171,0.117,0.284,0.167c0.34,0.146,0.739,0.175,1.299,0.221
						c0.853,0.065,1.11,0.146,1.487,0.284C27.986,17.195,28.154,17.138,28.277,17.098z"/>
					<path d="M53.882,19.372c0.013,0,0.022,0.005,0.031,0.005c0.405,0.047,0.573,0.007,0.629-0.011
						c0.006,0,0.012-0.006,0.026-0.006c0.254-0.095-0.366-0.23-0.471-0.241C53.908,19.114,53.652,19.159,53.882,19.372z"/>
					<path d="M31.626,17.836c-0.379-0.078-0.886-0.098-1.328-0.146c0.639,0.209,0.69,0.468,1.101,0.694
						c0.075,0.041,0.162,0.081,0.283,0.112c0.041-0.081,0.006-0.16-0.03-0.238c-0.062-0.126-0.093-0.207-0.031-0.25
						c0.106-0.066,0.479,0.032,0.685,0.083C32.213,18.033,32.026,17.915,31.626,17.836z"/>
					<path d="M66.84,19.992c0.035,0.028,0.083,0.058,0.129,0.083c0.307,0.163,0.666,0.158,0.795,0.155
						C67.595,20.139,67.36,20.047,66.84,19.992z"/>
					<path d="M64.501,20.606c-0.289-0.017-0.289-0.017-0.855-0.235c-0.317-0.012-0.423,0.09-0.755,0.074
						c-0.188-0.011-0.369-0.089-0.494-0.144c0.036,0.102,0.095,0.195,0.19,0.293c0.152,0.149,0.211,0.305,0.393,0.457
						c0.03,0.025,0.171,0.049,0.243,0.066c0.022,0.008,1.938,0.477,3.023,0.154c0.194-0.055,0.371-0.109,0.613-0.109
						c0.219,0,0.661,0.063,0.842,0.087c0.626,0.086,1.203,0.12,1.287,0.126c0.672,0.023,1.179-0.2,1.902-0.08
						c-0.159-0.144-0.27-0.235-0.642-0.333c-0.567-0.149-1.42-0.101-2.134-0.149c-0.736-0.055-0.855-0.195-1.036-0.477
						c-0.143-0.232-0.377-0.345-1.333-0.402c-0.354-0.017-0.731-0.017-1.05-0.055c0.543,0.324,0.796,0.399,1.403,0.434
						c0.437,0.023,0.613,0.058,0.955,0.241C66.311,20.676,65.132,20.642,64.501,20.606z"/>
					<path d="M29.442,17.941c0.16-0.092-0.28-0.16-0.28-0.16c-0.121-0.006-0.056,0.086,0.03,0.132
						C29.262,17.953,29.362,17.982,29.442,17.941z"/>
					<path d="M83.144,21.808c0.283,0.025,0.565,0.002,0.277-0.257c-0.178-0.008-0.407-0.02-0.577-0.025l0.283,0.282
						H83.144z"/>
					<path d="M48.691,19.74c-1.163-0.067-2.369-0.09-3.509-0.179c0.138,0.179,0.212,0.275,0.536,0.422
						c0.153,0.066,0.33,0.135,0.49,0.204c0.05,0.026,0.067,0.063,0.153,0.083c0.064,0.015,0.24,0.038,0.366-0.066
						c0.095-0.086,0.068-0.175,0.259-0.249c0.067-0.031,0.311-0.037,0.445-0.055c0.35,0.095,0.465,0.224,0.88,0.304
						c0.458,0.092,1.32,0.187,1.592,0.184c0.177-0.045-0.005-0.12,0.171-0.166c0.195,0.012,0.371,0.035,0.53,0.066
						c0.007,0.003,0.642,0.112,0.879,0.08c0.327-0.043-0.008-0.327-0.02-0.33C51.46,20.038,50.439,19.851,48.691,19.74z"/>
					<path d="M82.365,21.732c0.146,0.066,0.473,0.124,0.53,0.08c0.059-0.043-0.224-0.167-0.347-0.221
						C82.194,21.623,82.253,21.684,82.365,21.732z"/>
					<polygon points="51.832,20.245 52.179,20.268 51.983,20.067 51.636,20.05 "/>
					<path d="M28.8,18.727c0.248,0.14,0.546,0.14,0.669,0.137c-0.201-0.112-0.455-0.184-0.795-0.227
						C28.708,18.666,28.747,18.697,28.8,18.727z"/>
					<path d="M33.642,19.441c-0.158-0.01-0.154,0.065-0.062,0.114c0.039,0.022,0.227,0.109,0.475,0
						C33.824,19.463,33.712,19.446,33.642,19.441z"/>
					<polygon points="81.988,22.301 81.447,22.275 81.634,22.45 82.177,22.479 "/>
					<path d="M59.19,21.233c0.129,0.068,0.289,0.073,0.577,0.092c-0.119-0.058-0.254-0.133-0.364-0.19l-0.354-0.02
						C59.083,21.155,59.12,21.192,59.19,21.233z"/>
					<polygon points="31.735,19.562 32.045,19.584 31.862,19.403 31.549,19.381 "/>
					<path d="M29.153,19.481c0.153,0.083,0.254,0.08,0.395,0.052c0.075-0.021,0.191-0.034,0.451,0
						c-0.084-0.087-0.198-0.199-0.283-0.282c-0.094,0.061-0.112,0.061-0.392,0.031C29.316,19.279,28.694,19.234,29.153,19.481z"/>
					<path d="M41.831,21.681c0.036,0.017,0.077,0.046,0.117,0.066c0.841,0.398,2.854,0.246,3.048,0.16
						c0.101-0.043,0.006-0.118-0.129-0.215C42.813,21.583,42.324,21.561,41.831,21.681z"/>
					<path d="M37.385,21.517c0.16,0.084,0.353,0.089,0.624,0.095c0.165,0.007,0.348-0.008,0.497,0.018
						c-0.058-0.052-0.129-0.126-0.19-0.184c-0.187-0.133-0.329-0.184-0.571-0.207C37.567,21.23,36.917,21.278,37.385,21.517z"/>
					<path d="M40.367,21.663c0.243,0.133,0.516,0.136,0.684,0.139c-0.168-0.196-0.401-0.296-0.745-0.322
						c-0.053,0-0.109-0.003-0.165-0.003C40.192,21.54,40.255,21.604,40.367,21.663z"/>
					<path d="M34.862,21.21c0.043,0.034,0.086,0.061,0.138,0.089c0.188,0.098,0.401,0.135,0.542,0.152
						c0.382,0.042,0.817,0.034,1.215,0.06c-0.172-0.129-0.45-0.284-1.106-0.335C35.251,21.152,35,21.181,34.862,21.21z"/>
					<path d="M32.313,21.255c0.858,0.007,1.282,0.023,1.648,0.064c-0.434-0.207-0.767-0.313-1.934-0.4
						c-0.931-0.065-1.921-0.052-2.856-0.117c0.086,0.028,0.191,0.068,0.28,0.092C30.503,21.213,31.44,21.247,32.313,21.255z"/>
					<path d="M39.118,21.5c0.046,0.037,0.094,0.074,0.167,0.105c0.247,0.124,0.536,0.121,0.663,0.121
						c-0.051-0.105-0.135-0.181-0.41-0.201C39.404,21.514,39.237,21.525,39.118,21.5z"/>
					<path d="M28.959,20.951c0.079-0.04-0.036-0.126-0.092-0.166c-0.024,0.028-0.059,0.074-0.218,0.063
						c-0.311-0.023-0.448-0.093-0.69-0.133c0.027,0.028,0.06,0.058,0.116,0.086C28.308,20.917,28.83,21.021,28.959,20.951z"/>
					<path d="M50.958,26.071c0.007-0.003,0.463-0.301-0.736-0.391c-0.448-0.025-0.942-0.015-1.337-0.083
						c0.023,0.011,0.05,0.028,0.076,0.04C49.509,25.91,50.673,26.218,50.958,26.071z"/>
					<path d="M41.3,25.362c-0.034-0.023-0.068-0.05-0.111-0.071c-0.003-0.004-0.01-0.01-0.019-0.013
						c-0.124-0.065-0.283-0.126-0.599-0.151c-0.037,0-0.082-0.003-0.119-0.006c0.04,0.034,0.085,0.063,0.138,0.092
						C40.848,25.345,41.109,25.356,41.3,25.362z"/>
					<path d="M28.784,24.472c-0.029-0.021-0.056-0.037-0.084-0.055c-0.006-0.003-0.009-0.009-0.014-0.009
						c-0.131-0.074-0.301-0.149-0.56-0.172c0.017,0.012,0.036,0.022,0.052,0.034C28.45,24.427,28.644,24.458,28.784,24.472z"/>
					<path d="M54.248,26.177c-0.165-0.011-0.35,0.01-0.515-0.011l0.835,0.132C54.495,26.224,54.413,26.195,54.248,26.177z
						"/>
					<path d="M111.264,29.904c-0.23-0.108-0.442-0.218-0.607-0.33c-0.082,0.021-0.247,0.066-0.524,0.044
						c-0.524-0.044-0.879-0.146-1.361-0.198l0.106,0.267c0.029,0.003,0.072,0.006,0.106,0.006c1.426,0.115,1.369,0.574,2.922,0.657
						C111.954,30.247,111.812,30.169,111.264,29.904z"/>
					<path d="M103.183,29.187l0.308,0.275c-0.638-0.103-1.009-0.131-1.798-0.134c-0.654-0.003-1.019-0.037-1.486-0.098
						c0.046,0.011,0.101,0.028,0.148,0.043c1.562,0.393,3.867,0.407,5.499,0.29c-0.207-0.086-0.459-0.193-0.884-0.251
						C104.42,29.233,103.737,29.256,103.183,29.187z"/>
					<polygon points="106.837,29.417 107.168,29.71 107.769,29.732 107.245,29.434 "/>
					<path d="M59.75,27.393c0.265-0.026,0.146-0.112,0.017-0.184c-0.011-0.006-0.011-0.009-0.024-0.016
						c-0.058-0.028-0.116-0.058-0.175-0.079c-0.101-0.01-0.237-0.018-0.343-0.023l0.501,0.304C59.731,27.395,59.743,27.395,59.75,27.393z
						"/>
					<path d="M27.397,25.401c0,0,0.006,0,0.009,0c0.174-0.011,0.242,0.023,0.347,0.041
						c0.969,0.155,1.233,0.195,0.917-0.109c-0.685-0.011-1.033-0.106-1.359-0.373C27.017,25.012,26.961,25.089,27.397,25.401z"/>
					<path d="M141.023,31.447c0.294,0.022,0.684,0.055,0.985,0.074c1.868,0.106,3.8,0.135,5.676,0.238
						c1.078,0.061,1.915,0.27,3.113,0.247c0.152-0.052,0.135-0.12,0.317-0.169c0.047-0.003,0.106-0.006,0.146-0.003
						c1.233,0.089,2.234,0.28,3.46,0.37c1.767,0.13,3.612,0.181,5.411,0.281c0.473,0.026,0.93,0.049,1.403,0.066
						c2.616,0.095,2.627,0.092,3.17-0.115c0.578,0.021,0.565,0.218,1.231,0.213c0.076-0.026,0.076-0.026-0.759-0.383
						c1.261,0.17,2.181,0.435,3.464,0.592c0.567,0.066,1.251,0.021,1.469,0.003c-0.313-0.247-1.58-0.173-2.17-0.327
						c0.053-0.08,0.111-0.184,0.16-0.261c-0.507-0.207-0.85-0.144-1.302,0.04c-0.23-0.084-0.537-0.199-0.772-0.288
						c-3.042-0.076-3.042-0.076-3.843-0.286c-5.304,0.065-9.919-0.565-14.972-0.756c-1.486-0.043-2.923,0.123-4.421,0.049
						c-1.414-0.071-2.757-0.21-4.218-0.244c-0.083,0-0.178,0-0.255-0.005c-0.725-0.01-1.12,0.024-1.372,0.048
						c0.304,0.065,0.707,0.155,1.037,0.215C139.279,31.289,140.706,31.427,141.023,31.447z"/>
					<path d="M30.33,25.713c0.195,0.014,0.57,0.005,0.57,0.005c0.288-0.011,0.502-0.005,0.922,0.023
						c-0.251-0.104-0.627-0.225-1.364-0.285c-0.579-0.036-0.923-0.008-1.111,0.021c0.046,0.018,0.102,0.04,0.156,0.055
						C29.934,25.672,30.17,25.695,30.33,25.713z"/>
					<path d="M52.796,27.597c0.405,0.048,0.761,0.071,0.408-0.179c-0.097-0.072-0.097-0.072-0.303-0.086
						c-0.124-0.006-0.185,0-0.248,0.014c-0.003,0.004-0.006,0.004-0.015,0.004c-0.087,0.04-0.053,0.108,0.115,0.241
						C52.768,27.594,52.79,27.597,52.796,27.597z"/>
					<path d="M50.27,27.269c0.032,0.012,0.071,0.021,0.099,0.029c0.804,0.218,1.592,0.252,1.887,0.264
						c-0.089-0.072-0.374-0.287-1.252-0.348C50.642,27.19,50.396,27.211,50.27,27.269z"/>
					<path d="M49.22,27.28c-0.157-0.074-0.372-0.145-0.899-0.184c-0.38-0.023-0.768-0.012-1.149-0.023
						c0.024,0.007,0.058,0.015,0.08,0.021C47.991,27.309,48.451,27.298,49.22,27.28z"/>
					<path d="M46.924,27.172c0.051-0.036-0.035-0.096-0.073-0.121c-0.148-0.009-0.339-0.021-0.484-0.028
						c0.018,0.028,0.048,0.063,0.11,0.092C46.617,27.183,46.854,27.214,46.924,27.172z"/>
					<path d="M152.104,32.501c-0.013-0.003-1.968-0.104-4.267-0.179c-6.095-0.201-6.095-0.201-8.334-0.333
						c0.095,0.035,0.199,0.087,0.318,0.115c0.212,0.058,0.777,0.213,10.385,0.715c4.362,0.23,6.248,0.207,7.048,0.198
						c-2.569-0.229-4.172-0.385-4.745-0.462C152.388,32.542,152.234,32.513,152.104,32.501z"/>
					<path d="M158.481,33.018c-0.476-0.006-0.801-0.046-1.108-0.09c0.095,0.05,0.201,0.107,0.319,0.153
						c0.555,0.213,0.831,0.2,2.4,0.143c0.371-0.011,0.777-0.028,1.107,0.013c-0.383-0.179-0.607-0.23-1.067-0.253
						C159.566,32.972,159.036,33.029,158.481,33.018z"/>
					<path d="M164.163,33.236c-0.477-0.018-0.937-0.061-1.424-0.069c-0.107-0.003-0.254-0.006-0.366,0
						c-0.512,0.006-0.567,0.109-0.607,0.178c0.024-0.006,0.053-0.012,0.064-0.017c0.943-0.173,2.134,0.27,2.811,0.008
						c0.194,0.061,0.448,0.145,0.643,0.204c1.544-0.042,2.299-0.055,3.588,0.015c-0.63-0.192-1.16-0.261-2.293-0.308
						C165.778,33.23,164.965,33.265,164.163,33.236z"/>
					<path d="M171.354,33.719c0.512,0.014,1.032,0.031,1.551,0.045c-0.172-0.12-0.75-0.247-1.233-0.27
						c-0.482-0.009-0.447,0.115-0.365,0.225C171.319,33.719,171.343,33.719,171.354,33.719z"/>
					<path d="M169.669,33.373c-0.465-0.008-0.896,0.084-0.459,0.285c0.011-0.003,0.023-0.003,0.035-0.003
						c0.146-0.01,0.335,0,0.577,0.017c0.459,0.038,0.613,0.026,0.662,0.013c0.129-0.044-0.049-0.22-0.484-0.282
						C169.899,33.391,169.792,33.38,169.669,33.373z"/>
					<path d="M176.531,33.815c0.01-0.045-0.036-0.092-0.089-0.137c-0.795,0.224-1.833-0.185-2.711,0.017
						c0.01,0.005,0.029,0.012,0.052,0.018C174.089,33.787,176.476,34.12,176.531,33.815z"/>
					<path d="M49.161,28.556c-0.23-0.009-0.416,0.055-0.006,0.401c0.012-0.006,0.027-0.012,0.046-0.017
						c0.197-0.081,0.378-0.044,0.584,0.005c0.359,0.087,0.53,0.069,0.713,0.006c-0.094-0.006-0.224-0.014-0.321-0.017
						C49.718,28.624,49.282,28.566,49.161,28.556z"/>
					<path d="M44.333,28.372c-0.187-0.041-0.455-0.041-0.659-0.07c-0.071-0.011-0.166-0.027-0.216-0.039
						c-0.034-0.015-0.092-0.029-0.121-0.035c-0.109-0.039-0.084-0.092-0.3-0.114c-0.024,0-0.046,0-0.064,0
						c-0.075,0.022-0.083,0.039,0.04,0.184c0.125,0.132,0.129,0.155,0.056,0.178c-0.078,0-0.139-0.012-0.19-0.022
						c0.04,0.017,0.097,0.037,0.138,0.051c0.251,0.087,0.498,0.139,0.742,0.162c0.411,0.04,0.838,0.011,1.259,0.024
						c-0.184-0.134-0.33-0.224-0.56-0.289C44.432,28.389,44.375,28.377,44.333,28.372z"/>
					<path d="M56.692,29.428c-0.132-0.117-0.307-0.275-0.442-0.394c-0.089-0.008-0.184-0.02-0.273-0.022
						c-0.294-0.014-0.294-0.014-0.955,0.041c0.065,0.04,0.129,0.079,0.218,0.117C55.589,29.336,56.054,29.417,56.692,29.428z"/>
					<path d="M53.971,29.17c0.261,0.017,0.52,0.034,0.778,0.046c-0.126-0.081-0.251-0.109-0.479-0.139
						c-0.293-0.04-0.406-0.082-0.521-0.194l0.167,0.28C53.938,29.166,53.957,29.17,53.971,29.17z"/>
					<polygon points="45.539,28.633 45.746,28.812 46.067,28.834 45.857,28.652 "/>
					<path d="M58.789,31.329c0.089-0.046-0.065-0.154-0.129-0.209c-0.376,0.002-0.564-0.075-0.883-0.102
						c-0.107-0.003-0.167,0.004-0.289,0.032c0.018,0.006,0.027,0.015,0.046,0.02C57.833,31.22,58.617,31.41,58.789,31.329z"/>
					<path d="M50.816,30.663c0.055,0.029,0.148,0.049,0.246,0.063c0.208,0.04,0.306,0.074,0.377,0.207
						c0.392,0.024,0.343-0.107,0.583-0.145c-0.184-0.144-0.359-0.189-0.825-0.222c-0.171-0.008-0.362-0.005-0.519-0.031
						C50.706,30.58,50.73,30.623,50.816,30.663z"/>
					<path d="M48.572,30.646c0.035-0.022,0.035-0.068-0.159-0.167l-0.38,0.052c0.02,0.021,0.046,0.044,0.087,0.063
						C48.274,30.672,48.508,30.686,48.572,30.646z"/>
					<polygon points="47.941,30.703 47.711,30.508 47.23,30.476 47.461,30.675 "/>
					<path d="M45.834,30.53c0.006,0.006,0.011,0.013,0.02,0.016c0.017,0.008,0.038,0.017,0.056,0.024
						c0.089,0.007,0.218,0.013,0.313,0.018l0.016-0.086c-0.076-0.089-0.242-0.115-0.337-0.126C45.757,30.37,45.611,30.404,45.834,30.53z"
						/>
					<polygon points="143.687,35.435 143.487,35.264 143.045,35.246 143.251,35.424 "/>
					<path d="M164.441,16.351c-0.926-0.005-0.938,0.016-1.021,0.092c-0.093,0.087-0.224,0.092-0.605,0.084
						c-0.973-0.021-1.716-0.204-2.735-0.199c-0.319,0.006-0.501,0.053-0.607,0.081c0.07,0.058,0.178,0.132,0.318,0.184
						c0.949,0.367,2.635,0.574,6.017,0.741c1.94,0.095,2.428,0.058,3.497-0.27c0.093,0.028,0.223,0.074,0.329,0.103
						c-0.631-0.626-4.08-0.781-4.761-0.804C164.729,16.356,164.583,16.354,164.441,16.351z"/>
					<path d="M38.981,27.659c0.107,0.23-0.022,0.271-0.642,0.184c-1.368-0.189-0.675,0.235-0.346,0.437
						c0.03,0.003,0.059,0.003,0.081,0.003c0.804,0.026,2.09,0.173,2.099,0.176c1.185,0.137,1.815,0.178,2.661,0.086
						c-0.625-0.355-1.165-0.454-2.148-0.534C39.9,27.947,39.465,27.906,38.981,27.659z"/>
					<path d="M24.931,27.125c0.014,0.092,0.017,0.118,0.191,0.167c0.35,0.095,0.35,0.095,0.464,0.224
						c0.922,0.006,0.976,0.006,0.969-0.17c0.139,0.087,0.323,0.201,0.462,0.285c3.664,0.172,3.664,0.172,4.352,0
						c-0.008,0.083-0.076,0.17,0.024,0.256c0.774,0.005,1.229,0.031,2.5,0.126c2.081,0.152,2.725,0.149,3.634-0.021
						c-0.693-0.218-0.731-0.302-0.915-0.684c0.148,0.092,0.339,0.213,0.481,0.305c0.995,0.006,1.302-0.029,1.42-0.247
						c2.066,0.106,2.066,0.106,3.133,0.385c-0.165-0.12-0.195-0.244-0.266-0.367c1.42-0.175,2.704-0.228,4.892-0.201
						c-0.969-0.644-2.569-0.558-2.755-0.545c-0.158-0.023-0.428-0.063-1.115-0.411c-4.331-0.265-7.044-0.644-8.503-0.847
						c-0.484,0.229-0.74,0.252-2.125,0.189c0.742,0.603,0.742,0.603,4.124,1.252c-0.038-0.003-0.083,0-0.125,0
						c-0.182,0.109-0.028,0.226-0.165,0.338c-0.851,0.095-1.166-0.144-1.753-0.215c-0.072,0.341,0.899,0.598,0.908,0.598
						c0.003,0.002,0.027,0.229-0.995,0.014c-0.218-0.043-0.411-0.092-0.615-0.138c-0.126,0.069-0.283,0.121-0.99,0.023
						c-1.022-0.138-1.325-0.136-1.381,0.143c-0.185-0.097-0.44-0.224-0.63-0.32c-0.106,0.074-0.119,0.079-0.283,0.097
						c-0.505-0.052-0.705-0.201-1.338-0.206c-0.445-0.006-0.891,0.052-1.344,0c-0.362-0.04-0.608-0.121-0.792-0.184
						C26.559,27.266,26.404,27.251,24.931,27.125z"/>
					<path d="M112.979,29.681c-0.012,0-0.024,0-0.036,0c-0.312,0-0.366,0.069-0.553,0.104
						c-0.201,0.037-0.307,0.006-0.408-0.063c-0.229-0.002-0.252,0.034-0.064,0.118c0.141,0.061,0.389,0.123,0.435,0.084
						c0.049-0.032-0.022-0.063-0.058-0.098c0.217,0.085,0.5,0.203,0.718,0.292C113.604,30.054,113.122,29.698,112.979,29.681z"/>
					<path d="M46.35,28.658h-0.002c0.196,0.069,0.537,0.099,0.798,0.149C47.14,28.808,46.58,28.679,46.35,28.658z"/>
					<path d="M58.224,19.412c-0.332-0.012-0.661,0-0.991-0.015c-0.313-0.009-0.554-0.083-0.926-0.058
						c-0.101,0.049-0.112,0.061-0.018,0.17c0.26,0.021,0.608,0.046,0.872,0.065c3.213,0.236,3.997,0.325,6.023,0.679
						c0.203-0.112,0.237-0.133,0.884-0.104c0.526,0.021,0.502-0.071,0.442-0.278c-1.938-0.327-2.067-0.372-2.073-0.379
						c-0.337-0.135,0.406-0.215,0.342-0.339c0.748,0.181,1.583-0.023,2.369,0.029c0.901,0.058,1.68,0.189,2.6,0.235
						c0.059,0.006,0.141,0.006,0.199,0.011c0.23,0.006,0.384-0.017,0.614-0.063c0.306-0.063,0.565-0.121,2.564,0.021
						c0.63,0.045,1.101,0.16,1.75,0.197c1.095,0.063,1.143,0.063,1.166-0.031c0.013-0.032-0.023-0.071-0.046-0.104
						c0.602,0.077,0.542,0.268,1.154,0.342c0.064-0.051,0.154-0.124,0.224-0.179c-0.435-0.231-0.782-0.26-2.069-0.372
						c-0.558-0.047-1.083,0.042-1.632,0.017c-2.487-0.117-4.698-0.413-7.131-0.563c-3.088-0.161-3.372-0.115-3.926-0.021
						c-3.57-0.703-3.866-0.049-3.872-0.042c0.006,0.002,0.2,0.14,0.701,0.218c0.224,0.034,0.224,0.034,1.545,0.092
						c1.055,0.045,1.439,0.286,2.276,0.396C60.775,19.449,60.369,19.47,58.224,19.412z"/>
					<path d="M87.063,20.985c0.171-0.04,0.401-0.028,0.616-0.022c-0.224-0.012-0.437-0.028-0.676-0.035L87.063,20.985z"/>
					<path d="M29.122,28.199c-3.31-0.493-7.263-0.58-10.876-0.876c-0.303,0.032-0.704,0.077-1.01,0.111
						c-1.439-0.166-2.705-0.396-4.129-0.571c0.036,0.095,0.079,0.222,0.118,0.322c6.378,1.071,14.144,1.267,21.593,1.668
						c-1.671-0.178-3.259-0.41-4.682-0.764C29.831,28.125,29.427,28.168,29.122,28.199z"/>
					<path d="M40.453,29.227c-1.842-0.143-3.72-0.272-5.636-0.373C36.61,29.04,38.503,29.155,40.453,29.227z"/>
					<path d="M123.5,24.225c0.218,0.098,0.86,0.259,1.38,0.189c-0.129-0.126-0.302-0.296-0.431-0.422
						c-0.07,0.063-0.199,0.083-0.494,0.109C123.547,24.136,123.399,24.179,123.5,24.225z"/>
					<path d="M852.688,17.336c0.33,0.135,0.885,0.262,1.037,0.152c0.036-0.023,0.042-0.053,0.047-0.074
						c-0.129-0.029-0.306-0.073-0.435-0.102c-0.408-0.095-0.638-0.135-0.78-0.137C852.324,17.181,852.628,17.31,852.688,17.336z"/>
					<path d="M802.752,16.768c0.254,0.092,0.837,0.117,0.909,0.246c0.766-0.031,0.248-0.283-0.318-0.373
						c-0.148-0.022-0.313-0.036-0.49-0.043c-0.064,0.003-0.135,0.007-0.205,0.007C802.637,16.644,802.593,16.707,802.752,16.768z"/>
					<path d="M797.248,22.711c1.167,0.05,1.379-0.16,0.909-0.315c-0.066-0.02-0.144-0.04-0.218-0.055
						c-0.75,0.006-0.96,0.118-0.727,0.367C797.225,22.708,797.242,22.708,797.248,22.711z"/>
					<path d="M805.5,23.292c-0.678-0.296-0.883-0.385-1.096-0.595c-0.437,0.077-0.831,0.098-1.638,0.074
						c0.106,0.155,0.27,0.391,0.636,0.526C804.039,23.533,805.064,23.363,805.5,23.292z"/>
					<path d="M838.473,28.131c0.871-0.018,0.801-0.204,0.647-0.369c-0.146-0.011-0.294-0.021-0.459-0.028
						c-0.108,0-0.313,0-0.366,0.072c-0.071,0.109,0.129,0.215,0.106,0.325C838.424,28.131,838.448,28.131,838.473,28.131z"/>
					<path d="M847.29,33.917c0.028,0.003,0.059,0.003,0.076,0.006c0.75,0.051,1.314-0.095,2.015-0.09
						c-0.206-0.243-0.971-0.439-1.172-0.684c-0.106-0.002-0.224-0.005-0.342-0.008c-0.461,0.003-0.854,0.058-1.287,0.082
						C846.783,33.46,847.313,33.672,847.29,33.917z"/>
					<path d="M850.037,12.969c0.034-0.047,0.07-0.087,0.04-0.133l-0.831,0.282c0.024,0.017,0.049,0.042,0.106,0.063
						C849.564,13.255,849.9,13.105,850.037,12.969z"/>
					<path d="M771.208,34.571c0.14,0.006,0.33,0.015,0.471,0.02c-0.183,0.061-0.435,0.144-0.613,0.207
						c0.095,0.015,0.237,0.034,0.332,0.052c21.748,0.241,50.747,0.563,72.496,0.808c0.059-0.278,0.378-0.549,0.436-0.83
						c-0.389-0.032-0.914-0.074-1.308-0.109c0-0.018-1.864-2.32-2.192-2.539c-1.061-0.677-1.061-0.677-0.979-0.884
						c0.177-0.491,1.58-0.901,1.815-1.391c-0.141-0.011-0.323-0.025-0.466-0.037c-0.264-0.138-0.217-0.301-0.618-0.427
						c-0.235-0.01-0.554-0.019-0.79-0.029c0.266-0.402,0.183-0.604-0.4-0.971c-1.402,0.402-1.486,0.919-2.223,1.378
						c0.243,0.115,0.243,0.115,0.572,0.725c-0.6,0.12-0.6,0.12-0.366,0.37c-1.519-0.104-0.234-0.618-1.91-0.692
						c-0.612-0.028-3.901,0.184-2.899,1.119c-2.9-0.456-3.035-0.568-5.34-2.46c-0.417-0.034-0.784-0.065-1.391-0.364
						c-0.731-0.356-5.452-3.001-5.457-3.004l-1.367-0.396c-0.667-0.19-0.125-0.402-0.289-0.6l-0.95-0.199
						c-0.317-0.824-2.942-1.47-3.396-2.279c-0.589-0.052-0.589-0.052-2.476-0.914l-1.378-0.301c-0.165-0.456-0.165-0.456-0.955-0.608
						c-0.714-0.136-0.696-0.188-0.271-0.389c-1.061-0.092-1.002-0.384-1.851-0.511c-0.165-0.313-0.26-0.595-0.201-0.591
						c-2.05-0.385-2.145-1.018-3.583-1.482c-0.248-0.04-0.59-0.098-0.849-0.144c0.153,0.207,0.377,0.482,0.672,0.678
						c0.555,0.356,1.344,0.689,1.769,1.057c0.177,0.161-0.194,0.396,0.07,0.552c0.343,0.197,0.955,0.212,1.35,0.221
						c3.012,2.656,3.107,2.656,3.979,2.674c-1.031,1.395-1.031,1.395-0.66,1.874c-0.484,0.125-1.32,0.228-1.597,0.055
						c-0.666,0.23-0.938,0.503-0.919,0.67c0.849,0.043,1.644-0.118,2.504-0.031c0.148,0.092,0.148,0.092,0.118,0.166l5.908,0.069
						c-4.991-0.055-5.333-0.047-7.365,0.022c-0.076,0.023-0.182,0.055-0.258,0.078c1.492,0.66,0.501,1.524,3.396,2.063
						c0.371,1.546,0.371,1.546,0.259,1.644c-3.413-0.42-4.827-0.818-6.048-1.727c-1.154-0.864-1.48-0.864-2.246-0.87
						c1.251-0.551-1.39-0.891-1.444-1.367c0.006-0.367,0.006-0.367-0.142-0.505l-0.906-0.104c0.112-0.028,0.258-0.063,0.366-0.092
						c-0.491-0.138-1.209-0.206-1.799-0.321c0.036-0.21-0.543-0.388-0.696-0.589c-0.283-0.022-0.671-0.046-0.942-0.077
						c-0.059-0.006-4.882-0.694-1.121-0.908c-0.942-0.304,0.144-0.671-0.593-0.984c-0.761-0.003-1.528-0.009-2.035-0.072
						c-0.417-0.052-0.801-0.355,0.331-0.442c-0.285-0.031-0.684-0.086-0.797-0.149c-0.488-0.295,0.301-0.592-0.052-0.884
						c-0.212-0.175-1.192-0.182-1.432-0.351c0.065-0.018,0.141-0.046,0.206-0.063c0.083,0.003,0.188,0.005,0.271,0.005
						c0.058-0.012,0.141-0.031,0.2-0.039c-0.731-0.256-2.123-0.328-2.96-0.552c0.048-0.018,0.12-0.04,0.171-0.058
						c0.383,0.028,0.614,0.049,1.214,0.201c0.112-0.015,0.253-0.034,0.367-0.052c0.147-0.351,0.059-0.652-2.683-0.469
						c-0.165-0.191-0.106-0.206,0.165-0.264c1.568,0.037,1.568,0.037,1.397-0.235l-2.682-2.297c-0.106-0.089-0.308-0.213-0.459-0.302
						c-0.119-0.052-0.285-0.12-0.401-0.173c-0.636,0.247-1.581,0.437-2.321,0.66c0.317,0.339,0.765,0.669,1.143,0.999
						c0.235,0.214-0.938,0.233-1.139,0.388c-0.118,0.096,0.112,0.228,0.229,0.316c0.012,0.006,0.802,0.526,3.172,0.805
						c-1.097,0.468,0.549,0.861,0.708,1.294c0.023,0.081-0.201,0.185-0.142,0.265c0.106,0.157,0.235,0.21,0.695,0.377
						c0.602,0.209,0.497,0.283,0.277,0.43c-0.029-0.003-3.482-0.168-4.207-0.296c-0.755-0.131,0-0.304-0.138-0.453
						c-1.519-0.115-2.097-0.327-2.462-0.896c-1.274-0.173-1.486-0.259-2.83-0.815c-1.225,0.459,0.455,0.993-0.718,1.453
						c0.761,0.247,1.225,1.159,1.225,1.169c-1.166,0.226-1.166,0.226-1.108,0.307c-3.011-0.552-3.436-1.441-5.467-2.119
						c-1.327,0.293-1.91,0.545-1.511,1.551c-3.548-0.563-2.935-1.632-5.476-2.315c0.208-0.092-1.561-1.826-1.584-1.843
						c-0.436-0.287-1.097-0.365-1.857-0.454c0.237-0.441,0.159-0.511-1.479-0.608c-0.79,0.241,0.459,0.413,0.647,0.62
						c-0.566,0.158-0.854,0.144-1.143,0.126c-0.018-0.021-0.036-0.046-0.059-0.068c-0.659,0.16-0.289,0.265,1.484,0.608
						c0.036,0.494-0.452,0.982-0.306,1.477c0.848,0.045,2.593-0.182,2.576,0.098c-0.005,0.141-1.255,0.419-2.056,0.194
						c-0.661,0.621,1.839,0.937,2.668,1.407c-0.324,0.793,1.126,1.557,0.583,2.35c-0.022,0.031-0.271,0.298-2.392,0.259
						c-0.154,0.694,0.305,1.378,0.377,2.069c0.035,1.082,0.035,1.082,0.188,1.221c0.376,0.351,1.678,0.589,2.157,0.925
						c0.108-0.017,0.224-0.046,0.341-0.058c1.245-0.109,4.841,0.402,2.453,1.178c-0.471-0.028-1.507-0.209-0.86-0.405
						c0.148-0.003,0.353-0.008,0.507-0.011c-2.76-0.457-2.76-0.457-2.794-0.612c-0.484-0.017-1.139-0.046-1.633-0.066
						c0.053-0.065,0.065-0.151,0.041-0.215c-0.24,0.003-0.559,0.012-0.802,0.017c-0.342-0.464-0.347-0.482-1.674-0.453
						c-0.294,0.133-0.376,0.522,1.929,0.597c-1.238,0.247-0.359,0.561-0.519,0.839c-0.03,0.049-0.043,0.115-0.059,0.161
						c-0.077,0.311,0.082,0.546,0.146,0.646l1.002,0.309c-0.613,0.545,2.133,0.946,1.249,1.504c-0.989,0.029-0.989,0.029-1.627,0.132
						c-0.289,0.718-0.105,0.925,1.004,1.163c-0.531,0.934,0.665,1.852,0.329,2.789c1.627,0.385,1.627,0.385,1.581,0.647l3.039,0.033
						C770.796,34.659,770.796,34.659,771.208,34.571z M827.333,34.539c-0.503-0.006-0.891-0.022-1.327-0.192
						c-0.006-0.002-0.018-0.005-0.031-0.008C826.865,34.35,827.402,34.355,827.333,34.539z M814.295,29.216
						c0.081,0.16,0.152,0.321,0.229,0.484c-0.388-0.005-0.795-0.014-1.033-0.079C813.068,29.503,813.54,29.268,814.295,29.216z
						 M804.84,31.415l-0.095-0.189l0.86,0.012l0.094,0.189L804.84,31.415z M808.458,33.661l0.1,0.188l-0.794-0.011l-0.095-0.189
						L808.458,33.661z M806.703,30.08c0.04,0.089,0.094,0.21,0.142,0.299c-0.178,0.008-0.349,0.008-0.526,0.008
						c-0.423-0.006-0.772-0.037-1.119-0.166c-0.225-0.083-0.384-0.172-0.602-0.259C805.218,29.957,805.924,29.957,806.703,30.08z
						 M794.323,21.382c0.467,0.109,0.472,0.328-0.629,0.321c-0.077,0-0.147,0-0.218,0c-0.012,0-0.036,0-0.047,0
						c-0.047-0.12-0.106-0.278-0.152-0.398C793.818,21.291,794.148,21.339,794.323,21.382z M790.505,19.612
						c1.621-0.021,2.169,0.118,2.175,0.118c0.006,0.003,0.258,0.188-0.114,0.276c-0.27,0.068-0.659,0.085-1.413,0.103
						c-0.083-0.022-0.159-0.046-0.224-0.071C790.469,19.874,790.492,19.688,790.505,19.612z M788.407,20.759
						c-0.113,0.058-0.147,0.149-0.059,0.21c0.471,0.04,1.014,0.034,1.443,0.108c0.112,0.279,1.078,0.46,1.54,0.695
						c0.294,0.046,0.683,0.105,0.978,0.149c0.437,0.56,0.437,0.56,0.59,0.643c0.913,0.104,0.913,0.104,1.909,1.585
						c1.166,0.156,1.443,0.293,1.415,0.707c-0.095,0.425-0.082,0.442,0.023,0.66c-0.571,0.018-1.173,0.037-2.81-0.694
						c-0.407-0.198-0.749-0.405-1.114-0.608c-1.799-0.753-2.242-1.637-4.386-2.361c-0.089-0.034-0.177-0.068-0.259-0.104
						c-0.054-0.034-0.13-0.08-0.189-0.114C789.009,21.411,787.44,21.017,788.407,20.759z M770.594,27.947
						c3.367,2.066,3.367,2.066,3.733,2.48c0.03,0.04,0.03,0.04-0.501,0.339c-0.307,0.175,0.507,0.304,0.365,0.471
						c-0.058,0.074-0.205,0.087-0.602,0.115c2.312,0.184,2.312,0.184,2.641,0.32c-1.302,0.047-1.449,0.133-2.173,0.553
						c-0.279,0.011-0.562,0.011-0.843,0.005c-1.155-0.045-1.433-0.055-1.934-0.224c-0.701-0.235-0.655-0.528-1.079-0.787
						c-0.901-0.003-1.91,0.23-2.705,0.003c-0.131-0.037-0.213-0.083-0.294-0.129c1.532,0.058,2.393-0.235,3.583-0.351
						c-1.126-0.557-2.11-1.132-3.336-1.674c0.342-0.055,0.801-0.124,1.144-0.176C767.306,28.573,767.807,28.478,770.594,27.947z
						 M766.305,27.711c-0.36-0.127-0.825-0.235-1.167-0.361c-0.131-0.046-0.236-0.096-0.318-0.144c0.482-0.052,1.125-0.121,1.615-0.167
						l-0.325,0.275c-0.087,0.069-0.011,0.12,0.348,0.222c0.282,0.08,0.389,0.117,0.176,0.152c-0.023,0-0.046,0-0.059,0.005
						C766.48,27.699,766.393,27.706,766.305,27.711z M766.446,27.992c0.647-0.135,1.826-0.065,1.803,0.225
						c-0.835-0.01-1.296-0.018-1.638-0.139C766.541,28.05,766.486,28.021,766.446,27.992z M765.808,30.798l-0.104-0.204
						c0.082-0.095,0.353-0.112,0.813-0.048c0.59,0.077,1.416,0.317,0.577,0.358L765.808,30.798z M769.734,33.331l-0.141-0.05
						c-1.308-0.465-1.95-1.125-2.517-1.705c0.725-0.029,1.22,0.109,1.886,0.126c0.089,0,0.164-0.011,0.253-0.011
						c-0.212,0.278-0.212,0.278,0.872,0.882c-0.224,0.024-0.513,0.06-0.729,0.082c0.425,0.106,0.425,0.106,1.555,0.592
						c-0.253-0.003-0.589-0.005-0.848-0.008L769.734,33.331z"/>
					<path d="M848.273,35.372c-0.207-0.252-0.418-0.37-1.162-0.407c-0.071,0-0.129,0-0.188,0
						c0.106,0.063,0.33,0.195,0.177,0.333c-0.17,0.149-0.744,0.247-0.983,0.385l2.563,0.029C848.469,35.617,848.415,35.55,848.273,35.372
						z"/>
					<path d="M1427.052,15.518c0.037,0.023,0.088,0.047,0.145,0.069c0.256,0.012,0.58,0.025,0.832,0.038l-0.252-0.312
						C1427.272,15.329,1426.802,15.368,1427.052,15.518z"/>
					<path d="M1430.915,22.146c0.277,0.115,2.092,0.311,2.234-0.108c1,0.118,4.18,0.396,5.68,0.149
						c0.619,0.132,0.619,0.132,4.758,0.302c-0.109,0.229-1.006,0.39-1.043,0.626c0.367,0.014,0.846,0.037,1.203,0.048
						c0.936-0.071-0.154-0.339,0.578-0.456c0.549,0.095,0.756,0.256,1.367,0.335c0.402,0.058,0.766-0.005,0.945-0.034
						c0.008-0.238-1.379-0.299-1.367-0.542c5.592-0.04,5.592-0.04,6.965-0.084c-1.227-0.33-3.129-0.43-4.574-0.684
						c-1.387,0.354-5.326,0.385-5.584-0.338c-1.787,0.037-3.615-0.095-5.379,0.063c0.342,0.127,1.063,0.167,1.35,0.305
						c0.258,0.12,0.203,0.167-0.006,0.333c-0.539-0.009-0.801-0.087-1.238-0.236c-0.861-0.292-1.488-0.113-1.502,0.01
						c-0.721-0.089-1.107-0.268-1.846-0.348c-0.307-0.034-0.518-0.023-0.93,0.04c-0.035,0.086-0.084,0.207-0.119,0.293
						c-0.83,0.034-1.461-0.149-2.297-0.104c-0.557,0.029-0.592,0.118-0.607,0.258c0.025,0,0.051,0,0.074,0
						C1430.116,21.973,1430.544,21.999,1430.915,22.146z"/>
					<path d="M1427.827,22.088c0.697-0.017,0.842-0.137,0.891-0.241c-0.604,0.029-0.861,0.098-0.941,0.241
						C1427.796,22.088,1427.815,22.088,1427.827,22.088z"/>
					<path d="M1425.806,22.135c0.086-0.053-0.006-0.104-0.061-0.133c-0.031,0-0.068-0.006-0.117-0.006
						c-0.41-0.011-0.723,0.066-1.129,0.063c-0.014,0.021-0.014,0.041,0.023,0.063C1424.708,22.215,1425.604,22.237,1425.806,22.135z"/>
					<path d="M1489.794,25.345c0.307-0.146-1.008-0.138-1.02-0.138c-0.963,0.011-0.902-0.086-0.873-0.138
						c-0.129,0.012-0.484,0.043-0.307,0.123C1487.907,25.333,1489.521,25.469,1489.794,25.345z"/>
					<path d="M1452.175,23.536c-1.084-0.029-1.602,0.061-1.791,0.31c0.023,0,0.061,0,0.092,0.003
						C1451.923,23.88,1452.114,23.619,1452.175,23.536z"/>
					<path d="M1460.052,25.815c0.027-0.061,0.064-0.137,0.088-0.197l-0.332-0.106c-0.465-0.018-0.613,0.144-0.43,0.243
						C1459.501,25.83,1459.728,25.847,1460.052,25.815z"/>
					<path d="M1428.622,24.427c0.213,0.113,0.873,0.178,1.475,0.086c-0.012-0.144-0.371-0.225-1.195-0.259
						c-0.1-0.006-0.209-0.006-0.303-0.013C1428.563,24.277,1428.493,24.352,1428.622,24.427z"/>
					<path d="M1427.999,24.544c0.082-0.055-0.184-0.112-0.301-0.136l-0.867,0.058c0.02,0.012,0.037,0.029,0.061,0.037
						C1427.126,24.626,1427.882,24.621,1427.999,24.544z"/>
					<path d="M1457.317,26.172c-1.268-0.05-2.643,0.034-3.777-0.16c-0.67,0.246-0.67,0.246-1.705,0.108
						c0.033,0.06,0.07,0.127,0.205,0.178c0.186,0.075,0.443,0.109,0.75,0.146c0.695,0.086,0.93,0.141,1.178,0.343
						c0.426-0.007,0.5-0.058,0.598-0.242c0.027-0.063,0.086-0.189,0.416-0.195c0.043,0,0.285,0.006,0.891,0.098
						c0.537,0.086,0.818,0.109,1.445,0.101c0.162-0.074,0.389-0.178,0.559-0.253l0.746,0.031
						C1458.206,26.24,1457.899,26.203,1457.317,26.172z"/>
					<path d="M1450.524,26.342c0.117-0.099-0.35-0.13-0.494-0.136c-0.477-0.02-1.002,0.028-0.766,0.178
						c0.014,0,0.025,0.01,0.031,0.013c0.24,0.011,0.566,0.024,0.813,0.037L1450.524,26.342z"/>
					<polygon points="1447.368,26.108 1446.624,26.08 1446.542,26.275 1447.288,26.31 "/>
					<path d="M1443.667,26.336c1.088,0.068,1.258-0.093,1.289-0.238c-0.361-0.018-0.836-0.038-1.197-0.052l-0.117,0.287
						C1443.642,26.333,1443.653,26.336,1443.667,26.336z"/>
					<path d="M1457.327,26.993c-0.01-0.006-0.023-0.018-0.037-0.022c-0.146-0.129-0.49-0.152-0.611-0.162
						c-0.082-0.006-0.152-0.006-0.236-0.006c-0.033,0.035-0.117,0.099-0.01,0.165c0.105,0.065,0.379,0.105,0.674,0.149
						c0.527,0.076,0.863,0.14,0.658,0.324c0.152-0.112,0.373-0.259,0.533-0.368C1457.618,27.107,1457.446,27.054,1457.327,26.993z"/>
					<path d="M1453.497,27.206c-0.555-0.018-0.861-0.013-1.328,0.077c0.045,0.034,0.078,0.066,0.137,0.101
						c0.246,0.143,0.625,0.181,1.18,0.192c0.717,0.015,1.119,0.025,1.754,0.123c0.207-0.315,0.168-0.454-0.197-0.585
						C1454.464,27.234,1454.108,27.229,1453.497,27.206z"/>
					<path d="M1446.413,27.51c0.045,0,0.115,0.003,0.164,0.006c0.625,0.008,1.26-0.021,1.896,0.006
						c0.471,0.022,0.805,0.075,1.121,0.127c-0.068-0.276-1.004-0.472-1.35-0.725l-0.525,0.351c-0.012,0.086-0.189,0.095-0.684,0.075
						C1446.472,27.326,1446.177,27.323,1446.413,27.51z"/>
					<path d="M1457.856,28.107c-1.213-0.023-1.184,0.023-0.953,0.439c0.014,0.003,0.031,0.003,0.037,0.003
						c1.26,0.103,1.424-0.213,1.094-0.377C1457.987,28.152,1457.923,28.131,1457.856,28.107z"/>
					<path d="M1426.948,29.256c-0.086,0-0.178-0.003-0.258-0.006c0.012,0.009,0.037,0.018,0.049,0.028
						c0.232,0.144,0.676,0.184,1.076,0.201C1428.007,29.331,1427.655,29.288,1426.948,29.256z"/>
					<path d="M1426.938,29.629c-0.555,0.006-0.967,0.012-1.305-0.018c-0.535-0.037-0.93-0.134-1.424-0.189
						c-0.135,0.047-0.391,0.127-0.213,0.189c0.146,0.053,0.514,0.075,0.854,0.096c0.283,0.017,0.57,0.031,0.826,0.071
						c-0.023,0.052-0.049,0.126-0.072,0.179l2.004,0.086L1426.938,29.629z"/>
					<path d="M1424.132,29.888c-0.861,0.029-1.271-0.035-1.691-0.155c0,0.041-0.006,0.098,0.111,0.158
						c0.18,0.095,0.529,0.146,0.805,0.178c0.824,0.09,1.742,0.118,2.584,0.198C1425.728,29.931,1425.323,29.848,1424.132,29.888z"/>
					<path d="M1414.854,25.333c1.303,0.121,2.67,0.155,3.588,0.17c1.104,0.014,2.391,0.02,3.449,0.014
						c1.092-0.002,2.688,0.003,4.125,0.063c1.412,0.058,1.029,0.474,2.215,0.575c0.014,0.051-0.08,0.126-0.203,0.171
						c-0.367,0.016-0.736,0.029-1.096,0.053c0.508,0.318,1.76,0.511,2.586,0.775c3.053-0.546,8.629,0.16,8.867,0.191
						c0.172-0.169,0.172-0.169-0.41-0.364c-0.65-0.221,0.598-0.81,5.289-0.663c-0.33-0.38-2.262-0.21-3.084-0.428
						c0.324-0.069,0.762-0.158,1.092-0.228c0.447,0.032,0.773,0.052,1.51,0.061c1.566,0.018,2.979-0.173,4.549-0.16
						c1.203,0.006,2.141,0.235,3.383,0.212c1.311-0.022,2.547-0.161,3.891-0.117c0.979,0.031,1.898,0.154,2.93,0.1
						c1.094-0.058,1.277-0.27,1.406-0.413c-0.57-0.138-0.617-0.149-0.527-0.287c-2.363,0.023-2.363,0.023-2.748-0.041
						c-1.557-0.234-1.557-0.234-2.498-0.082c-1.883-0.359-1.883-0.359-2.297-0.302c-0.443-0.305-1.205-0.586-1.27-0.916
						c-1.703-0.015-3.564-0.044-6.02-0.17c-0.111,0.23,0.25,0.288,1.086,0.327c-1.215,0.351-1.215,0.351-1.797,0.311
						c0.502-0.477-0.309-0.661-2.082-0.85c0.129-0.201,0.969-0.33,1.061-0.534c-1.203-0.138-2.652-0.081-3.813-0.247
						c-0.055-0.011-0.129-0.023-0.184-0.034c-2.676,0.844-3.572,1.132-6.895,0.967c0.393,0.478-0.957,0.945-0.189,1.425
						c-5.445,0.152-5.717-0.1-5.857-0.238c-0.271-0.259-0.438-0.327-1.303-0.345c-0.143,0.172,0.623,0.264,0.676,0.416
						c-0.146,0.052-0.338,0.118-0.484,0.17c-1.225-0.049-1.537-0.123-1.916-0.268c-1.148-0.014-1.148-0.014-3.781,0.339
						c-1.34,0.176-2.836,0-4.207,0.089c-0.314,0.023-0.656,0.092-0.854,0.149c-0.037-0.003-3.775-0.41-4.932,0.092
						c0.297,0.013,0.695,0.023,0.992,0.029C1411.022,25.401,1412.933,25.163,1414.854,25.333z M1452.636,25.284
						c-1.037,0.052-1.668,0.081-2.48,0.049c-0.207-0.011-0.584-0.028-1.043-0.097c-0.049-0.006-0.109-0.013-0.146-0.021
						C1449.134,24.685,1452.202,25.195,1452.636,25.284z M1446.731,24.744c0.275,0.015,0.729,0.031,1.049,0.133
						c0.412,0.129,0.496,0.286,0.76,0.428c-0.436,0.008-0.844,0.061-1.303,0.042c-0.316-0.014-0.389-0.017-0.549-0.105
						C1446.386,25.074,1447.349,24.914,1446.731,24.744z M1444.019,25.053c0.557,0.021,0.871,0.021,1.365,0.005
						c-0.045,0.115-0.109,0.271-0.164,0.385c-1.242-0.206-2.145-0.195-3.701-0.092c-1.029,0.069-1.955,0.105-2.9-0.149
						c-0.061-0.018-0.129-0.04-0.189-0.055c0.297-0.146,0.67-0.33,1.604-0.345C1441.489,24.775,1442.671,24.988,1444.019,25.053z
						 M1438.489,23.903c0.543,0.129,0.813,0.241,1.215,0.505c0.025,0.019,0.047,0.029,0.064,0.043c0.043,0.026,0.092,0.064,0.111,0.089
						c-0.012,0-0.027,0-0.047,0c-1.059-0.057-1.686-0.304-1.846-0.393C1437.812,24.047,1437.761,23.921,1438.489,23.903z
						 M1431.323,25.621l0.76,0.034l-0.076,0.178l-0.748-0.028L1431.323,25.621z"/>
					<path d="M1327.905,16.698c0.07,0.04,0.484,0.239,1.338,0.29c0.158-0.187-0.031-0.271-0.383-0.428
						c-0.129-0.058-0.242-0.115-0.307-0.176C1327.479,16.411,1327.737,16.615,1327.905,16.698z"/>
					<polygon points="1331.347,17.063 1330.485,17.034 1330.435,17.235 1331.288,17.268 "/>
					<path d="M1340.987,18.981c0.145,0.075,0.508,0.13,0.686,0.022c0.107-0.06,0.082-0.157,0.07-0.198
						C1340.681,18.806,1340.956,18.967,1340.987,18.981z"/>
					<path d="M1377.532,20.547c0.053,0.024,0.396,0.157,1.301-0.061c-0.357-0.075-0.627-0.115-0.885-0.127
						C1377.323,20.343,1377.452,20.509,1377.532,20.547z"/>
					<path d="M1375.897,20.469c-0.148-0.011-0.295-0.023-0.451-0.028c-0.955-0.032-1.367,0.08-1.297,0.351
						c0.023,0.002,0.049,0.005,0.072,0.005C1375.47,20.877,1375.972,20.778,1375.897,20.469z"/>
					<path d="M1357.417,21.445c0.053,0.058,0.148,0.115,0.258,0.166c0.68,0.034,0.91-0.026,1.596-0.2
						c0.639-0.161,0.945-0.136,1.322,0.108c0.428-0.092,1-0.138,1.369-0.241c0.365-0.103,0.389-0.181,0.41-0.27
						c-0.174-0.012-0.365-0.023-0.555-0.029c-1.029-0.022-1.484,0.029-1.99,0.23C1358.235,20.966,1357.21,21.176,1357.417,21.445z"/>
					<path d="M1354.085,20.899c-0.092-0.006-0.186-0.017-0.295-0.022c-0.303-0.007-0.445,0.028-0.512,0.126
						c-0.029,0.052-0.029,0.052,0.338,0.16L1354.085,20.899z"/>
					<path d="M1328.554,21.032c0.018,0.002,0.037,0.005,0.051,0.008c0.59,0.13,2.143,0.021,2.135-0.321
						C1329.501,20.728,1328.599,20.733,1328.554,21.032z"/>
					<path d="M1327.507,20.704c-0.516-0.011-0.523,0.012-0.578,0.265c0.012,0.006,0.033,0.006,0.055,0.009
						c1.074,0.083,1.217-0.066,1.006-0.176C1327.868,20.744,1327.71,20.716,1327.507,20.704z"/>
					<path d="M1377.929,23.243c-0.006,0.034,0,0.065,0.063,0.097c0.16,0.087,0.16,0.087,2.314,0.196
						c-0.031-0.155-0.373-0.213-1.461-0.262C1378.536,23.266,1378.229,23.254,1377.929,23.243z"/>
					<path d="M1327.087,25.479c-0.049-0.262-0.426-0.371-1.404-0.41c-0.523-0.017-0.859-0.012-1.844,0.002
						c-0.035,0.061-0.09,0.139,0.117,0.21C1324.226,25.38,1324.226,25.38,1327.087,25.479z"/>
					<path d="M1373.106,27.343c0.078,0.044,0.158,0.084,0.236,0.125c0.818,0.011,0.51-0.193,0.1-0.366
						C1373.077,27.091,1372.698,27.107,1373.106,27.343z"/>
					<polygon points="1325.888,27.062 1325.843,27.245 1327.468,27.301 1326.751,26.999 "/>
					<path d="M1330.759,25.608c0.389,0.006,0.441-0.126,0.459-0.166c-0.408-0.006-0.709-0.038-0.906-0.098
						c-0.355-0.098-0.363-0.236-0.639-0.347c-0.057,0.005-0.129,0.011-0.193,0.016c-0.023,0.003-0.047,0.003-0.064,0.007
						c-0.75,0.063-1.154,0.152-1.08,0.41c0.029,0,0.066,0,0.09,0c1.002,0.006,1.592,0.086,1.898,0.152
						C1330.38,25.598,1330.452,25.608,1330.759,25.608z"/>
					<path d="M1329.938,19.619c1.053-0.052,1.053-0.052,2.322,0.092l1.686-0.141c0.777,0.008,1.502,0.071,2.271,0.1
						c1.307,0.047,2.283-0.264,3.641-0.168c-0.117-0.204-1.197-0.118-1.602-0.245c0.33-0.184,1.27-0.032,1.756-0.141
						c-0.014-0.005-0.023-0.015-0.023-0.022c0-0.003-0.016-0.009-0.027-0.009c-0.068-0.028-0.141-0.028-0.361-0.012
						c-0.518,0.043-0.775,0.012-0.895-0.006c-0.119-0.144-0.016-0.173,0.576-0.149c0.453,0.018,0.836,0.028,0.807-0.081
						c-0.066-0.218-0.605-0.246-0.906-0.263c-0.816-0.013-1.588,0.068-2.402,0.051c-0.795-0.017-1.521-0.095-2.273-0.149
						c-1.402-0.098-2.182-0.144-3.119-0.155c-0.605,0.254-1.064,0.403-1.893,0.621c-0.375-0.006-0.375-0.063-0.346-0.173
						c0.031-0.112,0.051-0.212-0.814-0.166c0.277,0.786,0.277,0.786-1.467,0.821c0.029,0.028,0.078,0.075,0.141,0.1
						C1327.499,19.742,1328.856,19.677,1329.938,19.619z"/>
					<path d="M1364.655,27.521c0.662-0.018,1.26-0.087,1.898-0.127c-0.793-0.031-1.846-0.068-2.637-0.103
						c0.025,0.012,0.057,0.017,0.096,0.028C1364.235,27.384,1364.448,27.452,1364.655,27.521z"/>
					<path d="M942.951,4.753c0.813-0.032,0.858-0.216,0.802-0.388c-0.771,0.022-1.037,0.138-0.873,0.388
						C942.902,4.753,942.925,4.749,942.951,4.753z"/>
					<path d="M941.65,5.428c0.368,0.011,0.557,0.008,0.827-0.012c0.037-0.003,0.063-0.006,0.095-0.009
						c0.933-0.117,0.755-0.367,1.214-0.543c-0.401-0.006-0.918-0.014-1.321-0.023c0.201,0.19,0.017,0.248-0.405,0.328
						c-0.373,0.077-0.525,0.121-0.447,0.256C941.618,5.422,941.635,5.428,941.65,5.428z"/>
					<path d="M938.859,7.938c0.568-0.08,1.304-0.058,1.649-0.046c-0.707-0.201-0.492-0.293,0.252-0.497
						c0.482-0.129,0.517-0.178,0.562-0.262c0.118-0.241-0.355-0.482,0.05-0.724c0.588-0.351,0.646-0.388,0.258-0.775
						c-0.107-0.005-0.213-0.008-0.308-0.008c-0.178,0-0.405,0.008-0.551,0.025c-0.08,0.132,0.411,0.229,0.4,0.359
						c-1.359,0.283-1.875,0.502-2.064,0.864c0.522,0.068,1.229,0.155,1.751,0.218c-0.552,0.181-1.479,0.281-1.965,0.474
						c-0.304,0.127-0.21,0.297-0.16,0.391C938.764,7.949,938.819,7.939,938.859,7.938z"/>
					<path d="M936.832,9.026c0.356,0.082,1.063,0.055,1.201,0.197c1.24-0.179,0.591-0.703,2.55-0.74
						c-0.369-0.115-0.492-0.207-0.529-0.408c-0.063,0-0.12-0.003-0.178-0.003c-2.292-0.021-2.007,0.577-3.193,0.83
						C936.676,8.951,936.676,8.987,936.832,9.026z"/>
					<path d="M938.112,9.941c0.041-0.04,0.029-0.08-0.005-0.121c-0.615-0.005-1.155,0.099-1.792,0.063
						c0.023,0.041,0.058,0.075,0.14,0.104C936.843,10.131,937.928,10.129,938.112,9.941z"/>
					<path d="M938.21,10.714c-0.011-0.061-0.017-0.146-0.023-0.21l-0.494-0.1c-0.459-0.003-0.588,0.146-0.33,0.255
						C937.469,10.705,937.733,10.774,938.21,10.714z"/>
					<path d="M934.701,12.099c0.305,0.118,0.775,0.129,1.022,0.137c0.011-0.008,0.025-0.022,0.025-0.031
						c0.049-0.103-0.06-0.16-0.278-0.246c-0.241-0.104-0.224-0.113-0.165-0.139c0.187-0.08,0.687-0.08,0.865-0.16
						c0.132-0.058,0.025-0.139-0.069-0.199c-0.015,0-0.035-0.002-0.057-0.002C934.569,11.458,934.179,11.903,934.701,12.099z"/>
					<path d="M934.649,12.733c0.196,0.073,0.592,0.111,0.721,0.008c0.078-0.071,0.011-0.17-0.014-0.21
						C934.238,12.561,934.604,12.715,934.649,12.733z"/>
					<path d="M933.811,13.169c0.158,0.055,0.494,0.063,1.017,0.062c0.35-0.004,0.688-0.029,1.039-0.004
						c-0.011-0.049-0.069-0.189-1.008-0.21c-0.601-0.006-0.951,0.041-1.14,0.078C933.73,13.123,933.741,13.146,933.811,13.169z"/>
					<path d="M955.187,13.632c-0.129-0.078-0.308-0.112-0.666-0.121c-0.632-0.005-1.367,0.112-1.034,0.299
						C953.995,13.755,954.672,13.687,955.187,13.632z"/>
					<path d="M934.179,13.391c-0.058-0.003-0.125-0.003-0.179-0.003c-0.821-0.012-1.174,0.08-1.088,0.286
						c0.009,0,0.02,0,0.026,0C934.305,13.721,934.213,13.479,934.179,13.391z"/>
					<path d="M932.989,14.169c0.011,0,0.023,0,0.034,0c1.026,0.034,1.404-0.084,1.215-0.38
						C933.153,13.944,932.932,13.977,932.989,14.169z"/>
					<path d="M953.389,14.496c0.356,0.141,0.97,0.244,1.149,0.408c0.649-0.075,0.557-0.17,0.201-0.351
						c-0.333-0.167-0.425-0.241-0.302-0.346c-0.048-0.002-0.092-0.005-0.14-0.005c-0.442-0.003-0.735,0.083-1.149,0.092
						C953.16,14.341,953.177,14.409,953.389,14.496z"/>
					<path d="M934.747,14.384c-0.072-0.077-0.235-0.105-0.661-0.12c-0.718-0.006-1.37,0.065-1.488,0.089
						c0.049,0.041,0.101,0.083,0.201,0.12C933.259,14.64,934.115,14.49,934.747,14.384z"/>
					<path d="M927.591,21.993c0.962,0.05,1.545-0.215,2.51-0.154c0.503-1.197,2.251-2.363,1.834-3.581
						c0.405-0.052,0.934-0.121,1.339-0.173c-0.368-0.304-0.347-0.358,0.258-0.801c0.668-0.496,0.542-0.655,0.221-1.043
						c0.259-0.028,0.609-0.068,0.873-0.098c-0.375-0.74-0.375-0.74-1.473-0.987c-0.752,0.031-1.352,0.167-2.174,0.155
						c1.473,0.12,1.398,0.502,2.326,0.718c-0.557,0.078-0.864,0.12-1.054,0.327c-0.242,0.275,0.083,0.552-0.041,0.827
						c-0.134,0.299-1.797,0.534-0.723,0.873c-1.338,0.259-1.338,0.259-2.142,0.27c-1.591,1.637-1.979,2.424-1.803,3.665
						C927.56,21.991,927.579,21.991,927.591,21.993z"/>
					<path d="M924.809,21.367c-1.143,0.003-1.663,0.124-1.623,0.371c0.032,0,0.069-0.004,0.095-0.004
						C924.421,21.687,924.702,21.514,924.809,21.367z"/>
					<path d="M938.928,9.833c0.928-0.156,0.546-0.22-0.351-0.328c-0.867-0.109-1.096-0.172-1.024-0.287
						c-0.106,0.04-0.17,0.065-0.575,0.121c-0.595,0.08-0.713,0.126-0.701,0.259c0.061-0.006,0.129-0.013,0.19-0.016
						C938.517,9.419,938.813,9.709,938.928,9.833z"/>
					<path d="M928.558,22.921c0.486,0.195,1.648,0.333,1.844,0.178c0.295-0.229-1.521-0.103-1.774-0.304
						C928.544,22.801,928.298,22.815,928.558,22.921z"/>
					<path d="M934.712,26.358c0,0.035-0.012,0.092,0.138,0.146c0.236,0.092,0.608,0.109,1.711,0.161
						c-0.671-0.075-0.884-0.29-1.746-0.306C934.781,26.358,934.747,26.358,934.712,26.358z"/>
					<path d="M923.243,26.396l-0.296-0.003l0.012,0.003C923.054,26.396,923.146,26.396,923.243,26.396z"/>
					<path d="M922.947,26.394c-0.085,0-0.181-0.001-0.259-0.004c0.029,0.002,0.055,0,0.093,0.004
						c0.046,0,0.095,0,0.152,0.003L922.947,26.394z"/>
					<path d="M953.4,24.998c0.086-0.142,1.057-0.225,0.615-0.391c-0.657-0.032-0.657-0.032-2.372,0.157
						c-2.774-0.54-2.774-0.54-3.612-0.617c0.341-0.276,0.341-0.276,1.579-2.691c0.118,0,0.285,0.016,0.414,0.006
						c0.83-0.04,0.259-0.275-0.977-0.407c3.107-3.352,3.107-3.352,3.475-4.531c-0.235-0.006-0.517-0.013-0.792-0.018l0.822,0.015
						c0.005-0.031,0.019-0.063,0.019-0.095c0.675-0.069,0.675-0.069,1.649-0.447c-0.548-0.179-0.623-0.265-0.658-0.521
						c-0.026-0.235-0.167-0.302-0.543-0.425c-0.083-0.021-0.184-0.044-0.255-0.061c-1.02,0.055-0.207,0.511,0.092,0.586
						c-0.523-0.035-0.689,0.04-0.993,0.2c-0.448,0.23-0.732,0.311-1.534,0.346c0.378,0.166,0.506,0.255,0.581,0.391h0.025l-1.217,1.26
						c-0.341,0.17-1.166,0.089-1.685,0.164c0.284,0.278,0.378,0.37-0.718,0.608c-0.92,0.196-0.937,0.228-0.386,0.448
						c-0.594,0.213-1.749,0.144-2.552,0.262c0.841,0.37,1.074,0.623,1.031,1.085c-0.235,0.025-0.557,0.058-0.792,0.083
						c0,0.026-0.262,2.677-2.9,2.677c0.201,0.506-1.243,0.957-1.005,1.468c-0.046,0.008-0.098,0.028-0.145,0.037
						c-0.792-0.066-0.792-0.066-1.068-0.003c0.896,0.324,0.896,0.324-0.603,1.163c1.953,0.141,1.993,0.778,1.982,0.907l13.981,0.206
						C955.239,25.296,955.239,25.296,953.4,24.998z M945.518,24.483c0.083,0.074,0.368,0.132,0.405,0.206
						c0.011,0.018,0.023,0.058-0.259,0.089c-0.026,0.004-0.051,0.004-0.063,0.007c-0.083-0.078-0.416-0.133-0.442-0.219
						C945.154,24.521,945.389,24.497,945.518,24.483z M948.53,26.172c-1.699-0.098-1.699-0.098-2.158,0.063
						c0.151,0.118,0.35,0.275,0.504,0.4c-0.743,0.054-1.507,0.031-2.262,0.048c-0.098,0-0.213,0.003-0.302,0.006
						c-0.124-0.114-0.134-0.155-0.066-0.321c0.092-0.235,0.061-0.371-0.19-0.652c0.919-0.052,1.063-0.135,1.671-0.497
						c-0.031,0.189,0.891,0.271,1.502,0.322c0.744,0.063,1.333,0.115,1.602,0.247C949.053,25.894,948.62,26.057,948.53,26.172z"/>
					<path d="M928.303,25.014c-0.93,0.044-0.93,0.044-1.103,0.016c-0.017-0.115-0.248-0.218-0.27-0.33
						c-0.012-0.044,0.005-0.05,0.175-0.084c0.687-0.144,1.321,0.046,1.982,0.021c-0.221-0.565-0.213-0.807,0.061-1.367
						c-0.85-0.075-1.729-0.028-2.597-0.037c-0.511,0.224-0.221,0.543-1.528,0.672c-1.327-0.149-0.322-0.864-1.958-0.721
						c0.247-0.268,1.011-0.49,1.172-0.768c0.049-0.089-0.33-0.197-0.571-0.27c-0.27-0.04-0.626-0.092-0.885-0.132
						c-0.66,0.207,0.236,0.391,0.141,0.585c-0.095,0.196-1,0.288-1.177,0.472c-0.023,0.021-0.035,0.046-0.043,0.065
						c-0.092,0.245,0.267,0.486,0.032,0.73c-0.614,0.617-0.614,0.617-0.023,0.933c0.6,0.319,0.623,0.385,0.232,0.595
						c0.468,0.021,0.864,0.101,1.375,0.078c0.109-0.003,0.158-0.031,0.321-0.146c1.157,0.014,0.638,0.456,1.864,0.416
						c-0.152,0.092-0.21,0.126-1.02,0.146c-1.608,0.037-1.125,0.221-0.936,0.272c0.31,0.071,0.64-0.028,0.948,0.006
						c0.212,0.026,0.631,0.213-0.288,0.247c0.864,0.012,2.014,0.028,2.877,0.037c-0.048-0.066-0.097-0.135-0.143-0.2
						C928.084,26.037,928.084,26.037,928.303,25.014z"/>
					<path d="M884.599,12.738c0.448,0.189,0.636,0.293,0.512,0.435c0.034-0.01,0.078-0.016,0.106-0.021
						c0.99-0.213,0.677-0.574-0.661-0.771C884.01,12.46,884.151,12.549,884.599,12.738z"/>
					<path d="M906.472,16.201c0.342,0.115,0.854,0.139,1.103,0.146c0.076-0.146-0.024-0.209-0.307-0.341
						c-0.258-0.127-0.353-0.207-0.249-0.368C906.142,15.733,905.971,16.034,906.472,16.201z"/>
					<path d="M890.464,16.207c-0.391,0-0.501,0.149-0.207,0.256c0.317,0.115,0.695,0.058,0.82,0.037
						c-0.006-0.058-0.03-0.132-0.043-0.191l-0.5-0.102C890.51,16.204,890.487,16.207,890.464,16.207z"/>
					<path d="M880.756,18.137c0.211,0.072,0.571,0.109,0.659,0.019c0.072-0.07-0.03-0.162-0.076-0.214
						C880.309,17.965,880.708,18.119,880.756,18.137z"/>
					<path d="M879.664,18.594c0.073-0.066-0.289-0.155-0.405-0.181c-0.396,0.077-0.525,0.138-0.378,0.189
						C879.058,18.663,879.589,18.666,879.664,18.594z"/>
					<path d="M867.695,18.694c0.206,0.061,0.577,0.068,0.777,0.074c-0.578-0.144-0.437-0.172,0.082-0.218
						c0.614-0.052,0.873-0.106,0.684-0.265c-0.07-0.008-0.148-0.015-0.229-0.015C868.014,18.271,867.246,18.57,867.695,18.694z"/>
					<polygon points="879.43,19.094 880.326,19.102 880.25,18.815 878.946,18.803 "/>
					<path d="M861.058,20.136c0.024-0.012,0.047-0.028,0.076-0.04c0.078-0.028,0.161-0.058,0.271-0.08
						c0.573-0.107,1.587,0.068,1.468,0.539c2.729-0.287,2.895-0.304,3.496,0.04c0.63-0.034,1.302-0.025,1.904-0.089
						c0.448-0.043,0.471-0.065,0.619-0.163c-1.12-0.463-1.12-0.463-1.845-0.518c0.104-0.057,0.247-0.14,0.353-0.2
						c0.271,0.031,0.308,0.04,0.584,0.137c0.34,0.128,0.702,0.13,1.255,0.092c0.03-0.103-0.011-0.151-0.507-0.212
						c-0.565-0.074-0.731-0.111-0.512-0.292c-0.195,0.063-0.408,0.082-1.084,0.027c-0.737-0.057-0.932-0.005-1.061,0.139
						c-0.283-0.063-0.661-0.144-0.943-0.204c0.019-0.095,0.019-0.095,1.108-0.084c0.783,0.013,0.896-0.022,0.602-0.194
						c-0.172-0.006-0.666-0.006-1.185,0.028c-0.142,0.012-0.284,0.029-0.449,0.012c-0.201-0.012-0.201-0.104-0.211-0.184
						c0-0.023,0.006-0.049,0.006-0.069C861.647,18.946,859.878,19.538,861.058,20.136z M867.175,20.319
						c-0.377-0.006-1.273-0.023-1.826-0.241c-0.343-0.132-0.473-0.304-0.531-0.388C865.742,19.677,867.27,19.745,867.175,20.319z"/>
					<path d="M880.22,19.492c0.194,0.069,0.583,0.106,0.69,0.018c0.07-0.063-0.013-0.155-0.061-0.207
						C879.778,19.32,880.178,19.476,880.22,19.492z"/>
					<path d="M901.173,20.756c-1.286,0-1.381-0.025-1.492-0.057c-0.076-0.029-0.041-0.093,0.006-0.165
						c0.034-0.065,0.07-0.129,0.083-0.194c-0.372,0.014-0.66,0.04-0.92,0.135c-0.366,0.132-0.388,0.287-0.647,0.429
						c0.035,0.008,0.083,0.019,0.129,0.024C899.021,21.043,901.303,21.112,901.173,20.756z"/>
					<path d="M865.524,20.621c-0.304-0.061-0.617-0.066-0.782-0.069c-0.194,0.003-0.384,0.006-0.56,0.018
						c0.005,0.057,0.022,0.117,0.247,0.209c0.254,0.099,0.613,0.185,0.778,0.29C866.35,21.037,866.139,20.738,865.524,20.621z"/>
					<polygon points="861.152,22.098 861.094,21.904 860.281,21.898 860.327,22.088 "/>
					<path d="M894.325,22.792c0.029,0.006,0.059,0.009,0.081,0.014c0.838,0.179,1.846,0.34,3.491,0.334
						c-0.543-0.127-1.864-0.365-2.93-0.385C894.707,22.755,894.549,22.761,894.325,22.792z"/>
					<path d="M898.338,23.237c0.017,0,0.042,0,0.059,0c0.566-0.018,0.807,0.011,1.267,0.074
						c0.348,0.049,0.501,0.069,0.884,0.049c0.237-0.244-0.642-0.376-1.332-0.388C898.727,22.973,898.185,23.016,898.338,23.237z"/>
					<path d="M900.413,24.334c-0.019-0.057-0.034-0.132-0.053-0.189l-0.507-0.115c-0.473,0-0.555,0.161-0.254,0.268
						C899.747,24.352,900.011,24.397,900.413,24.334z"/>
					<path d="M862.065,26.231c0.011-0.002,1.463-0.277,1.94,0.463c0.849,0.052,1.331,0.012,1.526-0.12
						c0.406-0.285-0.165-0.558-0.17-0.84c-0.985,0.202-1.286,0.207-1.781,0.036c-0.637-0.22-0.896-0.23-1.746-0.265
						c0.237-0.222,0.214-0.285-0.135-0.417c-0.371-0.141-0.43-0.204-0.528-0.361c-0.03-0.003-0.073-0.003-0.107-0.006
						c-0.726-0.015-0.849,0.661-0.006,1.077c-0.826,0.152-0.849,0.27-0.507,0.66c0.252,0.287,0.188,0.379,0.106,0.493
						c0.106-0.005,0.26-0.011,0.366-0.017C862.485,26.826,861.229,26.431,862.065,26.231z M862.849,25.91l0.072,0.19l-0.884-0.01
						l-0.064-0.189L862.849,25.91z"/>
					<path d="M880.792,25.83c-0.532-0.031-0.885-0.052-0.838-0.296c0.849,0.092,1.853,0.026,2.688,0.132
						c0.024,0.104-0.024,0.13-0.143,0.198c3.161,0.043,7.369,0.093,10.539,0.135c-1.851-1.079-2.229-1.303-1.838-1.973
						c-1.532-0.215-1.51-0.548-1.287-0.688c1.51-0.021,2.659-0.262,4.062-0.349c-0.053-0.281-1.315-0.444-1.355-0.729
						c1.285-0.092,1.285-0.092,1.526-0.149c0.743,0.345,1.498,0.469,3.212,0.528c0.878-0.429,1.038-0.505,1.604-0.531
						c0.253,0.049,0.253,0.049,0.406,0.167c0.826-0.273-0.188-0.546-0.012-0.819c0.083-0.011,0.19-0.031,0.272-0.045
						c-0.236-0.081-0.236-0.081-1.304-0.018c-0.016-0.063-0.04-0.144-0.051-0.207c-1.781-0.327-2.676-0.844-4.656-1.134
						c2.688-0.315-0.042-0.975,0.542-1.447c-1.729-0.153-1.839-0.225-2.913-0.911c-0.895,0.092-1.826,0.092-2.386,0
						c-0.743-0.12-0.03-0.293-0.283-0.43c-0.719-0.107-0.719-0.107-1.939-1.017c0.007-0.133,0.142-0.432,1.22-0.377
						c-0.395-0.034-0.932-0.083-1.327-0.117c0.236-0.127,0.308-0.158,0.85-0.192c-0.845-0.01-1.969-0.025-2.818-0.038
						c0.159,0.563-0.761,1.117-0.319,1.681c0.019,0.022,0.061,0.051,0.095,0.071c0.271,0.144,1.038,0.187,1.308,0.327
						c0.224,0.126-0.218,0.256,0.024,0.38c0.046,0.025,0.107,0.058,0.166,0.083c0.154,0.061,0.56,0.105,0.831,0.141
						c-0.489,0.195-1.514,0.603-0.607,0.93c0.118,0.041,0.407,0.092,0.388,0.142c-0.057,0.169-0.281,0.388-0.328,0.555
						c-0.025,0.071-0.012,0.168-0.012,0.241c0.017,0.419,1.214,0.77,1.319,1.177c0.129,0.465-0.701,0.91-0.612,1.378
						c0.169,0.861,0.1,0.977-0.343,1.528c0.767,0.121,1.004,0.252,1.063,0.591c-0.189,0.058-0.449,0.136-0.645,0.195
						c-1.136,0.018-2.067-0.198-3.223-0.146c-1.197,0.05-1.284,0.58-2.705,0.435c-0.046-0.035-0.065-0.093-0.036-0.133
						c-0.053-0.011-0.124-0.034-0.17-0.048c-0.318-0.01-0.638-0.01-0.955-0.004c0.304-0.104,1.048-0.694-0.62-0.684
						c0.418,0.494,0.359,0.861-0.254,1.459l2.004,0.022C880.892,25.842,880.744,25.83,880.792,25.83z M897.588,21.968
						c-0.435-0.009-0.942-0.034-1.284-0.179c-0.024-0.005-0.048-0.017-0.07-0.028C897.059,21.77,897.708,21.775,897.588,21.968z
						 M888.76,18.04c0.408,0.005,0.955,0.014,1.368,0.02c-0.06,0.149-0.136,0.192-0.497,0.198c-0.116-0.006-0.235-0.015-0.354-0.018
						c0.685,0.385,1.315,0.505,3.208,0.833c-0.803,0.77,0.647,1.571-0.708,2.326c-1.156,0.012-1.733-0.08-2.014-0.155
						c-0.108-0.028-0.427-0.118-0.526-0.339c-0.1-0.235,0.135-0.471,0.04-0.706c-0.14-0.362-0.364-0.729-0.473-1.098
						C888.642,18.599,888.659,18.36,888.76,18.04z"/>
					<path d="M855.428,24.359c-0.547-0.353,0.808-0.829-1.231-1.082c0.589-0.945-0.447-1.89,0.006-2.826
						c-0.389-0.009-0.909-0.011-1.297-0.017c0.017-0.244,1.538-0.232,1.561-0.475c-0.517,0.032-0.522,0.029-0.731,0
						c0.307-0.261,1.304-0.474,0.991-0.771c-0.313-0.009-0.731-0.018-1.037-0.029c-0.013-0.009-0.03-0.023-0.035-0.034
						c0.494-0.098,0.494-0.139,0.507-0.247c-0.88,0.053-1.108-0.167-1.746-0.219c-0.165-0.003-0.33-0.003-0.495,0
						c0.107,0.402,0.697,0.787,0.814,1.184c0.146,0.525-2.263,1.017-0.418,1.564c-0.896,0.248-0.727,0.586-1.427,0.851
						c0.507,0.439,0.224,0.898,0.712,1.333c0.229,0.2,1.228,0.296,1.362,0.508c0.089,0.138,0.099,0.271-0.549,0.557
						c-0.694,0.308-0.907,0.399-0.283,0.845l3.208,0.037C853.89,24.687,854.592,24.489,855.428,24.359z"/>
					<path d="M908.099,25.503c-0.042-0.031-0.112-0.078-0.331-0.099c-0.288-0.024-1.256,0.055-0.913,0.271
						c-0.579-0.126-0.803-0.175-1.285-0.598c-0.566-0.485-0.672-0.54-1.285-0.783c0.376-0.026,0.883-0.058,1.272-0.08
						c-0.012-0.626-1.101-0.787-2.015-0.816c-0.601-0.005-0.813,0.066-1.085,0.158c-0.294,0.101-0.471,0.161-1.461,0.146
						c-1.12-0.017-1.998-0.229-3.17-0.195c-0.695,0.017-0.725,0.023-0.943,0.066c0.342,0.191,1.296,0.313,1.291,0.542
						c0.266-0.126,0.383-0.181,0.801-0.229c0.677-0.087,1.469-0.058,2.164-0.127c0.095,0.127,0.095,0.161-0.035,0.178
						c-0.332,0.052-0.46-0.08-0.779-0.055c-0.07,0.038-0.082,0.043,0,0.153c0.602,0.074,0.85,0.286,1.774,0.226
						c-0.019,0.275-0.019,0.275,1.515,0.791c-1.752-0.044-2.688-0.145-4.001-0.432c-1.244,0.522-1.244,0.522-0.219,0.672
						c-0.224,0.006-0.224,0.006-1.805-0.117c-0.169-0.136-0.199-0.159,0.389-0.19c0.596-0.031,0.566-0.054,0.391-0.191
						c-0.289-0.216-1.569-0.219-1.851-0.438c-0.048-0.034-0.083-0.079-0.123-0.115c-0.043-0.039,0.051-0.103,0.064-0.148
						c-0.945,0.213-0.85,0.348,0.006,0.724c0.807,0.359,0.707,0.477-0.497,0.62c0.125,0.083,0.289,0.195,0.632,0.284
						c0.625,0.17,1.526,0.213,2.109,0.238c0.089,0.034,0.167,0.074,0.212,0.112c2.983,0.037,6.968,0.095,9.95,0.129
						C906.525,25.789,907.704,25.574,908.099,25.503z"/>
					<path d="M887.918,15.57c0.217,0.011,0.417,0.031,0.642,0.04c0.129,0.002,0.129-0.006,0.129-0.015
						c0.494,0.012,0.5,0.04,0.53,0.233c0.036,0.157,0.077,0.234,0.86,0.166c-0.205-0.109-0.34-0.221-0.329-0.402
						c0.124-0.382,0.9-0.738,0.884-1.126c-0.013-0.212-0.65-0.361-0.955-0.437c-0.731,0.007-1.004,0.012-1.097,0.066
						c-0.059,0.038,0,0.09,0.047,0.124c0.123,0.098,0.212,0.194,0.252,0.293c-1.342-0.089-1.303-0.592-3.129-0.534
						c0.146-0.069,0.465-0.099,0.712-0.144c0.011-0.023-0.046-0.058-0.099-0.081c-0.07-0.021-0.184-0.052-0.26-0.074
						c-1.71,0.063-1.803,0.27-1.373,0.74c0.393,0.437,0.464,0.646-0.514,0.816c0.183,0.103,0.266,0.169,0.348,0.286l2.813,0.038
						c0.165-0.003,0.329-0.003,0.488,0.009C887.888,15.57,887.905,15.57,887.918,15.57z M889.42,14.806l0.041,0.21l-0.89-0.012
						l-0.042-0.209L889.42,14.806z"/>
					<path d="M1156.446,9.33c0.133,0.089,0.156,0.268,0.164,0.27c-0.014,0.071-0.283,0.081-0.553,0.089
						c-0.512,0.012-0.658,0.046-0.461,0.184c0,0,0.023,0,0.035,0.003c1.91,0.115,2.758-0.594,1.861-0.909
						c-0.387-0.133-0.916-0.156-1.203-0.167c-0.389-0.009-0.787-0.017-0.857,0.104c-0.014,0.011-0.02,0.025-0.023,0.034
						c0.018,0.061,0.234,0.126,0.471,0.189C1156.079,9.184,1156.327,9.255,1156.446,9.33z"/>
					<path d="M1157.364,9.922c-0.35-0.007-0.471,0.014-0.701,0.082c-0.213,0.064-0.404,0.122-1.092,0.058
						c-0.01,0.092-0.006,0.144,0.104,0.219c0.012,0.006,0.027,0.015,0.037,0.02c0.121,0.05,0.229,0.072,0.559,0.099
						c0.492,0.037,0.666,0.071,0.543,0.284C1158.237,10.7,1157.866,10.085,1157.364,9.922z"/>
					<path d="M1144.187,11.429c-0.17-0.052-0.377-0.103-0.637-0.115c-0.367-0.005-0.473,0.089-0.326,0.145
						C1143.304,11.492,1143.55,11.552,1144.187,11.429z"/>
					<polygon points="1143.22,12.477 1144.517,12.417 1144.528,12.228 1143.251,12.102 "/>
					<path d="M1204.478,14.135c0.006-0.056,0.014-0.13,0.027-0.187l-0.461-0.11c-0.02,0-0.043-0.002-0.068-0.002
						c-0.377-0.003-0.539,0.144-0.281,0.252C1203.812,14.14,1204.05,14.191,1204.478,14.135z"/>
					<path d="M1177.358,13.674l0.438-0.286c-0.084-0.003-0.158-0.006-0.238-0.012c-0.73-0.012-0.602,0.195-0.602,0.195
						C1177.017,13.611,1177.233,13.646,1177.358,13.674z"/>
					<path d="M1203.792,15.455c0.344,0.123,0.977,0.146,1.314,0.16c0.381-0.258,0.078-0.591-0.635-1.384
						c-0.166-0.018-0.342-0.031-0.52-0.04c-0.068,0.003-0.166,0.006-0.236,0.006c-0.139,0.046-0.15,0.058,0.07,0.215
						c0.207,0.146,0.215,0.152,0.061,0.343c-0.117,0.143-0.27,0.286-0.295,0.43c0,0.012,0,0.029,0,0.038
						C1203.56,15.368,1203.739,15.432,1203.792,15.455z"/>
					<path d="M1136.325,12.768c0.123,0.052,0.369,0.103,0.799,0.046c0-0.058,0.008-0.136,0.012-0.19l-0.402-0.103
						c-0.021-0.006-0.047-0.006-0.078-0.006C1136.306,12.515,1136.005,12.636,1136.325,12.768z"/>
					<path d="M1137.054,14.071c0.037-0.003,0.082-0.006,0.105-0.01c1.109-0.095,1.227-0.163,0.805-0.456
						c-0.117-0.011-0.25-0.021-0.385-0.026C1136.534,13.568,1137.231,13.91,1137.054,14.071z"/>
					<path d="M1181.743,15.156c0.178,0.068,0.529,0.115,0.646,0.023c0.078-0.058,0.021-0.149-0.008-0.201
						C1181.343,14.979,1181.71,15.133,1181.743,15.156z"/>
					<path d="M1148.37,14.663c-0.043-0.044-0.178-0.115-0.59-0.133c-0.111-0.003-0.223,0-0.33,0.008
						c-0.004,0.087-0.016,0.199-0.016,0.285c0.016,0.003,0.033,0.003,0.051,0.006C1148.183,14.929,1148.468,14.761,1148.37,14.663z"/>
					<path d="M1172.399,16.839c0.799-0.022,0.873-0.195,0.844-0.367c-0.752,0-1.039,0.114-0.912,0.367
						C1172.356,16.839,1172.382,16.839,1172.399,16.839z"/>
					<path d="M1205.712,19.4c1.92,0.006,1.803-0.265,1.611-0.307c-0.24-0.055-0.639-0.037-0.861-0.098
						c-0.141-0.047-0.033-0.106,0.039-0.146c-0.119-0.013-0.24-0.018-0.357-0.023c-0.625-0.011-0.617,0.115-0.539,0.333
						c0.049,0.133,0.033,0.184-0.039,0.241C1205.614,19.4,1205.673,19.4,1205.712,19.4z"/>
					<path d="M1203.327,13.598c0.619-0.17-0.176-0.738-1.23-0.885c0.357,0.304,0.736,0.606,1.166,0.901
						C1203.28,13.611,1203.31,13.603,1203.327,13.598z"/>
					<path d="M1127.942,13.561c0.154-0.087,0.346-0.201,0.49-0.288l-0.881-0.115c-0.305,0.006-0.469,0.023-0.27,0.115
						C1127.493,13.367,1127.979,13.434,1127.942,13.561z"/>
					<path d="M1154.786,31.002c-0.004,0.011,0,0.023-0.004,0.037c0.408,0.012,0.799,0.021,1.215,0.031
						c-0.166-0.045-0.313-0.086-0.426-0.108C1155.319,30.962,1154.972,30.971,1154.786,31.002z"/>
					<path d="M1056.317,28.601c0.047-0.057,0.098-0.132,0.143-0.189c0.279-0.008,0.65-0.017,0.936-0.025
						c0.041-0.058,0.105-0.132,0.146-0.189c-0.248-0.008-0.582-0.021-0.836-0.031c2.18-0.646,0.236-1.391,0.979-2.074l-0.531-0.396
						c1.289-0.425,1.545-0.951,2.549-1.401c0.889,0,1.658,0.104,2.502,0.151c-0.039-0.071-0.076-0.163-0.107-0.235
						c-0.26-0.037-0.592-0.085-0.842-0.126c-0.189,0.037-0.434,0.095-0.621,0.136c-0.307-0.006-0.723-0.013-1.031-0.016
						c0.055-0.065,0.133-0.149,0.18-0.212c-0.18-0.043-0.418-0.101-0.602-0.141c-0.271,0.009-0.629,0.02-0.904,0.028
						c0.303-0.126,0.928-0.27,1.488-0.339c0.43-0.597-0.203-1.194-0.102-1.792c0.225-0.046,0.531-0.104,0.756-0.148
						c0.025,0.005,3.527,1.275,4.328,1.769c-0.238,0.109-0.607,0.246-0.934,0.345c0.201,0.108,0.689,0.241,1.143,0.299
						c0,0.003-0.318,1.076-1.836,2.599c1.143,0.359,0.826,0.469-0.508,0.915c1.074,0.309,1.561,0.449,1.521,1.285
						c20.357,0.433,47.504,1.014,67.863,1.449c0.139-0.049,0.318-0.115,0.459-0.16c0.539,0.045,1.197,0.151,1.539,0.258l95.26,2.521
						c-0.004-0.012-1.855-1.872-2.813-2.459c0.244-0.017,0.57-0.04,0.811-0.051c-0.209-0.304,0.053-0.603-0.078-0.908
						c-0.342-0.028-0.801-0.068-1.145-0.097l0.441,0.487c-0.27,0.067-0.625,0.153-0.891,0.219c0.049,0.058,0.109,0.132,0.156,0.189
						c-0.377,0.106-0.873,0.249-1.244,0.356c0.105,0.12,0.045,0.293-0.184,0.401c-0.766-0.092-1.189-0.148-1.615-0.511
						c0.191-0.049,0.443-0.108,0.633-0.155c0.24,0.023,0.561,0.047,0.795,0.063c0.072-0.132,0.059-0.308,0.012-0.438
						c0.4-0.078,0.801-0.223,1-0.337c-0.447-0.087-1.105-0.192-1.619-0.258c-1.867-2.659-1.867-2.659-2.551-2.792
						c-0.307,0.021-0.723,0.047-1.037,0.063c0.141,0.133,0.258,0.313,0.334,0.447c-0.316-0.057-0.746-0.134-1.066-0.188
						c0.176-0.592-0.803-1.189,0.129-1.775c0.082-0.006,0.168-0.011,0.813-0.046c0.084-0.055,0.191-0.126,0.271-0.178
						c-2.465-0.367-1.377-1.166-3.67-1.551c0.352-0.212,0.352-0.212-0.52-0.977c-0.383-0.011-0.789-0.022-1.197-0.034l1.205,0.034
						c-0.025-0.098,0.188-0.181,0.221-0.275c0.037-0.146-0.834-0.21-1.211-0.235c-1.004-0.074-1.074-0.092-1.355-0.213
						c-0.117,0.009-0.117,0.009-0.109,0.146c-0.068,0.018-0.215,0.026-0.311,0.032c-2.229-0.435-1.209-1.074-1.998-1.604
						c-2.141,0.152-2.141,0.152-2.57,0.225c-0.287-0.046-0.33-0.058-0.447-0.195c-0.102-0.12-0.262-0.207-1.189-0.146
						c0.164-0.313-0.074-0.434-1.002-0.52c-0.361-0.018-0.734-0.026-1.096-0.023c0.361,0.256,0.059,0.526,0.33,0.788
						c-0.438,0.108-0.969,0.24-0.996,0.568c-0.008,0.391,0.605,0.76,0.896,1.143h0.016c0.191,0.597-0.141,0.678-2.275,0.896
						c-0.195-0.095-0.195-0.095-1.27-0.996c-0.83,0.015-1.938,0.031-2.775,0.043c-0.176,0.049-0.412,0.112-0.59,0.157
						c-0.348-0.095-0.791-0.226-1.111-0.324c-3.502-0.092-8.166-0.218-11.658-0.307c-0.055,0.129-0.195,0.301-0.34,0.427
						c1.053,0.277,1.252,0.645,2.012,0.954c-4.492-0.7-4.828-0.801-6.535-1.502c-0.254-0.014-0.59-0.037-0.844-0.049
						c-0.605-0.017-1.408-0.037-2.018-0.054c4.568,0.904,5.973,1.26,7.234,2.027c-5.092-0.337-7.252-1.451-11.059-2.132
						c-0.342-0.008-0.719-0.021-1.063-0.028c0.338,0.008,0.709,0.021,1.039,0.026c-8.215-1.321-8.215-1.321-8.604-1.362
						c-4.617-0.487-9.727-0.637-14.43-1.062c5.447-0.497,6.424-0.106,6.896,0.081c8.475-0.179,16.59,1.486,16.668,1.501
						c0.463,0.361,0.463,0.361,3.336,0.948c0.559,0,1.301,0,1.855,0c-0.117-0.055-0.32-0.112-0.525-0.152
						c0.178-0.242,0.285-0.271,0.898-0.351c1.805,0.33,3.021,0.493,5.232,0.706c3.572,0.096,8.348,0.227,11.92,0.327
						c-4.494-1.85-4.494-1.85-6.389-2.096c0.135-0.5-2.844-0.775-3.561-0.775c-1.77-0.015-1.77-0.015-2.746-1.321l-0.805-0.022
						c0.029-0.448,0.029-0.448-1.369-0.862c0.049-0.04,0.121-0.097,0.166-0.14c-1.701,0.157-2.051,0.467-0.947,0.835
						c-1.729-0.091-1.729-0.091-3.498-0.96c-2.855-0.005-2.555,0.475-1.982,0.696c0.135-0.018,0.313-0.041,0.447-0.058
						c0.117,0.017,0.277,0.037,0.398,0.052c0.408,0.401-0.238,0.801-0.158,1.206c-0.766-0.081-1.785-0.184-2.549-0.259
						c0.154-0.385-0.541-0.775,0.014-1.16c-1.648-0.071-1.648-0.071-2.309,0.807c-1.541-0.017-1.867-0.187-2.383-0.536
						c-0.707-0.047-0.707-0.047-2.971-1.149c-0.57,0.189-1,0.196-2.566,0.029c-0.508,1.092-0.508,1.092-0.695,1.146
						c-0.793-0.095-0.367-0.417-1.521-0.437c-1.277-1.651-1.369-3.334-2.609-4.984c-0.15-0.19-0.369-0.233-1.346-0.268
						c0.467-0.136,0.572-0.178,0.535-0.568c-0.891-0.069-1.721-0.167-2.568-0.259c-1.105,0.49-1.105,0.49-1.43,0.523
						c-0.551-0.34-0.387-0.391,0.131-0.558c-0.105-0.023-0.254-0.052-0.357-0.071c-0.012-0.004-0.031-0.004-0.049-0.004
						c-0.891,0.156-0.947,0.408-1.418,0.612c0.334,0.06,0.334,0.06,1.732,0.537c-1.08,0.499-1.08,0.499-1.83,0.534
						c0.121,0.071,0.637,0.536-0.197,2.911c0.369,0.178,0.867,0.431,0.883,0.626c0,0.012-0.307,2.017-0.307,2.045
						c-0.029,0.101-0.207,0.23-0.318,0.327c-2.521-0.195-3.102-0.396-3.809-1.347c-0.99-0.515-0.313-1.08-1-1.6
						c-0.461-0.344-1.934-0.555-2.336-0.907c-0.15-0.133-0.15-0.238-0.021-0.479c0.01-0.015,0.719-1.517-2.336-1.307
						c0.195,0.135,0.238,0.16,1.107,0.382l0.039,0.006c-1.141,0.382-1.141,0.382-0.732,1.014c0.363,0.563,0.33,0.694-0.176,2.274
						c-0.238,0.74,0.959,1.511-0.738,2.229c-0.891,0.375-2.111-0.377-3.33-0.506c0.955-0.77-1.414-1.548,0.07-2.32
						c-0.896-0.485,0.578-1.143-2.104-1.499c-0.039,0.195-0.045,0.224-0.033,0.58c-0.123-0.063-0.275-0.149-0.398-0.213
						c-1.391,0.367-1.521,0.75-0.459,1.355c-0.506,0.219-0.506,0.219-0.807,2.205c-0.109,0.707-1.871,1.287-3.518,0.92
						c0.092-0.155,0.539-0.284,0.633-0.44c-0.117-0.02-0.281-0.048-0.398-0.071c-0.246,0.012-0.576,0.031-0.824,0.047
						c-0.195,0.126-0.135,0.275-0.502,0.391c-1.689-0.19-0.48-0.707-2.039-0.911c0.605-0.195,0.713-0.451,1.441-0.629
						c0.232,0.003,0.523,0.006,0.738,0.006c-1.574-0.853-2.174-1.367-2.93-2.505c-1.803,0.118-2.088,0.115-4.775,0.087
						c0.725,0.46,0.725,0.46,1.238,0.521c0.105-0.023,0.242-0.055,0.344-0.078c0.047,0.028,0.107,0.065,0.152,0.097
						c-0.428,0.173-0.715,0.162-1.338,0.147c0.117,0.29-1.242,0.546-0.428,0.853c-0.457,0.089-0.457,0.089-2.174,0.155
						c0.424,0.545-0.08,1.105,0.393,1.653c-0.119-0.057-0.355-0.126-0.568-0.166c-0.783,0.145-0.813,0.299-0.525,0.718
						c-0.539-0.011-1.086-0.022-1.631-0.039c-0.49-0.153-0.387-0.526,0.342-0.639c0.08,0.023,0.199,0.052,0.285,0.075
						c0.141-0.028,0.324-0.069,0.459-0.099c-3.551-0.775,1.215-1.923-2.357-2.698c-0.201,0.005-0.475,0.008-0.676,0.011
						c-0.068,0.491-0.068,0.491,0.412,0.601c-2.898,0.669-0.416,1.881-4.764,2.398c-1.104-0.362-1.104-0.362-0.785-1.692
						c-1.439-0.313-1.439-0.313-2.285-0.313c0.785-0.241,0.785-0.241,0.404-0.477c-0.777,0.012-2.598,0.031-2.105,0.925
						c2.381,0.878-0.813,1.729-0.27,2.596l11.07,0.261c-3.432-0.071-7.75-0.16-11.053-0.231c0.086,0.057,0.205,0.126,0.297,0.181
						c-1.121,0.416-0.723,0.925-1.641,1.35c0.111,0.057,0.252,0.131,0.361,0.186c-0.215,0.035-0.508,0.081-0.721,0.115
						c0.432,0.066,0.941,0.173,1.248,0.265c-0.166,0.058-0.398,0.135-0.57,0.194c-0.453-0.048-1.16-0.073-1.656-0.054
						c0.258,0.479-1.355,0.842-1.543,1.292c-0.313-0.083-0.896-0.175-1.381-0.204c-0.717-1.134-0.879-1.797-1.037-3.491v-0.015
						c-0.631-0.003-1.473-0.003-2.104-0.009c-0.455,0.371-1.764,0.667-1.811,1.074c-0.525,0.052-1.27,0.097-1.826,0.12
						c-1.039,0.411-0.871,0.894-1.486,1.327c-0.313,0.006-0.719,0.017-1.025,0.022c-2.063-0.394-2.559-0.488-4.615-0.588
						c1.549-2.04,1.551-2.042,2.053-2.191h0.041l-4.322-3.515c0,0,0.029-0.124,0.299-0.379c0.121-0.018,0.281-0.034,0.404-0.052
						c-0.215-0.132-0.215-0.132-1.309-0.425c0.414-0.587,0.408-0.718-0.488-1.08c0.971-0.371,1.24-0.709,1.373-1.723
						c-1.264-0.319-0.201-0.825-1.77-1.117c0.695-1.097-0.732-2.168-0.813-3.253c-0.637-0.064-0.637-0.064-1.678-1.029
						c-1.154,0.146-1.154,0.146-2.207,0.047c0.141,0.166,0.141,0.166-0.92,0.677c0.107,0.021,0.254,0.047,0.359,0.064
						c0.129-0.007,0.309-0.013,0.441-0.018c0.029-0.037,0.066-0.087,0.096-0.121c0.148,0.043,3.494,1.027,0.371,1.373
						c0.355,0.293,0.424,0.355,0.814,0.885c0.494,0.671,0.281,1.354,0.469,2.032c0.201,0.692-1.813,1.284-1.744,1.971
						c-1.621-0.293-2.771-0.689-4.396-0.982c-0.27-0.589-1.854-1.071-2.604-1.623c-0.318,0.089-0.471,0.207-0.896,0.279
						c-2.109-0.288-2.369-0.547-3.432-1.646c-1.51-0.521,1.025-1.255-1.762-1.709c0.949-0.087,1.332-0.391,2.621-0.339
						c-0.713-0.241-1.258-0.511-2.107-0.732c2.273-0.302,0.4-0.842,0.861-1.255c-0.896-0.063-0.896-0.063-1.758-0.934
						c-1.416-0.092-1.131-0.474-2.111-0.637c0.512-1.008-2.547-1.8-3.254-2.734c0.092-0.025,0.211-0.058,0.309-0.083
						c0.135,0,0.318,0.002,0.465,0.006c-0.699-0.178-1.98-0.167-2.48-0.402c-0.035-0.052-0.084-0.117-0.121-0.166
						c-0.928,0.976-0.928,0.976-0.553,1.077c-0.381-0.038-0.381-0.038-3.537,0.034c0.443,1.777,0.443,1.777,0.805,2.085
						c1.789-0.445,1.789-0.445,1.824-0.649c-0.412,0.021-0.977,0.043-1.387,0.065c0.016-0.367,0.016-0.367,0.113-0.493
						c2.453,0.144,2.471,0.305,2.549,1.545c3.488,0.385,3.488,0.385,3.869,1.854c-0.264,0.081-0.604,0.188-0.863,0.268
						c0.717,0.431,0.717,0.431-0.047,0.508c-1.381-0.275-0.738-0.683-1.285-1.013c-0.225,0.024-0.555,0.051-0.756,0.088
						c-0.801,0.144-1.66,0.667-0.234,0.748c0.984,0.564,0.984,0.564,1.848,0.551c-0.873,0.551,0.891,0.979,1.301,1.47
						c-0.104,0.028-0.232,0.072-0.332,0.104c-0.17,0.003-0.398,0.009-0.578,0.012c1.072,0.241,1.586,0.391,2.207,0.637
						c-1.475,0.282-1.475,0.282-1.316,0.676c-0.771-0.066-0.807-0.33-1.785-0.346c0,0.256,0,0.518,0,0.775
						c-0.613-0.092-0.613-0.092-1.436-0.123c-0.18-0.063-0.959-0.499,1.023-0.471c-1.068-0.25-1.051-0.444-0.414-1.089
						c-1.627,0.228-2.182-0.369-3.514-0.462c0.006-0.04,0.006-0.098,0-0.144c0.41-0.06,0.885-0.08,1.32-0.126
						c-0.941-0.229-0.482-0.572-1.309-0.811c-1.496,0.518-2.197,2.872-2.203,2.895l0.006,0.494c1.965,0.666,0.43,1.87,0.039,1.95
						c1.205,0.391-0.352,0.784,0.021,1.175c0.164,0.175,1.229,0.137,1.406,0.305c0.084,0.086-1.082,0.468-2.676,0.057
						c0.27-0.022,0.625-0.052,0.896-0.075c-0.732-0.172-1.037-0.232-2.205-0.235c0.809,0.38-0.07,0.799,0.602,1.184
						c0.742-0.018,1.355-0.112,2.045-0.163c0.396,0.065,0.914,0.16,1.313,0.231c-0.381,0.609,0.049,1.224-0.305,1.836
						c-1.131,0.487-1.131,0.487-0.721,1.43l35.398,0.767c-10.623-0.181-24.719-0.425-35.313-0.601c0.32,0.618,0.371,0.744,0.326,1.112
						c-0.234,0.022-0.553,0.054-0.773,0.077c1.332,0.646,0.781,0.79,0.08,0.974c1.135,0.425,0.873,0.922,1.434,1.373
						c-1.023,0.272-1.244,0.634-2.068,0.927c1.508,0.543,0.258,1.206,1.494,1.761c-0.373,0.108-0.865,0.252-1.236,0.361
						c0.354,0.327,1.426,0.621,1.016,0.985c-0.012,0.014-2.262,0.684-3.973-0.377c-1.734,0.905-0.385,1.31,0.568,1.468
						c0.371-0.08,0.844-0.192,1.174-0.278c1.357,0.338,1.322,0.364,0.344,1.108c0.211,0.04,0.492,0.104,0.705,0.148
						c-0.057,0.121-0.291,0.282-0.531,0.391l2.928,0.058C1056.331,28.636,1056.253,28.604,1056.317,28.601z M1223.882,31.955
						c-0.086,0.108,0.029,0.149,0.24,0.23c0.236,0.085,0.271,0.143,0.143,0.255l-1.711-0.049
						C1222.79,32.139,1223.071,31.995,1223.882,31.955z M1210.157,32.193c-0.205-0.008-0.334-0.055-0.375-0.075
						c-0.041-0.017-0.379-0.171,0.641-0.178C1210.54,32.128,1210.46,32.199,1210.157,32.193z M1211.29,31.691
						c-0.174,0.008-0.354,0.018-0.535,0.015c-0.604-0.023-0.922-0.115-1.051-0.167c-0.049-0.021-0.471-0.204,0.336-0.268
						c0.063,0.068,0.23,0.098,0.604,0.144C1211.155,31.479,1211.446,31.524,1211.29,31.691z M1210.778,24.268
						c-0.018-0.009-0.037-0.014-0.049-0.022c0.318-0.009,0.609-0.052,0.939-0.061c0.383-0.012,0.723,0.018,0.723,0.018
						c0.488,0.12,0.531,0.298,0.438,0.583c-0.309-0.01-0.768-0.021-1.145-0.118C1211.226,24.553,1211.075,24.4,1210.778,24.268z
						 M1210.767,23.673c0.023-0.445,0.035-0.611,1.307-0.537c0.072,0.061,0.145,0.089,0.441,0.164c0.42,0.104,0.572,0.179,0.389,0.339
						c-0.521,0.063-0.922,0.081-1.535,0.066c-0.18-0.009-0.354-0.022-0.527-0.025C1210.817,23.677,1210.79,23.673,1210.767,23.673z
						 M1213.372,30.135c0.07,0.132,0.098,0.265-0.207,0.259c-0.256-0.013-0.396-0.075-0.422-0.086
						C1212.651,30.267,1212.45,30.143,1213.372,30.135z M1213.019,31.353c-0.023,0-0.055,0-0.072,0c0.082-0.112-0.195-0.235,0.082-0.345
						c0.166-0.066,0.598-0.017,0.779,0C1213.923,31.234,1213.665,31.353,1213.019,31.353z M1214.087,22.325
						c-1.432-0.041-2.953-0.084-4.453-0.128L1214.087,22.325z M1209.649,21.729l-0.02,0.278c-0.115,0-0.227,0.009-0.336,0.006
						c-0.129-0.003-0.344-0.012-0.486-0.075c-0.178-0.076-0.146-0.175-0.424-0.244C1208.759,21.703,1209.267,21.718,1209.649,21.729z
						 M1208.007,20.624l0.867,0.022l-0.016,0.189l-0.875-0.026L1208.007,20.624z M1202.319,23.062c0.502,0.015,1.174,0.034,1.668,0.05
						c0.619,0.737,0.604,1.108-0.098,1.717c-0.412-0.04-0.551-0.055-0.879-0.173c-0.465-0.172-0.918-0.543-0.994-0.7
						C1201.888,23.653,1202.271,23.36,1202.319,23.062z M1197.954,24.754l-0.402-0.104c0.008-0.163,0.252-0.218,0.807-0.178
						C1198.241,24.558,1198.069,24.67,1197.954,24.754z M1197.604,22.646c0.289-0.184,0.404-0.241,0.877-0.265
						c2.088,0.54,0.152,1.172,0.768,1.744c-0.377-0.021-1.02-0.052-1.473-0.245c-0.684-0.278-0.469-0.632-1.402-0.891
						C1196.868,22.933,1197.222,22.881,1197.604,22.646z M1177.948,25.063c0.117,0.034,0.277,0.08,0.395,0.118v0.186
						c-0.123,0.023-0.193,0.023-0.406,0.019c-0.072-0.003-0.184-0.006-0.305-0.056C1177.323,25.207,1177.499,25.058,1177.948,25.063z
						 M1160.937,29.006c0.025,0.006,0.049,0.009,0.061,0.015c0.592,0.161,0.283,0.221-0.119,0.216c-0.223-0.01-0.314-0.037-0.354-0.05
						C1160.396,29.142,1160.524,29.077,1160.937,29.006z M1161.183,29.716c0.627-0.109,0.873-0.139,1.512-0.19
						c0.355,0.185,0.355,0.185,0.412,0.488c0-0.012,0-0.028-0.031-0.04c-0.041,0.012-0.301,0.426,0.525,0.719
						c-0.865-0.026-1.725-0.047-2.596-0.069c-0.258-0.195-0.836-0.352-1.252-0.528c-0.295-0.121-0.371-0.192-0.441-0.267
						C1160.313,29.859,1160.644,29.81,1161.183,29.716z M1157.542,29.21c0,0.178,0.842,0.16,1.227,0.252
						c0.342,0.081,0.242,0.236-0.402,0.236c-0.566-0.023-0.947-0.182-0.99-0.198C1157.224,29.434,1156.927,29.278,1157.542,29.21z
						 M1152.071,25.965c0.107,0.018,0.168,0.047,0.285,0.058c0.373,0.046,0.896,0.089,1.283,0.126c0.072,0.306,0.514,0.466,1.521,0.729
						c0.896,0.227,1.301,0.354,1.523,0.601h-0.068c-1.279-0.044-1.773-0.187-2.408-0.485c-0.424-0.206-0.799-0.379-1.639-0.468
						c-0.061-0.009-0.143-0.016-0.201-0.021c0.141-0.184-0.225-0.35-0.359-0.528C1152.022,25.973,1152.048,25.971,1152.071,25.965z
						 M1164.222,17.755c0.6-0.095,1.736-0.031,1.537,0.259c-0.152-0.003-0.309,0.003-0.467,0.003c-0.203-0.006-0.813-0.023-1.082-0.139
						c-0.078-0.031-0.107-0.063-0.123-0.097C1164.132,17.77,1164.173,17.764,1164.222,17.755z M1156.487,14.567
						c0.197,0.178,0.902,0.313,0.854,0.511c-0.252-0.005-1.008-0.024-1.461-0.209C1155.788,14.823,1155.325,14.611,1156.487,14.567z
						 M1131.608,29.055c-0.307-0.009-0.732-0.018-0.996-0.127c-0.213-0.085-0.256-0.197-0.318-0.384
						C1131.7,28.578,1132.235,28.923,1131.608,29.055z M1125.757,15.837c-0.012,0.262-0.09,0.322-0.146,0.325
						c-0.125-0.006-0.223-0.044-0.738-0.251c-0.127-0.003-0.287-0.008-0.414-0.011C1124.911,15.905,1125.271,15.806,1125.757,15.837z
						 M1124.86,16.696c0.006,0.073,0.135,0.108,0.441,0.16c0.389,0.065,0.555,0.112,0.426,0.235c-0.092,0-0.178,0.011-0.266,0.011
						c-0.359-0.017-0.65-0.068-0.859-0.154C1124.452,16.885,1124.187,16.713,1124.86,16.696z M1118.802,19.446
						c0.572-0.052,0.572-0.052,1.123-0.298c0.178-0.003,0.418-0.006,0.596-0.013c0.137,0.109,0.137,0.109,0.891,0.253
						c-0.1,0.058-0.195,0.145-0.225,0.207c0.156,0.003,0.361,0.009,0.514,0.017c0.109,0.109,0.109,0.109-0.26,0.277
						c1.471,0.034,3.025,0.073,4.582,0.113c-2.076-0.017-4.107-0.027-6.055-0.017c-0.158-0.046-0.389-0.106-0.547-0.149
						c0,0-0.012,0-0.014,0c0.049-0.021,0.086-0.061,0.178-0.058C1118.769,19.602,1118.769,19.602,1118.802,19.446z M1119.323,20.521
						c-0.031-0.003-0.068,0-0.092,0l0.467-0.379C1120.257,20.291,1120.196,20.497,1119.323,20.521z M1112.677,27.175
						c0.402,0.243,0.637,0.243,0.967,0.215c0.902-0.075,0.824-0.343,1.646-0.435c2.057,0.515,4.58,0.756,8.988,0.877
						c0.037,0.244,1.338,0.35,1.32,0.6c-0.357,0.061-0.715,0.071-1.533,0.058c-0.242-0.009-0.475-0.012-0.709-0.021
						c-0.104,0-0.244-0.003-0.354-0.006c-0.105,0-0.248-0.005-0.354-0.008c-0.072-0.055-0.176-0.136-0.275-0.188
						c-1.152-0.603-2.877-0.562-4.027,0.086c-0.529-0.275-1.492-0.191-1.498-0.188c-1.215,0.132-3.389,0.005-5.063-0.29
						c-0.102-0.021-0.23-0.043-0.322-0.063C1111.853,27.597,1112.228,27.384,1112.677,27.175z M1079.538,16.115
						c-0.059,0-0.115-0.003-0.176-0.006c-0.014,0-0.02,0-0.029,0c-0.162-0.315-0.004-0.511,1.279-0.442
						C1080.54,15.942,1080.493,16.127,1079.538,16.115z M1070.653,26.545c-0.143,0.08-0.318,0.189-0.449,0.271l-0.414-0.104
						C1069.851,26.583,1069.944,26.505,1070.653,26.545z M1066.479,27.699l0.031,0.188c-0.078,0.089-0.201,0.111-0.527,0.111
						c-0.541-0.017-1.027-0.121-1.186-0.184C1064.417,27.656,1065.058,27.671,1066.479,27.699z M1063.231,21.738
						c0.184,0.043,0.205,0.14-0.35,0.132c-0.313-0.006-0.613-0.047-0.906-0.115c-0.016-0.003-0.041-0.008-0.057-0.011
						C1062.581,21.689,1063.024,21.689,1063.231,21.738z M1060.53,20.032c0.303,0.08,0.449,0.259-0.453,0.247
						c-0.129,0-0.27-0.005-0.398-0.018c-0.025,0-0.049-0.005-0.076-0.005c-0.01-0.061-0.014-0.145-0.02-0.207
						C1060.009,19.918,1060.392,19.995,1060.53,20.032z M1060.089,20.733c0.166,0.017,0.33,0.037,0.514,0.042
						c0.313,0.003,0.549-0.014,1.211-0.082c0.418,0.234,0.326,0.341-0.051,0.504c-0.248,0.109-0.324,0.162-0.354,0.254
						c-0.203,0-2.051-0.018-2.414-0.052c-0.049,0-0.121,0-0.168-0.003c0.188-0.396,0.188-0.396-0.482-0.778
						C1059.069,20.639,1059.495,20.658,1060.089,20.733z M1053.06,26.855l-0.928-0.316c0.496-0.114,0.955-0.074,1.252-0.022
						C1053.849,26.603,1054.22,26.826,1053.06,26.855z"/>
					<path d="M1199.329,21.904l2.553,0.072c-0.436-0.264-1.064-0.388-2.186-0.434c-0.092-0.006-0.189-0.006-0.281-0.012
						C1199.491,21.669,1199.507,21.784,1199.329,21.904z"/>
					<path d="M1354.134,26.832l-0.025,0.092c1.016,0.034,2.371,0.075,3.383,0.109c0.133-0.046,0.307-0.109,0.441-0.155
						c0.352,0.009,0.352,0.009,1.537,0.161c0.215-0.029,0.439-0.098,0.563-0.149c0.279,0.006,0.658,0.012,0.939,0.018
						c0.057-0.029,0.129-0.063,0.184-0.089c1.195,0.112,1.814,0.221,2.762,0.474c1.162,0.046,2.357,0.034,3.473,0.132
						c0.006,0,0.016,0.006,0.029,0.006c0.324,0.038,0.625,0.086,0.914,0.138l-0.111-0.109c0.047-0.063,0.119-0.149,0.17-0.213
						c2.918-0.103,3-0.314,3.119-0.607c2.25,0.464,4.791,0.289,6.104,0.143c1.086,0.086,1.262,0.402,2.379,0.483
						c-0.16-0.087-0.285-0.219-0.156-0.306c0.721-0.074,1.014-0.103,2.248-0.003c0.553-0.973-6.053-0.255-8.891-0.548
						c-2.816,0.218-9.359,0.028-8.887-0.345c0.791-0.086,1.754-0.051,2.486-0.175c1.08,0.152,2.883,0.417,4.529,0.083
						c0-0.029,0.014-0.069,0.014-0.098c0.012,0,0.023,0,0.035-0.003c1.584,0.049,2.795,0.33,4.406,0.359l0.432-0.167l1.609,0.063
						c0.398-0.046,0.926-0.106,1.33-0.153c0.223,0.026,0.504,0.061,0.725,0.084c1.385,0.175,5.158,0.018,6.441-0.098
						c0.33-0.034,0.33-0.034,4.939,0.584c-0.246,0.054-0.576,0.116-0.824,0.169c1.674,0.304,1.977,0.358,3.182,0.315
						c-0.105-0.052-0.145-0.13-0.076-0.181c0.16,0.003,0.363,0.009,0.523,0.009c-0.154-0.155-0.375-0.192-1.006-0.224
						c-0.131,0.045-0.219,0.12-0.205,0.174c-0.533-0.168-0.859-0.272-2.326-0.385c0.59-0.095,1.381-0.215,1.971-0.31
						c1.002,0.063,1.236,0.092,1.713,0.27c1.953-0.324,3.908-0.369,6.172-0.138c-0.348-0.175-0.348-0.175-2.992-0.646
						c0.092-0.028,0.215-0.063,0.307-0.092c0.768,0.003,1.408,0.098,2.119,0.14l0.443-0.169c0.342,0.069,0.795,0.164,1.145,0.233
						c1.75-0.072,3.361-0.262,5.098-0.348c-0.668-0.377-2.027-0.354-2.418-0.305c-1.154-0.235-1.154-0.256-1.32-0.827
						c-0.787-0.061-0.787-0.061-11.113-0.061c-0.098,0.107-0.098,0.107,0.701,0.417c-0.096,0.023-0.229,0.058-0.32,0.08
						c-0.686-0.012-1.197-0.08-1.664-0.164c0.445,0,0.852-0.055,0.867-0.255c-0.365-0.018-0.848-0.034-1.213-0.052l-0.074,0.23
						c-0.74-0.162-1.395-0.349-2.393-0.42c0.744-0.253,0.744-0.253,0.598-0.371c-0.229-0.188-1.703-0.427-2.48,0.003
						c-0.801-0.284-1.936-0.394-4.855-0.47c-0.18,0.28,0.189,0.367,1.932,0.464c0.072-0.065,0.178-0.16,0.246-0.227
						c1.006,0.311,1.006,0.311,2.891,0.371c-0.213,0.132-0.789,0.221-0.803,0.372c0.215,0.035,0.537,0.061,0.779,0.073
						c-1.309,0.218-3.076-0.124-4.322,0.178c-0.18-0.003-0.418-0.006-0.594-0.01c0.018-0.116,0.348-0.223,0.318-0.338
						c-0.213-0.017-0.5-0.029-0.721-0.04c-0.176,0.37-0.135,0.414,0.273,0.585c-2.582,0.121-3.502,0.081-4.402-0.045
						c0.006-0.053,0.158-0.126,0.33-0.165c0.393,0.032,0.777,0.073,1.189,0.096c-0.084-0.558-2.775-0.483-4.051-0.753
						c0.014-0.058,0.035-0.137,0.061-0.194c2.959-0.053,3.076-0.058,3.535-0.312c-2.385-0.223-2.385-0.223-3.307-0.034
						c-2.93-0.542-4.496-0.375-5.244-0.295c0.873-0.281,2.906-0.311,3.096-0.738c-1.229,0.077-2.502-0.006-3.738,0.043
						c-0.438-0.537-0.438-0.537-0.652-0.6c0.436-0.075,0.436-0.075,7.09-0.118c0.246,0.139,0.246,0.139,2.32,0.531
						c-1.025,0.327-2.48-0.069-3.73-0.008c-0.148,0.26-0.117,0.313,0.301,0.493c1.289-0.215,2.275-0.228,6.281,0.104
						c1.381,0.111,4.246,0.35,4.801-0.232c-2.17,0.074-3.256-0.586-5.559-0.419c-0.078-0.021-0.17-0.05-0.256-0.07
						c0.473-0.143,1.594-0.126,1.693-0.355c3.254,0.518,6.902-0.229,7.066-0.261c-0.219-0.049-1.109-0.184-1.662,0.082
						c-1.229-0.539-4.076-0.034-5.504-0.441c-0.035-0.018-0.084-0.046-0.133-0.063c-0.436,0.097-2.707,0.554-4.574,0.011
						c-3.311,0.431-7.238-0.149-10.523,0.333c0.447,0.29,1.627,0.506,1.725,0.833c-1.055,0.178-7.287,0.327-8.141-0.083
						c-0.199,0.111-0.447,0.261-0.646,0.37c-0.453,0.006-0.453,0.006-1.484-0.247c-3.959,0.161-7.486-0.744-11.592-0.247
						c-0.859-0.272-0.197-0.603-0.602-0.894c0.006,0.003,1.387,0.383,2.125,0.543c0.75-0.187,0.75-0.187,1.496-0.111
						c0.072-0.17,0.072-0.17-0.502-0.486c0.279-0.042,0.725-0.076,1.057-0.086c-1.215-0.212-2.119,0.225-3.305,0.081
						c-0.006-0.058,0.16-0.132,0.322-0.173c0.086-0.006,0.166-0.011,0.484-0.042c0.061-0.038,0.152-0.081,0.213-0.115
						c-0.072-0.04-0.174-0.095-0.25-0.135c-0.635-0.038-0.635-0.038-2.096,0.292c-1.58-0.16-3.547-0.103-4.811-0.445
						c-2.004,0.222-2.924,0.34-4.293,0.532c-3.076-0.167-3.076-0.167-3.781-0.132c-0.129,0.218,0.52,0.613,1.295,0.688
						c0.842-0.092,0.842-0.092,1.18-0.092c0.094,0.026,0.213,0.053,0.307,0.074c-2.328,0.655-5.01,0.288-5.895,0.164
						c-1.197,0.216-1.197,0.216-1.16,1.221c0.977,0.034,1.957,0.069,2.934,0.104c0.662-0.253,1.01-0.244,3.332-0.179
						c-0.426,0.066-0.914,0.104-1.373,0.149c-0.043,0.029-0.1,0.063-0.148,0.089c0.313,0.029,0.313,0.029,2.217,0.364
						c1.357-0.091,1.967-0.2,2.609-0.481c-0.123,0.246-0.123,0.246,2.34,0.848c-1.014,0.123-2.291,0.065-3.229,0.238
						c-1.371-0.225-1.861-0.173-3.514,0c-2.828-0.253-5.826-0.133-8.734-0.201c0.072,0.063,0.178,0.154,0.318,0.218
						c1.438,0.615,4.738,0.195,6.57,0.597c0.207-0.028,0.207-0.028,8.391,0.053c-0.072,0.028-0.166,0.068-0.232,0.1
						c-0.135,0.003-0.313,0.003-0.441,0.003c-0.07-0.022-0.152-0.058-0.211-0.085c-0.949,0.126-0.52,0.286,0.248,0.582
						c-2.1,0.075-4.363-0.123-6.344,0.181c-0.023,0.05-0.047,0.115-0.072,0.161c1.842,0.012,3.191,0.351,5.004,0.379
						c-0.061,0.068-0.061,0.068-2.646,0.371l18.533,0.677l0.023-0.095L1354.134,26.832z M1394.815,24.575
						c-0.625-0.018-0.732,0.184-1.357,0.166c-0.316-0.02-0.34-0.022-0.5-0.103c-0.123-0.063-0.055-0.099,0.01-0.126
						c0.113-0.062,0.146-0.099-0.139-0.201C1394.138,24.346,1394.767,24.391,1394.815,24.575z M1390.825,25.475
						c0.404-0.112,0.711-0.055,0.857-0.016c0.303,0.087,0.379,0.273-0.486,0.244c-0.123-0.003-0.248-0.011-0.367-0.024
						c-0.021,0-0.045-0.007-0.068-0.01C1390.784,25.608,1390.808,25.534,1390.825,25.475z M1388.372,25.472l0.766,0.028l-0.064,0.198
						l-0.768-0.029L1388.372,25.472z M1384.04,25.571c0.023-0.002,0.047-0.002,0.07-0.002c0.52-0.053,0.721-0.213,1.385-0.213
						c0.289,0.235-0.486,0.378-1.148,0.356c-0.113-0.006-0.34-0.018-0.506-0.078c-0.035-0.014-0.072-0.037-0.1-0.055
						C1383.847,25.58,1383.948,25.577,1384.04,25.571z M1380.091,25.437c0.264,0.185-0.377,0.201-0.959,0.182
						c-0.795-0.038-1.02-0.106-1.068-0.124c-0.035-0.018-0.047-0.029-0.047-0.046C1378.583,25.391,1379.126,25.37,1380.091,25.437z
						 M1374.009,25.201c0.459,0.046,0.943,0.092,1.393,0.098c0.648,0.006,1.26-0.049,1.898-0.063c0.092,0.089,0.223,0.206,0.303,0.293
						c-1.479,0.085-1.742,0.097-2.133,0.212c-0.197-0.178-1.143-0.167-1.49-0.308C1373.778,25.351,1373.929,25.259,1374.009,25.201z
						 M1379.519,22.155c0.396-0.112,0.715-0.058,0.867-0.016c0.242,0.069,0.465,0.265-0.484,0.23c-0.129-0.006-0.26-0.012-0.377-0.023
						c-0.023-0.006-0.045-0.008-0.072-0.011C1379.479,22.278,1379.501,22.209,1379.519,22.155z M1359.396,26.35
						c-0.439-0.017-1.771-0.068-2.82-0.255c-0.049-0.009-0.109-0.021-0.152-0.026c0.695,0.018,0.965-0.018,1.271-0.155
						c1.273,0.144,1.68,0.127,2.576,0.08c0.549-0.025,1.131-0.045,2.34,0.013c-0.049,0.092-0.049,0.103,0.092,0.16
						c0.156,0.068,0.475,0.101,0.664,0.16C1361.868,26.39,1360.679,26.394,1359.396,26.35z M1360.899,25.218
						c0.012,0,0.25-0.045,0.195,0.155c0.232,0.042,0.643,0.139,0.678,0.149c-0.219-0.006-0.537-0.054-0.752-0.172
						C1360.899,25.287,1360.858,25.23,1360.899,25.218z M1371.038,25.383c0.064-0.124,0.07-0.142,0.457-0.182
						c0.547-0.052,1.123-0.006,1.678-0.028c-0.068,0.187-0.068,0.187-0.141,0.47c-0.586,0.081-1.057,0.096-2.027,0.064
						c-1.191-0.049-2.314-0.167-3.525-0.201c-0.846-0.026-1.227,0.028-1.434,0.058c-0.113-0.087-0.254-0.207-0.371-0.293l-0.078,0.275
						c-0.627-0.012-1.789-0.077-2.549-0.391c-0.061-0.023-0.121-0.058-0.18-0.086c1.805,0.058,3.607-0.069,5.412,0
						C1369.694,25.124,1370.501,25.278,1371.038,25.383z M1365.155,24.38c0.213,0.065,0.502,0.149,0.715,0.215
						c-0.094,0.038-0.256,0.078-0.537,0.072c-0.348-0.018-0.52-0.092-0.566-0.114C1364.702,24.521,1364.532,24.408,1365.155,24.38z
						 M1362.497,23.427c0.479-0.032,1.01-0.066,1.779-0.074c1.109-0.013,2.031,0.068,2.332,0.097c0.48,0.043,0.48,0.043,0.65,0.034
						c0.326-0.016,0.504-0.097,0.844-0.111c0.037,0,0.082-0.003,0.125,0c0.275,0.015,0.523,0.089,0.523,0.096
						c0.088,0.079-0.066,0.199-0.094,0.286c-0.697,0.075-2.551,0.229-4.861,0.157c-0.264-0.008-0.803-0.031-1.258-0.095
						c-0.045-0.005-0.1-0.011-0.154-0.02C1362.421,23.686,1362.47,23.538,1362.497,23.427z M1360.063,22.425
						c0.377,0,0.791,0.014,1.025,0.037c0.848,0.086,1.074,0.246,1.166,0.477c-0.518-0.065-0.953-0.102-2.002-0.117
						c-1.852-0.032-2.289-0.038-2.643-0.213c-0.094-0.049-0.141-0.099-0.184-0.146C1358.306,22.456,1359.179,22.425,1360.063,22.425z
						 M1359.841,25.437c-0.914,0.152-1.713,0.195-2.84,0.158c-0.297-0.015-0.75-0.031-1.506-0.118c-0.066-0.008-0.146-0.018-0.213-0.022
						c0.029-0.118,0.078-0.271,0.102-0.385C1356.423,25.017,1359.409,25.012,1359.841,25.437z M1353.138,23.357
						c0.582-0.146,2.15,0,2.26,0.271c-0.406,0.063-0.848,0.074-1.902,0.037c-0.168-0.009-0.34-0.014-0.516-0.021
						c-0.02,0-0.049-0.003-0.07-0.003C1352.872,23.57,1352.813,23.441,1353.138,23.357z M1329.534,22.105l-0.803-0.215
						c0.457,0.014,0.848-0.083,1.326-0.047C1329.897,21.922,1329.69,22.03,1329.534,22.105z M1335.397,22.536
						c-0.09-0.006-0.291-0.017-0.408-0.063c-0.049-0.022-0.066-0.042-0.08-0.065c0.264,0,0.35-0.026,0.516-0.089
						c0.342-0.139,0.768-0.066,0.768-0.066C1336.388,22.295,1336.427,22.563,1335.397,22.536z M1337.653,22.373
						c-0.098-0.055-0.166-0.112-0.201-0.17c1.215,0.008,1.764,0.115,2.063,0.17c-0.141,0.083-0.328,0.194-0.469,0.278
						C1338.562,22.611,1337.972,22.536,1337.653,22.373z M1339.288,24.771c0.227,0.092,0.533,0.218,0.771,0.307l-1.668,0.127
						C1338.384,24.928,1338.433,24.762,1339.288,24.771z M1339.128,26.189c-0.051-0.003-0.107-0.003-0.164-0.007c-0.016,0-0.02,0-0.025,0
						c-0.059-0.074-0.119-0.146-0.018-0.224c0.453-0.338,3.555-0.206,4.221,0.098C1341.774,26.057,1340.528,26.234,1339.128,26.189z
						 M1348.251,22.505c-0.012,0.083-0.047,0.198-0.07,0.278l-0.85-0.028l-0.4-0.204C1347.392,22.564,1347.78,22.47,1348.251,22.505z
						 M1345.14,22.434c0.131,0.165,0.061,0.235-0.721,0.212c-0.033-0.014-0.08-0.034-0.104-0.047c-0.318-0.154-0.258-0.298-0.166-0.43
						c0.365,0.04,0.848,0.097,1.215,0.138C1345.103,22.301,1345.058,22.329,1345.14,22.434z M1347.661,26.224l-0.836-0.034l0.047-0.181
						l0.838,0.031L1347.661,26.224z M1348.294,25.287c-0.785-0.028-1.254-0.046-1.48-0.149c-0.154-0.068-0.098-0.149-0.061-0.187
						C1348.522,24.963,1348.351,25.207,1348.294,25.287z M1351.13,26.148c-0.086-0.006-0.287-0.014-0.521-0.101
						c-0.012-0.002-0.029-0.008-0.035-0.011c0.654-0.089,0.895-0.061,0.984-0.038C1351.739,26.051,1351.497,26.158,1351.13,26.148z"/>
					<path d="M1.53,28.429c2.511,0.271,8.667,0.882,11.613,0.732c0.309,0.055,0.72,0.12,1.028,0.175
						c0.318-0.037,0.745-0.083,1.07-0.117c-3.111-1.346-10.441-0.965-15.186-1.639v1.341c0.131,0.024,0.26,0.048,0.404,0.074
						C0.68,28.816,1.122,28.587,1.53,28.429z"/>
					<path d="M128.758,28.503c-9.171-0.668-9.171-0.668-9.201-0.814c0.73-0.075,3.531-0.275,8.882,0.301
						c-0.53-0.348-1.238-0.813-1.77-1.163c-2.145-0.011-3.979-0.528-6.336-0.191c-1.101-0.096-2.033-0.265-3.058-0.388
						c-0.235,0.014-0.543,0.028-0.767,0.042c-0.978-0.172-2.227-0.229-3.257-0.382c-0.037-0.058-0.078-0.135-0.114-0.194
						c0.461-0.058,1.167-0.092,1.686-0.104c-0.053-0.011-5.182-0.996-5.918-1.645c0.413,0.065,1.098,0.117,1.592,0.109
						c0.112-0.044,0.272-0.107,0.384-0.152c0.336,0.092,0.784,0.215,1.114,0.307c2.486-0.055,4.873-0.33,7.462-0.167
						c-1.445-0.708-1.445-0.708-1.598-0.97c3.19-0.112,4.845-0.068,6.271,0.78c-0.843-0.634-1.963-1.478-2.8-2.11
						c-6-0.178-6-0.178-10.78-0.764c-0.194,0.037-0.466,0.087-0.66,0.121c-1.296-0.149-2.923-0.029-4.114-0.265
						c0.053-0.112,0.418-0.262,0.784-0.345c-0.059-0.071-0.137-0.166-0.201-0.241c2.158,0.023,2.357,0.046,3.208,0.138
						c0.199-0.049,0.471-0.114,0.66-0.167c0.224,0.023,0.529,0.055,0.753,0.081c-0.234-0.195-0.847-0.348-1.012-0.545
						c1.473-0.018,1.473-0.018,2.711-0.133c0.211,0.028,0.507,0.058,0.73,0.08c0.047-0.052,0.112-0.12,0.152-0.172
						c-2.935-0.833-2.935-0.867-2.905-1.258c1.262,0,4.633,0.068,8.707,0.718c-0.29-0.304-0.672-0.712-0.962-1.02
						c-5.44,0.342-6.467-0.318-8.187-1.412c0.166-0.049,0.378-0.115,0.536-0.164c-0.04-0.058-0.099-0.135-0.146-0.192
						c2.329,0.015,5.457,0.296,5.476,0.302c1.779,0.398,0.712,1.034,2.305,1.449c-0.697-0.697-1.627-1.627-2.329-2.328
						c-0.082,0.063-0.188,0.144-0.271,0.201c-7.468,0.018-27.177-1.536-27.336-1.554c-0.165,0.046-0.383,0.104-0.547,0.146
						c-5.347-0.453-11.041-0.592-16.462-0.971c-0.49-0.015-1.162,0.006-1.627,0.04c0.536,0.149,0.536,0.149,7.927,0.944
						c0.059-0.054,0.141-0.129,0.207-0.181c0.76,0.242,0.667,0.563,1.386,0.811c0.199-0.028,0.459-0.069,0.659-0.102
						c-0.036-0.117-0.294-0.267-0.594-0.358c0.146-0.061,0.354-0.141,0.5-0.201c4.645,0.563,8.629,1.338,12.96,2.001
						c-0.205,0.058-0.488,0.13-0.694,0.185c-4.444,0.072-8.411-0.457-12.749-0.52c0.895,0.444,2.475,0.78,3.678,1.184
						c-0.207,0.052-0.485,0.12-0.685,0.172c-0.837-0.018-1.661-0.063-2.511-0.055c2.907,0.83,2.907,0.83,1.427,1.111
						c-3.253-0.092-5.583-0.956-9.402-0.586c-0.112-0.129-0.087-0.315,0.07-0.442c0.208,0.038,0.484,0.083,0.691,0.118
						c-1.168-1.014-12.089-0.835-12.19-0.83c0.207,0.108,0.573,0.247,0.884,0.339c-0.012,0.005-2.54,0.264-9.428-0.179
						c-1.105,0.149-11.325-0.631-11.538-1.039c2.457-0.017,4.462,0.373,6.891,0.379c0.153-0.04,0.365-0.097,0.519-0.141
						c2.334,0.009,4.38,0.45,6.873,0.229c-0.377-0.221-0.725-0.295-1.928-0.28c-6.489-0.79-6.489-0.79-13.741-0.715
						c-4.79,0.051-7.515-0.925-11.65-1.199c-0.475-0.031-1.096,0.078-1.544,0.125c0.267,0.143,0.618,0.33,0.877,0.473
						c4.026,0.324,5.096,0.437,10.232,0.969c-0.065,0.138-0.362,0.327-0.774,0.43c3.678,1.212,10.343,0.73,15.047,1.361
						c-0.083-0.086-0.188-0.195-0.271-0.28c5.354,0.637,11.591,0.537,17.114,1.035c0.112-0.051,0.252-0.117,0.36-0.168
						c1.801-0.007,2.993,0.034,6.447,0.27c9.856,0.674,9.856,0.674,9.973,0.646c0.207,0.092,0.672,0.192,1.078,0.235
						c0.055-0.06,0.125-0.141,0.172-0.204c5.533,0.587,11.764,0.718,17.169,1.376c0.146,0.093,0.347,0.213,0.488,0.305
						c0.448-0.031,1.091-0.049,1.556-0.031c-0.124,0.061-0.283,0.143-0.412,0.203l-10.609-0.399c-0.359-0.074-0.944-0.149-1.403-0.184
						c-0.129,0.053-0.289,0.127-0.412,0.184c-0.061-0.011-6.731-0.919-8.794-0.396c-0.838-0.086-0.838-0.086-2.547-0.106
						c0.478,0.353,0.478,0.371,0.483,0.666c1.308,0.198,3.416,0.198,5.204,0.267l-0.217-0.224l-0.093,0.092
						c-0.154-0.126-0.202-0.206,0.021-0.246c0.108-0.018,0.307-0.016,0.615,0.005c0.159,0.012,0.448,0.026,0.628,0.017
						c0.114,0.093,0.308,0.271,0.138,0.354c-0.094,0.044-0.254,0.041-0.416,0.038c1.518,0.08,2.679,0.244,2.621,0.695
						c-3.773-0.058-5.854,0.218-5.878,0.223c0.249,0.007,0.573,0.018,0.82,0.023c-0.07,0.063-0.175,0.146-0.258,0.207
						c-0.501,0.006-1.179-0.003-1.686-0.023c-0.19,0.038-0.438,0.087-0.632,0.127c0.135,0.057,0.319,0.132,0.454,0.189
						c1.699,0.029,3.16,0.235,4.763,0.333c0.201-0.034,0.472-0.081,0.672-0.115c0.308,0.018,0.308,0.018,3.361,0.396
						c0.371,0,0.371,0,2.415,0.195c0.579-0.098,0.579-0.098,11.895,1.326c0.178,0.112,0.414,0.265,0.588,0.38
						c-0.181,0.052-0.429,0.12-0.612,0.167l-9.779-0.773c-3.66,0.434-5.581-0.479-8.563-0.571c-0.26-0.091-0.607-0.212-0.867-0.304
						c-5.097,0.947-10.026-0.442-15.083-0.058c0.884,0.25,1.226,0.241,2.133,0.213c2.029,0.367,6.496,0.017,6.754,0.835
						c-0.075,0.009-8.178,0.161-9.052-0.474c-0.129,0.058-0.305,0.126-0.435,0.178c-1.981-0.253-1.675-0.58-1.568-0.688
						c0.53-0.01,1.238-0.023,1.769-0.047c-1.203-0.465-3.925-0.646-4.504-1.229c-0.365,0.063-0.778,0.175-0.978,0.27
						c-3.261-0.27-6.655-0.031-9.95-0.141c-3.545-0.118-6.831-0.451-10.308-0.623c-0.189,0.04-0.445,0.086-0.634,0.127
						c0.797,0.367,3.032,0.304,3.891,0.654c-1.894,0.221-15.181-0.448-16.315-0.953c-3.381,0.305-6.284-0.546-9.683-0.207
						c-0.424-0.063-0.951-0.17-1.255-0.264c-2.657-0.044-3.856-0.461-5.083-0.87c0.099,0.008,0.186,0.008,0.284,0
						c0.165-0.01,0.32-0.021,0.486-0.01c-0.251-0.177-0.761-0.31-1.111-0.347c-0.36-0.026-0.311,0.089-0.237,0.17
						c-0.533-0.167-1.107-0.322-1.837-0.438l-0.695-0.063c-0.184,0.04-0.423,0.086-0.599,0.126c-0.227-0.018-0.528-0.034-0.755-0.052
						c0.503,0.361,2.693,0.448,2.735,0.879c-1.543-0.267-1.543-0.267-4.322-0.426c-0.119-0.103-0.075-0.252,0.104-0.35
						c0.228,0.02,0.525,0.049,0.751,0.068c0.18-0.034,0.418-0.08,0.596-0.117c-0.138-0.103-0.59-0.228-1.011-0.284
						c-1.725,0.114-3.032-0.204-4.63-0.227c0.649,0.232,1.842,0.33,2.587,0.537c-0.043,0.063-0.1,0.151-0.144,0.218
						c-2.959-0.026-4.9-0.402-5.95-0.605c0.049-0.061,0.11-0.147,0.165-0.21c0.212,0.026,0.498,0.063,0.712,0.086
						c0.154-0.041,0.366-0.095,0.523-0.138c-0.76-0.393-2.71-0.473-4.093-0.702v0.495C0.49,18.869,1.078,18.97,1.6,19.013
						c-0.03,0.055-0.066,0.13-0.089,0.188c-0.49-0.041-0.968-0.088-1.455-0.13v3.435c0.16,0.011,0.326,0.015,0.478,0.031
						c0.216-0.02,0.501-0.051,0.717-0.071c-0.013-0.121-0.274-0.285-0.613-0.377c0.094-0.051,0.216-0.117,0.309-0.166
						c2.86,0.218,5.488,0.598,8.597,0.638c0.118,0.052,0.277,0.12,0.401,0.172c1.058-0.092,5.938,0.046,5.355,0.862
						c-0.213,0.025-0.505,0.058-0.721,0.073l-0.918-0.172c-0.945-0.292-2.587-0.396-3.601-0.666c0.012,0.068,0.034,0.164,0.05,0.235
						c-0.245-0.014-0.568-0.034-0.814-0.046c-0.037,0.117,0.17,0.284,0.456,0.385c0.253-0.011,0.588-0.029,0.84-0.043
						c0.177,0.058,0.41,0.129,0.583,0.187c0.969,0.006,0.969,0.006,3.083,0.27l-0.082-0.184c0.153,0.04,0.362,0.098,0.516,0.136
						c4.086-0.416,6.499,0.864,10.499,0.528c1.109,0.209,1.551,0.144,2.428,0.009c-2.093-0.213-3.288-0.67-5.161-0.942
						c-0.127-0.139-0.278-0.322-0.364-0.466c0.181-0.042,0.419-0.103,0.602-0.149c0.201,0.035,0.47,0.087,0.669,0.121
						c0.243-0.009,0.57-0.02,0.807-0.028c0.197,0.035,0.448,0.08,0.642,0.111c0.076-0.06,0.172-0.14,0.251-0.204
						c0.237-0.011,0.553-0.028,0.785-0.04c1.532,0.498,5.016,0.566,5.531,1.287c-1.048-0.081-2.086-0.181-3.173-0.241
						c-0.207,0.031-0.484,0.075-0.683,0.106c2.743,0.321,2.969,0.347,4.189,0.844c2.582,0.063,4.81,0.537,7.624,0.336
						c-0.952-0.089-0.972-0.092-1.282-0.414c10.973,0.896,23.065,0.689,33.862,1.761c2.723-0.375,11.222,0.531,12.083,0.942
						c-0.618,0.262-1.32,0.554-17.881-0.701L55.129,26.24c0.107,0.052,0.236,0.12,0.336,0.173c6.647,0.204,6.647,0.204,15.331,1.148
						c-0.142,0.04-0.332,0.101-0.472,0.145c-0.277-0.007-0.649-0.021-0.921-0.026c-0.854-0.262-8.263-0.411-8.817-0.348
						c-0.011,0.058-0.034,0.126-0.046,0.181c-0.479,0.021-1.157,0.014-1.628-0.011c-0.023-0.055-0.058-0.128-0.082-0.182
						c-0.236-0.012-0.542-0.031-0.78-0.046c-0.07,0.058-0.15,0.132-0.211,0.189c-0.482-0.022-1.143-0.043-1.632-0.051
						c11.841,0.61,27.626,1.423,39.473,2.029c0.4-0.098,0.896-0.238,1.219-0.348c-0.96-0.293-1.078-0.321-2.952-0.657
						c-0.136,0.058-0.306,0.136-0.446,0.195c-0.602,0.003-1.41,0.025-2.004,0.049c-1.108-1.155-1.108-1.155-1.48-1.247
						c2.889-1.274,13.544,0.222,14.311,0.435c-0.065,0.058-0.146,0.136-0.201,0.198c7.204,0.747,8.47,0.614,9.578,0.499
						c-0.111-0.108-0.028-0.27,0.154-0.376c0.022,0,6.565,0.376,15.56,0.709C129.218,28.778,128.958,28.621,128.758,28.503z
						 M113.751,23.027c0.248,0.197,0.165,0.284-0.271,0.272c-0.07-0.005-0.142-0.018-0.218-0.022c-0.016,0-0.028-0.003-0.04-0.006
						C112.72,22.962,113.174,22.989,113.751,23.027z M37.961,15.958c-0.034-0.003-0.113-0.012-0.224-0.075
						c-0.037-0.022-0.132-0.077-0.079-0.106h0.008c0.081-0.018,0.246,0.023,0.516,0.118C38.106,15.942,38.045,15.96,37.961,15.958z
						 M39.633,16.063c-0.088-0.006-0.115-0.022-0.148-0.04c-0.081-0.045-0.119-0.103-0.086-0.126c0.019-0.023,0.097-0.018,0.211,0.023
						C40.031,16.063,39.639,16.063,39.633,16.063z M71.021,17.867l-0.461-0.29l0.56,0.025L71.021,17.867z M98.857,17.012
						c-0.607-0.035-0.973-0.161-1.526-0.219c-0.024,0-0.061-0.005-0.083-0.005c0-0.013,0.011-0.026,0.022-0.034
						c0.207-0.168,1.458-0.073,2.111,0.218C99.206,17.012,99.099,17.021,98.857,17.012z M98.192,16.558
						c-1.08-0.065-1.893-0.259-2.984-0.319c0.201,0.199,0.909,0.366,0.743,0.589c-0.411-0.018-0.813-0.034-1.219-0.055
						c-0.277-0.232-0.277-0.267-0.052-0.413c0.117-0.074,0.1-0.111,0.046-0.221c-0.224,0-0.389-0.034-0.402-0.034
						c-0.766-0.196-0.807-0.492-1.72-0.673c-0.312-0.061-0.826-0.028-1.072-0.115c-0.148-0.051-0.177-0.108-0.224-0.166
						c2.169-0.097,3.365-0.151,5.353-0.005c1.278,0.097,1.278,0.097,1.532,0.258c0.199,0.127,0.283,0.148,0.482,0.155
						c0.349-0.144,1.02-0.007,1.522-0.032c0.388,0.13,0.471,0.158,1.071,0.245c1.216,0.184,1.297,0.258,1.569,0.517
						C101.09,16.201,99.959,16.667,98.192,16.558z M84.877,20.722c-0.349-0.018-0.59-0.075-0.727-0.115
						c-0.022-0.006-0.034-0.012-0.047-0.015c0,0-0.217-0.175,0.025-0.226c0.17-0.035,0.252-0.029,1.019,0.005
						C85.694,20.722,85.142,20.733,84.877,20.722z M88.997,21.003c-0.025,0-0.042,0-0.061-0.003c-0.059-0.068-0.2-0.215-0.141-0.296
						c0.06-0.08,0.284-0.052,0.448,0C89.593,20.808,89.856,21.032,88.997,21.003z M86.491,22.237c-0.465-0.028-0.742-0.132-0.867-0.191
						c-0.087-0.038-0.141-0.081-0.188-0.124c0.577,0.009,0.979,0.055,1.262,0.144C87.305,22.255,86.499,22.237,86.491,22.237z
						 M90.417,21.537c-0.008-0.003-0.012-0.006-0.017-0.006c-0.061-0.038-0.089-0.075-0.106-0.109c0.112,0.006,0.254,0.012,0.365,0.014
						l0.412,0.193C90.776,21.618,90.563,21.611,90.417,21.537z M92.021,21.768c-0.324-0.021-0.666-0.115-0.837-0.196
						c-0.006-0.006-0.019-0.011-0.03-0.018c0.165,0.012,0.235,0.018,0.33-0.005c0.013,0,0.024-0.003,0.035-0.006
						c0.165-0.058,0.307-0.104,0.52-0.043C92.049,21.503,92.521,21.778,92.021,21.768z M93.158,21.83
						c-0.425-0.021-0.602-0.078-0.713-0.127c-0.006-0.006-0.017-0.009-0.03-0.011c0.202,0.022,0.461,0.04,0.744-0.053
						c0.146-0.045,0.3-0.086,0.507-0.034C94.62,21.864,93.169,21.833,93.158,21.83z M105.181,16.756c-0.03-0.002-0.059-0.009-0.082-0.012
						c0.423-0.144,1.773-0.123,2.775,0.207C106.986,16.88,106.02,16.862,105.181,16.756z M104.816,22.56
						c-0.047-0.023-0.07-0.043-0.095-0.066c0.306,0.034,0.708,0.084,1.014,0.118C105.43,22.594,105.022,22.651,104.816,22.56z
						 M106.136,22.727l-0.181-0.184l0.405,0.017l0.188,0.184L106.136,22.727z M9.391,19.607c0.112-0.055,0.395,0.025,0.672,0.189
						c0.01,0.006,0.015,0.012,0.026,0.018c0.092,0.057,0.162,0.117,0.224,0.178c-0.388-0.034-0.564-0.052-0.755-0.167
						C9.447,19.762,9.287,19.653,9.391,19.607z M10.812,21.658c-0.156-0.019-0.579-0.063-1.094-0.356
						c-0.263-0.149-0.263-0.149-0.328-0.345c0.194,0.052,0.431,0.091,0.676,0.127c0.343,0.045,0.733,0.103,1.065,0.267
						c0.221,0.105,0.351,0.232,0.354,0.232C11.485,21.583,11.3,21.697,10.812,21.658z M11.852,21.347
						c0.106,0.104,0.106,0.104,0.913,0.518c-0.092,0.017-0.211,0.04-0.306,0.063c-0.106-0.139-0.215-0.187-0.458-0.253
						c-0.114-0.032-0.208-0.066-0.28-0.104c-0.084-0.052-0.132-0.109-0.172-0.16C11.636,21.394,11.758,21.364,11.852,21.347z
						 M12.577,22.301c-0.244,0.009-0.496,0.018-0.742-0.074c-0.014-0.003-0.039-0.012-0.044-0.018c-0.013,0-0.315-0.315-0.151-0.35
						c0.042-0.013,0.141,0.005,0.144,0.005c0.187,0.138,0.326,0.189,0.601,0.218c0.221,0.019,0.491-0.017,0.672,0.035
						c0.169,0.046,0.198,0.138,0.218,0.227C13.13,22.289,12.953,22.292,12.577,22.301z M13.573,22.24
						c-0.16-0.083-0.086-0.114-0.056-0.129c0.159,0.126,0.683,0.201,0.851,0.33C13.924,22.398,13.682,22.298,13.573,22.24z
						 M37.261,24.751l-0.214-0.198l0.312,0.022l0.214,0.198L37.261,24.751z M60.97,23.427c-0.778-0.023-1.421-0.139-2.181-0.166
						c-0.317-0.013-0.336-0.013-0.514,0.057c-0.164,0.063-0.199,0.063-0.364,0.069c-0.452,0.023-0.329-0.139-0.76-0.139
						c-0.425,0-0.229,0.158-0.66,0.149c-0.961-0.034-1.409-0.249-2.265-0.321c-0.6-0.046-1.208,0.022-1.812-0.012
						c-0.667-0.034-0.875-0.204-1.471-0.259c-0.318-0.031-0.677,0.003-0.99-0.034c-0.041-0.005-0.088-0.011-0.127-0.017
						c0,0-0.188-0.031-0.353-0.109c-0.015-0.006-0.688-0.354-0.089-0.367c0.016,0,2.208,0.011,2.505,0.026
						c0.991,0.048,1.863,0.174,2.849,0.231c5.795,0.319,6.272,0.345,7.257,0.813C61.712,23.415,61.494,23.438,60.97,23.427z
						 M72.386,25.069c-0.017-0.02-0.036-0.037-0.046-0.056c-0.095-0.123-0.036-0.151,0.212-0.108c0.034,0.08,0.082,0.187,0.116,0.271
						L72.386,25.069z M80.863,25.695c-0.202,0.114-0.55,0.164-1.097,0.154c-1.279-0.021-2.251-0.221-3.419-0.313
						c-0.423-0.031-0.565-0.043-1.072,0.014c-0.205,0.023-0.389,0.047-0.589,0.034c-0.013,0-0.036,0-0.048,0
						c-0.211-0.016-0.388-0.068-0.388-0.068c-0.331-0.103-0.532-0.224-0.862-0.333c-0.034-0.011-0.093-0.028-0.118-0.046
						c-0.306-0.121-0.27-0.146-0.235-0.166c0.159-0.115,0.955,0.095,1.467,0.299c0.047-0.109,0.159-0.139,0.484-0.127
						c0.536,0.018,0.93,0.121,1.48,0.135c0.971,0.029,1.962-0.02,2.941,0.029c0.82,0.037,1.319,0.135,1.615,0.192
						C80.992,25.558,80.958,25.638,80.863,25.695z M72.481,27.788c-0.152,0.095-0.837-0.026-1.226-0.218
						c-0.112-0.055-0.188-0.112-0.241-0.17c0.525,0.003,0.677,0.133,1.114,0.167c0.087,0.006,0.171,0.009,0.259,0
						C72.445,27.619,72.574,27.73,72.481,27.788z M73.595,27.814c-0.136-0.009-0.266-0.017-0.395-0.021
						c-0.024-0.003-0.036-0.003-0.059-0.003c-0.4-0.296-0.024-0.289,0.547-0.249C74.119,27.798,73.977,27.832,73.595,27.814z
						 M79.466,28.176c-0.69-0.011-4.156-0.086-4.933-0.35c-0.142-0.046-0.271-0.115-0.366-0.167c0.649-0.015,1.221-0.138,1.934-0.081
						c0.824,0.063,1.06,0.273,1.803,0.362l0.518-0.16c0.884-0.006,3.878,0.018,5.222,0.61C82.501,28.285,81.406,28.217,79.466,28.176z
						 M83.739,28.319l-0.218-0.194l0.372,0.017l0.224,0.195L83.739,28.319z M84.658,28.334c-0.129-0.052-0.17-0.124-0.199-0.164
						c0.542,0.047,0.784,0.139,0.972,0.23C84.74,28.362,84.74,28.362,84.658,28.334z M88.785,27.384c0.011-0.006,0.022-0.015,0.047-0.023
						c0.118-0.055,0.507-0.068,0.837,0.155L88.785,27.384z M101.157,25.772c-0.786-0.243-2.458-0.198-3.119-0.485
						c-0.224-0.098-0.289-0.203-0.331-0.287c0.459,0.095,0.843,0.092,1.675,0.081c1.391-0.018,1.992,0.061,2.592,0.557
						C101.504,25.611,101.479,25.741,101.157,25.772z M108.417,22.771c-0.148,0.146-1.149-0.011-1.563-0.178
						c-0.083-0.034-0.142-0.074-0.177-0.115c0.395-0.034,0.413-0.034,1.173,0.222l0.537-0.058
						C108.423,22.686,108.463,22.727,108.417,22.771z M109.638,22.692c0.082,0.082,0.188,0.194,0.283,0.277
						c-0.082-0.003-0.154,0.009-0.224,0.009c-0.129-0.009-0.378-0.023-0.638-0.138c-0.07-0.032-0.123-0.063-0.169-0.098
						C109.143,22.731,109.313,22.651,109.638,22.692z M112.52,25.876l-0.418-0.014l-0.024-0.013c-0.224-0.108-0.142-0.16-0.004-0.175
						C112.083,25.675,112.88,25.66,112.52,25.876z M118.762,27.835c-0.036-0.009-0.059-0.021-0.089-0.034
						c-0.171-0.073-0.277-0.179-0.248-0.248c0.048-0.105,0.353-0.077,0.359-0.077C118.796,27.479,119.328,27.822,118.762,27.835z"/>
					<path d="M73.801,15.625c-1.103-0.095-2.163,0.097-3.265,0.02c-1.126-0.083-1.746-0.402-3.165-0.35
						c-0.408-0.167-0.697-0.351-1.168-0.506c-0.848-0.028-0.966-0.012-1.309,0.105c-0.849-0.14-2.133-0.347-5.788-0.479
						c-2.069-0.079-2.069-0.079-4.954-1.194c-0.182,0.351-0.182,0.351-0.423,0.432c-2.203-0.075-4.243-0.282-6.376-0.408
						c-1.882-0.112-3.568,0.201-5.43,0.132c-1.351-0.052-2.505-0.224-3.813-0.293c-0.132,0.037-0.289,0.093-0.384,0.138
						c-0.25-0.068-0.577-0.158-0.825-0.224c-0.755,0-1.19,0.25-2.09,0.138c-0.955-0.121-0.415-0.401-1.179-0.546
						c0.117,0.069,0.234,0.145,0.349,0.215c-0.076,0.21-1.293,0.233-1.43,0.435c-1.729-0.368-6.777,0.034-6.118-0.675
						c0.107-0.015,0.248-0.029,0.353-0.04c-0.229-0.354-5.23-0.689-5.282-0.692c0-0.022-0.004-0.055-0.01-0.08
						c0.186-0.023,0.483-0.029,0.688-0.021c0.008-0.003,0.008-0.009,0.064-0.031c-0.237-0.229-0.982-0.407-1.276-0.627
						c3.191-0.063,6.224,0.23,9.401,0.213c0.795,0.235,1.51,0.354,2.738,0.445c2.076,0.158,4.415-0.058,6.398,0.232
						c1.91,0.275,1.91,0.275,6.048,0.472c2.744,0.643,7.18,0.278,10.016,0.867c2.511-0.368,4.326,0.591,6.849,0.178
						c2.192,0.993,2.287,1.034,3.884,0.799c0.043-0.053,0.053-0.13-0.018-0.185c-0.099,0.006-0.228,0.012-0.33,0.018
						c0.03-0.023,0.066-0.052,0.095-0.074c-0.095-0.013-0.216-0.029-0.312-0.041c-0.007,0.021-0.019,0.052-0.019,0.075
						c-0.095,0.008-0.224,0.017-0.323,0.025c-0.136-0.095-0.33-0.221-0.478-0.318c0.283,0.005,0.648,0.011,0.924,0.014
						c0.16-0.048,0.343-0.118,0.442-0.169c0.16,0.04,0.389,0.092,0.589,0.121c1.281-0.107,1.281-0.107,1.722-0.035
						c-0.577-0.512-1.838-0.353-2.216-0.29c-0.024-0.008-4.62-1.021-5.163-1.094c0.26-0.118,0.384-0.241,0.555-0.365
						c0.124-0.014,0.294-0.037,0.43-0.052c1.136,0.115,1.149,0.509,2.622,0.543c1.498-0.299,1.498-0.299-3.719-1.421L60.77,11.01
						l-0.176-0.197c-0.083,0.024-0.196,0.054-0.279,0.079c-2.062-0.428-5.108-0.577-6.515-1.186c-0.82,0.109-1.259-0.127-1.968-0.108
						c-0.036,0.259,1.211,0.474,0.526,0.757c-0.424,0.173-0.583,0.162-2.501,0.053c0.022,0.166,0.134,0.206,1.083,0.367
						c1.449,0.253,3.417,1.681,3.42,1.694c-0.07,0.011-0.17,0.034-0.24,0.052L35.51,11.441c-0.704-0.05-0.85-0.21-1.271-0.319
						c-0.071,0.021-0.167,0.042-0.233,0.063c-0.385-0.021-1.23-0.154-1.238-0.157c0.033-0.023,0.081-0.055,0.119-0.075
						c0.655-0.074,1.199,0.031,1.796,0.058c0.072-0.017,0.164-0.046,0.229-0.063c0.002-0.218,0.002-0.218-4.083-1.094
						c-0.324-0.069-0.324-0.069-1.396-1.014c-0.238-0.015-0.566-0.035-0.806-0.052c-0.639-0.293-1.87-0.471-2.698-0.724
						c-0.445,0.12-0.266,0.276-0.399,0.413c-1.731,0.007-3.073-0.364-4.903-0.258c0.795,0.42,3.201,0.588,3.382,1.105
						c-1.263,0.115-2.331-0.095-3.521-0.112c0.85,0.546,1.387,0.741,2.283,0.833c1.456,0.155,2.063-0.253,3.29-0.253
						c-0.053-0.046-0.145-0.108-0.231-0.149c-0.196-0.014-0.466-0.029-0.676-0.034c-0.333-0.155-0.328-0.173-0.238-0.293
						c1.42-0.203,1.762-0.083,2.672,0.229c0.195,0,0.459-0.025,0.607-0.052c0.101,0.007,0.229,0.021,0.327,0.029
						c0.482,0.355,2.22,0.488,2.817,0.821c-0.481,0.04-0.996,0.006-1.476,0.04c-0.104,0.06-0.116,0.149-0.101,0.215
						c0.804,0.118,1.621,0.232,2.411,0.354c-1.677,0.184-3.166,0.126-6.926-0.258c-1.025-0.109-2.587-0.267-4.07-0.348
						c-0.977-0.052-1.993,0.095-2.964-0.026c-2.479-0.31-2.861-0.358-3.819-0.209c0.462,0.232,0.462,0.232,2.363,0.64
						c-0.454,0.299-1.299,0.855-5.52,0.471C9.776,11.09,9.776,11.09,6.01,9.772c0.092-0.023,0.209-0.055,0.3-0.075
						C7.21,9.694,8.022,9.919,8.983,9.746C8.362,9.04,11.341,7.942,7.051,7.622c-0.075,0.017-0.18,0.034-0.255,0.051
						C5.804,7.145,5.8,6.553,4.745,6.03c-0.9-0.451-0.9-0.451-2.6-0.677C1.74,5.324,1.74,5.324,1.144,5.39
						c0.456,0.325,0.456,0.325,0.352,0.417c-0.224,0.006-0.53,0-0.751-0.006C0.664,5.815,0.558,5.835,0.478,5.852
						c0.553,0.331,3.484,0.478,2.36,0.896c-0.224-0.006-0.521-0.02-0.743-0.031c0.546,0.284,0.923,0.46,2.309,0.79
						C4.853,7.615,6.181,8.374,5.74,8.54c-0.207,0.006-0.498,0-0.688-0.02C5.285,8.804,6.42,9,6.564,9.293
						C6.466,9.315,6.347,9.344,6.255,9.361C5.332,9.169,5.332,9.169,5.023,9.144C2.772,8.973,1.173,8.852,0,8.766v0.327
						c1.702,0.234,1.776,0.226,2.25,0.159C2.35,9.29,2.46,9.344,2.574,9.378c0.688,0.207,2.045,0.127,2.738,0.334
						c0.802,0.235,0.313,0.56,1.112,0.792c0.012,0.006,1.165,0.42,0.871,0.649c-0.42,0.043-0.898,0.006-1.331,0.034
						c-0.047,0.026-0.11,0.063-0.16,0.086c1.286,0.262,2.585,0.457,5.102,0.621c-0.237-0.213-0.237-0.213-0.1-0.351
						c0.454,0.301,0.454,0.301,0.689,0.385c0.021-0.184-0.182-0.364-0.257-0.548c1.038,0.191,2.511,0.191,3.499,0.404
						c0.599,0.133,0.308,0.31,0.496,0.463c12.257,1.079,12.257,1.079,12.558,0.943c7.137,0.874,11.413,1.017,16.825,1.202
						c3.441,0.113,17.158,1.064,17.241,1.072c1.107,0.104,2.044,0.285,3.229,0.354c1.219,0.072,2.31-0.123,3.506-0.089
						c1.74,0.052,3.213,0.304,4.982,0.33c0.931,0.015,1.295-0.02,1.91-0.08C75.104,15.857,74.585,15.69,73.801,15.625z M57.653,12.395
						c0.7,0.034,1.255,0.14,1.891,0.206c0.207,0.262-0.423,0.287-0.991,0.259c-0.989-0.061-1.42-0.241-1.532-0.294
						c-0.07-0.034-0.118-0.074-0.16-0.114C56.973,12.417,57.14,12.361,57.653,12.395z M28.552,9.324
						c-0.081-0.009-0.104-0.025-0.132-0.041c-0.078-0.042-0.112-0.1-0.089-0.128c0.019-0.019,0.069-0.035,0.236,0.02
						C28.979,9.319,28.558,9.321,28.552,9.324z M19.096,11.257c-0.117-0.009-0.419-0.04-0.752-0.242
						c-0.221-0.131-0.324-0.257-0.415-0.361c0.989,0.068,0.989,0.068,1.21,0.144C19.561,10.946,19.913,11.294,19.096,11.257z
						 M19.597,10.97c-0.013-0.034-0.036-0.098,0.092-0.139c0.217-0.068,0.931-0.005,1.198,0.312L19.597,10.97z"/>
					<path d="M1920.116,52.042V36.853c-0.545-0.085-1.064-0.178-1.729-0.297c-0.535,0.115-1.258,0.265-1.793,0.379
						c-0.723-0.052-1.691-0.12-2.42-0.172c0.322-0.333,1.277-0.758,2.26-1.022c0.715,0.04,1.682,0.092,2.4,0.132
						c-0.111-0.146-0.27-0.344-0.389-0.493c-3.264,0.021-6.414-0.276-9.707-0.176c-0.371-0.158-0.867-0.365-1.238-0.521
						c0.297-0.154,0.689-0.361,0.984-0.517c-0.637-0.298-2.199-0.626-3.543-0.758c-3.248-0.315-6.748-0.442-10.119-0.661
						c-0.201-0.166-0.471-0.391-0.672-0.554c1.502-0.187,3.482-0.442,4.949-0.641c-0.162-0.353,0.408-0.855,1.256-1.159
						c8.201,0.459,8.201,0.459,10.414,0.27c-7.391-1.034-7.391-1.034-7.715-1.351c-5.91,0.592-9.484-0.893-14.771-0.854
						c-0.098-0.012-10.719-0.851-18.705,0.074c-4.127-0.325-5.184-0.339-8.303-0.247c-0.945-0.319-2.934-0.987-8.832-0.977
						c-0.365,0.155-0.844,0.356-1.207,0.506c-2.967,0.632-7.361,0.505-10.529,1.028c0.301,0.169,0.695,0.396,0.99,0.563
						c-1.412,0.031-3.4-0.077-4.611-0.247c0.232,0.167,0.539,0.391,0.764,0.555c-5.381,0.468-11.068-0.095-16.486,0.249
						c-0.186,0.164-0.43,0.385-0.625,0.552c-0.537-0.114-1.256-0.267-1.783-0.382l-30.715-1.2c-1.875,0.732-1.875,0.732-6.215,1.025
						l-1.332-0.101c-3.592,0.037-7.143-0.245-10.746-0.061c0.096,0.166,0.242,0.385,0.352,0.551c-7.084,0.087-9.139,0.092-13.203-0.872
						c0.65,0.055,0.84-0.063,0.711-0.164c-0.068-0.074-0.246-0.089-0.305-0.095c-0.406-0.026-0.49,0.028-0.666,0.201
						c-1.564-0.383-3.42-0.891-5.986-1.608c-0.781,0.04-1.813,0.092-2.59,0.132c-0.217-0.077-0.506-0.181-0.713-0.261
						c0.404-0.141,0.936-0.324,1.338-0.463c-1.271,0.196-3.273,0.367-4.801,0.425c-0.842,0.578-3.322,0.864-4.689,1.351
						c-1.52,0.006-3.539-0.047-5.021-0.109c-0.193,0.172-0.457,0.41-0.652,0.586c-2.955,0.218-3.264,0.241-7.424-0.026
						c-1.053,0.222-2.84,0.434-4.23,0.502c-2.561,0.599-2.561,0.599-9.656,0.932c3.018,0.338,3.75,0.396,7.25,0.464
						c0.432,0.147,1,0.343,1.422,0.489c-7.646,0.391-15.674,0.152-23.217,0.709c0.141,0.175,0.33,0.405,0.471,0.577
						c-6.754-0.426-12.996-1.223-20.074-1.422c0.129-0.163,0.285-0.388,0.41-0.551c-3.279-0.715-8.51-0.497-11.717-1.246
						c-0.637,0.105-1.479,0.244-2.111,0.348c-0.705-0.099-1.65-0.23-2.357-0.327c-0.34,0.103-0.785,0.234-1.131,0.333
						c-5.834-0.394-11.957-0.204-17.875-0.438c0.381-0.201,0.885-0.471,1.264-0.671c-9.922-0.822-9.922-0.822-11.725-1.063
						c-0.52,0.118-1.203,0.275-1.715,0.396c-0.441-0.135-1.033-0.31-1.469-0.442c-0.143,0.33-0.943,0.77-1.865,1.028
						c4.727,0.333,10.303-0.178,14.43,0.744c-1.535,0.043-3.6,0.089-5.15,0.118c-0.199-0.041-0.475-0.093-0.684-0.133
						c-0.051,0-6.826,0.098-13.816-0.037c-2.527,0.164-5.094,0.021-7.639,0.046c-0.342,0.172-0.789,0.404-1.131,0.577
						c-0.365-0.152-0.85-0.354-1.211-0.506c-0.725,0.068-1.689,0.155-2.408,0.225c0.389,0.138,0.896,0.326,1.279,0.471
						c-0.756,0-1.752,0.012-2.504,0.018c-0.273-0.155-0.627-0.362-0.904-0.521c-1.469-0.092-3.418-0.221-4.875-0.318
						c-1.371,0.2-3.111,0.508-4.336,0.755c-0.178-0.065-0.412-0.154-0.576-0.221c0.41-0.144,0.977-0.337,1.395-0.479
						c-6.479-0.222-12.75-0.661-19.207-0.902c-0.379,0.086-0.875,0.201-1.252,0.287c-0.691-0.055-1.625-0.129-2.314-0.184
						c0.641-0.106,1.504-0.246,2.139-0.353c4.23,0.364,8.586,0.005,12.861,0.114c-0.014-0.175-0.025-0.408-0.041-0.58
						c1.072,0.235,2.887,0.466,4.32,0.563c0.141-0.361,0.35-0.844,0.533-1.205c0.609,0.105,1.41,0.246,2.025,0.353
						c-0.262,0.187-0.604,0.439-0.859,0.629c0.621-0.092,1.453-0.212,2.072-0.304c-0.4-0.158-0.938-0.368-1.34-0.526
						c0.504-0.131,1.172-0.307,1.68-0.439c-0.74,0.003-1.719,0.006-2.459,0.013c-0.475-0.124-1.113-0.293-1.59-0.42
						c0.096-0.181,0.219-0.426,0.314-0.609c-1.545,0.003-3.607-0.022-5.141-0.058c-0.33-0.16-0.785-0.372-1.121-0.534
						c1.605,0.041,3.736,0.099,5.342,0.146c-0.201-0.178-0.465-0.416-0.666-0.594c-0.785,0.031-1.822,0.069-2.598,0.101
						c-0.486-0.146-1.123-0.342-1.592-0.484c-2.945-0.023-2.945-0.023-9.662,0.647c1.516,0.035,3.537,0.066,5.059,0.081
						c0.205,0.126,0.477,0.293,0.676,0.419c-13.643,0.815-13.979,0.818-17.203,0.856c0.596,0.327,2.139,0.688,3.471,0.867
						c0.33,0.356,1.086,0.818,1.934,1.122c-0.461,0.003-1.084,0.007-1.543,0.01c-0.385-0.182-0.896-0.426-1.281-0.61
						c-0.824-0.025-1.92-0.057-2.744-0.083c0.545,0.118,1.271,0.273,1.814,0.388c0.182,0.092,0.424,0.219,0.607,0.313
						c-1.486,0.026-3.543-0.086-4.813-0.262c-0.123-0.166-0.295-0.385-0.416-0.554c-15.297-0.299-15.297-0.299-17.43-0.888
						c1.551-0.12,3.455-0.413,4.506-0.701c1.031,0.248,2.908,0.479,4.381,0.529c0.496-0.124,1.164-0.29,1.666-0.414
						c-0.346-0.16-0.793-0.375-1.135-0.54c-9.74,0.098-9.74,0.098-11.98-0.43c-0.08,0.108-0.184,0.255-0.27,0.361
						c-4.701-0.379-15.721-1.28-20.934-0.092c-0.277-0.161-0.646-0.374-0.924-0.531c-0.549,0.324-1.457,0.744-2.258,1.043
						c-4.623-0.228-7.252,0.798-11.328,0.916c-0.383,0.163-0.908,0.384-1.297,0.548c-0.697-0.081-1.627-0.184-2.316-0.265
						c0.068,0.179,0.164,0.42,0.236,0.604c-0.799-0.022-1.852-0.046-2.648-0.063c-0.324-0.152-0.762-0.356-1.084-0.511
						c-0.742-0.009-1.721-0.023-2.463-0.034c0.129,0.178,0.305,0.413,0.449,0.597c-1.164,0.032-1.164,0.032-6.432-0.45
						c0.082,0.169,0.193,0.393,0.283,0.56c-0.807-0.018-1.895-0.041-2.705-0.057c-0.217-0.168-0.496-0.388-0.695-0.553
						c-0.738-0.017-1.717-0.037-2.455-0.055c-0.35,0.146-0.818,0.34-1.166,0.486c-0.646-0.099-1.504-0.225-2.15-0.321
						c-0.736,0.097-1.729,0.235-2.461,0.332c-1.377-0.135-3.262-0.287-4.701-0.379c0.219,0.167,0.508,0.379,0.729,0.54
						c-1.479-0.129-3.34-0.385-4.498-0.632c-0.58,0.118-1.334,0.272-1.912,0.391c-0.682-0.068-0.682-0.068-0.932-0.126
						c0.084-0.012,0.201-0.029,0.281-0.043c-0.166-0.021-0.41-0.047-0.6-0.061c-1.867-0.098-3.961,0.342-5.68-0.12
						c-0.279,0.261-0.592,0.393-1.475,0.614c-1.174-0.104-2.086-0.342-3.451-0.356c-1.229-0.438-1.229-0.438-1.828-0.454
						c0.152,0.207,0.293,0.241,1.412,0.529c-1.633,0.218-2.676,0.608-4.49,0.77c-0.779,0.068-0.566-0.268-1.367-0.259
						c-0.33,0.333-1.971,0.448-2.43,0.758c-1.025-0.074-2.121,0.123-3.127-0.043c-0.031-0.003-3.09-0.555-3.986-1.131
						c-0.879-0.009-1.467-0.187-2.34-0.199c0.047-0.126-0.072-0.338,0.363-0.419c1.512,0.031,1.512,0.031,1.861-0.058
						c-0.227-0.511-3.182-0.184-4.324-0.482c-0.877,0.021-0.826,0.299-1.721,0.316c0.908,0.379,1.043,0.437,2.238,0.468
						c-0.174,0.311-2.014,0.287-2.266,0.58c-0.551-0.112-1.287-0.262-1.836-0.373c-0.783,0.043-0.594,0.295-1.4,0.33
						c0.975,0.227,0.699,0.557,1.34,0.815c-2.064,0.256-4.709,0.022-6.639,0.396c-0.35-0.132-1.32-0.084-1.494-0.268
						c-0.354,0.035-0.354,0.035-0.303,0.313c-0.168,0.022-0.373,0.052-0.916,0.012c-0.018-0.018-0.029-0.04-0.041-0.055
						c0.107-0.032,0.23-0.078,0.252-0.118c-0.229-0.017-0.459-0.023-0.699-0.023c-0.26,0.225-0.268,0.356-0.041,0.558l10.131,0.431
						c2.309,0.038,4.633,0.075,6.943,0.106c0.354-0.157,0.578-0.191,1.215-0.123l0.635,0.396l3.463,0.152l-3.496-0.152
						c0.021,0.006,0.039,0.013,0.057,0.018c-5.904,0.311-8.049,0.261-11.15-0.034c-0.135-0.08-0.305-0.189-0.434-0.276
						c0.809-0.031,1.916-0.068,2.744-0.086c-2.934-0.074-6.846-0.166-9.773-0.241c0.227,0.173,0.221,0.419,0.047,0.595
						c-2.449-0.031-2.449-0.031-3.742,0.232c-0.455-0.115-1.248-0.235-1.904-0.283c-1.479,0.317-2.83,0.422-6.932,0.186
						c-0.412,0.145-0.859,0.351-1.057,0.512c1.18,0.272,1.18,0.272,4.746,0.413c0.42-0.097,0.982-0.227,1.393-0.324
						c0.885,0.189,1.51,0.439,2.582,0.58c-0.084,0.373-0.084,0.373-1.91,0.767c0.402,0.351,1.613,0.646,1.344,1.039
						c-0.861,0.046-1.99,0.138-2.795,0.224c-2.395-0.221-2.395-0.221-4.207-0.258c-0.238,0.074-0.551,0.172-0.777,0.247
						c-1.314-0.04-2.475-0.213-3.82-0.235c-0.264,0.058-0.619,0.129-0.883,0.184c-1.309-0.063-2.666-0.04-3.971-0.104
						c0.152-0.262,0.152-0.262-0.438-0.977c3.08,0.023,3.08,0.023,3.371-0.002c-0.049-0.081-0.117-0.189-0.166-0.271
						c-2.336-0.089-2.336-0.089-3.271-0.293c-0.936,0.015-2.313-0.003-3.084-0.123c-0.092,0.025-0.197,0.049-0.342,0.063
						c-0.006,0-0.014,0-0.014,0c-0.055,0.003-0.104,0.006-0.156,0.006h-0.006h-0.01c0.139-0.051,0.318-0.077,0.527-0.068
						c-0.021-0.173-0.055-0.401-0.061-0.574c0.598,0.108,1.264,0.286,1.672,0.433c0.359-0.008,0.832-0.025,1.184-0.037
						c-0.352-0.138-0.646-0.351-0.67-0.505c1.447-0.204,3.145-0.235,4.721-0.351c0.275,0.063,0.646,0.149,0.922,0.212
						c0.201-0.063,0.459-0.149,0.664-0.212c0.637,0.058,1.59,0.077,2.273,0.052c-3.172-1.017-8.512,0.187-11.908-0.592
						c-1.143,0.015-2.297-0.04-3.42,0.044c-0.592-0.107-1.324-0.259-1.834-0.383c0.123-0.092,0.279-0.218,0.404-0.313
						c-0.309-0.042-0.713-0.103-1.02-0.148c-0.061,0.158-0.092,0.376-0.074,0.536c-0.455-0.113-0.799-0.327-0.762-0.481
						c-1.289-0.179-2.436-0.407-3.678-0.604c-0.203,0.161-0.533,0.367-0.828,0.517c-0.338-0.034-0.787-0.074-1.129-0.108
						c-0.094-0.152-0.541-0.348-1.039-0.453c-0.377,0.146-0.623,0.372-0.68,0.545c-0.449-0.167-0.857-0.419-1.035-0.612
						c-1.68,0.078-1.744,0.081-3.824-0.031c-0.324-0.144-0.568-0.354-0.578-0.514c-0.6,0.393-0.6,0.393-17.01-0.244
						c-0.508,0.138-1.203,0.313-1.732,0.442c-0.484-0.127-1.275-0.265-1.92-0.345c-0.516,0.109-1.074,0.293-1.371,0.437
						c-0.885-0.46-3.182-0.54-4.514-0.882c-3.494-0.014-3.494-0.014-4.066,0.003c2.033-0.598,2.033-0.598,3.191-0.715
						c0.252,0.063,0.594,0.146,0.84,0.209c0.365-0.149,1.037-0.327,1.592-0.445l-3.279-0.123l-0.023,0.109l-1.672-0.063l0.023-0.107
						c-28.301-0.984-28.951-0.933-30.52-0.807c0.873,0.469,0.873,0.469,5.135,0.561c0.383,0.17,0.953,0.393,1.418,0.558
						c-1.535,1.014-7.232,0.1-9.076,0.984c-1.604-0.241-4.031,0-5.26-0.46c-0.268,0.638,1.295,1.022,3.982,0.985
						c-0.17,0.083-0.396,0.192-0.574,0.272c-3.004,0.242-3.004,0.242-3.582,0.327c-0.578-0.103-1.473-0.2-2.168-0.25
						c-0.148,0.285,0.246,0.566,0.139,0.85c-0.836,0.029-1.924,0.165-2.428,0.319c-1.742-0.27-3.924-0.327-5.711-0.579
						c-4.678,0.299-4.678,0.299-5.893,0.235c-0.361-0.136-1.129-0.282-1.775-0.34c-0.295,0.145-0.471,0.364-0.4,0.521
						c-0.254-0.061-0.592-0.144-0.852-0.207l-1.127,0.21c-4.871-0.453-4.834-0.942-3.938-1.27c-0.799-0.098-0.799-0.098-4.775-0.224
						c-0.217-0.063-0.508-0.155-0.727-0.225c2.814-0.046,2.814-0.046,3.473-0.123c-0.225-0.071-0.518-0.163-0.744-0.236
						c-3.643-0.1-3.643-0.1-5.043-0.019c0.447,0.131,0.92,0.335,1.059,0.499c-1.373,0.111-2.873,0.146-4.146,0.321
						c0.422,0.132,0.91,0.316,1.197,0.456c3.102,0.104,2.844,0.914,5.006,1.215c1.512,0.21,3.297-0.022,4.83,0.152
						c-0.43,0.123-1.264,0.241-1.92,0.288c0.656,0.238,1.965,0.313,2.707,0.531c-0.281,0.058-0.674,0.132-0.965,0.188
						c-1.35-0.253-1.674-0.315-3.449-0.074c-1.154-0.074-2.387-0.057-3.531-0.138c-0.232,0.166-0.822,0.376-1.414,0.488
						c0.34,0.218,0.836,0.505,1.262,0.718c1.135,0.086,3.061,0.164,5.832,0.046c-0.043,0.195-0.318,0.459-0.658,0.643
						c-0.611-0.063-1.57-0.086-2.232-0.051c0.322,0.022,0.766,0.061,1.096,0.085c-2.256,0.265-5.191-0.092-7.193,0.408
						c-0.334-0.034-0.781-0.078-1.111-0.109c-0.117,0.078-0.291,0.182-0.41,0.259c-2.076-0.224-2.076-0.224-4.184-0.982
						c-2.984-0.126-6.033-0.149-9.02-0.275c-0.225,0.012-0.51,0.023-0.725,0.029c-1.172-0.218-1.172-0.218-4.463-0.196
						c-0.189,0.081-0.447,0.185-0.643,0.262c-2.918-0.666-2.918-0.666-5.203-0.548c-0.268-0.047-0.627-0.115-0.885-0.161
						c0.99-0.114,0.99-0.114,3.445-0.146c0.453-0.121,1.045-0.284,1.494-0.404c3.365,0.12,3.365,0.12,6.035,0.574
						c0.342-0.018,0.791-0.04,1.129-0.058c0.201,0.06,0.484,0.144,0.703,0.206c5.676-0.321,3.926-0.861,1.02-1.763
						c-3.066,0.167-3.303,0.16-5.469,0.052c-0.338-0.152-0.662-0.374-0.785-0.539c0.373-0.032,0.867-0.07,1.238-0.104
						c0.973,0.144,2.211,0.13,3.164,0.279c0.201-0.066,0.459-0.153,0.664-0.222c-0.688-0.08-1.51-0.224-2.076-0.344
						c-2.027,0.188-4.48-0.099-6.33,0.286c0.232,0.149,0.563,0.351,0.799,0.5c-2.143-0.265-4.051-0.615-6.152-0.898
						c-0.258-0.768,1.211-0.894,2.387-0.991c-0.867-0.46-0.49-0.597,0.732-0.939c0.383,0,0.891,0,1.277,0
						c1.879,0.571,1.879,0.571,4.094,0.624c0.092-0.108,0.209-0.253,0.305-0.362c0.941-0.034,2.158-0.144,2.969-0.256
						c0.059-0.077,0.117-0.187,0.166-0.266c0,0,0,0,0.012,0.005c-0.209-0.963-0.209-0.963-1.559-1.223
						c-0.303,0.057-0.705,0.129-1.01,0.184c-0.643-0.098-1.275-0.316-1.463-0.488c-0.857-0.072-0.857-0.072-3.43-0.729
						c-0.699,0.031-1.662,0.063-2.379,0.068c-0.453-1.039-0.438-1.108-0.205-1.524c0.691,0.037,1.627,0.083,2.328,0.106
						c0.207,0.068,0.479,0.166,0.693,0.235c0.18-0.072,0.43-0.173,0.611-0.244c-0.006,0-0.012,0-0.018,0
						c0.117-0.279-0.184-0.518-1.006-0.796c-1.299,0.118-2.652,0.238-4.162-0.005c-0.602-0.102-0.822-0.262-0.885-0.316
						c-0.25-0.179-0.119-0.362-0.26-0.546c-0.016-0.018-0.053-0.039-0.076-0.06c-0.523,0.071-1.166,0.163-1.488,0.433
						c-0.404,0.34-0.146,0.693-0.264,1.034l3.236,0.104c-1.111-0.036-2.246-0.07-3.205-0.099c-0.385,0.466-0.385,0.466-1.787,0.614
						c-0.33-0.13-1.078-0.27-1.717-0.318c-0.074,0.164-0.164,0.382-0.229,0.542c0.264,0.07,0.615,0.164,0.873,0.235
						c-0.365,0.078-0.842,0.182-1.203,0.265c0.227,0.058,0.525,0.139,0.754,0.201c-0.301,0.339-0.744,0.666-0.965,1.005
						c0,0.006,0.854,1.896,1.014,2.516c0.676,0.074,1.486,0.219,1.979,0.348c0.354-0.02,0.828-0.052,1.178-0.071
						c0.297,0.039,0.68,0.097,0.967,0.141c-0.129,0.077-0.309,0.187-0.447,0.261c-2.02,0.052-2.02,0.052-4.139-0.017
						c-0.174-0.075-0.408-0.173-0.582-0.247c0.361-0.015,0.842-0.038,1.203-0.052c-0.561-0.109-1.49-0.21-2.223-0.241
						c-1.166-1.517,0.695-3.096-1.908-4.584c-0.332,0.142-0.975,0.312-1.557,0.403c0.082,0.092,0.189,0.212,0.271,0.304
						c-0.271,0.052-0.625,0.121-0.885,0.173c-0.453-0.54-0.482-0.547-2.25-0.765c-0.039-0.04-0.072-0.098-0.107-0.141
						c-0.178,0.354-0.178,0.354,0.471,0.882l-1.578,3.133c-0.592,0.095-1.273,0.255-1.65,0.394c-0.35-0.006-0.814-0.009-1.17-0.018
						c0.086,0.093,0.178,0.213,0.252,0.305c5.066,0.462-0.119,1.814,2.955,2.533c0.402-0.021,0.939-0.044,1.338-0.064
						c0.865-0.912,0.795-1.211,0.682-1.754c2.719,0.182,2.719,0.182,8.297-0.025c0.021,0.166-0.035,0.391-0.156,0.554
						c0.693,0.038,1.594,0.106,2.254,0.164c-0.277,0.063-0.635,0.149-0.908,0.212c-1.852-0.293-2.096-0.332-7.965,0.305
						c-0.215,0.178-0.197,0.437-0.043,0.617c1.941,0.138,2.033,0.291,2.18,0.566c-0.783,0.011-1.848,0.011-2.623-0.006
						c-1.344,0.37-1.344,0.37-4.229,0.441c-0.658,0.311-0.658,0.311-0.83,0.856c0.355,1.332,0.355,1.332-2.074,1.406
						c-0.807-0.938-0.656-1.31-0.598-1.487c0.352-0.339,0.438-0.428,1.518-0.35c-0.141-0.259-1.379-0.414-1.227-0.695
						c0.043-0.077,0.389-0.111,0.477-0.182c0.219-0.146,0.254-0.301,0.408-0.45c0.293-0.281,1.264-0.351,1.271-0.351
						c-0.363-0.321-1.719-0.49-2.365-0.769c-0.049-0.044-0.115-0.104-0.154-0.146c-2.977,0.221-0.023,1.082-2.57,1.386l-0.055,1.482
						c0.018,0.694,0.049,1.628,0.064,2.329c0.346,0.017,0.793,0.037,1.133,0.055c0.379,0.474,0.379,0.474-1.25,0.993l0.006,0.361
						c-0.27-0.229-0.697-0.43-1.41-0.579c0.275-0.265,0.275-0.265-0.492-0.728c0.541-0.055,1.314-0.1,1.902-0.105l0.047-2.326
						c-21.717-0.54-48.926-1.212-73.258-1.81c1.242,0.34,3.857,1.189,3.879,1.197c0.59,0.21,0.541,0.282,0.455,0.422
						c0.924-0.017,1.148,0.268,2.066,0.254c0.084,0.259,1.045,0.484,0.523,0.76c-1.775-0.1-2.484-0.234-3.986-0.755
						c-0.428-0.144-0.945-0.324-1.605-0.453c-0.117-0.023-0.283-0.052-0.406-0.075c0.041-0.218,0.037-0.258-0.486-0.488
						c-0.16-0.065-0.535-0.223-0.496-0.333c0.01-0.043,0.135-0.109,0.051-0.151c-0.279-0.146-0.947-0.23-1.211-0.377
						c-0.014-0.011,0-0.02,0.002-0.031c-7.139-0.176-14.057-0.347-20.451-0.503c0.672,0.356,0.756,0.359,2.104,0.435
						c0.055,0.055,0.055,0.055,4.016,1.708c-2.016-0.052-2.271-0.58-3.891-0.738c0.119-0.058,0.281-0.135,0.412-0.192
						c-0.447-0.021-1.047-0.046-1.496-0.068c-1.238-0.442-2.205-0.916-3.371-1.367c-20.393-0.45-47.578-1.051-67.971-1.501
						c-0.113,0.65-0.527,2.833-1.201,3.49c-0.381,0.021-0.885,0.047-1.266,0.067c-1.041,0.901-1.041,0.901-2.732,1.082
						c-1.031-0.474-1.533-0.996-2.438-1.479c0.031-0.063,0.092-0.149,0.141-0.212c-0.189-0.048-0.438-0.115-0.615-0.163
						c0.623-0.904,0.684-1.482,0.309-2.944c-0.881-0.017-2.051-0.04-2.928-0.058c0.012,0.526,0.012,0.526-2.107,2.481
						c0.221,0.044,0.529,0.104,0.756,0.144l-0.744,0.374l0.465,0.286c-2.787,1.281,4.615,3.002-2.539,4.032
						c0.4,0.093,0.934,0.213,1.34,0.298c-2.367,1.316-1.6,2.105-1.316,2.404c19.498,0.37,42.885,0.881,65.465,1.387
						c-22.566-0.471-45.953-0.931-65.414-1.337c0.125,0.129,0.041,0.313-0.133,0.436c-0.566,0.034-1.299,0.097-1.811,0.157
						c-0.148,0.146-0.537,0.343-0.955,0.46c0.1,0.077,0.229,0.184,0.324,0.259c-0.52,0.061-1.086,0.192-1.391,0.305
						c-0.535-0.052-1.26-0.106-1.809-0.144c2.09,0.629-0.832,1.215-1.775,1.381c-0.26-0.023-0.605-0.055-0.873-0.077
						c-0.246,0.025-0.584,0.061-0.838,0.089c0.184,0.379,0.184,0.379-1.613,1.32c-2.439-0.345-2.439-0.345-0.26-2.158
						c0.342,0.021,0.799,0.056,1.154,0.082c-0.064-0.065-0.141-0.152-0.201-0.215c-0.295,0.011-0.688,0.028-0.99,0.04
						c0.119-0.077,0.285-0.185,0.402-0.258c1.158-0.121,2.453-0.162,3.547-0.316c-0.281-0.029-0.67-0.068-0.953-0.098
						c-0.52,0.049-1.295,0.063-1.846,0.04c0.107-0.058,0.242-0.138,0.344-0.192c-1.045-0.319-2.33-0.712-0.75-1.352
						c0.018-0.196-0.896-0.285-1.025-0.466c-0.16-0.218,0.438-0.425,0.23-0.649c-0.041-0.043-0.252-0.092-0.359-0.132
						c-0.654-0.241-1.086-0.58,0.578-0.81c-0.168-0.454-0.191-0.523,0.662-0.552c-0.025-0.17-1.039-0.218-0.898-0.401
						c0.135-0.179,0.354-0.222,1.557-0.448c-0.939-0.477-0.652-1.061-2.475-1.456c-0.084,0.364-1.344,2.13-1.355,2.146
						c-0.061,0.068-0.408,0.132-0.639,0.178c0.09,0.229,0.521,0.287,1.379,0.407c-2.816,0.661-0.816,0.876-0.152,0.948
						c-0.367,0.089-0.99,0.065-1.344,0.157c-0.459-0.071-0.381-0.197-0.555-0.299c-0.207-0.008-0.486-0.008-0.684-0.003
						c-0.111,0.265,1.189,0.429,0.941,0.701c-0.227,0.241-1.438,0.247-1.975,0.414c-0.275-0.133-2.633-1.31,0.434-1.597
						c-1.227-0.294-0.438-2.872,0.506-3.116c-0.934-0.301-1.557-0.445-2.703-0.617c0.205-0.356,0.205-0.356-0.91-0.738
						c1.225-0.152,1.225-0.152,1.078-0.308c-0.389-0.036-0.906-0.08-1.297-0.12c0.564-0.152,0.32-0.37,0.785-0.534
						c0.111-0.003,0.264-0.008,0.369-0.011c-1.744-0.311-1.744-0.311-2.316-0.592c-0.795,0.103-1.43,0.023-2.115-0.265
						c0.383-0.021,0.889-0.052,1.273-0.068c-0.717-0.713,1.137-1.373,0.873-2.074c-1.154-0.017-2.699-0.04-3.861-0.055
						c-0.066,0.018-0.158,0.038-0.229,0.055c-0.215-0.014-0.479-0.051-0.637-0.089c-0.012-0.003-0.721-1.156-0.689-1.357
						c0.021-0.179,0.523-0.322,0.67-0.489c0.525-0.585-0.611-1.15-0.336-1.728c0.061-0.153,0.557-0.327,0.908-0.457
						c-0.484-0.417-0.484-0.417-0.961-0.503c0.855-0.545,0.879-0.775,0.723-1.303c-0.15-0.495,0.107-0.54,0.779-0.604
						c-0.611-0.138-0.611-0.138-0.094-0.678c-0.277-0.092-0.646-0.207-0.92-0.299c0.873-0.778,0.934-1.292,0.969-2.809
						c0.002,0,0.008,0,0.008,0c0.049-0.971,0.049-0.971,0.648-2.113c-0.906,0-0.619-0.265-1.289-0.327
						c0.303-0.293,0.678-0.66-0.689-1.344c-0.094-0.04-0.223-0.092-0.318-0.127c-1.631,0.448-1.932,0.532-2.369,0.781
						c-0.416,0.235,0.119,0.488-0.156,0.724c-0.211,0.178-1.047,0.275-1.221,0.46c-0.035,0.034,0.07,0.074,0.1,0.108
						c0.016,0.018,1.148,1.394-2.117,1.603c0.023,0.003,0.051,0.009,0.068,0.012c0.139,0.028,0.275,0.058,0.381,0.092
						c0.154,0.003,0.33,0.007,0.494,0.01c-0.174-0.003-0.361-0.007-0.525-0.01c0.736,0.281-0.73,0.437-0.742,0.678
						c-0.012,0.154,0.701,0.341,0.678,0.5c-0.01,0.065-0.1,0.154-0.146,0.221c-0.877,1.148-1.496,1.194-1.785,1.218
						c-0.744,0.055-0.803,0.078-0.66,0.256c-0.129-0.021-0.129-0.021-0.918-0.402c-0.123-0.003-0.297-0.012-0.426-0.018
						c-0.059-0.278,1.656-0.437,0.998-0.752c-1.148-0.046-2.338-0.087-4.377,0.481c-0.654,0.188,1.049,0.254,1.08,0.442
						c-0.082,0.013-0.184,0.026-0.262,0.035c-0.045,0.006-0.082,0.012-0.246,0.022c-1.314,0.029-1.709-0.258-2.064-0.6
						c-1.424-0.021-2.557-0.244-3.961-0.278c-0.582,0.35-0.6,0.729-1.24,1.076c-0.586,0.313-0.775,0.336-1.541,0.428
						c0.492,0.351-0.26,0.692-0.098,1.04c0.037,0.109,0.674,0.224,0.723,0.333c0.012,0.034,0.006,0.081,0.012,0.115
						c-0.012,0.075-0.402,0.138-0.682,0.186c-0.65,0.11-0.613,0.173-0.514,0.352c-1.072-0.05-1.963-0.207-3.037-0.259
						c-0.27-0.821,0.543-1.634,0.428-2.455c-0.049-0.37-0.951-0.7-0.934-1.074c0.012-0.195,0.164-0.224,0.719-0.339
						c-0.836-0.098-1.861-0.098-2.627-0.235c-0.072,0.023-0.201,0.052-0.232,0.081c-0.383,0.327,0.338,0.653-0.021,0.98
						c-0.26,0.23-1.42,0.322-1.668,0.553c-0.049,0.036-0.096,0.089-0.129,0.129c-0.072,0.077,0.068,0.186,0.164,0.267
						c-2.063,0.718-3.186,1.54-4.822,2.303c-0.213,0.096-0.666,0.204-0.789,0.311c-0.281,0.224,1.076,0.29,0.979,0.499
						c-0.273,0.575-2.223,1.086-1.369,1.712c-1.391,0.592-1.008,1.295-2.369,1.89c-0.555,0.157-0.738,0.184-1.488,0.253
						c0.016,0.034,0.025,0.08,0.043,0.114c0.373,0.069,0.373,0.069,1.295,0.096c-0.307,0.35-0.445,0.45-1.596,0.456
						c1.014,0.401,1.014,0.401-0.959,1.315c-0.707,0.333,0.396,0.644,0.252,0.965c-0.063,0.141-0.309,0.321-0.506,0.457
						c-0.424,0.302-1.102,0.582-1.455,0.889c-0.168,0.159,0.207,0.4-0.164,0.537c-0.945,0.354-2.713,0.461-4.051,0.693
						c0.07,0.101,0.154,0.231,0.221,0.33c-0.238,0.029-0.541,0.068-0.762,0.103l1.201,3.819c-37.133-0.568-75.148,2.292-111.468-1.473
						c0.224-0.411,0.224-0.411-0.171-0.542c1.508,0.097,1.726,0.16,1.94,0.565c32.924,0.387,76.793,1.013,109.699,1.449
						c-0.414-1.137-0.959-2.659-1.379-3.796c-0.477,0.04-1.154,0.071-1.662,0.074c-0.08-0.04-0.184-0.092-0.252-0.132
						c2.83-0.398-0.098-1.103,1.633-1.556c0-0.006,0.006-0.006,0.012-0.006c0.209-0.069,0.191-0.13-0.055-0.219l-0.025-0.006
						l-0.023-0.074c-0.344-1.031-0.803-2.406-1.154-3.44c-0.18,0.028-0.432,0.063-0.611,0.092c0.637,0.305,0.549,0.339-0.059,0.552
						c-1.061-0.161-1.834-0.414-3.111-0.511c-0.096,0.333-1.014,0.643-0.633,0.995c0.281,0.032,0.672,0.075,0.957,0.107
						c0.221-0.023,0.516-0.053,0.734-0.081c0.336,0.052,0.689,0.155,0.795,0.241c-0.178,0.026-0.424,0.061-0.607,0.086
						c-0.76-0.063-1.482-0.149-2.242-0.218c-0.143,0.224-0.572,0.431-0.699,0.655c-2.357,0.082-2.357,0.082-3.01,0.137
						c0.658,0.397,0.658,0.397,0.008,0.626c-0.473-0.005-1.104-0.034-1.547-0.074c0.59,0.522,0.596,0.534-0.252,0.771
						c-0.242-0.053-0.561-0.115-0.803-0.167c0.285-0.081,0.762-0.165,1.156-0.216c-3.1-0.83,0.004-1.74-0.703-2.599
						c-2.154-0.222-2.381-0.245-3.923-0.253c-1.023,0.721-1.818,1.453-2.7,2.177c-2.49-0.105-2.49-0.105-2.717-0.086
						c0.299,0.104,0.646,0.24,0.873,0.35c-0.16,0.035-0.339,0.093-0.528,0.115c-2.488,0.302-3.665,0.046-3.519-0.772
						c0.348-0.06,0.845-0.129,1.244-0.167l-0.459-0.191c2.262-0.713,1.898-2.927,1.886-2.947c-4.223-0.022-9.866-0.052-14.096-0.073
						c-0.241,0.086-0.707,0.184-1.118,0.223c-0.252,0.609-0.252,0.609-1.903,1.706c-0.012,0-1.108-0.598-1.672-1.125
						c0.216-0.015,0.517-0.031,0.741-0.044c-1.66-0.163-1.66-0.163-2.476-0.163c0.023,0.098,0.164,0.227,0.342,0.315
						c-1.792,0.155-2.298,0.408-2.254,1.123c-0.368,0.055-0.858,0.129-1.224,0.187c0.253,0.46-1.792,0.839-0.953,1.32
						c-0.953,0.173-1.8,0.38-2.809,0.537c-0.505-0.06-1.355-0.163-1.333-0.499c0.086-1.307,1.77-2.596,0.982-3.917
						c-1.117-0.009-2.602-0.025-3.704-0.049h-0.069c-0.474-0.008-1.12,0.012-1.557,0.053c0.942,0.412,1.02,0.47,0.236,0.786
						c-1.861-0.17-2.194-0.385-2.789-0.896c-0.56-0.485-1.019-0.621-2.432-0.724c0.641-0.679-1.618-1.173-2.189-1.77
						c-0.182-0.195,0.09-0.391-0.154-0.586c-0.277-0.225-1.179-0.373-1.442-0.6c-0.313-0.262,0.083-0.531-0.2-0.79
						c-0.146-0.138-0.685-0.221-0.907-0.347c-0.75-0.424-0.042-0.908-0.974-1.327c-0.254-0.113-1.15-0.187-1.255-0.311
						c-0.129-0.141,0.589-0.146,0.771-0.241c0.013-0.003-0.494-1.002-1.738-1.474c-0.224-0.048-0.531-0.111-0.755-0.16
						c-0.437,0.775,1.314,1.476,1.486,2.237c0.052,0.272-0.979,0.487-0.844,0.767c0.07,0.152,0.879,0.195,0.974,0.339
						c-0.584,0.149-0.719,0.184-0.755,0.367c0.165,0.092,0.579,0.207,0.555,0.304c-0.048,0.162-0.625,0.274-0.754,0.426
						c-0.495,0.643,1.532,1.154,1.756,1.761c0.06,0.154,0.06,0.154-0.631,0.657c-0.229,0.166,0.507,0.272,0.513,0.425
						c0.011,0.144-0.872,0.166-0.801,0.315c0.083,0.195,1.208,0.279,1.025,0.5l-0.484,0.104c-0.129,0.017-0.306,0.043-0.437,0.066
						c-0.199-0.026-0.458-0.058-0.659-0.084c-2.971-0.011-6.933-0.023-9.902-0.034c-0.531,0.448-0.531,0.448,0.01,0.676
						c-0.376,0.054-0.871,0.12-1.249,0.174c0.459,0.139,1.061,0.253,1.425,0.405c-1.513,1.152-0.448,2.421-3.159,3.521
						c-1.756-0.264-1.756-0.264-2.21-0.31c1.149-1.152-1.003-2.33,0.537-3.473c-1.15-0.351-0.685-0.786-1.286-1.16
						c-3.195-0.031-7.451-0.068-10.644-0.092c-0.573,0.213-0.573,0.213,0.465,0.861c-0.218,0.019-0.512,0.034-0.736,0.053
						c-0.919-0.213-0.974-0.225-1.192-0.978c-0.636,0.023-1.483,0.053-2.121,0.075c-0.495,0.362-0.495,0.362-1.179,0.549
						c-0.484-0.265-0.755-0.411-2.748-0.618c0.296,0.127,0.685,0.291,0.979,0.414c-0.389,0.154-1.055,0.246-1.602,0.364
						c0.153,0.549-0.402,1.095-0.249,1.64c-0.655-0.071-0.655-0.071-2.865-0.521c-0.194,0.016-0.448,0.034-0.636,0.052
						c0.035,0.372-1.461,0.626-1.509,0.99c-0.042,0.336,1.378,0.565,1.273,0.904c-0.013,0.058-0.283,0.12-0.402,0.173
						c-0.364-0.053-0.824-0.124-1.167-0.185c-0.181,0.02-0.435,0.046-0.623,0.063c2.287,0.571-0.178,1.347,1.626,1.938
						c-1.993,0.887-0.249,1.854-1.108,2.765c-0.884-0.045-1.538-0.227-2.517-0.218c0.006-0.589,1.397-1.116,1.421-1.706
						c0.01-0.385-1.245-0.691-1.311-1.073l0.249-0.385l0.755-0.288c-2.724-0.804,0.766-2.084-4.062-2.73
						c0.808-0.152,0.913-0.201,0.63-0.681c-1.615-0.178-1.615-0.178-2.352-0.146c-0.334,0.164-0.583,0.33-0.826,0.5
						c-1.13-0.055-1.13-0.055-5.25-2.183c-0.915,0.026-2.133,0.052-3.054,0.071c0.707,0.673-0.909,1.342-0.013,2.011
						c-0.365,0.052-0.847,0.121-1.208,0.179c0.017,0.014,1.503,1.918-0.607,2.688c1.621,1.091,1.162,1.315-1.061,1.441
						c0.005,0.181,0.005,0.181,1.014,0.49c-0.354,0.133-0.354,0.133,0.96,1.255c-0.458,0.035-1.065,0.081-1.532,0.115
						c0.313,0.072,0.831,0.149,1.262,0.172c-4.603,0.322-4.603,0.322-3.908,0.689c0.89,0.031,0.926,0.034,2.039-0.134
						c0,0.065,0,0.157,0,0.226c-0.471,0.049-1.037,0.139-1.407,0.222c0.229,0.037,0.534,0.089,0.758,0.129
						c0.326-0.068,0.674-0.181,0.826-0.27c1.097,0.105,1.875,0.634,1.781,0.85c-0.49,0.009-1.142,0.028-1.631,0.051l-0.88-0.01
						c-0.754,0.045-1.768,0.103-2.529,0.149c0.03,0.086,0.076,0.2,0.114,0.289c-0.372,0.038-0.862,0.083-1.234,0.124
						c-0.489-0.17-0.983-0.419-1.137-0.617c-21.62-0.21-50.442-0.492-72.056-0.699c0.355,0.17,0.667,0.414,0.773,0.604
						c-0.354,0.051-0.839,0.117-1.198,0.169c-0.559-0.365-0.689-0.48-0.737-0.89c-0.918-0.01-2.127-0.021-3.039-0.033
						c-1.004,0.521,3.051,3.748,4.785,5.124c-0.178,0.086-0.408,0.201-0.584,0.287l-6.389-2.878c-2.775-2.085-2.775-2.085-5.665-2.016
						c0.578,0.948-2.057,1.897,0.048,2.841c0.376-0.012,0.867-0.032,1.238-0.043c-0.283-0.173-0.549-0.414-0.696-0.598
						c0.354,0.022,0.825,0.051,1.186,0.074c0.594,0.382,5.777,3.772,4.951,4.741c-0.148,0.163,0.69,0.37,1.268,0.477
						c-0.685,0.049-1.722,0.037-2.394-0.021c-0.059-0.341-0.607-2.096-4.973-3.195c-0.078,0.198-0.09,0.468-0.06,0.675
						c-0.367-0.034-0.85-0.072-1.215-0.104c-1.385-0.982-2.499-1.991-3.973-2.969c0.188-0.07,0.448-0.167,0.636-0.236
						c-1.119-0.631-1.119-0.631-2.375-0.814c0.042,0.11,0.094,0.258,0.135,0.367c-0.271,0.06-0.63,0.137-0.896,0.191
						c-1.196-0.175-1.638-0.238-1.531-0.758c-0.365-0.021-0.849-0.046-1.215-0.065c0.731-0.592-0.99-1.275-1.013-1.281
						c-0.966,0.032-2.251,0.074-3.219,0.106c0.019,0.015,1.475,1.604,0.389,2.182c0.525,0.201,0.525,0.201,1.019,3.449
						c1.9,0.228,2.895,0.401,0.691,0.972c0.178,0.079,0.424,0.184,0.602,0.263c-1.733,0.604,0.313,1.327-1.19,1.941
						c-0.013-0.006-1.934-1.261-2.835-1.892c-0.79-0.084-1.757-0.25-2.311-0.405c-0.242,0.158-0.711,0.358-1.15,0.494
						c0.36,0.061,0.832,0.138,1.185,0.194c0.065,0.09,0.148,0.214,0.218,0.303c0.294,0.045,0.697,0.105,1.002,0.152
						c-0.607,0.117-1.438,0.264-2.085,0.37c-0.826-0.417-0.808-0.445-0.578-0.842c-0.696-0.063-1.609-0.154-2.269-0.235
						c1.749,2.059,1.749,2.059,1.031,2.279c-1.308-0.197-1.993-0.593-3.849-0.613c0.254,0.406-0.488,0.807-0.219,1.218l23.141,0.238
						c0.046-0.121,0.718-0.248,1.209-0.293c0.135,0.094,0.312,0.215,0.447,0.307c2.446,0,5.711-0.003,8.152-0.006
						c-0.078-0.188-0.19-0.439-0.283-0.629c0.317-0.06,0.743-0.141,1.066-0.198c1.491,0.311,1.793,0.408,2.27,0.953
						c1.325,0.013,3.1,0.032,4.426,0.047c0.006-0.086,0.03-0.196,0.042-0.276c0.377,0.004,0.879,0.012,1.262,0.015
						c0.188,0.086,0.435,0.198,0.623,0.278c49.137,0.521,67.397,0.712,105.542,1.184c-29.599-0.343-63.847-0.721-105.571-1.181
						c2.381,1.576,3.472,3.225,5.429,4.821c-3.301-0.798-7.333-4.81-7.344-4.841c-2.223,0.086-5.188,0.373-6.756,0.74
						c-0.199-0.247-0.482-0.574-0.695-0.821l-9.819-0.1c-2.621,0.014-5.653,0.085-8.774,0.146c0.083,0.027,0.186,0.051,0.24,0.079
						c0.123,0.075-0.059,0.127-0.166,0.155l-1.203-0.014c-0.07-0.071-0.124-0.136-0.158-0.199c-5.966,0.104-12.137,0.128-16.434-0.442
						c-0.547-0.258-1.103-0.511-1.714-0.763c0.118,0.003,0.271,0.003,0.382,0.006c0.502-0.273-1.014-0.684,0.619-0.85
						c-0.961-0.374-0.948-0.856-2.545-1.16c0,0-0.485-0.063-1.032,0.146c-0.279,0.103-0.465,0.149-1.102,0.126
						c1.02,0.318,1.308,0.508,0.942,0.962c-0.319,0.39-0.319,0.487-0.046,0.743c-0.92,0.04-1.676-0.095-2.535-0.12
						c0.229-0.144,0.825-0.244,0.943-0.401c0.064-0.09-0.296-0.274-0.402-0.331c-0.069-0.029-0.141-0.052-0.213-0.074
						c-1.071-0.316-1.071-0.316-1.283-0.425c-0.177-0.013-0.537-0.029-0.684,0.082c-0.154,0.112-0.26,0.161-1.109,0.084
						c-0.07-0.04-0.159-0.104-0.129-0.146c0.218-0.043,0.518-0.043,0.731-0.083c0.023-0.046-0.059-0.106-0.129-0.149
						c-0.915-0.063-1.292-0.144-1.851-0.483c-0.049-0.028-0.107-0.071-0.153-0.103c-0.16,0.023-0.308,0.049-0.448,0.074
						c-0.884,0.259-0.436,0.58-0.867,0.861c-0.684-0.137-1.232-0.246-2.411-0.712c-0.795-0.31-0.795-0.31-1.308-0.281
						c-0.183,0.078,0.022,0.155,0.005,0.23c-0.005,0.005-0.59,0.327-2.033-0.466c-0.459-0.247-0.602-0.275-1.203-0.399
						c-0.211-0.018-0.482-0.04-0.689-0.055c-0.425,1.326-0.524,1.643,0.985,2.379l-0.089,0.367l-0.679,0.175
						c0.203,0.089,0.473,0.207,0.673,0.296c-0.47,0.126-1.482,0.061-1.743,0.258l-1.309-0.014c-1.332,0.081-3.113,0.187-4.445,0.265
						c4.338,4.238,4.303,4.255,2.417,5.137c-2.163-0.861-2.369-0.979-3.984-1.901c-0.012-0.009-0.034-0.017-0.247-0.123
						c-1.108-0.374-1.108-0.374-3.113-1.858l-1-0.77l-1.799-0.872c-0.07-0.196-0.165-0.461-0.241-0.655
						c-0.695,0.103-1.626,0.235-2.321,0.342c-0.213-0.173-0.49-0.399-0.708-0.571l-0.142-0.265L652,29.365
						c-6.448,0.304-10.001-0.299-18.589-1.764l-4.267-0.313c-0.053-0.072-0.118-0.17-0.172-0.242
						c-26.275-2.868-26.275-2.868-59.554-4.045c-43.545-4.278-48.154-3.228-50.631-2.665c-1.296-0.178-2.675-0.568-3.147-0.893
						c-24.914-1.658-51.284-0.808-76.292-2.289c-15.571-0.109-15.571-0.109-17.53,0.459c-0.448-0.149-1.049-0.342-1.498-0.488
						c-5.41-0.157-5.41-0.157-7.933-0.063c-0.248,0.379-1.108,0.861-2.02,1.183c-9.91-2.526-45.321-1.528-49.86-0.454
						c-0.766-0.068-1.803-0.166-2.582-0.238c0.112-0.197,0.249-0.459,0.354-0.657c-1.791,0.092-1.791,0.092-8.481-0.046
						c-0.891,0.305-1.445,0.813-1.362,1.177c-0.859,0.092-2.004,0.213-2.864,0.305c-0.625-0.117-1.452-0.272-2.075-0.391
						c0.623-0.149,1.462-0.347,2.086-0.499c-0.165-0.184-0.383-0.431-0.554-0.617c-1.898,0.022-1.898,0.022-54.673-0.438
						c-0.389,0.176-0.902,0.405-1.285,0.578c2.688,0.574,6.625,0.485,9.561,0.933c-0.613,0.146-1.438,0.342-2.058,0.485
						c-11.913-0.511-11.913-0.511-14.429-0.506c-0.429-0.154-0.995-0.355-1.426-0.511c0.701-0.117,1.633-0.27,2.334-0.388
						c-0.258-0.175-0.607-0.411-0.859-0.585c-13.946-0.561-28.428,0.261-42.174-0.827c0.083,0.191,0.201,0.456,0.277,0.646
						c-0.76,0.049-1.781,0.109-2.541,0.155c1.622,0.163,3.514,0.517,4.658,0.821c-0.472,0.17-1.098,0.396-1.562,0.563
						c-1.716-0.333-1.716-0.333-7.739-0.666c0.141-0.195,0.323-0.454,0.464-0.648c-3.577-1.121-3.577-1.121-16.154-1.367
						c-0.601,0.123-1.397,0.287-1.999,0.413c-4.734-0.077-8.6-0.735-13.067-0.993c-0.66,0.132-1.539,0.305-2.198,0.431
						c-6.277-0.281-12.702-0.367-18.885-0.764c0.046-0.092,0.112-0.213,0.152-0.305c-1.433,0.146-3.736,0.158-5.251,0.063
						c-0.16,0.38,0.217,0.905,0.862,1.259c-0.85,0.009-1.976,0.022-2.819,0.034c0.354,0.16,0.826,0.379,1.179,0.54
						c-0.807,0.058-1.875,0.132-2.683,0.187c7.635,0.726,7.635,0.726,13.361,2.223c-0.647,0.132-1.509,0.308-2.156,0.445
						c-0.083-0.015-9.348-1.172-16.416-0.586c1.486,0.154,3.132,0.54,3.878,0.873c-0.076-0.009-8.516-0.938-14.422-1.447
						c-0.354,0.16-0.82,0.373-1.167,0.534c0.777-0.052,1.815-0.12,2.593-0.173c-0.005,0.179-0.012,0.423-0.024,0.601
						c-1.709-0.044-3.966-0.152-5.611-0.268c-0.625-0.333-2.027-0.74-3.371-0.933c-0.177,0.181-0.413,0.422-0.589,0.603
						c-5.118-0.783-5.118-0.783-7.08-0.807c-0.478,0.166-1.126,0.385-1.597,0.551c2.204,0.741,6.371,0.62,9.218,1.081
						c-0.094,0.194-0.207,0.453-0.301,0.647c-1.598-0.063-3.731-0.154-5.333-0.223c0.129,0.35-0.178,0.838-0.731,1.165
						c1.437,0.138,3.083,0.482,3.901,0.781c-0.666,0.103-1.556,0.244-2.215,0.344c-3.159-0.263-6.247-0.573-9.4-0.844
						c-0.602,0.123-1.404,0.288-2.012,0.405c5.923,0.333,5.923,0.333,7.633,0.588c-0.612,0.156-1.432,0.363-2.051,0.518
						c-1.431-0.212-3.449-0.463-5.003-0.626c-1.403-0.172-3.396-0.345-4.916-0.453c-0.932-1.472-0.932-1.472-2.063-1.815
						c0.695-0.101,1.615-0.235,2.31-0.333c-2.486-0.89-7.185-0.977-10.673-1.502c0.347-0.187,0.813-0.431,1.16-0.617
						c2.676,0.284,4.445,0.876,7.315,1.085c0.184-0.191,0.423-0.447,0.602-0.644c0.748,0.089,1.75,0.207,2.492,0.293
						c0.224,0.198,0.513,0.466,0.731,0.664c-0.577,0.124-1.344,0.284-1.921,0.41c0.813,0.023,1.887,0.063,2.693,0.086
						c0.336,0.162,0.795,0.38,1.137,0.543c0.778,0.046,1.822,0.106,2.606,0.155c-0.778-0.124-1.815-0.29-2.594-0.413
						c1.127-1.071,1.127-1.071,5.907-1.982c-0.814-0.313-1.437-0.795-1.515-1.16c3.172,0.254,3.826,0.303,8.305,0.038
						c0.325-0.184,0.755-0.426,1.078-0.603c-1.467-0.178-3.024-0.586-3.73-0.929c0.689-0.089,1.614-0.209,2.304-0.301
						c-0.235-0.192-0.548-0.445-0.785-0.632c-1.59-0.061-3.843-0.017-5.344,0.115c0.712,0.092,1.656,0.212,2.363,0.304
						c-0.626,0.319-2.228,0.687-3.666,0.816c0.129,0.143,0.294,0.333,0.423,0.479c-1.503-0.112-1.503-0.112-8.293-0.282
						c1.42,0.247,3.388,0.558,4.926,0.762c-0.07,0.181-0.169,0.419-0.246,0.597c-0.731,0.058-1.704,0.132-2.435,0.189
						c0.471,0.189,1.09,0.442,1.562,0.626c-2.517-0.083-5.123-0.172-11.664-0.746c0.129-0.351-0.408-0.844-1.308-1.132
						c-0.814,0.047-1.899,0.109-2.701,0.158c0.313,0.164,0.731,0.382,1.05,0.543c-0.767-0.041-1.792-0.098-2.558-0.141l2.257,2.423
						h-0.036c0.524,0.342,1.221,0.796,1.75,1.135c0.814,0.018,1.91,0.043,2.724,0.063c0,0.195,0,0.453,0,0.654
						c-0.78-0.037-1.815-0.083-2.595-0.118l0.019,0.268c-0.002,0-0.002-0.003-0.005-0.006c-0.56-0.034-1.114-0.068-1.674-0.097
						c-4.25-0.179-2.24,0.723-2.215,0.734c0.435,0.164,1.135,0.284,1.485,0.465c1.266-0.167,2.445,0.161,4.077,0.624
						c-0.166-0.176-0.368-0.383-0.564-0.584l0.653,0.673l2.211,2.17l-0.019,0.015c1.314,0.561,1.314,0.561,6.49,1.454
						c-0.809-0.021-1.885-0.055-2.688-0.078c1.061,0.27,2.528,0.626,3.654,0.885c-1.543-0.078-3.665-0.127-5.251-0.127
						c-0.002-0.002-0.004-0.004-0.006-0.006c-0.317,0.023-0.624,0.049-0.919,0.081c0.013,0.005,0.025,0.011,0.041,0.011
						c0.408,0.144,0.876,0.19,1.197,0.209l0.408,0.388c1.225,0.581,2.852,1.367,4.544,1.887c-0.814-0.048-1.893-0.116-2.699-0.163
						c6.948,1.781,17.458,1.098,25.814,1.907c2.778,0.582,3.679,0.597,7.503,0.416l0.844,0.195c0.448-0.061,1.049-0.141,1.498-0.198
						c21.359,1.271,21.359,1.271,23.834,1.703c-2.948,0.388-2.948,0.388-13.667-0.055c-0.497,0.155-1.162,0.361-1.657,0.517
						c8.917,0.977,19.115,1.137,27.843,2.234c-14.015-0.218-27.23-1.562-41.435-1.517c-2.08-0.356-24.401-0.85-25.699-0.826l3.065,2.492
						c1.061-0.063,2.559,0.023,3.654,0.052c5.132-1.006,5.132-1.006,6.106-1.092c3.867,1.416,11.317,1.052,16.692,1.718
						c0.129-0.003,15.596,0.241,20.817,1.014c6.86,0.132,15.997,0.307,22.856,0.436c-0.448-0.169-1.031-0.393-1.473-0.559
						c14.63,0.453,15.831,0.49,20.004,1.145c0.042,0.003,0.081,0.003,0.121,0.003c-0.156-0.003-0.306-0.005-0.462-0.008
						c-0.342-0.055-0.613-0.141-1.048-0.164h-0.036l-0.035,0.138c-10.01,0.38-10.01,0.38-16.493-0.388
						c-26.69-0.439-26.69-0.439-32.265-0.634c-0.282,0.097-0.659,0.229-0.947,0.327c-4.28-0.374-8.907-0.385-13.293-0.655
						c-2.309,0.247-4.702,0.04-7.06,0.069c-0.183,0.188-0.437,0.442-0.625,0.629c1.627,0.106,3.56,0.463,4.427,0.786
						c-9.62-0.048-9.62-0.048-18.621-0.784l-0.035-0.002c1.084,0.537,2.535,1.255,3.614,1.794c7.62,0.368,7.62,0.368,8.381,0.385
						c4.472,0.5,10.007,0.396,13.902,1.236c-2.379-0.107-2.379-0.107-8.77-0.535c-0.777,0.104-1.81,0.244-2.582,0.351
						c2.215,0.626,2.735,0.774,7.437,0.574c0.03-0.012,0.061-0.018,1.845-0.109c0.962,0.293,1.824,0.758,2.058,1.114
						c-4.178,0.012-8.163-0.307-12.294-0.37c-0.83-1.174-1.891-1.229-10.114-1.663h-0.036l1.486,1.178l0.318,0.227
						c-0.601-0.166-1.181-0.342-1.899-0.479c0.343-0.028,0.795-0.068,1.133-0.101c-0.636-0.24-1.486-0.565-2.122-0.804
						c-2.984-0.061-2.984-0.061-9.489-1.111c0.023-0.083,0.059-0.192,0.082-0.276c5.854,0.13,6.289,0.149,9.128,0.282
						c-0.925-0.528-2.149-1.235-3.081-1.769c-2.081-0.018-3.832-0.345-5.941-0.34c-0.408-0.293,0.047-0.614-0.488-0.904
						c0.076-0.049,0.194-0.112,0.275-0.16c3.514,0.143,3.75,0.014,4.734-0.537c-0.915-0.753-2.116-1.752-3.024-2.508
						c-2.882-0.181-2.882-0.181-3.394-0.192c-0.237,0.061-0.544,0.139-0.769,0.196c-1.249-0.46-1.249-0.46-6.676-0.655
						c0.07,0.074,0.159,0.172,0.224,0.247c-3.248-0.684-7.847-0.833-11.254-1.456c0.189,0.175,0.326,0.422,0.307,0.6
						c-1.167-0.04-2.299-0.108-3.46-0.154c-2.419,0.283-4.519,0.339-6.437,0.265c-0.113-0.007-0.228-0.011-0.341-0.017
						c-5.145-0.245-8.967-1.435-13.953-1.794c0.19-0.073,0.45-0.171,0.638-0.246c0.33,0.018,0.778,0.046,1.108,0.068
						c0.801-0.045,1.993-0.031,2.758,0.047c0.336-0.034,0.791-0.081,1.126-0.115c0.229,0.058,0.537,0.133,0.772,0.189
						c0.023-0.121,0.048-0.275,0.066-0.396c0.346-0.011,0.807-0.031,1.16-0.043c-40.457-2.048-40.457-2.048-42.134-1.893
						c4.364,0.928,11.391,0.471,15.504,1.524c0.106-0.042,0.249-0.103,0.349-0.146c0.218,0.061,0.512,0.142,0.723,0.201
						c-0.094-0.074-0.211-0.175-0.306-0.252c14.965,0.534,14.965,0.534,16.037,0.956c-0.289,0.043-0.659,0.101-0.937,0.145
						c0.254,0.065,0.589,0.157,0.849,0.226c-0.082,0.081-0.207,0.196-0.296,0.275c-0.141-0.005-14.474-0.534-16.325-1.036
						c-0.626-0.169-10.18-1.893-12.814-0.318c0.896,0.367,0.896,0.367,0.849,0.684c-2.063-0.144-2.063-0.144-3.393-0.018
						c-4.219-0.394-8.997-0.391-13.528-0.563c2.325,0.188,4.592,0.408,6.698,0.73c3.11-0.241,16.2,0.869,16.33,0.881
						c0.754,0.405,0.425,1.1,0.419,1.105c-0.242-0.149-0.736-0.333-1.184-0.459c-0.154,0.075-0.367,0.178-0.52,0.253
						c-0.276-0.046-0.653-0.115-0.93-0.161c0.034-0.087,0.087-0.204,0.129-0.291c-0.33,0.023-0.761,0.055-1.08,0.078
						c-0.294-0.049-0.688-0.114-0.983-0.16c0.023,0.092,0.072,0.218,0.101,0.31c-2.445,0.055-7.07-0.267-8.364-0.482
						c-1.483,0.201-2.093,0.281-6.628-0.327c0.041-0.08,0.102-0.187,0.151-0.267c-1.516-0.308-2.25-0.359-13.004-0.896
						c-0.218,0.061-0.51,0.135-0.725,0.192c-0.219-0.054-0.518-0.132-0.736-0.189c0.955,0.388,0.977,0.416,1.345,0.933
						c-7.696-0.731-9.737-0.64-11.091-0.576c4.58,0.419,12.243,1.123,15.485,2.291c-1.329,0.149-1.329,0.149-4.86-0.034
						c-0.258,0.049-0.613,0.114-0.876,0.166c-1.616-0.108-3.293-0.166-4.874-0.304c-0.221-0.058-0.516-0.144-0.74-0.204
						c-7.445,0.083-11.337-1.554-17.902-1.892c0.126,0.144,0.628,0.329,1.15,0.419c-0.137,0.074-0.319,0.166-0.457,0.235
						c-2.288-0.284-4.794-0.462-7.249-0.666v21.105l1.742,1.025h2.618L1.717,50.96c1.111,0.367,2.263,0.729,3.375,1.082H1920.116z
						 M1236.958,36.896c0.143,0.078,0.33,0.179,0.48,0.256c8.008-0.355,16.012,0.608,24.029,0c-0.113-0.073-0.258-0.175-0.367-0.252
						c1.393-0.041,2.461-0.282,3.842-0.331c0.238-0.071,0.545-0.175,0.781-0.25c-0.236-0.034-0.543-0.089-0.781-0.128
						c0.627,0.071,1.449,0.166,2.064,0.241c0.119-0.078,0.287-0.179,0.412-0.257c-0.34-0.017-0.793-0.04-1.129-0.055
						c-0.027-0.076-0.059-0.181-0.084-0.255c1.473,0.109,1.473,0.109,2.998,0.615c0.266-0.058,0.619-0.13,0.885-0.188
						c-0.113-0.071-0.27-0.173-0.383-0.247c2.838,0.043,5.422,0.537,8.461,0.25c-0.008-0.08-0.008-0.192-0.008-0.271
						c-0.73-0.028-1.768-0.02-2.477,0.029c-0.426-0.092-0.977-0.218-1.402-0.315c0.719,0.011,1.703-0.069,2.297-0.161
						c-0.424-0.098-0.424-0.098-3.24-0.281c-0.223,0.058-0.529,0.137-0.752,0.201c0.088,0.074,0.217,0.175,0.309,0.252
						c-0.215,0.061-0.5,0.146-0.723,0.207c-1.721-0.092-2.219-0.126-4.314-0.511c0.141-0.075,0.316-0.17,0.457-0.241
						c-0.275-0.092-0.641-0.213-0.916-0.304c0.322-0.05,0.768-0.118,1.082-0.168c0.666,0.053,1.557,0.11,2.24,0.149
						c0.27-0.052,0.627-0.123,0.902-0.172c-1.008-0.155-2.24-0.213-3.236-0.376c0.014-0.083,0.025-0.192,0.025-0.276
						c-4.662-0.141-10.043-0.305-15.479-0.47l15.479,0.47c0.365-0.077,1.197-0.082,1.66-0.043l20.842,0.311
						c0.566,0.109,1.51,0.212,2.24,0.241c-0.072-0.147-0.104-0.21,0.375-0.296c0.498-0.086,0.521-0.106,0.535-0.238
						c-0.688-0.138-1.398-0.247-3.371-0.229c-1.047,0.011-1.748-0.018-2.229-0.195c-0.049-0.012-0.098-0.038-0.135-0.058
						c2.455-0.098,5.031,0.144,7.422-0.132c0.785,0.16,1.387,0.218,2.826,0.272c4.689,0.136,4.689,0.136,4.975,0.184
						c0.021,0.003,1.164,0.457-0.078,0.561c-0.254-0.087-0.299-0.104-0.141-0.225c0.129-0.092-0.078-0.121-0.584-0.181
						c-0.336,0.117-0.613,0.132-1.975,0.112c-1.629-0.026-1.973,0.034-1.838,0.327c0.824,0.058,1.725,0.023,2.537,0.098
						c0.576,0.049,0.676,0.089,0.729,0.189c-2.023-0.12-4.412,0.152-6.125-0.293c0.189-0.089,0.424-0.164,1.244-0.086
						c0.973,0.097,1.113-0.006,1.248-0.104c-0.238-0.098-0.566-0.224-0.805-0.318c-0.891,0.025-1.807-0.026-2.676,0.055
						c-0.652,0.061-0.738,0.108-1.063,0.293c0.564,0.16,1.461,0.234,1.99,0.401c0.391,0.121,0.379,0.121,0.006,0.23
						c-0.475-0.225-1.068-0.265-2.869-0.368l-0.035,0.287c-2.498,0.391-2.498,0.391-3.748,0.517c-0.059-0.092-0.119-0.215-0.172-0.305
						c-2.256-0.27-4.824-0.144-7.172-0.298c-0.26,0.06-0.613,0.138-0.873,0.201c0.207,0.074,0.482,0.166,0.686,0.241
						c0.35,0.005,0.824,0.014,1.188,0.021c0.215,0.143,0.26,0.361,0.096,0.508c0.012,0.006,3.291,1.011,4.697,1.493
						c-1.174,0.307-1.174,0.307-3.732,0.304c0.59,0.359,0.59,0.359,1.35,0.535c0.307-0.037,0.713-0.092,1.02-0.127
						c0.285,0.046,0.664,0.106,0.945,0.152c-1.068,0.289-2.783,0.315-4.078,0.514c-2.063-0.151-2.271-0.129-5.684,0.262
						c-0.105,0.009-0.223,0.017-0.33,0.026c-0.684,0.011-1.615-0.05-2.193-0.13c0.346,0.012,0.805,0.025,1.143,0.034
						c0.262-0.049,0.609-0.118,0.871-0.169c-1.518-0.012-3.023,0-4.529,0.029l-0.375-0.182l-0.842-0.025l-0.012,0.231
						c-0.352,0.007-0.701,0.015-1.045,0.021c0.064-0.063,0.139-0.126,0.197-0.184c-0.229-0.061-0.533-0.149-0.752-0.213
						c-5.156,0.081-10.111-0.437-15.297-0.264c-0.152,0.075-0.352,0.178-0.5,0.256c-0.691-0.052-1.527-0.164-2.066-0.27
						c-0.352,0.021-0.805,0.054-1.143,0.076c0.492,0.124,1.105,0.299,1.504,0.44c-0.682,0.022-1.613,0.025-2.299,0.002
						c-0.01-0.16,0.07-0.379,0.219-0.539c-12.453-0.102-13.361-0.581-13.902-0.867C1236.487,37.072,1236.757,36.972,1236.958,36.896z
						 M1015.589,27.882c-3.736-0.065-7.645-0.134-11.541-0.202L1015.589,27.882z M962.423,29.072c0.07-0.046,0.201-0.098,0.615-0.077
						c0.447,0.218-0.029,0.398-0.572,0.396c-0.094-0.003-0.313-0.008-0.514-0.075c-0.047-0.014-0.092-0.039-0.135-0.06
						C962.147,29.256,962.147,29.256,962.423,29.072z M953.056,31.28c0.603-0.095,1.148-0.031,1.148-0.031
						c0.528,0.12,0.558,0.246,0.675,0.678c-0.796-0.047-1.191-0.012-1.559,0.023c-0.271,0.028-0.492,0.048-0.833,0.048
						c-0.046,0-0.106-0.003-0.16-0.003c0.324-0.281,0.292-0.385-0.204-0.684C952.583,31.346,952.804,31.317,953.056,31.28z
						 M952.924,32.578c-0.1,0.084-0.224,0.192-0.321,0.273l-0.506-0.098C952.134,32.61,952.186,32.529,952.924,32.578z M942.672,30.028
						l0.063,0.201l-0.884-0.012l-0.058-0.204L942.672,30.028z M941.288,32.503c-0.364,0.066-0.603,0.162-1.002,0.216
						c-0.387,0.055-0.648,0.052-0.944,0.052c-0.161-0.003-0.31-0.017-0.469-0.023c-0.025,0-0.061,0-0.083,0
						c-0.058-0.174-0.132-0.404-0.179-0.577C941.036,32.489,941.036,32.489,941.288,32.503z M931.031,31.306l0.495,0.288l-1.281-0.018
						l-0.095-0.281L931.031,31.306z M927.653,36.314c-0.333,0.077-0.556,0.086-0.643,0.086c-0.045,0-0.174-0.006-0.28-0.041
						c-0.073-0.021-0.092-0.048-0.092-0.079C926.643,36.28,926.694,36.09,927.653,36.314z M921.962,29.83
						c-0.144-0.212-0.772-0.402-0.597-0.628c0.115-0.147,0.879-0.133,1.172-0.13c0.568,0.453,0.827,0.663-0.437,0.746
						C922.063,29.825,922.003,29.825,921.962,29.83z M922.511,32.911l-0.061-0.186l0.879,0.011l0.066,0.184L922.511,32.911z
						 M923.217,31.2l0.885,0.009l0.057,0.188l-0.884-0.011L923.217,31.2z M923.938,33.315l-0.074-0.2l0.873,0.012l0.077,0.201
						L923.938,33.315z M925.245,26.505c0.434,0.152-0.095,0.215-0.626,0.212c-0.29-0.008-0.479-0.024-0.583-0.06
						c-0.052-0.018-0.063-0.038-0.058-0.061C924.426,26.585,924.765,26.499,925.245,26.505z M920.602,27.366
						c0.14-0.109,0.186-0.118,0.565-0.137c2.05,0.548,2.05,0.548,3.167,0.619c-0.126,0.287-0.6,0.316-1.436,0.34
						c-0.724,0.021-1.08,0.057-1.378,0.2l-0.953-0.219c0.448,0.006,1.375,0.006,1.235-0.131c-0.106-0.099-0.672-0.233-1.224-0.362
						c-0.252-0.058-0.511-0.112-0.694-0.185C920.418,27.516,920.51,27.438,920.602,27.366z M890.575,31.312
						c0.131-0.16,1.145-0.143,1.592,0.023c0.005,0.005,0.019,0.011,0.024,0.011c0.081,0.041,0.129,0.081,0.141,0.124l-1.697-0.02
						C890.58,31.403,890.54,31.358,890.575,31.312z M892.083,33.161c-0.294-0.009-0.553-0.055-0.789-0.141
						c-0.072-0.022-0.13-0.046-0.166-0.072c-0.023-0.017-0.513-0.353,1.704-0.117C892.755,32.983,892.604,33.161,892.083,33.161z
						 M891.924,32.521c-0.027,0-0.057,0-0.087,0.002c-0.56-0.287-0.353-0.358,0.703-0.477C892.674,32.26,892.827,32.503,891.924,32.521z
						 M892.638,31.194c-0.636-0.009-1.373-0.029-1.85-0.179c-0.343-0.105-0.402-0.238-0.396-0.238c-0.046-0.172,0.094-0.35,0.077-0.522
						c-0.013-0.129-0.053-0.259,0.012-0.39c0.105-0.201,0.388-0.312,1.131-0.432C892.403,30.06,892.45,30.255,892.638,31.194z
						 M890.51,26.043c0.235,0.258,0.218,0.404-0.553,0.401c-0.184-0.003-0.367-0.006-0.537-0.014c-0.024-0.006-0.059-0.01-0.083-0.01
						C889.616,26.051,889.625,26.033,890.51,26.043z M884.911,27.159c0.218-0.614,0.548-0.731,1.427-0.775
						c0.199,0.102,0.501,0.254,1.103,0.336c1.042,0.146,2.333,0.153,3.376,0.303c-0.041,0.231-0.041,0.231,1.102,0.684
						c-1.938,0.166-1.938,0.166-2.493,0.263c-0.242-0.527-0.242-0.536-1.078-0.591c-0.944,1.039-0.944,1.039-2.169,1.223
						c1.133,0.195,0.006,0.457,0.229,0.678c-0.406,0.01-0.771-0.028-0.771-0.028c-0.702-0.08-1.015-0.391-0.343-0.655
						c0.124,0,0.283,0,0.408,0.003c-0.814-0.16-0.791-0.425-1.492-0.597C884.606,27.809,884.716,27.711,884.911,27.159z M878.263,28.228
						l0.064,0.187l-0.883-0.008l-0.064-0.189L878.263,28.228z M878.469,29.074c0.602,0.07,0.813,0.053,0.942-0.068
						c-1.473-0.042-2.016-0.184-1.932-0.508c0.529,0.008,1.231,0.015,1.762,0.022c0.159,0.287,0.478,0.574,0.483,0.867
						c0.006,0.23-0.294,0.391-0.473,0.491c-0.552-0.006-0.977-0.098-1.497-0.124c-0.075-0.002-0.169-0.002-0.234-0.005
						c-0.254-0.129-0.395-0.235,0.094-0.439c0.125-0.055,0.402-0.092,0.319-0.166c-0.095-0.084-0.454-0.112-0.691-0.165
						C877.549,28.975,877.549,28.975,878.469,29.074z M868.02,34.824c-0.043,0.063,0.004,0.12,0.116,0.232
						c0.172,0.184,0.172,0.262-0.3,0.262c-0.124-0.004-0.249-0.004-0.359-0.015c-0.012,0-0.03-0.003-0.047-0.006
						C867.259,35.045,867.434,34.902,868.02,34.824z M860.385,28.186c-0.347-0.099-0.471-0.142,0.184-0.17
						c0.094,0.058,0.2,0.086,0.513,0.154c0.412,0.087,0.66,0.155,0.541,0.339c-0.129,0.018-0.258,0.018-0.4,0.018
						c-0.595-0.011-1.096-0.089-1.249-0.138c-0.224-0.071,0.165-0.09,0.294-0.098c0.129,0.031,0.308,0.071,0.437,0.104
						C860.809,28.331,860.739,28.282,860.385,28.186z M861.281,29.899c-0.27-0.006-0.524-0.023-0.767-0.047
						c-0.04-0.003-0.093-0.011-0.129-0.011c0.414-0.213,0.2-0.348-0.389-0.604c-0.591-0.267-0.836-0.419-0.496-0.657
						c0.826-0.018,1.45,0.077,1.745,0.141C862.708,29.015,863.315,29.888,861.281,29.899z M722.641,44.82
						c-0.004-0.006-0.004-0.006-0.007-0.009l-0.31-0.399L722.641,44.82z"/>
					';
			$svg_top_output .= '</svg>';
		}

		$svg_bottom_output = '';
		if ( $enable_grunge_effect == 'yes' && $grunge_effect_bottom == 'yes' ) {
			$svg_bottom_output    .= '<svg class="qodef-grunge-effect qodef-grunge-effect-bottom" preserveAspectRatio="none" width="1920px" height="52px" viewBox="0 0 1920 52" enable-background="new 0 0 1920 52" ' . mixtape_qodef_get_inline_attr( $grunge_effect_style, 'style' ) . '>';
			$svg_bottom_output    .= '<polygon points="406.54,13.503 406.398,13.307 405.751,13.302 405.88,13.496 "/>
				<polygon points="241.93,10.933 241.795,10.751 241.246,10.74 241.382,10.918 "/>
				<path d="M268.944,15.952c1.75-0.069,0.83-0.479,0.252-0.568c-0.142-0.021-0.296-0.031-0.461-0.038
					c-0.247-0.003-0.412,0.007-0.653,0.035c0.017,0.21,0.566,0.378,0.742,0.577C268.861,15.955,268.901,15.955,268.944,15.952z"/>
				<path d="M255.257,17.744c-1.162-0.021-2.01-0.006-1.551,0.416c0.019,0,0.036,0,0.049,0
					C255.363,18.252,255.287,17.867,255.257,17.744z"/>
				<path d="M675.027,28.849c-0.917-0.167-2.096-0.133-3.134-0.204c-0.011,0.063-0.024,0.175,0.283,0.267
					C672.859,29.106,674.628,29.037,675.027,28.849z"/>
				<path d="M45.177,41.515c0.15,0.018,0.321,0.003,0.477,0.015c-0.161-0.109-0.339-0.185-0.726-0.219
					c-0.067-0.006-0.138-0.006-0.218-0.011c0.052,0.052,0.108,0.103,0.209,0.151C44.982,41.478,45.057,41.501,45.177,41.515z"/>
				<polygon points="132.24,46.371 131.982,46.181 131.576,46.164 131.84,46.353 "/>
				<path d="M40.624,41.96c0.429-0.052,1.232-0.04,2.054,0.104c-0.372-0.276-1.105-0.365-1.404-0.394
					c-0.409-0.026-1.04-0.022-0.708,0.295C40.585,41.965,40.605,41.96,40.624,41.96z"/>
				<path d="M45.389,42.27c-0.123-0.061-0.28-0.138-0.402-0.2l-0.289-0.023c0.039,0.043,0.092,0.081,0.168,0.121
					C44.982,42.219,44.996,42.219,45.389,42.27z"/>
				<path d="M114.323,50.784c-0.176-0.055-0.271-0.112-0.389-0.175c-0.2-0.092-0.313-0.112-0.437-0.121
					c-0.047,0-0.088,0-0.129,0.003c0.082,0.061,0.177,0.121,0.306,0.176C113.935,50.767,114.141,50.775,114.323,50.784z"/>
				<path d="M69.304,49.443c0.101-0.031,0.342-0.018,0.389-0.018c-0.218-0.086-0.501-0.201-0.719-0.286
					c-0.041,0.051,0.095,0.197-0.188,0.154c0.072,0.037,0.137,0.071,0.219,0.105C69.175,49.478,69.232,49.467,69.304,49.443z"/>
				<path d="M36.533,49.119c-0.274-0.182-0.602-0.268-0.814-0.291c-0.218-0.017-0.206,0.034-0.165,0.055
					C36.014,49.104,36.403,49.113,36.533,49.119z"/>
				<path d="M16.978,47.404c0.302,0.144,0.553,0.172,0.638,0.13c0.066-0.034,0.025-0.107-0.129-0.21
					c-0.33-0.018-0.4-0.099-0.648-0.136c-0.262-0.025-0.121,0.066-0.062,0.102C16.831,47.327,16.904,47.367,16.978,47.404z"/>
				<polygon points="18.989,47.657 18.724,47.484 18.307,47.427 18.577,47.605 "/>
				<path d="M16.687,47.468c0.06-0.049-0.013-0.141-0.221-0.276c-0.151,0.029-0.003,0.095-0.24,0.115
					c-0.111,0.012-0.301-0.037-0.386-0.058c0.043,0.023,0.092,0.049,0.135,0.072C16.316,47.49,16.603,47.524,16.687,47.468z"/>
				<path d="M15.353,47.461c0,0,0.002,0,0.006,0c0.044-0.036-0.174-0.2-0.336-0.229c-0.002,0-0.002,0-0.002,0
					c-0.041,0.009,0.205,0.175,0.286,0.212C15.314,47.45,15.33,47.459,15.353,47.461z"/>
				<path d="M3.569,45.781c0.055,0.032,0.122,0.073,0.184,0.101c0.294,0.156,0.344,0.146,0.489,0.121
					c0.084-0.018,0.144-0.022,0.295,0.021c-0.183-0.093-0.407-0.198-0.658-0.247C3.747,45.75,3.646,45.756,3.569,45.781z"/>
				<path d="M2.448,45.658c0.034,0.052,0.102,0.098,0.171,0.149c0.011-0.003,0.017-0.006,0.026-0.008
					c0.296-0.05,0.701,0.12,0.767,0.037c0.044-0.063,0.072-0.101-0.619-0.236C2.674,45.581,2.35,45.522,2.448,45.658z"/>
				<path d="M1912.804,30.979c0.107-0.042,0.084-0.092,0.072-0.112c-0.045-0.008-0.094-0.014-0.154-0.02
					c-0.309-0.028-0.578,0.04-0.885,0.017c-0.043,0.023-0.08,0.047-0.053,0.075C1911.874,31.025,1912.569,31.07,1912.804,30.979z"/>
				<path d="M1909.522,34.379c0.164-0.052,0.234-0.155,0.27-0.207c-0.791-0.04-0.717,0.12-0.705,0.141
					C1909.13,34.382,1909.321,34.441,1909.522,34.379z"/>
				<path d="M1817.087,28.618c0.016-0.045,0.094-0.187-0.469-0.241c-0.26-0.018-0.506-0.008-0.781,0.026
					c-0.018,0.037-0.023,0.071,0.006,0.109C1815.96,28.642,1816.515,28.687,1817.087,28.618z"/>
				<path d="M1813.118,28.59l0.406-0.063c0.176-0.092-0.174-0.136-0.34-0.149c-0.449-0.034-0.865,0.012-0.768,0.144
					c0.006,0.006,0.012,0.012,0.02,0.015C1812.634,28.55,1812.909,28.576,1813.118,28.59z"/>
				<path d="M1284.741,36.257c-0.027-0.003-0.064-0.003-0.104-0.003c-1.117-0.031-1.279,0.149-1.553,0.419
					c0.025-0.002,0.049-0.005,0.072-0.008C1284.618,36.475,1284.702,36.464,1284.741,36.257z"/>
				<path d="M1279.798,36.478c-0.686,0.041-0.84,0.133-0.863,0.262c0.369,0.012,0.863,0.028,1.227,0.041L1279.798,36.478
					z"/>
				<path d="M1281.813,37.302c-0.836-0.018-1.037,0.253-0.746,0.385c0.285,0.124,0.9,0.093,1.1,0.081
					c-0.328-0.081-0.307-0.127-0.152-0.222C1282.159,37.454,1282.167,37.396,1281.813,37.302z"/>
				<path d="M1238.339,39.329c0.736,0,0.482-0.298,1.236-0.246c-0.08-0.139-0.457-0.201-1.391-0.23
					c-0.213-0.005-0.416-0.008-0.623-0.011c-0.273,0.224-0.273,0.224,0,0.465C1237.798,39.312,1238.101,39.326,1238.339,39.329z"/>
				<path d="M1258.567,40.856c0.223-0.02,0.33-0.028,0.33-0.073c0-0.075-0.246-0.13-0.33-0.196
					c0.543,0.037,0.641,0.047,1.143,0.184c0.365,0.092,0.744,0.196,1.758,0.173c0.117-0.163,0.529-0.31,0.529-0.482
					c0.004-0.126-0.082-0.167-0.512-0.345c-1.41-0.006-2.678,0.181-4.096,0.152c-1.369-0.025-2.477-0.21-3.732-0.302
					c-0.006,0.058,0,0.126,0,0.181c-0.111,0.026-0.219,0.021-0.779-0.129c-0.906-0.241-0.906-0.241-0.906,0.275c0.018,0,0.039,0,0.061,0
					C1253.032,40.306,1256.587,40.47,1258.567,40.856z"/>
				<path d="M1251.196,40.073c-0.373-0.008-0.871-0.026-1.234-0.037v0.289c0,0,0.01,0,0.025,0
					C1250.435,40.341,1251.271,40.363,1251.196,40.073z"/>
				<path d="M1231.329,40.047c1.006,0.006,0.951-0.212,0.385-0.35c-0.914,0.012-0.791,0.195-0.59,0.281
					C1231.181,40.008,1231.253,40.026,1231.329,40.047z"/>
				<polygon points="1264.323,40.76 1263.542,40.736 1263.542,40.915 1264.317,40.94 "/>
				<path d="M731.453,36.836c-0.154-0.005-0.3-0.011-0.454-0.014c-0.365,0-0.737,0.009-0.966,0.115
					c-0.308,0.146-0.129,0.302-0.249,0.456c0.036-0.002,0.076-0.005,0.106-0.008C731.128,37.308,731.907,37.233,731.453,36.836z"/>
				<path d="M730.893,39.02c0.023,0,0.042,0,0.057,0c1.057-0.046,1.471,0.264,2.501,0.229
					c-0.284-1.143-0.355-1.45-1.682-1.93c-0.311,0.003-0.558,0.003-0.924,0.135c-0.348,0.118-0.907,0.078-1.438,0.026
					c0.337,0.315,0.909,0.614,1.214,0.93C730.858,38.651,730.88,38.767,730.893,39.02z"/>
				<path d="M760.457,39.054c1.32,0.006,1.121-0.334,0.583-0.46c-0.018-0.005-0.046-0.008-0.065-0.011
					c-0.801,0.011-0.813,0.16-0.529,0.471C760.446,39.054,760.446,39.054,760.457,39.054z"/>
				<path d="M1180.517,45.968c0.061-0.042,0.055-0.092,0.045-0.14c-0.658-0.021-0.998-0.078-1.27-0.21
					c-0.98,0.018-0.672,0.179-0.494,0.244C1179.233,46.025,1180.282,46.181,1180.517,45.968z"/>
				<path d="M731.341,39.476c0.159,0.055,0.92,0.238,1.479,0.04c-0.313-0.086-0.712-0.197-1.02-0.283
					C730.775,39.27,731.282,39.455,731.341,39.476z"/>
				<path d="M1182.04,47.348c0.869-0.125,0.74-0.199,0.184-0.363c-0.633-0.184-1.012-0.32-0.73-0.579
					c-0.375,0.014-1.529,0.058-0.092,0.688C1181.603,47.181,1181.813,47.261,1182.04,47.348z"/>
				<path d="M1176.181,46.824c-0.389-0.092-0.178-0.281-0.939-0.304c-0.111-0.006-0.234,0-0.346,0.002
					c-0.008,0.037-0.016,0.112,0.146,0.176C1175.317,46.811,1175.933,46.824,1176.181,46.824z"/>
				<path d="M740.104,40.162c0.018-0.146-0.406-0.253-0.642-0.379l-1.148,0.083c0.01,0.037,0.028,0.115,0.234,0.181
					C738.944,40.174,739.721,40.168,740.104,40.162z"/>
				<path d="M722.593,39.794l0.319-0.085c0-0.092-0.355-0.118-0.649-0.121c-0.471-0.006-0.918,0.058-0.529,0.187
					c0.01,0.003,0.022,0.009,0.034,0.014C722.022,39.788,722.345,39.791,722.593,39.794z"/>
				<path d="M1178.54,48.449c-0.156,0.185-0.309,0.379,0.398,0.626c1.369,0.471,1.369,0.471,1.449,0.609
					c0.254,0.006,0.59,0.017,0.848,0.023c1.283-0.149-0.246-0.896-1.811-1.058c-0.229-0.439-1.102-0.912-3.234-1.734
					c-0.029-0.003-0.068-0.006-0.096-0.006C1174.604,46.95,1178.479,48.433,1178.54,48.449z"/>
				<path d="M723.632,40.191c-0.396-0.029-0.78-0.066-1.197-0.075c-0.507,0-0.678,0.065-0.642,0.238
					c0.034,0,0.076,0,0.105,0.003C724.009,40.38,724.009,40.38,723.632,40.191z"/>
				<polygon points="715.415,40.38 715.272,40.196 714.447,40.188 714.589,40.372 "/>
				<path d="M738.997,40.702c0,0,0.089-0.175-0.442-0.181c-0.471,0-0.365,0.129-0.647,0.172
					c-0.012,0.003-0.024,0.003-0.035,0.003c-0.061,0.006-0.113,0.009-0.178,0.009c0.035,0.023,0.07,0.042,0.142,0.065
					C738.17,40.875,738.897,40.831,738.997,40.702z"/>
				<path d="M712.285,40.478c-0.146-0.085-0.429-0.149-0.607-0.227c-0.418,0.055-0.553,0.166-0.473,0.379
					c0.356,0.004,0.839,0.009,1.198,0.012C712.408,40.616,712.414,40.547,712.285,40.478z"/>
				<path d="M722.523,40.841c1.09-0.041,0.612-0.259,0.123-0.34c-0.249-0.04-0.442-0.043-0.531-0.046
					c-0.283,0-0.429,0.022-0.63,0.08C721.804,40.627,722.216,40.747,722.523,40.841z"/>
				<path d="M1184.017,48.478c0.852-0.168,0.73-0.536-0.246-0.82c-0.27,0.006-0.861,0.008-0.83,0.184
					c0.039,0.241,0.75,0.43,0.977,0.654C1183.948,48.49,1183.983,48.484,1184.017,48.478z"/>
				<path d="M719.742,41.376c0.606,0.01,1.231-0.003,0.961-0.28c-0.361-0.006-0.844-0.009-1.203-0.015l0.218,0.295
					C719.724,41.38,719.729,41.376,719.742,41.376z"/>
				<polygon points="716.428,41.25 716.276,41.046 715.456,41.041 715.604,41.242 "/>
				<path d="M735.207,41.727c-0.306,0.003-0.548,0.026-0.772,0.075c0.524,0.037,1.209,0.089,1.733,0.127
					C735.997,41.805,735.678,41.739,735.207,41.727z"/>
				<path d="M1181.493,49.075c0.037,0.028,0.078,0.058,0.148,0.084c0.242,0.094,0.717,0.141,1.582,0.151
					c0.1-0.246-0.656-0.289-0.896-0.299C1181.989,49.007,1181.737,49.024,1181.493,49.075z"/>
				<path d="M735.082,42.276c0.019-0.035-0.04-0.058-0.099-0.087c-0.012-0.002-0.025-0.005-0.042-0.012
					c-0.087-0.029-0.188-0.058-0.289-0.083c-0.418,0.095-0.377,0.158-0.277,0.189C734.546,42.339,735.042,42.345,735.082,42.276z"/>
				<path d="M696.553,42.276c0.119-0.139-0.046-0.19-0.612-0.202c-0.366,0-0.732,0.029-1.097,0
					c0.011,0,0.023,0.006,0.035,0.012C695.269,42.219,695.945,42.256,696.553,42.276z"/>
				<path d="M735.46,42.657c-0.914-0.003-0.925,0.161-0.936,0.385c0.005,0,0.011,0,0.022-0.003
					c0.744-0.008,1.285,0.173,2.076,0.115c-0.272-0.063-0.637-0.144-0.908-0.207l0.176-0.272
					C735.743,42.666,735.608,42.661,735.46,42.657z"/>
				<path d="M695.503,42.447c-0.534,0.029-0.317,0.125-0.199,0.167c0.237,0.078,0.801,0.173,1.249,0.132
					c-0.012-0.103-0.165-0.137-0.542-0.184C695.727,42.531,695.586,42.505,695.503,42.447z"/>
				<path d="M1903.05,32.196c1.252,0.144,1.697,0.112,1.936-0.133c0.232-0.017,0.363-0.017,0.918,0.026
					c0.83,0.064,1.072,0.041,1.279-0.118c-1.154-0.2-1.756-0.1-2.486,0.064c-0.152-0.047-0.369-0.104-0.521-0.149
					c0.693-0.023,1.074-0.173,1.48-0.578c-0.383-0.034-0.885-0.083-1.268-0.123c-0.08,0.222-0.313,0.275-0.783,0.345
					c-0.494,0.068-0.719,0.121-0.801,0.324c0.039,0,0.094,0,0.137,0.003c0.545,0,0.742,0.012,0.748,0.052
					c0.004,0.018-0.055,0.041-0.09,0.058C1903.427,32.044,1903.228,32.118,1903.05,32.196z"/>
				<path d="M1899.985,31.903c0.006,0.006,0.012,0.003,0.027,0.006c0.914,0.109,1.613-0.121,2.492-0.083
					c0.104-0.078,0.246-0.188,0.35-0.267c0.012-0.038,0.154-0.075-0.025-0.109c-0.227,0.022-0.545,0.246-0.615,0.351
					c-0.119-0.073-0.281-0.167-0.402-0.241c-0.436-0.033-0.912,0.034-1.334-0.023c0.123,0.115,0.092,0.135-0.098,0.184
					C1900.153,31.782,1900.087,31.826,1899.985,31.903z"/>
				<path d="M1244.597,40.162c1.428,0.023,2.137,0.012,2.447-0.212c-0.365,0.011-0.914,0.028-1.324,0
					c-0.592-0.034-1.051-0.127-1.592-0.179c-0.426,0.115-1.055,0.187-1.234,0.345c-0.486-0.012-0.502-0.026-0.771-0.218
					c-0.117-0.087-0.365-0.121-0.848-0.121c-0.025,0.462-0.025,0.534,0.389,0.678C1242.04,40.15,1242.89,40.134,1244.597,40.162z"/>
				<path d="M723.13,39.283c0.382,0.012,0.777,0.023,1.155,0.052c-0.135-0.068-0.359-0.181-1.363-0.166
					c-0.894,0.014-1.308-0.058-1.684-0.141c-0.188,0.037-0.26,0.06-0.212,0.105c0.024,0.003,0.03,0.007,0.036,0.012
					C721.332,39.212,721.897,39.237,723.13,39.283z"/>
				<path d="M1262.056,36.71c-0.092-0.005-0.24-0.011-0.367-0.063c-0.209-0.086-0.221-0.354,0.324-0.351
					c0,0.146,0.066,0.27,0.373,0.391C1262.28,36.699,1262.175,36.71,1262.056,36.71z"/>
				<polygon points="750.155,40.65 750.026,40.467 750.862,40.472 750.991,40.656 "/>
				<path d="M753.644,37.135c-0.095-0.005-0.224-0.005-0.343-0.04c-0.152-0.045-0.245-0.129-0.329-0.215
					c0.966-0.025,1.551,0.043,1.731,0.201C754.351,37.104,754.016,37.135,753.644,37.135z"/>
				<path d="M757.912,43.568c0.118,0.172,0.111,0.249-0.241,0.278c-0.419-0.147-0.501-0.239-0.55-0.405
					c-0.034-0.135-0.093-0.195-0.382-0.279c0.524,0.039,1.213,0.09,1.739,0.128C757.746,43.264,757.775,43.385,757.912,43.568z"/>
				<polygon points="772.353,40.409 773.188,40.414 773.307,40.602 772.469,40.593 "/>
				<path d="M773.154,42.206c-0.054-0.005-0.095-0.014-0.129-0.021c-0.154-0.055-0.262-0.182-0.203-0.245
					c0.043-0.037,0.153-0.074,0.52,0.058c0.012,0.003,0.023,0.009,0.042,0.015c0.005,0.006,0.022,0.008,0.034,0.014
					C773.342,42.08,773.236,42.148,773.154,42.206z"/>
				<polygon points="772.712,41.546 773.813,41.373 773.608,41.739 "/>
				<path d="M775.83,44.323c-0.138-0.003-0.273-0.003-0.389-0.015c-0.024,0-0.059-0.005-0.078-0.005
					c-0.042-0.053-0.089-0.13-0.135-0.185c0.283-0.141,0.672-0.08,0.824-0.046C776.353,44.137,776.736,44.325,775.83,44.323z"/>
				<path d="M775.109,43.938c-0.118-0.181,0.154-0.243,0.638-0.283c0.188,0.089,0.452,0.207,0.649,0.296L775.109,43.938z
					"/>
				<path d="M781.988,43.246c0.831,0.178,0.707,0.487-0.006,0.565c-0.184-0.052-0.366-0.103-0.524-0.16
					C780.745,43.396,781.322,43.304,781.988,43.246z"/>
				<path d="M783.315,44.936c-0.047,0.005-0.108,0.011-0.16,0.014c0.146-0.152-0.064-0.262-0.76-0.506
					c-0.707-0.244-0.866-0.358,0.502-0.425c-0.383,0.136-0.208,0.256,0.359,0.49C783.687,44.693,784.063,44.849,783.315,44.936z"/>
				<path d="M713.492,44.137c-0.016,0-0.04,0-0.059,0.003c-0.088-0.09-0.754-0.224-0.217-0.276
					c0.112,0.072,0.418,0.118,0.494,0.192C713.729,44.076,713.765,44.107,713.492,44.137z"/>
				<path d="M715.545,43.487c-0.12,0-0.294-0.006-0.579-0.061c-0.036-0.006-0.071-0.014-0.106-0.02
					c0.454-0.279,0.454-0.279-0.435-0.569c1.12-0.008,1.12-0.008,0.524-0.378c0.359,0.005,0.836,0.011,1.197,0.011
					c0.241,0.322,0.483,0.638,0.73,0.956C716.417,43.427,716.003,43.484,715.545,43.487z"/>
				<path d="M719.742,43.82c-0.06,0-0.107,0-0.166,0c-0.012,0-0.012,0-0.023,0c0.236-0.261,0.141-0.379-0.507-0.66
					c1.12,0.072,1.731,0.247,2.075,0.583C720.625,43.743,720.225,43.82,719.742,43.82z"/>
				<path d="M1.714,51.391c-0.224-0.09-0.375-0.185-0.599-0.271c0.044,0.037,0.103,0.089,0.147,0.126
					c-0.083,0-0.38-0.137-0.858-0.401C0.359,50.816,0.3,50.781,0.25,50.753c0.249,0.028,1.56,0.591,1.498,0.646
					C1.734,51.396,1.723,51.391,1.714,51.391z"/>
				<path d="M2.571,51.643c-0.144-0.051-0.188-0.118-0.372-0.166c-0.034,0.028,0.078,0.052,0.019,0.08
					C2.058,51.534,2.067,51.493,2,51.459c-0.115-0.063-0.384-0.213-0.313-0.229c0.123-0.025,0.903,0.379,0.89,0.413H2.571z"/>
				<polygon points="1889.911,31.576 1890.507,31.634 1890.274,31.812 1889.683,31.757 "/>
				<path d="M1889.595,31.921c0.016,0,0.037,0,0.055,0.003c0.039,0.006,0.078,0.048,0.078,0.052
					c-0.01,0.037-0.025,0.101,0.381,0.203c0.424,0.104,1.041,0.161,1.4,0.282c0.127,0.04,0.092,0.058-0.029,0.077
					c-1.076-0.146-1.076-0.146-2.213-0.207C1889.229,32.233,1889.401,31.97,1889.595,31.921z"/>
				<path d="M1871.187,30.931c1.686,0.037,2.861,0.318,4.316,0.467c0.756,0.078,0.789,0.07,1.131,0.023
					c0.236-0.034,3.645-0.014,3.664-0.014c0.902,0.061,1.551,0.218,2.365,0.315c0.523-0.21,1.445-0.336,2.098-0.52
					c0.674,0.046,0.996,0.2,1.604,0.261c0.148,0.015,0.295,0.025,0.459,0.025c-0.453,0.377-0.828,0.5-2.002,0.747
					c-0.447-0.092-0.744-0.121-0.844-0.126c-0.723-0.052-0.984-0.052-1.998-0.034c-1.166,0.022-1.326-0.018-1.496-0.058
					c-0.326-0.081-0.652-0.161-1.115-0.184c-0.359-0.018-0.813,0.065-1.166,0.092c-0.682-0.086-0.828-0.302-1.668-0.351
					c-1.008,0.17-1.008,0.17-1.518,0.063c-0.006,0-0.016,0.003-0.021,0.006c0.016-0.006,0.039-0.011,0.012-0.017
					c-0.006-0.003-0.012,0-0.018,0c-0.02,0-0.023,0.003-0.02,0.006c0,0.005,0.014,0.005,0.025,0.011
					c-0.123,0.023-0.254,0.041-0.389,0.058c-0.189-0.017-0.453-0.04-0.648-0.058c-0.543,0.044-0.709,0.058-0.867,0.052
					c-0.08,0-0.1-0.034-0.129-0.052c-0.23-0.16-0.658-0.194-0.75-0.203c-0.734-0.052-1.436,0.203-2.15,0.037
					c-0.41-0.098-0.588-0.133-0.871-0.149c-0.584-0.044-1.148,0.213-1.588,0.068c-0.008-0.005-0.023-0.008-0.039-0.017
					C1867.888,31.261,1868.872,30.879,1871.187,30.931z"/>
				<path d="M1861.403,30.64c0.525,0.063,0.99,0.149,1.539,0.202c0.385,0.034,0.611,0.037,1.031,0.024
					c-0.383,0.235-0.891,0.309-1.697,0.248c-0.207-0.121-0.785-0.19-0.924-0.319C1861.292,30.737,1861.337,30.695,1861.403,30.64z"/>
				<path d="M1859.79,30.496c-0.029,0.069,0.074,0.104,0.48,0.161c0.449,0.055,0.699,0.096,0.5,0.227
					c-0.523-0.095-0.875-0.049-1.096-0.008c-0.506,0.097-0.896,0.051-1.037,0.034c-0.006,0-0.018-0.003-0.018-0.003
					C1858.979,30.767,1859.394,30.635,1859.79,30.496z"/>
				<path d="M1857.36,29.876c-0.1,0.081-0.23,0.187-0.33,0.27c-0.107,0.003-0.225,0.006-0.342,0
					c-0.061-0.005-0.201-0.023-0.25-0.086c-0.012-0.011-0.012-0.028-0.012-0.04C1856.438,29.913,1856.853,29.755,1857.36,29.876z"/>
				<path d="M1855.532,30.227c0.242,0.149,0.146,0.322-0.547,0.265c-0.137-0.013-0.262-0.023-0.371-0.041
					c-0.025-0.006-0.055-0.012-0.07-0.012C1854.733,30.292,1855.058,30.221,1855.532,30.227z"/>
				<path d="M1840.319,29.836c0.078,0.031-0.105,0.087-0.482,0.063c-0.111-0.012-0.406-0.04-0.57-0.149
					c-0.006-0.006-0.012-0.012-0.021-0.018C1839.833,29.761,1840.231,29.799,1840.319,29.836z"/>
				<path d="M1728.3,37.641c0.404,0.028,0.945,0.063,1.346,0.092c-0.387,0.216,0.047,0.448-0.271,0.661
					c-0.619-0.043-1.156-0.081-1.334-0.265C1727.868,37.957,1728.165,37.732,1728.3,37.641z"/>
				<path d="M1725.216,37.802c0.836,0.029,1.529,0.108,1.002,0.465c-0.217-0.022-0.848-0.08-1.025-0.252
					C1725.106,37.925,1725.181,37.842,1725.216,37.802z"/>
				<path d="M1723.788,38.095c0.422,0.029,0.99,0.069,1.41,0.098c-0.006,0.045-0.184,0.232-0.42,0.459
					c-0.152-0.006-0.307-0.006-0.447-0.014c-0.189-0.015-0.611-0.049-0.736-0.176C1723.476,38.336,1723.681,38.175,1723.788,38.095z"/>
				<path d="M1718.896,38.002c1.426-0.014,2.926,0.106,4.002,0.313c-0.516,0.233-1.514,0.503-3.354,0.457
					c-0.625-0.08-0.813-0.271-1.584-0.311c-0.303-0.018-0.627,0-0.904-0.039c-0.047-0.01-0.117-0.018-0.139-0.029
					c-0.025-0.007-0.025-0.018-0.039-0.023C1716.856,38.33,1717.12,38.02,1718.896,38.002z"/>
				<path d="M1713.681,38.009c0.105-0.052,0.375-0.188,1.289-0.018c0.258,0.047,0.258,0.047,0.879,0.416
					c-0.342,0.026-0.627,0.084-0.982,0.104c-0.307,0.018-0.463,0.015-0.727-0.003c-0.158-0.009-0.313-0.022-0.455-0.046
					c-0.021,0-0.047-0.002-0.07-0.005C1713.663,38.308,1713.378,38.151,1713.681,38.009z"/>
				<path d="M1711.8,38.031c0.088,0.115,0.352,0.225,0.391,0.345c0.021,0.106-0.156,0.207-0.232,0.247
					c-0.463-0.029-0.732-0.132-1.168-0.173c-0.027,0-0.076-0.006-0.111-0.006C1710.868,38.146,1711.083,38.012,1711.8,38.031z"/>
				<path d="M1707.733,38.049c-0.338,0.034-0.566,0.04-0.996,0.015c-0.818-0.066-1.104-0.198-1.197-0.268
					c-0.119-0.086-0.061-0.152-0.018-0.195C1706.647,37.478,1708.063,37.71,1707.733,38.049z"/>
				<path d="M1425.616,37.865c-0.613-0.146-0.613-0.146-0.605-0.179c0.281,0.046,0.617,0.043,0.924,0.055
					c0.732,0.012,1.074,0.02,1.037,0.121c-0.422,0.055-0.686,0.155-1.143,0.204c-0.342,0.034-0.447-0.021-0.482-0.041
					c-0.018-0.011-0.037-0.026-0.049-0.034C1425.772,37.974,1425.983,37.948,1425.616,37.865z"/>
				<path d="M1431.771,37.744c-0.371-0.021-0.617-0.075-0.695-0.109c-0.16-0.065,0.096-0.105,0.768-0.114
					C1432.382,37.732,1432.03,37.75,1431.771,37.744z"/>
				<polygon points="1417.071,37.555 1417.813,37.587 1417.765,37.768 1417.024,37.736 "/>
				<path d="M1413.44,37.498c0.297,0.039,0.518,0.063,0.859,0.079c0.396,0.013,0.803-0.005,1.203,0.023
					c0.318,0.023,0.494,0.058,0.705,0.104c-0.789,0.018-0.93,0.098-0.459,0.27c-0.729-0.063-1.148,0-1.461,0.046
					c-0.41,0.058-0.768,0.109-1.658,0.016c-0.031-0.004-0.074-0.01-0.096-0.013c-0.107-0.092-0.254-0.215-0.363-0.304
					c0.363-0.05,0.822-0.003,1.164-0.066C1413.511,37.621,1413.47,37.543,1413.44,37.498z"/>
				<path d="M1412.534,36.516c-0.217,0.003-0.426,0-0.627-0.012c-0.383-0.017-0.846-0.058-1.131-0.213
					c-0.072-0.04-0.119-0.086-0.166-0.129C1411.577,36.005,1412.638,36.246,1412.534,36.516z"/>
				<path d="M1405.39,37.641c-0.119,0.023-0.342,0.061-0.582,0.052c-0.102-0.006-0.201-0.014-0.279-0.052
					c-0.041-0.022-0.082-0.046-0.059-0.068C1404.522,37.522,1404.847,37.446,1405.39,37.641z"/>
				<path d="M1348.181,38.829c-0.195-0.008-0.766-0.028-1.016-0.146c-0.049-0.028-0.08-0.06-0.092-0.092
					c0.043-0.008,0.082-0.02,0.129-0.025c0.578-0.083,1.633-0.017,1.428,0.264C1348.478,38.824,1348.331,38.832,1348.181,38.829z"/>
				<path d="M1327.063,36.464l-0.031,0.184c-0.129,0.021-0.201,0.023-0.387,0.018c-0.074-0.007-0.24-0.013-0.381-0.087
					c-0.057-0.025-0.102-0.052-0.109-0.083c0.008-0.003,0.008-0.123,0.359-0.136C1326.61,36.354,1326.61,36.354,1327.063,36.464z"/>
				<path d="M1312.075,38.482c-0.359-0.015-0.561-0.025-0.863-0.08c-0.209-0.035-0.303-0.052-0.707,0.008
					c-0.031,0.003-0.068,0.013-0.094,0.018c-0.072-0.041-0.23-0.138,0.236-0.178C1311.126,38.209,1312.476,38.273,1312.075,38.482z"/>
				<path d="M1306.644,37.54c-0.068-0.003-0.146-0.005-0.221-0.008c-0.012,0-0.02,0-0.031,0
					c0.025-0.139,0.277-0.21,0.861-0.244c0.111,0.057,0.258,0.138,0.373,0.194C1307.276,37.485,1307.005,37.549,1306.644,37.54z"/>
				<path d="M1307.157,38.135l-0.416,0.348c-0.145-0.096-0.631-0.112-0.832-0.195c-0.156-0.061-0.072-0.129,0.033-0.192
					C1306.312,38.106,1306.79,38.12,1307.157,38.135z"/>
				<path d="M1305.71,36.765c-0.098-0.025-0.178-0.052-0.25-0.08c-0.295-0.132-0.262-0.158,0.324-0.571
					c0.797,0.065,1.232,0.104,1.568,0.178C1307.606,36.349,1308.62,36.76,1305.71,36.765z"/>
				<path d="M1305.183,37.399c-0.623-0.023-1.037-0.034-1.189-0.105c-0.09-0.044-0.039-0.089-0.02-0.118
					c0.256,0.012,0.588,0.023,0.848,0.032L1305.183,37.399z"/>
				<polygon points="1296.171,37.189 1297.009,37.219 1296.991,37.417 1296.153,37.389 "/>
				<path d="M1295.845,36.618c-0.076-0.022-0.145-0.045-0.205-0.068c-0.207-0.098-0.33-0.293,0.627-0.282
					C1296.765,36.412,1296.813,36.63,1295.845,36.618z"/>
				<path d="M1297.317,38.077c0.012,0.006,0.027,0.012,0.043,0.015c0.424,0.127,0.527,0.287-0.27,0.267
					c-0.164-0.006-0.33-0.011-0.484-0.025c-0.021-0.003-0.063-0.003-0.088-0.009C1296.476,38.187,1296.714,38.111,1297.317,38.077z"/>
				<path d="M1294.743,37.328c-0.281-0.009-0.447-0.04-0.504-0.063c-0.152-0.06,0.205-0.112,0.32-0.123
					c0.205,0.028,0.412,0.061,0.564,0.103C1295.347,37.313,1295.101,37.337,1294.743,37.328z"/>
				<path d="M1293.644,38.049c0.359,0.152-0.219,0.188-0.666,0.175c-0.271-0.012-0.447-0.031-0.531-0.065
					c-0.049-0.018-0.049-0.038-0.035-0.058C1292.839,38.106,1293.202,38.035,1293.644,38.049z"/>
				<path d="M1290.95,36.458c-0.025,0.074-0.111,0.111-0.277,0.115c-0.385-0.023-0.725-0.179-0.82-0.225
					c-0.07-0.034-0.137-0.068-0.143-0.103C1289.716,36.165,1289.948,36.223,1290.95,36.458z"/>
				<path d="M1290.692,37.059c0.793-0.055,1.316-0.066,2.197,0.025c-0.078,0.315-0.891,0.305-3.32,0.27
					c-0.309-0.101-0.762-0.172-1.014-0.287c-0.092-0.04-0.141-0.086-0.178-0.132C1289.288,37.13,1289.776,37.121,1290.692,37.059z"/>
				<path d="M1291.567,38.164c-0.336,0.063-0.549,0.071-0.654,0.068c-0.049-0.003-0.164-0.009-0.248-0.043
					c-0.061-0.022-0.082-0.049-0.061-0.078C1290.644,38.072,1290.962,37.971,1291.567,38.164z"/>
				<path d="M1279.47,42.635l-0.451-0.209c2.9,0.24,6.105,0.103,8.977,0.378c0.285-0.065,0.213-0.172,0.531-0.229
					c0.123-0.023,0.459-0.087,2.279,0.263c0.365,0.075,0.391,0.136,0.438,0.265c-3.922-0.049-7.867-0.017-11.787-0.108
					c0.043-0.038,0.045-0.099-0.061-0.133c-0.184-0.063-0.523-0.087-0.752-0.138c-0.035-0.012-0.072-0.025-0.107-0.035
					C1278.755,42.611,1278.995,42.62,1279.47,42.635z"/>
				<path d="M1276.196,42.426c0.49,0.137,1.303,0.2,1.641,0.372c0.246,0.124-0.207,0.199-0.432,0.235
					c0.117-0.131,0.033-0.188-0.695-0.146c-0.908,0.049-1.191-0.05-1.285-0.084C1275.294,42.759,1275.374,42.494,1276.196,42.426z"/>
				<path d="M1274.14,42.27c0.236,0.213,0.41,0.489-0.648,0.463c-0.566-0.021-1.014-0.109-1.168-0.164
					c-0.023-0.006-0.045-0.014-0.051-0.022c-0.092-0.041-0.072-0.104,1.031-0.018C1273.323,42.379,1273.552,42.308,1274.14,42.27z"/>
				<path d="M1270.872,42.609c-0.104,0.16-1.424,0.134-1.984,0.114c-0.047,0-4.203-0.175-4.861-0.351
					c-0.391-0.109,0.045-0.293,0.885-0.299c1.436-0.017,2.604,0.189,3.959,0.242c0.578,0.014,1.182-0.029,1.721,0.052
					C1270.827,42.399,1270.989,42.426,1270.872,42.609z"/>
				<path d="M1258.065,38.457c2.137,0.105,2.137,0.105,3.273-0.07c2.229,0.294,4.879,0.199,7.248,0.359
					c-2.619,0.066-5.232,0.127-7.863,0.106c-0.111,0.081-0.264,0.187-0.379,0.268c-2.346-0.164-2.346-0.164-3.256-0.472
					C1257.378,38.591,1257.767,38.515,1258.065,38.457z"/>
				<path d="M1229.251,39.186c2.998,0.086,3.607-0.293,4.449-0.827c0.076,0.173,0.307,0.402,0.537,0.565
					c0.482-0.171,1.125-0.401,1.596-0.573c1.014,0.055,1.014,0.055,3.35-0.113c1.736,0.346,1.779,0.386,2.086,0.713
					c0.455-0.149,0.455-0.149,3.318-0.557c2.014,0.227,2.227,0.252,2.328,0.74c4.604,0.741,10.746,0.167,15.352,0.913
					c1.936-0.166,3.885,0.081,5.814-0.018c-0.094,0.107-0.225,0.251-0.318,0.356c-0.402,0.023-0.934,0.052-1.32,0.078
					c-0.014,0.08-0.014,0.189-0.023,0.267c2.004,0.373,2.004,0.373,2.238,0.672c-3.83-0.074-4.926-0.247-5.955-0.601
					c-0.646,0.251-0.646,0.563-1.455,0.802c-5.268-0.579-11.232-0.603-16.66-1.062c-0.125,0.074-0.297,0.177-0.42,0.252
					c-0.158-0.086-0.355-0.189-0.512-0.272c-1.592,0.123-3.326,0.065-4.895,0.209c-0.486,0.635-0.486,0.635,0.191,1.071
					c4.631,0.204,5.01,0.192,6.424,0.149c0.424,0.101,0.967,0.233,1.387,0.336c-0.162,0.075-0.373,0.173-0.525,0.247
					c-4.693-0.258-4.693-0.258-6.99-0.104c2.15,0.265,2.15,0.265,3.322,0.655c-0.301,0.037-0.707,0.086-1.002,0.12
					c43.904,1.332,69.951,2.148,97.232,3.139c-0.063-0.003-0.139-0.003-0.201-0.006c-29.615-0.947-69.48-1.736-98.705-3.179
					c-0.678-0.069-2.088-0.207-3.936-0.643c-0.932,0.071-1.664,0.235-2.664,0.27c-0.625,0.026-1.223-0.075-1.475-0.115
					c0.613-0.071,0.693-0.089,0.73-0.299c0.029-0.212,0.254-0.235,0.926-0.304c-0.371,0.017-0.857,0.04-1.232,0.058
					c0.195-0.371-0.729-0.696-0.879-1.052c0.395-0.006,1.008-0.017,1.264-0.086c0.867-0.242-0.637-0.735-2.523-0.686
					c-0.09-0.325-0.006-0.445,0.371-0.55c-0.26-0.068-0.449-0.097-1.055-0.154l-0.182-0.016l0.131,3.271
					c-0.111-0.987-0.256-2.303-0.369-3.29c-0.264-0.026-0.611-0.063-0.879-0.087c0.055-0.06,0.137-0.141,0.197-0.204
					c0.271-0.025,0.637-0.063,0.908-0.089c-0.025-0.123-0.014-0.262,0.018-0.401L1229.251,39.186z"/>
				<path d="M1261.845,42.447c-0.27,0.053-0.604,0.07-1.082,0.058c-0.156-0.005-0.627-0.022-0.863-0.12
					c-0.059-0.029-0.096-0.061-0.119-0.092C1260.331,42.195,1261.737,42.212,1261.845,42.447z"/>
				<path d="M1248.7,42.89c-0.039,0.109-0.158,0.438-1.992,0.394c-0.201-0.008-0.627-0.022-1.145-0.095
					c-0.047-0.003-0.105-0.011-0.15-0.017C1245.917,42.937,1246.966,42.919,1248.7,42.89z"/>
				<polygon points="782.385,51.022 783.22,51.028 783.355,51.209 782.525,51.201 "/>
				<polygon points="784.793,51.511 783.739,51.212 785.012,51.226 "/>
				<path d="M892.957,48.231c-0.213,0.167-0.259,0.301-0.302,0.626c-0.028,0.256-0.064,0.545-0.507,0.735
					c-0.023,0.011-0.064,0.023-0.088,0.031C891.017,49.153,890.564,48.269,892.957,48.231z"/>
				<path d="M891.753,47.382c0.224-0.089,0.926-0.096,1.179,0.115c-0.364,0.021-0.849,0.051-1.208,0.073
					C891.694,47.539,891.59,47.45,891.753,47.382z"/>
				<path d="M892.403,50.833c0.007,0.109,0.111,0.172,0.341,0.276c0.071,0.028,0.178,0.06,0.166,0.1
					c-0.011,0.05-0.283,0.066-0.619,0.087c-0.1-0.021-0.194-0.044-0.277-0.073C891.636,51.094,891.436,50.845,892.403,50.833z"/>
				<path d="M892.579,49.725c0.141,0.109,0.26,0.232-0.047,0.238c-0.276-0.009-0.454-0.063-0.5-0.077
					C891.954,49.86,891.624,49.73,892.579,49.725z"/>
				<path d="M1182.894,44.872l-0.836,0.065c0.063-0.222,0.08-0.301,0.807-0.25
					C1182.874,44.745,1182.88,44.814,1182.894,44.872z"/>
				<path d="M1180.63,44.171c-0.254-0.115-0.701-0.197-0.984-0.31c-0.248-0.092-0.113-0.136,0.221-0.179
					c0.344,0.104,0.154,0.287,0.947,0.322c0.109,0.003,0.217-0.007,0.33-0.007c-0.117,0.109-0.283,0.248-0.408,0.351
					C1180.765,44.32,1180.825,44.251,1180.63,44.171z"/>
				<path d="M1227.351,47.557c-0.398-0.018-0.799-0.035-1.211-0.049c-0.029,0-0.072,0-0.102,0
					c-0.043-0.256,0.275-0.267,1.361-0.178C1227.368,47.404,1227.376,47.479,1227.351,47.557z"/>
				<path d="M1224.237,48.157c-0.057-0.003-0.092-0.018-0.115-0.023c-0.051-0.023-0.082-0.04-0.094-0.061
					c-0.029-0.095,0.141-0.246,0.318-0.215C1224.581,47.903,1224.499,48.145,1224.237,48.157z"/>
				<path d="M1221.86,46.927c0.424,0,0.77-0.085,1.223-0.054c0.078,0.52,0.086,0.54-0.328,0.629
					c-1.426-0.038-1.889-0.167-1.957-0.19c-0.236-0.079,0.148-0.108,0.318-0.12c0.111,0.029,0.381,0.109,0.66,0.115
					C1222.177,47.314,1222.478,47.141,1221.86,46.927z"/>
				<path d="M1212.958,47.318c-0.104,0.006-0.502,0.022-0.801-0.08c-0.023-0.009-0.047-0.023-0.072-0.029
					c0.813-0.097,1.158-0.31,1.959-0.408c0-0.028-0.006-0.063-0.012-0.092c1.52,0.092,2.145,0.251,2.557,0.356
					c-0.033-0.299,0.377-0.281,3.006-0.187c0.223,0.006,0.436,0,0.65,0.003c0.016,0.184,0.033,0.367,0.059,0.551
					c-2.6-0.098-3.023-0.132-5.779-0.333C1214.009,47.175,1213.585,47.283,1212.958,47.318z"/>
				<polygon points="1214.173,47.909 1212.946,47.875 1212.923,47.694 1214.149,47.729 "/>
				<path d="M1234.448,42.999c0.066-0.095,0.146-0.109,0.293-0.138c0.109,0.049,0.184,0.101,0.254,0.155
					c-0.135,0.086-0.322,0.195-0.457,0.278C1234.509,43.206,1234.472,43.089,1234.448,42.999z"/>
				<path d="M1261.485,45.032c0.184,0.018,0.398,0.012,0.795-0.011c1.752-0.109,1.676,0.079,1.648,0.174
					c-0.373-0.068-0.646-0.079-1.227-0.054c-0.344,0.017-0.711,0.034-1.117-0.08C1261.548,45.053,1261.517,45.038,1261.485,45.032z"/>
				<path d="M1270.438,48.501c-1.025,0.058-1.24-0.028-1.438-0.115c-0.566-0.229-0.289-0.511,0.67-0.7
					c-0.025,0.077-0.02,0.155,0.203,0.17c0.646,0.009,1.367-0.153,1.943,0.009c0.307,0.089,0.313,0.109,0.307,0.629
					C1271.493,48.44,1271.146,48.461,1270.438,48.501z"/>
				<path d="M1278.456,46.035c-1.088-0.044-1.555-0.141-1.746-0.214c-0.143-0.054-0.154-0.089-0.164-0.134
					c1.334-0.075,2.666-0.029,4.09,0.025C1280.776,46.063,1279.007,46.049,1278.456,46.035z"/>
				<path d="M1280.187,46.91c-0.17-0.114-0.338-0.117-0.711-0.075c-0.295,0.032-0.598,0.055-0.842-0.042
					c-0.006,0-0.275-0.216,0.787-0.278c0.049,0.034,0.189,0.063,0.572,0.135C1280.704,46.778,1280.917,46.854,1280.187,46.91z"/>
				<path d="M1228.817,38.209c0.156,0.248,0.092,0.388-0.713,0.374c-0.152-0.006-0.307-0.012-0.447-0.023
					c-0.021-0.003-0.045-0.006-0.068-0.011c0-0.112,0-0.265-0.006-0.377L1228.817,38.209z"/>
				<path d="M1224.642,37.997c0.658,0.215,0.223,0.229,0,0.227c-0.383-0.015-0.674-0.065-0.754-0.097
					C1223.687,38.06,1223.944,38.015,1224.642,37.997z"/>
				<path d="M1071.159,38.887c-0.07-0.017-0.129-0.031-0.189-0.052c-0.113-0.04-0.119-0.074-0.006-0.097
					c0.262-0.058,1.461-0.04,1.434,0.068C1072.022,38.829,1071.526,38.864,1071.159,38.887z"/>
				<path d="M1001.851,41.099c-0.207-0.227,0.021-0.345,0.734-0.368c-0.006,0.146-0.086,0.305-0.684,0.365
					C1001.89,41.096,1001.868,41.099,1001.851,41.099z"/>
				<path d="M1018.407,42.185c-0.52-0.087-0.613-0.104-0.543-0.256c0.695-0.066,1.285-0.199,2.119-0.184
					c0.652,0.011,1.041,0.148,1.299,0.243c-0.824,0.061-1.402,0.132-1.77,0.31c-0.51,0.245-0.307,0.516-0.461,0.771
					c-0.504-0.021-0.896-0.04-1.205-0.108c-0.324-0.075-0.361-0.17-0.385-0.299c-0.033-0.207-0.105-0.259-0.34-0.365
					c0.148-0.012,0.34-0.018,0.783,0.037c0.207,0.029,0.359,0.074,0.594,0.093c0.146,0.008,0.191-0.013,0.232-0.036
					C1018.946,42.284,1018.536,42.206,1018.407,42.185z"/>
				<path d="M1021.87,39.763c0.336,0.153,0.545,0.204,1.313,0.279c-0.332,0.074-0.508,0.098-0.781,0.095
					c-0.252-0.016-0.393-0.037-0.789-0.21c-0.141-0.061-0.564-0.247-1.484-0.213c-0.02,0.003-0.037,0.003-0.047,0.003
					c-0.602-0.738-0.602-0.738,0.176-0.942c-0.201-0.082-0.219-0.089-0.641-0.131c-0.826-0.087-0.85-0.118-0.82-0.273
					c0.494-0.094,0.908-0.089,1.625,0.023c0.793,0.121,0.961,0.126,1.436,0.132c-0.025,0.339-1.191,0.586-1.398,0.907
					C1021.247,39.533,1021.495,39.594,1021.87,39.763z"/>
				<path d="M1019.833,39.835c0.211,0.071,0.43,0.081,0.643,0.086c0.184,0.003,0.361,0.003,0.527-0.005
					c-0.109,0.344,0.787,0.683,0.211,1.033c-0.119,0.077-0.498,0.311-2.301,0.253c-0.012,0-0.023,0-0.029,0
					c-0.254-0.259-0.254-0.374-0.217-0.66c0.051-0.356-0.027-0.534-0.273-0.856C1019.126,39.651,1019.433,39.702,1019.833,39.835z"/>
				<path d="M1018.782,43.441c-0.131,0.022-0.193,0.029-0.395,0.022c-0.066,0-0.238-0.005-0.428-0.074
					c-0.357-0.133-0.055-0.243,0.324-0.241c0.129,0.032,0.299,0.081,0.428,0.108L1018.782,43.441z"/>
				<path d="M1017.368,40.3c-0.023,0.063-0.225,0.096-0.293,0.106c-0.273,0.043-0.615,0.049-0.896,0.089
					c-0.02,0-0.043,0.006-0.057,0.006c-0.049-0.195-0.756-0.322-1.023-0.488c0.236-0.005,0.736-0.012,1.27,0.023
					C1017.452,40.11,1017.429,40.174,1017.368,40.3z"/>
				<path d="M1016.644,40.875c-0.123,0.021-0.211,0.025-0.393,0.021c-0.072-0.002-0.25-0.005-0.424-0.076
					c-0.084-0.032-0.16-0.061-0.16-0.095c-0.008-0.244,0.688-0.087,0.918-0.034L1016.644,40.875z"/>
				<polygon points="1015.14,43.852 1014.269,43.838 1014.194,43.64 1015.071,43.654 "/>
				<path d="M1014.704,43.936c0.137,0.264-0.146,0.442-0.965,0.617c-0.018,0.006-0.047,0.009-0.066,0.014
					C1013.71,43.995,1013.71,43.936,1014.704,43.936z"/>
				<path d="M1030.767,39.995c0.545,0.021,0.688,0.023,1.184,0.09c0.531,0.065,0.934,0.175,1.449,0.246
					c-0.166,0.342,0.33,0.688,0.018,1.034c-0.195,0.212-0.885,0.296-1.252,0.342l-0.904-0.109
					C1031.142,41.063,1030.876,40.529,1030.767,39.995z"/>
				<path d="M1164.694,49.488c0.627,0.006,1.371,0.058,1.359,0.302c-0.111,0.01-0.213,0.01-0.324,0.01
					c-0.123-0.006-0.354-0.013-0.537-0.087C1165.003,49.644,1164.966,49.552,1164.694,49.488z"/>
				<polygon points="1036.931,37.761 1036.585,37.939 1035.651,37.739 "/>
				<path d="M1019.396,37.448c2.088-0.151,2.088-0.151,2.973-0.146c0.061,0.139,0.398,0.253,0.514,0.391
					c-0.67,0.068-0.787,0.081-1.057,0.419c0.43,0.013,0.93,0.018,1.381,0.029c-0.838,0.04-1.643,0.092-2.355,0.184
					c-0.117-0.068-0.264-0.16-0.375-0.235C1019.608,37.63,1019.608,37.63,1019.396,37.448z"/>
				<path d="M892.744,44.868c0.041,0.01,0.095,0.021,0.129,0.032c0.526,0.126,0.377,0.2-0.07,0.195
					c-0.224-0.003-0.335-0.026-0.372-0.04C892.272,45.009,892.379,44.946,892.744,44.868z"/>
				<path d="M982.11,47.422c1.496,0.025,3.055,0.052,4.58,0.08c-3.355-0.052-6.742-0.104-10.16-0.151
					C978.392,47.372,980.192,47.398,982.11,47.422z"/>
				<path d="M792.203,51.678c-1.473-0.092-1.473-0.092-1.686-0.156c-0.16-0.054-0.183-0.114-0.2-0.149
					C791.525,51.367,792.073,51.453,792.203,51.678z"/>
				<path d="M789.839,50.253c0.549,0.187,1.067,0.362,0.377,0.38c-0.028,0.002-0.065,0-0.087,0.002
					c-0.025-0.015-0.055-0.022-0.083-0.034c-0.012-0.004-0.024-0.009-0.036-0.012c-0.006-0.003-0.025-0.009-0.035-0.014
					c-0.024-0.007-0.048-0.018-0.071-0.023c-0.018-0.006-0.023-0.012-0.048-0.018C789.338,50.345,789.327,50.264,789.839,50.253z"/>
				<path d="M788.915,49.038c-0.584-0.003-0.879-0.008-1.097-0.065c-0.224-0.063-0.2-0.142-0.166-0.311
					c0.04-0.185,0.083-0.355-1.208-0.298c-0.029-0.038-0.076-0.094-0.071-0.128c0.055-0.204,1.067-0.151,1.08-0.149
					c0.507,0.093,0.642,0.248,0.813,0.498C788.429,48.814,788.537,48.936,788.915,49.038z"/>
				<path d="M785.625,46.101c0.671,0.534,0.459,1.125,1.927,1.611c-0.5,0.238-0.676,0.313-1.219,0.333
					c-0.107-0.003-0.295-0.009-0.531-0.049c-0.012-0.003-0.695-0.155,0.19-0.204c0.541-0.029,0.518-0.043,0.218-0.224
					c-1.48-0.88-1.48-0.88-1.551-0.968c-0.036-0.052-0.06-0.109-0.06-0.161C784.576,46.188,785.341,46.124,785.625,46.101z"/>
				<path d="M783.539,50.385c0.07,0.021,0.14,0.041,0.205,0.063c0.019,0.01,0.043,0.019,0.064,0.023
					c0.343,0.133,0.425,0.235,0.461,0.374c-0.313-0.006-1.145-0.015-1.602-0.154c-0.355-0.115-0.355-0.259-0.343-0.316
					C782.683,50.374,783.173,50.379,783.539,50.385z"/>
				<path d="M760.15,49.3c-0.046,0.08-0.11,0.188-0.165,0.27l-0.447-0.095C759.426,49.325,759.62,49.271,760.15,49.3z"/>
				<path d="M757.416,47.109c0.071,0.034,0.183,0.065,0.171,0.108c-0.019,0.049-0.366,0.072-0.571,0.083
					c-0.106-0.018-0.19-0.046-0.273-0.071c-0.021-0.009-0.058-0.021-0.081-0.026c-0.036-0.018-0.932-0.358,0.448-0.278
					C757.175,46.987,757.285,47.049,757.416,47.109z"/>
				<path d="M756.433,45.762c0.016,0.006,0.029,0.012,0.041,0.018c0.119,0.052,0.111,0.08,0.036,0.167
					c-0.114,0.108-0.12,0.184,0.099,0.32c-0.323,0-0.595,0.047-0.914,0.052c-0.07-0.002-0.141-0.011-0.188-0.022
					c-0.047-0.012-0.072-0.029-0.106-0.04c0.112-0.047,0.059-0.092-0.154-0.207c-0.129-0.081-0.281-0.17-0.224-0.232
					C755.07,45.75,755.913,45.604,756.433,45.762z"/>
				<polygon points="751.604,47.065 751.746,47.249 750.544,47.238 750.401,47.055 "/>
				<path d="M748.988,45.438c0.342-0.161,0.937-0.075,0.943-0.072c0.235,0.04,0.2,0.282-0.795,0.282
					c-0.153-0.007-0.408-0.012-0.609-0.069c-0.036-0.012-0.082-0.035-0.116-0.046C748.734,45.532,748.846,45.504,748.988,45.438z"/>
				<path d="M231.698,43.573c-0.377,0.029-0.672,0.018-1.886-0.092c-0.517-0.052-1.032-0.095-1.58-0.12
					c-0.519,0.212-1.145,0.224-3.364,0.167c-1.311-0.033-1.716-0.013-2.171,0.057c-0.046-0.221-0.11-0.232-0.216-0.253
					c-0.259,0.018-0.342,0.087-0.614,0.098c-0.164,0.007-0.271-0.006-0.399-0.055c0.755-0.428-2.382-0.376-3.313-0.629
					c-0.059-0.02-0.131-0.045-0.178-0.063c0.991,0.009,6.095,0.08,8.7,0.379c0.167-0.063,0.396-0.155,1.379-0.149
					c1.31,0.006,2.523,0.12,3.784,0.173C232,43.255,232.264,43.531,231.698,43.573z"/>
				<path d="M215.066,42.626c-0.024-0.006-0.049-0.012-0.07-0.015c0.67-0.106,1.896-0.036,2.711,0.244
					C216.773,42.821,215.878,42.774,215.066,42.626z"/>
				<path d="M233.991,40.856c0.019-0.022,0.089-0.086,0.63,0.069c-0.059,0.035-0.142,0.072-0.294,0.069
					c-0.094,0-0.165-0.018-0.218-0.038C234.02,40.929,233.985,40.88,233.991,40.856z"/>
				<path d="M724.397,51.169c-0.312,0.407-0.312,0.407,0.579,0.654c-0.426,0.015-0.844,0.032-1.273,0.032
					c-0.343-0.007-0.621-0.021-1.014-0.149c-0.089-0.028-0.165-0.057-0.243-0.089C723.573,51.574,723.343,51.226,724.397,51.169z"/>
				<path d="M719.021,46.565c0.266-0.051,0.408-0.08,0.583-0.08c0.294,0.006,0.513,0.111,0.631,0.172
					c-0.365,0.035-0.683,0.092-1.108,0.096c-0.094-0.004-0.27-0.01-0.395-0.044c-0.078-0.023-0.099-0.045-0.135-0.068
					C718.75,46.617,718.892,46.595,719.021,46.565z"/>
				<path d="M715.272,44.596c1.108-0.068,3.95,0.477,3.147,0.813c-0.177-0.081-0.447-0.201-1.16,0.058
					c-0.237,0.089-0.425,0.146-0.644,0.076c-0.045-0.014-0.082-0.028-0.116-0.045c0.542-0.035,0.471-0.058-0.024-0.139
					c-0.496-0.08-0.572-0.104-0.59-0.16c0.814,0.029,0.973-0.106,1.049-0.173c-0.849-0.08-1.19-0.29-1.932-0.399
					C715.084,44.613,715.168,44.603,715.272,44.596z"/>
				<path d="M715.227,45.848c-0.224,0.044-0.353,0.052-0.577,0.052c-0.685-0.011-1.338-0.201-2.052-0.431
					c-0.017-0.006-0.042-0.012-0.047-0.015C713.858,45.469,714.766,45.604,715.227,45.848z"/>
				<path d="M711.459,51.597c-0.902-0.068-1.921,0.233-2.692,0.006c-0.03-0.009-0.066-0.023-0.095-0.028
					c0.66-0.038,1.249-0.142,1.968-0.135C711.195,51.447,711.359,51.542,711.459,51.597z"/>
				<polygon points="709.614,50 709.786,50.198 708.602,50.185 708.437,49.989 "/>
				<path d="M710.364,50.851c-0.578-0.029-0.684,0.112-1.02,0.169c-0.414-0.06-0.896-0.135-1.239-0.25
					c-0.472-0.16-0.501-0.33-0.517-0.413C709.367,50.296,709.975,50.561,710.364,50.851z"/>
				<polygon points="695.558,44.906 695.481,44.889 695.469,44.797 "/>
				<path d="M635.906,43.55c-3.41-0.034-6.77-0.068-10.103-0.103C629.109,43.481,632.526,43.516,635.906,43.55z"/>
				<path d="M622.226,43.413c-93.73-0.939-157.455-1.608-208.651-2.24C465.42,41.811,529.933,42.488,622.226,43.413z"/>
				<path d="M393.935,18.163c-0.326,0.08-0.985,0.215-1.852,0.215c-0.207-0.005-0.689-0.018-1.096-0.167
					c-0.159-0.06-0.254-0.126-0.343-0.188C390.991,17.962,393.633,17.792,393.935,18.163z"/>
				<path d="M386.625,19.722c0.047,0.216-0.159,0.294-1.408,0.288c-0.59-0.012-1.173-0.034-1.75-0.058
					c-0.491-0.018-0.95-0.034-1.279-0.028c-0.237,0.008-0.501,0.068-0.909,0.165c-0.359,0.09-0.463,0.104-0.825,0.147
					c-0.271,0.031-0.753,0.028-0.955,0.025c-0.194-0.103-0.589-0.166-0.895-0.246c-0.26-0.069-0.294-0.121-0.366-0.219
					c0.573-0.141,1.12-0.253,2.559-0.264c0.83-0.01,2.122,0.063,2.604,0.086C384.863,19.696,385.475,19.704,386.625,19.722z"/>
				<path d="M377.105,17.729c0.56,0,3.383,0.026,4.208,0.435c-1.237,0.299-2.623,0.445-4.113,0.439
					c-0.573-0.018-1.626-0.046-2.712-0.339c-0.118-0.029-0.248-0.074-0.354-0.106C376.021,17.755,376.139,17.729,377.105,17.729z"/>
				<path d="M359.105,19.429c0.565,0.127,0.772,0.219,0.801,0.351c0.048,0.23-0.636,0.425-0.602,0.655
					c-0.335-0.023-1.037-0.072-1.521-0.253C356.358,19.659,358.822,19.449,359.105,19.429z"/>
				<path d="M355.499,21.956c0.306-0.025,0.583-0.005,0.788,0.012c0.089,0.109,0.219,0.259,0.308,0.371
					c-1.179-0.018-1.532-0.026-1.845-0.13c-0.169-0.061-0.218-0.127-0.241-0.172C354.883,22.037,355.167,21.985,355.499,21.956z"/>
				<path d="M317.681,18.074c0.371-0.181,1.144-0.29,1.531-0.466c1.239,0.115,1.416,0.081,3.597-0.327
					c2.233,0.175,3.979-0.2,5.987-0.272c0.862,0.16,1.363,0.416,2.5,0.505c2.976,0.003,2.976,0.003,4.066-0.112
					c0.638,0.156,1.097,0.225,2.052,0.305c0.082,0.232,0.118,0.331,1.145,0.505c0.859,0.149,0.907,0.173,0.753,0.356
					c-1.91-0.045-3.661,0.144-5.517,0.184c-4.417-0.836-4.417-0.836-6.437-0.93c-2.471-0.121-4.079,0.141-4.998,0.382l-1.498-0.026
					c-0.696,0.092-1.138,0.265-1.974,0.311c-0.266,0.017-0.691,0.02-1.255-0.13C317.287,18.266,317.681,18.074,317.681,18.074z"/>
				<path d="M336.017,20.003c-0.342,0.041-0.571,0.052-1.053,0.047c-0.19-0.003-0.578-0.012-1.263-0.074
					c-0.036-0.004-0.082-0.007-0.119-0.013c-0.07-0.052-0.211-0.154,0.095-0.232C334.162,19.61,335.94,19.653,336.017,20.003z"/>
				<path d="M325.686,21.132l-1.196-0.02c-0.065-0.046-0.23-0.167,0.017-0.238
					C324.784,20.796,325.598,20.851,325.686,21.132z"/>
				<path d="M306.424,17.525c0.896-0.339,3.831-0.528,4.797,0.316c-0.401,0.111-1.114,0.232-3.147,0.203
					c-0.33-0.005-1.097-0.022-1.792-0.092c-0.065-0.005-0.141-0.018-0.194-0.022C306.046,17.839,305.988,17.689,306.424,17.525z"/>
				<path d="M298.359,21.04c-0.96,0.405-3.417,0.21-4.279,0.061c-0.076-0.012-0.164-0.029-0.234-0.04
					c1.2-0.489,5.55-0.104,5.592-0.098c0.471-0.447,2.823-0.392,4.296-0.021c-0.782,0.17-1.272,0.21-2.367,0.199
					C300.363,21.118,299.369,21.063,298.359,21.04z"/>
				<path d="M299.799,21.7c-0.596,0.089-0.992,0.112-1.634,0.102c-0.418-0.01-0.818-0.029-1.23-0.047
					c-0.061-0.003-0.142-0.006-0.203-0.008c0-0.015-0.01-0.029-0.01-0.037C296.687,21.33,298.814,21.477,299.799,21.7z"/>
				<path d="M292.384,18.887c0.022-0.241,0.235-0.29,0.736-0.348c0.377,0.127,0.377,0.127,0.189,0.563
					c2.64,0.442,4.768,0.575,9.918,0.908c-0.306,0.356-0.877,0.425-3.217,0.388c-1.551-0.021-1.886,0.008-2.434,0.071
					c-1.739-0.45-4.62-0.574-6.118-1.097c-0.101-0.035-0.213-0.084-0.302-0.115C292.207,19.24,292.349,19.165,292.384,18.887z"/>
				<path d="M290.909,19.943c0.531,0.049,0.813,0.055,1.087-0.038c0.353,0.294-0.501,0.371-1.063,0.369
					c-0.689-0.021-1.049-0.127-1.196-0.186c-0.1-0.039-0.165-0.086-0.207-0.129C289.685,19.929,290.003,19.86,290.909,19.943z"/>
				<path d="M254.203,18.731c-1.157,0.066-1.157,0.066-1.469-0.126c0.862,0.009,1.232-0.028,1.503-0.146
					c-0.112-0.012-0.271-0.023-0.378-0.034c-1.461-0.173-4.833-1.615,1.12-1.987c0.2,0.06,0.483,0.144,0.784,0.178
					c0.951,0.103,2.046,0.081,3.012,0.173c0.802,0.074,1.302,0.252,2.145,0.314c0.241,0.019,1.273,0.006,0.861-0.255
					c-0.294-0.188-1.313-0.154-1.746-0.301c1.05,0.054,2.335-0.179,3.183,0.108c1.433,0.482,1.433,0.482,2.859,0.514
					c1.893,0.026,3.766-0.111,5.67-0.031l4.426,0.311c0.448,0.04,0.53,0.08,0.673,0.154c-1.852,0.107-2.77,0.165-7.026,0.098
					c-5.199-0.08-8.954-0.135-10.845,0.293c1.201,0.164,2.77,0.123,3.865,0.351c-0.118,0.265-0.955,0.472-1.201,0.729
					c-1.828-0.061-3.29-0.365-5.164-0.399c-0.877-0.018-0.885,0.199-1.439,0.271c-0.194-0.026-0.341-0.071-0.482-0.112
					c-0.131,0.028-0.325,0.058-0.461,0.086l0.431,0.189c3.62,0.109,7.256-0.017,10.882,0.035c0.029-0.193,0.052-0.201,0.718-0.448
					c2.428,0.143,2.428,0.143,2.965,0.232c-0.143,0.117-0.448,0.227-0.389,0.353c2.179,0.34,7.061,0.408,9.141,0.438
					c7.585,0.108,7.829,0.201,8.464,0.459c-0.548,0.379-2.128,0.228-3.354,0.031c-0.235,0.044-0.235,0.044-3.708,0.204
					c-0.359-0.083-1.114-0.252-2.056-0.259c-1.02-0.011-1.97,0.109-3.002,0.086c-1.691-0.039-3.328-0.16-5.044-0.165
					c-3.908-0.019-7.803-0.075-11.711-0.063c-1.439,0.006-2.005,0.126-2.464,0.224c0.524,0.204,0.524,0.204,1.19,1.025
					c-6.312-0.015-6.312-0.015-7.008-0.046c-0.607-0.405-1.137-0.606-2.352-0.595c-0.012,0.003-0.036,0-0.051,0.003
					c-0.12-0.262,0.876-0.469,0.682-0.738c-0.029-0.037-0.294-0.058-0.429-0.086c-0.759-0.155-0.873-0.264-1.403-0.778
					C250.766,19.32,252.723,19.133,254.203,18.731z"/>
				<path d="M265.036,18.384c-0.144-0.02-0.144-0.02-0.531,0.075c-0.171,0.04-0.248,0.037-0.4-0.018
					c-0.013-0.006-0.023-0.012-0.047-0.021c-0.03-0.017-0.071-0.04-0.101-0.057C264.793,18.252,264.882,18.237,265.036,18.384z"/>
				<polygon points="266.249,27.148 265.742,27.136 265.566,26.958 266.071,26.971 "/>
				<path d="M257.225,23.314c-0.289-0.037-0.619-0.032-1.143-0.02c-0.537,0.011-0.968,0.017-1.243-0.078
					c-0.129-0.043-0.178-0.095-0.224-0.146c0.248,0.063,0.412,0.086,0.712,0.095c0.448,0.006,0.866-0.054,1.327-0.02
					C256.937,23.169,257.119,23.261,257.225,23.314z"/>
				<path d="M252.193,23.119c0.459,0.003,0.872-0.078,1.348-0.043c0.36,0.022,0.524,0.093,0.708,0.178
					c-1.025-0.058-2.251,0.075-3.1-0.155c0.53-0.114,0.2-0.166-0.661-0.275c-0.437-0.057-1.037-0.135-1.357-0.246
					c-0.199-0.075-0.224-0.133-0.234-0.176c1.267-0.043,4.349-0.089,5.463,0.396c-1.032-0.009-1.238,0.039-2.399,0.318
					C252.045,23.116,252.115,23.116,252.193,23.119z"/>
				<path d="M244.902,24.618c0.14,0.123,0.199,0.27-0.326,0.262c-0.064,0-0.122-0.003-0.194-0.003
					c-0.012-0.003-0.023,0-0.03-0.003C244.063,24.621,244.488,24.595,244.902,24.618z"/>
				<path d="M240.834,33.736c0.389,0.017,1.203,0.187,0.706,0.263l-1-0.206
					C240.551,33.771,240.563,33.724,240.834,33.736z"/>
				<path d="M234.28,36.271c-0.189-0.003-0.378-0.008-0.566-0.014c-0.023,0.003-0.061,0-0.082,0
					c-0.083-0.061-0.195-0.146-0.173-0.218c0.065-0.219,1.41-0.023,1.422-0.018C234.893,36.021,235.563,36.291,234.28,36.271z"/>
				<path d="M232.429,29.554c-0.482-0.068-0.884,0.023-0.884,0.023c-0.182,0.047-0.325,0.068-0.501,0.006
					c-0.057-0.02-0.1-0.04-0.146-0.063C231.002,29.479,232.04,29.331,232.429,29.554z"/>
				<path d="M230.041,29.595c-0.124-0.005-0.289-0.052-0.412-0.092c-0.006-0.003-0.025-0.006-0.041-0.012
					c0.283-0.111,0.464-0.089,0.578-0.049c0,0,0.005,0.003,0.011,0.006C230.33,29.522,230.201,29.595,230.041,29.595z"/>
				<path d="M238.169,22.462c-2.533-0.058-3.212-0.075-3.855-0.333c-0.094-0.038-0.175-0.081-0.248-0.121
					C237.639,22.318,237.639,22.318,238.169,22.462z"/>
				<path d="M233.053,18.844c0.152,0.087,0.367,0.197,0.52,0.286l-0.542-0.014c-0.065-0.022-0.143-0.049-0.189-0.072
					C232.488,18.89,232.901,18.857,233.053,18.844z"/>
				<path d="M412.142,41.155c-1.74-0.022-3.47-0.042-5.182-0.063C408.686,41.113,410.386,41.133,412.142,41.155z"/>
				<path d="M192.421,43.723c0.465,0.275-0.391,0.278-0.566,0.275c-0.626-0.024-0.966-0.126-1.099-0.171
					c-0.164-0.064-0.199-0.115-0.228-0.156C191.158,43.688,191.789,43.706,192.421,43.723z"/>
				<path d="M187.258,50.833c-5.389-0.229-8.713-0.551-9.036-0.62c-0.184-0.04-0.361-0.109-0.478-0.161
					c0.602,0.058,0.913,0.063,2.652,0.086C185.399,50.201,186.656,50.626,187.258,50.833z"/>
				<path d="M176.884,41.871c-0.013,0.003-0.024,0.003-0.036,0.008c-0.237-0.413-0.237-0.413-0.118-0.448
					C177.52,41.655,177.172,41.828,176.884,41.871z"/>
				<path d="M168.3,40.831c2.57,0.095,4.51,0.225,7.411,0.497c0.212,0.189,0.169,0.241-0.184,0.235
					c-0.925-0.028-0.925-0.028-0.931,0.08c-0.201-0.138-0.272-0.166-0.708-0.261c-0.171-0.038-0.317-0.078-0.436-0.123
					c0,0.017-0.006,0.037-0.012,0.051c-0.083,0.167-0.667,0.136-0.978,0.115c-0.602-0.029-1.085-0.118-1.657-0.166
					c-0.301-0.026-0.625-0.023-0.924-0.05c-0.095-0.008-0.235-0.022-0.33-0.031c-0.226-0.023-0.484-0.078-0.649-0.12
					C168.672,41.001,168.46,40.903,168.3,40.831z"/>
				<path d="M159,49.386c0.013,0,0.414,0.144-0.154,0.129c-0.435-0.017-1.095-0.126-1.373-0.226
					c-0.04-0.016-0.076-0.029-0.11-0.047C158.318,49.271,158.711,49.282,159,49.386z"/>
				<path d="M150.759,41.776c-0.211-0.006-0.423,0.005-0.634,0.003c-0.078-0.003-0.213-0.009-0.326-0.055
					c-0.052-0.018-0.082-0.04-0.111-0.063C150.006,41.695,150.444,41.742,150.759,41.776z"/>
				<path d="M147.555,41.271c0.129,0.034,0.342,0.16,0.141,0.158c-0.095-0.006-0.2-0.023-0.484-0.106
					c-0.01-0.005-0.034-0.012-0.046-0.018C147.271,41.244,147.401,41.233,147.555,41.271z"/>
				<path d="M151.469,46.873c-1.657,0.037-3.06,0.009-6.143-0.278c-0.094-0.009-0.212-0.022-0.307-0.029
					c-0.27-0.224-0.124-0.241,0.685-0.235c0.104,0.081,0.258,0.19,0.365,0.271c0-0.028-0.012-0.063,0.013-0.086
					c0.027-0.041,0.11-0.092,0.469-0.081c0.744,0.026,1.308,0.161,2.063,0.184c0.554,0.021,1.109,0.003,1.651,0.034
					c0.059,0.006,0.141,0.01,0.199,0.013C151.008,46.701,151.31,46.813,151.469,46.873z"/>
				<path d="M144.358,46.376c0.173,0.081,0.402,0.189,0.579,0.275l-0.425-0.017c-0.071-0.023-0.141-0.049-0.2-0.069
					C143.948,46.416,144.242,46.388,144.358,46.376z"/>
				<path d="M142.213,46.287c0,0,0.801-0.021,0.496,0.192l-0.417-0.012l-0.03-0.014
					C142.014,46.353,142.084,46.302,142.213,46.287z"/>
				<path d="M13.681,51.175c-0.709-0.167-1.836-0.188-2.52-0.358c-0.129-0.035-0.129-0.035-0.824-0.609
					c0.173,0.089,0.406,0.206,0.586,0.298l-0.58-0.367c0.007,0,0.017,0,0.025-0.003c1.083,0.078,0.745,0.391,1.633,0.5
					c0.005-0.009,0.021-0.015,0.033-0.02c0.003-0.006,0-0.006,0.003-0.012c0.042-0.219,0.042-0.219-0.215-0.405
					c0.305,0.181,0.351,0.187,0.486,0.198c0.043-0.012,0.099-0.022,0.144-0.034c0.124-0.006,0.167-0.004,0.35,0.061
					c-0.138-0.102,0.065-0.216-0.229-0.308c-1.068-0.345-1.426-0.281-1.541-0.258c-0.342-0.201-0.769-0.391-1.1-0.587
					c0.068,0.026,0.121,0.058,0.271,0.069c-0.062-0.063-0.177-0.121-0.148-0.189c0.284,0.109,0.349,0.115,0.484,0.123
					c0.062-0.021,0.062-0.021-0.171-0.49c0.499,0.045,0.86,0.178,2.061,0.614c-0.064-0.115-0.489-0.213-0.372-0.339
					c0.019,0.006,0.048,0.011,0.065,0.017c0.333-0.037,1.509-0.092,2.182,0.081c0.169,0.046,0.241,0.112,0.562,0.123
					c0.129-0.026,0.172-0.071,0.359-0.086c0.197,0.049,0.178,0.146,0.596,0.146c0.095-0.029,0.153-0.058,0.243-0.087
					c0.812,0.013,1.003,0.214,1.635,0.282c0.043-0.012,0.1-0.023,0.148-0.034c0.032,0.006,0.076,0.006,0.102,0.006
					c0.238,0.074,0.551,0.181,0.789,0.255c0.359,0.072,0.721-0.063,1.081,0c0.442,0.078,0.731,0.192,1.255,0.247
					c0.032,0.003,0.076,0.009,0.108,0.015c0.478,0.034,0.749-0.108,1.228-0.069c0.359,0.026,0.283,0.155,0.745,0.161
					c0.118-0.029,0.182-0.066,0.28-0.098c1.014-0.021,1.603,0.414,2.579,0.221c0.421,0.178,0.667,0.259,1.09,0.358l-0.217-0.258
					c0.891,0.322,2.253,0.557,3.094,0.887c0.009-0.005,0.03-0.014,0.043-0.02c0.027,0,0.069-0.005,0.095-0.005
					c0.189,0.008,1.598,0.364,1.23,0.474c-0.104-0.015-0.234-0.035-0.65-0.225c0.189,0.17,0.218,0.218,0.142,0.265
					c-0.042,0.003-0.099,0.011-0.142,0.008c-0.423-0.017-0.602-0.117-0.989-0.148c-0.602-0.05-1.163,0.086-1.767,0.018
					c-0.638-0.07-1.007-0.288-1.937-0.199c-0.194-0.021-0.2-0.022-0.402-0.083c0.131,0.133,0.122,0.138,0.052,0.192
					c-0.178,0.009-0.21,0.006-0.69-0.089c-0.227-0.043-0.462-0.086-0.715-0.12c-0.347-0.047-0.626,0.079-0.976,0.02
					c-0.427-0.071-0.418-0.221-0.972-0.271c-0.093,0.035-0.255,0.09-0.9,0.016c-0.093-0.013-0.218-0.029-0.304-0.041
					c-0.761-0.108-1.391-0.258-2.169-0.355c-0.391-0.052-0.649-0.069-1.179-0.046c-0.817,0.028-1.213,0.005-2.175-0.38
					c0.136,0.086,0.312,0.201,0.449,0.285c-0.804-0.182-1.268-0.182-1.375-0.006c-0.246-0.164-0.186-0.348-0.544-0.509
					c-0.489-0.02-0.271,0.118-0.017,0.278c-0.054,0.204-0.051,0.207,0.783,0.54l-0.252-0.244c0.498,0.253,1.243,0.472,1.58,0.738
					c-0.154-0.012-0.154-0.012-0.938-0.29c0.175,0.123,0.599,0.227,0.582,0.367c-0.383-0.152-0.52-0.189-0.696-0.218
					c-0.029,0.006-0.068,0.009-0.09,0.011c-0.019,0.029-0.025,0.053-0.012,0.078c-0.258-0.152-0.673-0.29-1.017-0.434
					c0.064,0.154,0.432,0.296,0.354,0.457c-0.249-0.149-0.332-0.308-0.709-0.445c-0.049,0.003-0.113,0.006-0.164,0.006
					C13.463,50.963,13.611,51.068,13.681,51.175z"/>
				<path d="M9.453,49.65c-0.079-0.023-0.271-0.075-0.472-0.081c-0.247-0.006-0.465-0.04-0.908-0.212
					c-0.391-0.152,0.272-0.351,0.303-0.359c0.237,0.118,0.564,0.227,0.836,0.342c-0.081-0.063-0.216-0.173-0.131-0.198
					c0.093-0.025,0.363,0.043,0.363,0.043c0.175,0.058,0.297,0.144,0.427,0.204c0.118,0.078,0.24,0.152,0.291,0.235
					c0.034,0.049-0.06,0.092-0.051,0.142c-0.375-0.122-0.629-0.254-1.003-0.374C9.212,49.47,9.35,49.569,9.453,49.65z"/>
				<path d="M6.841,49.167c0.021,0.007,0.039,0.012,0.077,0.018c0.241-0.04-0.142-0.092-0.027-0.144
					c0.122,0.012,0.177,0.055,0.641,0.391c-0.192-0.034-0.299-0.058-0.5-0.155C6.962,49.242,6.903,49.205,6.841,49.167z"/>
				<polygon points="6.986,49.328 6.759,49.282 6.452,49.093 6.685,49.136 "/>
				<path d="M1.473,45.917c-0.004,0-0.007,0-0.007,0c-0.127-0.075-0.268-0.149-0.341-0.229
					c-0.027-0.029-0.013-0.04,0.043-0.032C1.18,45.658,1.859,45.899,1.473,45.917z"/>
				<path d="M0.788,45.79c0,0-0.003,0-0.008,0c-0.143-0.034-0.186-0.08-0.262-0.12c-0.072-0.037,0.003-0.052,0.003-0.052
					C0.6,45.618,0.841,45.773,0.788,45.79z"/>
				<path d="M3.806,37.652c0.229,0.074,0.297,0.08,0.57,0.115c0.175,0.006,0.24,0.012,0.477,0.103
					c-0.201,0.006-0.191,0.081-0.439,0.069c-0.04,0-0.151-0.012-0.313-0.098C3.979,37.781,3.892,37.716,3.806,37.652z"/>
				<path d="M3.845,37.805c-0.122-0.015-0.23-0.041-0.524-0.21c-0.013-0.002-0.016-0.005-0.021-0.012
					C3.517,37.614,3.649,37.632,3.845,37.805z"/>
				<path d="M2.946,37.856c-0.05-0.009-0.08-0.015-0.116-0.025c-0.071-0.021-0.253-0.162-0.155-0.213
					c0.056-0.035,0.188-0.015,0.3,0.04C3.049,37.698,3.124,37.87,2.946,37.856z"/>
				<path d="M1.74,37.756c-0.145-0.098-0.445-0.308-0.345-0.33c0.003-0.003,0.377,0.008,0.613,0.227
					c0.075,0.074-0.044,0.061-0.137,0.052c-0.104-0.015-0.203-0.025-0.147,0.035C1.728,37.744,1.737,37.75,1.74,37.756z"/>
				<polygon points="1.942,37.546 2.241,37.587 2.509,37.784 2.206,37.741 "/>
				<path d="M19.511,41.046c0.002-0.005,0.012-0.005,0.504,0.139l0.646,0.028l-0.003,0.04
					c0.084-0.037,0.197-0.086,0.289-0.12c0.185,0.066,0.442,0.149,0.625,0.212l-0.525-0.051l-0.388-0.041l-0.002,0.029l-0.266-0.04
					c-0.004-0.003-0.004-0.003-0.007-0.006c-0.002,0-0.002-0.003-0.012-0.003c0-0.003,0-0.003-0.017-0.015h-0.291l-0.224-0.052
					L19.511,41.046z"/>
				<path d="M30.671,45.263c0.013,0,0.031-0.003,0.05-0.007c0.362,0.058,0.332,0.178,0.758,0.219
					c0.026-0.046,0.051-0.109,0.073-0.157l0.918,0.335c0.101,0.023,0.28,0.023,0.356,0.052c0.136,0.058,0.322,0.185,0.366,0.247
					c-0.003,0.003-0.017,0.006-0.023,0.009c-0.209-0.065-0.288-0.152-0.562-0.21c0.008,0.069,0.013,0.163,0.022,0.235
					c-0.524-0.052-0.989-0.166-1.996-0.427c-0.07,0.06-0.208,0.188-1.243,0.117c-0.473-0.035-0.473-0.035-1.184-0.29
					c-0.308-0.044-0.504-0.008-0.695,0.031c-0.437,0.087-0.745,0.098-1.321-0.058c-0.258-0.068-0.228-0.338-0.147-0.396
					c0.221-0.173,0.806-0.121,1.026-0.102c0.289,0.026,0.289,0.026,0.99,0.279l0.066-0.161c0.702-0.034,1.067,0.052,2.607,0.425
					C30.691,45.357,30.604,45.313,30.671,45.263z"/>
				<path d="M34.776,46.692c0.523,0.08,0.847,0.224,1.217,0.401c-0.4-0.08-0.784-0.131-1.456-0.144
					c-1.367-0.017-1.96-0.224-2.435-0.385c0.127,0.086,0.295,0.201,0.423,0.288c-0.24-0.058-0.29-0.061-0.472-0.063
					c-0.212,0.055-0.248,0.16,0.182,0.58c-0.036,0-3.727,0.091-5.779-0.517c0.011,0.034,0.031,0.068-0.036,0.097
					c-0.09,0.047-0.339,0.023-0.682-0.14c-0.159-0.072,0.144-0.133,0.127-0.204c-0.035-0.086-0.34-0.179-0.375-0.19
					c-0.305-0.089-0.351-0.114-0.574-0.275c0.38-0.141,0.389-0.144,1.065-0.132c0.791,0.015,1.377,0.145,2.115,0.187
					c0.583,0.034,0.642,0.021,0.838-0.031c0.065-0.018,0.132-0.034,0.249-0.034c0.049,0,0.11,0.005,0.16,0.011
					c0.344,0.021,0.98,0.126,1.863,0.271c1.05,0.169,1.384,0.2,1.888,0.25C33.647,46.692,34.246,46.611,34.776,46.692z"/>
				<polygon points="33.488,45.831 33.745,45.856 34,46.031 33.748,46.009 "/>
				<path d="M36.299,46.893c0.343,0.007,0.491,0.034,0.672,0.13c-0.205-0.015-0.386,0.04-0.594,0.009
					c-0.143-0.023-0.289-0.071-0.493-0.17c-0.017-0.008-0.036-0.017-0.052-0.026C35.958,46.864,36.133,46.879,36.299,46.893z"/>
				<path d="M35.887,46.055c0.162,0.043,0.286,0.055,0.4-0.026c0.033-0.022,0.079-0.04,0.236,0.026
					c0.334,0.138,0.049,0.195-0.082,0.187c-0.164-0.02-0.382-0.111-0.504-0.166C35.925,46.069,35.906,46.06,35.887,46.055z"/>
				<path d="M39.695,48.699c0.012,0,1.546,0.061,1.913-0.06c2.234,0.398,6.866,0.906,9.39,0.775
					c0.283,0.063,0.235,0.178,0.666,0.223c0.99,0.102,2.104,0.073,3.109,0.156c0.821,0.068,0.821,0.068,6.81,0.37
					c4.703,0.238,4.703,0.238,4.952,0.31c0.512,0.152,0.37,0.343-0.249,0.322c-9.654-0.658-10.167-0.663-11.129-0.163
					c1.262,0.143,1.84,0.255,2.69,0.524c-0.767-0.105-0.767-0.105-1.145-0.252c0.101,0.055,0.189,0.105,0.26,0.16
					c-0.046,0.006-0.118,0.015-0.159,0.021c-0.089-0.009-0.218-0.023-0.325-0.028c-0.029,0.008-0.076,0.02-0.112,0.028
					c0.019,0.014,0.042,0.034,0.053,0.046c-0.849-0.029-1.496-0.093-3.439-0.311c-1.845-0.206-1.988-0.201-2.692-0.172
					c-0.544,0.021-0.693,0.018-1.057-0.012l-6.016-0.497c-0.9-0.083-1.723-0.209-2.71-0.235c0.006,0.026-0.019,0.061-0.052,0.084
					c-0.007-0.003-1.736-0.195-1.763-0.199c-0.53-0.051-1.125-0.008-1.663-0.054c-1.103-0.096-1.986-0.282-3.08-0.382
					c-0.571,0.105-0.958-0.112-1.184-0.316c0.153-0.048,0.24-0.071,0.988,0.021c1.655,0.201,1.686,0.055,1.529-0.213
					c-1.458-0.247-3.312-0.296-4.883-0.488h-0.002c0,0-0.401-0.152-0.177-0.296c0.4-0.031,0.522-0.043,1.45,0.049
					C31.706,48.113,39.518,48.691,39.695,48.699z"/>
				<path d="M37.09,46.95c0.365,0.081,0.518,0.047,0.53,0.044c0.146-0.038,0.238-0.026,0.51,0.134
					c-0.185,0.029-0.3,0.023-0.397,0.019c-0.095-0.006-0.289-0.029-0.592-0.173C37.125,46.968,37.1,46.956,37.09,46.95z"/>
				<path d="M40.732,47.203l0.388,0.189c-0.221-0.022-0.329-0.034-0.473-0.097c-0.081-0.038-0.136-0.075-0.182-0.115
					C40.541,47.186,40.647,47.198,40.732,47.203z"/>
				<path d="M40.706,43.301c0.042,0.029,0.095,0.065,0.137,0.095c0.118,0.052,0.234,0.104,0.351,0.152
					c0.037,0.021,0.153,0.031,0.097,0.055c-0.073-0.012-0.484-0.163-0.616-0.224c-0.019-0.013-0.038-0.018-0.056-0.029
					C40.487,43.28,40.597,43.292,40.706,43.301z"/>
				<path d="M41.313,47.977c0.227,0.157,0.327,0.258,0.07,0.24c-0.023-0.002-0.04-0.002-0.062-0.002l-0.006-0.004
					c-0.123-0.083-0.283-0.189-0.403-0.27L41.313,47.977z"/>
				<path d="M42.217,48.307c-0.043-0.01-0.073-0.021-0.114-0.026c-0.082-0.012-0.257-0.141-0.143-0.187
					c0.076-0.028,0.293-0.028,0.389,0.054C42.034,48.131,42.537,48.323,42.217,48.307z"/>
				<path d="M47.543,48.415c0.857,0.104,1.674-0.092,2.531-0.017c0.613,0.058,1.04,0.16,1.654,0.347
					c0.507-0.268,0.507-0.268,1.143-0.231c-0.648-0.395-0.648-0.395-0.521-0.445c0.255,0.014,0.557,0.031,0.625,0.267
					c0.095,0.327,0.575,0.342,1.523,0.364c2.388,0.063,2.388,0.063,2.664,0.106c0.071,0.012,0.165,0.025,0.236,0.038
					c0.401,0.065,0.767,0.157,1.062,0.235c-0.195-0.13-0.497-0.248-0.684-0.377c1.543-0.044,2.18-0.063,3.542,0.166
					c0.884-0.326,2.404-0.003,3.601-0.003c1.061-0.315,2.229,0.238,3.418,0.313l0.188-0.157c0.347-0.007,0.577,0.074,0.938,0.061
					c0.207,0.111,0.49,0.261,0.689,0.372c0.566,0.104,1.338,0.098,1.898,0.202c0.424,0.074,0.748,0.215,1.002,0.327
					c-3.365,0.115-6.731-0.089-12.401-0.747c-0.259,0.275-1.349,0.132-2.204-0.075c-0.072,0.047-0.165,0.104-0.431,0.104
					c-0.131,0-3.729-0.087-4.009-0.102c-1.406-0.071-1.406-0.071-2.277-0.333l-0.305,0.13c-2.083,0-3.561-0.334-5.348-0.497
					c-0.079-0.008-0.187-0.015-0.266-0.023c-0.076-0.146-0.056-0.151,0.089-0.215c0.062-0.006,0.138-0.011,0.194-0.011
					C46.69,48.236,47.043,48.357,47.543,48.415z"/>
				<path d="M46.358,44.579c0.037-0.047,0.639,0.043,0.642,0.045c0.008,0,0.413,0.21,0.129,0.196
					c-0.232-0.023-0.544-0.115-0.701-0.184C46.39,44.619,46.347,44.603,46.358,44.579z"/>
				<path d="M48.354,44.97c0,0,0.464-0.037,0.445,0.206l-0.289-0.025l-0.027-0.015
					C48.274,45.038,48.271,44.986,48.354,44.97z"/>
				<path d="M56.873,46.175l-0.558-0.293l-0.414-0.103c0.153-0.006,0.271-0.014,0.389-0.071
					c0.106-0.053,0.118-0.058,0.236-0.056c-0.3-0.161-0.718-0.315-0.955-0.481c0.224,0.039,0.513,0.097,0.731,0.137
					c-0.095,0.087,0.042,0.155,0.401,0.29c0.364,0.147,0.542,0.228,0.66,0.356C56.938,46,57.386,46.195,56.873,46.175z"/>
				<path d="M58.229,47.585c-0.243,0.043-0.383,0.058-0.596,0.043c-0.106-0.005-0.294-0.022-0.518-0.12
					c-0.083-0.034-0.218-0.068-0.172-0.118C57.051,47.272,57.799,47.425,58.229,47.585z"/>
				<path d="M55.718,45.839l0.418,0.199c-0.399-0.05-0.399-0.05-0.519-0.096c-0.089-0.04-0.148-0.083-0.199-0.123
					C55.513,45.825,55.629,45.831,55.718,45.839z"/>
				<path d="M56.195,48.433c-0.212,0.034-0.367,0.058-0.59,0.042c-0.129-0.008-0.306-0.036-0.513-0.129
					c-0.064-0.028-0.123-0.057-0.169-0.091C55.17,48.177,55.624,48.239,56.195,48.433z"/>
				<path d="M54.318,45.325c-0.229-0.187-0.135-0.267-0.104-0.29c0.047-0.031,0.236-0.105,0.743,0.178
					C54.767,45.245,54.512,45.291,54.318,45.325z"/>
				<path d="M54.893,48.49c-0.006,0-0.006,0-0.012,0.003c-0.227-0.124-0.529-0.244-0.679-0.377
					c0.125,0.01,0.288,0.023,0.411,0.031C54.798,48.271,54.993,48.427,54.893,48.49z"/>
				<path d="M54.448,48.545c-0.017-0.016-0.261-0.142-0.442-0.204c-0.143-0.047-0.235-0.058-0.264-0.023
					c-0.003,0-0.003,0.003-0.003,0.006c-0.08-0.058-0.257-0.201-0.224-0.247c0.029-0.04,0.175,0,0.297,0.04
					C54.135,48.223,54.847,48.564,54.448,48.545z"/>
				<path d="M53.862,45.813c-0.302,0-0.348-0.068-0.546-0.104c-0.185-0.022-0.158,0.04-0.109,0.121
					c-0.476-0.123-0.653-0.155-1.09-0.207c-0.178-0.018-0.352-0.041-0.51-0.068c-0.184-0.033-0.184-0.033-0.464-0.534
					c0.24,0.132,0.378,0.178,0.59,0.2c0.135,0.007,0.249-0.006,0.365-0.017c0.296-0.034,0.546-0.058,0.915,0.023
					c0.099,0.021,0.891,0.419,0.955,0.487C53.968,45.716,54.012,45.816,53.862,45.813z"/>
				<path d="M59.354,45.256c0.195,0.078,0.195,0.078,0.661,0.466c1.036,0.052,1.905,0.209,2.953,0.259
					c0.542,0.028,0.767-0.034,0.913-0.075c0.348,0.115,1.557,0.66,1.179,0.824c-0.23-0.083-0.623-0.135-0.896-0.212
					c-0.129-0.032-0.141-0.106-0.317-0.124c-0.319-0.038-0.749-0.018-1.31,0.052c-0.949,0.12-1.603-0.034-2.192-0.201
					c-0.036,0.152-0.219,0.155-0.801,0.006c-0.543-0.136-0.795-0.17-0.967-0.133c-0.012,0-0.019,0.003-0.03,0.007
					c-0.431-0.362-0.431-0.466,0.454-0.457C59.826,45.672,59.872,45.612,59.354,45.256z"/>
				<path d="M81.659,46.273c1.366,0.074,2.569,0.241,3.92,0.315c1.219,0.068,2.517-0.029,3.7,0.092
					c0.061,0.005,0.136,0.018,0.195,0.023c0.459,0.06,0.684,0.178,1.143,0.235c0.596,0.074,1.314,0.068,1.91,0.146
					c0.16,0.02,0.355,0.052,0.502,0.077c0.642,0.117,1.09,0.311,1.525,0.488c-2.31,0.02-4.444-0.184-6.672-0.27
					c0.307,0.215,0.229,0.231,0.07,0.264c-0.519-0.018-0.942-0.104-1.478-0.114c-1.021-0.029-2.059,0.022-3.079-0.023
					c-1.691-0.075-4.078-0.247-4.096-0.247c-0.435-0.038-0.318-0.138-0.448-0.206c-0.371-0.217-0.441-0.241-0.708-0.282
					c-0.183,0.072-0.183,0.072-1.591-0.265c-0.418,0.081-0.34,0.265-1.108,0.271c-0.405-0.172-1.172-0.496-0.86-0.675
					c0.201-0.112,1.15-0.173,2.322,0.336c-0.164-0.142,0.272-0.271,0.189-0.408c0.83,0.178,1.416,0.213,2.43,0.136
					c0.742-0.058,1.154-0.055,1.626,0.021c-0.013,0.017-0.037,0.045-0.055,0.068C81.293,46.259,81.481,46.267,81.659,46.273z"/>
				<path d="M108.452,49.478c3.531,0.281,4.551,0.265,5.045,0.259c-0.082-0.061-0.189-0.135-0.271-0.192l0.767,0.284
					c0.423-0.104,0.423-0.104,1.862,0.08c0.106-0.054,0.354-0.184,1.097-0.108c3.159,0.299,3.478,0.428,3.896,0.585
					c0.172-0.022,0.69-0.095,1.728-0.017c1.19,0.092,2.205,0.275,3.466,0.327c0.412,0.014,0.83-0.038,1.238,0.006
					c0.307,0.028,0.565,0.163,0.701,0.228c-0.885-0.053-1.775-0.09-2.681-0.125l-7.438-0.235c-0.778-0.006-0.813,0.127-0.849,0.242
					c1.592,0.247,4.745,0.551,6.795,0.487c1.61-0.055,2.487,0,3.766,0.472c-2.87,0.138-5.577-0.13-8.376-0.173
					c0.083,0.053,0.184,0.121,0.184,0.173c-0.16,0.037-0.412,0.034-0.589,0.063c-0.024,0.052,0.046,0.114,0.11,0.16
					c-9.165-0.367-9.165-0.367-11.021-0.563c-0.243,0.09-0.553,0.112-1.384,0.095c-1.78-0.548-2.152-0.714-2.429-0.962
					c2.57-0.037,5.127,0.333,7.716,0.018c1.066,0.149,1.515,0.216,1.395-0.097c-6.471-0.405-6.871-0.483-8.05-0.704l0.059,0.163
					c-0.118,0.023-0.224,0.047-0.519,0.032c-0.767-0.038-1.239-0.192-1.976-0.238c-0.725-0.044-1.473,0.029-2.198-0.018
					c-0.153-0.008-0.471-0.034-0.86-0.106c-0.046-0.009-0.106-0.02-0.154-0.031c0.685-0.022-0.07-0.241,0.52-0.311
					c0.553,0.204,0.553,0.204,1.309,0.328C102.653,49.174,104.32,49.147,108.452,49.478z"/>
				<path d="M105.747,48.44c0.006-0.014,0.019-0.025,0.041-0.04c0.119-0.055,0.461-0.043,0.825,0.169L105.747,48.44z"/>
				<polygon points="107.74,47.767 108.08,47.783 108.323,47.953 107.981,47.938 "/>
				<path d="M113.581,48.157c-0.006,0-0.184,0.079-0.484-0.023c-0.065-0.026-0.148-0.058-0.2-0.083
					c-0.36-0.17-0.336-0.342,0.235-0.296c0.059,0.08,0.27,0.12,0.589,0.178c0.289,0.052,0.378,0.075,0.167,0.104l-0.508-0.109
					C113.467,47.99,113.64,48.105,113.581,48.157z"/>
				<path d="M126.806,49.345c0.237,0.01,0.556,0.023,0.795,0.029c0.29,0.189,0.07,0.235-0.099,0.235
					c-0.059-0.006-0.212-0.014-0.4-0.089C126.959,49.467,126.876,49.405,126.806,49.345z"/>
				<polygon points="99.516,48.234 99.117,47.95 99.476,47.967 100.059,48.26 "/>
				<path d="M128.599,49.46c0.046-0.011,0.105-0.006,0.165,0c0.2,0.021,0.365,0.052,0.553,0.075
					c0.19,0.155,0.2,0.189,0.16,0.212c0,0-0.005,0.006-0.017,0.006c-0.019,0-0.047,0.006-0.072,0.003
					c-0.224-0.011-0.365-0.055-0.564-0.077c-0.013,0-0.037,0-0.047-0.006C128.675,49.604,128.505,49.483,128.599,49.46z"/>
				<polygon points="129.719,49.546 130.084,49.562 130.696,49.84 130.097,49.816 "/>
				<path d="M136.155,49.92c1.45,0.04,2.806,0.169,4.244,0.224c0.694,0.026,0.955,0.034,1.391,0.023
					c1.826,0.388,4.254,0.603,4.638,0.62c1.256,0.055,1.539,0.126,2.082,0.391c-0.224,0.074-0.525,0.178-2.505,0.026
					c-1.632-0.127-2.116-0.072-2.434,0.065c-0.413-0.178-0.731-0.247-1.403-0.319c-0.107,0.021-0.42,0.078-0.955,0.032
					c-0.632-0.054-1.179-0.149-1.811-0.207c-0.744-0.069-1.539-0.095-2.282-0.166c-0.224-0.018-0.519-0.047-0.736-0.069
					c-0.429-0.043-0.96-0.127-1.278-0.206c-0.36-0.093-0.649-0.248-0.837-0.359C134.604,49.942,135.122,49.892,136.155,49.92z"/>
				<path d="M135.152,49.147c0.129-0.092,0.259-0.083,0.353-0.061c0.178,0.046,0.249,0.166,0.054,0.166
					c-0.1-0.005-0.277-0.063-0.372-0.094C135.177,49.156,135.165,49.15,135.152,49.147z"/>
				<path d="M137.593,49.239c0-0.201,0.247-0.212,1.02-0.146c0.92,0.083,1.114,0.011,1.232-0.023
					c0.095,0.044,0.165,0.075,0.448,0.121c0.413,0.069,0.537,0.106,0.672,0.264c-0.123,0.034-0.237,0.047-0.531,0.037
					c-0.989-0.054-1.708-0.261-2.806-0.255C137.618,49.239,137.605,49.236,137.593,49.239z"/>
				<path d="M141.86,49.395c0.472-0.058-0.106-0.268,0.482-0.262c0.696,0.012,0.272,0.229,0.814,0.282
					c0.26-0.018,0.146-0.087,0.306-0.115c0.307-0.055,0.472,0.149,0.461,0.188c-0.083,0.182-1.615,0.013-2.018-0.079
					C141.895,49.402,141.872,49.397,141.86,49.395z"/>
				<path d="M150.087,51.589c0.437,0.123,0.755,0.33,0.319,0.35c-0.076-0.02-0.152-0.043-0.211-0.066
					C149.912,51.758,149.675,51.594,150.087,51.589z"/>
				<path d="M152.434,51.833c0.402-0.102,0.915-0.006,1.645,0.307c-0.353-0.012-0.943-0.032-1.569-0.272
					C152.488,51.855,152.453,51.844,152.434,51.833z"/>
				<path d="M144.865,51.502c0.019-0.025,0.108-0.046,0.525,0.084c-0.03,0.034-0.077,0.071-0.194,0.068
					c-0.094-0.005-0.142-0.023-0.189-0.041C144.903,51.579,144.854,51.528,144.865,51.502z"/>
				<path d="M145.467,51.5c0.532,0.002,0.968,0.021,1.297,0.223c-0.294-0.008-0.79-0.022-1.272-0.212
					C145.486,51.508,145.473,51.505,145.467,51.5z"/>
				<path d="M148.768,51.93c-0.801-0.04-1.566-0.212-1.891-0.321c-0.053-0.017-0.123-0.046-0.172-0.063
					c0.461-0.086,0.786-0.037,1.369,0.061c0.536,0.092,0.776,0.101,1.219,0.117C149.451,51.907,149.098,51.936,148.768,51.93z"/>
				<path d="M131.375,50.141c-0.042-0.008-0.089-0.021-0.129-0.028c0.27-0.071,0.27-0.071-0.431-0.434
					c0.366,0.025,0.742,0.046,1.12,0.061c0.36,0.014,0.719,0.02,1.072,0.026c0.148,0.16,0.636,0.292,0.837,0.447
					C133.467,50.327,132.058,50.287,131.375,50.141z"/>
				<path d="M72.977,49.374c-0.03,0.004-0.054,0.006-0.083,0.012c-0.012-0.021-0.03-0.046-0.042-0.063
					c-0.135-0.312,1.298-0.038,1.98,0.092c-0.188,0.022-0.305,0.025-0.653,0.002C73.195,49.357,73.195,49.357,72.977,49.374z"/>
				<path d="M73.395,50c0,0-0.011,0-0.024,0c-0.218-0.132-0.276-0.2-0.211-0.241c0,0,0.011,0,0.011-0.003
					c0.059-0.017,0.154-0.025,0.412,0C73.901,49.949,73.831,49.954,73.395,50z"/>
				<path d="M75.304,51.014c0.095,0.009,0.188,0.021,0.294,0.025c0.089,0.006,0.165-0.008,0.254-0.011
					c0.017,0.006,0.047,0.011,0.064,0.017c0.006,0,0.017,0.007,0.023,0.013c0.065,0.034,0.119,0.063,0.165,0.1
					c-0.095-0.006-0.224-0.014-0.319-0.02c-0.07,0.051-0.164,0.126-0.547,0.126c-0.731,0-1.25-0.12-1.87-0.181
					c-0.618-0.061-0.672-0.063-1.048,0.003c-0.265,0.043-0.36,0.052-0.732,0.04c-0.788-0.021-1.496-0.104-2.244-0.155
					c-0.289-0.021-0.602-0.015-0.901-0.028c-0.331-0.018-0.685-0.053-1.122-0.21c-0.129-0.042-0.264-0.109-0.37-0.157
					c0.484-0.061,0.985-0.092,3.084,0.017C71.12,50.654,73.335,50.819,75.304,51.014z"/>
				<polygon points="75.033,49.269 75.35,49.289 75.611,49.467 75.286,49.443 "/>
				<path d="M75.657,49.392c0.224,0.037,0.532,0.086,0.767,0.12c-0.024,0.052-0.082,0.063-0.235,0.058
					c-0.118-0.008-0.237-0.037-0.354-0.086C75.771,49.454,75.706,49.423,75.657,49.392z"/>
				<path d="M82.483,48.532c0.177,0.152,0.376,0.359,0.106,0.354c-0.142-0.011-0.283-0.045-0.425-0.103
					C82.012,48.72,81.6,48.487,82.483,48.532z"/>
				<path d="M83.237,48.731c0.106,0.021,0.212,0.028,0.331,0.034c0.313,0.018,0.483,0.025,0.625,0.195
					c-0.129,0.003-0.424,0.009-0.76-0.133C83.356,48.797,83.297,48.766,83.237,48.731z"/>
				<path d="M88.06,48.607c0.519,0.009,0.743,0.129,1.202,0.164c0.078,0,0.154,0,0.213-0.015
					c0-0.003,0.011-0.005,0.019-0.009c0.004,0,0.01-0.006,0.016-0.009c0.184,0.129,0.507,0.244,0.697,0.371
					c-0.944-0.028-0.991-0.025-1.792,0.08c-0.167-0.08-0.391-0.195-0.555-0.275c0.013,0.04,0.053,0.12-0.036,0.12
					c-0.308,0.015-0.218-0.092-0.482-0.1v0.002c-0.03,0.04,0.035,0.074,0.076,0.112c-0.254-0.038-0.643-0.095-1.426-0.089
					c-0.348,0.006-0.772,0.009-1.416-0.127c-0.051-0.011-0.104-0.022-0.159-0.034c0.66-0.286,1.416-0.23,3.679-0.048
					C88.035,48.702,87.893,48.604,88.06,48.607z"/>
				<path d="M89.886,48.674c0.036-0.006,0.065,0,0.095,0.003c0.329,0.037,1.154,0.456,0.918,0.471
					c-0.129-0.117-0.495-0.207-0.742-0.307C90.027,48.788,89.945,48.731,89.886,48.674z"/>
				<path d="M89.592,50.69c-0.083-0.007-0.283-0.019-0.672-0.122c-0.023-0.006-0.042-0.014-0.059-0.017
					c0.288-0.003,0.689,0.011,0.859,0.068C89.803,50.644,89.846,50.701,89.592,50.69z"/>
				<path d="M88.589,49.954c-0.571-0.068-0.778-0.037-1.156,0.017c-0.01,0-0.034,0.007-0.047,0.007
					c-0.034-0.035-0.116-0.109-0.034-0.161C87.494,49.716,88.111,49.739,88.589,49.954z"/>
				<path d="M86.255,50c-0.07-0.006-0.258-0.017-0.482-0.104c-0.237-0.092-0.213-0.114-0.201-0.126
					c0.072-0.069,0.401-0.072,0.714,0.037C86.868,50.012,86.267,50,86.255,50z"/>
				<path d="M85.212,49.874c-0.241-0.017-0.395-0.08-0.419-0.087c-0.035-0.011-0.059-0.028-0.083-0.045
					c0.177-0.021,0.349-0.102,0.542-0.052C85.294,49.695,85.753,49.896,85.212,49.874z"/>
				<path d="M75.164,47.936c1.997,0.112,3.695,0.391,5.67,0.521c0.224,0.011,0.448,0.019,0.678,0.019
					c0.053,0.095,0.11,0.21,0.053,0.285c-0.154,0.166-0.708,0.103-1.486,0.012c-0.872-0.101-0.872-0.101-3.159-0.115
					c-1.355-0.006-4.992-0.229-7.816-0.413c-1.921-0.127-3.795-0.293-5.752-0.392c-0.482-0.022-0.913,0.064-1.403,0.038
					c-0.218-0.015-0.673-0.066-1.213-0.296c-0.059-0.025-0.136-0.063-0.189-0.089c0.023,0,0.065,0.003,0.095,0.003
					c0.353-0.081-0.025-0.189,0.199-0.275c0.141,0.031,0.141,0.079,0.236,0.115c1.097-0.036,1.645-0.058,5.434,0.209
					c1.473,0.101,2.925,0.224,4.444,0.29C72.339,47.909,73.778,47.858,75.164,47.936z"/>
				<path d="M72.474,49.199c0.154,0.216-0.046,0.227-0.522,0.198c-0.254-0.018-0.502-0.032-0.632,0.025
					c-0.024,0.009-0.035,0.021-0.047,0.029C70.878,49.024,71.314,49.075,72.474,49.199z"/>
				<path d="M54.599,51.718c-0.301-0.023-0.607-0.047-0.906-0.068c-0.021-0.003-0.046-0.007-0.064-0.007
					c-0.087-0.057-0.203-0.132-0.292-0.189c0.322,0.023,0.649,0.052,0.977,0.075C54.399,51.586,54.515,51.663,54.599,51.718z"/>
				<path d="M50.502,51.393c-0.207-0.037-0.343-0.049-0.622-0.021c-0.159,0.019-0.274,0.029-0.487-0.057
					c-0.162-0.069-0.269-0.144-0.38-0.213c0.15,0.023,0.321,0.041,0.495,0.058C49.981,51.172,50.221,51.229,50.502,51.393z"/>
				<path d="M32.645,49.874c-0.055-0.014-0.119-0.04-0.176-0.058c1.271,0.173,2.685-0.051,3.966,0.075
					c0.512,0.051,0.987,0.12,1.527,0.154c1.825,0.121,3.404,0.386,5.27,0.482c0.315,0.018,0.319-0.074,0.495-0.109
					c1.361,0.023,4.315,0.445,4.747,0.639c0.007,0.002,0.342,0.204-0.376,0.148c-2.008-0.172-4.124-0.281-6.095-0.477
					c-0.542-0.052-0.542-0.052-0.712,0.052c-0.08,0.052-0.198,0.046-0.823-0.072c-0.192-0.037-0.359-0.079-0.613-0.1
					c-0.246-0.015-0.501-0.018-0.752-0.023c-1.084-0.023-1.621-0.058-2.565-0.293c-0.164,0.086-0.24,0.109-0.443,0.12
					c-0.655-0.181-1.049-0.24-1.836-0.28C33.702,50.106,33.26,50.072,32.645,49.874z"/>
				<path d="M32.357,51.487l0.517,0.282c-0.013,0.034-0.125,0.063-0.332,0.04c-0.091-0.009-0.163-0.029-0.219-0.047
					c-0.131-0.054-0.143-0.116-0.152-0.149c0.146,0.041,0.342,0.093,0.49,0.13L32.357,51.487z"/>
				<polygon points="32.051,49.92 31.79,49.747 32.253,49.794 32.523,49.971 "/>
				<path d="M31.446,49.13c-0.062,0.052-0.389-0.011-0.737-0.169c-0.024-0.012-0.062-0.028-0.086-0.046
					c0.089,0.028,0.215,0.04,0.337,0.052C31.491,48.983,31.452,49.127,31.446,49.13z"/>
				<path d="M29.688,48.346c-0.05-0.002-0.16-0.017-0.326-0.091c-0.197-0.093-0.326-0.184-0.452-0.281
					c0.109,0.024,0.255,0.027,0.388,0.04c0.166,0.017,0.343,0.045,0.516,0.12C30.259,48.335,29.742,48.354,29.688,48.346z"/>
				<path d="M28.843,48.194c-0.18-0.021-0.359-0.037-0.542-0.058c-0.011-0.003-0.024-0.003-0.039-0.003
					c-0.083-0.058-0.2-0.136-0.28-0.189l-0.006-0.069c0.047,0.023,0.122,0.044,0.208,0.058C28.375,47.97,28.521,48.008,28.843,48.194z"
					/>
				<path d="M25.825,43.324c0.075-0.003,0.127,0.006,0.167,0.02c0.165,0.043,0.152,0.106,0.306,0.155
					c0.202,0.063,0.537,0.098,0.733,0.166c0.209,0.068,0.342,0.149,0.472,0.225c-0.386-0.104-0.658-0.127-1.111-0.101
					c-0.269,0.018-0.513,0.009-0.865-0.083c-0.02-0.007-0.047-0.015-0.067-0.021c0.05-0.12,0.103-0.184,0.575-0.095
					C26,43.502,25.779,43.419,25.825,43.324z"/>
				<path d="M27.477,44.603c-0.118,0.027-0.168,0.036-0.254,0.027c-0.041-0.006-0.132-0.017-0.315-0.103
					c-0.1-0.053-0.189-0.107-0.271-0.161C26.934,44.383,27.194,44.412,27.477,44.603z"/>
				<path d="M25.426,45.276c-0.077-0.014-0.116-0.031-0.15-0.052c-0.015-0.009-0.03-0.015-0.042-0.02
					c-0.025-0.018-0.062-0.038-0.084-0.052c0.02-0.009,0.032-0.018,0.037-0.029c0.047-0.034,0.119-0.068,0.267-0.008
					C25.796,45.26,25.432,45.276,25.426,45.276z"/>
				<path d="M25.329,43.82c-0.143-0.017-0.209-0.048-0.286-0.08c-0.112-0.046-0.305-0.19-0.28-0.238
					c0.04-0.061,0.442,0.006,0.448,0.009C25.225,43.511,25.659,43.849,25.329,43.82z"/>
				<path d="M24.735,42.648c-0.172-0.089-0.3-0.184-0.418-0.275c0.11,0,0.098-0.028,0.135-0.043
					c0.075-0.034,0.24,0.012,0.24,0.012c0.25,0.135,0.457,0.327,0.65,0.465C25.122,42.787,24.978,42.77,24.735,42.648z"/>
				<path d="M24.612,46.244c-0.046-0.022-0.092-0.049-0.127-0.072c0.059,0.016,0.143,0.029,0.231,0.037
					c0.218,0.007,0.356,0.058,0.508,0.204C25.089,46.405,24.88,46.379,24.612,46.244z"/>
				<path d="M24.556,48.634c-0.186-0.029-0.552-0.207-0.656-0.259c-0.013-0.009-0.022-0.011-0.03-0.018
					c-0.024-0.012-0.047-0.022-0.073-0.034c0.262,0.015,0.471,0.052,0.721,0.184C24.784,48.645,24.556,48.634,24.556,48.634z"/>
				<polygon points="24.981,46.698 24.906,46.525 25.449,46.824 25.237,46.801 "/>
				<path d="M25.199,48.708l-0.221-0.026c-0.019-0.008-0.033-0.02-0.053-0.025c-0.16-0.08-0.224-0.141-0.157-0.155
					C24.777,48.501,25.169,48.507,25.199,48.708z"/>
				<path d="M26.109,48.587c0.185,0.133,0.227,0.201-0.082,0.176c0,0-0.604-0.101-0.682-0.129
					C25.192,48.576,25.844,48.569,26.109,48.587z"/>
				<path d="M26.191,48.516c0.879,0.129,1.188,0.29,1.19,0.292c0.022,0.016-0.005,0.09-0.323,0.055
					c-0.067-0.005-0.283-0.034-0.534-0.148C26.381,48.65,26.28,48.585,26.191,48.516z"/>
				<path d="M25.891,41.781l-0.799-0.077l-1.34-0.135l-2.173-0.225c0.758,0.004,1.765,0.007,2.517,0.007
					c0.012,0.077,0.03,0.181,0.041,0.258l1.2,0.117c0.141-0.057,0.325-0.134,0.462-0.194c0.077,0.08,0.177,0.187,0.252,0.265
					L25.891,41.781z"/>
				<path d="M12.622,44.498c-0.491-0.08-1.136-0.1-1.586-0.198c-0.675-0.146-0.989-0.33-1.047-0.364
					c-0.062-0.043-0.121-0.098-0.05-0.138c0.175,0.006,0.249,0.046,0.415,0.051c0.189,0.013,0.363-0.017,0.55-0.011
					c0.055,0.006,0.129,0.009,0.178,0.011c0.122,0.007,0.279,0.021,0.391,0.032c0.739,0.083,1.374,0.198,2.044,0.302
					c-0.015-0.009-0.02-0.028-0.015-0.038c0.003,0,0.704,0.222,0.76,0.359c-0.317-0.022-0.574-0.074-0.869-0.115
					c-0.823,0.139,0.073,0.437,0.33,0.491c0.248,0.05,0.593,0.009,0.866,0.04c0.955,0.112,1.822,0.262,2.783,0.368
					c0.051,0.006,0.126,0.015,0.176,0.02c0.176,0.021,0.351,0.037,0.531,0.052c0.787,0.074,1.459,0.196,2.245,0.271
					c0.233,0.018,0.328,0.022,0.555-0.018c0.141-0.022,0.28-0.046,0.471-0.012c0.386,0.075,0.877,0.316,0.88,0.322
					c0.122,0.077-0.11,0.155-0.024,0.235c-0.528-0.133-0.85-0.155-1.371-0.152c-0.437,0-0.817,0-2.3-0.206
					c-1.23-0.176-2.533-0.316-3.779-0.479c-0.224,0.011-0.264,0.12-0.537,0.085c-0.464-0.057-0.744-0.16-1.154-0.234
					c-0.254-0.041-0.609-0.013-0.863-0.061c-0.169-0.031-0.37-0.12-0.44-0.159c-0.013-0.005-0.944-0.477,0.532-0.24
					c0.579,0.092,0.636,0.052,0.688,0.022C12.98,44.731,13.18,44.596,12.622,44.498z"/>
				<polygon points="8.117,45.205 7.979,45.256 7.74,44.998 "/>
				<path d="M7.734,44.584c-0.092-0.018-0.132-0.036-0.174-0.057c-0.045-0.023-0.083-0.05-0.118-0.074
					c0.038-0.018,0.095-0.041,0.135-0.055l0.03,0.014c0.006,0.003,0.015,0.006,0.021,0.012c0.05,0.029,0.092,0.054,0.127,0.083
					C7.812,44.556,7.829,44.596,7.734,44.584z"/>
				<path d="M7.393,43.74c-0.036-0.012-0.073-0.028-0.101-0.041c0.375-0.042,0.741-0.079,1.268,0.016
					c0.262,0.048,0.262,0.048,0.593,0.33c-0.195-0.037-0.652-0.098-0.744-0.104C8.112,43.921,7.779,43.881,7.393,43.74z"/>
				<path d="M9.288,43.987c-0.254-0.155-0.235-0.179-0.153-0.189c0.07-0.012,0.056-0.028,0.047-0.041
					c0.079,0.05,0.179,0.099,0.204,0.155c0.013,0.023-0.106,0.044-0.104,0.069C9.282,43.984,9.288,43.987,9.288,43.987z"/>
				<path d="M9.45,45.325c0.013,0.012,0.022,0.089-0.319,0.043c-0.176-0.029-0.333-0.077-0.478-0.146
					c-0.004-0.006-0.02-0.012-0.031-0.017C8.864,45.202,9.26,45.193,9.45,45.325z"/>
				<path d="M7.714,41.902c-0.198-0.026-0.207-0.115-0.318-0.16c-0.183-0.07-0.437-0.133-0.606-0.207
					c-0.578-0.247-0.458-0.456,1.034-0.098c0.544,0.132,0.701,0.16,0.81,0.149c0.248,0.114,0.571,0.229,0.897,0.339
					c0.013-0.058,0.022-0.115,0.083-0.173c0.307-0.272,1.166,0.086,1.489,0.218c-0.053-0.042-0.169-0.085-0.096-0.132
					c0,0,0.135-0.078,0.798,0.145c0.265,0.086,0.396,0.131,0.695,0.184c0.414,0.074,0.972,0.06,1.397,0.131
					c0.05,0.003,0.109,0.019,0.146,0.023c0.472,0.102,0.782,0.244,1.077,0.385C14.663,42.706,13.438,42.706,7.714,41.902z"/>
				<path d="M5.8,41.596c-0.167,0.146-1.298-0.296-1.938-0.581c-0.029-0.014-0.075-0.031-0.104-0.043
					c0.162,0.026,0.646,0.121,1.073,0.121c0.184,0.006,0.739,0.008,1.414,0.167c0.114,0.022,0.099,0.079,0.139,0.113
					c0.059,0.05,0.165,0.115,0.251,0.159c0.16,0.084,0.533,0.138,0.564,0.238c0,0-0.006,0.045-0.236,0.017
					c-0.307-0.058-0.515-0.12-1.216-0.378C5.792,41.472,5.877,41.532,5.8,41.596z"/>
				<path d="M6.08,44.814c-0.076,0.04-0.149,0.034-0.227,0.026c-0.056-0.016-0.197-0.038-0.491-0.199
					c-0.022-0.005-0.034-0.018-0.053-0.022c0.031,0.005,0.062,0.011,0.092,0.02c0.218,0.043,0.244,0.015,0.237-0.031
					C5.772,44.671,5.948,44.752,6.08,44.814z"/>
				<path d="M2.525,44.188c0.167,0.008,0.126,0.051,0.167,0.074c0.008,0.003,0.014,0.006,0.02,0.012
					c0.137,0.077,0.251,0.158,0.313,0.241c0.006,0.003,0.01,0.009,0.013,0.012C2.692,44.331,2.5,44.202,2.525,44.188z"/>
				<path d="M2.439,44.412c-0.143-0.029-0.316-0.115-0.411-0.166c-0.087-0.052-0.166-0.099-0.241-0.149
					c0.207,0.068,0.235,0.058,0.293,0.037c0.079-0.021,0.253,0.011,0.408,0.17C2.531,44.344,2.608,44.436,2.439,44.412z"/>
				<path d="M2.835,44.191c0.019-0.009,0.491,0.003,0.755,0.29c0.07,0.08-0.062,0.061-0.132,0.048
					c-0.094-0.017-0.191-0.036-0.286-0.048C3.049,44.458,2.83,44.191,2.835,44.191z"/>
				<path d="M3.024,40.501c-0.275-0.074-0.347-0.213-0.494-0.305c0.029,0.032,0.093,0.101,0.019,0.129
					c-0.084,0.026-0.281-0.002-0.534-0.14c-0.114-0.058-0.2-0.12-0.284-0.185c0.607,0.007,1.192,0.058,1.816,0.049
					c0.227,0.118,0.742,0.411,0.653,0.469c-0.208-0.078-0.347-0.084-0.504-0.018C3.523,40.569,3.296,40.569,3.024,40.501z"/>
				<path d="M1.374,40.317c-0.233-0.103-0.341-0.123-0.513-0.132c-0.272-0.015-0.272-0.015-0.396-0.075
					c-0.069-0.034-0.116-0.065-0.162-0.098c0.242,0.006,0.3,0.069,0.5,0.087c0.279,0.025-0.136-0.139-0.315-0.207
					c0.257-0.029,0.118-0.086,0.201-0.13c0.11-0.054,0.344,0.078,0.765,0.348c-0.05-0.009-0.105-0.021-0.18-0.025
					C1.196,40.104,1.192,40.134,1.374,40.317z"/>
				<polygon points="1.277,39.933 1.463,39.961 1.734,40.156 1.548,40.128 "/>
				<path d="M9.509,41.081c0.095-0.055,0.277-0.149,1.219,0.006c0.022-0.018,0.034-0.041,0.058-0.063
					c0.17-0.139,1.051-0.346,3.024,0.361c0.007-0.021,0.013-0.041,0.046-0.058c0.109-0.055,0.31,0.105,0.419,0.192
					c-0.906-0.037-1.761,0.111-2.674,0.043c-0.283-0.022-0.892-0.104-1.812-0.391C9.706,41.145,9.595,41.11,9.509,41.081z"/>
				<polygon points="15.809,44.475 16.125,44.513 16.404,44.705 16.086,44.665 "/>
				<path d="M17.041,44.545c0.106,0.077,0.238,0.148,0.416,0.218c0.08,0.034,0.19,0.06,0.217,0.098
					c0,0,0.016,0.052-0.106,0.04c-0.565-0.08-0.647-0.242-1.093-0.342c-0.007-0.003-0.025-0.003-0.028-0.009
					c0,0-0.043-0.043,0.051-0.034c0.175,0.022,0.254,0.063,0.402,0.089C17.094,44.639,17.061,44.584,17.041,44.545z"/>
				<path d="M17.908,44.733c0.119-0.037,0.389,0.115,0.386,0.121c0.01,0.04-0.125,0.086-0.175,0.12
					C17.85,44.831,17.85,44.752,17.908,44.733z"/>
				<path d="M22.052,43.41c-0.224-0.063-0.184-0.153-0.334-0.222c-0.141-0.068-0.351-0.126-0.533-0.184
					c0.039,0.04,0.098,0.101,0.033,0.104c-0.261,0.022-0.224-0.077-0.479-0.069c-0.087,0.095,0.233,0.19,0.018,0.288
					c-0.018,0.005-0.049,0.011-0.073,0.017c-0.221-0.126-0.464-0.253-0.639-0.382c0.218,0.046,0.224,0.046,0.353,0.046
					c0.024-0.166-0.442-0.302-0.545-0.462c0.292,0.123,0.451,0.166,0.705,0.2c0.319,0.028,0.624-0.042,0.942-0.006
					c0.249,0.034,0.414,0.081,0.699,0.21c-0.17,0.055-0.192,0.061,0.085,0.23c0.13,0.076,0.38,0.146,0.34,0.232
					C22.581,43.508,22.061,43.413,22.052,43.41z"/>
				<polygon points="22.868,44.986 23.145,45.182 22.896,45.153 22.618,44.961 "/>
				<path d="M23.106,48.398c-0.041-0.018-0.088-0.047-0.164-0.032c-0.108,0.02-0.033,0.054-0.083,0.077
					c-0.015,0.013-0.047,0.015-0.192-0.058c-0.129-0.063-0.132-0.068-0.07-0.1C22.635,48.263,22.792,48.202,23.106,48.398z"/>
				<polygon points="20.889,48.194 20.675,48.165 20.412,47.99 20.628,48.019 "/>
				<polygon points="13.509,47.293 13.803,47.335 14.092,47.524 13.803,47.484 "/>
				<polygon points="13.706,47.474 13.515,47.444 13.219,47.249 13.417,47.277 "/>
				<path d="M13.091,47.396c-0.046-0.006-0.088-0.014-0.122-0.025c-0.231-0.066-0.201-0.187-0.271-0.271
					c0.161,0.081,0.317,0.155,0.424,0.235C13.216,47.41,13.128,47.401,13.091,47.396z"/>
				<path d="M12.329,47.348l-0.174-0.026l-0.027-0.015c-0.212-0.108-0.247-0.16-0.199-0.173
					C11.928,47.134,12.192,47.131,12.329,47.348z"/>
				<path d="M10.422,47.134c-0.072,0.052-0.271-0.011-0.854-0.194C9.543,46.934,9.52,46.922,9.5,46.919
					C9.617,46.778,10.05,47.076,10.422,47.134z"/>
				<polygon points="10.251,46.963 10.528,47.002 10.792,47.181 10.513,47.134 "/>
				<path d="M9.848,50.327c0.312-0.08,1.012,0.354,1.015,0.363c0,0-0.081,0.082-0.365,0.034
					c-0.096-0.021-0.323-0.063-0.722-0.274c-0.079-0.042-0.149-0.082-0.224-0.123C9.677,50.356,9.736,50.351,9.848,50.327z"/>
				<path d="M22.902,52.039c-0.284-0.046-0.55-0.154-0.724-0.241c-0.033-0.018-0.081-0.04-0.115-0.06
					c0.096,0.024,0.342,0.092,0.512,0.048c0.216-0.055,0.483,0.083,0.49,0.086C23.065,51.872,23.351,52.091,22.902,52.039z"/>
				<polygon points="20.941,51.795 21.113,51.82 21.417,52.011 21.235,51.984 "/>
				<path d="M21.321,51.563c0.226,0.126,0.494,0.247,0.673,0.376l-0.297-0.037
					C21.143,51.563,21.275,51.563,21.321,51.563z"/>
				<path d="M37.906,41.179c0.505,0.201,0.53,0.434,0.879,0.643c-0.127-0.011-0.282-0.021-0.508-0.132
					C37.917,41.521,37.578,41.167,37.906,41.179z"/>
				<path d="M39.9,41.756c-0.69-0.126-0.755-0.503-0.624-0.551c0.533,0.129,1.139,0.238,1.633,0.375
					c-0.227-0.097-0.227-0.097-0.204-0.27c0.149-0.006,0.215,0.003,0.431,0.158c0.067,0.054,0.135,0.104,0.258,0.152
					c0.024,0,0.05,0.003,0.075,0.006c-0.325-0.385-0.325-0.385-0.21-0.435c2.843,0.276,2.843,0.276,3.297,0.181
					c-0.2-0.079-0.2-0.079-0.626-0.151c-0.629-0.101-0.923-0.365-0.043-0.327c1.08,0.043,1.889,0.272,1.839,0.399
					c-0.073,0.221,0.896,0.224,0.909,0.227c0.163-0.072,0.174-0.077,0.23-0.244c0.076-0.241,0.129-0.252,0.415-0.291
					c1.559,0.642,1.559,0.642,1.948,0.736c0.029,0,0.059-0.003,0.083-0.003c0.073-0.092-0.308-0.17-0.083-0.259
					c0.026,0,0.071,0,0.098,0.006c0.683,0.098,1.231,0.241,1.932,0.339c0.675,0.098,1.548,0.105,2.093,0.259
					c0.875,0.241,1.053,0.479,0.383,0.517c-0.326,0.021-0.623,0.006-1.147-0.037c-0.016,0-2.254-0.175-3.999-0.204
					c-0.122,0.074,0.115,0.155-0.073,0.229c-0.013,0-0.634-0.014-1.271-0.155c0,0.013,0,0.029-0.005,0.041
					c-0.025,0.085-0.16,0.092-0.201,0.098c-0.095,0.003-0.095,0.003-1.023-0.149c-0.351-0.058-0.539-0.066-0.892,0.086
					c-0.162,0.071-0.342,0.149-0.616,0.138c-0.504-0.025-0.709-0.149-1.179-0.184c-0.731-0.053-1.518-0.012-2.237-0.074
					c-0.314-0.029-0.908-0.081-1.748-0.279c-0.092-0.022-0.207-0.051-0.294-0.074c0.257-0.102,0.395-0.155,0.948-0.009
					C39.882,41.926,39.916,41.842,39.9,41.756z"/>
				<path d="M43.418,41.202c-1.08-0.081-1.08-0.081-1.351-0.196c-0.064-0.031-0.126-0.063-0.181-0.097
					c-0.337-0.201,0.221-0.144,0.86-0.075c0.062,0.007,0.113-0.006,0.168-0.003C43.065,40.943,43.268,41.09,43.418,41.202z"/>
				<path d="M56.391,41.8c0.283,0.108,0.625,0.298,0.264,0.28c-0.065-0.006-0.116-0.011-0.165-0.022
					c-0.012,0-0.022-0.003-0.041-0.006C56.431,41.978,56.408,41.874,56.391,41.8z"/>
				<path d="M68.857,42.426c0.583-0.047,0.718-0.055,1.271-0.029c0.679,0.029,1.594,0.108,2.194,0.16
					c3.007,0.262,3.007,0.262,3.891,0.155c0.246-0.034,0.246-0.034,1.756,0.121c0.258,0.025,0.542,0.046,0.825,0.063
					c3.641,0.138,3.641,0.138,4.761,0.345c-0.2,0.247-0.578,0.305-2.434,0.181c-0.925-0.063-1.879-0.129-2.033,0.023
					c0.053,0.015,0.118,0.034,0.188,0.049c0.319,0.049,0.672-0.083,0.955-0.003c0.301,0.083,0.141,0.272,0.813,0.267
					c0.19-0.005,0.254,0,0.425,0.052c-0.465,0.05-1.238,0.129-2.828,0.053c-1.391-0.069-2.711-0.193-4.079-0.265
					c-3.172-0.173-6.473-0.178-9.625-0.374c-1.079-0.063-1.079-0.063-2.121-0.333c-0.726-0.068-1.622-0.063-2.158-0.224
					c-0.047,0.315-0.047,0.315-0.437,0.305c-0.354-0.253-1.138-0.46-1.65-0.689c-0.013,0.017-0.019,0.046-0.047,0.063
					c-0.201,0.16-0.69,0.028-1.049-0.133c-0.206-0.092-0.359-0.189-0.513-0.286c0.319-0.029,0.849-0.081,1.774-0.05
					c1.726,0.061,3.294,0.256,5.028,0.313c0.966,0.034,2.003-0.141,2.94,0.04C68.066,42.491,68.066,42.491,68.857,42.426z"/>
				<path d="M119.363,45.521c-0.167-0.095-0.207-0.126-0.159-0.189c0.165,0.006,0.389,0.018,0.554,0.023
					c0.377,0.224,0.319,0.286,0.034,0.355c-0.194,0.046-0.283,0.074-0.252,0.161c0.112-0.012,0.159,0.011,0.218,0.028
					c0.16,0.037,0.771,0.247,0.342,0.247c-0.129-0.087-0.501-0.121-0.719-0.187c-0.166-0.05-0.166-0.05-0.395-0.382
					c0.254,0.022,0.429,0.031,0.454,0.003C119.463,45.559,119.399,45.538,119.363,45.521z"/>
				<path d="M120.996,45.621c0.116,0.031,0.211,0.135-0.013,0.126c-0.07-0.002-0.165-0.008-0.412-0.092
					c-0.023-0.005-0.036-0.012-0.047-0.015C120.707,45.59,120.866,45.583,120.996,45.621z"/>
				<path d="M111.812,44.59c0.565,0.296,2.169,0.4,2.583,0.718c-1.204-0.058-2.153,0.302-3.432,0.109
					c-0.019,0.098-0.029,0.181-0.496,0.201c-0.718,0.025-1.26-0.08-1.89-0.127c-0.767-0.058-1.344,0.092-2.059,0.099
					c-0.965,0.006-2.339-0.081-2.886-0.118c-1.793-0.13-2.287-0.106-2.678-0.075c-1.498-0.623-2.604-0.307-2.617-0.301
					c-1.33-0.281-1.861-0.253-3.454-0.166c-0.277-0.153-0.442-0.162-0.742-0.146c-0.165-0.044-0.106-0.102-0.218-0.146
					c-1.409,0.028-1.444-0.316-2.221-0.458c-0.648,0.204-1.416,0.159-2.099-0.129c-0.053-0.022-0.118-0.052-0.165-0.073
					c1.992,0.103,2.587,0.131,2.534-0.303c-1.143,0.028-1.143,0.028-1.509-0.163c1.049-0.003,2.01,0.172,3.1,0.078
					c0.744,0.231,1.179,0.255,1.451,0.068c0.329,0.204,0.437,0.212,0.801,0.175c2.387-0.27,3.512,0.074,3.996,0.218
					c0.235-0.073,0.767-0.097,0.743-0.218c0.271,0.084,0.153,0.207,0.554,0.281c0.437,0.075,0.979,0.058,1.48,0.081
					c2.493,0.097,3,0.092,6.944,0.042C110.269,44.603,111.447,44.711,111.812,44.59z"/>
				<path d="M101.633,46.626l-0.548-0.025c-0.372-0.271-0.106-0.259,0.17-0.245
					C101.367,46.437,101.521,46.549,101.633,46.626z"/>
				<path d="M100.744,46.586c-0.86-0.043-0.86-0.043-0.966-0.086c-0.118-0.046-0.161-0.095-0.207-0.147
					C100.001,46.376,100.354,46.423,100.744,46.586z"/>
				<path d="M83.792,40.596c-0.172-0.012-0.402-0.037-0.66-0.158c-0.049-0.021-0.083-0.039-0.119-0.06
					C83.544,40.433,83.62,40.438,83.792,40.596z"/>
				<path d="M83.539,43.921c-0.619,0.066-0.619,0.066-0.867,0.056c-0.095-0.007-0.376-0.023-0.653-0.145
					c-0.053-0.025-0.101-0.049-0.148-0.075c0.294-0.123,0.442-0.184,1.038-0.126C83.485,43.688,83.343,43.823,83.539,43.921z"/>
				<path d="M122.438,46.06c0.148-0.063,0.608-0.06,0.885,0.128c-0.289-0.007-0.289,0.089-0.572,0.079
					c-0.083,0-0.176-0.008-0.242-0.017C122.38,46.229,122.315,46.109,122.438,46.06z"/>
				<path d="M138.442,40.656c0.389,0.13,0.672,0.305,0.207,0.295c-0.083-0.002-0.16-0.011-0.22-0.02
					c-0.021,0-0.04-0.006-0.046-0.006C138.395,40.843,138.419,40.736,138.442,40.656z"/>
				<polygon points="137.175,40.61 137.415,40.802 136.787,40.776 136.544,40.587 "/>
				<path d="M133.161,45.727c0.776,0.035,1.59,0.019,2.344,0.075c0.131,0.012,0.308,0.023,0.431,0.035
					c1.197,0.094,2.188,0.283,3.413,0.367c0.442,0.028,0.92-0.017,1.351,0.034c0.482,0.06,0.688,0.178,0.891,0.293
					c-3.008,0.025-5.861-0.428-8.942-0.146c0.629,0.106,0.913,0.284,1.513,0.399c-1.731,0.012-3.193-0.33-5.021-0.189
					c-0.296-0.087-0.684-0.207-0.978-0.293c-0.012,0.051-0.036,0.121-0.165,0.132c-0.342,0.037-0.661-0.028-0.997-0.011
					c-0.207-0.408-0.207-0.408-0.96-0.563c0.083,0.092-0.343,0.169-0.143,0.265c0.484,0.04,0.632,0.215,0.672,0.287
					c-0.541,0.071-0.63-0.145-0.972-0.207c-0.748,0.339-3.813-0.546-3.943-0.583c-0.118-0.031-0.271-0.083-0.39-0.117
					c1.049-0.07,2.188-0.023,3.219-0.121c0.755-0.075,0.802-0.099,1.237-0.313c0.083,0.058,0.183,0.133,0.259,0.187
					c0.202,0.026,0.402,0.047,0.615,0.058c0.883,0.025,1.78-0.029,2.663,0.023C130.661,45.414,131.74,45.658,133.161,45.727z"/>
				<path d="M3.131,49.11c-0.158-0.08-0.096-0.178-0.209-0.265c0.2,0.127,0.402,0.255,0.652,0.383
					C3.45,49.185,3.226,49.159,3.131,49.11z"/>
				<path d="M7.618,50.023c-0.021-0.006-0.055-0.012-0.083-0.018c-0.016,0.083,0.197,0.155,0.267,0.235
					c-0.017,0-0.037,0.004-0.051,0.006c-0.529-0.154-0.543-0.355-0.968-0.517c0.021,0.022,0.042,0.055,0.047,0.077
					c-0.021,0.006-0.041,0.012-0.062,0.014c-0.025,0-0.062,0-0.083,0c-0.015,0-0.032,0.007-0.043,0.007
					c-0.399-0.146-0.772-0.276-1.375-0.351c-0.887-0.112-1.464-0.379-1.929-0.592c0.363,0.221,0.356,0.225,0.326,0.271
					c-0.022,0-0.049,0.005-0.07,0.005c-0.003,0.006-0.006,0.013-0.015,0.018c-0.427-0.27-1.022-0.525-1.231-0.813
					c0.064,0.037,0.059,0.083,0.229,0.108c-0.014-0.019-0.049-0.042,0.01-0.06c0.371,0.152,0.533,0.33,1.019,0.468
					c-0.242-0.169-0.237-0.181-0.215-0.215c0.082,0.011,0.156,0.017,0.482,0.146c-0.09-0.106-0.099-0.13-0.005-0.146
					c0.324,0.011,0.408,0.092,0.689,0.118c0.021-0.003,0.042-0.006,0.056-0.01c0.019-0.037-0.073-0.074,0.052-0.108
					c0.614,0.089,1.289,0.362,1.421,0.417c0.323,0.134,0.298,0.295,0.574,0.433c0.178,0.089,0.508,0.149,0.75,0.228
					c0.497,0.154,1.129,0.29,1.513,0.462c0.006,0.006,0.475,0.313,0.292,0.365c-0.05-0.004-0.113-0.01-0.157-0.015
					C8.146,50.356,8.146,50.356,7.618,50.023z"/>
				<path d="M748.988,44.699c-0.571,0-0.655,0.106-0.571,0.252c0.437-0.005,0.857-0.014,1.287-0.021
					C749.464,44.852,749.17,44.786,748.988,44.699z"/>
				<path d="M704.777,42.845c-0.089-0.007-0.196-0.012-0.279-0.018c0.083,0.126,0.202,0.321,1.863,0.311
					c-0.177,0.043-0.418,0.068-0.507,0.126c0.182,0.063,0.477,0.101,0.719,0.149c-0.064,0.137-0.248,0.132-0.754,0.051
					c-0.535-0.079-0.896-0.103-1.25-0.068c-0.053,0.272,0.019,0.511,0.26,0.839l4.728,0.049c-0.873-0.155-1.262-0.325-2.004-0.698
					C706.679,43.141,706.102,42.937,704.777,42.845z M705.305,43.729c-0.051-0.017-0.099-0.034-0.141-0.051
					c0.985,0.028,1.35,0.04,1.35,0.209C705.961,43.878,705.606,43.832,705.305,43.729z"/>
				<path d="M43.472,43.439c0.039-0.061,0.1-0.09,0.326-0.084c0.194,0.006,0.343,0.034,0.503,0.058
					c0.366,0.055,0.604,0.061,1.416,0.086c-0.844-0.066-1.961-0.155-2.806-0.219c0.026,0.006,0.052,0.015,0.073,0.021
					C43.132,43.348,43.273,43.401,43.472,43.439z"/>
				<path d="M52.201,44.183c-0.04-0.069-0.117-0.138-0.07-0.206c-0.27-0.019-0.629-0.047-0.897-0.067
					c0.009,0.003,0.021,0.003,0.026,0.007C51.743,43.998,51.922,44.027,52.201,44.183z"/>
				<path d="M112.01,47.232c-0.072-0.007-0.154-0.01-0.224-0.012c0.052,0.018,0.129,0.034,0.168,0.052
					C112.008,47.255,111.995,47.243,112.01,47.232z"/>
				<path d="M85.101,45.975c-0.129,0.011-0.259,0.017-0.39,0.022l0.62,0.034c-0.07-0.017-0.135-0.031-0.207-0.048
					C85.124,45.983,85.106,45.978,85.101,45.975z"/>
				<path d="M1768.022,29.991c0.105-0.053,0.355-0.173,0.129-0.259c-0.324-0.121-0.982-0.146-1.418-0.241
					c-0.049,0.069-0.107,0.167-0.043,0.253C1766.856,29.957,1767.675,29.979,1768.022,29.991z"/>
				<path d="M1764.958,29.761c0.285-0.154-0.043-0.187-0.83-0.27c0.01,0.018,0.016,0.041,0.025,0.058
					C1764.269,29.687,1764.622,29.735,1764.958,29.761z"/>
				<path d="M1055.021,1.459c0.307,0.126,1.158,0.063,1.242-0.034c0.137-0.139-0.404-0.149-1.299-0.167
					C1054.919,1.304,1054.845,1.39,1055.021,1.459z"/>
				<path d="M1722.964,29.802c0.023-0.044,0.08-0.173-0.701-0.235c-0.385-0.023-0.717-0.018-0.986,0.023
					c-0.012,0.036-0.023,0.074,0.037,0.108C1721.515,29.842,1722.415,29.894,1722.964,29.802z"/>
				<path d="M1044.972,2.685c0.098,0.241,0.088,0.371-0.232,0.531c0.039-0.005,0.078-0.011,0.109-0.018
					c1-0.184,1.418-0.533,1.248-1.045C1044.907,2.234,1044.843,2.372,1044.972,2.685z"/>
				<path d="M1711.175,30.87c0.713,0.006,0.484-0.201,0.131-0.282c-0.09-0.022-0.201-0.039-0.318-0.049
					c-0.096-0.009-0.189-0.009-0.279-0.006c-0.066,0.034-0.109,0.066-0.098,0.104c0,0.002,0,0.005,0.012,0.008
					C1710.728,30.732,1711.198,30.767,1711.175,30.87z"/>
				<path d="M1673.345,29.577c-0.021-0.155-0.15-0.163-0.582-0.189c-1.668-0.086-2.139,0.356-2.078,0.396
					c0.309,0.207,0.717,0.391,2.217,0.413C1673.042,29.991,1673.38,29.79,1673.345,29.577z"/>
				<path d="M1667.739,29.569c-0.051-0.331-0.057-0.383-0.627-0.425c-0.381-0.021-0.615,0.1-0.486,0.191
					C1666.669,29.365,1666.896,29.509,1667.739,29.569z"/>
				<path d="M1080.712,6.372c0.035,0,0.078-0.003,0.113-0.003c1.578-0.069,1.625-0.431,1.637-0.546
					c-0.682-0.022-1.037-0.08-1.295-0.224c-0.566,0.037-0.535,0.189-0.443,0.437C1080.79,6.197,1080.813,6.283,1080.712,6.372z"/>
				<path d="M1662.901,29.848c0.012,0.005,0.035,0.009,0.047,0.015c0.402,0.123,1.051,0.157,1.369,0.169
					c0.057-0.08,0.146-0.189,0.211-0.271c-0.283,0.018-0.486-0.028-0.736-0.045C1662.638,29.644,1662.878,29.825,1662.901,29.848z"/>
				<path d="M1574.815,25.195c0.076-0.114,0.176-0.268,0.246-0.379c0.236,0.098,0.455,0.179,0.992,0.224
					c0.879,0.075,1.838,0.015,2.711,0.087c-0.166-0.322-0.383-0.322-1.422-0.189c-0.244-0.193-0.551-0.276-1.215-0.322
					c-1.318-0.058-2.393,0.196-2.066,0.394C1574.208,25.104,1574.606,25.161,1574.815,25.195z"/>
				<path d="M1056.571,5.835c-0.393-0.005-0.916-0.018-1.314-0.028l-0.008,0.398c0.014,0,0.029,0.003,0.039,0.003
					C1055.741,6.231,1056.767,6.242,1056.571,5.835z"/>
				<path d="M1660.298,29.882c0.01,0,0.027,0,0.047-0.003c0.205-0.014,0.67-0.074,0.473-0.255
					c-0.061-0.013-0.127-0.018-0.189-0.023c-0.525-0.023-0.525,0.16-1.043,0.135c0,0.02,0.006,0.038,0.029,0.058
					C1659.677,29.848,1659.89,29.899,1660.298,29.882z"/>
				<path d="M1054.597,6.622c0.26,0.184,0.307,0.264,0.15,0.447c0.033,0,0.072-0.005,0.098-0.011
					c0.896-0.126,1.129,0.065,1.213,0.138c1.875-0.144,0.721-0.522-0.402-0.884c-0.389-0.013-0.914-0.023-1.307-0.032
					C1054.343,6.412,1054.378,6.462,1054.597,6.622z M1055.243,6.702l0.826,0.018v0.189l-0.83-0.018L1055.243,6.702z"/>
				<polygon points="1564.489,24.639 1563.353,24.578 1563.224,24.775 1564.366,24.839 "/>
				<path d="M1071.337,6.96c-0.436-0.034-0.68-0.056-0.781-0.131l-0.422,0.385l1.721,0.039
					C1072.233,7.064,1072.011,7.013,1071.337,6.96z"/>
				<path d="M1510.165,22.548c0,0,0.02,0,0.025,0.003c0.691,0.055,1.152,0.003,1.305-0.015
					c0.506-0.061,0.764-0.089,1.49,0.058c0.082-0.138-0.738-0.25-1.525-0.293C1510.429,22.258,1509.993,22.341,1510.165,22.548z"/>
				<path d="M1626.737,29.106c-0.117-0.092-0.117-0.138-0.098-0.218c0.049-0.087,0-0.155-0.316-0.294
					c-0.637,0.026-0.695,0.236-0.543,0.351C1625.97,29.084,1626.392,29.118,1626.737,29.106z"/>
				<path d="M1575.044,25.993c-0.053-0.005-0.119-0.011-0.166-0.011c-0.729-0.038-1.07,0.029-1.143,0.224
					c0,0,0.018,0,0.023,0C1574.368,26.243,1574.95,26.24,1575.044,25.993z"/>
				<path d="M1541.567,24.374c0.088-0.04,0.119-0.092,0.143-0.141c-0.656-0.031-1.299-0.065-1.953-0.101
					c0,0.035,0.031,0.066,0.063,0.095C1540.114,24.414,1541.175,24.569,1541.567,24.374z"/>
				<path d="M1572.604,26.143c0.236-0.16-0.213-0.201-0.791-0.232c-0.068-0.003-0.16-0.009-0.24-0.014
					c0.018,0.011,0.029,0.022,0.035,0.034C1571.8,26.077,1572.218,26.12,1572.604,26.143z"/>
				<path d="M1538.585,24.747c-0.688-0.281-0.779-0.35-0.834-0.619c-0.469-0.023-1.107-0.058-1.578-0.081
					c-0.043,0.068-0.123,0.23,0.086,0.38C1536.649,24.689,1537.769,24.736,1538.585,24.747z"/>
				<path d="M1498.788,22.24c-0.084-0.043-0.084-0.043-0.361-0.058c-0.773-0.031-1.102,0.067-1.125,0.342
					c0.014,0,0.029,0.006,0.047,0.006C1498.431,22.638,1499.106,22.415,1498.788,22.24z"/>
				<path d="M1060.868,8.589c0.037-0.249-0.836-0.283-1.014-0.29c-0.314-0.003-0.496,0.012-0.701,0.046
					c0.008,0.029,0.041,0.055,0.082,0.081c0.006,0.003,0.018,0.006,0.029,0.011C1059.495,8.534,1059.96,8.581,1060.868,8.589z"/>
				<path d="M1522.151,25.658c-0.107-0.061-0.236-0.144-0.33-0.204l-0.732-0.034c-0.059,0.025-0.135,0.074-0.064,0.114
					C1521.099,25.585,1521.099,25.585,1522.151,25.658z"/>
				<path d="M1511.093,25.305c-0.059,0.132-0.566,0.225-0.578,0.358c0.037-0.003,0.084-0.005,0.119-0.008
					c0.691-0.063,1.197-0.052,1.779-0.034c0.426,0.011,0.639,0.008,0.896-0.01c-0.211-0.152-0.725-0.235-1.814-0.289
					C1511.354,25.311,1511.222,25.308,1511.093,25.305z"/>
				<path d="M1506.942,25.37c-1.082-0.111-2.273-0.149-3.395-0.232c0.15,0.099,0.246,0.161,0.309,0.331
					c0.021,0.065,0.045,0.135,0.168,0.194c0.174,0.09,0.504,0.152,0.787,0.21c0.896-0.12,0.959-0.109,1.748,0.021
					c0.611,0.1,1.027,0.118,1.377,0.129c0.35-0.155,0.434-0.241,0.344-0.359c-0.018-0.014-0.031-0.025-0.051-0.037
					C1508.065,25.546,1507.839,25.462,1506.942,25.37z"/>
				<path d="M1513.157,26.758c0.422,0.037,0.777-0.052,1.201-0.034c-0.082-0.064-0.188-0.149-0.266-0.214
					c-0.588,0.026-0.854,0.096-0.949,0.248C1513.144,26.758,1513.157,26.761,1513.157,26.758z"/>
				<path d="M1396.907,22.077c0.088-0.003,0.203-0.006,0.289-0.006c1.137-0.031,2.32,0.135,3.432-0.046
					c0.197-0.322-1.252-0.367-1.818-0.554c-1.035,0.181-1.203,0.209-2.119,0.113c-0.213,0.13-0.158,0.176,0.086,0.279
					C1396.995,21.956,1396.987,21.996,1396.907,22.077z"/>
				<path d="M1392.843,21.808c-0.055-0.006-0.115-0.012-0.178-0.012c-0.604-0.023-0.639,0.095-0.693,0.272
					c0.246-0.021,0.568-0.043,0.805-0.063L1392.843,21.808z"/>
				<path d="M1394.979,22.95c0.99-0.179,0-0.454-0.908-0.498c-0.635-0.019-0.9,0.07-1.049,0.142
					c0.02,0,0.035,0.005,0.053,0.012C1394.321,22.921,1394.321,22.921,1394.979,22.95z"/>
				<path d="M1390.101,22.74c0.109,0.037,0.109,0.037,1.613,0.078c-0.094-0.136-0.426-0.207-1.148-0.236
					c-0.154-0.008-0.301-0.012-0.453-0.012C1390.052,22.614,1389.944,22.688,1390.101,22.74z"/>
				<path d="M1398.005,23.68c1.123,0.02,2.188-0.075,3.293-0.083c-1.031-0.142-1.916-0.216-2.869-0.259
					c-1.209-0.043-2.057-0.009-2.846,0.117c0.08,0.018,0.201,0.034,0.281,0.047C1396.933,23.659,1397.601,23.673,1398.005,23.68z"/>
				<path d="M1389.849,23.622c0.668,0.063,1.076,0.04,1.436,0.017c0.412-0.028,0.582-0.028,0.939-0.02
					c-0.027-0.078-0.701-0.146-1.359-0.175c-0.906-0.032-1.277,0.025-1.104,0.168C1389.778,23.615,1389.815,23.619,1389.849,23.622z"/>
				<polygon points="1023.397,13.496 1023.394,13.307 1022.497,13.29 1022.503,13.479 "/>
				<path d="M1325.771,22.563c0.047-0.043-0.033-0.09-0.07-0.112c-0.584-0.012-1.129,0.074-1.715,0.035
					c-0.018,0.017-0.006,0.037,0.031,0.051C1324.286,22.648,1325.618,22.692,1325.771,22.563z"/>
				<path d="M1242.183,21.322c0.607-0.055,0.615-0.248,0.615-0.33c0.01-0.309-0.475-0.598-0.584-0.903
					c-0.508,0.312-0.328,0.911-0.174,1.241C1242.079,21.327,1242.14,21.325,1242.183,21.322z"/>
				<polygon points="1253.433,21.401 1253.063,21.187 1252.188,21.271 1252.626,21.472 "/>
				<path d="M1401.212,26.878c-0.02-0.012-0.045-0.028-0.066-0.04c-0.248-0.114-0.549-0.161-1.225-0.195
					c-0.955-0.034-1.936,0.009-2.877-0.052c-0.484,0.115-0.621,0.218-0.604,0.454c0.152-0.052,0.357-0.114,0.508-0.167
					c0.426,0.189,0.848,0.207,1.688,0.179c0.682-0.029,1.004-0.041,1.047,0.118c0.52-0.07,0.957-0.063,1.615-0.026
					C1401.329,27.016,1401.312,26.971,1401.212,26.878z"/>
				<path d="M1289.853,22.656c-0.057-0.034-0.154-0.063-0.246-0.092c-0.57,0.018-0.873,0.099-0.91,0.251
					c0.025,0.003,0.061,0.003,0.086,0.008C1289.911,22.927,1290.089,22.783,1289.853,22.656z"/>
				<path d="M765.096,12.228c-0.028-0.187-0.595-0.265-1.114-0.27c-0.317-0.003-0.525,0.016-0.689,0.057
					c0.01,0.006,0.018,0.012,0.035,0.012C763.699,12.17,764.512,12.21,765.096,12.228z"/>
				<path d="M759.213,12.232c0.182,0.069,0.442,0.087,0.767,0.05c-0.031-0.089-0.066-0.213-0.089-0.305
					c-0.107-0.012-0.224-0.02-0.336-0.022C758.95,11.958,758.996,12.159,759.213,12.232z"/>
				<path d="M1395.55,26.617c-0.381-0.009-0.668,0.065-1.047,0.055c-0.031,0.034-0.09,0.115,0.039,0.188
					c0.178,0.095,0.639,0.145,1.521,0.167c0.119-0.138-0.211-0.264-0.316-0.396C1395.687,26.625,1395.616,26.619,1395.55,26.617z"/>
				<path d="M1385.468,26.731c0.137,0.056,0.412,0.084,0.623,0.095c0.596,0.04,1.221,0.04,1.828,0.063
					c0.16-0.31-1.676-0.224-2.406-0.373C1385.421,26.583,1385.302,26.663,1385.468,26.731z"/>
				<path d="M1321.372,25.152c0.154,0.081,0.637,0.192,1.168,0.167c0.107-0.106-0.033-0.144-0.375-0.192
					c-0.277-0.043-0.383-0.069-0.408-0.129C1321.163,25.012,1321.286,25.108,1321.372,25.152z"/>
				<path d="M1013.44,17.878c1.754-0.021,2.584-0.267,2.465-0.723c-0.746-0.023-1.09-0.074-1.391-0.213
					c-1.32,0.078-1.324,0.438-1.195,0.936C1013.349,17.878,1013.396,17.878,1013.44,17.878z"/>
				<path d="M1232.228,23.237c0.145,0.071,0.547,0.135,0.682,0.04c0.078-0.061,0.023-0.149-0.012-0.201
					C1231.952,23.07,1232.144,23.196,1232.228,23.237z"/>
				<path d="M1316.497,26.345c0.01,0.008,0.057,0.016,0.078,0.022c0.492,0.121,1.377,0.108,2.24,0.087
					c1.889-0.047,2.105,0.017,2.229,0.051c1.197-0.333-1.107-0.517-2.104-0.557C1315.976,25.862,1316.483,26.339,1316.497,26.345z"/>
				<path d="M1282.888,25.127c0.762,0.086,0.781-0.015,0.801-0.104c0.021-0.118,0.066-0.164,0.422-0.155
					c-0.092-0.069-0.199-0.098-0.422-0.109c-0.885-0.02-1.063,0.305-0.873,0.356C1282.827,25.121,1282.864,25.121,1282.888,25.127z"/>
				<path d="M1242.22,23.803c0.092,0.046,0.326,0.111,0.775,0.061c0.109-0.149-0.297-0.267-0.42-0.402
					C1242.159,23.461,1241.933,23.677,1242.22,23.803z"/>
				<path d="M1014.476,18.57c0.064,0.089-0.066,0.219-0.145,0.303c0.043-0.007,0.092-0.018,0.139-0.023
					c0.541-0.092,0.73-0.271,1.451-0.325c0.471-0.034,1.182,0.066,1.447,0.107c-0.354-0.122-0.871-0.222-1.172-0.356
					c-0.201-0.089-0.195-0.188-0.195-0.253c-0.756,0.034-1.338,0.184-2.168,0.167C1014.003,18.32,1014.374,18.433,1014.476,18.57z"/>
				<path d="M1316.075,26.146c-0.371-0.014-0.865-0.031-1.23-0.043l-0.061,0.276c0,0,0.012,0,0.023,0
					C1315.575,26.41,1316.079,26.384,1316.075,26.146z"/>
				<path d="M1311.519,25.988c-0.082-0.006-0.166-0.012-0.246-0.018c-0.473-0.012-0.508,0.041-0.658,0.264
					c0.266-0.017,0.609-0.045,0.871-0.063L1311.519,25.988z"/>
				<path d="M1286.175,25.135c-0.588,0.009-0.604,0.306-0.258,0.377c0.223,0.046,0.465,0.018,0.588,0.005
					c-0.129,0.084-0.307,0.196-0.447,0.279c-0.627-0.164-2.266-0.164-2.279-0.167c-0.443,0.003-0.639-0.008-1.043-0.037
					c0.068,0.143,0.08,0.166-0.238,0.281c-0.33,0.115-0.314,0.139-0.242,0.278c0.043,0,0.096,0.004,0.135,0.007
					c0.531,0.024,0.896,0.14,1.488,0.137c0.129-0.1,0.258-0.135,0.836-0.16c0.637-0.023,0.891-0.049,1.32-0.152
					c0.611,0.003,0.848,0.092,1.025,0.187c0.27,0.141,0.41,0.21,1.037,0.083c-0.141-0.077-0.395-0.135-0.529-0.206
					c0.258-0.078,0.658-0.109,0.988-0.167c0.086-0.184-0.092-0.236-0.848-0.35c-0.713-0.109-0.848-0.185-0.684-0.368
					C1286.774,25.155,1286.431,25.144,1286.175,25.135z"/>
				<path d="M1397.774,29.291c-0.191,0.045-0.787,0.178-0.357,0.396c0.404,0.204,1.959,0.491,3.408,0.299
					c-0.17-0.275-0.646-0.333-1.613-0.396C1398.351,29.535,1397.964,29.479,1397.774,29.291z"/>
				<path d="M1308.548,26.459c0.133-0.112,0.318-0.262,0.459-0.373l-1.234-0.04c-0.109,0.06-0.213,0.131-0.055,0.197
					C1307.919,26.326,1308.419,26.355,1308.548,26.459z"/>
				<path d="M1006.089,19.114c0.041-0.003,0.1-0.007,0.141-0.013c0.566-0.063,0.531-0.171,0.482-0.286
					c-0.059-0.162,0.023-0.245,1.086-0.251c-0.152-0.095-0.369-0.218-0.521-0.313l-1.303-0.022
					C1005.38,18.539,1005.649,18.792,1006.089,19.114z"/>
				<path d="M1290.229,26.832c0.008-0.006,0.084-0.103-0.293-0.12c-0.215-0.006-0.418,0.018-0.68,0.055
					c0.018,0.005,0.043,0.011,0.055,0.014C1289.827,26.947,1290.169,26.907,1290.229,26.832z"/>
				<path d="M1103.103,22.278c0.074,0.034,0.178,0.063,0.283,0.089c0.84-0.018,0.867-0.17,0.639-0.29
					c-0.012-0.006-0.025-0.012-0.037-0.018c-0.059-0.029-0.129-0.052-0.217-0.074C1102.833,22.002,1102.864,22.175,1103.103,22.278z"/>
				<path d="M1286.304,27.269c0.318,0.164,0.93,0.187,1.141,0.195c0.227-0.16-0.195-0.189-1.209-0.241
					C1286.253,27.237,1286.28,27.254,1286.304,27.269z"/>
				<polygon points="1282.077,27.285 1282.933,27.314 1282.962,27.117 1282.108,27.085 "/>
				<path d="M1421.024,32.702c-0.6-0.078-0.982-0.112-1.559-0.139c-1.537-0.051-2.998,0.092-4.514,0.092
					c0.141,0.099,0.258,0.184,0.049,0.432c-0.158,0.184-0.266,0.304,0.061,0.411c0.188,0.06,0.49,0.094,0.775,0.126
					c-0.191-0.066-0.346-0.123-0.26-0.193c0.145-0.105,0.574-0.16,0.848-0.244c0.539,0.047,0.566,0.216,1.154,0.244
					c0.564,0.034,0.738-0.098,0.689-0.137c-0.111-0.095-0.633-0.145-0.588-0.254c0.004-0.022,0.092-0.076,0.691-0.06
					c1.234,0.031,1.234,0.031,1.375-0.037c0.012,0.057,0.049,0.112,0.111,0.167c0.035,0.021,0.066,0.039,0.102,0.063
					c0.258,0.126,0.354,0.158,0.813,0.287c0.508-0.104,0.412-0.161,0.037-0.339C1420.347,32.896,1420.583,32.814,1421.024,32.702z"/>
				<path d="M1231.442,26.567c0.213,0.09,0.715,0.139,1.514,0.149c0.01-0.085,0.018-0.207,0.031-0.292
					c-0.129-0.012-0.26-0.018-0.402-0.023c-0.453-0.008-0.838,0.049-1.26,0.063C1231.337,26.505,1231.358,26.533,1231.442,26.567z"/>
				<path d="M1266.479,27.835c-0.107-0.061-0.248-0.146-0.367-0.21l-0.863-0.028c-0.021,0.034-0.068,0.086,0.033,0.131
					C1265.405,27.78,1265.405,27.78,1266.479,27.835z"/>
				<path d="M1234.544,27.183c0.197,0.098,0.537,0.195,0.885,0.178c0.02-0.08-0.023-0.129-0.201-0.225
					c-0.207-0.113-0.344-0.191-0.156-0.355c-0.059-0.006-0.113-0.009-0.174-0.012C1234.036,26.758,1234.177,27.01,1234.544,27.183z"/>
				<polygon points="1062.872,23.116 1062.048,23.099 1062.071,23.288 1062.882,23.306 "/>
				<path d="M1234.612,27.613c-0.637-0.098-1.449-0.077-2.109-0.152c0.037,0.021,0.082,0.046,0.125,0.063
					c0.27,0.125,0.605,0.162,0.91,0.199c0.51,0.063,0.75,0.104,0.572,0.355C1235.099,28.11,1234.386,27.765,1234.612,27.613z"/>
				<path d="M1225.312,28.005c0.117-0.023,0.275-0.058,0.402-0.081l0.012-0.184l-0.402,0.079l-1.246-0.131
					c-0.217,0.045-0.557,0.117-0.369,0.166C1224.134,27.969,1224.946,27.863,1225.312,28.005z"/>
				<path d="M1280.905,30.091c0.248-0.089,0.414-0.129,1.191-0.048c0.342-0.058,0.217-0.089-0.4-0.115
					c-0.908-0.025-2.006,0.021-1.643,0.155c0.092,0.037,0.238,0.063,0.387,0.092C1280.636,30.169,1280.716,30.158,1280.905,30.091z"/>
				<polygon points="1276.677,29.865 1275.894,29.842 1275.872,30.025 1276.655,30.052 "/>
				<path d="M1225.255,28.957l1.26-0.058c0.012-0.003,0.27-0.471-0.756-0.505c-0.471-0.009-0.885,0.046-1.332,0.063
					C1224.673,28.607,1225.005,28.808,1225.255,28.957z"/>
				<path d="M1051.495,24.914c0.838-0.006,0.502-0.149-0.047-0.391c-0.236,0-0.848,0-0.25,0.271
					C1051.296,24.833,1051.403,24.87,1051.495,24.914z"/>
				<polygon points="975.435,24.679 975.392,24.475 974.501,24.461 974.544,24.661 "/>
				<path d="M1277.657,32.168c0.033,0.034,0.066,0.063,0.135,0.092c0.32,0.132,1.098,0.146,1.545,0.146
					c0.242-0.152-0.012-0.181-0.709-0.207C1278.306,32.19,1277.97,32.196,1277.657,32.168z"/>
				<path d="M975.886,26.625c0.25,0.089,1.135,0.162,1.258,0.029c0.123-0.145-0.178-0.281-0.08-0.42
					c-0.115-0.011-0.234-0.019-0.352-0.022C975.769,26.212,975.546,26.493,975.886,26.625z"/>
				<path d="M1040.013,28.102c0.258,0.101,0.602,0.063,0.756,0.046c-0.014-0.063-0.025-0.143-0.037-0.2l-0.42-0.104
					C1039.815,27.84,1039.767,28.005,1040.013,28.102z"/>
				<path d="M975.976,27.085c0.018,0.012,0.063,0.017,0.088,0.022c0.729,0.146,2.133,0.093,2.031-0.191
					c-0.016-0.032-0.039-0.061-0.082-0.093c-0.18-0.002-0.371-0.008-0.557-0.015C975.386,26.78,975.968,27.085,975.976,27.085z"/>
				<path d="M1038.114,29.721c0.596,0.034,1.064-0.097,1.652-0.063c-0.141-0.253-0.648-0.377-1.77-0.42
					c0.039,0.161,0.061,0.322,0.096,0.482C1038.104,29.721,1038.11,29.721,1038.114,29.721z"/>
				<path d="M1280.8,35.706c0.07,0.027,0.178,0.051,0.295,0.068c0.252-0.052,0.602-0.12,0.848-0.172
					c-0.104-0.069-0.221-0.098-0.459-0.11C1280.997,35.481,1280.587,35.607,1280.8,35.706z"/>
				<path d="M964.567,28.149c-1.023,0.032-0.08,0.417-0.068,0.424c0.053,0.021,0.113,0.045,0.199,0.063
					C965.749,28.618,964.817,28.21,964.567,28.149z"/>
				<path d="M1038.919,29.828c-0.215,0.002-0.607,0.002-0.744,0.134c-0.178,0.173,0.059,0.346,0.07,0.517
					c0.012-0.003,0.043-0.005,0.061-0.005c0.766-0.104,1.137-0.184,1.521-0.535C1039.554,29.904,1039.188,29.859,1038.919,29.828z"/>
				<path d="M1037.622,31.427c1.07,0.068,1.236-0.061,0.941-0.178c-0.08-0.035-0.248-0.08-0.518-0.093
					c-0.545,0-0.531,0.05-0.496,0.265C1037.573,31.424,1037.604,31.427,1037.622,31.427z"/>
				<path d="M1037.856,32.438c0.125,0.04,0.248-0.034,0.291-0.098c0.063-0.104-0.043-0.206-0.172-0.212
					C1037.679,32.136,1037.646,32.38,1037.856,32.438z"/>
				<polygon points="1038.765,32.972 1039.577,32.985 1039.53,32.785 1038.724,32.771 "/>
				<polygon points="759.939,34.941 760.788,34.953 760.675,34.767 759.833,34.758 "/>
				<path d="M752.96,35.499c0.012,0.006,0.023,0.009,0.035,0.014c0.33,0.106,0.648,0.061,0.761,0.047
					c-0.053-0.089-0.129-0.207-0.183-0.296c-0.106-0.013-0.214-0.018-0.332-0.023C752.748,35.243,752.729,35.396,752.96,35.499z"/>
				<path d="M1309.62,28.223c0.32,0.131,1.109,0,1.309-0.149c0.154-0.115-0.08-0.173-0.17-0.196
					c-0.279,0.128-0.512,0.173-1.268,0.128C1309.487,28.056,1309.46,28.152,1309.62,28.223z"/>
				<polygon points="1310.765,27.86 1310.759,27.877 1310.831,27.863 "/>
				<path d="M1311.942,28.196c0.59,0.011,1.109-0.089,1.711-0.049c0.129-0.149-0.141-0.187-0.66-0.244
					c-0.537-0.061-0.732-0.112-0.555-0.262c-1.002,0-1.313,0.072-1.607,0.222c0.049,0.003,0.111,0.003,0.152,0.003
					C1312.052,27.924,1311.979,28.113,1311.942,28.196z"/>
				<path d="M1500.53,22.632c1.369-0.062,1.369-0.062,7.498,0.111c0.957-0.299,0.957-0.299,1.77-0.213
					c-0.432-0.232-0.578-0.31-1.463-0.354c0.432-0.191,0.873-0.267,1.816-0.301c-0.473-0.046-0.969-0.08-1.469-0.104
					c-1.943-0.083-1.943-0.083-9.059,0.08c0.129,0.268,0.336,0.534,0.398,0.804C1500.177,22.646,1500.378,22.635,1500.53,22.632z"/>
				<path d="M1489.438,22.215c0.006,0.028-0.283,0.104-0.59,0.192c0.049,0,0.109-0.003,0.158-0.006
					c0.951-0.028,2.176,0.006,3.863,0.101c0.24-0.095,0.295-0.142,0.262-0.241c-0.021-0.068,0-0.089,0.303-0.121
					c-0.354-0.068-0.766-0.106-1.697-0.151c-0.918-0.044-1.908-0.066-3.029-0.071c0.104,0.12,0.225,0.194,0.588,0.255
					C1489.356,22.183,1489.431,22.192,1489.438,22.215z"/>
				<path d="M1490.452,25.233c0.568,0.134,1.396,0.221,2.492,0.261c0.221-0.046,0.533-0.052,0.732-0.104
					c0.176-0.044,0.184-0.065,0.207-0.138c0.814,0.172,1.473,0.253,3.012,0.229c1.371-0.018,1.955,0.052,2.711,0.327
					c1.018,0.019,1.797-0.209,2.859-0.146c0.057-0.083,0.141-0.198,0.199-0.283c-0.848-0.112-1.451-0.162-2.605-0.222
					c-1.996-0.089-4.127-0.037-5.986-0.284c-0.934,0.234-1.83,0.308-3.82,0.305C1490.312,25.195,1490.394,25.213,1490.452,25.233z"/>
				<path d="M1284.915,23.335c0.139,0.052,0.424,0.018,0.846-0.047c0.426-0.054,0.555-0.065,0.744-0.065
					c-0.08-0.077-0.152-0.101-0.33-0.111c-0.107,0-0.234,0-0.652,0.079c-0.215,0.041-0.479,0.095-0.68,0.07
					C1284.854,23.285,1284.86,23.312,1284.915,23.335z"/>
				<path d="M767.318,13.936c0.041-0.005,0.095-0.008,0.129-0.017c1.19-0.17,0.365-0.633-0.79-0.775
					c-0.354,0.054-0.249,0.126,0.153,0.305C767.26,13.649,767.448,13.775,767.318,13.936z"/>
				<path d="M1270.812,28.495c-0.766,0.042-1.088,0.049-1.441-0.089c-0.051,0-0.135,0.005-0.193,0.005
					c-0.041,0.006-0.082,0.006-0.129,0.013c-0.059,0.011-0.098,0.017-0.025,0.045c0.201,0.063,0.566,0.098,0.732,0.173
					c0.141,0.063,0.068,0.095-0.031,0.144c1.729-0.023,2.082-0.012,3.791,0.121c0.117-0.121,0.023-0.155-0.389-0.236
					c-0.361-0.065-0.402-0.092-0.412-0.161c-0.197-0.022-0.404-0.04-0.625-0.048C1271.733,28.452,1271.438,28.455,1270.812,28.495z"/>
				<path d="M1276.485,31.473c-0.076,0.145,0.287,0.265,0.422,0.396c0.014,0,0.039-0.006,0.055-0.012
					c0.359-0.08,1.182-0.132,1.188-0.075c-0.006,0.029-0.285,0.081-0.459,0.113c0.129,0.151,0.809,0.031,1.084-0.055
					c0.303-0.095,0.27-0.161,0.252-0.196C1278.067,31.671,1277.368,31.508,1276.485,31.473z"/>
				<path d="M1038.429,28.969c0.502,0.089,1.113,0.112,1.705,0.126c-0.16-0.141-0.178-0.212,0.068-0.344
					c0.207-0.115,0.225-0.144,0.229-0.225c-0.629-0.034-0.781-0.215-1.441-0.241c-0.537-0.006-0.623,0.046-0.592,0.061
					c0.092,0.031,0.662,0.061,1.139,0.055c-0.088,0.089-0.262,0.126-0.637,0.189C1037.776,28.785,1038.423,28.964,1038.429,28.969z"/>
				<path d="M1029.581,27.935c0.232,0.07,0.447,0.144,0.674,0.213c0.016,0.005,0.037,0.012,0.059,0.018
					c0.758,0.229,1.428,0.341,2.369,0.401c-0.506-0.244-0.35-0.281,0.225-0.373c-0.381-0.006-0.822-0.013-1.266-0.021
					c1.375,0.022,1.457,0.006,1.824-0.071c-0.49-0.488-0.643-0.784-0.631-1.255c-1.381-0.158-1.709-0.198-2.682-0.253
					c-0.137-0.197,0.193-0.404-0.07-0.601c-0.055-0.039-0.289-0.097-0.855-0.086c-0.051-0.04-0.105-0.103-0.051-0.146
					c0.264-0.034,0.623-0.006,0.852-0.065c0.131-0.032,0-0.104-0.049-0.145c-0.32-0.034-0.646-0.06-0.986-0.074
					c-0.842-0.021-1.574,0.104-2.402,0.104c-0.111,0.075-0.252,0.173-0.32,0.25c-0.402,0.434-0.178,0.882-0.625,1.313
					c-0.32,0.31-0.875,0.413-0.932,0.425c-0.377,0.063-0.738,0.126-0.258,0.308c0.152,0.057,0.33,0.109,0.416,0.172
					c1.16,0.021,2.719,0.049,3.873,0.071C1028.78,27.986,1028.962,27.947,1029.581,27.935z"/>
				<path d="M977.118,30.826c0.996-0.681,0.996-0.681,1.174-0.893c0.061-0.068,0.117-0.163,0.129-0.235
					c0.141-0.655-0.395-0.729-1.068-0.824c-1.598-0.227-0.947-0.413-0.941-0.416c0.225-0.061,1.209,0.043,1.23,0.194
					c0.236-0.068,0.285-0.079,0.201-0.2c-0.166-0.225,0.014-0.235,0.975-0.259c-0.268-0.175-0.408-0.228-1.607-0.46
					c-0.092-0.017-0.197-0.04-0.289-0.054c-0.785,0.082-1.676,0.333-0.645,0.657c-0.225-0.04-0.385-0.06-0.699-0.08
					c0.273,1.024,0.633,2.395,0.902,3.423c0.092-0.012,0.221-0.023,0.303-0.041C978.032,31.393,976.724,31.091,977.118,30.826z"/>
				<polygon points="965.405,31.231 965.401,31.234 965.405,31.237 "/>
				<path d="M747.396,33.759c-1.71,0.052-2.069,0.329-2.493,0.651c0.023,0.009,0.052,0.015,0.071,0.021
					c0.159,0.045,0.288,0.092,0.417,0.141c1.049,0.012,2.464,0.025,3.514,0.037c-0.419-0.172-0.807-0.361-1.414-0.79
					C747.454,33.799,747.426,33.775,747.396,33.759z"/>
				<path d="M1101.46,18.37c-0.158-0.013-0.471-0.058-0.617-0.084c-0.604-0.109-0.049-0.126,0.215-0.131
					c-0.063-0.013-0.129-0.019-0.203-0.023c-0.072,0-0.146,0-0.213,0c-0.756,0.037-2.605,0.511-0.855,0.775
					c-0.195-0.01-0.701-0.034-0.822,0.034c-0.068,0.037-0.063,0.074-0.02,0.188c0.033,0.075,0.057,0.152,0.041,0.23l2.104,0.049
					C1101.077,19.06,1101.796,18.724,1101.46,18.37z"/>
				<path d="M1294.958,29.81h-0.01c-0.037,0.003-0.061,0.009-0.061,0.021l0.123-0.022
					C1294.991,29.808,1294.972,29.808,1294.958,29.81z"/>
				<path d="M0.997,5.422c0.238-0.087-0.311-0.225-0.603-0.299c-0.016,0.014-0.043,0.052,0.08,0.132
					C0.62,5.347,0.917,5.45,0.997,5.422z"/>
				<path d="M3.437,12.359c0.056-0.04,0.113-0.04,0.195-0.034c-0.106-0.179-0.244-0.227-0.511-0.287
					c-0.206-0.046-0.286-0.075-0.385-0.149c-0.435,0.046,0.33,0.482,0.339,0.482C3.308,12.429,3.378,12.4,3.437,12.359z"/>
				<path d="M2.344,12.749c0.411,0.058,0.801,0.125,1.193,0.19c1.809,0.293,2.676,0.373,2.688,0.373
					c0.472,0.031,0.573-0.028,0.439-0.27c-0.892-0.115-1.739-0.253-2.7-0.345c-0.857-0.069-1.262-0.063-1.789,0.035
					C2.224,12.735,2.294,12.744,2.344,12.749z"/>
				<path d="M0.858,12.785c0.125-0.016,0.105-0.052,0.21-0.067c-0.091-0.111-0.329-0.146-0.395-0.152
					c-0.406-0.036-0.047,0.202-0.044,0.202S0.753,12.796,0.858,12.785z"/>
				<path d="M2.445,15.371C0.624,15.2,0.624,15.2,0.099,15.225c0.062,0.07,0.124,0.139,0.246,0.204
					c0.323,0.176,0.792,0.204,0.969,0.115c0.067-0.031,0.053-0.068,0.047-0.103c1.063,0.243,1.807,0.249,2.744,0.26
					C3.615,15.547,3.229,15.452,2.445,15.371z"/>
				<path d="M4.923,15.639c-0.033-0.006-0.324-0.017-0.04,0.144c0.267,0.157,0.612,0.259,0.718,0.213
					C5.707,15.949,5.74,15.73,4.923,15.639z"/>
				<path d="M1.003,16.477c0.059,0.07,0.125,0.139,0.227,0.202c0.243,0.148,0.494,0.148,0.588,0.148
					C1.648,16.641,1.567,16.621,1.003,16.477z"/>
				<polygon points="6.376,17.354 6.077,17.052 5.678,17.017 6.113,17.327 "/>
				<polygon points="5.046,17.833 5.253,18.033 5.78,18.082 5.58,17.881 "/>
				<path d="M4.088,17.925c0.015,0.014,0.036,0.031,0.061,0.046c0.138,0.08,0.401,0.12,0.479,0.074
					c0.03-0.018,0.014-0.167-0.249-0.192C4.195,17.842,4.192,17.901,4.088,17.925z"/>
				<path d="M0.726,17.595c0.186,0.045,0.428,0.105,0.613,0.152c-0.192-0.145-0.257-0.17-0.318-0.182
					C0.891,17.561,0.847,17.598,0.726,17.595z"/>
				<path d="M4.966,19.208c0.195-0.06,0.383-0.04,1.422,0.061c-0.407-0.319-0.995-0.408-1.168-0.425
					c-0.462-0.035-0.555,0.092-0.286,0.373C4.947,19.217,4.959,19.211,4.966,19.208z"/>
				<path d="M6.585,25.805c-0.162-0.115-0.238-0.149-0.34-0.167c-0.238-0.012-0.194,0.063-0.329,0.086
					c-0.125,0.023-0.251-0.006-0.303-0.017c0.021,0.011,0.062,0.027,0.084,0.04c0.277,0.126,0.388,0.132,0.446,0.137
					C6.399,25.901,6.405,25.821,6.585,25.805z"/>
				<path d="M2.703,27.234c0.016,0.011,0.033,0.02,0.049,0.029c0.172,0.097,0.332,0.154,0.507,0.184
					c0.208,0.034,0.423-0.006,0.629,0.005c-0.203-0.094-0.448-0.195-0.76-0.232C2.97,27.203,2.845,27.209,2.703,27.234z"/>
				<path d="M1.411,23.104l1.382,0.144c-0.157-0.034-0.316-0.063-0.504-0.092C1.949,23.116,1.641,23.107,1.411,23.104z"
					/>
				<path d="M23.212,4.741c0.027,0.015,0.056,0.025,0.081,0.037c0.804,0.373,1.958-0.04,1.971-0.087
					c0,0-0.243-0.378-1.898-0.501c-0.151-0.01-0.307-0.021-0.467-0.029c0.033,0.086,0.117,0.169,0.201,0.255
					C23.344,4.675,23.366,4.732,23.212,4.741z"/>
				<path d="M12.995,7.104c0.922,0.148,1.721,0.276,2.399,0.284c0.774,0.009,0.626-0.241,0.63-0.244
					c-0.006-0.002-0.312-0.276-1.205-0.522c-0.572-0.158-1.375-0.253-2.055-0.38c-0.171,0.173-0.135,0.346,0.148,0.851
					C12.942,7.099,12.972,7.099,12.995,7.104z"/>
				<path d="M16.083,8.063c0.012,0,0.029-0.003,0.045-0.006c0.165-0.006,0.324,0.003,0.48,0.015
					c0.102,0.009,0.226,0.04,0.318,0.011c0.1-0.028,0.014-0.16-0.035-0.24c-0.175,0.008-0.299,0.075-0.5,0.039
					c-0.138-0.024-0.253-0.117-0.332-0.187C15.904,7.704,15.796,7.753,16.083,8.063z"/>
				<path d="M15.038,7.793c0.009,0.003,0.014,0.007,0.021,0.013c0.265,0.114,0.439,0.16,0.485,0.132
					c0.047-0.029-0.085-0.167-0.3-0.189C15.19,7.748,15.12,7.751,15.038,7.793z"/>
				<path d="M7.095,7.242C7.253,7.337,7.47,7.46,7.625,7.555C7.823,7.449,7.993,7.357,7.501,7.09
					C7.467,7.082,7.424,7.075,7.375,7.069C7.003,7.047,7.474,7.266,7.095,7.242z"/>
				<path d="M24.579,13.944c-0.073-0.012-0.146-0.017-0.221-0.022c-0.388-0.029-0.415,0.048-0.114,0.275
					c0.009,0.006,0.012,0.003,0.02,0.006C24.724,14.249,24.812,14.174,24.579,13.944z"/>
				<path d="M25.143,14.252c0.065,0.034,0.25,0.031,0.25,0.031c0.153-0.018,0.146-0.058,0.274-0.075
					c-0.082-0.103-0.357-0.131-0.413-0.137C25.033,14.06,24.906,14.111,25.143,14.252z"/>
				<path d="M22.055,14.3c-0.061-0.113-0.134-0.258-0.189-0.372c-0.593,0.097-0.919,0.149-1.338-0.104
					c-0.356,0.204-0.717,0.271-2.003,0.149c-1.236-0.12-1.403-0.1-1.63-0.074c0.076,0.029,0.169,0.063,0.25,0.087
					c0.648,0.218,1.141,0.28,1.535,0.314c0.26,0.023,0.26,0.023,1.736-0.024C21.178,14.255,21.503,14.252,22.055,14.3z"/>
				<path d="M14.442,13.789c-0.097,0-0.175,0.003-0.713-0.103c-0.95-0.187-1.403-0.244-1.411,0.028
					c0.019,0,0.047,0,0.067,0.003c0.143,0.003,0.561,0.014,1.146,0.105c0.926,0.144,1.26,0.127,1.699,0.035
					c-0.153-0.132-0.231-0.175-0.342-0.192C14.569,13.677,14.771,13.783,14.442,13.789z"/>
				<path d="M15.378,13.873c0.021,0.015,0.049,0.031,0.07,0.046c0.095,0.054,0.319,0.189,0.855,0.141
					c0.062-0.003,0.296-0.018,0.627,0.028c-0.209-0.092-0.485-0.195-0.933-0.235C15.753,13.836,15.55,13.841,15.378,13.873z"/>
				<path d="M9.93,13.681c0.202-0.164,0.555-0.127,1.249-0.031c0.584,0.077,0.795,0.077,0.998,0.054
					c-0.466-0.184-0.755-0.255-1.236-0.302c-0.544-0.042-1.125,0.015-1.662-0.031c-0.617-0.058-1.105-0.166-1.747-0.215
					c-0.03-0.003-0.071-0.003-0.101-0.009c-0.274-0.012-0.437,0-0.534,0.011c0.041,0.019,0.094,0.044,0.132,0.061
					c0.521,0.216,0.929,0.222,1.486,0.23C9.125,13.456,9.436,13.496,9.93,13.681z"/>
				<path d="M21.255,15.047c0.014,0.007,0.027,0.009,0.042,0.015c0.307,0.129,0.46,0.139,0.501,0.104
					c0.033-0.032-0.081-0.141-0.274-0.158C21.414,14.999,21.329,15.024,21.255,15.047z"/>
				<path d="M20.692,15.082c0.062-0.035,0.019-0.096-0.132-0.185l-0.347,0.069c0.01,0.017,0.034,0.04,0.067,0.058
					C20.4,15.094,20.616,15.122,20.692,15.082z"/>
				<path d="M18.715,14.771c-1.193-0.126-1.521-0.086-1.738-0.061c0.019,0.009,0.052,0.021,0.073,0.031
					c0.721,0.265,2.569,0.5,2.88,0.254c0.061-0.047,0.049-0.095,0.033-0.145C19.351,14.829,18.715,14.771,18.715,14.771z"/>
				<path d="M15.986,15.788c0.044,0.049,0.083,0.098,0.175,0.146c0.105,0.055,0.221,0.072,0.365,0.1
					c0.32,0.062,0.409,0.122,0.51,0.282c0.177-0.058,0.299-0.098,0.692-0.115c0.459-0.022,0.915,0.026,1.374,0.018
					c-0.294-0.198-0.489-0.27-0.855-0.308C18.01,15.9,18.01,15.9,17.248,15.979C16.339,15.742,16.339,15.742,15.986,15.788z"/>
				<polygon points="15.384,15.829 15.674,15.851 15.495,15.67 15.21,15.647 "/>
				<path d="M13.519,15.523c0.003,0.007,0.012,0.01,0.018,0.013c0.136,0.086,0.323,0.184,0.555,0.188
					c-0.098-0.149-0.254-0.188-0.509-0.212c-0.03-0.003-0.064-0.006-0.098-0.009C13.496,15.51,13.509,15.518,13.519,15.523z"/>
				<polygon points="24.391,16.44 24.085,16.417 24.282,16.615 24.582,16.639 "/>
				<polygon points="19.941,16.55 19.667,16.265 19.249,16.23 19.519,16.511 "/>
				<path d="M21.549,16.959c-0.409-0.021-0.574,0.081-0.498,0.306c0.016,0,0.04,0.003,0.056,0.006
					c0.287,0.014,1.203,0.086,1.734,0.131C22.337,17.092,21.862,16.994,21.549,16.959z"/>
				<path d="M18.674,16.891c-0.437-0.108-1.095-0.166-1.494-0.286c0.067,0.113,0.163,0.263,0.23,0.372
					c0.017,0,0.034,0.003,0.05,0c0.191,0.006,0.636,0.023,1.633,0.192c0.828,0.138,1.167,0.153,1.513,0.062
					c-0.386-0.288-0.653-0.395-1.107-0.442C19.272,16.775,19.004,16.772,18.674,16.891z"/>
				<path d="M27.56,17.729c0.107-0.057-0.092-0.194-0.175-0.249c-0.146,0.065-0.347,0.078-0.682,0.026
					c0.029,0.031,0.059,0.058,0.11,0.086C27.037,17.718,27.443,17.789,27.56,17.729z"/>
				<path d="M22.942,17.224c0.029,0.055,0.073,0.109,0.169,0.156c0.195,0.103,0.448,0.113,0.537,0.063
					c0.062-0.031,0.07-0.104-0.188-0.256L22.942,17.224z"/>
				<polygon points="25.941,17.448 26.135,17.649 26.746,17.694 26.549,17.493 "/>
				<path d="M23.792,17.385c0.016,0.022,0.042,0.046,0.086,0.069c0.129,0.063,0.336,0.086,0.404,0.039
					c0.053-0.034,0.008-0.092-0.142-0.178L23.792,17.385z"/>
				<path d="M8.459,16.272c-0.003-0.048-0.107-0.146-0.342-0.266l0.018,0.275c0.006,0,0.02,0.006,0.03,0.006
					C8.355,16.327,8.462,16.325,8.459,16.272z"/>
				<path d="M7.903,16.167c-0.169-0.112-0.423-0.241-1.029-0.299c-0.619-0.052-1.028,0.006-1.104,0.018
					c0.021,0.006,0.052,0.018,0.073,0.022C6.418,16.063,7.628,16.219,7.903,16.167z"/>
				<path d="M20.652,18.269c0.572-0.143-0.38-0.447-0.799-0.493c-0.314-0.023-0.63,0.017-0.943-0.006
					c-0.25-0.018-0.454-0.077-0.55-0.104c-0.089,0.075-0.199,0.176-0.286,0.249c-0.854-0.243-0.854-0.243-1.185-0.277
					c0.129,0.091,0.297,0.206,0.42,0.295c-0.933-0.388-1.226-0.348-1.316-0.283c-0.119,0.079-0.056,0.114,0.105,0.2
					c0.249,0.141,0.638,0.259,0.781,0.207c0.078-0.031,0.032-0.108,0.003-0.16c0.578,0.355,0.845,0.517,1.162,0.369
					c0.083,0.01,0.083,0.01,0.258,0.271c0.075,0.109,0.192,0.146,0.392,0.133c-0.144-0.142-0.34-0.337-0.485-0.479
					c0.301-0.055,0.602-0.063,1.314,0.04C20.303,18.341,20.459,18.318,20.652,18.269z"/>
				<polygon points="15.414,17.608 15.069,17.396 15.081,17.672 "/>
				<path d="M12.211,18.132c0.518-0.013,0.419-0.403,0.036-0.472c-0.027-0.005-0.059-0.008-0.089-0.011
					c-0.31-0.018-0.488,0.12-0.745,0.063c0.068,0.068,0.146,0.137,0.27,0.206C11.816,17.993,12.017,18.062,12.211,18.132z"/>
				<path d="M8.33,17.915c0.294,0.122,0.501,0.153,0.599,0.159c0.515,0.04,0.666-0.092,1.048-0.115
					c0.778-0.044,0.686,0.218,1.335,0.241c0.123,0,0.168-0.043,0.168-0.043c0.002,0-0.025-0.164-0.458-0.232
					c-0.541-0.086-0.491-0.27-0.485-0.27c0.206,0.017,0.165,0.086,0.4,0.097c0.003,0,0.304-0.224-1.453-0.393
					c-0.544-0.044-0.908-0.055-1.44-0.037c0.19,0.188,0.274,0.275,0.209,0.447C8.211,17.867,8.211,17.867,8.33,17.915z"/>
				<path d="M15.944,18.577c0.414-0.026,0.604-0.026,0.858,0.031c-0.402-0.195-0.634-0.248-1.114-0.259
					c-0.359-0.009-0.553-0.046-0.879-0.167c0.095,0.096,0.183,0.19,0.342,0.276C15.414,18.608,15.648,18.594,15.944,18.577z"/>
				<path d="M14.129,18.384l-0.14-0.27c-0.035-0.009-0.075-0.017-0.121-0.023C13.868,18.091,13.515,18.098,14.129,18.384
					z"/>
				<path d="M21.62,20.366c0.111,0.057,0.246,0.068,0.417,0.079c0.068-0.008,0.136-0.005,0.204,0
					c-0.163-0.132-0.336-0.194-0.602-0.224c-0.053-0.003-0.112-0.005-0.17-0.005C21.499,20.268,21.532,20.316,21.62,20.366z"/>
				<path d="M24.889,20.738c0.098,0.058,0.227,0.101,0.266,0.081c0.053-0.028-0.154-0.19-0.221-0.241
					C24.625,20.578,24.846,20.71,24.889,20.738z"/>
				<path d="M17.844,20.016c0.024,0.019,0.057,0.045,0.096,0.06c0.159,0.084,0.338,0.084,0.532,0.089
					c0.151,0.003,0.319-0.012,0.461,0.018c-0.103-0.069-0.194-0.098-0.399-0.118C18.302,20.047,18.043,20.055,17.844,20.016z"/>
				<path d="M26.881,23.708c-0.111,0-0.2-0.012-0.282-0.025c0.02,0.014,0.051,0.031,0.076,0.045
					c0.3,0.152,0.719,0.233,0.854,0.164c0.131-0.072-0.25-0.206-0.33-0.215C27.064,23.667,26.997,23.702,26.881,23.708z"/>
				<path d="M8.61,23.357c0.006,0,0.018,0,0.021,0.003c0.298,0.05,0.406,0.021,0.333-0.089
					c-0.05-0.081-0.12-0.189-0.389-0.225C8.281,23.03,8.6,23.353,8.61,23.357z"/>
				<path d="M6.735,23.013c0.042,0.052,0.086,0.106,0.18,0.156c0.053,0.027,0.118,0.056,0.237,0.068
					c0.132,0.017,0.289,0.008,0.423,0.017c-0.168-0.138-0.337-0.194-0.636-0.229C6.871,23.019,6.808,23.019,6.735,23.013z"/>
				<path d="M21.604,25.066c0.175,0.015,0.347,0.003,0.562-0.017c0.498-0.041,0.602-0.026,1.51,0.103
					c1.213,0.176,1.95,0.281,2.271,0.129c0.121-0.063,0.121-0.16,0.123-0.235c-0.089-0.017-0.179-0.032-0.286-0.04
					c-0.313-0.011-0.38,0.026-0.488,0.155c-0.903-0.247-1.533-0.281-2.606-0.281c-0.507,0-1.273,0.005-1.94-0.086
					c0.039,0.02,0.089,0.045,0.128,0.063C21.04,24.935,21.293,25.04,21.604,25.066z"/>
				<path d="M18.37,24.744c0.127-0.071-0.03-0.191-0.097-0.249c-0.869,0.034-0.869,0.034-1.022,0.08
					c0.021,0.017,0.046,0.037,0.086,0.058C17.606,24.778,18.203,24.846,18.37,24.744z"/>
				<path d="M17.041,24.942c0.183-0.092-0.198-0.557-1.017-0.637c-0.171-0.018-0.345-0.015-0.643,0.028
					c0.089,0.095,0.209,0.189,0.369,0.281C16.212,24.877,16.848,25.04,17.041,24.942z"/>
				<polygon points="13.072,24.202 12.867,24.019 12.6,23.995 12.799,24.179 "/>
				<path d="M20.516,24.896c0.029-0.012,0.042-0.026,0.044-0.04c-0.194-0.043-0.451-0.092-0.65-0.132
					c0.043,0.034,0.092,0.063,0.146,0.098C20.235,24.914,20.428,24.948,20.516,24.896z"/>
				<path d="M25.303,26.643c0.182,0.092,0.317,0.104,0.423,0.034c0.048-0.028,0.073-0.06,0.099-0.094
					c0.122,0.036,0.279,0.089,0.399,0.123c-0.041-0.139-0.243-0.225-0.593-0.259C25.438,26.438,24.842,26.413,25.303,26.643z"/>
				<path d="M24.066,26.52c0.042-0.038-0.056-0.136-0.265-0.155c-0.118-0.009-0.194,0.009-0.259,0.037
					c0.014,0.003,0.03,0.012,0.036,0.012C23.837,26.522,24.021,26.56,24.066,26.52z"/>
				<path d="M13.288,26.122c0.043,0.01,0.102,0.016,0.146,0.019c0.592,0.065,1.094-0.104,1.686-0.038
					c0.304,0.038,0.602,0.127,0.98,0.242c0.54,0.16,0.84,0.238,1.317,0.229c0.133-0.093-0.086-0.178-0.086-0.27
					c0.184,0.065,0.316,0.108,0.547,0.149c0.459,0.082,0.757-0.075,1.137-0.112c0.134-0.016,0.542-0.056,1.355,0.442
					c0.266,0.157,0.266,0.157,0.532,0.154c0.128-0.089,0.128-0.089-0.563-0.807c-1.704-0.109-3.127-0.351-4.739-0.5
					c-1.839-0.144-2.852-0.176-3.631,0.021c0.072,0.037,0.159,0.08,0.227,0.115C12.726,26.017,13.054,26.086,13.288,26.122z"/>
				<path d="M20.863,26.24c0.007,0.007,0.016,0.01,0.019,0.012c0.228,0.127,0.455,0.152,0.655,0.161
					c-0.108-0.161-0.237-0.201-0.483-0.221c-0.099-0.006-0.216-0.006-0.3-0.026C20.784,26.192,20.824,26.218,20.863,26.24z"/>
				<path d="M23.142,26.709c-0.269-0.015-0.347,0.003-0.064,0.222c0.202,0.154-0.033,0.131-0.187,0.116
					c0.03,0.021,0.073,0.044,0.111,0.064c0.07,0.034,0.236,0.118,0.438,0.065c0.215-0.06,0.434,0.04,0.725,0.224
					c0.297,0.023,0.297,0.023,0.77-0.111c-0.221-0.192-0.411-0.216-0.846-0.235C23.557,27.033,23.377,26.971,23.142,26.709z"/>
				<path d="M18.761,26.588c-0.043-0.003-0.085,0-0.116,0.009c0.027,0.028,0.064,0.061,0.116,0.092
					c0.156,0.08,0.494,0.135,0.608,0.222C19.587,26.86,19.09,26.625,18.761,26.588z"/>
				<polygon points="12.015,26.924 12.37,27.131 12.63,27.156 12.309,26.878 "/>
				<path d="M10.04,27.751c-0.105,0.029-0.007,0.104,0.092,0.158c0.119,0.066,0.45,0.204,0.618,0.164
					c-0.095-0.144-0.181-0.167-0.369-0.184C10.248,27.875,10.153,27.857,10.04,27.751z"/>
				<path d="M11.262,28.032c0.009,0.007,0.022,0.012,0.025,0.012c0.356,0.201,0.715,0.247,0.958,0.258
					c-0.168-0.188-0.21-0.188-0.715-0.226C11.418,28.067,11.333,28.056,11.262,28.032z"/>
				<path d="M16.287,29.021c0.273,0.229,0.513,0.431,0.761,0.56c0.013,0.01,0.031,0.018,0.046,0.026
					c0.16-0.092,0.913-0.063,0.842-0.185c-0.005-0.014-0.056-0.028-0.082-0.039c-0.192-0.092-0.377-0.179-0.57-0.271
					c-0.221-0.104-0.439-0.206-0.667-0.311c-0.013,0-0.029,0-0.043,0c-0.07,0.013-0.062,0.034-0.008,0.133
					c0.057,0.098,0.046,0.115-0.019,0.129C16.422,29.058,16.358,29.037,16.287,29.021z"/>
				<path d="M15.065,29.233c0.092-0.058,0.517,0.017,0.556-0.047c0.035-0.068-0.126-0.209-0.396-0.241
					c-0.155-0.008-0.159,0.04-0.267,0.05c-0.138,0.011-0.283-0.026-0.361-0.044c0.14,0.086,0.32,0.201,0.459,0.287
					C15.06,29.238,15.06,29.236,15.065,29.233z"/>
				<path d="M19.198,29.525c0.002,0,0.119-0.149-0.338-0.194c-0.207-0.016-0.442,0.031-0.298,0.103
					C18.727,29.52,19.107,29.574,19.198,29.525z"/>
				<path d="M16.462,29.46c0.07-0.135-0.289-0.25-0.432-0.376c-0.115-0.012-0.271-0.026-0.388-0.034
					c0.096,0.098,0.202,0.194,0.376,0.289C16.168,29.417,16.319,29.46,16.462,29.46z"/>
				<path d="M153.041,36.671c0.243,0.1,0.667,0.191,0.795,0.114c0.042-0.025,0.042-0.025-0.741-0.316
					C152.611,36.481,152.931,36.624,153.041,36.671z"/>
				<path d="M19.255,29.796c0.099-0.046,0.029-0.13-0.006-0.172c-0.064,0.074-0.086,0.068-0.534-0.01
					c-0.31-0.054-0.499-0.024-0.345,0.052C18.647,29.808,19.104,29.876,19.255,29.796z"/>
				<path d="M1.653,13.7c0.117,0.063,0.231,0.083,0.273,0.089c0.101,0.015,0.232,0.013,0.342,0.018
					c0.308,0.017,0.561,0.063,0.839,0.098c0.612,0.072,0.841,0.126,1.397,0.282c0.065-0.052,0.146-0.115,0.211-0.167
					c0.548,0.212,1.744,0.462,1.906,0.264c0.022-0.025,0.01-0.063,0.006-0.092c0.169-0.022,0.248,0.034,0.388,0.145
					c0.149,0.12,0.242,0.131,0.334,0.108c0.013,0,0.025,0,0.036,0.003c0.042,0.009,0.081,0.017,0.14,0.02
					c0.037-0.011,0.079-0.022-0.007-0.148c-0.025-0.053-0.232-0.101-0.022-0.149c0.067,0,0.112,0.006,0.151,0.015
					c-0.354-0.099-0.618-0.157-0.914-0.188c-0.394-0.026-0.526,0.015-0.514,0.161c-0.32-0.086-0.551-0.19-0.94-0.265
					c-0.27-0.052-0.303,0.012-0.313,0.029c-0.016,0.043,0.003,0.083,0.027,0.123c-0.229-0.123-0.645-0.353-2.171-0.358
					c-0.837,0-1.176-0.092-1.338-0.139C1.53,13.6,1.573,13.652,1.653,13.7z"/>
				<path d="M22.383,26.474c-0.002,0-0.008,0.002-0.008,0.002c-0.006-0.051,0.006-0.103,0.212-0.058
					c0.192,0.041,0.214,0.115,0.51,0.136c0.165,0.011,0.133-0.089,0.133-0.089c-0.033-0.052-0.156-0.098-0.363-0.146
					c-0.21-0.049-0.275-0.089-0.352-0.17c-0.317-0.011-0.202,0.095-0.326,0.138c-0.1,0.035-0.275,0.003-0.459-0.034
					c0.046,0.053,0.079,0.104,0.188,0.152c0.165,0.077,0.557,0.112,0.708,0.187c0.02,0,0.04,0,0.062,0
					C22.734,26.545,22.411,26.476,22.383,26.474z"/>
				<path d="M3.826,25.023c0.182,0.003,0.277,0.014,0.385,0.114c0.248-0.135,0.561-0.166,1.487,0.08
					c0.538,0.145,0.742,0.162,0.866,0.075c0.51,0.184,0.876,0.386,1.416,0.566c0,0,0.152,0.045,0.362,0.024
					c0.48-0.045,0.527-0.048,0.89,0.185c0.003-0.144-0.313-0.281-0.111-0.426c0.176-0.005,0.176-0.005,0.691,0.285
					c0.126,0.071,0.239,0.146,0.445,0.204c0.042-0.084-0.254-0.146-0.292-0.225c-0.03-0.063,0.167-0.115,0.244-0.169
					c0.033,0.012,0.076,0.025,0.1,0.037c0.228,0.101,0.289,0.218,0.513,0.322c0.126,0.061,0.218,0.079,0.332,0.068
					c-0.359-0.336-0.319-0.396,0.223-0.348c0.5,0.044,0.61,0.015,0.352-0.275c-1.931-0.232-2.388-0.284-3.023-0.126
					c-0.767-0.222-1.263-0.296-2.321-0.364c-1.117-0.07-1.649-0.147-2.576-0.466c-0.698,0.195-0.607,0.238-0.329,0.373
					C3.517,24.978,3.609,25.023,3.826,25.023z"/>
				<path d="M7.974,26.921c0,0,0.104-0.008,0.332,0.021c0.271,0.04,0.498,0.092,0.764,0.129
					c0.504,0.072,0.636,0.015,0.798-0.058c0.121-0.055,0.207-0.086,0.339-0.089c0.788-0.022,1.209,0.156,1.905,0.181
					c-0.234-0.134-0.414-0.207-0.855-0.27c-0.24-0.032-0.525-0.037-0.784-0.055c-1.058-0.077-1.97-0.221-2.968-0.326
					C3.735,26.071,2.4,26.02,1.521,26.025c0.022,0.075,0.055,0.178,0.081,0.256c-0.003-0.003-0.269-0.259-0.747-0.33
					c-0.28,0.014-0.129,0.089,0.08,0.194c0.473,0.23,0.843,0.302,1.05,0.343c0.052,0.011,0.132,0.021,0.19,0.031
					c0.319,0.043,0.675,0.071,1.019,0.105c0.281,0.029,0.464,0.092,0.676,0.142c0.521,0.126,0.663,0.131,0.807,0.106
					c0.442,0.149,0.613,0.231,0.915,0.514c0.246,0,0.389,0.055,0.575,0.221c0.318,0.009,0.528,0.028,1.268,0.133
					c0.108,0.017,0.221,0.031,0.331,0.045c0.271,0.029,0.591,0.041,0.859,0.075c0.274,0.04,0.488,0.098,0.801,0.124
					c0.146,0.008,0.336,0.025,0.367-0.058c0.002-0.016-0.054-0.199-0.207-0.221c-0.266-0.047-0.289,0.079-0.465,0.113
					c-0.204-0.218-0.237-0.235-0.669-0.355c-0.504-0.141-0.685-0.284-1.05-0.571c0.183,0.097,0.417,0.227,0.592,0.321
					C7.855,27.073,7.74,26.952,7.974,26.921z M7.829,27.355l0.344,0.298l-0.251-0.025L7.458,27.32L7.829,27.355z M7.238,27.35
					c-0.061,0.022-0.138,0.04-0.206,0.057c-0.059,0.018-0.107,0.038-0.151,0.058c-0.004,0-0.007,0.006-0.01,0.006
					c-0.017,0.012-0.036,0.022-0.047,0.034c-0.002,0.003-0.007,0.009-0.01,0.012c-0.175-0.184-0.303-0.367-0.421-0.551
					c0.411-0.018,0.937,0.339,0.94,0.341C7.354,27.326,7.275,27.335,7.238,27.35z"/>
				<path d="M18.205,29.425c0.029,0.016,0.073,0.032,0.097,0.016c0.044-0.029-0.038-0.202-0.277-0.351l0.081,0.27
					C18.132,29.383,18.161,29.405,18.205,29.425z"/>
				<path d="M17.021,16.854c-0.425-0.146-1.418-0.491-3.549-0.555c-1.114-0.425-0.739-0.603-0.524-0.66
					c0.042,0,0.104,0,0.144,0c-0.624-0.247-1.107-0.325-2.333-0.38c-0.86-0.039-1.305-0.068-1.961-0.221
					c-0.049-0.011-0.114-0.028-0.167-0.042c-0.386,0.169-0.929,0.2-2.947-0.07c-1.253-0.171-1.758-0.2-2.169-0.131
					c0.02,0.014,0.049,0.034,0.076,0.052c0.086,0.051,0.34,0.207,0.655,0.166c0.5-0.063,0.743,0.12,0.955,0.287
					c0.014-0.043,0.011-0.086,0.115-0.126c0.02,0,0.05,0,0.07-0.003c0.469,0.088,0.593,0.232,0.994,0.33
					c0.07-0.046,0.162-0.104,0.229-0.148c0.653,0.255,0.936,0.234,1.325,0.209c0.78-0.052,1.105,0.14,1.162,0.181
					c0.134,0.087,0.134,0.087-0.431,0.311c0.917,0.364,0.985,0.373,4.709,0.683c0.071-0.049,0.163-0.114,0.231-0.164
					c0.689,0.089,0.869,0.322,1.848,0.325C15.982,16.896,16.455,16.782,17.021,16.854z M11.049,16.007
					c-0.062-0.038-0.179-0.067-0.144-0.109c0-0.003,0.362-0.213,0.427-0.222c0.221,0.17,0.626,0.331,0.752,0.509
					C11.234,16.112,11.234,16.112,11.049,16.007z"/>
				<path d="M6.645,23.599c-0.691-0.097-1.344-0.206-2.063-0.293c-0.541-0.058-0.541-0.058-0.905,0.037l4.043,0.399
					c-0.083-0.034-0.237-0.109-0.403-0.132C7.1,23.578,6.862,23.631,6.645,23.599z"/>
				<path d="M158.411,6.96h0.005c0.82,0.064,0.596-0.184,0.26-0.562c-0.055-0.003-0.112-0.007-0.16-0.012
					c-0.566-0.006-0.448,0.148-0.129,0.571C158.399,6.96,158.411,6.96,158.411,6.96z"/>
				<path d="M187.374,11.516c0.013,0,0.024,0.005,0.024,0.005c0.755,0.069,0.647-0.212,0.3-0.391
					c-0.177-0.086-0.211-0.092-0.448-0.103c-0.135,0-0.229,0.017-0.205,0.092C187.08,11.257,187.314,11.384,187.374,11.516z"/>
				<path d="M118.843,9.579c0.654,0.044,1.032,0.047,0.59-0.27c-0.059-0.003-0.123-0.006-0.182-0.009
					c-0.519-0.015-0.648,0.061-0.459,0.278C118.814,9.579,118.826,9.579,118.843,9.579z"/>
				<path d="M75.722,7.779c-0.07-0.164-0.14-0.173-0.747-0.229c0.016,0.008,0.041,0.022,0.058,0.031
					C75.298,7.735,75.528,7.769,75.722,7.779z"/>
				<path d="M107.964,9.915c0.116,0.106-0.102,0.233,0.3,0.327c0.777,0.183,1.58,0.204,2.346,0.207
					c1.308,0.003,1.686,0.044,2.099,0.109c0-0.083-0.013-0.191-0.019-0.275c-0.205-0.101-0.631-0.308-1.562-0.463
					c-1.133-0.184-2.523-0.243-3.714-0.401c0.036,0.043,0.072,0.098,0.113,0.138C107.651,9.677,107.828,9.792,107.964,9.915z"/>
				<path d="M31.152,6.116c-0.363-0.194-0.685-0.278-1.176-0.315c-0.304-0.018-0.62-0.012-0.932-0.018
					c0.032,0.012,0.064,0.029,0.092,0.04C29.509,5.973,30.259,6.214,31.152,6.116z"/>
				<path d="M31.799,6.15c0.042-0.034-0.093-0.149-0.32-0.171c-0.095-0.004-0.165,0.011-0.246,0.045
					c0.013,0.006,0.03,0.012,0.048,0.018C31.603,6.165,31.762,6.18,31.799,6.15z"/>
				<path d="M129.317,11.162c-0.046-0.207-0.27-0.244-0.776-0.284c-0.343-0.028-0.507-0.055-0.649-0.136
					c-0.118,0.021-0.425,0.066-0.146,0.187C128.057,11.067,128.852,11.185,129.317,11.162z"/>
				<path d="M143.18,12.013c0,0,0.584,0.048,0.769,0.025c0.064-0.007,0.364-0.141-0.19-0.225
					c-0.353-0.049-0.565-0.058-0.66-0.06c-0.448-0.009-0.625,0.057-0.566,0.227c0.012,0,0.019-0.003,0.023-0.003
					C142.72,11.969,142.986,11.992,143.18,12.013z"/>
				<path d="M141.766,11.857c0,0-0.105-0.178-0.79-0.207c-0.012,0-0.942-0.021-0.543,0.163
					C140.875,12.018,141.743,11.918,141.766,11.857z"/>
				<path d="M158.447,12.848c-0.577-0.391-2.029-0.494-2.841-0.522c-0.554-0.015-0.874-0.006-1.226,0.025
					c0.012,0.011,0.047,0.026,0.064,0.034C155.229,12.749,156.372,12.788,158.447,12.848z"/>
				<path d="M29.626,6.826c0.188,0.112,0.456,0.154,0.585,0.089c0.124-0.068-0.257-0.244-0.66-0.272
					c-0.042-0.003-0.076-0.003-0.118-0.006C29.472,6.702,29.524,6.763,29.626,6.826z"/>
				<polygon points="27.895,6.817 27.728,6.616 27.403,6.593 27.571,6.794 "/>
				<path d="M22.036,6.98c1.506,0.228,2.595,0.38,3.956,0.438C26.65,7.68,26.813,8,27.875,8.21
					c0.021,0,0.049,0,0.067-0.003c0.1-0.026,0.11-0.061,0.117-0.092c0.492,0.161,0.786,0.293,1.216,0.539
					c1.777-0.456,3.803,0.139,5.713,0.019c-0.304-0.219-0.426-0.308-1.17-0.442c-0.775-0.147-0.857-0.179-1.228-0.365
					c-0.202,0-0.674,0.003-1.881-0.227c-0.927-0.179-1.282-0.202-1.45-0.092c-0.408-0.145-0.77-0.299-1.067-0.465
					c-0.157-0.087-0.157-0.087-0.348-0.089c-0.182,0.037-0.178,0.117,0.041,0.364c-0.035,0.006-0.091,0.014-0.129,0.02
					c-0.622-0.077,0.03-0.396-0.755-0.353c-0.083-0.012-0.172-0.021-0.267-0.018c0.042,0.092,0.348,0.172,0.322,0.272
					c-0.095,0.009-0.218,0.026-0.334-0.014c-0.041-0.015-0.085-0.031-0.114-0.047c-0.27-0.123,0.026-0.313-0.79-0.369
					c-1.103-0.078-1.463-0.078-1.74,0.065c-0.896-0.23-1.213-0.27-1.562-0.305c-0.037-0.003-0.096-0.005-0.141-0.005
					c-0.05,0.051-0.118,0.123-0.167,0.178c-0.322,0.006-0.448-0.081-0.767-0.078C21.241,6.86,21.715,6.933,22.036,6.98z"/>
				<path d="M148.756,14.008c1.58,0.127,3.265,0.143,4.88,0.238c7.403,0.428,7.403,0.428,8.759,1.046
					c7.238,0.361,7.238,0.361,8.063,0.134c-1.357-0.321-1.214-0.718-1.145-0.833c0.061-0.083,0.171-0.257-1.801-0.607
					c-2.837-0.5-6.52-0.472-9.656-0.788c-0.294,0.23,0.59,0.437,0.295,0.673c-0.744-0.184-1.898-0.275-2.263-0.54
					c-3.361-0.018-3.561-0.018-4.421,0.428c-1.587-0.238-3.49-0.158-5.212-0.262c0.154,0.062,0.319,0.149,0.507,0.204
					C147.413,13.898,148.062,13.953,148.756,14.008z"/>
				<path d="M95.297,11.449c0.283,0.026,1.13,0.105,2.582,0.141c3.052,0.077,4.055,0.35,4.715,0.533
					c0.164-0.021,0.377-0.054,0.542-0.079c-0.1-0.235-0.129-0.316-0.754-0.422c-0.478-0.084-0.478-0.084-0.877-0.302
					c-0.502-0.086-0.89-0.13-1.562-0.161c-1.333-0.037-2.253,0.021-2.8,0.175c-1.632-0.181-2.241-0.249-2.104,0.089
					C95.114,11.429,95.214,11.441,95.297,11.449z"/>
				<path d="M110.263,11.911c0.064-0.046-0.03-0.111-0.078-0.149c-0.311-0.031-0.542-0.101-0.907-0.12
					c-0.078,0-0.561,0.022-0.249,0.158C109.337,11.929,110.128,12.021,110.263,11.911z"/>
				<path d="M103.832,12.348c0.329,0.012,0.647,0.026,0.979,0.037c-0.366-0.215-0.709-0.31-1.186-0.33
					c-0.094-0.003-0.182-0.003-0.283,0c0.124,0.087,0.29,0.201,0.419,0.288C103.785,12.346,103.808,12.348,103.832,12.348z"/>
				<path d="M77.508,11.806c0.249-0.01,0.584-0.026,0.831-0.01c0.809,0.047,1.315,0.13,2.34,0.293
					c0.577,0.099,0.942,0.144,1.185,0.139c0.359-0.018,0.488-0.139,0.949-0.106c0.154,0.012,0.294,0.055,0.359,0.075
					c-0.135-0.129-0.229-0.184-0.73-0.25c-0.342-0.052-0.636-0.115-0.995-0.158c-0.055-0.009-0.12-0.014-0.166-0.02
					c-0.707-0.081-1.498-0.069-2.247-0.112c-1.697-0.095-2.457-0.514-4.178-0.601c-0.989-0.046-2.033-0.021-2.971-0.13
					c0.071,0.034,0.143,0.084,0.212,0.118C73.702,11.854,77.474,11.809,77.508,11.806z"/>
				<path d="M35.299,9.474c0.03,0.014,0.07,0.034,0.1,0.049c0.129-0.018,0.129-0.018,0.049-0.247
					c0.004,0,0.007,0,0.013,0c0.135,0.055,0.19,0.12,0.345,0.178c0.008,0.003,0.092,0.015,0.116-0.014
					c0.046-0.038-0.08-0.158-0.197-0.271c-0.064-0.061-0.14-0.124-0.165-0.192c-0.013,0-0.026,0-0.04,0
					C34.935,8.948,34.899,9.241,35.299,9.474z"/>
				<path d="M102.93,12.953c-0.861-0.028-1.321-0.028-2.021,0.013c0.082,0.061,0.212,0.14,0.342,0.2
					c0.334,0.144,0.753,0.222,1.16,0.296c1.127,0.212,1.48,0.33,1.811,0.756c0.525,0.04,0.879,0.101,1.874,0.313
					c0.684,0.146,1.333,0.287,1.827,0.299c0.567,0.011,0.855-0.135,0.99-0.207c0.402-0.194,0.473-0.21,0.874-0.281
					c-0.619-0.345-1.438-0.672-2.123-1.011C103.632,12.985,103.632,12.985,102.93,12.953z"/>
				<path d="M110.333,13.804l-0.159-0.181c-0.046-0.005-0.095-0.012-0.148-0.015c-0.289-0.009-0.182,0.112-0.03,0.279
					C110.098,13.861,110.233,13.83,110.333,13.804z"/>
				<path d="M46.594,10.946c0.317,0.018,0.633,0.037,0.949,0.055c-0.362-0.25-0.632-0.419-1.07-0.45
					c-0.093-0.003-0.19,0-0.277,0.008c0.101,0.115,0.232,0.268,0.333,0.383C46.55,10.944,46.574,10.946,46.594,10.946z"/>
				<path d="M41.214,10.823c0.006,0.003,0.009,0.008,0.013,0.011c0.033,0.021,0.06,0.041,0.086,0.061
					c0.103-0.045,0.244-0.108,0.349-0.152c-0.211-0.126-0.455-0.197-0.853-0.243C40.871,10.622,40.904,10.643,41.214,10.823z"/>
				<path d="M28.131,9.763c-0.112-0.082-0.169-0.108-0.263-0.12c-0.238-0.006-0.342,0.115-0.533,0.063
					c0.043,0.04,0.089,0.075,0.146,0.109c0.121,0.072,0.207,0.075,0.263,0.068C27.995,9.867,27.961,9.799,28.131,9.763z"/>
				<path d="M74.374,12.531c0.021,0.013,0.052,0.023,0.082,0.034c0.312,0.139,0.695,0.184,0.955,0.21
					c0.701,0.067,1.456,0.049,2.182,0.084c-0.308-0.11-0.826-0.241-2.088-0.311C74.975,12.526,74.668,12.526,74.374,12.531z"/>
				<path d="M44.846,11.371c0.144-0.079,0.144-0.178,0.355-0.258c0.146-0.058,0.262-0.055,0.446-0.049
					c0.003-0.037,0-0.078-0.173-0.101c-0.014-0.004-0.039-0.006-0.059-0.009c-0.306-0.031-0.653-0.009-0.967-0.037
					c-0.531-0.052-0.872-0.17-1.43-0.213c-0.098-0.003-0.188,0-0.283,0.006c0.101,0.075,0.207,0.149,0.33,0.218
					C43.661,11.271,44.407,11.636,44.846,11.371z"/>
				<path d="M36.668,10.499c0.065-0.035,0.036-0.092-0.106-0.173l-0.417,0.065c0.016,0.021,0.038,0.044,0.072,0.061
					C36.348,10.524,36.583,10.538,36.668,10.499z"/>
				<path d="M35.377,10.47c0.026,0.018,0.064,0.037,0.106,0.052c0.121-0.018,0.283-0.046,0.403-0.063
					c-0.055-0.089-0.3-0.115-0.367-0.121C35.307,10.326,35.195,10.37,35.377,10.47z"/>
				<path d="M83.132,13.227c0.135,0.069,0.27,0.075,0.377,0.021c0.058-0.032,0.082-0.069,0.104-0.106
					c-0.229-0.069-0.366-0.098-0.495-0.104C82.794,13.026,83.132,13.227,83.132,13.227z"/>
				<path d="M84.971,13.761c0.27,0,0.824,0.034,0.93,0.046c0.448,0.046,1.12,0.026,1.304-0.005
					c0.158-0.023,0.617-0.168-0.195-0.362c-0.378-0.093-0.897-0.155-1.521-0.185c-0.507-0.02-0.779-0.014-0.991,0.023
					c0.131,0.144,0.295,0.336,0.425,0.482C84.941,13.761,84.953,13.761,84.971,13.761z"/>
				<path d="M177.833,17.315c0.23,0.015,0.454,0,0.678,0.007c-0.249-0.11-0.607-0.176-1.145-0.21
					c0.012,0.031,0.024,0.095,0.129,0.143C177.59,17.296,177.72,17.307,177.833,17.315z"/>
				<path d="M125.109,15.788c0.383,0.052,0.459-0.026,0.459-0.026c0-0.003-0.058-0.187-0.942-0.221
					c-0.249-0.008-0.507-0.008-0.761-0.018c0.011,0.003,0.03,0.01,0.042,0.01C124.308,15.619,124.638,15.725,125.109,15.788z"/>
				<polygon points="67.347,14.295 66.982,14.082 66.88,14.364 "/>
				<path d="M76.4,16.055c0.107-0.068-0.365-0.151-0.365-0.151c-0.153-0.003-0.07,0.097,0.03,0.149
					C76.159,16.099,76.295,16.124,76.4,16.055z"/>
				<path d="M139.03,19.918c0.283,0.063,0.549-0.041,0.809-0.067c-0.078-0.1-0.454-0.123-0.56-0.129
					C138.607,19.702,138.984,19.905,139.03,19.918z"/>
				<path d="M73.335,17.281c0.59,0.27,1.262,0.264,2.371,0.259c-0.214-0.144-0.461-0.204-0.973-0.233
					c-0.49-0.021-1.014,0.006-1.467-0.06C73.288,17.259,73.312,17.271,73.335,17.281z"/>
				<path d="M24.868,15.316c0.063,0.023,0.141,0.058,0.202,0.081c0.737,0.282,1.305,0.29,1.967,0.299
					c0.501,0.008,1.274,0.052,1.397,0.063c0.07,0.006,0.163,0.018,0.237,0.023c1.233,0.139,2.474,0.271,3.705,0.408
					c0.676,0.077,1.333,0.166,1.994,0.247c0.064-0.047,0.18-0.126,0.448-0.132c0.465-0.018,0.797,0.079,1.249,0.076
					c-0.363-0.22-0.529-0.327-4.491-0.681C29.041,15.53,27.261,15.432,24.868,15.316z"/>
				<path d="M45.766,17.618c-0.163,0.048-0.343,0.1-0.77,0.071c-0.81-0.052-1.393-0.207-2.218-0.254
					c-0.757-0.039-1.503,0.122-2.263,0.01c-1.959-0.285-1.959-0.285-3.789-0.382c-1.908-0.104-2.724-0.161-3.809-0.275
					C32.348,16.988,32.321,17,32.14,17c-0.645,0.021-0.943-0.141-1.539-0.149c-0.462-0.006-0.75,0.307-0.06,0.439
					c0.647,0.124,1.206,0.172,1.443,0.192c0.073,0.006,0.171,0.011,0.244,0.018c1.002,0.074,2.063,0.068,3.091,0.108
					c1.274,0.047,1.37,0.063,2.098,0.213c0.531,0.104,0.798,0.158,1.133,0.151c0.341,0.296,1.108,0.429,1.694,0.486
					c0.361,0.04,0.745,0.043,1.125,0.058c1.289,0.054,2.104,0.31,3.321,0.394c0.163,0.014,0.227-0.037,0.257-0.063
					c0.132-0.109,0.181-0.152,1.91,0.061c1.415,0.171,1.949,0.241,2.761,0.212c0.069-0.246-0.227-0.485-0.238-0.729
					c1.06-0.003,2.089,0.086,3.159,0.069c0.86-0.021,1.005-0.055,1.435-0.155c-2.18-0.185-4.193-0.454-6.336-0.654
					C46.073,17.534,46.073,17.534,45.766,17.618z M39.53,17.878c-0.003-0.005-0.012-0.008-0.02-0.011
					c0.099,0.023,0.185,0.026,0.247,0.014c0.339,0.023,0.53,0.034,0.583,0.21C40.202,18.074,39.821,18.027,39.53,17.878z M45.188,18.502
					c-0.044-0.003-0.082-0.009-0.118-0.015c-0.333-0.058-0.327-0.206-0.465-0.296c0.145,0.032,0.329,0.026,0.365,0.023
					c0.428-0.023,0.517,0.071,0.551,0.111C45.128,18.31,45.581,18.52,45.188,18.502z"/>
				<path d="M28.277,17.098c0.817,0.114,1.091,0.338,1.769,0.479c0.064-0.02,0.154-0.055,0.212-0.074l-0.468-0.486
					c-0.206-0.058-0.478-0.132-0.777-0.154c-0.373-0.026-0.718,0.034-1.087,0.022c-0.462-0.201-0.772-0.275-1.316-0.327
					c-0.61-0.028-1.215,0.026-1.819,0.006c0.076,0.052,0.171,0.117,0.284,0.167c0.34,0.146,0.739,0.175,1.299,0.221
					c0.853,0.065,1.11,0.146,1.487,0.284C27.986,17.195,28.154,17.138,28.277,17.098z"/>
				<path d="M53.882,19.372c0.013,0,0.022,0.005,0.031,0.005c0.405,0.047,0.573,0.007,0.629-0.011
					c0.006,0,0.012-0.006,0.026-0.006c0.254-0.095-0.366-0.23-0.471-0.241C53.908,19.114,53.652,19.159,53.882,19.372z"/>
				<path d="M31.626,17.836c-0.379-0.078-0.886-0.098-1.328-0.146c0.639,0.209,0.69,0.468,1.101,0.694
					c0.075,0.041,0.162,0.081,0.283,0.112c0.041-0.081,0.006-0.16-0.03-0.238c-0.062-0.126-0.093-0.207-0.031-0.25
					c0.106-0.066,0.479,0.032,0.685,0.083C32.213,18.033,32.026,17.915,31.626,17.836z"/>
				<path d="M66.84,19.992c0.035,0.028,0.083,0.058,0.129,0.083c0.307,0.163,0.666,0.158,0.795,0.155
					C67.595,20.139,67.36,20.047,66.84,19.992z"/>
				<path d="M64.501,20.606c-0.289-0.017-0.289-0.017-0.855-0.235c-0.317-0.012-0.423,0.09-0.755,0.074
					c-0.188-0.011-0.369-0.089-0.494-0.144c0.036,0.102,0.095,0.195,0.19,0.293c0.152,0.149,0.211,0.305,0.393,0.457
					c0.03,0.025,0.171,0.049,0.243,0.066c0.022,0.008,1.938,0.477,3.023,0.154c0.194-0.055,0.371-0.109,0.613-0.109
					c0.219,0,0.661,0.063,0.842,0.087c0.626,0.086,1.203,0.12,1.287,0.126c0.672,0.023,1.179-0.2,1.902-0.08
					c-0.159-0.144-0.27-0.235-0.642-0.333c-0.567-0.149-1.42-0.101-2.134-0.149c-0.736-0.055-0.855-0.195-1.036-0.477
					c-0.143-0.232-0.377-0.345-1.333-0.402c-0.354-0.017-0.731-0.017-1.05-0.055c0.543,0.324,0.796,0.399,1.403,0.434
					c0.437,0.023,0.613,0.058,0.955,0.241C66.311,20.676,65.132,20.642,64.501,20.606z"/>
				<path d="M29.442,17.941c0.16-0.092-0.28-0.16-0.28-0.16c-0.121-0.006-0.056,0.086,0.03,0.132
					C29.262,17.953,29.362,17.982,29.442,17.941z"/>
				<path d="M83.144,21.808c0.283,0.025,0.565,0.002,0.277-0.257c-0.178-0.008-0.407-0.02-0.577-0.025l0.283,0.282
					H83.144z"/>
				<path d="M48.691,19.74c-1.163-0.067-2.369-0.09-3.509-0.179c0.138,0.179,0.212,0.275,0.536,0.422
					c0.153,0.066,0.33,0.135,0.49,0.204c0.05,0.026,0.067,0.063,0.153,0.083c0.064,0.015,0.24,0.038,0.366-0.066
					c0.095-0.086,0.068-0.175,0.259-0.249c0.067-0.031,0.311-0.037,0.445-0.055c0.35,0.095,0.465,0.224,0.88,0.304
					c0.458,0.092,1.32,0.187,1.592,0.184c0.177-0.045-0.005-0.12,0.171-0.166c0.195,0.012,0.371,0.035,0.53,0.066
					c0.007,0.003,0.642,0.112,0.879,0.08c0.327-0.043-0.008-0.327-0.02-0.33C51.46,20.038,50.439,19.851,48.691,19.74z"/>
				<path d="M82.365,21.732c0.146,0.066,0.473,0.124,0.53,0.08c0.059-0.043-0.224-0.167-0.347-0.221
					C82.194,21.623,82.253,21.684,82.365,21.732z"/>
				<polygon points="51.832,20.245 52.179,20.268 51.983,20.067 51.636,20.05 "/>
				<path d="M28.8,18.727c0.248,0.14,0.546,0.14,0.669,0.137c-0.201-0.112-0.455-0.184-0.795-0.227
					C28.708,18.666,28.747,18.697,28.8,18.727z"/>
				<path d="M33.642,19.441c-0.158-0.01-0.154,0.065-0.062,0.114c0.039,0.022,0.227,0.109,0.475,0
					C33.824,19.463,33.712,19.446,33.642,19.441z"/>
				<polygon points="81.988,22.301 81.447,22.275 81.634,22.45 82.177,22.479 "/>
				<path d="M59.19,21.233c0.129,0.068,0.289,0.073,0.577,0.092c-0.119-0.058-0.254-0.133-0.364-0.19l-0.354-0.02
					C59.083,21.155,59.12,21.192,59.19,21.233z"/>
				<polygon points="31.735,19.562 32.045,19.584 31.862,19.403 31.549,19.381 "/>
				<path d="M29.153,19.481c0.153,0.083,0.254,0.08,0.395,0.052c0.075-0.021,0.191-0.034,0.451,0
					c-0.084-0.087-0.198-0.199-0.283-0.282c-0.094,0.061-0.112,0.061-0.392,0.031C29.316,19.279,28.694,19.234,29.153,19.481z"/>
				<path d="M41.831,21.681c0.036,0.017,0.077,0.046,0.117,0.066c0.841,0.398,2.854,0.246,3.048,0.16
					c0.101-0.043,0.006-0.118-0.129-0.215C42.813,21.583,42.324,21.561,41.831,21.681z"/>
				<path d="M37.385,21.517c0.16,0.084,0.353,0.089,0.624,0.095c0.165,0.007,0.348-0.008,0.497,0.018
					c-0.058-0.052-0.129-0.126-0.19-0.184c-0.187-0.133-0.329-0.184-0.571-0.207C37.567,21.23,36.917,21.278,37.385,21.517z"/>
				<path d="M40.367,21.663c0.243,0.133,0.516,0.136,0.684,0.139c-0.168-0.196-0.401-0.296-0.745-0.322
					c-0.053,0-0.109-0.003-0.165-0.003C40.192,21.54,40.255,21.604,40.367,21.663z"/>
				<path d="M34.862,21.21c0.043,0.034,0.086,0.061,0.138,0.089c0.188,0.098,0.401,0.135,0.542,0.152
					c0.382,0.042,0.817,0.034,1.215,0.06c-0.172-0.129-0.45-0.284-1.106-0.335C35.251,21.152,35,21.181,34.862,21.21z"/>
				<path d="M32.313,21.255c0.858,0.007,1.282,0.023,1.648,0.064c-0.434-0.207-0.767-0.313-1.934-0.4
					c-0.931-0.065-1.921-0.052-2.856-0.117c0.086,0.028,0.191,0.068,0.28,0.092C30.503,21.213,31.44,21.247,32.313,21.255z"/>
				<path d="M39.118,21.5c0.046,0.037,0.094,0.074,0.167,0.105c0.247,0.124,0.536,0.121,0.663,0.121
					c-0.051-0.105-0.135-0.181-0.41-0.201C39.404,21.514,39.237,21.525,39.118,21.5z"/>
				<path d="M28.959,20.951c0.079-0.04-0.036-0.126-0.092-0.166c-0.024,0.028-0.059,0.074-0.218,0.063
					c-0.311-0.023-0.448-0.093-0.69-0.133c0.027,0.028,0.06,0.058,0.116,0.086C28.308,20.917,28.83,21.021,28.959,20.951z"/>
				<path d="M50.958,26.071c0.007-0.003,0.463-0.301-0.736-0.391c-0.448-0.025-0.942-0.015-1.337-0.083
					c0.023,0.011,0.05,0.028,0.076,0.04C49.509,25.91,50.673,26.218,50.958,26.071z"/>
				<path d="M41.3,25.362c-0.034-0.023-0.068-0.05-0.111-0.071c-0.003-0.004-0.01-0.01-0.019-0.013
					c-0.124-0.065-0.283-0.126-0.599-0.151c-0.037,0-0.082-0.003-0.119-0.006c0.04,0.034,0.085,0.063,0.138,0.092
					C40.848,25.345,41.109,25.356,41.3,25.362z"/>
				<path d="M28.784,24.472c-0.029-0.021-0.056-0.037-0.084-0.055c-0.006-0.003-0.009-0.009-0.014-0.009
					c-0.131-0.074-0.301-0.149-0.56-0.172c0.017,0.012,0.036,0.022,0.052,0.034C28.45,24.427,28.644,24.458,28.784,24.472z"/>
				<path d="M54.248,26.177c-0.165-0.011-0.35,0.01-0.515-0.011l0.835,0.132C54.495,26.224,54.413,26.195,54.248,26.177z
					"/>
				<path d="M111.264,29.904c-0.23-0.108-0.442-0.218-0.607-0.33c-0.082,0.021-0.247,0.066-0.524,0.044
					c-0.524-0.044-0.879-0.146-1.361-0.198l0.106,0.267c0.029,0.003,0.072,0.006,0.106,0.006c1.426,0.115,1.369,0.574,2.922,0.657
					C111.954,30.247,111.812,30.169,111.264,29.904z"/>
				<path d="M103.183,29.187l0.308,0.275c-0.638-0.103-1.009-0.131-1.798-0.134c-0.654-0.003-1.019-0.037-1.486-0.098
					c0.046,0.011,0.101,0.028,0.148,0.043c1.562,0.393,3.867,0.407,5.499,0.29c-0.207-0.086-0.459-0.193-0.884-0.251
					C104.42,29.233,103.737,29.256,103.183,29.187z"/>
				<polygon points="106.837,29.417 107.168,29.71 107.769,29.732 107.245,29.434 "/>
				<path d="M59.75,27.393c0.265-0.026,0.146-0.112,0.017-0.184c-0.011-0.006-0.011-0.009-0.024-0.016
					c-0.058-0.028-0.116-0.058-0.175-0.079c-0.101-0.01-0.237-0.018-0.343-0.023l0.501,0.304C59.731,27.395,59.743,27.395,59.75,27.393z
					"/>
				<path d="M27.397,25.401c0,0,0.006,0,0.009,0c0.174-0.011,0.242,0.023,0.347,0.041
					c0.969,0.155,1.233,0.195,0.917-0.109c-0.685-0.011-1.033-0.106-1.359-0.373C27.017,25.012,26.961,25.089,27.397,25.401z"/>
				<path d="M141.023,31.447c0.294,0.022,0.684,0.055,0.985,0.074c1.868,0.106,3.8,0.135,5.676,0.238
					c1.078,0.061,1.915,0.27,3.113,0.247c0.152-0.052,0.135-0.12,0.317-0.169c0.047-0.003,0.106-0.006,0.146-0.003
					c1.233,0.089,2.234,0.28,3.46,0.37c1.767,0.13,3.612,0.181,5.411,0.281c0.473,0.026,0.93,0.049,1.403,0.066
					c2.616,0.095,2.627,0.092,3.17-0.115c0.578,0.021,0.565,0.218,1.231,0.213c0.076-0.026,0.076-0.026-0.759-0.383
					c1.261,0.17,2.181,0.435,3.464,0.592c0.567,0.066,1.251,0.021,1.469,0.003c-0.313-0.247-1.58-0.173-2.17-0.327
					c0.053-0.08,0.111-0.184,0.16-0.261c-0.507-0.207-0.85-0.144-1.302,0.04c-0.23-0.084-0.537-0.199-0.772-0.288
					c-3.042-0.076-3.042-0.076-3.843-0.286c-5.304,0.065-9.919-0.565-14.972-0.756c-1.486-0.043-2.923,0.123-4.421,0.049
					c-1.414-0.071-2.757-0.21-4.218-0.244c-0.083,0-0.178,0-0.255-0.005c-0.725-0.01-1.12,0.024-1.372,0.048
					c0.304,0.065,0.707,0.155,1.037,0.215C139.279,31.289,140.706,31.427,141.023,31.447z"/>
				<path d="M30.33,25.713c0.195,0.014,0.57,0.005,0.57,0.005c0.288-0.011,0.502-0.005,0.922,0.023
					c-0.251-0.104-0.627-0.225-1.364-0.285c-0.579-0.036-0.923-0.008-1.111,0.021c0.046,0.018,0.102,0.04,0.156,0.055
					C29.934,25.672,30.17,25.695,30.33,25.713z"/>
				<path d="M52.796,27.597c0.405,0.048,0.761,0.071,0.408-0.179c-0.097-0.072-0.097-0.072-0.303-0.086
					c-0.124-0.006-0.185,0-0.248,0.014c-0.003,0.004-0.006,0.004-0.015,0.004c-0.087,0.04-0.053,0.108,0.115,0.241
					C52.768,27.594,52.79,27.597,52.796,27.597z"/>
				<path d="M50.27,27.269c0.032,0.012,0.071,0.021,0.099,0.029c0.804,0.218,1.592,0.252,1.887,0.264
					c-0.089-0.072-0.374-0.287-1.252-0.348C50.642,27.19,50.396,27.211,50.27,27.269z"/>
				<path d="M49.22,27.28c-0.157-0.074-0.372-0.145-0.899-0.184c-0.38-0.023-0.768-0.012-1.149-0.023
					c0.024,0.007,0.058,0.015,0.08,0.021C47.991,27.309,48.451,27.298,49.22,27.28z"/>
				<path d="M46.924,27.172c0.051-0.036-0.035-0.096-0.073-0.121c-0.148-0.009-0.339-0.021-0.484-0.028
					c0.018,0.028,0.048,0.063,0.11,0.092C46.617,27.183,46.854,27.214,46.924,27.172z"/>
				<path d="M152.104,32.501c-0.013-0.003-1.968-0.104-4.267-0.179c-6.095-0.201-6.095-0.201-8.334-0.333
					c0.095,0.035,0.199,0.087,0.318,0.115c0.212,0.058,0.777,0.213,10.385,0.715c4.362,0.23,6.248,0.207,7.048,0.198
					c-2.569-0.229-4.172-0.385-4.745-0.462C152.388,32.542,152.234,32.513,152.104,32.501z"/>
				<path d="M158.481,33.018c-0.476-0.006-0.801-0.046-1.108-0.09c0.095,0.05,0.201,0.107,0.319,0.153
					c0.555,0.213,0.831,0.2,2.4,0.143c0.371-0.011,0.777-0.028,1.107,0.013c-0.383-0.179-0.607-0.23-1.067-0.253
					C159.566,32.972,159.036,33.029,158.481,33.018z"/>
				<path d="M164.163,33.236c-0.477-0.018-0.937-0.061-1.424-0.069c-0.107-0.003-0.254-0.006-0.366,0
					c-0.512,0.006-0.567,0.109-0.607,0.178c0.024-0.006,0.053-0.012,0.064-0.017c0.943-0.173,2.134,0.27,2.811,0.008
					c0.194,0.061,0.448,0.145,0.643,0.204c1.544-0.042,2.299-0.055,3.588,0.015c-0.63-0.192-1.16-0.261-2.293-0.308
					C165.778,33.23,164.965,33.265,164.163,33.236z"/>
				<path d="M171.354,33.719c0.512,0.014,1.032,0.031,1.551,0.045c-0.172-0.12-0.75-0.247-1.233-0.27
					c-0.482-0.009-0.447,0.115-0.365,0.225C171.319,33.719,171.343,33.719,171.354,33.719z"/>
				<path d="M169.669,33.373c-0.465-0.008-0.896,0.084-0.459,0.285c0.011-0.003,0.023-0.003,0.035-0.003
					c0.146-0.01,0.335,0,0.577,0.017c0.459,0.038,0.613,0.026,0.662,0.013c0.129-0.044-0.049-0.22-0.484-0.282
					C169.899,33.391,169.792,33.38,169.669,33.373z"/>
				<path d="M176.531,33.815c0.01-0.045-0.036-0.092-0.089-0.137c-0.795,0.224-1.833-0.185-2.711,0.017
					c0.01,0.005,0.029,0.012,0.052,0.018C174.089,33.787,176.476,34.12,176.531,33.815z"/>
				<path d="M49.161,28.556c-0.23-0.009-0.416,0.055-0.006,0.401c0.012-0.006,0.027-0.012,0.046-0.017
					c0.197-0.081,0.378-0.044,0.584,0.005c0.359,0.087,0.53,0.069,0.713,0.006c-0.094-0.006-0.224-0.014-0.321-0.017
					C49.718,28.624,49.282,28.566,49.161,28.556z"/>
				<path d="M44.333,28.372c-0.187-0.041-0.455-0.041-0.659-0.07c-0.071-0.011-0.166-0.027-0.216-0.039
					c-0.034-0.015-0.092-0.029-0.121-0.035c-0.109-0.039-0.084-0.092-0.3-0.114c-0.024,0-0.046,0-0.064,0
					c-0.075,0.022-0.083,0.039,0.04,0.184c0.125,0.132,0.129,0.155,0.056,0.178c-0.078,0-0.139-0.012-0.19-0.022
					c0.04,0.017,0.097,0.037,0.138,0.051c0.251,0.087,0.498,0.139,0.742,0.162c0.411,0.04,0.838,0.011,1.259,0.024
					c-0.184-0.134-0.33-0.224-0.56-0.289C44.432,28.389,44.375,28.377,44.333,28.372z"/>
				<path d="M56.692,29.428c-0.132-0.117-0.307-0.275-0.442-0.394c-0.089-0.008-0.184-0.02-0.273-0.022
					c-0.294-0.014-0.294-0.014-0.955,0.041c0.065,0.04,0.129,0.079,0.218,0.117C55.589,29.336,56.054,29.417,56.692,29.428z"/>
				<path d="M53.971,29.17c0.261,0.017,0.52,0.034,0.778,0.046c-0.126-0.081-0.251-0.109-0.479-0.139
					c-0.293-0.04-0.406-0.082-0.521-0.194l0.167,0.28C53.938,29.166,53.957,29.17,53.971,29.17z"/>
				<polygon points="45.539,28.633 45.746,28.812 46.067,28.834 45.857,28.652 "/>
				<path d="M58.789,31.329c0.089-0.046-0.065-0.154-0.129-0.209c-0.376,0.002-0.564-0.075-0.883-0.102
					c-0.107-0.003-0.167,0.004-0.289,0.032c0.018,0.006,0.027,0.015,0.046,0.02C57.833,31.22,58.617,31.41,58.789,31.329z"/>
				<path d="M50.816,30.663c0.055,0.029,0.148,0.049,0.246,0.063c0.208,0.04,0.306,0.074,0.377,0.207
					c0.392,0.024,0.343-0.107,0.583-0.145c-0.184-0.144-0.359-0.189-0.825-0.222c-0.171-0.008-0.362-0.005-0.519-0.031
					C50.706,30.58,50.73,30.623,50.816,30.663z"/>
				<path d="M48.572,30.646c0.035-0.022,0.035-0.068-0.159-0.167l-0.38,0.052c0.02,0.021,0.046,0.044,0.087,0.063
					C48.274,30.672,48.508,30.686,48.572,30.646z"/>
				<polygon points="47.941,30.703 47.711,30.508 47.23,30.476 47.461,30.675 "/>
				<path d="M45.834,30.53c0.006,0.006,0.011,0.013,0.02,0.016c0.017,0.008,0.038,0.017,0.056,0.024
					c0.089,0.007,0.218,0.013,0.313,0.018l0.016-0.086c-0.076-0.089-0.242-0.115-0.337-0.126C45.757,30.37,45.611,30.404,45.834,30.53z"
					/>
				<polygon points="143.687,35.435 143.487,35.264 143.045,35.246 143.251,35.424 "/>
				<path d="M164.441,16.351c-0.926-0.005-0.938,0.016-1.021,0.092c-0.093,0.087-0.224,0.092-0.605,0.084
					c-0.973-0.021-1.716-0.204-2.735-0.199c-0.319,0.006-0.501,0.053-0.607,0.081c0.07,0.058,0.178,0.132,0.318,0.184
					c0.949,0.367,2.635,0.574,6.017,0.741c1.94,0.095,2.428,0.058,3.497-0.27c0.093,0.028,0.223,0.074,0.329,0.103
					c-0.631-0.626-4.08-0.781-4.761-0.804C164.729,16.356,164.583,16.354,164.441,16.351z"/>
				<path d="M38.981,27.659c0.107,0.23-0.022,0.271-0.642,0.184c-1.368-0.189-0.675,0.235-0.346,0.437
					c0.03,0.003,0.059,0.003,0.081,0.003c0.804,0.026,2.09,0.173,2.099,0.176c1.185,0.137,1.815,0.178,2.661,0.086
					c-0.625-0.355-1.165-0.454-2.148-0.534C39.9,27.947,39.465,27.906,38.981,27.659z"/>
				<path d="M24.931,27.125c0.014,0.092,0.017,0.118,0.191,0.167c0.35,0.095,0.35,0.095,0.464,0.224
					c0.922,0.006,0.976,0.006,0.969-0.17c0.139,0.087,0.323,0.201,0.462,0.285c3.664,0.172,3.664,0.172,4.352,0
					c-0.008,0.083-0.076,0.17,0.024,0.256c0.774,0.005,1.229,0.031,2.5,0.126c2.081,0.152,2.725,0.149,3.634-0.021
					c-0.693-0.218-0.731-0.302-0.915-0.684c0.148,0.092,0.339,0.213,0.481,0.305c0.995,0.006,1.302-0.029,1.42-0.247
					c2.066,0.106,2.066,0.106,3.133,0.385c-0.165-0.12-0.195-0.244-0.266-0.367c1.42-0.175,2.704-0.228,4.892-0.201
					c-0.969-0.644-2.569-0.558-2.755-0.545c-0.158-0.023-0.428-0.063-1.115-0.411c-4.331-0.265-7.044-0.644-8.503-0.847
					c-0.484,0.229-0.74,0.252-2.125,0.189c0.742,0.603,0.742,0.603,4.124,1.252c-0.038-0.003-0.083,0-0.125,0
					c-0.182,0.109-0.028,0.226-0.165,0.338c-0.851,0.095-1.166-0.144-1.753-0.215c-0.072,0.341,0.899,0.598,0.908,0.598
					c0.003,0.002,0.027,0.229-0.995,0.014c-0.218-0.043-0.411-0.092-0.615-0.138c-0.126,0.069-0.283,0.121-0.99,0.023
					c-1.022-0.138-1.325-0.136-1.381,0.143c-0.185-0.097-0.44-0.224-0.63-0.32c-0.106,0.074-0.119,0.079-0.283,0.097
					c-0.505-0.052-0.705-0.201-1.338-0.206c-0.445-0.006-0.891,0.052-1.344,0c-0.362-0.04-0.608-0.121-0.792-0.184
					C26.559,27.266,26.404,27.251,24.931,27.125z"/>
				<path d="M112.979,29.681c-0.012,0-0.024,0-0.036,0c-0.312,0-0.366,0.069-0.553,0.104
					c-0.201,0.037-0.307,0.006-0.408-0.063c-0.229-0.002-0.252,0.034-0.064,0.118c0.141,0.061,0.389,0.123,0.435,0.084
					c0.049-0.032-0.022-0.063-0.058-0.098c0.217,0.085,0.5,0.203,0.718,0.292C113.604,30.054,113.122,29.698,112.979,29.681z"/>
				<path d="M46.35,28.658h-0.002c0.196,0.069,0.537,0.099,0.798,0.149C47.14,28.808,46.58,28.679,46.35,28.658z"/>
				<path d="M58.224,19.412c-0.332-0.012-0.661,0-0.991-0.015c-0.313-0.009-0.554-0.083-0.926-0.058
					c-0.101,0.049-0.112,0.061-0.018,0.17c0.26,0.021,0.608,0.046,0.872,0.065c3.213,0.236,3.997,0.325,6.023,0.679
					c0.203-0.112,0.237-0.133,0.884-0.104c0.526,0.021,0.502-0.071,0.442-0.278c-1.938-0.327-2.067-0.372-2.073-0.379
					c-0.337-0.135,0.406-0.215,0.342-0.339c0.748,0.181,1.583-0.023,2.369,0.029c0.901,0.058,1.68,0.189,2.6,0.235
					c0.059,0.006,0.141,0.006,0.199,0.011c0.23,0.006,0.384-0.017,0.614-0.063c0.306-0.063,0.565-0.121,2.564,0.021
					c0.63,0.045,1.101,0.16,1.75,0.197c1.095,0.063,1.143,0.063,1.166-0.031c0.013-0.032-0.023-0.071-0.046-0.104
					c0.602,0.077,0.542,0.268,1.154,0.342c0.064-0.051,0.154-0.124,0.224-0.179c-0.435-0.231-0.782-0.26-2.069-0.372
					c-0.558-0.047-1.083,0.042-1.632,0.017c-2.487-0.117-4.698-0.413-7.131-0.563c-3.088-0.161-3.372-0.115-3.926-0.021
					c-3.57-0.703-3.866-0.049-3.872-0.042c0.006,0.002,0.2,0.14,0.701,0.218c0.224,0.034,0.224,0.034,1.545,0.092
					c1.055,0.045,1.439,0.286,2.276,0.396C60.775,19.449,60.369,19.47,58.224,19.412z"/>
				<path d="M87.063,20.985c0.171-0.04,0.401-0.028,0.616-0.022c-0.224-0.012-0.437-0.028-0.676-0.035L87.063,20.985z"/>
				<path d="M29.122,28.199c-3.31-0.493-7.263-0.58-10.876-0.876c-0.303,0.032-0.704,0.077-1.01,0.111
					c-1.439-0.166-2.705-0.396-4.129-0.571c0.036,0.095,0.079,0.222,0.118,0.322c6.378,1.071,14.144,1.267,21.593,1.668
					c-1.671-0.178-3.259-0.41-4.682-0.764C29.831,28.125,29.427,28.168,29.122,28.199z"/>
				<path d="M40.453,29.227c-1.842-0.143-3.72-0.272-5.636-0.373C36.61,29.04,38.503,29.155,40.453,29.227z"/>
				<path d="M123.5,24.225c0.218,0.098,0.86,0.259,1.38,0.189c-0.129-0.126-0.302-0.296-0.431-0.422
					c-0.07,0.063-0.199,0.083-0.494,0.109C123.547,24.136,123.399,24.179,123.5,24.225z"/>
				<path d="M852.688,17.336c0.33,0.135,0.885,0.262,1.037,0.152c0.036-0.023,0.042-0.053,0.047-0.074
					c-0.129-0.029-0.306-0.073-0.435-0.102c-0.408-0.095-0.638-0.135-0.78-0.137C852.324,17.181,852.628,17.31,852.688,17.336z"/>
				<path d="M802.752,16.768c0.254,0.092,0.837,0.117,0.909,0.246c0.766-0.031,0.248-0.283-0.318-0.373
					c-0.148-0.022-0.313-0.036-0.49-0.043c-0.064,0.003-0.135,0.007-0.205,0.007C802.637,16.644,802.593,16.707,802.752,16.768z"/>
				<path d="M797.248,22.711c1.167,0.05,1.379-0.16,0.909-0.315c-0.066-0.02-0.144-0.04-0.218-0.055
					c-0.75,0.006-0.96,0.118-0.727,0.367C797.225,22.708,797.242,22.708,797.248,22.711z"/>
				<path d="M805.5,23.292c-0.678-0.296-0.883-0.385-1.096-0.595c-0.437,0.077-0.831,0.098-1.638,0.074
					c0.106,0.155,0.27,0.391,0.636,0.526C804.039,23.533,805.064,23.363,805.5,23.292z"/>
				<path d="M838.473,28.131c0.871-0.018,0.801-0.204,0.647-0.369c-0.146-0.011-0.294-0.021-0.459-0.028
					c-0.108,0-0.313,0-0.366,0.072c-0.071,0.109,0.129,0.215,0.106,0.325C838.424,28.131,838.448,28.131,838.473,28.131z"/>
				<path d="M847.29,33.917c0.028,0.003,0.059,0.003,0.076,0.006c0.75,0.051,1.314-0.095,2.015-0.09
					c-0.206-0.243-0.971-0.439-1.172-0.684c-0.106-0.002-0.224-0.005-0.342-0.008c-0.461,0.003-0.854,0.058-1.287,0.082
					C846.783,33.46,847.313,33.672,847.29,33.917z"/>
				<path d="M850.037,12.969c0.034-0.047,0.07-0.087,0.04-0.133l-0.831,0.282c0.024,0.017,0.049,0.042,0.106,0.063
					C849.564,13.255,849.9,13.105,850.037,12.969z"/>
				<path d="M771.208,34.571c0.14,0.006,0.33,0.015,0.471,0.02c-0.183,0.061-0.435,0.144-0.613,0.207
					c0.095,0.015,0.237,0.034,0.332,0.052c21.748,0.241,50.747,0.563,72.496,0.808c0.059-0.278,0.378-0.549,0.436-0.83
					c-0.389-0.032-0.914-0.074-1.308-0.109c0-0.018-1.864-2.32-2.192-2.539c-1.061-0.677-1.061-0.677-0.979-0.884
					c0.177-0.491,1.58-0.901,1.815-1.391c-0.141-0.011-0.323-0.025-0.466-0.037c-0.264-0.138-0.217-0.301-0.618-0.427
					c-0.235-0.01-0.554-0.019-0.79-0.029c0.266-0.402,0.183-0.604-0.4-0.971c-1.402,0.402-1.486,0.919-2.223,1.378
					c0.243,0.115,0.243,0.115,0.572,0.725c-0.6,0.12-0.6,0.12-0.366,0.37c-1.519-0.104-0.234-0.618-1.91-0.692
					c-0.612-0.028-3.901,0.184-2.899,1.119c-2.9-0.456-3.035-0.568-5.34-2.46c-0.417-0.034-0.784-0.065-1.391-0.364
					c-0.731-0.356-5.452-3.001-5.457-3.004l-1.367-0.396c-0.667-0.19-0.125-0.402-0.289-0.6l-0.95-0.199
					c-0.317-0.824-2.942-1.47-3.396-2.279c-0.589-0.052-0.589-0.052-2.476-0.914l-1.378-0.301c-0.165-0.456-0.165-0.456-0.955-0.608
					c-0.714-0.136-0.696-0.188-0.271-0.389c-1.061-0.092-1.002-0.384-1.851-0.511c-0.165-0.313-0.26-0.595-0.201-0.591
					c-2.05-0.385-2.145-1.018-3.583-1.482c-0.248-0.04-0.59-0.098-0.849-0.144c0.153,0.207,0.377,0.482,0.672,0.678
					c0.555,0.356,1.344,0.689,1.769,1.057c0.177,0.161-0.194,0.396,0.07,0.552c0.343,0.197,0.955,0.212,1.35,0.221
					c3.012,2.656,3.107,2.656,3.979,2.674c-1.031,1.395-1.031,1.395-0.66,1.874c-0.484,0.125-1.32,0.228-1.597,0.055
					c-0.666,0.23-0.938,0.503-0.919,0.67c0.849,0.043,1.644-0.118,2.504-0.031c0.148,0.092,0.148,0.092,0.118,0.166l5.908,0.069
					c-4.991-0.055-5.333-0.047-7.365,0.022c-0.076,0.023-0.182,0.055-0.258,0.078c1.492,0.66,0.501,1.524,3.396,2.063
					c0.371,1.546,0.371,1.546,0.259,1.644c-3.413-0.42-4.827-0.818-6.048-1.727c-1.154-0.864-1.48-0.864-2.246-0.87
					c1.251-0.551-1.39-0.891-1.444-1.367c0.006-0.367,0.006-0.367-0.142-0.505l-0.906-0.104c0.112-0.028,0.258-0.063,0.366-0.092
					c-0.491-0.138-1.209-0.206-1.799-0.321c0.036-0.21-0.543-0.388-0.696-0.589c-0.283-0.022-0.671-0.046-0.942-0.077
					c-0.059-0.006-4.882-0.694-1.121-0.908c-0.942-0.304,0.144-0.671-0.593-0.984c-0.761-0.003-1.528-0.009-2.035-0.072
					c-0.417-0.052-0.801-0.355,0.331-0.442c-0.285-0.031-0.684-0.086-0.797-0.149c-0.488-0.295,0.301-0.592-0.052-0.884
					c-0.212-0.175-1.192-0.182-1.432-0.351c0.065-0.018,0.141-0.046,0.206-0.063c0.083,0.003,0.188,0.005,0.271,0.005
					c0.058-0.012,0.141-0.031,0.2-0.039c-0.731-0.256-2.123-0.328-2.96-0.552c0.048-0.018,0.12-0.04,0.171-0.058
					c0.383,0.028,0.614,0.049,1.214,0.201c0.112-0.015,0.253-0.034,0.367-0.052c0.147-0.351,0.059-0.652-2.683-0.469
					c-0.165-0.191-0.106-0.206,0.165-0.264c1.568,0.037,1.568,0.037,1.397-0.235l-2.682-2.297c-0.106-0.089-0.308-0.213-0.459-0.302
					c-0.119-0.052-0.285-0.12-0.401-0.173c-0.636,0.247-1.581,0.437-2.321,0.66c0.317,0.339,0.765,0.669,1.143,0.999
					c0.235,0.214-0.938,0.233-1.139,0.388c-0.118,0.096,0.112,0.228,0.229,0.316c0.012,0.006,0.802,0.526,3.172,0.805
					c-1.097,0.468,0.549,0.861,0.708,1.294c0.023,0.081-0.201,0.185-0.142,0.265c0.106,0.157,0.235,0.21,0.695,0.377
					c0.602,0.209,0.497,0.283,0.277,0.43c-0.029-0.003-3.482-0.168-4.207-0.296c-0.755-0.131,0-0.304-0.138-0.453
					c-1.519-0.115-2.097-0.327-2.462-0.896c-1.274-0.173-1.486-0.259-2.83-0.815c-1.225,0.459,0.455,0.993-0.718,1.453
					c0.761,0.247,1.225,1.159,1.225,1.169c-1.166,0.226-1.166,0.226-1.108,0.307c-3.011-0.552-3.436-1.441-5.467-2.119
					c-1.327,0.293-1.91,0.545-1.511,1.551c-3.548-0.563-2.935-1.632-5.476-2.315c0.208-0.092-1.561-1.826-1.584-1.843
					c-0.436-0.287-1.097-0.365-1.857-0.454c0.237-0.441,0.159-0.511-1.479-0.608c-0.79,0.241,0.459,0.413,0.647,0.62
					c-0.566,0.158-0.854,0.144-1.143,0.126c-0.018-0.021-0.036-0.046-0.059-0.068c-0.659,0.16-0.289,0.265,1.484,0.608
					c0.036,0.494-0.452,0.982-0.306,1.477c0.848,0.045,2.593-0.182,2.576,0.098c-0.005,0.141-1.255,0.419-2.056,0.194
					c-0.661,0.621,1.839,0.937,2.668,1.407c-0.324,0.793,1.126,1.557,0.583,2.35c-0.022,0.031-0.271,0.298-2.392,0.259
					c-0.154,0.694,0.305,1.378,0.377,2.069c0.035,1.082,0.035,1.082,0.188,1.221c0.376,0.351,1.678,0.589,2.157,0.925
					c0.108-0.017,0.224-0.046,0.341-0.058c1.245-0.109,4.841,0.402,2.453,1.178c-0.471-0.028-1.507-0.209-0.86-0.405
					c0.148-0.003,0.353-0.008,0.507-0.011c-2.76-0.457-2.76-0.457-2.794-0.612c-0.484-0.017-1.139-0.046-1.633-0.066
					c0.053-0.065,0.065-0.151,0.041-0.215c-0.24,0.003-0.559,0.012-0.802,0.017c-0.342-0.464-0.347-0.482-1.674-0.453
					c-0.294,0.133-0.376,0.522,1.929,0.597c-1.238,0.247-0.359,0.561-0.519,0.839c-0.03,0.049-0.043,0.115-0.059,0.161
					c-0.077,0.311,0.082,0.546,0.146,0.646l1.002,0.309c-0.613,0.545,2.133,0.946,1.249,1.504c-0.989,0.029-0.989,0.029-1.627,0.132
					c-0.289,0.718-0.105,0.925,1.004,1.163c-0.531,0.934,0.665,1.852,0.329,2.789c1.627,0.385,1.627,0.385,1.581,0.647l3.039,0.033
					C770.796,34.659,770.796,34.659,771.208,34.571z M827.333,34.539c-0.503-0.006-0.891-0.022-1.327-0.192
					c-0.006-0.002-0.018-0.005-0.031-0.008C826.865,34.35,827.402,34.355,827.333,34.539z M814.295,29.216
					c0.081,0.16,0.152,0.321,0.229,0.484c-0.388-0.005-0.795-0.014-1.033-0.079C813.068,29.503,813.54,29.268,814.295,29.216z
					 M804.84,31.415l-0.095-0.189l0.86,0.012l0.094,0.189L804.84,31.415z M808.458,33.661l0.1,0.188l-0.794-0.011l-0.095-0.189
					L808.458,33.661z M806.703,30.08c0.04,0.089,0.094,0.21,0.142,0.299c-0.178,0.008-0.349,0.008-0.526,0.008
					c-0.423-0.006-0.772-0.037-1.119-0.166c-0.225-0.083-0.384-0.172-0.602-0.259C805.218,29.957,805.924,29.957,806.703,30.08z
					 M794.323,21.382c0.467,0.109,0.472,0.328-0.629,0.321c-0.077,0-0.147,0-0.218,0c-0.012,0-0.036,0-0.047,0
					c-0.047-0.12-0.106-0.278-0.152-0.398C793.818,21.291,794.148,21.339,794.323,21.382z M790.505,19.612
					c1.621-0.021,2.169,0.118,2.175,0.118c0.006,0.003,0.258,0.188-0.114,0.276c-0.27,0.068-0.659,0.085-1.413,0.103
					c-0.083-0.022-0.159-0.046-0.224-0.071C790.469,19.874,790.492,19.688,790.505,19.612z M788.407,20.759
					c-0.113,0.058-0.147,0.149-0.059,0.21c0.471,0.04,1.014,0.034,1.443,0.108c0.112,0.279,1.078,0.46,1.54,0.695
					c0.294,0.046,0.683,0.105,0.978,0.149c0.437,0.56,0.437,0.56,0.59,0.643c0.913,0.104,0.913,0.104,1.909,1.585
					c1.166,0.156,1.443,0.293,1.415,0.707c-0.095,0.425-0.082,0.442,0.023,0.66c-0.571,0.018-1.173,0.037-2.81-0.694
					c-0.407-0.198-0.749-0.405-1.114-0.608c-1.799-0.753-2.242-1.637-4.386-2.361c-0.089-0.034-0.177-0.068-0.259-0.104
					c-0.054-0.034-0.13-0.08-0.189-0.114C789.009,21.411,787.44,21.017,788.407,20.759z M770.594,27.947
					c3.367,2.066,3.367,2.066,3.733,2.48c0.03,0.04,0.03,0.04-0.501,0.339c-0.307,0.175,0.507,0.304,0.365,0.471
					c-0.058,0.074-0.205,0.087-0.602,0.115c2.312,0.184,2.312,0.184,2.641,0.32c-1.302,0.047-1.449,0.133-2.173,0.553
					c-0.279,0.011-0.562,0.011-0.843,0.005c-1.155-0.045-1.433-0.055-1.934-0.224c-0.701-0.235-0.655-0.528-1.079-0.787
					c-0.901-0.003-1.91,0.23-2.705,0.003c-0.131-0.037-0.213-0.083-0.294-0.129c1.532,0.058,2.393-0.235,3.583-0.351
					c-1.126-0.557-2.11-1.132-3.336-1.674c0.342-0.055,0.801-0.124,1.144-0.176C767.306,28.573,767.807,28.478,770.594,27.947z
					 M766.305,27.711c-0.36-0.127-0.825-0.235-1.167-0.361c-0.131-0.046-0.236-0.096-0.318-0.144c0.482-0.052,1.125-0.121,1.615-0.167
					l-0.325,0.275c-0.087,0.069-0.011,0.12,0.348,0.222c0.282,0.08,0.389,0.117,0.176,0.152c-0.023,0-0.046,0-0.059,0.005
					C766.48,27.699,766.393,27.706,766.305,27.711z M766.446,27.992c0.647-0.135,1.826-0.065,1.803,0.225
					c-0.835-0.01-1.296-0.018-1.638-0.139C766.541,28.05,766.486,28.021,766.446,27.992z M765.808,30.798l-0.104-0.204
					c0.082-0.095,0.353-0.112,0.813-0.048c0.59,0.077,1.416,0.317,0.577,0.358L765.808,30.798z M769.734,33.331l-0.141-0.05
					c-1.308-0.465-1.95-1.125-2.517-1.705c0.725-0.029,1.22,0.109,1.886,0.126c0.089,0,0.164-0.011,0.253-0.011
					c-0.212,0.278-0.212,0.278,0.872,0.882c-0.224,0.024-0.513,0.06-0.729,0.082c0.425,0.106,0.425,0.106,1.555,0.592
					c-0.253-0.003-0.589-0.005-0.848-0.008L769.734,33.331z"/>
				<path d="M848.273,35.372c-0.207-0.252-0.418-0.37-1.162-0.407c-0.071,0-0.129,0-0.188,0
					c0.106,0.063,0.33,0.195,0.177,0.333c-0.17,0.149-0.744,0.247-0.983,0.385l2.563,0.029C848.469,35.617,848.415,35.55,848.273,35.372
					z"/>
				<path d="M1427.052,15.518c0.037,0.023,0.088,0.047,0.145,0.069c0.256,0.012,0.58,0.025,0.832,0.038l-0.252-0.312
					C1427.272,15.329,1426.802,15.368,1427.052,15.518z"/>
				<path d="M1430.915,22.146c0.277,0.115,2.092,0.311,2.234-0.108c1,0.118,4.18,0.396,5.68,0.149
					c0.619,0.132,0.619,0.132,4.758,0.302c-0.109,0.229-1.006,0.39-1.043,0.626c0.367,0.014,0.846,0.037,1.203,0.048
					c0.936-0.071-0.154-0.339,0.578-0.456c0.549,0.095,0.756,0.256,1.367,0.335c0.402,0.058,0.766-0.005,0.945-0.034
					c0.008-0.238-1.379-0.299-1.367-0.542c5.592-0.04,5.592-0.04,6.965-0.084c-1.227-0.33-3.129-0.43-4.574-0.684
					c-1.387,0.354-5.326,0.385-5.584-0.338c-1.787,0.037-3.615-0.095-5.379,0.063c0.342,0.127,1.063,0.167,1.35,0.305
					c0.258,0.12,0.203,0.167-0.006,0.333c-0.539-0.009-0.801-0.087-1.238-0.236c-0.861-0.292-1.488-0.113-1.502,0.01
					c-0.721-0.089-1.107-0.268-1.846-0.348c-0.307-0.034-0.518-0.023-0.93,0.04c-0.035,0.086-0.084,0.207-0.119,0.293
					c-0.83,0.034-1.461-0.149-2.297-0.104c-0.557,0.029-0.592,0.118-0.607,0.258c0.025,0,0.051,0,0.074,0
					C1430.116,21.973,1430.544,21.999,1430.915,22.146z"/>
				<path d="M1427.827,22.088c0.697-0.017,0.842-0.137,0.891-0.241c-0.604,0.029-0.861,0.098-0.941,0.241
					C1427.796,22.088,1427.815,22.088,1427.827,22.088z"/>
				<path d="M1425.806,22.135c0.086-0.053-0.006-0.104-0.061-0.133c-0.031,0-0.068-0.006-0.117-0.006
					c-0.41-0.011-0.723,0.066-1.129,0.063c-0.014,0.021-0.014,0.041,0.023,0.063C1424.708,22.215,1425.604,22.237,1425.806,22.135z"/>
				<path d="M1489.794,25.345c0.307-0.146-1.008-0.138-1.02-0.138c-0.963,0.011-0.902-0.086-0.873-0.138
					c-0.129,0.012-0.484,0.043-0.307,0.123C1487.907,25.333,1489.521,25.469,1489.794,25.345z"/>
				<path d="M1452.175,23.536c-1.084-0.029-1.602,0.061-1.791,0.31c0.023,0,0.061,0,0.092,0.003
					C1451.923,23.88,1452.114,23.619,1452.175,23.536z"/>
				<path d="M1460.052,25.815c0.027-0.061,0.064-0.137,0.088-0.197l-0.332-0.106c-0.465-0.018-0.613,0.144-0.43,0.243
					C1459.501,25.83,1459.728,25.847,1460.052,25.815z"/>
				<path d="M1428.622,24.427c0.213,0.113,0.873,0.178,1.475,0.086c-0.012-0.144-0.371-0.225-1.195-0.259
					c-0.1-0.006-0.209-0.006-0.303-0.013C1428.563,24.277,1428.493,24.352,1428.622,24.427z"/>
				<path d="M1427.999,24.544c0.082-0.055-0.184-0.112-0.301-0.136l-0.867,0.058c0.02,0.012,0.037,0.029,0.061,0.037
					C1427.126,24.626,1427.882,24.621,1427.999,24.544z"/>
				<path d="M1457.317,26.172c-1.268-0.05-2.643,0.034-3.777-0.16c-0.67,0.246-0.67,0.246-1.705,0.108
					c0.033,0.06,0.07,0.127,0.205,0.178c0.186,0.075,0.443,0.109,0.75,0.146c0.695,0.086,0.93,0.141,1.178,0.343
					c0.426-0.007,0.5-0.058,0.598-0.242c0.027-0.063,0.086-0.189,0.416-0.195c0.043,0,0.285,0.006,0.891,0.098
					c0.537,0.086,0.818,0.109,1.445,0.101c0.162-0.074,0.389-0.178,0.559-0.253l0.746,0.031
					C1458.206,26.24,1457.899,26.203,1457.317,26.172z"/>
				<path d="M1450.524,26.342c0.117-0.099-0.35-0.13-0.494-0.136c-0.477-0.02-1.002,0.028-0.766,0.178
					c0.014,0,0.025,0.01,0.031,0.013c0.24,0.011,0.566,0.024,0.813,0.037L1450.524,26.342z"/>
				<polygon points="1447.368,26.108 1446.624,26.08 1446.542,26.275 1447.288,26.31 "/>
				<path d="M1443.667,26.336c1.088,0.068,1.258-0.093,1.289-0.238c-0.361-0.018-0.836-0.038-1.197-0.052l-0.117,0.287
					C1443.642,26.333,1443.653,26.336,1443.667,26.336z"/>
				<path d="M1457.327,26.993c-0.01-0.006-0.023-0.018-0.037-0.022c-0.146-0.129-0.49-0.152-0.611-0.162
					c-0.082-0.006-0.152-0.006-0.236-0.006c-0.033,0.035-0.117,0.099-0.01,0.165c0.105,0.065,0.379,0.105,0.674,0.149
					c0.527,0.076,0.863,0.14,0.658,0.324c0.152-0.112,0.373-0.259,0.533-0.368C1457.618,27.107,1457.446,27.054,1457.327,26.993z"/>
				<path d="M1453.497,27.206c-0.555-0.018-0.861-0.013-1.328,0.077c0.045,0.034,0.078,0.066,0.137,0.101
					c0.246,0.143,0.625,0.181,1.18,0.192c0.717,0.015,1.119,0.025,1.754,0.123c0.207-0.315,0.168-0.454-0.197-0.585
					C1454.464,27.234,1454.108,27.229,1453.497,27.206z"/>
				<path d="M1446.413,27.51c0.045,0,0.115,0.003,0.164,0.006c0.625,0.008,1.26-0.021,1.896,0.006
					c0.471,0.022,0.805,0.075,1.121,0.127c-0.068-0.276-1.004-0.472-1.35-0.725l-0.525,0.351c-0.012,0.086-0.189,0.095-0.684,0.075
					C1446.472,27.326,1446.177,27.323,1446.413,27.51z"/>
				<path d="M1457.856,28.107c-1.213-0.023-1.184,0.023-0.953,0.439c0.014,0.003,0.031,0.003,0.037,0.003
					c1.26,0.103,1.424-0.213,1.094-0.377C1457.987,28.152,1457.923,28.131,1457.856,28.107z"/>
				<path d="M1426.948,29.256c-0.086,0-0.178-0.003-0.258-0.006c0.012,0.009,0.037,0.018,0.049,0.028
					c0.232,0.144,0.676,0.184,1.076,0.201C1428.007,29.331,1427.655,29.288,1426.948,29.256z"/>
				<path d="M1426.938,29.629c-0.555,0.006-0.967,0.012-1.305-0.018c-0.535-0.037-0.93-0.134-1.424-0.189
					c-0.135,0.047-0.391,0.127-0.213,0.189c0.146,0.053,0.514,0.075,0.854,0.096c0.283,0.017,0.57,0.031,0.826,0.071
					c-0.023,0.052-0.049,0.126-0.072,0.179l2.004,0.086L1426.938,29.629z"/>
				<path d="M1424.132,29.888c-0.861,0.029-1.271-0.035-1.691-0.155c0,0.041-0.006,0.098,0.111,0.158
					c0.18,0.095,0.529,0.146,0.805,0.178c0.824,0.09,1.742,0.118,2.584,0.198C1425.728,29.931,1425.323,29.848,1424.132,29.888z"/>
				<path d="M1414.854,25.333c1.303,0.121,2.67,0.155,3.588,0.17c1.104,0.014,2.391,0.02,3.449,0.014
					c1.092-0.002,2.688,0.003,4.125,0.063c1.412,0.058,1.029,0.474,2.215,0.575c0.014,0.051-0.08,0.126-0.203,0.171
					c-0.367,0.016-0.736,0.029-1.096,0.053c0.508,0.318,1.76,0.511,2.586,0.775c3.053-0.546,8.629,0.16,8.867,0.191
					c0.172-0.169,0.172-0.169-0.41-0.364c-0.65-0.221,0.598-0.81,5.289-0.663c-0.33-0.38-2.262-0.21-3.084-0.428
					c0.324-0.069,0.762-0.158,1.092-0.228c0.447,0.032,0.773,0.052,1.51,0.061c1.566,0.018,2.979-0.173,4.549-0.16
					c1.203,0.006,2.141,0.235,3.383,0.212c1.311-0.022,2.547-0.161,3.891-0.117c0.979,0.031,1.898,0.154,2.93,0.1
					c1.094-0.058,1.277-0.27,1.406-0.413c-0.57-0.138-0.617-0.149-0.527-0.287c-2.363,0.023-2.363,0.023-2.748-0.041
					c-1.557-0.234-1.557-0.234-2.498-0.082c-1.883-0.359-1.883-0.359-2.297-0.302c-0.443-0.305-1.205-0.586-1.27-0.916
					c-1.703-0.015-3.564-0.044-6.02-0.17c-0.111,0.23,0.25,0.288,1.086,0.327c-1.215,0.351-1.215,0.351-1.797,0.311
					c0.502-0.477-0.309-0.661-2.082-0.85c0.129-0.201,0.969-0.33,1.061-0.534c-1.203-0.138-2.652-0.081-3.813-0.247
					c-0.055-0.011-0.129-0.023-0.184-0.034c-2.676,0.844-3.572,1.132-6.895,0.967c0.393,0.478-0.957,0.945-0.189,1.425
					c-5.445,0.152-5.717-0.1-5.857-0.238c-0.271-0.259-0.438-0.327-1.303-0.345c-0.143,0.172,0.623,0.264,0.676,0.416
					c-0.146,0.052-0.338,0.118-0.484,0.17c-1.225-0.049-1.537-0.123-1.916-0.268c-1.148-0.014-1.148-0.014-3.781,0.339
					c-1.34,0.176-2.836,0-4.207,0.089c-0.314,0.023-0.656,0.092-0.854,0.149c-0.037-0.003-3.775-0.41-4.932,0.092
					c0.297,0.013,0.695,0.023,0.992,0.029C1411.022,25.401,1412.933,25.163,1414.854,25.333z M1452.636,25.284
					c-1.037,0.052-1.668,0.081-2.48,0.049c-0.207-0.011-0.584-0.028-1.043-0.097c-0.049-0.006-0.109-0.013-0.146-0.021
					C1449.134,24.685,1452.202,25.195,1452.636,25.284z M1446.731,24.744c0.275,0.015,0.729,0.031,1.049,0.133
					c0.412,0.129,0.496,0.286,0.76,0.428c-0.436,0.008-0.844,0.061-1.303,0.042c-0.316-0.014-0.389-0.017-0.549-0.105
					C1446.386,25.074,1447.349,24.914,1446.731,24.744z M1444.019,25.053c0.557,0.021,0.871,0.021,1.365,0.005
					c-0.045,0.115-0.109,0.271-0.164,0.385c-1.242-0.206-2.145-0.195-3.701-0.092c-1.029,0.069-1.955,0.105-2.9-0.149
					c-0.061-0.018-0.129-0.04-0.189-0.055c0.297-0.146,0.67-0.33,1.604-0.345C1441.489,24.775,1442.671,24.988,1444.019,25.053z
					 M1438.489,23.903c0.543,0.129,0.813,0.241,1.215,0.505c0.025,0.019,0.047,0.029,0.064,0.043c0.043,0.026,0.092,0.064,0.111,0.089
					c-0.012,0-0.027,0-0.047,0c-1.059-0.057-1.686-0.304-1.846-0.393C1437.812,24.047,1437.761,23.921,1438.489,23.903z
					 M1431.323,25.621l0.76,0.034l-0.076,0.178l-0.748-0.028L1431.323,25.621z"/>
				<path d="M1327.905,16.698c0.07,0.04,0.484,0.239,1.338,0.29c0.158-0.187-0.031-0.271-0.383-0.428
					c-0.129-0.058-0.242-0.115-0.307-0.176C1327.479,16.411,1327.737,16.615,1327.905,16.698z"/>
				<polygon points="1331.347,17.063 1330.485,17.034 1330.435,17.235 1331.288,17.268 "/>
				<path d="M1340.987,18.981c0.145,0.075,0.508,0.13,0.686,0.022c0.107-0.06,0.082-0.157,0.07-0.198
					C1340.681,18.806,1340.956,18.967,1340.987,18.981z"/>
				<path d="M1377.532,20.547c0.053,0.024,0.396,0.157,1.301-0.061c-0.357-0.075-0.627-0.115-0.885-0.127
					C1377.323,20.343,1377.452,20.509,1377.532,20.547z"/>
				<path d="M1375.897,20.469c-0.148-0.011-0.295-0.023-0.451-0.028c-0.955-0.032-1.367,0.08-1.297,0.351
					c0.023,0.002,0.049,0.005,0.072,0.005C1375.47,20.877,1375.972,20.778,1375.897,20.469z"/>
				<path d="M1357.417,21.445c0.053,0.058,0.148,0.115,0.258,0.166c0.68,0.034,0.91-0.026,1.596-0.2
					c0.639-0.161,0.945-0.136,1.322,0.108c0.428-0.092,1-0.138,1.369-0.241c0.365-0.103,0.389-0.181,0.41-0.27
					c-0.174-0.012-0.365-0.023-0.555-0.029c-1.029-0.022-1.484,0.029-1.99,0.23C1358.235,20.966,1357.21,21.176,1357.417,21.445z"/>
				<path d="M1354.085,20.899c-0.092-0.006-0.186-0.017-0.295-0.022c-0.303-0.007-0.445,0.028-0.512,0.126
					c-0.029,0.052-0.029,0.052,0.338,0.16L1354.085,20.899z"/>
				<path d="M1328.554,21.032c0.018,0.002,0.037,0.005,0.051,0.008c0.59,0.13,2.143,0.021,2.135-0.321
					C1329.501,20.728,1328.599,20.733,1328.554,21.032z"/>
				<path d="M1327.507,20.704c-0.516-0.011-0.523,0.012-0.578,0.265c0.012,0.006,0.033,0.006,0.055,0.009
					c1.074,0.083,1.217-0.066,1.006-0.176C1327.868,20.744,1327.71,20.716,1327.507,20.704z"/>
				<path d="M1377.929,23.243c-0.006,0.034,0,0.065,0.063,0.097c0.16,0.087,0.16,0.087,2.314,0.196
					c-0.031-0.155-0.373-0.213-1.461-0.262C1378.536,23.266,1378.229,23.254,1377.929,23.243z"/>
				<path d="M1327.087,25.479c-0.049-0.262-0.426-0.371-1.404-0.41c-0.523-0.017-0.859-0.012-1.844,0.002
					c-0.035,0.061-0.09,0.139,0.117,0.21C1324.226,25.38,1324.226,25.38,1327.087,25.479z"/>
				<path d="M1373.106,27.343c0.078,0.044,0.158,0.084,0.236,0.125c0.818,0.011,0.51-0.193,0.1-0.366
					C1373.077,27.091,1372.698,27.107,1373.106,27.343z"/>
				<polygon points="1325.888,27.062 1325.843,27.245 1327.468,27.301 1326.751,26.999 "/>
				<path d="M1330.759,25.608c0.389,0.006,0.441-0.126,0.459-0.166c-0.408-0.006-0.709-0.038-0.906-0.098
					c-0.355-0.098-0.363-0.236-0.639-0.347c-0.057,0.005-0.129,0.011-0.193,0.016c-0.023,0.003-0.047,0.003-0.064,0.007
					c-0.75,0.063-1.154,0.152-1.08,0.41c0.029,0,0.066,0,0.09,0c1.002,0.006,1.592,0.086,1.898,0.152
					C1330.38,25.598,1330.452,25.608,1330.759,25.608z"/>
				<path d="M1329.938,19.619c1.053-0.052,1.053-0.052,2.322,0.092l1.686-0.141c0.777,0.008,1.502,0.071,2.271,0.1
					c1.307,0.047,2.283-0.264,3.641-0.168c-0.117-0.204-1.197-0.118-1.602-0.245c0.33-0.184,1.27-0.032,1.756-0.141
					c-0.014-0.005-0.023-0.015-0.023-0.022c0-0.003-0.016-0.009-0.027-0.009c-0.068-0.028-0.141-0.028-0.361-0.012
					c-0.518,0.043-0.775,0.012-0.895-0.006c-0.119-0.144-0.016-0.173,0.576-0.149c0.453,0.018,0.836,0.028,0.807-0.081
					c-0.066-0.218-0.605-0.246-0.906-0.263c-0.816-0.013-1.588,0.068-2.402,0.051c-0.795-0.017-1.521-0.095-2.273-0.149
					c-1.402-0.098-2.182-0.144-3.119-0.155c-0.605,0.254-1.064,0.403-1.893,0.621c-0.375-0.006-0.375-0.063-0.346-0.173
					c0.031-0.112,0.051-0.212-0.814-0.166c0.277,0.786,0.277,0.786-1.467,0.821c0.029,0.028,0.078,0.075,0.141,0.1
					C1327.499,19.742,1328.856,19.677,1329.938,19.619z"/>
				<path d="M1364.655,27.521c0.662-0.018,1.26-0.087,1.898-0.127c-0.793-0.031-1.846-0.068-2.637-0.103
					c0.025,0.012,0.057,0.017,0.096,0.028C1364.235,27.384,1364.448,27.452,1364.655,27.521z"/>
				<path d="M942.951,4.753c0.813-0.032,0.858-0.216,0.802-0.388c-0.771,0.022-1.037,0.138-0.873,0.388
					C942.902,4.753,942.925,4.749,942.951,4.753z"/>
				<path d="M941.65,5.428c0.368,0.011,0.557,0.008,0.827-0.012c0.037-0.003,0.063-0.006,0.095-0.009
					c0.933-0.117,0.755-0.367,1.214-0.543c-0.401-0.006-0.918-0.014-1.321-0.023c0.201,0.19,0.017,0.248-0.405,0.328
					c-0.373,0.077-0.525,0.121-0.447,0.256C941.618,5.422,941.635,5.428,941.65,5.428z"/>
				<path d="M938.859,7.938c0.568-0.08,1.304-0.058,1.649-0.046c-0.707-0.201-0.492-0.293,0.252-0.497
					c0.482-0.129,0.517-0.178,0.562-0.262c0.118-0.241-0.355-0.482,0.05-0.724c0.588-0.351,0.646-0.388,0.258-0.775
					c-0.107-0.005-0.213-0.008-0.308-0.008c-0.178,0-0.405,0.008-0.551,0.025c-0.08,0.132,0.411,0.229,0.4,0.359
					c-1.359,0.283-1.875,0.502-2.064,0.864c0.522,0.068,1.229,0.155,1.751,0.218c-0.552,0.181-1.479,0.281-1.965,0.474
					c-0.304,0.127-0.21,0.297-0.16,0.391C938.764,7.949,938.819,7.939,938.859,7.938z"/>
				<path d="M936.832,9.026c0.356,0.082,1.063,0.055,1.201,0.197c1.24-0.179,0.591-0.703,2.55-0.74
					c-0.369-0.115-0.492-0.207-0.529-0.408c-0.063,0-0.12-0.003-0.178-0.003c-2.292-0.021-2.007,0.577-3.193,0.83
					C936.676,8.951,936.676,8.987,936.832,9.026z"/>
				<path d="M938.112,9.941c0.041-0.04,0.029-0.08-0.005-0.121c-0.615-0.005-1.155,0.099-1.792,0.063
					c0.023,0.041,0.058,0.075,0.14,0.104C936.843,10.131,937.928,10.129,938.112,9.941z"/>
				<path d="M938.21,10.714c-0.011-0.061-0.017-0.146-0.023-0.21l-0.494-0.1c-0.459-0.003-0.588,0.146-0.33,0.255
					C937.469,10.705,937.733,10.774,938.21,10.714z"/>
				<path d="M934.701,12.099c0.305,0.118,0.775,0.129,1.022,0.137c0.011-0.008,0.025-0.022,0.025-0.031
					c0.049-0.103-0.06-0.16-0.278-0.246c-0.241-0.104-0.224-0.113-0.165-0.139c0.187-0.08,0.687-0.08,0.865-0.16
					c0.132-0.058,0.025-0.139-0.069-0.199c-0.015,0-0.035-0.002-0.057-0.002C934.569,11.458,934.179,11.903,934.701,12.099z"/>
				<path d="M934.649,12.733c0.196,0.073,0.592,0.111,0.721,0.008c0.078-0.071,0.011-0.17-0.014-0.21
					C934.238,12.561,934.604,12.715,934.649,12.733z"/>
				<path d="M933.811,13.169c0.158,0.055,0.494,0.063,1.017,0.062c0.35-0.004,0.688-0.029,1.039-0.004
					c-0.011-0.049-0.069-0.189-1.008-0.21c-0.601-0.006-0.951,0.041-1.14,0.078C933.73,13.123,933.741,13.146,933.811,13.169z"/>
				<path d="M955.187,13.632c-0.129-0.078-0.308-0.112-0.666-0.121c-0.632-0.005-1.367,0.112-1.034,0.299
					C953.995,13.755,954.672,13.687,955.187,13.632z"/>
				<path d="M934.179,13.391c-0.058-0.003-0.125-0.003-0.179-0.003c-0.821-0.012-1.174,0.08-1.088,0.286
					c0.009,0,0.02,0,0.026,0C934.305,13.721,934.213,13.479,934.179,13.391z"/>
				<path d="M932.989,14.169c0.011,0,0.023,0,0.034,0c1.026,0.034,1.404-0.084,1.215-0.38
					C933.153,13.944,932.932,13.977,932.989,14.169z"/>
				<path d="M953.389,14.496c0.356,0.141,0.97,0.244,1.149,0.408c0.649-0.075,0.557-0.17,0.201-0.351
					c-0.333-0.167-0.425-0.241-0.302-0.346c-0.048-0.002-0.092-0.005-0.14-0.005c-0.442-0.003-0.735,0.083-1.149,0.092
					C953.16,14.341,953.177,14.409,953.389,14.496z"/>
				<path d="M934.747,14.384c-0.072-0.077-0.235-0.105-0.661-0.12c-0.718-0.006-1.37,0.065-1.488,0.089
					c0.049,0.041,0.101,0.083,0.201,0.12C933.259,14.64,934.115,14.49,934.747,14.384z"/>
				<path d="M927.591,21.993c0.962,0.05,1.545-0.215,2.51-0.154c0.503-1.197,2.251-2.363,1.834-3.581
					c0.405-0.052,0.934-0.121,1.339-0.173c-0.368-0.304-0.347-0.358,0.258-0.801c0.668-0.496,0.542-0.655,0.221-1.043
					c0.259-0.028,0.609-0.068,0.873-0.098c-0.375-0.74-0.375-0.74-1.473-0.987c-0.752,0.031-1.352,0.167-2.174,0.155
					c1.473,0.12,1.398,0.502,2.326,0.718c-0.557,0.078-0.864,0.12-1.054,0.327c-0.242,0.275,0.083,0.552-0.041,0.827
					c-0.134,0.299-1.797,0.534-0.723,0.873c-1.338,0.259-1.338,0.259-2.142,0.27c-1.591,1.637-1.979,2.424-1.803,3.665
					C927.56,21.991,927.579,21.991,927.591,21.993z"/>
				<path d="M924.809,21.367c-1.143,0.003-1.663,0.124-1.623,0.371c0.032,0,0.069-0.004,0.095-0.004
					C924.421,21.687,924.702,21.514,924.809,21.367z"/>
				<path d="M938.928,9.833c0.928-0.156,0.546-0.22-0.351-0.328c-0.867-0.109-1.096-0.172-1.024-0.287
					c-0.106,0.04-0.17,0.065-0.575,0.121c-0.595,0.08-0.713,0.126-0.701,0.259c0.061-0.006,0.129-0.013,0.19-0.016
					C938.517,9.419,938.813,9.709,938.928,9.833z"/>
				<path d="M928.558,22.921c0.486,0.195,1.648,0.333,1.844,0.178c0.295-0.229-1.521-0.103-1.774-0.304
					C928.544,22.801,928.298,22.815,928.558,22.921z"/>
				<path d="M934.712,26.358c0,0.035-0.012,0.092,0.138,0.146c0.236,0.092,0.608,0.109,1.711,0.161
					c-0.671-0.075-0.884-0.29-1.746-0.306C934.781,26.358,934.747,26.358,934.712,26.358z"/>
				<path d="M923.243,26.396l-0.296-0.003l0.012,0.003C923.054,26.396,923.146,26.396,923.243,26.396z"/>
				<path d="M922.947,26.394c-0.085,0-0.181-0.001-0.259-0.004c0.029,0.002,0.055,0,0.093,0.004
					c0.046,0,0.095,0,0.152,0.003L922.947,26.394z"/>
				<path d="M953.4,24.998c0.086-0.142,1.057-0.225,0.615-0.391c-0.657-0.032-0.657-0.032-2.372,0.157
					c-2.774-0.54-2.774-0.54-3.612-0.617c0.341-0.276,0.341-0.276,1.579-2.691c0.118,0,0.285,0.016,0.414,0.006
					c0.83-0.04,0.259-0.275-0.977-0.407c3.107-3.352,3.107-3.352,3.475-4.531c-0.235-0.006-0.517-0.013-0.792-0.018l0.822,0.015
					c0.005-0.031,0.019-0.063,0.019-0.095c0.675-0.069,0.675-0.069,1.649-0.447c-0.548-0.179-0.623-0.265-0.658-0.521
					c-0.026-0.235-0.167-0.302-0.543-0.425c-0.083-0.021-0.184-0.044-0.255-0.061c-1.02,0.055-0.207,0.511,0.092,0.586
					c-0.523-0.035-0.689,0.04-0.993,0.2c-0.448,0.23-0.732,0.311-1.534,0.346c0.378,0.166,0.506,0.255,0.581,0.391h0.025l-1.217,1.26
					c-0.341,0.17-1.166,0.089-1.685,0.164c0.284,0.278,0.378,0.37-0.718,0.608c-0.92,0.196-0.937,0.228-0.386,0.448
					c-0.594,0.213-1.749,0.144-2.552,0.262c0.841,0.37,1.074,0.623,1.031,1.085c-0.235,0.025-0.557,0.058-0.792,0.083
					c0,0.026-0.262,2.677-2.9,2.677c0.201,0.506-1.243,0.957-1.005,1.468c-0.046,0.008-0.098,0.028-0.145,0.037
					c-0.792-0.066-0.792-0.066-1.068-0.003c0.896,0.324,0.896,0.324-0.603,1.163c1.953,0.141,1.993,0.778,1.982,0.907l13.981,0.206
					C955.239,25.296,955.239,25.296,953.4,24.998z M945.518,24.483c0.083,0.074,0.368,0.132,0.405,0.206
					c0.011,0.018,0.023,0.058-0.259,0.089c-0.026,0.004-0.051,0.004-0.063,0.007c-0.083-0.078-0.416-0.133-0.442-0.219
					C945.154,24.521,945.389,24.497,945.518,24.483z M948.53,26.172c-1.699-0.098-1.699-0.098-2.158,0.063
					c0.151,0.118,0.35,0.275,0.504,0.4c-0.743,0.054-1.507,0.031-2.262,0.048c-0.098,0-0.213,0.003-0.302,0.006
					c-0.124-0.114-0.134-0.155-0.066-0.321c0.092-0.235,0.061-0.371-0.19-0.652c0.919-0.052,1.063-0.135,1.671-0.497
					c-0.031,0.189,0.891,0.271,1.502,0.322c0.744,0.063,1.333,0.115,1.602,0.247C949.053,25.894,948.62,26.057,948.53,26.172z"/>
				<path d="M928.303,25.014c-0.93,0.044-0.93,0.044-1.103,0.016c-0.017-0.115-0.248-0.218-0.27-0.33
					c-0.012-0.044,0.005-0.05,0.175-0.084c0.687-0.144,1.321,0.046,1.982,0.021c-0.221-0.565-0.213-0.807,0.061-1.367
					c-0.85-0.075-1.729-0.028-2.597-0.037c-0.511,0.224-0.221,0.543-1.528,0.672c-1.327-0.149-0.322-0.864-1.958-0.721
					c0.247-0.268,1.011-0.49,1.172-0.768c0.049-0.089-0.33-0.197-0.571-0.27c-0.27-0.04-0.626-0.092-0.885-0.132
					c-0.66,0.207,0.236,0.391,0.141,0.585c-0.095,0.196-1,0.288-1.177,0.472c-0.023,0.021-0.035,0.046-0.043,0.065
					c-0.092,0.245,0.267,0.486,0.032,0.73c-0.614,0.617-0.614,0.617-0.023,0.933c0.6,0.319,0.623,0.385,0.232,0.595
					c0.468,0.021,0.864,0.101,1.375,0.078c0.109-0.003,0.158-0.031,0.321-0.146c1.157,0.014,0.638,0.456,1.864,0.416
					c-0.152,0.092-0.21,0.126-1.02,0.146c-1.608,0.037-1.125,0.221-0.936,0.272c0.31,0.071,0.64-0.028,0.948,0.006
					c0.212,0.026,0.631,0.213-0.288,0.247c0.864,0.012,2.014,0.028,2.877,0.037c-0.048-0.066-0.097-0.135-0.143-0.2
					C928.084,26.037,928.084,26.037,928.303,25.014z"/>
				<path d="M884.599,12.738c0.448,0.189,0.636,0.293,0.512,0.435c0.034-0.01,0.078-0.016,0.106-0.021
					c0.99-0.213,0.677-0.574-0.661-0.771C884.01,12.46,884.151,12.549,884.599,12.738z"/>
				<path d="M906.472,16.201c0.342,0.115,0.854,0.139,1.103,0.146c0.076-0.146-0.024-0.209-0.307-0.341
					c-0.258-0.127-0.353-0.207-0.249-0.368C906.142,15.733,905.971,16.034,906.472,16.201z"/>
				<path d="M890.464,16.207c-0.391,0-0.501,0.149-0.207,0.256c0.317,0.115,0.695,0.058,0.82,0.037
					c-0.006-0.058-0.03-0.132-0.043-0.191l-0.5-0.102C890.51,16.204,890.487,16.207,890.464,16.207z"/>
				<path d="M880.756,18.137c0.211,0.072,0.571,0.109,0.659,0.019c0.072-0.07-0.03-0.162-0.076-0.214
					C880.309,17.965,880.708,18.119,880.756,18.137z"/>
				<path d="M879.664,18.594c0.073-0.066-0.289-0.155-0.405-0.181c-0.396,0.077-0.525,0.138-0.378,0.189
					C879.058,18.663,879.589,18.666,879.664,18.594z"/>
				<path d="M867.695,18.694c0.206,0.061,0.577,0.068,0.777,0.074c-0.578-0.144-0.437-0.172,0.082-0.218
					c0.614-0.052,0.873-0.106,0.684-0.265c-0.07-0.008-0.148-0.015-0.229-0.015C868.014,18.271,867.246,18.57,867.695,18.694z"/>
				<polygon points="879.43,19.094 880.326,19.102 880.25,18.815 878.946,18.803 "/>
				<path d="M861.058,20.136c0.024-0.012,0.047-0.028,0.076-0.04c0.078-0.028,0.161-0.058,0.271-0.08
					c0.573-0.107,1.587,0.068,1.468,0.539c2.729-0.287,2.895-0.304,3.496,0.04c0.63-0.034,1.302-0.025,1.904-0.089
					c0.448-0.043,0.471-0.065,0.619-0.163c-1.12-0.463-1.12-0.463-1.845-0.518c0.104-0.057,0.247-0.14,0.353-0.2
					c0.271,0.031,0.308,0.04,0.584,0.137c0.34,0.128,0.702,0.13,1.255,0.092c0.03-0.103-0.011-0.151-0.507-0.212
					c-0.565-0.074-0.731-0.111-0.512-0.292c-0.195,0.063-0.408,0.082-1.084,0.027c-0.737-0.057-0.932-0.005-1.061,0.139
					c-0.283-0.063-0.661-0.144-0.943-0.204c0.019-0.095,0.019-0.095,1.108-0.084c0.783,0.013,0.896-0.022,0.602-0.194
					c-0.172-0.006-0.666-0.006-1.185,0.028c-0.142,0.012-0.284,0.029-0.449,0.012c-0.201-0.012-0.201-0.104-0.211-0.184
					c0-0.023,0.006-0.049,0.006-0.069C861.647,18.946,859.878,19.538,861.058,20.136z M867.175,20.319
					c-0.377-0.006-1.273-0.023-1.826-0.241c-0.343-0.132-0.473-0.304-0.531-0.388C865.742,19.677,867.27,19.745,867.175,20.319z"/>
				<path d="M880.22,19.492c0.194,0.069,0.583,0.106,0.69,0.018c0.07-0.063-0.013-0.155-0.061-0.207
					C879.778,19.32,880.178,19.476,880.22,19.492z"/>
				<path d="M901.173,20.756c-1.286,0-1.381-0.025-1.492-0.057c-0.076-0.029-0.041-0.093,0.006-0.165
					c0.034-0.065,0.07-0.129,0.083-0.194c-0.372,0.014-0.66,0.04-0.92,0.135c-0.366,0.132-0.388,0.287-0.647,0.429
					c0.035,0.008,0.083,0.019,0.129,0.024C899.021,21.043,901.303,21.112,901.173,20.756z"/>
				<path d="M865.524,20.621c-0.304-0.061-0.617-0.066-0.782-0.069c-0.194,0.003-0.384,0.006-0.56,0.018
					c0.005,0.057,0.022,0.117,0.247,0.209c0.254,0.099,0.613,0.185,0.778,0.29C866.35,21.037,866.139,20.738,865.524,20.621z"/>
				<polygon points="861.152,22.098 861.094,21.904 860.281,21.898 860.327,22.088 "/>
				<path d="M894.325,22.792c0.029,0.006,0.059,0.009,0.081,0.014c0.838,0.179,1.846,0.34,3.491,0.334
					c-0.543-0.127-1.864-0.365-2.93-0.385C894.707,22.755,894.549,22.761,894.325,22.792z"/>
				<path d="M898.338,23.237c0.017,0,0.042,0,0.059,0c0.566-0.018,0.807,0.011,1.267,0.074
					c0.348,0.049,0.501,0.069,0.884,0.049c0.237-0.244-0.642-0.376-1.332-0.388C898.727,22.973,898.185,23.016,898.338,23.237z"/>
				<path d="M900.413,24.334c-0.019-0.057-0.034-0.132-0.053-0.189l-0.507-0.115c-0.473,0-0.555,0.161-0.254,0.268
					C899.747,24.352,900.011,24.397,900.413,24.334z"/>
				<path d="M862.065,26.231c0.011-0.002,1.463-0.277,1.94,0.463c0.849,0.052,1.331,0.012,1.526-0.12
					c0.406-0.285-0.165-0.558-0.17-0.84c-0.985,0.202-1.286,0.207-1.781,0.036c-0.637-0.22-0.896-0.23-1.746-0.265
					c0.237-0.222,0.214-0.285-0.135-0.417c-0.371-0.141-0.43-0.204-0.528-0.361c-0.03-0.003-0.073-0.003-0.107-0.006
					c-0.726-0.015-0.849,0.661-0.006,1.077c-0.826,0.152-0.849,0.27-0.507,0.66c0.252,0.287,0.188,0.379,0.106,0.493
					c0.106-0.005,0.26-0.011,0.366-0.017C862.485,26.826,861.229,26.431,862.065,26.231z M862.849,25.91l0.072,0.19l-0.884-0.01
					l-0.064-0.189L862.849,25.91z"/>
				<path d="M880.792,25.83c-0.532-0.031-0.885-0.052-0.838-0.296c0.849,0.092,1.853,0.026,2.688,0.132
					c0.024,0.104-0.024,0.13-0.143,0.198c3.161,0.043,7.369,0.093,10.539,0.135c-1.851-1.079-2.229-1.303-1.838-1.973
					c-1.532-0.215-1.51-0.548-1.287-0.688c1.51-0.021,2.659-0.262,4.062-0.349c-0.053-0.281-1.315-0.444-1.355-0.729
					c1.285-0.092,1.285-0.092,1.526-0.149c0.743,0.345,1.498,0.469,3.212,0.528c0.878-0.429,1.038-0.505,1.604-0.531
					c0.253,0.049,0.253,0.049,0.406,0.167c0.826-0.273-0.188-0.546-0.012-0.819c0.083-0.011,0.19-0.031,0.272-0.045
					c-0.236-0.081-0.236-0.081-1.304-0.018c-0.016-0.063-0.04-0.144-0.051-0.207c-1.781-0.327-2.676-0.844-4.656-1.134
					c2.688-0.315-0.042-0.975,0.542-1.447c-1.729-0.153-1.839-0.225-2.913-0.911c-0.895,0.092-1.826,0.092-2.386,0
					c-0.743-0.12-0.03-0.293-0.283-0.43c-0.719-0.107-0.719-0.107-1.939-1.017c0.007-0.133,0.142-0.432,1.22-0.377
					c-0.395-0.034-0.932-0.083-1.327-0.117c0.236-0.127,0.308-0.158,0.85-0.192c-0.845-0.01-1.969-0.025-2.818-0.038
					c0.159,0.563-0.761,1.117-0.319,1.681c0.019,0.022,0.061,0.051,0.095,0.071c0.271,0.144,1.038,0.187,1.308,0.327
					c0.224,0.126-0.218,0.256,0.024,0.38c0.046,0.025,0.107,0.058,0.166,0.083c0.154,0.061,0.56,0.105,0.831,0.141
					c-0.489,0.195-1.514,0.603-0.607,0.93c0.118,0.041,0.407,0.092,0.388,0.142c-0.057,0.169-0.281,0.388-0.328,0.555
					c-0.025,0.071-0.012,0.168-0.012,0.241c0.017,0.419,1.214,0.77,1.319,1.177c0.129,0.465-0.701,0.91-0.612,1.378
					c0.169,0.861,0.1,0.977-0.343,1.528c0.767,0.121,1.004,0.252,1.063,0.591c-0.189,0.058-0.449,0.136-0.645,0.195
					c-1.136,0.018-2.067-0.198-3.223-0.146c-1.197,0.05-1.284,0.58-2.705,0.435c-0.046-0.035-0.065-0.093-0.036-0.133
					c-0.053-0.011-0.124-0.034-0.17-0.048c-0.318-0.01-0.638-0.01-0.955-0.004c0.304-0.104,1.048-0.694-0.62-0.684
					c0.418,0.494,0.359,0.861-0.254,1.459l2.004,0.022C880.892,25.842,880.744,25.83,880.792,25.83z M897.588,21.968
					c-0.435-0.009-0.942-0.034-1.284-0.179c-0.024-0.005-0.048-0.017-0.07-0.028C897.059,21.77,897.708,21.775,897.588,21.968z
					 M888.76,18.04c0.408,0.005,0.955,0.014,1.368,0.02c-0.06,0.149-0.136,0.192-0.497,0.198c-0.116-0.006-0.235-0.015-0.354-0.018
					c0.685,0.385,1.315,0.505,3.208,0.833c-0.803,0.77,0.647,1.571-0.708,2.326c-1.156,0.012-1.733-0.08-2.014-0.155
					c-0.108-0.028-0.427-0.118-0.526-0.339c-0.1-0.235,0.135-0.471,0.04-0.706c-0.14-0.362-0.364-0.729-0.473-1.098
					C888.642,18.599,888.659,18.36,888.76,18.04z"/>
				<path d="M855.428,24.359c-0.547-0.353,0.808-0.829-1.231-1.082c0.589-0.945-0.447-1.89,0.006-2.826
					c-0.389-0.009-0.909-0.011-1.297-0.017c0.017-0.244,1.538-0.232,1.561-0.475c-0.517,0.032-0.522,0.029-0.731,0
					c0.307-0.261,1.304-0.474,0.991-0.771c-0.313-0.009-0.731-0.018-1.037-0.029c-0.013-0.009-0.03-0.023-0.035-0.034
					c0.494-0.098,0.494-0.139,0.507-0.247c-0.88,0.053-1.108-0.167-1.746-0.219c-0.165-0.003-0.33-0.003-0.495,0
					c0.107,0.402,0.697,0.787,0.814,1.184c0.146,0.525-2.263,1.017-0.418,1.564c-0.896,0.248-0.727,0.586-1.427,0.851
					c0.507,0.439,0.224,0.898,0.712,1.333c0.229,0.2,1.228,0.296,1.362,0.508c0.089,0.138,0.099,0.271-0.549,0.557
					c-0.694,0.308-0.907,0.399-0.283,0.845l3.208,0.037C853.89,24.687,854.592,24.489,855.428,24.359z"/>
				<path d="M908.099,25.503c-0.042-0.031-0.112-0.078-0.331-0.099c-0.288-0.024-1.256,0.055-0.913,0.271
					c-0.579-0.126-0.803-0.175-1.285-0.598c-0.566-0.485-0.672-0.54-1.285-0.783c0.376-0.026,0.883-0.058,1.272-0.08
					c-0.012-0.626-1.101-0.787-2.015-0.816c-0.601-0.005-0.813,0.066-1.085,0.158c-0.294,0.101-0.471,0.161-1.461,0.146
					c-1.12-0.017-1.998-0.229-3.17-0.195c-0.695,0.017-0.725,0.023-0.943,0.066c0.342,0.191,1.296,0.313,1.291,0.542
					c0.266-0.126,0.383-0.181,0.801-0.229c0.677-0.087,1.469-0.058,2.164-0.127c0.095,0.127,0.095,0.161-0.035,0.178
					c-0.332,0.052-0.46-0.08-0.779-0.055c-0.07,0.038-0.082,0.043,0,0.153c0.602,0.074,0.85,0.286,1.774,0.226
					c-0.019,0.275-0.019,0.275,1.515,0.791c-1.752-0.044-2.688-0.145-4.001-0.432c-1.244,0.522-1.244,0.522-0.219,0.672
					c-0.224,0.006-0.224,0.006-1.805-0.117c-0.169-0.136-0.199-0.159,0.389-0.19c0.596-0.031,0.566-0.054,0.391-0.191
					c-0.289-0.216-1.569-0.219-1.851-0.438c-0.048-0.034-0.083-0.079-0.123-0.115c-0.043-0.039,0.051-0.103,0.064-0.148
					c-0.945,0.213-0.85,0.348,0.006,0.724c0.807,0.359,0.707,0.477-0.497,0.62c0.125,0.083,0.289,0.195,0.632,0.284
					c0.625,0.17,1.526,0.213,2.109,0.238c0.089,0.034,0.167,0.074,0.212,0.112c2.983,0.037,6.968,0.095,9.95,0.129
					C906.525,25.789,907.704,25.574,908.099,25.503z"/>
				<path d="M887.918,15.57c0.217,0.011,0.417,0.031,0.642,0.04c0.129,0.002,0.129-0.006,0.129-0.015
					c0.494,0.012,0.5,0.04,0.53,0.233c0.036,0.157,0.077,0.234,0.86,0.166c-0.205-0.109-0.34-0.221-0.329-0.402
					c0.124-0.382,0.9-0.738,0.884-1.126c-0.013-0.212-0.65-0.361-0.955-0.437c-0.731,0.007-1.004,0.012-1.097,0.066
					c-0.059,0.038,0,0.09,0.047,0.124c0.123,0.098,0.212,0.194,0.252,0.293c-1.342-0.089-1.303-0.592-3.129-0.534
					c0.146-0.069,0.465-0.099,0.712-0.144c0.011-0.023-0.046-0.058-0.099-0.081c-0.07-0.021-0.184-0.052-0.26-0.074
					c-1.71,0.063-1.803,0.27-1.373,0.74c0.393,0.437,0.464,0.646-0.514,0.816c0.183,0.103,0.266,0.169,0.348,0.286l2.813,0.038
					c0.165-0.003,0.329-0.003,0.488,0.009C887.888,15.57,887.905,15.57,887.918,15.57z M889.42,14.806l0.041,0.21l-0.89-0.012
					l-0.042-0.209L889.42,14.806z"/>
				<path d="M1156.446,9.33c0.133,0.089,0.156,0.268,0.164,0.27c-0.014,0.071-0.283,0.081-0.553,0.089
					c-0.512,0.012-0.658,0.046-0.461,0.184c0,0,0.023,0,0.035,0.003c1.91,0.115,2.758-0.594,1.861-0.909
					c-0.387-0.133-0.916-0.156-1.203-0.167c-0.389-0.009-0.787-0.017-0.857,0.104c-0.014,0.011-0.02,0.025-0.023,0.034
					c0.018,0.061,0.234,0.126,0.471,0.189C1156.079,9.184,1156.327,9.255,1156.446,9.33z"/>
				<path d="M1157.364,9.922c-0.35-0.007-0.471,0.014-0.701,0.082c-0.213,0.064-0.404,0.122-1.092,0.058
					c-0.01,0.092-0.006,0.144,0.104,0.219c0.012,0.006,0.027,0.015,0.037,0.02c0.121,0.05,0.229,0.072,0.559,0.099
					c0.492,0.037,0.666,0.071,0.543,0.284C1158.237,10.7,1157.866,10.085,1157.364,9.922z"/>
				<path d="M1144.187,11.429c-0.17-0.052-0.377-0.103-0.637-0.115c-0.367-0.005-0.473,0.089-0.326,0.145
					C1143.304,11.492,1143.55,11.552,1144.187,11.429z"/>
				<polygon points="1143.22,12.477 1144.517,12.417 1144.528,12.228 1143.251,12.102 "/>
				<path d="M1204.478,14.135c0.006-0.056,0.014-0.13,0.027-0.187l-0.461-0.11c-0.02,0-0.043-0.002-0.068-0.002
					c-0.377-0.003-0.539,0.144-0.281,0.252C1203.812,14.14,1204.05,14.191,1204.478,14.135z"/>
				<path d="M1177.358,13.674l0.438-0.286c-0.084-0.003-0.158-0.006-0.238-0.012c-0.73-0.012-0.602,0.195-0.602,0.195
					C1177.017,13.611,1177.233,13.646,1177.358,13.674z"/>
				<path d="M1203.792,15.455c0.344,0.123,0.977,0.146,1.314,0.16c0.381-0.258,0.078-0.591-0.635-1.384
					c-0.166-0.018-0.342-0.031-0.52-0.04c-0.068,0.003-0.166,0.006-0.236,0.006c-0.139,0.046-0.15,0.058,0.07,0.215
					c0.207,0.146,0.215,0.152,0.061,0.343c-0.117,0.143-0.27,0.286-0.295,0.43c0,0.012,0,0.029,0,0.038
					C1203.56,15.368,1203.739,15.432,1203.792,15.455z"/>
				<path d="M1136.325,12.768c0.123,0.052,0.369,0.103,0.799,0.046c0-0.058,0.008-0.136,0.012-0.19l-0.402-0.103
					c-0.021-0.006-0.047-0.006-0.078-0.006C1136.306,12.515,1136.005,12.636,1136.325,12.768z"/>
				<path d="M1137.054,14.071c0.037-0.003,0.082-0.006,0.105-0.01c1.109-0.095,1.227-0.163,0.805-0.456
					c-0.117-0.011-0.25-0.021-0.385-0.026C1136.534,13.568,1137.231,13.91,1137.054,14.071z"/>
				<path d="M1181.743,15.156c0.178,0.068,0.529,0.115,0.646,0.023c0.078-0.058,0.021-0.149-0.008-0.201
					C1181.343,14.979,1181.71,15.133,1181.743,15.156z"/>
				<path d="M1148.37,14.663c-0.043-0.044-0.178-0.115-0.59-0.133c-0.111-0.003-0.223,0-0.33,0.008
					c-0.004,0.087-0.016,0.199-0.016,0.285c0.016,0.003,0.033,0.003,0.051,0.006C1148.183,14.929,1148.468,14.761,1148.37,14.663z"/>
				<path d="M1172.399,16.839c0.799-0.022,0.873-0.195,0.844-0.367c-0.752,0-1.039,0.114-0.912,0.367
					C1172.356,16.839,1172.382,16.839,1172.399,16.839z"/>
				<path d="M1205.712,19.4c1.92,0.006,1.803-0.265,1.611-0.307c-0.24-0.055-0.639-0.037-0.861-0.098
					c-0.141-0.047-0.033-0.106,0.039-0.146c-0.119-0.013-0.24-0.018-0.357-0.023c-0.625-0.011-0.617,0.115-0.539,0.333
					c0.049,0.133,0.033,0.184-0.039,0.241C1205.614,19.4,1205.673,19.4,1205.712,19.4z"/>
				<path d="M1203.327,13.598c0.619-0.17-0.176-0.738-1.23-0.885c0.357,0.304,0.736,0.606,1.166,0.901
					C1203.28,13.611,1203.31,13.603,1203.327,13.598z"/>
				<path d="M1127.942,13.561c0.154-0.087,0.346-0.201,0.49-0.288l-0.881-0.115c-0.305,0.006-0.469,0.023-0.27,0.115
					C1127.493,13.367,1127.979,13.434,1127.942,13.561z"/>
				<path d="M1154.786,31.002c-0.004,0.011,0,0.023-0.004,0.037c0.408,0.012,0.799,0.021,1.215,0.031
					c-0.166-0.045-0.313-0.086-0.426-0.108C1155.319,30.962,1154.972,30.971,1154.786,31.002z"/>
				<path d="M1056.317,28.601c0.047-0.057,0.098-0.132,0.143-0.189c0.279-0.008,0.65-0.017,0.936-0.025
					c0.041-0.058,0.105-0.132,0.146-0.189c-0.248-0.008-0.582-0.021-0.836-0.031c2.18-0.646,0.236-1.391,0.979-2.074l-0.531-0.396
					c1.289-0.425,1.545-0.951,2.549-1.401c0.889,0,1.658,0.104,2.502,0.151c-0.039-0.071-0.076-0.163-0.107-0.235
					c-0.26-0.037-0.592-0.085-0.842-0.126c-0.189,0.037-0.434,0.095-0.621,0.136c-0.307-0.006-0.723-0.013-1.031-0.016
					c0.055-0.065,0.133-0.149,0.18-0.212c-0.18-0.043-0.418-0.101-0.602-0.141c-0.271,0.009-0.629,0.02-0.904,0.028
					c0.303-0.126,0.928-0.27,1.488-0.339c0.43-0.597-0.203-1.194-0.102-1.792c0.225-0.046,0.531-0.104,0.756-0.148
					c0.025,0.005,3.527,1.275,4.328,1.769c-0.238,0.109-0.607,0.246-0.934,0.345c0.201,0.108,0.689,0.241,1.143,0.299
					c0,0.003-0.318,1.076-1.836,2.599c1.143,0.359,0.826,0.469-0.508,0.915c1.074,0.309,1.561,0.449,1.521,1.285
					c20.357,0.433,47.504,1.014,67.863,1.449c0.139-0.049,0.318-0.115,0.459-0.16c0.539,0.045,1.197,0.151,1.539,0.258l95.26,2.521
					c-0.004-0.012-1.855-1.872-2.813-2.459c0.244-0.017,0.57-0.04,0.811-0.051c-0.209-0.304,0.053-0.603-0.078-0.908
					c-0.342-0.028-0.801-0.068-1.145-0.097l0.441,0.487c-0.27,0.067-0.625,0.153-0.891,0.219c0.049,0.058,0.109,0.132,0.156,0.189
					c-0.377,0.106-0.873,0.249-1.244,0.356c0.105,0.12,0.045,0.293-0.184,0.401c-0.766-0.092-1.189-0.148-1.615-0.511
					c0.191-0.049,0.443-0.108,0.633-0.155c0.24,0.023,0.561,0.047,0.795,0.063c0.072-0.132,0.059-0.308,0.012-0.438
					c0.4-0.078,0.801-0.223,1-0.337c-0.447-0.087-1.105-0.192-1.619-0.258c-1.867-2.659-1.867-2.659-2.551-2.792
					c-0.307,0.021-0.723,0.047-1.037,0.063c0.141,0.133,0.258,0.313,0.334,0.447c-0.316-0.057-0.746-0.134-1.066-0.188
					c0.176-0.592-0.803-1.189,0.129-1.775c0.082-0.006,0.168-0.011,0.813-0.046c0.084-0.055,0.191-0.126,0.271-0.178
					c-2.465-0.367-1.377-1.166-3.67-1.551c0.352-0.212,0.352-0.212-0.52-0.977c-0.383-0.011-0.789-0.022-1.197-0.034l1.205,0.034
					c-0.025-0.098,0.188-0.181,0.221-0.275c0.037-0.146-0.834-0.21-1.211-0.235c-1.004-0.074-1.074-0.092-1.355-0.213
					c-0.117,0.009-0.117,0.009-0.109,0.146c-0.068,0.018-0.215,0.026-0.311,0.032c-2.229-0.435-1.209-1.074-1.998-1.604
					c-2.141,0.152-2.141,0.152-2.57,0.225c-0.287-0.046-0.33-0.058-0.447-0.195c-0.102-0.12-0.262-0.207-1.189-0.146
					c0.164-0.313-0.074-0.434-1.002-0.52c-0.361-0.018-0.734-0.026-1.096-0.023c0.361,0.256,0.059,0.526,0.33,0.788
					c-0.438,0.108-0.969,0.24-0.996,0.568c-0.008,0.391,0.605,0.76,0.896,1.143h0.016c0.191,0.597-0.141,0.678-2.275,0.896
					c-0.195-0.095-0.195-0.095-1.27-0.996c-0.83,0.015-1.938,0.031-2.775,0.043c-0.176,0.049-0.412,0.112-0.59,0.157
					c-0.348-0.095-0.791-0.226-1.111-0.324c-3.502-0.092-8.166-0.218-11.658-0.307c-0.055,0.129-0.195,0.301-0.34,0.427
					c1.053,0.277,1.252,0.645,2.012,0.954c-4.492-0.7-4.828-0.801-6.535-1.502c-0.254-0.014-0.59-0.037-0.844-0.049
					c-0.605-0.017-1.408-0.037-2.018-0.054c4.568,0.904,5.973,1.26,7.234,2.027c-5.092-0.337-7.252-1.451-11.059-2.132
					c-0.342-0.008-0.719-0.021-1.063-0.028c0.338,0.008,0.709,0.021,1.039,0.026c-8.215-1.321-8.215-1.321-8.604-1.362
					c-4.617-0.487-9.727-0.637-14.43-1.062c5.447-0.497,6.424-0.106,6.896,0.081c8.475-0.179,16.59,1.486,16.668,1.501
					c0.463,0.361,0.463,0.361,3.336,0.948c0.559,0,1.301,0,1.855,0c-0.117-0.055-0.32-0.112-0.525-0.152
					c0.178-0.242,0.285-0.271,0.898-0.351c1.805,0.33,3.021,0.493,5.232,0.706c3.572,0.096,8.348,0.227,11.92,0.327
					c-4.494-1.85-4.494-1.85-6.389-2.096c0.135-0.5-2.844-0.775-3.561-0.775c-1.77-0.015-1.77-0.015-2.746-1.321l-0.805-0.022
					c0.029-0.448,0.029-0.448-1.369-0.862c0.049-0.04,0.121-0.097,0.166-0.14c-1.701,0.157-2.051,0.467-0.947,0.835
					c-1.729-0.091-1.729-0.091-3.498-0.96c-2.855-0.005-2.555,0.475-1.982,0.696c0.135-0.018,0.313-0.041,0.447-0.058
					c0.117,0.017,0.277,0.037,0.398,0.052c0.408,0.401-0.238,0.801-0.158,1.206c-0.766-0.081-1.785-0.184-2.549-0.259
					c0.154-0.385-0.541-0.775,0.014-1.16c-1.648-0.071-1.648-0.071-2.309,0.807c-1.541-0.017-1.867-0.187-2.383-0.536
					c-0.707-0.047-0.707-0.047-2.971-1.149c-0.57,0.189-1,0.196-2.566,0.029c-0.508,1.092-0.508,1.092-0.695,1.146
					c-0.793-0.095-0.367-0.417-1.521-0.437c-1.277-1.651-1.369-3.334-2.609-4.984c-0.15-0.19-0.369-0.233-1.346-0.268
					c0.467-0.136,0.572-0.178,0.535-0.568c-0.891-0.069-1.721-0.167-2.568-0.259c-1.105,0.49-1.105,0.49-1.43,0.523
					c-0.551-0.34-0.387-0.391,0.131-0.558c-0.105-0.023-0.254-0.052-0.357-0.071c-0.012-0.004-0.031-0.004-0.049-0.004
					c-0.891,0.156-0.947,0.408-1.418,0.612c0.334,0.06,0.334,0.06,1.732,0.537c-1.08,0.499-1.08,0.499-1.83,0.534
					c0.121,0.071,0.637,0.536-0.197,2.911c0.369,0.178,0.867,0.431,0.883,0.626c0,0.012-0.307,2.017-0.307,2.045
					c-0.029,0.101-0.207,0.23-0.318,0.327c-2.521-0.195-3.102-0.396-3.809-1.347c-0.99-0.515-0.313-1.08-1-1.6
					c-0.461-0.344-1.934-0.555-2.336-0.907c-0.15-0.133-0.15-0.238-0.021-0.479c0.01-0.015,0.719-1.517-2.336-1.307
					c0.195,0.135,0.238,0.16,1.107,0.382l0.039,0.006c-1.141,0.382-1.141,0.382-0.732,1.014c0.363,0.563,0.33,0.694-0.176,2.274
					c-0.238,0.74,0.959,1.511-0.738,2.229c-0.891,0.375-2.111-0.377-3.33-0.506c0.955-0.77-1.414-1.548,0.07-2.32
					c-0.896-0.485,0.578-1.143-2.104-1.499c-0.039,0.195-0.045,0.224-0.033,0.58c-0.123-0.063-0.275-0.149-0.398-0.213
					c-1.391,0.367-1.521,0.75-0.459,1.355c-0.506,0.219-0.506,0.219-0.807,2.205c-0.109,0.707-1.871,1.287-3.518,0.92
					c0.092-0.155,0.539-0.284,0.633-0.44c-0.117-0.02-0.281-0.048-0.398-0.071c-0.246,0.012-0.576,0.031-0.824,0.047
					c-0.195,0.126-0.135,0.275-0.502,0.391c-1.689-0.19-0.48-0.707-2.039-0.911c0.605-0.195,0.713-0.451,1.441-0.629
					c0.232,0.003,0.523,0.006,0.738,0.006c-1.574-0.853-2.174-1.367-2.93-2.505c-1.803,0.118-2.088,0.115-4.775,0.087
					c0.725,0.46,0.725,0.46,1.238,0.521c0.105-0.023,0.242-0.055,0.344-0.078c0.047,0.028,0.107,0.065,0.152,0.097
					c-0.428,0.173-0.715,0.162-1.338,0.147c0.117,0.29-1.242,0.546-0.428,0.853c-0.457,0.089-0.457,0.089-2.174,0.155
					c0.424,0.545-0.08,1.105,0.393,1.653c-0.119-0.057-0.355-0.126-0.568-0.166c-0.783,0.145-0.813,0.299-0.525,0.718
					c-0.539-0.011-1.086-0.022-1.631-0.039c-0.49-0.153-0.387-0.526,0.342-0.639c0.08,0.023,0.199,0.052,0.285,0.075
					c0.141-0.028,0.324-0.069,0.459-0.099c-3.551-0.775,1.215-1.923-2.357-2.698c-0.201,0.005-0.475,0.008-0.676,0.011
					c-0.068,0.491-0.068,0.491,0.412,0.601c-2.898,0.669-0.416,1.881-4.764,2.398c-1.104-0.362-1.104-0.362-0.785-1.692
					c-1.439-0.313-1.439-0.313-2.285-0.313c0.785-0.241,0.785-0.241,0.404-0.477c-0.777,0.012-2.598,0.031-2.105,0.925
					c2.381,0.878-0.813,1.729-0.27,2.596l11.07,0.261c-3.432-0.071-7.75-0.16-11.053-0.231c0.086,0.057,0.205,0.126,0.297,0.181
					c-1.121,0.416-0.723,0.925-1.641,1.35c0.111,0.057,0.252,0.131,0.361,0.186c-0.215,0.035-0.508,0.081-0.721,0.115
					c0.432,0.066,0.941,0.173,1.248,0.265c-0.166,0.058-0.398,0.135-0.57,0.194c-0.453-0.048-1.16-0.073-1.656-0.054
					c0.258,0.479-1.355,0.842-1.543,1.292c-0.313-0.083-0.896-0.175-1.381-0.204c-0.717-1.134-0.879-1.797-1.037-3.491v-0.015
					c-0.631-0.003-1.473-0.003-2.104-0.009c-0.455,0.371-1.764,0.667-1.811,1.074c-0.525,0.052-1.27,0.097-1.826,0.12
					c-1.039,0.411-0.871,0.894-1.486,1.327c-0.313,0.006-0.719,0.017-1.025,0.022c-2.063-0.394-2.559-0.488-4.615-0.588
					c1.549-2.04,1.551-2.042,2.053-2.191h0.041l-4.322-3.515c0,0,0.029-0.124,0.299-0.379c0.121-0.018,0.281-0.034,0.404-0.052
					c-0.215-0.132-0.215-0.132-1.309-0.425c0.414-0.587,0.408-0.718-0.488-1.08c0.971-0.371,1.24-0.709,1.373-1.723
					c-1.264-0.319-0.201-0.825-1.77-1.117c0.695-1.097-0.732-2.168-0.813-3.253c-0.637-0.064-0.637-0.064-1.678-1.029
					c-1.154,0.146-1.154,0.146-2.207,0.047c0.141,0.166,0.141,0.166-0.92,0.677c0.107,0.021,0.254,0.047,0.359,0.064
					c0.129-0.007,0.309-0.013,0.441-0.018c0.029-0.037,0.066-0.087,0.096-0.121c0.148,0.043,3.494,1.027,0.371,1.373
					c0.355,0.293,0.424,0.355,0.814,0.885c0.494,0.671,0.281,1.354,0.469,2.032c0.201,0.692-1.813,1.284-1.744,1.971
					c-1.621-0.293-2.771-0.689-4.396-0.982c-0.27-0.589-1.854-1.071-2.604-1.623c-0.318,0.089-0.471,0.207-0.896,0.279
					c-2.109-0.288-2.369-0.547-3.432-1.646c-1.51-0.521,1.025-1.255-1.762-1.709c0.949-0.087,1.332-0.391,2.621-0.339
					c-0.713-0.241-1.258-0.511-2.107-0.732c2.273-0.302,0.4-0.842,0.861-1.255c-0.896-0.063-0.896-0.063-1.758-0.934
					c-1.416-0.092-1.131-0.474-2.111-0.637c0.512-1.008-2.547-1.8-3.254-2.734c0.092-0.025,0.211-0.058,0.309-0.083
					c0.135,0,0.318,0.002,0.465,0.006c-0.699-0.178-1.98-0.167-2.48-0.402c-0.035-0.052-0.084-0.117-0.121-0.166
					c-0.928,0.976-0.928,0.976-0.553,1.077c-0.381-0.038-0.381-0.038-3.537,0.034c0.443,1.777,0.443,1.777,0.805,2.085
					c1.789-0.445,1.789-0.445,1.824-0.649c-0.412,0.021-0.977,0.043-1.387,0.065c0.016-0.367,0.016-0.367,0.113-0.493
					c2.453,0.144,2.471,0.305,2.549,1.545c3.488,0.385,3.488,0.385,3.869,1.854c-0.264,0.081-0.604,0.188-0.863,0.268
					c0.717,0.431,0.717,0.431-0.047,0.508c-1.381-0.275-0.738-0.683-1.285-1.013c-0.225,0.024-0.555,0.051-0.756,0.088
					c-0.801,0.144-1.66,0.667-0.234,0.748c0.984,0.564,0.984,0.564,1.848,0.551c-0.873,0.551,0.891,0.979,1.301,1.47
					c-0.104,0.028-0.232,0.072-0.332,0.104c-0.17,0.003-0.398,0.009-0.578,0.012c1.072,0.241,1.586,0.391,2.207,0.637
					c-1.475,0.282-1.475,0.282-1.316,0.676c-0.771-0.066-0.807-0.33-1.785-0.346c0,0.256,0,0.518,0,0.775
					c-0.613-0.092-0.613-0.092-1.436-0.123c-0.18-0.063-0.959-0.499,1.023-0.471c-1.068-0.25-1.051-0.444-0.414-1.089
					c-1.627,0.228-2.182-0.369-3.514-0.462c0.006-0.04,0.006-0.098,0-0.144c0.41-0.06,0.885-0.08,1.32-0.126
					c-0.941-0.229-0.482-0.572-1.309-0.811c-1.496,0.518-2.197,2.872-2.203,2.895l0.006,0.494c1.965,0.666,0.43,1.87,0.039,1.95
					c1.205,0.391-0.352,0.784,0.021,1.175c0.164,0.175,1.229,0.137,1.406,0.305c0.084,0.086-1.082,0.468-2.676,0.057
					c0.27-0.022,0.625-0.052,0.896-0.075c-0.732-0.172-1.037-0.232-2.205-0.235c0.809,0.38-0.07,0.799,0.602,1.184
					c0.742-0.018,1.355-0.112,2.045-0.163c0.396,0.065,0.914,0.16,1.313,0.231c-0.381,0.609,0.049,1.224-0.305,1.836
					c-1.131,0.487-1.131,0.487-0.721,1.43l35.398,0.767c-10.623-0.181-24.719-0.425-35.313-0.601c0.32,0.618,0.371,0.744,0.326,1.112
					c-0.234,0.022-0.553,0.054-0.773,0.077c1.332,0.646,0.781,0.79,0.08,0.974c1.135,0.425,0.873,0.922,1.434,1.373
					c-1.023,0.272-1.244,0.634-2.068,0.927c1.508,0.543,0.258,1.206,1.494,1.761c-0.373,0.108-0.865,0.252-1.236,0.361
					c0.354,0.327,1.426,0.621,1.016,0.985c-0.012,0.014-2.262,0.684-3.973-0.377c-1.734,0.905-0.385,1.31,0.568,1.468
					c0.371-0.08,0.844-0.192,1.174-0.278c1.357,0.338,1.322,0.364,0.344,1.108c0.211,0.04,0.492,0.104,0.705,0.148
					c-0.057,0.121-0.291,0.282-0.531,0.391l2.928,0.058C1056.331,28.636,1056.253,28.604,1056.317,28.601z M1223.882,31.955
					c-0.086,0.108,0.029,0.149,0.24,0.23c0.236,0.085,0.271,0.143,0.143,0.255l-1.711-0.049
					C1222.79,32.139,1223.071,31.995,1223.882,31.955z M1210.157,32.193c-0.205-0.008-0.334-0.055-0.375-0.075
					c-0.041-0.017-0.379-0.171,0.641-0.178C1210.54,32.128,1210.46,32.199,1210.157,32.193z M1211.29,31.691
					c-0.174,0.008-0.354,0.018-0.535,0.015c-0.604-0.023-0.922-0.115-1.051-0.167c-0.049-0.021-0.471-0.204,0.336-0.268
					c0.063,0.068,0.23,0.098,0.604,0.144C1211.155,31.479,1211.446,31.524,1211.29,31.691z M1210.778,24.268
					c-0.018-0.009-0.037-0.014-0.049-0.022c0.318-0.009,0.609-0.052,0.939-0.061c0.383-0.012,0.723,0.018,0.723,0.018
					c0.488,0.12,0.531,0.298,0.438,0.583c-0.309-0.01-0.768-0.021-1.145-0.118C1211.226,24.553,1211.075,24.4,1210.778,24.268z
					 M1210.767,23.673c0.023-0.445,0.035-0.611,1.307-0.537c0.072,0.061,0.145,0.089,0.441,0.164c0.42,0.104,0.572,0.179,0.389,0.339
					c-0.521,0.063-0.922,0.081-1.535,0.066c-0.18-0.009-0.354-0.022-0.527-0.025C1210.817,23.677,1210.79,23.673,1210.767,23.673z
					 M1213.372,30.135c0.07,0.132,0.098,0.265-0.207,0.259c-0.256-0.013-0.396-0.075-0.422-0.086
					C1212.651,30.267,1212.45,30.143,1213.372,30.135z M1213.019,31.353c-0.023,0-0.055,0-0.072,0c0.082-0.112-0.195-0.235,0.082-0.345
					c0.166-0.066,0.598-0.017,0.779,0C1213.923,31.234,1213.665,31.353,1213.019,31.353z M1214.087,22.325
					c-1.432-0.041-2.953-0.084-4.453-0.128L1214.087,22.325z M1209.649,21.729l-0.02,0.278c-0.115,0-0.227,0.009-0.336,0.006
					c-0.129-0.003-0.344-0.012-0.486-0.075c-0.178-0.076-0.146-0.175-0.424-0.244C1208.759,21.703,1209.267,21.718,1209.649,21.729z
					 M1208.007,20.624l0.867,0.022l-0.016,0.189l-0.875-0.026L1208.007,20.624z M1202.319,23.062c0.502,0.015,1.174,0.034,1.668,0.05
					c0.619,0.737,0.604,1.108-0.098,1.717c-0.412-0.04-0.551-0.055-0.879-0.173c-0.465-0.172-0.918-0.543-0.994-0.7
					C1201.888,23.653,1202.271,23.36,1202.319,23.062z M1197.954,24.754l-0.402-0.104c0.008-0.163,0.252-0.218,0.807-0.178
					C1198.241,24.558,1198.069,24.67,1197.954,24.754z M1197.604,22.646c0.289-0.184,0.404-0.241,0.877-0.265
					c2.088,0.54,0.152,1.172,0.768,1.744c-0.377-0.021-1.02-0.052-1.473-0.245c-0.684-0.278-0.469-0.632-1.402-0.891
					C1196.868,22.933,1197.222,22.881,1197.604,22.646z M1177.948,25.063c0.117,0.034,0.277,0.08,0.395,0.118v0.186
					c-0.123,0.023-0.193,0.023-0.406,0.019c-0.072-0.003-0.184-0.006-0.305-0.056C1177.323,25.207,1177.499,25.058,1177.948,25.063z
					 M1160.937,29.006c0.025,0.006,0.049,0.009,0.061,0.015c0.592,0.161,0.283,0.221-0.119,0.216c-0.223-0.01-0.314-0.037-0.354-0.05
					C1160.396,29.142,1160.524,29.077,1160.937,29.006z M1161.183,29.716c0.627-0.109,0.873-0.139,1.512-0.19
					c0.355,0.185,0.355,0.185,0.412,0.488c0-0.012,0-0.028-0.031-0.04c-0.041,0.012-0.301,0.426,0.525,0.719
					c-0.865-0.026-1.725-0.047-2.596-0.069c-0.258-0.195-0.836-0.352-1.252-0.528c-0.295-0.121-0.371-0.192-0.441-0.267
					C1160.313,29.859,1160.644,29.81,1161.183,29.716z M1157.542,29.21c0,0.178,0.842,0.16,1.227,0.252
					c0.342,0.081,0.242,0.236-0.402,0.236c-0.566-0.023-0.947-0.182-0.99-0.198C1157.224,29.434,1156.927,29.278,1157.542,29.21z
					 M1152.071,25.965c0.107,0.018,0.168,0.047,0.285,0.058c0.373,0.046,0.896,0.089,1.283,0.126c0.072,0.306,0.514,0.466,1.521,0.729
					c0.896,0.227,1.301,0.354,1.523,0.601h-0.068c-1.279-0.044-1.773-0.187-2.408-0.485c-0.424-0.206-0.799-0.379-1.639-0.468
					c-0.061-0.009-0.143-0.016-0.201-0.021c0.141-0.184-0.225-0.35-0.359-0.528C1152.022,25.973,1152.048,25.971,1152.071,25.965z
					 M1164.222,17.755c0.6-0.095,1.736-0.031,1.537,0.259c-0.152-0.003-0.309,0.003-0.467,0.003c-0.203-0.006-0.813-0.023-1.082-0.139
					c-0.078-0.031-0.107-0.063-0.123-0.097C1164.132,17.77,1164.173,17.764,1164.222,17.755z M1156.487,14.567
					c0.197,0.178,0.902,0.313,0.854,0.511c-0.252-0.005-1.008-0.024-1.461-0.209C1155.788,14.823,1155.325,14.611,1156.487,14.567z
					 M1131.608,29.055c-0.307-0.009-0.732-0.018-0.996-0.127c-0.213-0.085-0.256-0.197-0.318-0.384
					C1131.7,28.578,1132.235,28.923,1131.608,29.055z M1125.757,15.837c-0.012,0.262-0.09,0.322-0.146,0.325
					c-0.125-0.006-0.223-0.044-0.738-0.251c-0.127-0.003-0.287-0.008-0.414-0.011C1124.911,15.905,1125.271,15.806,1125.757,15.837z
					 M1124.86,16.696c0.006,0.073,0.135,0.108,0.441,0.16c0.389,0.065,0.555,0.112,0.426,0.235c-0.092,0-0.178,0.011-0.266,0.011
					c-0.359-0.017-0.65-0.068-0.859-0.154C1124.452,16.885,1124.187,16.713,1124.86,16.696z M1118.802,19.446
					c0.572-0.052,0.572-0.052,1.123-0.298c0.178-0.003,0.418-0.006,0.596-0.013c0.137,0.109,0.137,0.109,0.891,0.253
					c-0.1,0.058-0.195,0.145-0.225,0.207c0.156,0.003,0.361,0.009,0.514,0.017c0.109,0.109,0.109,0.109-0.26,0.277
					c1.471,0.034,3.025,0.073,4.582,0.113c-2.076-0.017-4.107-0.027-6.055-0.017c-0.158-0.046-0.389-0.106-0.547-0.149
					c0,0-0.012,0-0.014,0c0.049-0.021,0.086-0.061,0.178-0.058C1118.769,19.602,1118.769,19.602,1118.802,19.446z M1119.323,20.521
					c-0.031-0.003-0.068,0-0.092,0l0.467-0.379C1120.257,20.291,1120.196,20.497,1119.323,20.521z M1112.677,27.175
					c0.402,0.243,0.637,0.243,0.967,0.215c0.902-0.075,0.824-0.343,1.646-0.435c2.057,0.515,4.58,0.756,8.988,0.877
					c0.037,0.244,1.338,0.35,1.32,0.6c-0.357,0.061-0.715,0.071-1.533,0.058c-0.242-0.009-0.475-0.012-0.709-0.021
					c-0.104,0-0.244-0.003-0.354-0.006c-0.105,0-0.248-0.005-0.354-0.008c-0.072-0.055-0.176-0.136-0.275-0.188
					c-1.152-0.603-2.877-0.562-4.027,0.086c-0.529-0.275-1.492-0.191-1.498-0.188c-1.215,0.132-3.389,0.005-5.063-0.29
					c-0.102-0.021-0.23-0.043-0.322-0.063C1111.853,27.597,1112.228,27.384,1112.677,27.175z M1079.538,16.115
					c-0.059,0-0.115-0.003-0.176-0.006c-0.014,0-0.02,0-0.029,0c-0.162-0.315-0.004-0.511,1.279-0.442
					C1080.54,15.942,1080.493,16.127,1079.538,16.115z M1070.653,26.545c-0.143,0.08-0.318,0.189-0.449,0.271l-0.414-0.104
					C1069.851,26.583,1069.944,26.505,1070.653,26.545z M1066.479,27.699l0.031,0.188c-0.078,0.089-0.201,0.111-0.527,0.111
					c-0.541-0.017-1.027-0.121-1.186-0.184C1064.417,27.656,1065.058,27.671,1066.479,27.699z M1063.231,21.738
					c0.184,0.043,0.205,0.14-0.35,0.132c-0.313-0.006-0.613-0.047-0.906-0.115c-0.016-0.003-0.041-0.008-0.057-0.011
					C1062.581,21.689,1063.024,21.689,1063.231,21.738z M1060.53,20.032c0.303,0.08,0.449,0.259-0.453,0.247
					c-0.129,0-0.27-0.005-0.398-0.018c-0.025,0-0.049-0.005-0.076-0.005c-0.01-0.061-0.014-0.145-0.02-0.207
					C1060.009,19.918,1060.392,19.995,1060.53,20.032z M1060.089,20.733c0.166,0.017,0.33,0.037,0.514,0.042
					c0.313,0.003,0.549-0.014,1.211-0.082c0.418,0.234,0.326,0.341-0.051,0.504c-0.248,0.109-0.324,0.162-0.354,0.254
					c-0.203,0-2.051-0.018-2.414-0.052c-0.049,0-0.121,0-0.168-0.003c0.188-0.396,0.188-0.396-0.482-0.778
					C1059.069,20.639,1059.495,20.658,1060.089,20.733z M1053.06,26.855l-0.928-0.316c0.496-0.114,0.955-0.074,1.252-0.022
					C1053.849,26.603,1054.22,26.826,1053.06,26.855z"/>
				<path d="M1199.329,21.904l2.553,0.072c-0.436-0.264-1.064-0.388-2.186-0.434c-0.092-0.006-0.189-0.006-0.281-0.012
					C1199.491,21.669,1199.507,21.784,1199.329,21.904z"/>
				<path d="M1354.134,26.832l-0.025,0.092c1.016,0.034,2.371,0.075,3.383,0.109c0.133-0.046,0.307-0.109,0.441-0.155
					c0.352,0.009,0.352,0.009,1.537,0.161c0.215-0.029,0.439-0.098,0.563-0.149c0.279,0.006,0.658,0.012,0.939,0.018
					c0.057-0.029,0.129-0.063,0.184-0.089c1.195,0.112,1.814,0.221,2.762,0.474c1.162,0.046,2.357,0.034,3.473,0.132
					c0.006,0,0.016,0.006,0.029,0.006c0.324,0.038,0.625,0.086,0.914,0.138l-0.111-0.109c0.047-0.063,0.119-0.149,0.17-0.213
					c2.918-0.103,3-0.314,3.119-0.607c2.25,0.464,4.791,0.289,6.104,0.143c1.086,0.086,1.262,0.402,2.379,0.483
					c-0.16-0.087-0.285-0.219-0.156-0.306c0.721-0.074,1.014-0.103,2.248-0.003c0.553-0.973-6.053-0.255-8.891-0.548
					c-2.816,0.218-9.359,0.028-8.887-0.345c0.791-0.086,1.754-0.051,2.486-0.175c1.08,0.152,2.883,0.417,4.529,0.083
					c0-0.029,0.014-0.069,0.014-0.098c0.012,0,0.023,0,0.035-0.003c1.584,0.049,2.795,0.33,4.406,0.359l0.432-0.167l1.609,0.063
					c0.398-0.046,0.926-0.106,1.33-0.153c0.223,0.026,0.504,0.061,0.725,0.084c1.385,0.175,5.158,0.018,6.441-0.098
					c0.33-0.034,0.33-0.034,4.939,0.584c-0.246,0.054-0.576,0.116-0.824,0.169c1.674,0.304,1.977,0.358,3.182,0.315
					c-0.105-0.052-0.145-0.13-0.076-0.181c0.16,0.003,0.363,0.009,0.523,0.009c-0.154-0.155-0.375-0.192-1.006-0.224
					c-0.131,0.045-0.219,0.12-0.205,0.174c-0.533-0.168-0.859-0.272-2.326-0.385c0.59-0.095,1.381-0.215,1.971-0.31
					c1.002,0.063,1.236,0.092,1.713,0.27c1.953-0.324,3.908-0.369,6.172-0.138c-0.348-0.175-0.348-0.175-2.992-0.646
					c0.092-0.028,0.215-0.063,0.307-0.092c0.768,0.003,1.408,0.098,2.119,0.14l0.443-0.169c0.342,0.069,0.795,0.164,1.145,0.233
					c1.75-0.072,3.361-0.262,5.098-0.348c-0.668-0.377-2.027-0.354-2.418-0.305c-1.154-0.235-1.154-0.256-1.32-0.827
					c-0.787-0.061-0.787-0.061-11.113-0.061c-0.098,0.107-0.098,0.107,0.701,0.417c-0.096,0.023-0.229,0.058-0.32,0.08
					c-0.686-0.012-1.197-0.08-1.664-0.164c0.445,0,0.852-0.055,0.867-0.255c-0.365-0.018-0.848-0.034-1.213-0.052l-0.074,0.23
					c-0.74-0.162-1.395-0.349-2.393-0.42c0.744-0.253,0.744-0.253,0.598-0.371c-0.229-0.188-1.703-0.427-2.48,0.003
					c-0.801-0.284-1.936-0.394-4.855-0.47c-0.18,0.28,0.189,0.367,1.932,0.464c0.072-0.065,0.178-0.16,0.246-0.227
					c1.006,0.311,1.006,0.311,2.891,0.371c-0.213,0.132-0.789,0.221-0.803,0.372c0.215,0.035,0.537,0.061,0.779,0.073
					c-1.309,0.218-3.076-0.124-4.322,0.178c-0.18-0.003-0.418-0.006-0.594-0.01c0.018-0.116,0.348-0.223,0.318-0.338
					c-0.213-0.017-0.5-0.029-0.721-0.04c-0.176,0.37-0.135,0.414,0.273,0.585c-2.582,0.121-3.502,0.081-4.402-0.045
					c0.006-0.053,0.158-0.126,0.33-0.165c0.393,0.032,0.777,0.073,1.189,0.096c-0.084-0.558-2.775-0.483-4.051-0.753
					c0.014-0.058,0.035-0.137,0.061-0.194c2.959-0.053,3.076-0.058,3.535-0.312c-2.385-0.223-2.385-0.223-3.307-0.034
					c-2.93-0.542-4.496-0.375-5.244-0.295c0.873-0.281,2.906-0.311,3.096-0.738c-1.229,0.077-2.502-0.006-3.738,0.043
					c-0.438-0.537-0.438-0.537-0.652-0.6c0.436-0.075,0.436-0.075,7.09-0.118c0.246,0.139,0.246,0.139,2.32,0.531
					c-1.025,0.327-2.48-0.069-3.73-0.008c-0.148,0.26-0.117,0.313,0.301,0.493c1.289-0.215,2.275-0.228,6.281,0.104
					c1.381,0.111,4.246,0.35,4.801-0.232c-2.17,0.074-3.256-0.586-5.559-0.419c-0.078-0.021-0.17-0.05-0.256-0.07
					c0.473-0.143,1.594-0.126,1.693-0.355c3.254,0.518,6.902-0.229,7.066-0.261c-0.219-0.049-1.109-0.184-1.662,0.082
					c-1.229-0.539-4.076-0.034-5.504-0.441c-0.035-0.018-0.084-0.046-0.133-0.063c-0.436,0.097-2.707,0.554-4.574,0.011
					c-3.311,0.431-7.238-0.149-10.523,0.333c0.447,0.29,1.627,0.506,1.725,0.833c-1.055,0.178-7.287,0.327-8.141-0.083
					c-0.199,0.111-0.447,0.261-0.646,0.37c-0.453,0.006-0.453,0.006-1.484-0.247c-3.959,0.161-7.486-0.744-11.592-0.247
					c-0.859-0.272-0.197-0.603-0.602-0.894c0.006,0.003,1.387,0.383,2.125,0.543c0.75-0.187,0.75-0.187,1.496-0.111
					c0.072-0.17,0.072-0.17-0.502-0.486c0.279-0.042,0.725-0.076,1.057-0.086c-1.215-0.212-2.119,0.225-3.305,0.081
					c-0.006-0.058,0.16-0.132,0.322-0.173c0.086-0.006,0.166-0.011,0.484-0.042c0.061-0.038,0.152-0.081,0.213-0.115
					c-0.072-0.04-0.174-0.095-0.25-0.135c-0.635-0.038-0.635-0.038-2.096,0.292c-1.58-0.16-3.547-0.103-4.811-0.445
					c-2.004,0.222-2.924,0.34-4.293,0.532c-3.076-0.167-3.076-0.167-3.781-0.132c-0.129,0.218,0.52,0.613,1.295,0.688
					c0.842-0.092,0.842-0.092,1.18-0.092c0.094,0.026,0.213,0.053,0.307,0.074c-2.328,0.655-5.01,0.288-5.895,0.164
					c-1.197,0.216-1.197,0.216-1.16,1.221c0.977,0.034,1.957,0.069,2.934,0.104c0.662-0.253,1.01-0.244,3.332-0.179
					c-0.426,0.066-0.914,0.104-1.373,0.149c-0.043,0.029-0.1,0.063-0.148,0.089c0.313,0.029,0.313,0.029,2.217,0.364
					c1.357-0.091,1.967-0.2,2.609-0.481c-0.123,0.246-0.123,0.246,2.34,0.848c-1.014,0.123-2.291,0.065-3.229,0.238
					c-1.371-0.225-1.861-0.173-3.514,0c-2.828-0.253-5.826-0.133-8.734-0.201c0.072,0.063,0.178,0.154,0.318,0.218
					c1.438,0.615,4.738,0.195,6.57,0.597c0.207-0.028,0.207-0.028,8.391,0.053c-0.072,0.028-0.166,0.068-0.232,0.1
					c-0.135,0.003-0.313,0.003-0.441,0.003c-0.07-0.022-0.152-0.058-0.211-0.085c-0.949,0.126-0.52,0.286,0.248,0.582
					c-2.1,0.075-4.363-0.123-6.344,0.181c-0.023,0.05-0.047,0.115-0.072,0.161c1.842,0.012,3.191,0.351,5.004,0.379
					c-0.061,0.068-0.061,0.068-2.646,0.371l18.533,0.677l0.023-0.095L1354.134,26.832z M1394.815,24.575
					c-0.625-0.018-0.732,0.184-1.357,0.166c-0.316-0.02-0.34-0.022-0.5-0.103c-0.123-0.063-0.055-0.099,0.01-0.126
					c0.113-0.062,0.146-0.099-0.139-0.201C1394.138,24.346,1394.767,24.391,1394.815,24.575z M1390.825,25.475
					c0.404-0.112,0.711-0.055,0.857-0.016c0.303,0.087,0.379,0.273-0.486,0.244c-0.123-0.003-0.248-0.011-0.367-0.024
					c-0.021,0-0.045-0.007-0.068-0.01C1390.784,25.608,1390.808,25.534,1390.825,25.475z M1388.372,25.472l0.766,0.028l-0.064,0.198
					l-0.768-0.029L1388.372,25.472z M1384.04,25.571c0.023-0.002,0.047-0.002,0.07-0.002c0.52-0.053,0.721-0.213,1.385-0.213
					c0.289,0.235-0.486,0.378-1.148,0.356c-0.113-0.006-0.34-0.018-0.506-0.078c-0.035-0.014-0.072-0.037-0.1-0.055
					C1383.847,25.58,1383.948,25.577,1384.04,25.571z M1380.091,25.437c0.264,0.185-0.377,0.201-0.959,0.182
					c-0.795-0.038-1.02-0.106-1.068-0.124c-0.035-0.018-0.047-0.029-0.047-0.046C1378.583,25.391,1379.126,25.37,1380.091,25.437z
					 M1374.009,25.201c0.459,0.046,0.943,0.092,1.393,0.098c0.648,0.006,1.26-0.049,1.898-0.063c0.092,0.089,0.223,0.206,0.303,0.293
					c-1.479,0.085-1.742,0.097-2.133,0.212c-0.197-0.178-1.143-0.167-1.49-0.308C1373.778,25.351,1373.929,25.259,1374.009,25.201z
					 M1379.519,22.155c0.396-0.112,0.715-0.058,0.867-0.016c0.242,0.069,0.465,0.265-0.484,0.23c-0.129-0.006-0.26-0.012-0.377-0.023
					c-0.023-0.006-0.045-0.008-0.072-0.011C1379.479,22.278,1379.501,22.209,1379.519,22.155z M1359.396,26.35
					c-0.439-0.017-1.771-0.068-2.82-0.255c-0.049-0.009-0.109-0.021-0.152-0.026c0.695,0.018,0.965-0.018,1.271-0.155
					c1.273,0.144,1.68,0.127,2.576,0.08c0.549-0.025,1.131-0.045,2.34,0.013c-0.049,0.092-0.049,0.103,0.092,0.16
					c0.156,0.068,0.475,0.101,0.664,0.16C1361.868,26.39,1360.679,26.394,1359.396,26.35z M1360.899,25.218
					c0.012,0,0.25-0.045,0.195,0.155c0.232,0.042,0.643,0.139,0.678,0.149c-0.219-0.006-0.537-0.054-0.752-0.172
					C1360.899,25.287,1360.858,25.23,1360.899,25.218z M1371.038,25.383c0.064-0.124,0.07-0.142,0.457-0.182
					c0.547-0.052,1.123-0.006,1.678-0.028c-0.068,0.187-0.068,0.187-0.141,0.47c-0.586,0.081-1.057,0.096-2.027,0.064
					c-1.191-0.049-2.314-0.167-3.525-0.201c-0.846-0.026-1.227,0.028-1.434,0.058c-0.113-0.087-0.254-0.207-0.371-0.293l-0.078,0.275
					c-0.627-0.012-1.789-0.077-2.549-0.391c-0.061-0.023-0.121-0.058-0.18-0.086c1.805,0.058,3.607-0.069,5.412,0
					C1369.694,25.124,1370.501,25.278,1371.038,25.383z M1365.155,24.38c0.213,0.065,0.502,0.149,0.715,0.215
					c-0.094,0.038-0.256,0.078-0.537,0.072c-0.348-0.018-0.52-0.092-0.566-0.114C1364.702,24.521,1364.532,24.408,1365.155,24.38z
					 M1362.497,23.427c0.479-0.032,1.01-0.066,1.779-0.074c1.109-0.013,2.031,0.068,2.332,0.097c0.48,0.043,0.48,0.043,0.65,0.034
					c0.326-0.016,0.504-0.097,0.844-0.111c0.037,0,0.082-0.003,0.125,0c0.275,0.015,0.523,0.089,0.523,0.096
					c0.088,0.079-0.066,0.199-0.094,0.286c-0.697,0.075-2.551,0.229-4.861,0.157c-0.264-0.008-0.803-0.031-1.258-0.095
					c-0.045-0.005-0.1-0.011-0.154-0.02C1362.421,23.686,1362.47,23.538,1362.497,23.427z M1360.063,22.425
					c0.377,0,0.791,0.014,1.025,0.037c0.848,0.086,1.074,0.246,1.166,0.477c-0.518-0.065-0.953-0.102-2.002-0.117
					c-1.852-0.032-2.289-0.038-2.643-0.213c-0.094-0.049-0.141-0.099-0.184-0.146C1358.306,22.456,1359.179,22.425,1360.063,22.425z
					 M1359.841,25.437c-0.914,0.152-1.713,0.195-2.84,0.158c-0.297-0.015-0.75-0.031-1.506-0.118c-0.066-0.008-0.146-0.018-0.213-0.022
					c0.029-0.118,0.078-0.271,0.102-0.385C1356.423,25.017,1359.409,25.012,1359.841,25.437z M1353.138,23.357
					c0.582-0.146,2.15,0,2.26,0.271c-0.406,0.063-0.848,0.074-1.902,0.037c-0.168-0.009-0.34-0.014-0.516-0.021
					c-0.02,0-0.049-0.003-0.07-0.003C1352.872,23.57,1352.813,23.441,1353.138,23.357z M1329.534,22.105l-0.803-0.215
					c0.457,0.014,0.848-0.083,1.326-0.047C1329.897,21.922,1329.69,22.03,1329.534,22.105z M1335.397,22.536
					c-0.09-0.006-0.291-0.017-0.408-0.063c-0.049-0.022-0.066-0.042-0.08-0.065c0.264,0,0.35-0.026,0.516-0.089
					c0.342-0.139,0.768-0.066,0.768-0.066C1336.388,22.295,1336.427,22.563,1335.397,22.536z M1337.653,22.373
					c-0.098-0.055-0.166-0.112-0.201-0.17c1.215,0.008,1.764,0.115,2.063,0.17c-0.141,0.083-0.328,0.194-0.469,0.278
					C1338.562,22.611,1337.972,22.536,1337.653,22.373z M1339.288,24.771c0.227,0.092,0.533,0.218,0.771,0.307l-1.668,0.127
					C1338.384,24.928,1338.433,24.762,1339.288,24.771z M1339.128,26.189c-0.051-0.003-0.107-0.003-0.164-0.007c-0.016,0-0.02,0-0.025,0
					c-0.059-0.074-0.119-0.146-0.018-0.224c0.453-0.338,3.555-0.206,4.221,0.098C1341.774,26.057,1340.528,26.234,1339.128,26.189z
					 M1348.251,22.505c-0.012,0.083-0.047,0.198-0.07,0.278l-0.85-0.028l-0.4-0.204C1347.392,22.564,1347.78,22.47,1348.251,22.505z
					 M1345.14,22.434c0.131,0.165,0.061,0.235-0.721,0.212c-0.033-0.014-0.08-0.034-0.104-0.047c-0.318-0.154-0.258-0.298-0.166-0.43
					c0.365,0.04,0.848,0.097,1.215,0.138C1345.103,22.301,1345.058,22.329,1345.14,22.434z M1347.661,26.224l-0.836-0.034l0.047-0.181
					l0.838,0.031L1347.661,26.224z M1348.294,25.287c-0.785-0.028-1.254-0.046-1.48-0.149c-0.154-0.068-0.098-0.149-0.061-0.187
					C1348.522,24.963,1348.351,25.207,1348.294,25.287z M1351.13,26.148c-0.086-0.006-0.287-0.014-0.521-0.101
					c-0.012-0.002-0.029-0.008-0.035-0.011c0.654-0.089,0.895-0.061,0.984-0.038C1351.739,26.051,1351.497,26.158,1351.13,26.148z"/>
				<path d="M1.53,28.429c2.511,0.271,8.667,0.882,11.613,0.732c0.309,0.055,0.72,0.12,1.028,0.175
					c0.318-0.037,0.745-0.083,1.07-0.117c-3.111-1.346-10.441-0.965-15.186-1.639v1.341c0.131,0.024,0.26,0.048,0.404,0.074
					C0.68,28.816,1.122,28.587,1.53,28.429z"/>
				<path d="M128.758,28.503c-9.171-0.668-9.171-0.668-9.201-0.814c0.73-0.075,3.531-0.275,8.882,0.301
					c-0.53-0.348-1.238-0.813-1.77-1.163c-2.145-0.011-3.979-0.528-6.336-0.191c-1.101-0.096-2.033-0.265-3.058-0.388
					c-0.235,0.014-0.543,0.028-0.767,0.042c-0.978-0.172-2.227-0.229-3.257-0.382c-0.037-0.058-0.078-0.135-0.114-0.194
					c0.461-0.058,1.167-0.092,1.686-0.104c-0.053-0.011-5.182-0.996-5.918-1.645c0.413,0.065,1.098,0.117,1.592,0.109
					c0.112-0.044,0.272-0.107,0.384-0.152c0.336,0.092,0.784,0.215,1.114,0.307c2.486-0.055,4.873-0.33,7.462-0.167
					c-1.445-0.708-1.445-0.708-1.598-0.97c3.19-0.112,4.845-0.068,6.271,0.78c-0.843-0.634-1.963-1.478-2.8-2.11
					c-6-0.178-6-0.178-10.78-0.764c-0.194,0.037-0.466,0.087-0.66,0.121c-1.296-0.149-2.923-0.029-4.114-0.265
					c0.053-0.112,0.418-0.262,0.784-0.345c-0.059-0.071-0.137-0.166-0.201-0.241c2.158,0.023,2.357,0.046,3.208,0.138
					c0.199-0.049,0.471-0.114,0.66-0.167c0.224,0.023,0.529,0.055,0.753,0.081c-0.234-0.195-0.847-0.348-1.012-0.545
					c1.473-0.018,1.473-0.018,2.711-0.133c0.211,0.028,0.507,0.058,0.73,0.08c0.047-0.052,0.112-0.12,0.152-0.172
					c-2.935-0.833-2.935-0.867-2.905-1.258c1.262,0,4.633,0.068,8.707,0.718c-0.29-0.304-0.672-0.712-0.962-1.02
					c-5.44,0.342-6.467-0.318-8.187-1.412c0.166-0.049,0.378-0.115,0.536-0.164c-0.04-0.058-0.099-0.135-0.146-0.192
					c2.329,0.015,5.457,0.296,5.476,0.302c1.779,0.398,0.712,1.034,2.305,1.449c-0.697-0.697-1.627-1.627-2.329-2.328
					c-0.082,0.063-0.188,0.144-0.271,0.201c-7.468,0.018-27.177-1.536-27.336-1.554c-0.165,0.046-0.383,0.104-0.547,0.146
					c-5.347-0.453-11.041-0.592-16.462-0.971c-0.49-0.015-1.162,0.006-1.627,0.04c0.536,0.149,0.536,0.149,7.927,0.944
					c0.059-0.054,0.141-0.129,0.207-0.181c0.76,0.242,0.667,0.563,1.386,0.811c0.199-0.028,0.459-0.069,0.659-0.102
					c-0.036-0.117-0.294-0.267-0.594-0.358c0.146-0.061,0.354-0.141,0.5-0.201c4.645,0.563,8.629,1.338,12.96,2.001
					c-0.205,0.058-0.488,0.13-0.694,0.185c-4.444,0.072-8.411-0.457-12.749-0.52c0.895,0.444,2.475,0.78,3.678,1.184
					c-0.207,0.052-0.485,0.12-0.685,0.172c-0.837-0.018-1.661-0.063-2.511-0.055c2.907,0.83,2.907,0.83,1.427,1.111
					c-3.253-0.092-5.583-0.956-9.402-0.586c-0.112-0.129-0.087-0.315,0.07-0.442c0.208,0.038,0.484,0.083,0.691,0.118
					c-1.168-1.014-12.089-0.835-12.19-0.83c0.207,0.108,0.573,0.247,0.884,0.339c-0.012,0.005-2.54,0.264-9.428-0.179
					c-1.105,0.149-11.325-0.631-11.538-1.039c2.457-0.017,4.462,0.373,6.891,0.379c0.153-0.04,0.365-0.097,0.519-0.141
					c2.334,0.009,4.38,0.45,6.873,0.229c-0.377-0.221-0.725-0.295-1.928-0.28c-6.489-0.79-6.489-0.79-13.741-0.715
					c-4.79,0.051-7.515-0.925-11.65-1.199c-0.475-0.031-1.096,0.078-1.544,0.125c0.267,0.143,0.618,0.33,0.877,0.473
					c4.026,0.324,5.096,0.437,10.232,0.969c-0.065,0.138-0.362,0.327-0.774,0.43c3.678,1.212,10.343,0.73,15.047,1.361
					c-0.083-0.086-0.188-0.195-0.271-0.28c5.354,0.637,11.591,0.537,17.114,1.035c0.112-0.051,0.252-0.117,0.36-0.168
					c1.801-0.007,2.993,0.034,6.447,0.27c9.856,0.674,9.856,0.674,9.973,0.646c0.207,0.092,0.672,0.192,1.078,0.235
					c0.055-0.06,0.125-0.141,0.172-0.204c5.533,0.587,11.764,0.718,17.169,1.376c0.146,0.093,0.347,0.213,0.488,0.305
					c0.448-0.031,1.091-0.049,1.556-0.031c-0.124,0.061-0.283,0.143-0.412,0.203l-10.609-0.399c-0.359-0.074-0.944-0.149-1.403-0.184
					c-0.129,0.053-0.289,0.127-0.412,0.184c-0.061-0.011-6.731-0.919-8.794-0.396c-0.838-0.086-0.838-0.086-2.547-0.106
					c0.478,0.353,0.478,0.371,0.483,0.666c1.308,0.198,3.416,0.198,5.204,0.267l-0.217-0.224l-0.093,0.092
					c-0.154-0.126-0.202-0.206,0.021-0.246c0.108-0.018,0.307-0.016,0.615,0.005c0.159,0.012,0.448,0.026,0.628,0.017
					c0.114,0.093,0.308,0.271,0.138,0.354c-0.094,0.044-0.254,0.041-0.416,0.038c1.518,0.08,2.679,0.244,2.621,0.695
					c-3.773-0.058-5.854,0.218-5.878,0.223c0.249,0.007,0.573,0.018,0.82,0.023c-0.07,0.063-0.175,0.146-0.258,0.207
					c-0.501,0.006-1.179-0.003-1.686-0.023c-0.19,0.038-0.438,0.087-0.632,0.127c0.135,0.057,0.319,0.132,0.454,0.189
					c1.699,0.029,3.16,0.235,4.763,0.333c0.201-0.034,0.472-0.081,0.672-0.115c0.308,0.018,0.308,0.018,3.361,0.396
					c0.371,0,0.371,0,2.415,0.195c0.579-0.098,0.579-0.098,11.895,1.326c0.178,0.112,0.414,0.265,0.588,0.38
					c-0.181,0.052-0.429,0.12-0.612,0.167l-9.779-0.773c-3.66,0.434-5.581-0.479-8.563-0.571c-0.26-0.091-0.607-0.212-0.867-0.304
					c-5.097,0.947-10.026-0.442-15.083-0.058c0.884,0.25,1.226,0.241,2.133,0.213c2.029,0.367,6.496,0.017,6.754,0.835
					c-0.075,0.009-8.178,0.161-9.052-0.474c-0.129,0.058-0.305,0.126-0.435,0.178c-1.981-0.253-1.675-0.58-1.568-0.688
					c0.53-0.01,1.238-0.023,1.769-0.047c-1.203-0.465-3.925-0.646-4.504-1.229c-0.365,0.063-0.778,0.175-0.978,0.27
					c-3.261-0.27-6.655-0.031-9.95-0.141c-3.545-0.118-6.831-0.451-10.308-0.623c-0.189,0.04-0.445,0.086-0.634,0.127
					c0.797,0.367,3.032,0.304,3.891,0.654c-1.894,0.221-15.181-0.448-16.315-0.953c-3.381,0.305-6.284-0.546-9.683-0.207
					c-0.424-0.063-0.951-0.17-1.255-0.264c-2.657-0.044-3.856-0.461-5.083-0.87c0.099,0.008,0.186,0.008,0.284,0
					c0.165-0.01,0.32-0.021,0.486-0.01c-0.251-0.177-0.761-0.31-1.111-0.347c-0.36-0.026-0.311,0.089-0.237,0.17
					c-0.533-0.167-1.107-0.322-1.837-0.438l-0.695-0.063c-0.184,0.04-0.423,0.086-0.599,0.126c-0.227-0.018-0.528-0.034-0.755-0.052
					c0.503,0.361,2.693,0.448,2.735,0.879c-1.543-0.267-1.543-0.267-4.322-0.426c-0.119-0.103-0.075-0.252,0.104-0.35
					c0.228,0.02,0.525,0.049,0.751,0.068c0.18-0.034,0.418-0.08,0.596-0.117c-0.138-0.103-0.59-0.228-1.011-0.284
					c-1.725,0.114-3.032-0.204-4.63-0.227c0.649,0.232,1.842,0.33,2.587,0.537c-0.043,0.063-0.1,0.151-0.144,0.218
					c-2.959-0.026-4.9-0.402-5.95-0.605c0.049-0.061,0.11-0.147,0.165-0.21c0.212,0.026,0.498,0.063,0.712,0.086
					c0.154-0.041,0.366-0.095,0.523-0.138c-0.76-0.393-2.71-0.473-4.093-0.702v0.495C0.49,18.869,1.078,18.97,1.6,19.013
					c-0.03,0.055-0.066,0.13-0.089,0.188c-0.49-0.041-0.968-0.088-1.455-0.13v3.435c0.16,0.011,0.326,0.015,0.478,0.031
					c0.216-0.02,0.501-0.051,0.717-0.071c-0.013-0.121-0.274-0.285-0.613-0.377c0.094-0.051,0.216-0.117,0.309-0.166
					c2.86,0.218,5.488,0.598,8.597,0.638c0.118,0.052,0.277,0.12,0.401,0.172c1.058-0.092,5.938,0.046,5.355,0.862
					c-0.213,0.025-0.505,0.058-0.721,0.073l-0.918-0.172c-0.945-0.292-2.587-0.396-3.601-0.666c0.012,0.068,0.034,0.164,0.05,0.235
					c-0.245-0.014-0.568-0.034-0.814-0.046c-0.037,0.117,0.17,0.284,0.456,0.385c0.253-0.011,0.588-0.029,0.84-0.043
					c0.177,0.058,0.41,0.129,0.583,0.187c0.969,0.006,0.969,0.006,3.083,0.27l-0.082-0.184c0.153,0.04,0.362,0.098,0.516,0.136
					c4.086-0.416,6.499,0.864,10.499,0.528c1.109,0.209,1.551,0.144,2.428,0.009c-2.093-0.213-3.288-0.67-5.161-0.942
					c-0.127-0.139-0.278-0.322-0.364-0.466c0.181-0.042,0.419-0.103,0.602-0.149c0.201,0.035,0.47,0.087,0.669,0.121
					c0.243-0.009,0.57-0.02,0.807-0.028c0.197,0.035,0.448,0.08,0.642,0.111c0.076-0.06,0.172-0.14,0.251-0.204
					c0.237-0.011,0.553-0.028,0.785-0.04c1.532,0.498,5.016,0.566,5.531,1.287c-1.048-0.081-2.086-0.181-3.173-0.241
					c-0.207,0.031-0.484,0.075-0.683,0.106c2.743,0.321,2.969,0.347,4.189,0.844c2.582,0.063,4.81,0.537,7.624,0.336
					c-0.952-0.089-0.972-0.092-1.282-0.414c10.973,0.896,23.065,0.689,33.862,1.761c2.723-0.375,11.222,0.531,12.083,0.942
					c-0.618,0.262-1.32,0.554-17.881-0.701L55.129,26.24c0.107,0.052,0.236,0.12,0.336,0.173c6.647,0.204,6.647,0.204,15.331,1.148
					c-0.142,0.04-0.332,0.101-0.472,0.145c-0.277-0.007-0.649-0.021-0.921-0.026c-0.854-0.262-8.263-0.411-8.817-0.348
					c-0.011,0.058-0.034,0.126-0.046,0.181c-0.479,0.021-1.157,0.014-1.628-0.011c-0.023-0.055-0.058-0.128-0.082-0.182
					c-0.236-0.012-0.542-0.031-0.78-0.046c-0.07,0.058-0.15,0.132-0.211,0.189c-0.482-0.022-1.143-0.043-1.632-0.051
					c11.841,0.61,27.626,1.423,39.473,2.029c0.4-0.098,0.896-0.238,1.219-0.348c-0.96-0.293-1.078-0.321-2.952-0.657
					c-0.136,0.058-0.306,0.136-0.446,0.195c-0.602,0.003-1.41,0.025-2.004,0.049c-1.108-1.155-1.108-1.155-1.48-1.247
					c2.889-1.274,13.544,0.222,14.311,0.435c-0.065,0.058-0.146,0.136-0.201,0.198c7.204,0.747,8.47,0.614,9.578,0.499
					c-0.111-0.108-0.028-0.27,0.154-0.376c0.022,0,6.565,0.376,15.56,0.709C129.218,28.778,128.958,28.621,128.758,28.503z
					 M113.751,23.027c0.248,0.197,0.165,0.284-0.271,0.272c-0.07-0.005-0.142-0.018-0.218-0.022c-0.016,0-0.028-0.003-0.04-0.006
					C112.72,22.962,113.174,22.989,113.751,23.027z M37.961,15.958c-0.034-0.003-0.113-0.012-0.224-0.075
					c-0.037-0.022-0.132-0.077-0.079-0.106h0.008c0.081-0.018,0.246,0.023,0.516,0.118C38.106,15.942,38.045,15.96,37.961,15.958z
					 M39.633,16.063c-0.088-0.006-0.115-0.022-0.148-0.04c-0.081-0.045-0.119-0.103-0.086-0.126c0.019-0.023,0.097-0.018,0.211,0.023
					C40.031,16.063,39.639,16.063,39.633,16.063z M71.021,17.867l-0.461-0.29l0.56,0.025L71.021,17.867z M98.857,17.012
					c-0.607-0.035-0.973-0.161-1.526-0.219c-0.024,0-0.061-0.005-0.083-0.005c0-0.013,0.011-0.026,0.022-0.034
					c0.207-0.168,1.458-0.073,2.111,0.218C99.206,17.012,99.099,17.021,98.857,17.012z M98.192,16.558
					c-1.08-0.065-1.893-0.259-2.984-0.319c0.201,0.199,0.909,0.366,0.743,0.589c-0.411-0.018-0.813-0.034-1.219-0.055
					c-0.277-0.232-0.277-0.267-0.052-0.413c0.117-0.074,0.1-0.111,0.046-0.221c-0.224,0-0.389-0.034-0.402-0.034
					c-0.766-0.196-0.807-0.492-1.72-0.673c-0.312-0.061-0.826-0.028-1.072-0.115c-0.148-0.051-0.177-0.108-0.224-0.166
					c2.169-0.097,3.365-0.151,5.353-0.005c1.278,0.097,1.278,0.097,1.532,0.258c0.199,0.127,0.283,0.148,0.482,0.155
					c0.349-0.144,1.02-0.007,1.522-0.032c0.388,0.13,0.471,0.158,1.071,0.245c1.216,0.184,1.297,0.258,1.569,0.517
					C101.09,16.201,99.959,16.667,98.192,16.558z M84.877,20.722c-0.349-0.018-0.59-0.075-0.727-0.115
					c-0.022-0.006-0.034-0.012-0.047-0.015c0,0-0.217-0.175,0.025-0.226c0.17-0.035,0.252-0.029,1.019,0.005
					C85.694,20.722,85.142,20.733,84.877,20.722z M88.997,21.003c-0.025,0-0.042,0-0.061-0.003c-0.059-0.068-0.2-0.215-0.141-0.296
					c0.06-0.08,0.284-0.052,0.448,0C89.593,20.808,89.856,21.032,88.997,21.003z M86.491,22.237c-0.465-0.028-0.742-0.132-0.867-0.191
					c-0.087-0.038-0.141-0.081-0.188-0.124c0.577,0.009,0.979,0.055,1.262,0.144C87.305,22.255,86.499,22.237,86.491,22.237z
					 M90.417,21.537c-0.008-0.003-0.012-0.006-0.017-0.006c-0.061-0.038-0.089-0.075-0.106-0.109c0.112,0.006,0.254,0.012,0.365,0.014
					l0.412,0.193C90.776,21.618,90.563,21.611,90.417,21.537z M92.021,21.768c-0.324-0.021-0.666-0.115-0.837-0.196
					c-0.006-0.006-0.019-0.011-0.03-0.018c0.165,0.012,0.235,0.018,0.33-0.005c0.013,0,0.024-0.003,0.035-0.006
					c0.165-0.058,0.307-0.104,0.52-0.043C92.049,21.503,92.521,21.778,92.021,21.768z M93.158,21.83
					c-0.425-0.021-0.602-0.078-0.713-0.127c-0.006-0.006-0.017-0.009-0.03-0.011c0.202,0.022,0.461,0.04,0.744-0.053
					c0.146-0.045,0.3-0.086,0.507-0.034C94.62,21.864,93.169,21.833,93.158,21.83z M105.181,16.756c-0.03-0.002-0.059-0.009-0.082-0.012
					c0.423-0.144,1.773-0.123,2.775,0.207C106.986,16.88,106.02,16.862,105.181,16.756z M104.816,22.56
					c-0.047-0.023-0.07-0.043-0.095-0.066c0.306,0.034,0.708,0.084,1.014,0.118C105.43,22.594,105.022,22.651,104.816,22.56z
					 M106.136,22.727l-0.181-0.184l0.405,0.017l0.188,0.184L106.136,22.727z M9.391,19.607c0.112-0.055,0.395,0.025,0.672,0.189
					c0.01,0.006,0.015,0.012,0.026,0.018c0.092,0.057,0.162,0.117,0.224,0.178c-0.388-0.034-0.564-0.052-0.755-0.167
					C9.447,19.762,9.287,19.653,9.391,19.607z M10.812,21.658c-0.156-0.019-0.579-0.063-1.094-0.356
					c-0.263-0.149-0.263-0.149-0.328-0.345c0.194,0.052,0.431,0.091,0.676,0.127c0.343,0.045,0.733,0.103,1.065,0.267
					c0.221,0.105,0.351,0.232,0.354,0.232C11.485,21.583,11.3,21.697,10.812,21.658z M11.852,21.347
					c0.106,0.104,0.106,0.104,0.913,0.518c-0.092,0.017-0.211,0.04-0.306,0.063c-0.106-0.139-0.215-0.187-0.458-0.253
					c-0.114-0.032-0.208-0.066-0.28-0.104c-0.084-0.052-0.132-0.109-0.172-0.16C11.636,21.394,11.758,21.364,11.852,21.347z
					 M12.577,22.301c-0.244,0.009-0.496,0.018-0.742-0.074c-0.014-0.003-0.039-0.012-0.044-0.018c-0.013,0-0.315-0.315-0.151-0.35
					c0.042-0.013,0.141,0.005,0.144,0.005c0.187,0.138,0.326,0.189,0.601,0.218c0.221,0.019,0.491-0.017,0.672,0.035
					c0.169,0.046,0.198,0.138,0.218,0.227C13.13,22.289,12.953,22.292,12.577,22.301z M13.573,22.24
					c-0.16-0.083-0.086-0.114-0.056-0.129c0.159,0.126,0.683,0.201,0.851,0.33C13.924,22.398,13.682,22.298,13.573,22.24z
					 M37.261,24.751l-0.214-0.198l0.312,0.022l0.214,0.198L37.261,24.751z M60.97,23.427c-0.778-0.023-1.421-0.139-2.181-0.166
					c-0.317-0.013-0.336-0.013-0.514,0.057c-0.164,0.063-0.199,0.063-0.364,0.069c-0.452,0.023-0.329-0.139-0.76-0.139
					c-0.425,0-0.229,0.158-0.66,0.149c-0.961-0.034-1.409-0.249-2.265-0.321c-0.6-0.046-1.208,0.022-1.812-0.012
					c-0.667-0.034-0.875-0.204-1.471-0.259c-0.318-0.031-0.677,0.003-0.99-0.034c-0.041-0.005-0.088-0.011-0.127-0.017
					c0,0-0.188-0.031-0.353-0.109c-0.015-0.006-0.688-0.354-0.089-0.367c0.016,0,2.208,0.011,2.505,0.026
					c0.991,0.048,1.863,0.174,2.849,0.231c5.795,0.319,6.272,0.345,7.257,0.813C61.712,23.415,61.494,23.438,60.97,23.427z
					 M72.386,25.069c-0.017-0.02-0.036-0.037-0.046-0.056c-0.095-0.123-0.036-0.151,0.212-0.108c0.034,0.08,0.082,0.187,0.116,0.271
					L72.386,25.069z M80.863,25.695c-0.202,0.114-0.55,0.164-1.097,0.154c-1.279-0.021-2.251-0.221-3.419-0.313
					c-0.423-0.031-0.565-0.043-1.072,0.014c-0.205,0.023-0.389,0.047-0.589,0.034c-0.013,0-0.036,0-0.048,0
					c-0.211-0.016-0.388-0.068-0.388-0.068c-0.331-0.103-0.532-0.224-0.862-0.333c-0.034-0.011-0.093-0.028-0.118-0.046
					c-0.306-0.121-0.27-0.146-0.235-0.166c0.159-0.115,0.955,0.095,1.467,0.299c0.047-0.109,0.159-0.139,0.484-0.127
					c0.536,0.018,0.93,0.121,1.48,0.135c0.971,0.029,1.962-0.02,2.941,0.029c0.82,0.037,1.319,0.135,1.615,0.192
					C80.992,25.558,80.958,25.638,80.863,25.695z M72.481,27.788c-0.152,0.095-0.837-0.026-1.226-0.218
					c-0.112-0.055-0.188-0.112-0.241-0.17c0.525,0.003,0.677,0.133,1.114,0.167c0.087,0.006,0.171,0.009,0.259,0
					C72.445,27.619,72.574,27.73,72.481,27.788z M73.595,27.814c-0.136-0.009-0.266-0.017-0.395-0.021
					c-0.024-0.003-0.036-0.003-0.059-0.003c-0.4-0.296-0.024-0.289,0.547-0.249C74.119,27.798,73.977,27.832,73.595,27.814z
					 M79.466,28.176c-0.69-0.011-4.156-0.086-4.933-0.35c-0.142-0.046-0.271-0.115-0.366-0.167c0.649-0.015,1.221-0.138,1.934-0.081
					c0.824,0.063,1.06,0.273,1.803,0.362l0.518-0.16c0.884-0.006,3.878,0.018,5.222,0.61C82.501,28.285,81.406,28.217,79.466,28.176z
					 M83.739,28.319l-0.218-0.194l0.372,0.017l0.224,0.195L83.739,28.319z M84.658,28.334c-0.129-0.052-0.17-0.124-0.199-0.164
					c0.542,0.047,0.784,0.139,0.972,0.23C84.74,28.362,84.74,28.362,84.658,28.334z M88.785,27.384c0.011-0.006,0.022-0.015,0.047-0.023
					c0.118-0.055,0.507-0.068,0.837,0.155L88.785,27.384z M101.157,25.772c-0.786-0.243-2.458-0.198-3.119-0.485
					c-0.224-0.098-0.289-0.203-0.331-0.287c0.459,0.095,0.843,0.092,1.675,0.081c1.391-0.018,1.992,0.061,2.592,0.557
					C101.504,25.611,101.479,25.741,101.157,25.772z M108.417,22.771c-0.148,0.146-1.149-0.011-1.563-0.178
					c-0.083-0.034-0.142-0.074-0.177-0.115c0.395-0.034,0.413-0.034,1.173,0.222l0.537-0.058
					C108.423,22.686,108.463,22.727,108.417,22.771z M109.638,22.692c0.082,0.082,0.188,0.194,0.283,0.277
					c-0.082-0.003-0.154,0.009-0.224,0.009c-0.129-0.009-0.378-0.023-0.638-0.138c-0.07-0.032-0.123-0.063-0.169-0.098
					C109.143,22.731,109.313,22.651,109.638,22.692z M112.52,25.876l-0.418-0.014l-0.024-0.013c-0.224-0.108-0.142-0.16-0.004-0.175
					C112.083,25.675,112.88,25.66,112.52,25.876z M118.762,27.835c-0.036-0.009-0.059-0.021-0.089-0.034
					c-0.171-0.073-0.277-0.179-0.248-0.248c0.048-0.105,0.353-0.077,0.359-0.077C118.796,27.479,119.328,27.822,118.762,27.835z"/>
				<path d="M73.801,15.625c-1.103-0.095-2.163,0.097-3.265,0.02c-1.126-0.083-1.746-0.402-3.165-0.35
					c-0.408-0.167-0.697-0.351-1.168-0.506c-0.848-0.028-0.966-0.012-1.309,0.105c-0.849-0.14-2.133-0.347-5.788-0.479
					c-2.069-0.079-2.069-0.079-4.954-1.194c-0.182,0.351-0.182,0.351-0.423,0.432c-2.203-0.075-4.243-0.282-6.376-0.408
					c-1.882-0.112-3.568,0.201-5.43,0.132c-1.351-0.052-2.505-0.224-3.813-0.293c-0.132,0.037-0.289,0.093-0.384,0.138
					c-0.25-0.068-0.577-0.158-0.825-0.224c-0.755,0-1.19,0.25-2.09,0.138c-0.955-0.121-0.415-0.401-1.179-0.546
					c0.117,0.069,0.234,0.145,0.349,0.215c-0.076,0.21-1.293,0.233-1.43,0.435c-1.729-0.368-6.777,0.034-6.118-0.675
					c0.107-0.015,0.248-0.029,0.353-0.04c-0.229-0.354-5.23-0.689-5.282-0.692c0-0.022-0.004-0.055-0.01-0.08
					c0.186-0.023,0.483-0.029,0.688-0.021c0.008-0.003,0.008-0.009,0.064-0.031c-0.237-0.229-0.982-0.407-1.276-0.627
					c3.191-0.063,6.224,0.23,9.401,0.213c0.795,0.235,1.51,0.354,2.738,0.445c2.076,0.158,4.415-0.058,6.398,0.232
					c1.91,0.275,1.91,0.275,6.048,0.472c2.744,0.643,7.18,0.278,10.016,0.867c2.511-0.368,4.326,0.591,6.849,0.178
					c2.192,0.993,2.287,1.034,3.884,0.799c0.043-0.053,0.053-0.13-0.018-0.185c-0.099,0.006-0.228,0.012-0.33,0.018
					c0.03-0.023,0.066-0.052,0.095-0.074c-0.095-0.013-0.216-0.029-0.312-0.041c-0.007,0.021-0.019,0.052-0.019,0.075
					c-0.095,0.008-0.224,0.017-0.323,0.025c-0.136-0.095-0.33-0.221-0.478-0.318c0.283,0.005,0.648,0.011,0.924,0.014
					c0.16-0.048,0.343-0.118,0.442-0.169c0.16,0.04,0.389,0.092,0.589,0.121c1.281-0.107,1.281-0.107,1.722-0.035
					c-0.577-0.512-1.838-0.353-2.216-0.29c-0.024-0.008-4.62-1.021-5.163-1.094c0.26-0.118,0.384-0.241,0.555-0.365
					c0.124-0.014,0.294-0.037,0.43-0.052c1.136,0.115,1.149,0.509,2.622,0.543c1.498-0.299,1.498-0.299-3.719-1.421L60.77,11.01
					l-0.176-0.197c-0.083,0.024-0.196,0.054-0.279,0.079c-2.062-0.428-5.108-0.577-6.515-1.186c-0.82,0.109-1.259-0.127-1.968-0.108
					c-0.036,0.259,1.211,0.474,0.526,0.757c-0.424,0.173-0.583,0.162-2.501,0.053c0.022,0.166,0.134,0.206,1.083,0.367
					c1.449,0.253,3.417,1.681,3.42,1.694c-0.07,0.011-0.17,0.034-0.24,0.052L35.51,11.441c-0.704-0.05-0.85-0.21-1.271-0.319
					c-0.071,0.021-0.167,0.042-0.233,0.063c-0.385-0.021-1.23-0.154-1.238-0.157c0.033-0.023,0.081-0.055,0.119-0.075
					c0.655-0.074,1.199,0.031,1.796,0.058c0.072-0.017,0.164-0.046,0.229-0.063c0.002-0.218,0.002-0.218-4.083-1.094
					c-0.324-0.069-0.324-0.069-1.396-1.014c-0.238-0.015-0.566-0.035-0.806-0.052c-0.639-0.293-1.87-0.471-2.698-0.724
					c-0.445,0.12-0.266,0.276-0.399,0.413c-1.731,0.007-3.073-0.364-4.903-0.258c0.795,0.42,3.201,0.588,3.382,1.105
					c-1.263,0.115-2.331-0.095-3.521-0.112c0.85,0.546,1.387,0.741,2.283,0.833c1.456,0.155,2.063-0.253,3.29-0.253
					c-0.053-0.046-0.145-0.108-0.231-0.149c-0.196-0.014-0.466-0.029-0.676-0.034c-0.333-0.155-0.328-0.173-0.238-0.293
					c1.42-0.203,1.762-0.083,2.672,0.229c0.195,0,0.459-0.025,0.607-0.052c0.101,0.007,0.229,0.021,0.327,0.029
					c0.482,0.355,2.22,0.488,2.817,0.821c-0.481,0.04-0.996,0.006-1.476,0.04c-0.104,0.06-0.116,0.149-0.101,0.215
					c0.804,0.118,1.621,0.232,2.411,0.354c-1.677,0.184-3.166,0.126-6.926-0.258c-1.025-0.109-2.587-0.267-4.07-0.348
					c-0.977-0.052-1.993,0.095-2.964-0.026c-2.479-0.31-2.861-0.358-3.819-0.209c0.462,0.232,0.462,0.232,2.363,0.64
					c-0.454,0.299-1.299,0.855-5.52,0.471C9.776,11.09,9.776,11.09,6.01,9.772c0.092-0.023,0.209-0.055,0.3-0.075
					C7.21,9.694,8.022,9.919,8.983,9.746C8.362,9.04,11.341,7.942,7.051,7.622c-0.075,0.017-0.18,0.034-0.255,0.051
					C5.804,7.145,5.8,6.553,4.745,6.03c-0.9-0.451-0.9-0.451-2.6-0.677C1.74,5.324,1.74,5.324,1.144,5.39
					c0.456,0.325,0.456,0.325,0.352,0.417c-0.224,0.006-0.53,0-0.751-0.006C0.664,5.815,0.558,5.835,0.478,5.852
					c0.553,0.331,3.484,0.478,2.36,0.896c-0.224-0.006-0.521-0.02-0.743-0.031c0.546,0.284,0.923,0.46,2.309,0.79
					C4.853,7.615,6.181,8.374,5.74,8.54c-0.207,0.006-0.498,0-0.688-0.02C5.285,8.804,6.42,9,6.564,9.293
					C6.466,9.315,6.347,9.344,6.255,9.361C5.332,9.169,5.332,9.169,5.023,9.144C2.772,8.973,1.173,8.852,0,8.766v0.327
					c1.702,0.234,1.776,0.226,2.25,0.159C2.35,9.29,2.46,9.344,2.574,9.378c0.688,0.207,2.045,0.127,2.738,0.334
					c0.802,0.235,0.313,0.56,1.112,0.792c0.012,0.006,1.165,0.42,0.871,0.649c-0.42,0.043-0.898,0.006-1.331,0.034
					c-0.047,0.026-0.11,0.063-0.16,0.086c1.286,0.262,2.585,0.457,5.102,0.621c-0.237-0.213-0.237-0.213-0.1-0.351
					c0.454,0.301,0.454,0.301,0.689,0.385c0.021-0.184-0.182-0.364-0.257-0.548c1.038,0.191,2.511,0.191,3.499,0.404
					c0.599,0.133,0.308,0.31,0.496,0.463c12.257,1.079,12.257,1.079,12.558,0.943c7.137,0.874,11.413,1.017,16.825,1.202
					c3.441,0.113,17.158,1.064,17.241,1.072c1.107,0.104,2.044,0.285,3.229,0.354c1.219,0.072,2.31-0.123,3.506-0.089
					c1.74,0.052,3.213,0.304,4.982,0.33c0.931,0.015,1.295-0.02,1.91-0.08C75.104,15.857,74.585,15.69,73.801,15.625z M57.653,12.395
					c0.7,0.034,1.255,0.14,1.891,0.206c0.207,0.262-0.423,0.287-0.991,0.259c-0.989-0.061-1.42-0.241-1.532-0.294
					c-0.07-0.034-0.118-0.074-0.16-0.114C56.973,12.417,57.14,12.361,57.653,12.395z M28.552,9.324
					c-0.081-0.009-0.104-0.025-0.132-0.041c-0.078-0.042-0.112-0.1-0.089-0.128c0.019-0.019,0.069-0.035,0.236,0.02
					C28.979,9.319,28.558,9.321,28.552,9.324z M19.096,11.257c-0.117-0.009-0.419-0.04-0.752-0.242
					c-0.221-0.131-0.324-0.257-0.415-0.361c0.989,0.068,0.989,0.068,1.21,0.144C19.561,10.946,19.913,11.294,19.096,11.257z
					 M19.597,10.97c-0.013-0.034-0.036-0.098,0.092-0.139c0.217-0.068,0.931-0.005,1.198,0.312L19.597,10.97z"/>
				<path d="M1920.116,52.042V36.853c-0.545-0.085-1.064-0.178-1.729-0.297c-0.535,0.115-1.258,0.265-1.793,0.379
					c-0.723-0.052-1.691-0.12-2.42-0.172c0.322-0.333,1.277-0.758,2.26-1.022c0.715,0.04,1.682,0.092,2.4,0.132
					c-0.111-0.146-0.27-0.344-0.389-0.493c-3.264,0.021-6.414-0.276-9.707-0.176c-0.371-0.158-0.867-0.365-1.238-0.521
					c0.297-0.154,0.689-0.361,0.984-0.517c-0.637-0.298-2.199-0.626-3.543-0.758c-3.248-0.315-6.748-0.442-10.119-0.661
					c-0.201-0.166-0.471-0.391-0.672-0.554c1.502-0.187,3.482-0.442,4.949-0.641c-0.162-0.353,0.408-0.855,1.256-1.159
					c8.201,0.459,8.201,0.459,10.414,0.27c-7.391-1.034-7.391-1.034-7.715-1.351c-5.91,0.592-9.484-0.893-14.771-0.854
					c-0.098-0.012-10.719-0.851-18.705,0.074c-4.127-0.325-5.184-0.339-8.303-0.247c-0.945-0.319-2.934-0.987-8.832-0.977
					c-0.365,0.155-0.844,0.356-1.207,0.506c-2.967,0.632-7.361,0.505-10.529,1.028c0.301,0.169,0.695,0.396,0.99,0.563
					c-1.412,0.031-3.4-0.077-4.611-0.247c0.232,0.167,0.539,0.391,0.764,0.555c-5.381,0.468-11.068-0.095-16.486,0.249
					c-0.186,0.164-0.43,0.385-0.625,0.552c-0.537-0.114-1.256-0.267-1.783-0.382l-30.715-1.2c-1.875,0.732-1.875,0.732-6.215,1.025
					l-1.332-0.101c-3.592,0.037-7.143-0.245-10.746-0.061c0.096,0.166,0.242,0.385,0.352,0.551c-7.084,0.087-9.139,0.092-13.203-0.872
					c0.65,0.055,0.84-0.063,0.711-0.164c-0.068-0.074-0.246-0.089-0.305-0.095c-0.406-0.026-0.49,0.028-0.666,0.201
					c-1.564-0.383-3.42-0.891-5.986-1.608c-0.781,0.04-1.813,0.092-2.59,0.132c-0.217-0.077-0.506-0.181-0.713-0.261
					c0.404-0.141,0.936-0.324,1.338-0.463c-1.271,0.196-3.273,0.367-4.801,0.425c-0.842,0.578-3.322,0.864-4.689,1.351
					c-1.52,0.006-3.539-0.047-5.021-0.109c-0.193,0.172-0.457,0.41-0.652,0.586c-2.955,0.218-3.264,0.241-7.424-0.026
					c-1.053,0.222-2.84,0.434-4.23,0.502c-2.561,0.599-2.561,0.599-9.656,0.932c3.018,0.338,3.75,0.396,7.25,0.464
					c0.432,0.147,1,0.343,1.422,0.489c-7.646,0.391-15.674,0.152-23.217,0.709c0.141,0.175,0.33,0.405,0.471,0.577
					c-6.754-0.426-12.996-1.223-20.074-1.422c0.129-0.163,0.285-0.388,0.41-0.551c-3.279-0.715-8.51-0.497-11.717-1.246
					c-0.637,0.105-1.479,0.244-2.111,0.348c-0.705-0.099-1.65-0.23-2.357-0.327c-0.34,0.103-0.785,0.234-1.131,0.333
					c-5.834-0.394-11.957-0.204-17.875-0.438c0.381-0.201,0.885-0.471,1.264-0.671c-9.922-0.822-9.922-0.822-11.725-1.063
					c-0.52,0.118-1.203,0.275-1.715,0.396c-0.441-0.135-1.033-0.31-1.469-0.442c-0.143,0.33-0.943,0.77-1.865,1.028
					c4.727,0.333,10.303-0.178,14.43,0.744c-1.535,0.043-3.6,0.089-5.15,0.118c-0.199-0.041-0.475-0.093-0.684-0.133
					c-0.051,0-6.826,0.098-13.816-0.037c-2.527,0.164-5.094,0.021-7.639,0.046c-0.342,0.172-0.789,0.404-1.131,0.577
					c-0.365-0.152-0.85-0.354-1.211-0.506c-0.725,0.068-1.689,0.155-2.408,0.225c0.389,0.138,0.896,0.326,1.279,0.471
					c-0.756,0-1.752,0.012-2.504,0.018c-0.273-0.155-0.627-0.362-0.904-0.521c-1.469-0.092-3.418-0.221-4.875-0.318
					c-1.371,0.2-3.111,0.508-4.336,0.755c-0.178-0.065-0.412-0.154-0.576-0.221c0.41-0.144,0.977-0.337,1.395-0.479
					c-6.479-0.222-12.75-0.661-19.207-0.902c-0.379,0.086-0.875,0.201-1.252,0.287c-0.691-0.055-1.625-0.129-2.314-0.184
					c0.641-0.106,1.504-0.246,2.139-0.353c4.23,0.364,8.586,0.005,12.861,0.114c-0.014-0.175-0.025-0.408-0.041-0.58
					c1.072,0.235,2.887,0.466,4.32,0.563c0.141-0.361,0.35-0.844,0.533-1.205c0.609,0.105,1.41,0.246,2.025,0.353
					c-0.262,0.187-0.604,0.439-0.859,0.629c0.621-0.092,1.453-0.212,2.072-0.304c-0.4-0.158-0.938-0.368-1.34-0.526
					c0.504-0.131,1.172-0.307,1.68-0.439c-0.74,0.003-1.719,0.006-2.459,0.013c-0.475-0.124-1.113-0.293-1.59-0.42
					c0.096-0.181,0.219-0.426,0.314-0.609c-1.545,0.003-3.607-0.022-5.141-0.058c-0.33-0.16-0.785-0.372-1.121-0.534
					c1.605,0.041,3.736,0.099,5.342,0.146c-0.201-0.178-0.465-0.416-0.666-0.594c-0.785,0.031-1.822,0.069-2.598,0.101
					c-0.486-0.146-1.123-0.342-1.592-0.484c-2.945-0.023-2.945-0.023-9.662,0.647c1.516,0.035,3.537,0.066,5.059,0.081
					c0.205,0.126,0.477,0.293,0.676,0.419c-13.643,0.815-13.979,0.818-17.203,0.856c0.596,0.327,2.139,0.688,3.471,0.867
					c0.33,0.356,1.086,0.818,1.934,1.122c-0.461,0.003-1.084,0.007-1.543,0.01c-0.385-0.182-0.896-0.426-1.281-0.61
					c-0.824-0.025-1.92-0.057-2.744-0.083c0.545,0.118,1.271,0.273,1.814,0.388c0.182,0.092,0.424,0.219,0.607,0.313
					c-1.486,0.026-3.543-0.086-4.813-0.262c-0.123-0.166-0.295-0.385-0.416-0.554c-15.297-0.299-15.297-0.299-17.43-0.888
					c1.551-0.12,3.455-0.413,4.506-0.701c1.031,0.248,2.908,0.479,4.381,0.529c0.496-0.124,1.164-0.29,1.666-0.414
					c-0.346-0.16-0.793-0.375-1.135-0.54c-9.74,0.098-9.74,0.098-11.98-0.43c-0.08,0.108-0.184,0.255-0.27,0.361
					c-4.701-0.379-15.721-1.28-20.934-0.092c-0.277-0.161-0.646-0.374-0.924-0.531c-0.549,0.324-1.457,0.744-2.258,1.043
					c-4.623-0.228-7.252,0.798-11.328,0.916c-0.383,0.163-0.908,0.384-1.297,0.548c-0.697-0.081-1.627-0.184-2.316-0.265
					c0.068,0.179,0.164,0.42,0.236,0.604c-0.799-0.022-1.852-0.046-2.648-0.063c-0.324-0.152-0.762-0.356-1.084-0.511
					c-0.742-0.009-1.721-0.023-2.463-0.034c0.129,0.178,0.305,0.413,0.449,0.597c-1.164,0.032-1.164,0.032-6.432-0.45
					c0.082,0.169,0.193,0.393,0.283,0.56c-0.807-0.018-1.895-0.041-2.705-0.057c-0.217-0.168-0.496-0.388-0.695-0.553
					c-0.738-0.017-1.717-0.037-2.455-0.055c-0.35,0.146-0.818,0.34-1.166,0.486c-0.646-0.099-1.504-0.225-2.15-0.321
					c-0.736,0.097-1.729,0.235-2.461,0.332c-1.377-0.135-3.262-0.287-4.701-0.379c0.219,0.167,0.508,0.379,0.729,0.54
					c-1.479-0.129-3.34-0.385-4.498-0.632c-0.58,0.118-1.334,0.272-1.912,0.391c-0.682-0.068-0.682-0.068-0.932-0.126
					c0.084-0.012,0.201-0.029,0.281-0.043c-0.166-0.021-0.41-0.047-0.6-0.061c-1.867-0.098-3.961,0.342-5.68-0.12
					c-0.279,0.261-0.592,0.393-1.475,0.614c-1.174-0.104-2.086-0.342-3.451-0.356c-1.229-0.438-1.229-0.438-1.828-0.454
					c0.152,0.207,0.293,0.241,1.412,0.529c-1.633,0.218-2.676,0.608-4.49,0.77c-0.779,0.068-0.566-0.268-1.367-0.259
					c-0.33,0.333-1.971,0.448-2.43,0.758c-1.025-0.074-2.121,0.123-3.127-0.043c-0.031-0.003-3.09-0.555-3.986-1.131
					c-0.879-0.009-1.467-0.187-2.34-0.199c0.047-0.126-0.072-0.338,0.363-0.419c1.512,0.031,1.512,0.031,1.861-0.058
					c-0.227-0.511-3.182-0.184-4.324-0.482c-0.877,0.021-0.826,0.299-1.721,0.316c0.908,0.379,1.043,0.437,2.238,0.468
					c-0.174,0.311-2.014,0.287-2.266,0.58c-0.551-0.112-1.287-0.262-1.836-0.373c-0.783,0.043-0.594,0.295-1.4,0.33
					c0.975,0.227,0.699,0.557,1.34,0.815c-2.064,0.256-4.709,0.022-6.639,0.396c-0.35-0.132-1.32-0.084-1.494-0.268
					c-0.354,0.035-0.354,0.035-0.303,0.313c-0.168,0.022-0.373,0.052-0.916,0.012c-0.018-0.018-0.029-0.04-0.041-0.055
					c0.107-0.032,0.23-0.078,0.252-0.118c-0.229-0.017-0.459-0.023-0.699-0.023c-0.26,0.225-0.268,0.356-0.041,0.558l10.131,0.431
					c2.309,0.038,4.633,0.075,6.943,0.106c0.354-0.157,0.578-0.191,1.215-0.123l0.635,0.396l3.463,0.152l-3.496-0.152
					c0.021,0.006,0.039,0.013,0.057,0.018c-5.904,0.311-8.049,0.261-11.15-0.034c-0.135-0.08-0.305-0.189-0.434-0.276
					c0.809-0.031,1.916-0.068,2.744-0.086c-2.934-0.074-6.846-0.166-9.773-0.241c0.227,0.173,0.221,0.419,0.047,0.595
					c-2.449-0.031-2.449-0.031-3.742,0.232c-0.455-0.115-1.248-0.235-1.904-0.283c-1.479,0.317-2.83,0.422-6.932,0.186
					c-0.412,0.145-0.859,0.351-1.057,0.512c1.18,0.272,1.18,0.272,4.746,0.413c0.42-0.097,0.982-0.227,1.393-0.324
					c0.885,0.189,1.51,0.439,2.582,0.58c-0.084,0.373-0.084,0.373-1.91,0.767c0.402,0.351,1.613,0.646,1.344,1.039
					c-0.861,0.046-1.99,0.138-2.795,0.224c-2.395-0.221-2.395-0.221-4.207-0.258c-0.238,0.074-0.551,0.172-0.777,0.247
					c-1.314-0.04-2.475-0.213-3.82-0.235c-0.264,0.058-0.619,0.129-0.883,0.184c-1.309-0.063-2.666-0.04-3.971-0.104
					c0.152-0.262,0.152-0.262-0.438-0.977c3.08,0.023,3.08,0.023,3.371-0.002c-0.049-0.081-0.117-0.189-0.166-0.271
					c-2.336-0.089-2.336-0.089-3.271-0.293c-0.936,0.015-2.313-0.003-3.084-0.123c-0.092,0.025-0.197,0.049-0.342,0.063
					c-0.006,0-0.014,0-0.014,0c-0.055,0.003-0.104,0.006-0.156,0.006h-0.006h-0.01c0.139-0.051,0.318-0.077,0.527-0.068
					c-0.021-0.173-0.055-0.401-0.061-0.574c0.598,0.108,1.264,0.286,1.672,0.433c0.359-0.008,0.832-0.025,1.184-0.037
					c-0.352-0.138-0.646-0.351-0.67-0.505c1.447-0.204,3.145-0.235,4.721-0.351c0.275,0.063,0.646,0.149,0.922,0.212
					c0.201-0.063,0.459-0.149,0.664-0.212c0.637,0.058,1.59,0.077,2.273,0.052c-3.172-1.017-8.512,0.187-11.908-0.592
					c-1.143,0.015-2.297-0.04-3.42,0.044c-0.592-0.107-1.324-0.259-1.834-0.383c0.123-0.092,0.279-0.218,0.404-0.313
					c-0.309-0.042-0.713-0.103-1.02-0.148c-0.061,0.158-0.092,0.376-0.074,0.536c-0.455-0.113-0.799-0.327-0.762-0.481
					c-1.289-0.179-2.436-0.407-3.678-0.604c-0.203,0.161-0.533,0.367-0.828,0.517c-0.338-0.034-0.787-0.074-1.129-0.108
					c-0.094-0.152-0.541-0.348-1.039-0.453c-0.377,0.146-0.623,0.372-0.68,0.545c-0.449-0.167-0.857-0.419-1.035-0.612
					c-1.68,0.078-1.744,0.081-3.824-0.031c-0.324-0.144-0.568-0.354-0.578-0.514c-0.6,0.393-0.6,0.393-17.01-0.244
					c-0.508,0.138-1.203,0.313-1.732,0.442c-0.484-0.127-1.275-0.265-1.92-0.345c-0.516,0.109-1.074,0.293-1.371,0.437
					c-0.885-0.46-3.182-0.54-4.514-0.882c-3.494-0.014-3.494-0.014-4.066,0.003c2.033-0.598,2.033-0.598,3.191-0.715
					c0.252,0.063,0.594,0.146,0.84,0.209c0.365-0.149,1.037-0.327,1.592-0.445l-3.279-0.123l-0.023,0.109l-1.672-0.063l0.023-0.107
					c-28.301-0.984-28.951-0.933-30.52-0.807c0.873,0.469,0.873,0.469,5.135,0.561c0.383,0.17,0.953,0.393,1.418,0.558
					c-1.535,1.014-7.232,0.1-9.076,0.984c-1.604-0.241-4.031,0-5.26-0.46c-0.268,0.638,1.295,1.022,3.982,0.985
					c-0.17,0.083-0.396,0.192-0.574,0.272c-3.004,0.242-3.004,0.242-3.582,0.327c-0.578-0.103-1.473-0.2-2.168-0.25
					c-0.148,0.285,0.246,0.566,0.139,0.85c-0.836,0.029-1.924,0.165-2.428,0.319c-1.742-0.27-3.924-0.327-5.711-0.579
					c-4.678,0.299-4.678,0.299-5.893,0.235c-0.361-0.136-1.129-0.282-1.775-0.34c-0.295,0.145-0.471,0.364-0.4,0.521
					c-0.254-0.061-0.592-0.144-0.852-0.207l-1.127,0.21c-4.871-0.453-4.834-0.942-3.938-1.27c-0.799-0.098-0.799-0.098-4.775-0.224
					c-0.217-0.063-0.508-0.155-0.727-0.225c2.814-0.046,2.814-0.046,3.473-0.123c-0.225-0.071-0.518-0.163-0.744-0.236
					c-3.643-0.1-3.643-0.1-5.043-0.019c0.447,0.131,0.92,0.335,1.059,0.499c-1.373,0.111-2.873,0.146-4.146,0.321
					c0.422,0.132,0.91,0.316,1.197,0.456c3.102,0.104,2.844,0.914,5.006,1.215c1.512,0.21,3.297-0.022,4.83,0.152
					c-0.43,0.123-1.264,0.241-1.92,0.288c0.656,0.238,1.965,0.313,2.707,0.531c-0.281,0.058-0.674,0.132-0.965,0.188
					c-1.35-0.253-1.674-0.315-3.449-0.074c-1.154-0.074-2.387-0.057-3.531-0.138c-0.232,0.166-0.822,0.376-1.414,0.488
					c0.34,0.218,0.836,0.505,1.262,0.718c1.135,0.086,3.061,0.164,5.832,0.046c-0.043,0.195-0.318,0.459-0.658,0.643
					c-0.611-0.063-1.57-0.086-2.232-0.051c0.322,0.022,0.766,0.061,1.096,0.085c-2.256,0.265-5.191-0.092-7.193,0.408
					c-0.334-0.034-0.781-0.078-1.111-0.109c-0.117,0.078-0.291,0.182-0.41,0.259c-2.076-0.224-2.076-0.224-4.184-0.982
					c-2.984-0.126-6.033-0.149-9.02-0.275c-0.225,0.012-0.51,0.023-0.725,0.029c-1.172-0.218-1.172-0.218-4.463-0.196
					c-0.189,0.081-0.447,0.185-0.643,0.262c-2.918-0.666-2.918-0.666-5.203-0.548c-0.268-0.047-0.627-0.115-0.885-0.161
					c0.99-0.114,0.99-0.114,3.445-0.146c0.453-0.121,1.045-0.284,1.494-0.404c3.365,0.12,3.365,0.12,6.035,0.574
					c0.342-0.018,0.791-0.04,1.129-0.058c0.201,0.06,0.484,0.144,0.703,0.206c5.676-0.321,3.926-0.861,1.02-1.763
					c-3.066,0.167-3.303,0.16-5.469,0.052c-0.338-0.152-0.662-0.374-0.785-0.539c0.373-0.032,0.867-0.07,1.238-0.104
					c0.973,0.144,2.211,0.13,3.164,0.279c0.201-0.066,0.459-0.153,0.664-0.222c-0.688-0.08-1.51-0.224-2.076-0.344
					c-2.027,0.188-4.48-0.099-6.33,0.286c0.232,0.149,0.563,0.351,0.799,0.5c-2.143-0.265-4.051-0.615-6.152-0.898
					c-0.258-0.768,1.211-0.894,2.387-0.991c-0.867-0.46-0.49-0.597,0.732-0.939c0.383,0,0.891,0,1.277,0
					c1.879,0.571,1.879,0.571,4.094,0.624c0.092-0.108,0.209-0.253,0.305-0.362c0.941-0.034,2.158-0.144,2.969-0.256
					c0.059-0.077,0.117-0.187,0.166-0.266c0,0,0,0,0.012,0.005c-0.209-0.963-0.209-0.963-1.559-1.223
					c-0.303,0.057-0.705,0.129-1.01,0.184c-0.643-0.098-1.275-0.316-1.463-0.488c-0.857-0.072-0.857-0.072-3.43-0.729
					c-0.699,0.031-1.662,0.063-2.379,0.068c-0.453-1.039-0.438-1.108-0.205-1.524c0.691,0.037,1.627,0.083,2.328,0.106
					c0.207,0.068,0.479,0.166,0.693,0.235c0.18-0.072,0.43-0.173,0.611-0.244c-0.006,0-0.012,0-0.018,0
					c0.117-0.279-0.184-0.518-1.006-0.796c-1.299,0.118-2.652,0.238-4.162-0.005c-0.602-0.102-0.822-0.262-0.885-0.316
					c-0.25-0.179-0.119-0.362-0.26-0.546c-0.016-0.018-0.053-0.039-0.076-0.06c-0.523,0.071-1.166,0.163-1.488,0.433
					c-0.404,0.34-0.146,0.693-0.264,1.034l3.236,0.104c-1.111-0.036-2.246-0.07-3.205-0.099c-0.385,0.466-0.385,0.466-1.787,0.614
					c-0.33-0.13-1.078-0.27-1.717-0.318c-0.074,0.164-0.164,0.382-0.229,0.542c0.264,0.07,0.615,0.164,0.873,0.235
					c-0.365,0.078-0.842,0.182-1.203,0.265c0.227,0.058,0.525,0.139,0.754,0.201c-0.301,0.339-0.744,0.666-0.965,1.005
					c0,0.006,0.854,1.896,1.014,2.516c0.676,0.074,1.486,0.219,1.979,0.348c0.354-0.02,0.828-0.052,1.178-0.071
					c0.297,0.039,0.68,0.097,0.967,0.141c-0.129,0.077-0.309,0.187-0.447,0.261c-2.02,0.052-2.02,0.052-4.139-0.017
					c-0.174-0.075-0.408-0.173-0.582-0.247c0.361-0.015,0.842-0.038,1.203-0.052c-0.561-0.109-1.49-0.21-2.223-0.241
					c-1.166-1.517,0.695-3.096-1.908-4.584c-0.332,0.142-0.975,0.312-1.557,0.403c0.082,0.092,0.189,0.212,0.271,0.304
					c-0.271,0.052-0.625,0.121-0.885,0.173c-0.453-0.54-0.482-0.547-2.25-0.765c-0.039-0.04-0.072-0.098-0.107-0.141
					c-0.178,0.354-0.178,0.354,0.471,0.882l-1.578,3.133c-0.592,0.095-1.273,0.255-1.65,0.394c-0.35-0.006-0.814-0.009-1.17-0.018
					c0.086,0.093,0.178,0.213,0.252,0.305c5.066,0.462-0.119,1.814,2.955,2.533c0.402-0.021,0.939-0.044,1.338-0.064
					c0.865-0.912,0.795-1.211,0.682-1.754c2.719,0.182,2.719,0.182,8.297-0.025c0.021,0.166-0.035,0.391-0.156,0.554
					c0.693,0.038,1.594,0.106,2.254,0.164c-0.277,0.063-0.635,0.149-0.908,0.212c-1.852-0.293-2.096-0.332-7.965,0.305
					c-0.215,0.178-0.197,0.437-0.043,0.617c1.941,0.138,2.033,0.291,2.18,0.566c-0.783,0.011-1.848,0.011-2.623-0.006
					c-1.344,0.37-1.344,0.37-4.229,0.441c-0.658,0.311-0.658,0.311-0.83,0.856c0.355,1.332,0.355,1.332-2.074,1.406
					c-0.807-0.938-0.656-1.31-0.598-1.487c0.352-0.339,0.438-0.428,1.518-0.35c-0.141-0.259-1.379-0.414-1.227-0.695
					c0.043-0.077,0.389-0.111,0.477-0.182c0.219-0.146,0.254-0.301,0.408-0.45c0.293-0.281,1.264-0.351,1.271-0.351
					c-0.363-0.321-1.719-0.49-2.365-0.769c-0.049-0.044-0.115-0.104-0.154-0.146c-2.977,0.221-0.023,1.082-2.57,1.386l-0.055,1.482
					c0.018,0.694,0.049,1.628,0.064,2.329c0.346,0.017,0.793,0.037,1.133,0.055c0.379,0.474,0.379,0.474-1.25,0.993l0.006,0.361
					c-0.27-0.229-0.697-0.43-1.41-0.579c0.275-0.265,0.275-0.265-0.492-0.728c0.541-0.055,1.314-0.1,1.902-0.105l0.047-2.326
					c-21.717-0.54-48.926-1.212-73.258-1.81c1.242,0.34,3.857,1.189,3.879,1.197c0.59,0.21,0.541,0.282,0.455,0.422
					c0.924-0.017,1.148,0.268,2.066,0.254c0.084,0.259,1.045,0.484,0.523,0.76c-1.775-0.1-2.484-0.234-3.986-0.755
					c-0.428-0.144-0.945-0.324-1.605-0.453c-0.117-0.023-0.283-0.052-0.406-0.075c0.041-0.218,0.037-0.258-0.486-0.488
					c-0.16-0.065-0.535-0.223-0.496-0.333c0.01-0.043,0.135-0.109,0.051-0.151c-0.279-0.146-0.947-0.23-1.211-0.377
					c-0.014-0.011,0-0.02,0.002-0.031c-7.139-0.176-14.057-0.347-20.451-0.503c0.672,0.356,0.756,0.359,2.104,0.435
					c0.055,0.055,0.055,0.055,4.016,1.708c-2.016-0.052-2.271-0.58-3.891-0.738c0.119-0.058,0.281-0.135,0.412-0.192
					c-0.447-0.021-1.047-0.046-1.496-0.068c-1.238-0.442-2.205-0.916-3.371-1.367c-20.393-0.45-47.578-1.051-67.971-1.501
					c-0.113,0.65-0.527,2.833-1.201,3.49c-0.381,0.021-0.885,0.047-1.266,0.067c-1.041,0.901-1.041,0.901-2.732,1.082
					c-1.031-0.474-1.533-0.996-2.438-1.479c0.031-0.063,0.092-0.149,0.141-0.212c-0.189-0.048-0.438-0.115-0.615-0.163
					c0.623-0.904,0.684-1.482,0.309-2.944c-0.881-0.017-2.051-0.04-2.928-0.058c0.012,0.526,0.012,0.526-2.107,2.481
					c0.221,0.044,0.529,0.104,0.756,0.144l-0.744,0.374l0.465,0.286c-2.787,1.281,4.615,3.002-2.539,4.032
					c0.4,0.093,0.934,0.213,1.34,0.298c-2.367,1.316-1.6,2.105-1.316,2.404c19.498,0.37,42.885,0.881,65.465,1.387
					c-22.566-0.471-45.953-0.931-65.414-1.337c0.125,0.129,0.041,0.313-0.133,0.436c-0.566,0.034-1.299,0.097-1.811,0.157
					c-0.148,0.146-0.537,0.343-0.955,0.46c0.1,0.077,0.229,0.184,0.324,0.259c-0.52,0.061-1.086,0.192-1.391,0.305
					c-0.535-0.052-1.26-0.106-1.809-0.144c2.09,0.629-0.832,1.215-1.775,1.381c-0.26-0.023-0.605-0.055-0.873-0.077
					c-0.246,0.025-0.584,0.061-0.838,0.089c0.184,0.379,0.184,0.379-1.613,1.32c-2.439-0.345-2.439-0.345-0.26-2.158
					c0.342,0.021,0.799,0.056,1.154,0.082c-0.064-0.065-0.141-0.152-0.201-0.215c-0.295,0.011-0.688,0.028-0.99,0.04
					c0.119-0.077,0.285-0.185,0.402-0.258c1.158-0.121,2.453-0.162,3.547-0.316c-0.281-0.029-0.67-0.068-0.953-0.098
					c-0.52,0.049-1.295,0.063-1.846,0.04c0.107-0.058,0.242-0.138,0.344-0.192c-1.045-0.319-2.33-0.712-0.75-1.352
					c0.018-0.196-0.896-0.285-1.025-0.466c-0.16-0.218,0.438-0.425,0.23-0.649c-0.041-0.043-0.252-0.092-0.359-0.132
					c-0.654-0.241-1.086-0.58,0.578-0.81c-0.168-0.454-0.191-0.523,0.662-0.552c-0.025-0.17-1.039-0.218-0.898-0.401
					c0.135-0.179,0.354-0.222,1.557-0.448c-0.939-0.477-0.652-1.061-2.475-1.456c-0.084,0.364-1.344,2.13-1.355,2.146
					c-0.061,0.068-0.408,0.132-0.639,0.178c0.09,0.229,0.521,0.287,1.379,0.407c-2.816,0.661-0.816,0.876-0.152,0.948
					c-0.367,0.089-0.99,0.065-1.344,0.157c-0.459-0.071-0.381-0.197-0.555-0.299c-0.207-0.008-0.486-0.008-0.684-0.003
					c-0.111,0.265,1.189,0.429,0.941,0.701c-0.227,0.241-1.438,0.247-1.975,0.414c-0.275-0.133-2.633-1.31,0.434-1.597
					c-1.227-0.294-0.438-2.872,0.506-3.116c-0.934-0.301-1.557-0.445-2.703-0.617c0.205-0.356,0.205-0.356-0.91-0.738
					c1.225-0.152,1.225-0.152,1.078-0.308c-0.389-0.036-0.906-0.08-1.297-0.12c0.564-0.152,0.32-0.37,0.785-0.534
					c0.111-0.003,0.264-0.008,0.369-0.011c-1.744-0.311-1.744-0.311-2.316-0.592c-0.795,0.103-1.43,0.023-2.115-0.265
					c0.383-0.021,0.889-0.052,1.273-0.068c-0.717-0.713,1.137-1.373,0.873-2.074c-1.154-0.017-2.699-0.04-3.861-0.055
					c-0.066,0.018-0.158,0.038-0.229,0.055c-0.215-0.014-0.479-0.051-0.637-0.089c-0.012-0.003-0.721-1.156-0.689-1.357
					c0.021-0.179,0.523-0.322,0.67-0.489c0.525-0.585-0.611-1.15-0.336-1.728c0.061-0.153,0.557-0.327,0.908-0.457
					c-0.484-0.417-0.484-0.417-0.961-0.503c0.855-0.545,0.879-0.775,0.723-1.303c-0.15-0.495,0.107-0.54,0.779-0.604
					c-0.611-0.138-0.611-0.138-0.094-0.678c-0.277-0.092-0.646-0.207-0.92-0.299c0.873-0.778,0.934-1.292,0.969-2.809
					c0.002,0,0.008,0,0.008,0c0.049-0.971,0.049-0.971,0.648-2.113c-0.906,0-0.619-0.265-1.289-0.327
					c0.303-0.293,0.678-0.66-0.689-1.344c-0.094-0.04-0.223-0.092-0.318-0.127c-1.631,0.448-1.932,0.532-2.369,0.781
					c-0.416,0.235,0.119,0.488-0.156,0.724c-0.211,0.178-1.047,0.275-1.221,0.46c-0.035,0.034,0.07,0.074,0.1,0.108
					c0.016,0.018,1.148,1.394-2.117,1.603c0.023,0.003,0.051,0.009,0.068,0.012c0.139,0.028,0.275,0.058,0.381,0.092
					c0.154,0.003,0.33,0.007,0.494,0.01c-0.174-0.003-0.361-0.007-0.525-0.01c0.736,0.281-0.73,0.437-0.742,0.678
					c-0.012,0.154,0.701,0.341,0.678,0.5c-0.01,0.065-0.1,0.154-0.146,0.221c-0.877,1.148-1.496,1.194-1.785,1.218
					c-0.744,0.055-0.803,0.078-0.66,0.256c-0.129-0.021-0.129-0.021-0.918-0.402c-0.123-0.003-0.297-0.012-0.426-0.018
					c-0.059-0.278,1.656-0.437,0.998-0.752c-1.148-0.046-2.338-0.087-4.377,0.481c-0.654,0.188,1.049,0.254,1.08,0.442
					c-0.082,0.013-0.184,0.026-0.262,0.035c-0.045,0.006-0.082,0.012-0.246,0.022c-1.314,0.029-1.709-0.258-2.064-0.6
					c-1.424-0.021-2.557-0.244-3.961-0.278c-0.582,0.35-0.6,0.729-1.24,1.076c-0.586,0.313-0.775,0.336-1.541,0.428
					c0.492,0.351-0.26,0.692-0.098,1.04c0.037,0.109,0.674,0.224,0.723,0.333c0.012,0.034,0.006,0.081,0.012,0.115
					c-0.012,0.075-0.402,0.138-0.682,0.186c-0.65,0.11-0.613,0.173-0.514,0.352c-1.072-0.05-1.963-0.207-3.037-0.259
					c-0.27-0.821,0.543-1.634,0.428-2.455c-0.049-0.37-0.951-0.7-0.934-1.074c0.012-0.195,0.164-0.224,0.719-0.339
					c-0.836-0.098-1.861-0.098-2.627-0.235c-0.072,0.023-0.201,0.052-0.232,0.081c-0.383,0.327,0.338,0.653-0.021,0.98
					c-0.26,0.23-1.42,0.322-1.668,0.553c-0.049,0.036-0.096,0.089-0.129,0.129c-0.072,0.077,0.068,0.186,0.164,0.267
					c-2.063,0.718-3.186,1.54-4.822,2.303c-0.213,0.096-0.666,0.204-0.789,0.311c-0.281,0.224,1.076,0.29,0.979,0.499
					c-0.273,0.575-2.223,1.086-1.369,1.712c-1.391,0.592-1.008,1.295-2.369,1.89c-0.555,0.157-0.738,0.184-1.488,0.253
					c0.016,0.034,0.025,0.08,0.043,0.114c0.373,0.069,0.373,0.069,1.295,0.096c-0.307,0.35-0.445,0.45-1.596,0.456
					c1.014,0.401,1.014,0.401-0.959,1.315c-0.707,0.333,0.396,0.644,0.252,0.965c-0.063,0.141-0.309,0.321-0.506,0.457
					c-0.424,0.302-1.102,0.582-1.455,0.889c-0.168,0.159,0.207,0.4-0.164,0.537c-0.945,0.354-2.713,0.461-4.051,0.693
					c0.07,0.101,0.154,0.231,0.221,0.33c-0.238,0.029-0.541,0.068-0.762,0.103l1.201,3.819c-37.133-0.568-75.148,2.292-111.468-1.473
					c0.224-0.411,0.224-0.411-0.171-0.542c1.508,0.097,1.726,0.16,1.94,0.565c32.924,0.387,76.793,1.013,109.699,1.449
					c-0.414-1.137-0.959-2.659-1.379-3.796c-0.477,0.04-1.154,0.071-1.662,0.074c-0.08-0.04-0.184-0.092-0.252-0.132
					c2.83-0.398-0.098-1.103,1.633-1.556c0-0.006,0.006-0.006,0.012-0.006c0.209-0.069,0.191-0.13-0.055-0.219l-0.025-0.006
					l-0.023-0.074c-0.344-1.031-0.803-2.406-1.154-3.44c-0.18,0.028-0.432,0.063-0.611,0.092c0.637,0.305,0.549,0.339-0.059,0.552
					c-1.061-0.161-1.834-0.414-3.111-0.511c-0.096,0.333-1.014,0.643-0.633,0.995c0.281,0.032,0.672,0.075,0.957,0.107
					c0.221-0.023,0.516-0.053,0.734-0.081c0.336,0.052,0.689,0.155,0.795,0.241c-0.178,0.026-0.424,0.061-0.607,0.086
					c-0.76-0.063-1.482-0.149-2.242-0.218c-0.143,0.224-0.572,0.431-0.699,0.655c-2.357,0.082-2.357,0.082-3.01,0.137
					c0.658,0.397,0.658,0.397,0.008,0.626c-0.473-0.005-1.104-0.034-1.547-0.074c0.59,0.522,0.596,0.534-0.252,0.771
					c-0.242-0.053-0.561-0.115-0.803-0.167c0.285-0.081,0.762-0.165,1.156-0.216c-3.1-0.83,0.004-1.74-0.703-2.599
					c-2.154-0.222-2.381-0.245-3.923-0.253c-1.023,0.721-1.818,1.453-2.7,2.177c-2.49-0.105-2.49-0.105-2.717-0.086
					c0.299,0.104,0.646,0.24,0.873,0.35c-0.16,0.035-0.339,0.093-0.528,0.115c-2.488,0.302-3.665,0.046-3.519-0.772
					c0.348-0.06,0.845-0.129,1.244-0.167l-0.459-0.191c2.262-0.713,1.898-2.927,1.886-2.947c-4.223-0.022-9.866-0.052-14.096-0.073
					c-0.241,0.086-0.707,0.184-1.118,0.223c-0.252,0.609-0.252,0.609-1.903,1.706c-0.012,0-1.108-0.598-1.672-1.125
					c0.216-0.015,0.517-0.031,0.741-0.044c-1.66-0.163-1.66-0.163-2.476-0.163c0.023,0.098,0.164,0.227,0.342,0.315
					c-1.792,0.155-2.298,0.408-2.254,1.123c-0.368,0.055-0.858,0.129-1.224,0.187c0.253,0.46-1.792,0.839-0.953,1.32
					c-0.953,0.173-1.8,0.38-2.809,0.537c-0.505-0.06-1.355-0.163-1.333-0.499c0.086-1.307,1.77-2.596,0.982-3.917
					c-1.117-0.009-2.602-0.025-3.704-0.049h-0.069c-0.474-0.008-1.12,0.012-1.557,0.053c0.942,0.412,1.02,0.47,0.236,0.786
					c-1.861-0.17-2.194-0.385-2.789-0.896c-0.56-0.485-1.019-0.621-2.432-0.724c0.641-0.679-1.618-1.173-2.189-1.77
					c-0.182-0.195,0.09-0.391-0.154-0.586c-0.277-0.225-1.179-0.373-1.442-0.6c-0.313-0.262,0.083-0.531-0.2-0.79
					c-0.146-0.138-0.685-0.221-0.907-0.347c-0.75-0.424-0.042-0.908-0.974-1.327c-0.254-0.113-1.15-0.187-1.255-0.311
					c-0.129-0.141,0.589-0.146,0.771-0.241c0.013-0.003-0.494-1.002-1.738-1.474c-0.224-0.048-0.531-0.111-0.755-0.16
					c-0.437,0.775,1.314,1.476,1.486,2.237c0.052,0.272-0.979,0.487-0.844,0.767c0.07,0.152,0.879,0.195,0.974,0.339
					c-0.584,0.149-0.719,0.184-0.755,0.367c0.165,0.092,0.579,0.207,0.555,0.304c-0.048,0.162-0.625,0.274-0.754,0.426
					c-0.495,0.643,1.532,1.154,1.756,1.761c0.06,0.154,0.06,0.154-0.631,0.657c-0.229,0.166,0.507,0.272,0.513,0.425
					c0.011,0.144-0.872,0.166-0.801,0.315c0.083,0.195,1.208,0.279,1.025,0.5l-0.484,0.104c-0.129,0.017-0.306,0.043-0.437,0.066
					c-0.199-0.026-0.458-0.058-0.659-0.084c-2.971-0.011-6.933-0.023-9.902-0.034c-0.531,0.448-0.531,0.448,0.01,0.676
					c-0.376,0.054-0.871,0.12-1.249,0.174c0.459,0.139,1.061,0.253,1.425,0.405c-1.513,1.152-0.448,2.421-3.159,3.521
					c-1.756-0.264-1.756-0.264-2.21-0.31c1.149-1.152-1.003-2.33,0.537-3.473c-1.15-0.351-0.685-0.786-1.286-1.16
					c-3.195-0.031-7.451-0.068-10.644-0.092c-0.573,0.213-0.573,0.213,0.465,0.861c-0.218,0.019-0.512,0.034-0.736,0.053
					c-0.919-0.213-0.974-0.225-1.192-0.978c-0.636,0.023-1.483,0.053-2.121,0.075c-0.495,0.362-0.495,0.362-1.179,0.549
					c-0.484-0.265-0.755-0.411-2.748-0.618c0.296,0.127,0.685,0.291,0.979,0.414c-0.389,0.154-1.055,0.246-1.602,0.364
					c0.153,0.549-0.402,1.095-0.249,1.64c-0.655-0.071-0.655-0.071-2.865-0.521c-0.194,0.016-0.448,0.034-0.636,0.052
					c0.035,0.372-1.461,0.626-1.509,0.99c-0.042,0.336,1.378,0.565,1.273,0.904c-0.013,0.058-0.283,0.12-0.402,0.173
					c-0.364-0.053-0.824-0.124-1.167-0.185c-0.181,0.02-0.435,0.046-0.623,0.063c2.287,0.571-0.178,1.347,1.626,1.938
					c-1.993,0.887-0.249,1.854-1.108,2.765c-0.884-0.045-1.538-0.227-2.517-0.218c0.006-0.589,1.397-1.116,1.421-1.706
					c0.01-0.385-1.245-0.691-1.311-1.073l0.249-0.385l0.755-0.288c-2.724-0.804,0.766-2.084-4.062-2.73
					c0.808-0.152,0.913-0.201,0.63-0.681c-1.615-0.178-1.615-0.178-2.352-0.146c-0.334,0.164-0.583,0.33-0.826,0.5
					c-1.13-0.055-1.13-0.055-5.25-2.183c-0.915,0.026-2.133,0.052-3.054,0.071c0.707,0.673-0.909,1.342-0.013,2.011
					c-0.365,0.052-0.847,0.121-1.208,0.179c0.017,0.014,1.503,1.918-0.607,2.688c1.621,1.091,1.162,1.315-1.061,1.441
					c0.005,0.181,0.005,0.181,1.014,0.49c-0.354,0.133-0.354,0.133,0.96,1.255c-0.458,0.035-1.065,0.081-1.532,0.115
					c0.313,0.072,0.831,0.149,1.262,0.172c-4.603,0.322-4.603,0.322-3.908,0.689c0.89,0.031,0.926,0.034,2.039-0.134
					c0,0.065,0,0.157,0,0.226c-0.471,0.049-1.037,0.139-1.407,0.222c0.229,0.037,0.534,0.089,0.758,0.129
					c0.326-0.068,0.674-0.181,0.826-0.27c1.097,0.105,1.875,0.634,1.781,0.85c-0.49,0.009-1.142,0.028-1.631,0.051l-0.88-0.01
					c-0.754,0.045-1.768,0.103-2.529,0.149c0.03,0.086,0.076,0.2,0.114,0.289c-0.372,0.038-0.862,0.083-1.234,0.124
					c-0.489-0.17-0.983-0.419-1.137-0.617c-21.62-0.21-50.442-0.492-72.056-0.699c0.355,0.17,0.667,0.414,0.773,0.604
					c-0.354,0.051-0.839,0.117-1.198,0.169c-0.559-0.365-0.689-0.48-0.737-0.89c-0.918-0.01-2.127-0.021-3.039-0.033
					c-1.004,0.521,3.051,3.748,4.785,5.124c-0.178,0.086-0.408,0.201-0.584,0.287l-6.389-2.878c-2.775-2.085-2.775-2.085-5.665-2.016
					c0.578,0.948-2.057,1.897,0.048,2.841c0.376-0.012,0.867-0.032,1.238-0.043c-0.283-0.173-0.549-0.414-0.696-0.598
					c0.354,0.022,0.825,0.051,1.186,0.074c0.594,0.382,5.777,3.772,4.951,4.741c-0.148,0.163,0.69,0.37,1.268,0.477
					c-0.685,0.049-1.722,0.037-2.394-0.021c-0.059-0.341-0.607-2.096-4.973-3.195c-0.078,0.198-0.09,0.468-0.06,0.675
					c-0.367-0.034-0.85-0.072-1.215-0.104c-1.385-0.982-2.499-1.991-3.973-2.969c0.188-0.07,0.448-0.167,0.636-0.236
					c-1.119-0.631-1.119-0.631-2.375-0.814c0.042,0.11,0.094,0.258,0.135,0.367c-0.271,0.06-0.63,0.137-0.896,0.191
					c-1.196-0.175-1.638-0.238-1.531-0.758c-0.365-0.021-0.849-0.046-1.215-0.065c0.731-0.592-0.99-1.275-1.013-1.281
					c-0.966,0.032-2.251,0.074-3.219,0.106c0.019,0.015,1.475,1.604,0.389,2.182c0.525,0.201,0.525,0.201,1.019,3.449
					c1.9,0.228,2.895,0.401,0.691,0.972c0.178,0.079,0.424,0.184,0.602,0.263c-1.733,0.604,0.313,1.327-1.19,1.941
					c-0.013-0.006-1.934-1.261-2.835-1.892c-0.79-0.084-1.757-0.25-2.311-0.405c-0.242,0.158-0.711,0.358-1.15,0.494
					c0.36,0.061,0.832,0.138,1.185,0.194c0.065,0.09,0.148,0.214,0.218,0.303c0.294,0.045,0.697,0.105,1.002,0.152
					c-0.607,0.117-1.438,0.264-2.085,0.37c-0.826-0.417-0.808-0.445-0.578-0.842c-0.696-0.063-1.609-0.154-2.269-0.235
					c1.749,2.059,1.749,2.059,1.031,2.279c-1.308-0.197-1.993-0.593-3.849-0.613c0.254,0.406-0.488,0.807-0.219,1.218l23.141,0.238
					c0.046-0.121,0.718-0.248,1.209-0.293c0.135,0.094,0.312,0.215,0.447,0.307c2.446,0,5.711-0.003,8.152-0.006
					c-0.078-0.188-0.19-0.439-0.283-0.629c0.317-0.06,0.743-0.141,1.066-0.198c1.491,0.311,1.793,0.408,2.27,0.953
					c1.325,0.013,3.1,0.032,4.426,0.047c0.006-0.086,0.03-0.196,0.042-0.276c0.377,0.004,0.879,0.012,1.262,0.015
					c0.188,0.086,0.435,0.198,0.623,0.278c49.137,0.521,67.397,0.712,105.542,1.184c-29.599-0.343-63.847-0.721-105.571-1.181
					c2.381,1.576,3.472,3.225,5.429,4.821c-3.301-0.798-7.333-4.81-7.344-4.841c-2.223,0.086-5.188,0.373-6.756,0.74
					c-0.199-0.247-0.482-0.574-0.695-0.821l-9.819-0.1c-2.621,0.014-5.653,0.085-8.774,0.146c0.083,0.027,0.186,0.051,0.24,0.079
					c0.123,0.075-0.059,0.127-0.166,0.155l-1.203-0.014c-0.07-0.071-0.124-0.136-0.158-0.199c-5.966,0.104-12.137,0.128-16.434-0.442
					c-0.547-0.258-1.103-0.511-1.714-0.763c0.118,0.003,0.271,0.003,0.382,0.006c0.502-0.273-1.014-0.684,0.619-0.85
					c-0.961-0.374-0.948-0.856-2.545-1.16c0,0-0.485-0.063-1.032,0.146c-0.279,0.103-0.465,0.149-1.102,0.126
					c1.02,0.318,1.308,0.508,0.942,0.962c-0.319,0.39-0.319,0.487-0.046,0.743c-0.92,0.04-1.676-0.095-2.535-0.12
					c0.229-0.144,0.825-0.244,0.943-0.401c0.064-0.09-0.296-0.274-0.402-0.331c-0.069-0.029-0.141-0.052-0.213-0.074
					c-1.071-0.316-1.071-0.316-1.283-0.425c-0.177-0.013-0.537-0.029-0.684,0.082c-0.154,0.112-0.26,0.161-1.109,0.084
					c-0.07-0.04-0.159-0.104-0.129-0.146c0.218-0.043,0.518-0.043,0.731-0.083c0.023-0.046-0.059-0.106-0.129-0.149
					c-0.915-0.063-1.292-0.144-1.851-0.483c-0.049-0.028-0.107-0.071-0.153-0.103c-0.16,0.023-0.308,0.049-0.448,0.074
					c-0.884,0.259-0.436,0.58-0.867,0.861c-0.684-0.137-1.232-0.246-2.411-0.712c-0.795-0.31-0.795-0.31-1.308-0.281
					c-0.183,0.078,0.022,0.155,0.005,0.23c-0.005,0.005-0.59,0.327-2.033-0.466c-0.459-0.247-0.602-0.275-1.203-0.399
					c-0.211-0.018-0.482-0.04-0.689-0.055c-0.425,1.326-0.524,1.643,0.985,2.379l-0.089,0.367l-0.679,0.175
					c0.203,0.089,0.473,0.207,0.673,0.296c-0.47,0.126-1.482,0.061-1.743,0.258l-1.309-0.014c-1.332,0.081-3.113,0.187-4.445,0.265
					c4.338,4.238,4.303,4.255,2.417,5.137c-2.163-0.861-2.369-0.979-3.984-1.901c-0.012-0.009-0.034-0.017-0.247-0.123
					c-1.108-0.374-1.108-0.374-3.113-1.858l-1-0.77l-1.799-0.872c-0.07-0.196-0.165-0.461-0.241-0.655
					c-0.695,0.103-1.626,0.235-2.321,0.342c-0.213-0.173-0.49-0.399-0.708-0.571l-0.142-0.265L652,29.365
					c-6.448,0.304-10.001-0.299-18.589-1.764l-4.267-0.313c-0.053-0.072-0.118-0.17-0.172-0.242
					c-26.275-2.868-26.275-2.868-59.554-4.045c-43.545-4.278-48.154-3.228-50.631-2.665c-1.296-0.178-2.675-0.568-3.147-0.893
					c-24.914-1.658-51.284-0.808-76.292-2.289c-15.571-0.109-15.571-0.109-17.53,0.459c-0.448-0.149-1.049-0.342-1.498-0.488
					c-5.41-0.157-5.41-0.157-7.933-0.063c-0.248,0.379-1.108,0.861-2.02,1.183c-9.91-2.526-45.321-1.528-49.86-0.454
					c-0.766-0.068-1.803-0.166-2.582-0.238c0.112-0.197,0.249-0.459,0.354-0.657c-1.791,0.092-1.791,0.092-8.481-0.046
					c-0.891,0.305-1.445,0.813-1.362,1.177c-0.859,0.092-2.004,0.213-2.864,0.305c-0.625-0.117-1.452-0.272-2.075-0.391
					c0.623-0.149,1.462-0.347,2.086-0.499c-0.165-0.184-0.383-0.431-0.554-0.617c-1.898,0.022-1.898,0.022-54.673-0.438
					c-0.389,0.176-0.902,0.405-1.285,0.578c2.688,0.574,6.625,0.485,9.561,0.933c-0.613,0.146-1.438,0.342-2.058,0.485
					c-11.913-0.511-11.913-0.511-14.429-0.506c-0.429-0.154-0.995-0.355-1.426-0.511c0.701-0.117,1.633-0.27,2.334-0.388
					c-0.258-0.175-0.607-0.411-0.859-0.585c-13.946-0.561-28.428,0.261-42.174-0.827c0.083,0.191,0.201,0.456,0.277,0.646
					c-0.76,0.049-1.781,0.109-2.541,0.155c1.622,0.163,3.514,0.517,4.658,0.821c-0.472,0.17-1.098,0.396-1.562,0.563
					c-1.716-0.333-1.716-0.333-7.739-0.666c0.141-0.195,0.323-0.454,0.464-0.648c-3.577-1.121-3.577-1.121-16.154-1.367
					c-0.601,0.123-1.397,0.287-1.999,0.413c-4.734-0.077-8.6-0.735-13.067-0.993c-0.66,0.132-1.539,0.305-2.198,0.431
					c-6.277-0.281-12.702-0.367-18.885-0.764c0.046-0.092,0.112-0.213,0.152-0.305c-1.433,0.146-3.736,0.158-5.251,0.063
					c-0.16,0.38,0.217,0.905,0.862,1.259c-0.85,0.009-1.976,0.022-2.819,0.034c0.354,0.16,0.826,0.379,1.179,0.54
					c-0.807,0.058-1.875,0.132-2.683,0.187c7.635,0.726,7.635,0.726,13.361,2.223c-0.647,0.132-1.509,0.308-2.156,0.445
					c-0.083-0.015-9.348-1.172-16.416-0.586c1.486,0.154,3.132,0.54,3.878,0.873c-0.076-0.009-8.516-0.938-14.422-1.447
					c-0.354,0.16-0.82,0.373-1.167,0.534c0.777-0.052,1.815-0.12,2.593-0.173c-0.005,0.179-0.012,0.423-0.024,0.601
					c-1.709-0.044-3.966-0.152-5.611-0.268c-0.625-0.333-2.027-0.74-3.371-0.933c-0.177,0.181-0.413,0.422-0.589,0.603
					c-5.118-0.783-5.118-0.783-7.08-0.807c-0.478,0.166-1.126,0.385-1.597,0.551c2.204,0.741,6.371,0.62,9.218,1.081
					c-0.094,0.194-0.207,0.453-0.301,0.647c-1.598-0.063-3.731-0.154-5.333-0.223c0.129,0.35-0.178,0.838-0.731,1.165
					c1.437,0.138,3.083,0.482,3.901,0.781c-0.666,0.103-1.556,0.244-2.215,0.344c-3.159-0.263-6.247-0.573-9.4-0.844
					c-0.602,0.123-1.404,0.288-2.012,0.405c5.923,0.333,5.923,0.333,7.633,0.588c-0.612,0.156-1.432,0.363-2.051,0.518
					c-1.431-0.212-3.449-0.463-5.003-0.626c-1.403-0.172-3.396-0.345-4.916-0.453c-0.932-1.472-0.932-1.472-2.063-1.815
					c0.695-0.101,1.615-0.235,2.31-0.333c-2.486-0.89-7.185-0.977-10.673-1.502c0.347-0.187,0.813-0.431,1.16-0.617
					c2.676,0.284,4.445,0.876,7.315,1.085c0.184-0.191,0.423-0.447,0.602-0.644c0.748,0.089,1.75,0.207,2.492,0.293
					c0.224,0.198,0.513,0.466,0.731,0.664c-0.577,0.124-1.344,0.284-1.921,0.41c0.813,0.023,1.887,0.063,2.693,0.086
					c0.336,0.162,0.795,0.38,1.137,0.543c0.778,0.046,1.822,0.106,2.606,0.155c-0.778-0.124-1.815-0.29-2.594-0.413
					c1.127-1.071,1.127-1.071,5.907-1.982c-0.814-0.313-1.437-0.795-1.515-1.16c3.172,0.254,3.826,0.303,8.305,0.038
					c0.325-0.184,0.755-0.426,1.078-0.603c-1.467-0.178-3.024-0.586-3.73-0.929c0.689-0.089,1.614-0.209,2.304-0.301
					c-0.235-0.192-0.548-0.445-0.785-0.632c-1.59-0.061-3.843-0.017-5.344,0.115c0.712,0.092,1.656,0.212,2.363,0.304
					c-0.626,0.319-2.228,0.687-3.666,0.816c0.129,0.143,0.294,0.333,0.423,0.479c-1.503-0.112-1.503-0.112-8.293-0.282
					c1.42,0.247,3.388,0.558,4.926,0.762c-0.07,0.181-0.169,0.419-0.246,0.597c-0.731,0.058-1.704,0.132-2.435,0.189
					c0.471,0.189,1.09,0.442,1.562,0.626c-2.517-0.083-5.123-0.172-11.664-0.746c0.129-0.351-0.408-0.844-1.308-1.132
					c-0.814,0.047-1.899,0.109-2.701,0.158c0.313,0.164,0.731,0.382,1.05,0.543c-0.767-0.041-1.792-0.098-2.558-0.141l2.257,2.423
					h-0.036c0.524,0.342,1.221,0.796,1.75,1.135c0.814,0.018,1.91,0.043,2.724,0.063c0,0.195,0,0.453,0,0.654
					c-0.78-0.037-1.815-0.083-2.595-0.118l0.019,0.268c-0.002,0-0.002-0.003-0.005-0.006c-0.56-0.034-1.114-0.068-1.674-0.097
					c-4.25-0.179-2.24,0.723-2.215,0.734c0.435,0.164,1.135,0.284,1.485,0.465c1.266-0.167,2.445,0.161,4.077,0.624
					c-0.166-0.176-0.368-0.383-0.564-0.584l0.653,0.673l2.211,2.17l-0.019,0.015c1.314,0.561,1.314,0.561,6.49,1.454
					c-0.809-0.021-1.885-0.055-2.688-0.078c1.061,0.27,2.528,0.626,3.654,0.885c-1.543-0.078-3.665-0.127-5.251-0.127
					c-0.002-0.002-0.004-0.004-0.006-0.006c-0.317,0.023-0.624,0.049-0.919,0.081c0.013,0.005,0.025,0.011,0.041,0.011
					c0.408,0.144,0.876,0.19,1.197,0.209l0.408,0.388c1.225,0.581,2.852,1.367,4.544,1.887c-0.814-0.048-1.893-0.116-2.699-0.163
					c6.948,1.781,17.458,1.098,25.814,1.907c2.778,0.582,3.679,0.597,7.503,0.416l0.844,0.195c0.448-0.061,1.049-0.141,1.498-0.198
					c21.359,1.271,21.359,1.271,23.834,1.703c-2.948,0.388-2.948,0.388-13.667-0.055c-0.497,0.155-1.162,0.361-1.657,0.517
					c8.917,0.977,19.115,1.137,27.843,2.234c-14.015-0.218-27.23-1.562-41.435-1.517c-2.08-0.356-24.401-0.85-25.699-0.826l3.065,2.492
					c1.061-0.063,2.559,0.023,3.654,0.052c5.132-1.006,5.132-1.006,6.106-1.092c3.867,1.416,11.317,1.052,16.692,1.718
					c0.129-0.003,15.596,0.241,20.817,1.014c6.86,0.132,15.997,0.307,22.856,0.436c-0.448-0.169-1.031-0.393-1.473-0.559
					c14.63,0.453,15.831,0.49,20.004,1.145c0.042,0.003,0.081,0.003,0.121,0.003c-0.156-0.003-0.306-0.005-0.462-0.008
					c-0.342-0.055-0.613-0.141-1.048-0.164h-0.036l-0.035,0.138c-10.01,0.38-10.01,0.38-16.493-0.388
					c-26.69-0.439-26.69-0.439-32.265-0.634c-0.282,0.097-0.659,0.229-0.947,0.327c-4.28-0.374-8.907-0.385-13.293-0.655
					c-2.309,0.247-4.702,0.04-7.06,0.069c-0.183,0.188-0.437,0.442-0.625,0.629c1.627,0.106,3.56,0.463,4.427,0.786
					c-9.62-0.048-9.62-0.048-18.621-0.784l-0.035-0.002c1.084,0.537,2.535,1.255,3.614,1.794c7.62,0.368,7.62,0.368,8.381,0.385
					c4.472,0.5,10.007,0.396,13.902,1.236c-2.379-0.107-2.379-0.107-8.77-0.535c-0.777,0.104-1.81,0.244-2.582,0.351
					c2.215,0.626,2.735,0.774,7.437,0.574c0.03-0.012,0.061-0.018,1.845-0.109c0.962,0.293,1.824,0.758,2.058,1.114
					c-4.178,0.012-8.163-0.307-12.294-0.37c-0.83-1.174-1.891-1.229-10.114-1.663h-0.036l1.486,1.178l0.318,0.227
					c-0.601-0.166-1.181-0.342-1.899-0.479c0.343-0.028,0.795-0.068,1.133-0.101c-0.636-0.24-1.486-0.565-2.122-0.804
					c-2.984-0.061-2.984-0.061-9.489-1.111c0.023-0.083,0.059-0.192,0.082-0.276c5.854,0.13,6.289,0.149,9.128,0.282
					c-0.925-0.528-2.149-1.235-3.081-1.769c-2.081-0.018-3.832-0.345-5.941-0.34c-0.408-0.293,0.047-0.614-0.488-0.904
					c0.076-0.049,0.194-0.112,0.275-0.16c3.514,0.143,3.75,0.014,4.734-0.537c-0.915-0.753-2.116-1.752-3.024-2.508
					c-2.882-0.181-2.882-0.181-3.394-0.192c-0.237,0.061-0.544,0.139-0.769,0.196c-1.249-0.46-1.249-0.46-6.676-0.655
					c0.07,0.074,0.159,0.172,0.224,0.247c-3.248-0.684-7.847-0.833-11.254-1.456c0.189,0.175,0.326,0.422,0.307,0.6
					c-1.167-0.04-2.299-0.108-3.46-0.154c-2.419,0.283-4.519,0.339-6.437,0.265c-0.113-0.007-0.228-0.011-0.341-0.017
					c-5.145-0.245-8.967-1.435-13.953-1.794c0.19-0.073,0.45-0.171,0.638-0.246c0.33,0.018,0.778,0.046,1.108,0.068
					c0.801-0.045,1.993-0.031,2.758,0.047c0.336-0.034,0.791-0.081,1.126-0.115c0.229,0.058,0.537,0.133,0.772,0.189
					c0.023-0.121,0.048-0.275,0.066-0.396c0.346-0.011,0.807-0.031,1.16-0.043c-40.457-2.048-40.457-2.048-42.134-1.893
					c4.364,0.928,11.391,0.471,15.504,1.524c0.106-0.042,0.249-0.103,0.349-0.146c0.218,0.061,0.512,0.142,0.723,0.201
					c-0.094-0.074-0.211-0.175-0.306-0.252c14.965,0.534,14.965,0.534,16.037,0.956c-0.289,0.043-0.659,0.101-0.937,0.145
					c0.254,0.065,0.589,0.157,0.849,0.226c-0.082,0.081-0.207,0.196-0.296,0.275c-0.141-0.005-14.474-0.534-16.325-1.036
					c-0.626-0.169-10.18-1.893-12.814-0.318c0.896,0.367,0.896,0.367,0.849,0.684c-2.063-0.144-2.063-0.144-3.393-0.018
					c-4.219-0.394-8.997-0.391-13.528-0.563c2.325,0.188,4.592,0.408,6.698,0.73c3.11-0.241,16.2,0.869,16.33,0.881
					c0.754,0.405,0.425,1.1,0.419,1.105c-0.242-0.149-0.736-0.333-1.184-0.459c-0.154,0.075-0.367,0.178-0.52,0.253
					c-0.276-0.046-0.653-0.115-0.93-0.161c0.034-0.087,0.087-0.204,0.129-0.291c-0.33,0.023-0.761,0.055-1.08,0.078
					c-0.294-0.049-0.688-0.114-0.983-0.16c0.023,0.092,0.072,0.218,0.101,0.31c-2.445,0.055-7.07-0.267-8.364-0.482
					c-1.483,0.201-2.093,0.281-6.628-0.327c0.041-0.08,0.102-0.187,0.151-0.267c-1.516-0.308-2.25-0.359-13.004-0.896
					c-0.218,0.061-0.51,0.135-0.725,0.192c-0.219-0.054-0.518-0.132-0.736-0.189c0.955,0.388,0.977,0.416,1.345,0.933
					c-7.696-0.731-9.737-0.64-11.091-0.576c4.58,0.419,12.243,1.123,15.485,2.291c-1.329,0.149-1.329,0.149-4.86-0.034
					c-0.258,0.049-0.613,0.114-0.876,0.166c-1.616-0.108-3.293-0.166-4.874-0.304c-0.221-0.058-0.516-0.144-0.74-0.204
					c-7.445,0.083-11.337-1.554-17.902-1.892c0.126,0.144,0.628,0.329,1.15,0.419c-0.137,0.074-0.319,0.166-0.457,0.235
					c-2.288-0.284-4.794-0.462-7.249-0.666v21.105l1.742,1.025h2.618L1.717,50.96c1.111,0.367,2.263,0.729,3.375,1.082H1920.116z
					 M1236.958,36.896c0.143,0.078,0.33,0.179,0.48,0.256c8.008-0.355,16.012,0.608,24.029,0c-0.113-0.073-0.258-0.175-0.367-0.252
					c1.393-0.041,2.461-0.282,3.842-0.331c0.238-0.071,0.545-0.175,0.781-0.25c-0.236-0.034-0.543-0.089-0.781-0.128
					c0.627,0.071,1.449,0.166,2.064,0.241c0.119-0.078,0.287-0.179,0.412-0.257c-0.34-0.017-0.793-0.04-1.129-0.055
					c-0.027-0.076-0.059-0.181-0.084-0.255c1.473,0.109,1.473,0.109,2.998,0.615c0.266-0.058,0.619-0.13,0.885-0.188
					c-0.113-0.071-0.27-0.173-0.383-0.247c2.838,0.043,5.422,0.537,8.461,0.25c-0.008-0.08-0.008-0.192-0.008-0.271
					c-0.73-0.028-1.768-0.02-2.477,0.029c-0.426-0.092-0.977-0.218-1.402-0.315c0.719,0.011,1.703-0.069,2.297-0.161
					c-0.424-0.098-0.424-0.098-3.24-0.281c-0.223,0.058-0.529,0.137-0.752,0.201c0.088,0.074,0.217,0.175,0.309,0.252
					c-0.215,0.061-0.5,0.146-0.723,0.207c-1.721-0.092-2.219-0.126-4.314-0.511c0.141-0.075,0.316-0.17,0.457-0.241
					c-0.275-0.092-0.641-0.213-0.916-0.304c0.322-0.05,0.768-0.118,1.082-0.168c0.666,0.053,1.557,0.11,2.24,0.149
					c0.27-0.052,0.627-0.123,0.902-0.172c-1.008-0.155-2.24-0.213-3.236-0.376c0.014-0.083,0.025-0.192,0.025-0.276
					c-4.662-0.141-10.043-0.305-15.479-0.47l15.479,0.47c0.365-0.077,1.197-0.082,1.66-0.043l20.842,0.311
					c0.566,0.109,1.51,0.212,2.24,0.241c-0.072-0.147-0.104-0.21,0.375-0.296c0.498-0.086,0.521-0.106,0.535-0.238
					c-0.688-0.138-1.398-0.247-3.371-0.229c-1.047,0.011-1.748-0.018-2.229-0.195c-0.049-0.012-0.098-0.038-0.135-0.058
					c2.455-0.098,5.031,0.144,7.422-0.132c0.785,0.16,1.387,0.218,2.826,0.272c4.689,0.136,4.689,0.136,4.975,0.184
					c0.021,0.003,1.164,0.457-0.078,0.561c-0.254-0.087-0.299-0.104-0.141-0.225c0.129-0.092-0.078-0.121-0.584-0.181
					c-0.336,0.117-0.613,0.132-1.975,0.112c-1.629-0.026-1.973,0.034-1.838,0.327c0.824,0.058,1.725,0.023,2.537,0.098
					c0.576,0.049,0.676,0.089,0.729,0.189c-2.023-0.12-4.412,0.152-6.125-0.293c0.189-0.089,0.424-0.164,1.244-0.086
					c0.973,0.097,1.113-0.006,1.248-0.104c-0.238-0.098-0.566-0.224-0.805-0.318c-0.891,0.025-1.807-0.026-2.676,0.055
					c-0.652,0.061-0.738,0.108-1.063,0.293c0.564,0.16,1.461,0.234,1.99,0.401c0.391,0.121,0.379,0.121,0.006,0.23
					c-0.475-0.225-1.068-0.265-2.869-0.368l-0.035,0.287c-2.498,0.391-2.498,0.391-3.748,0.517c-0.059-0.092-0.119-0.215-0.172-0.305
					c-2.256-0.27-4.824-0.144-7.172-0.298c-0.26,0.06-0.613,0.138-0.873,0.201c0.207,0.074,0.482,0.166,0.686,0.241
					c0.35,0.005,0.824,0.014,1.188,0.021c0.215,0.143,0.26,0.361,0.096,0.508c0.012,0.006,3.291,1.011,4.697,1.493
					c-1.174,0.307-1.174,0.307-3.732,0.304c0.59,0.359,0.59,0.359,1.35,0.535c0.307-0.037,0.713-0.092,1.02-0.127
					c0.285,0.046,0.664,0.106,0.945,0.152c-1.068,0.289-2.783,0.315-4.078,0.514c-2.063-0.151-2.271-0.129-5.684,0.262
					c-0.105,0.009-0.223,0.017-0.33,0.026c-0.684,0.011-1.615-0.05-2.193-0.13c0.346,0.012,0.805,0.025,1.143,0.034
					c0.262-0.049,0.609-0.118,0.871-0.169c-1.518-0.012-3.023,0-4.529,0.029l-0.375-0.182l-0.842-0.025l-0.012,0.231
					c-0.352,0.007-0.701,0.015-1.045,0.021c0.064-0.063,0.139-0.126,0.197-0.184c-0.229-0.061-0.533-0.149-0.752-0.213
					c-5.156,0.081-10.111-0.437-15.297-0.264c-0.152,0.075-0.352,0.178-0.5,0.256c-0.691-0.052-1.527-0.164-2.066-0.27
					c-0.352,0.021-0.805,0.054-1.143,0.076c0.492,0.124,1.105,0.299,1.504,0.44c-0.682,0.022-1.613,0.025-2.299,0.002
					c-0.01-0.16,0.07-0.379,0.219-0.539c-12.453-0.102-13.361-0.581-13.902-0.867C1236.487,37.072,1236.757,36.972,1236.958,36.896z
					 M1015.589,27.882c-3.736-0.065-7.645-0.134-11.541-0.202L1015.589,27.882z M962.423,29.072c0.07-0.046,0.201-0.098,0.615-0.077
					c0.447,0.218-0.029,0.398-0.572,0.396c-0.094-0.003-0.313-0.008-0.514-0.075c-0.047-0.014-0.092-0.039-0.135-0.06
					C962.147,29.256,962.147,29.256,962.423,29.072z M953.056,31.28c0.603-0.095,1.148-0.031,1.148-0.031
					c0.528,0.12,0.558,0.246,0.675,0.678c-0.796-0.047-1.191-0.012-1.559,0.023c-0.271,0.028-0.492,0.048-0.833,0.048
					c-0.046,0-0.106-0.003-0.16-0.003c0.324-0.281,0.292-0.385-0.204-0.684C952.583,31.346,952.804,31.317,953.056,31.28z
					 M952.924,32.578c-0.1,0.084-0.224,0.192-0.321,0.273l-0.506-0.098C952.134,32.61,952.186,32.529,952.924,32.578z M942.672,30.028
					l0.063,0.201l-0.884-0.012l-0.058-0.204L942.672,30.028z M941.288,32.503c-0.364,0.066-0.603,0.162-1.002,0.216
					c-0.387,0.055-0.648,0.052-0.944,0.052c-0.161-0.003-0.31-0.017-0.469-0.023c-0.025,0-0.061,0-0.083,0
					c-0.058-0.174-0.132-0.404-0.179-0.577C941.036,32.489,941.036,32.489,941.288,32.503z M931.031,31.306l0.495,0.288l-1.281-0.018
					l-0.095-0.281L931.031,31.306z M927.653,36.314c-0.333,0.077-0.556,0.086-0.643,0.086c-0.045,0-0.174-0.006-0.28-0.041
					c-0.073-0.021-0.092-0.048-0.092-0.079C926.643,36.28,926.694,36.09,927.653,36.314z M921.962,29.83
					c-0.144-0.212-0.772-0.402-0.597-0.628c0.115-0.147,0.879-0.133,1.172-0.13c0.568,0.453,0.827,0.663-0.437,0.746
					C922.063,29.825,922.003,29.825,921.962,29.83z M922.511,32.911l-0.061-0.186l0.879,0.011l0.066,0.184L922.511,32.911z
					 M923.217,31.2l0.885,0.009l0.057,0.188l-0.884-0.011L923.217,31.2z M923.938,33.315l-0.074-0.2l0.873,0.012l0.077,0.201
					L923.938,33.315z M925.245,26.505c0.434,0.152-0.095,0.215-0.626,0.212c-0.29-0.008-0.479-0.024-0.583-0.06
					c-0.052-0.018-0.063-0.038-0.058-0.061C924.426,26.585,924.765,26.499,925.245,26.505z M920.602,27.366
					c0.14-0.109,0.186-0.118,0.565-0.137c2.05,0.548,2.05,0.548,3.167,0.619c-0.126,0.287-0.6,0.316-1.436,0.34
					c-0.724,0.021-1.08,0.057-1.378,0.2l-0.953-0.219c0.448,0.006,1.375,0.006,1.235-0.131c-0.106-0.099-0.672-0.233-1.224-0.362
					c-0.252-0.058-0.511-0.112-0.694-0.185C920.418,27.516,920.51,27.438,920.602,27.366z M890.575,31.312
					c0.131-0.16,1.145-0.143,1.592,0.023c0.005,0.005,0.019,0.011,0.024,0.011c0.081,0.041,0.129,0.081,0.141,0.124l-1.697-0.02
					C890.58,31.403,890.54,31.358,890.575,31.312z M892.083,33.161c-0.294-0.009-0.553-0.055-0.789-0.141
					c-0.072-0.022-0.13-0.046-0.166-0.072c-0.023-0.017-0.513-0.353,1.704-0.117C892.755,32.983,892.604,33.161,892.083,33.161z
					 M891.924,32.521c-0.027,0-0.057,0-0.087,0.002c-0.56-0.287-0.353-0.358,0.703-0.477C892.674,32.26,892.827,32.503,891.924,32.521z
					 M892.638,31.194c-0.636-0.009-1.373-0.029-1.85-0.179c-0.343-0.105-0.402-0.238-0.396-0.238c-0.046-0.172,0.094-0.35,0.077-0.522
					c-0.013-0.129-0.053-0.259,0.012-0.39c0.105-0.201,0.388-0.312,1.131-0.432C892.403,30.06,892.45,30.255,892.638,31.194z
					 M890.51,26.043c0.235,0.258,0.218,0.404-0.553,0.401c-0.184-0.003-0.367-0.006-0.537-0.014c-0.024-0.006-0.059-0.01-0.083-0.01
					C889.616,26.051,889.625,26.033,890.51,26.043z M884.911,27.159c0.218-0.614,0.548-0.731,1.427-0.775
					c0.199,0.102,0.501,0.254,1.103,0.336c1.042,0.146,2.333,0.153,3.376,0.303c-0.041,0.231-0.041,0.231,1.102,0.684
					c-1.938,0.166-1.938,0.166-2.493,0.263c-0.242-0.527-0.242-0.536-1.078-0.591c-0.944,1.039-0.944,1.039-2.169,1.223
					c1.133,0.195,0.006,0.457,0.229,0.678c-0.406,0.01-0.771-0.028-0.771-0.028c-0.702-0.08-1.015-0.391-0.343-0.655
					c0.124,0,0.283,0,0.408,0.003c-0.814-0.16-0.791-0.425-1.492-0.597C884.606,27.809,884.716,27.711,884.911,27.159z M878.263,28.228
					l0.064,0.187l-0.883-0.008l-0.064-0.189L878.263,28.228z M878.469,29.074c0.602,0.07,0.813,0.053,0.942-0.068
					c-1.473-0.042-2.016-0.184-1.932-0.508c0.529,0.008,1.231,0.015,1.762,0.022c0.159,0.287,0.478,0.574,0.483,0.867
					c0.006,0.23-0.294,0.391-0.473,0.491c-0.552-0.006-0.977-0.098-1.497-0.124c-0.075-0.002-0.169-0.002-0.234-0.005
					c-0.254-0.129-0.395-0.235,0.094-0.439c0.125-0.055,0.402-0.092,0.319-0.166c-0.095-0.084-0.454-0.112-0.691-0.165
					C877.549,28.975,877.549,28.975,878.469,29.074z M868.02,34.824c-0.043,0.063,0.004,0.12,0.116,0.232
					c0.172,0.184,0.172,0.262-0.3,0.262c-0.124-0.004-0.249-0.004-0.359-0.015c-0.012,0-0.03-0.003-0.047-0.006
					C867.259,35.045,867.434,34.902,868.02,34.824z M860.385,28.186c-0.347-0.099-0.471-0.142,0.184-0.17
					c0.094,0.058,0.2,0.086,0.513,0.154c0.412,0.087,0.66,0.155,0.541,0.339c-0.129,0.018-0.258,0.018-0.4,0.018
					c-0.595-0.011-1.096-0.089-1.249-0.138c-0.224-0.071,0.165-0.09,0.294-0.098c0.129,0.031,0.308,0.071,0.437,0.104
					C860.809,28.331,860.739,28.282,860.385,28.186z M861.281,29.899c-0.27-0.006-0.524-0.023-0.767-0.047
					c-0.04-0.003-0.093-0.011-0.129-0.011c0.414-0.213,0.2-0.348-0.389-0.604c-0.591-0.267-0.836-0.419-0.496-0.657
					c0.826-0.018,1.45,0.077,1.745,0.141C862.708,29.015,863.315,29.888,861.281,29.899z M722.641,44.82
					c-0.004-0.006-0.004-0.006-0.007-0.009l-0.31-0.399L722.641,44.82z"/>';
			$svg_bottom_output    .= '</svg>';
		}

		if( $enable_grunge_effect == 'yes' ){
			$qodef_elementor_section_html = '<div class="qodef-elementor-row">';
			if( ! empty( $svg_top_output ) ){
				$qodef_elementor_section_html .= $svg_top_output;
			}
			$qodef_elementor_section_html .= $content;
			if( ! empty( $svg_bottom_output ) ){
				$qodef_elementor_section_html .= $svg_bottom_output;
			}
			$qodef_elementor_section_html .= '</div>';

			echo mixtape_qodef_get_module_part($qodef_elementor_section_html);
		} else{
			echo mixtape_qodef_get_module_part($content);
		}

	}
	add_action( 'elementor/frontend/section/after_render', 'mixtape_core_render_section_background_after');
}

//function that renders background elements in admin
if ( ! function_exists( 'mixtape_core_render_section_background_option_admin' ) ) {
	function mixtape_core_render_section_background_option_admin( $template, $widget ) {
		if ( 'section' === $widget->get_name() ) {

			$svg_top_output = '';
			$svg_top_output .= '<svg class="qodef-grunge-effect qodef-grunge-effect-top" preserveAspectRatio="none" width="1920px" height="52px" viewBox="0 0 1920 52" enable-background="new 0 0 1920 52" <# if( settings.grunge_effect_background !== "" ){ #> fill=" {{{settings.grunge_effect_background}}} "  <# } #> >';
			$svg_top_output .= '<polygon points="406.54,13.503 406.398,13.307 405.751,13.302 405.88,13.496 "/>
				<polygon points="241.93,10.933 241.795,10.751 241.246,10.74 241.382,10.918 "/>
					<path d="M268.944,15.952c1.75-0.069,0.83-0.479,0.252-0.568c-0.142-0.021-0.296-0.031-0.461-0.038
						c-0.247-0.003-0.412,0.007-0.653,0.035c0.017,0.21,0.566,0.378,0.742,0.577C268.861,15.955,268.901,15.955,268.944,15.952z"/>
					<path d="M255.257,17.744c-1.162-0.021-2.01-0.006-1.551,0.416c0.019,0,0.036,0,0.049,0
						C255.363,18.252,255.287,17.867,255.257,17.744z"/>
					<path d="M675.027,28.849c-0.917-0.167-2.096-0.133-3.134-0.204c-0.011,0.063-0.024,0.175,0.283,0.267
						C672.859,29.106,674.628,29.037,675.027,28.849z"/>
					<path d="M45.177,41.515c0.15,0.018,0.321,0.003,0.477,0.015c-0.161-0.109-0.339-0.185-0.726-0.219
						c-0.067-0.006-0.138-0.006-0.218-0.011c0.052,0.052,0.108,0.103,0.209,0.151C44.982,41.478,45.057,41.501,45.177,41.515z"/>
					<polygon points="132.24,46.371 131.982,46.181 131.576,46.164 131.84,46.353 "/>
					<path d="M40.624,41.96c0.429-0.052,1.232-0.04,2.054,0.104c-0.372-0.276-1.105-0.365-1.404-0.394
						c-0.409-0.026-1.04-0.022-0.708,0.295C40.585,41.965,40.605,41.96,40.624,41.96z"/>
					<path d="M45.389,42.27c-0.123-0.061-0.28-0.138-0.402-0.2l-0.289-0.023c0.039,0.043,0.092,0.081,0.168,0.121
						C44.982,42.219,44.996,42.219,45.389,42.27z"/>
					<path d="M114.323,50.784c-0.176-0.055-0.271-0.112-0.389-0.175c-0.2-0.092-0.313-0.112-0.437-0.121
						c-0.047,0-0.088,0-0.129,0.003c0.082,0.061,0.177,0.121,0.306,0.176C113.935,50.767,114.141,50.775,114.323,50.784z"/>
					<path d="M69.304,49.443c0.101-0.031,0.342-0.018,0.389-0.018c-0.218-0.086-0.501-0.201-0.719-0.286
						c-0.041,0.051,0.095,0.197-0.188,0.154c0.072,0.037,0.137,0.071,0.219,0.105C69.175,49.478,69.232,49.467,69.304,49.443z"/>
					<path d="M36.533,49.119c-0.274-0.182-0.602-0.268-0.814-0.291c-0.218-0.017-0.206,0.034-0.165,0.055
						C36.014,49.104,36.403,49.113,36.533,49.119z"/>
					<path d="M16.978,47.404c0.302,0.144,0.553,0.172,0.638,0.13c0.066-0.034,0.025-0.107-0.129-0.21
						c-0.33-0.018-0.4-0.099-0.648-0.136c-0.262-0.025-0.121,0.066-0.062,0.102C16.831,47.327,16.904,47.367,16.978,47.404z"/>
					<polygon points="18.989,47.657 18.724,47.484 18.307,47.427 18.577,47.605 "/>
					<path d="M16.687,47.468c0.06-0.049-0.013-0.141-0.221-0.276c-0.151,0.029-0.003,0.095-0.24,0.115
						c-0.111,0.012-0.301-0.037-0.386-0.058c0.043,0.023,0.092,0.049,0.135,0.072C16.316,47.49,16.603,47.524,16.687,47.468z"/>
					<path d="M15.353,47.461c0,0,0.002,0,0.006,0c0.044-0.036-0.174-0.2-0.336-0.229c-0.002,0-0.002,0-0.002,0
						c-0.041,0.009,0.205,0.175,0.286,0.212C15.314,47.45,15.33,47.459,15.353,47.461z"/>
					<path d="M3.569,45.781c0.055,0.032,0.122,0.073,0.184,0.101c0.294,0.156,0.344,0.146,0.489,0.121
						c0.084-0.018,0.144-0.022,0.295,0.021c-0.183-0.093-0.407-0.198-0.658-0.247C3.747,45.75,3.646,45.756,3.569,45.781z"/>
					<path d="M2.448,45.658c0.034,0.052,0.102,0.098,0.171,0.149c0.011-0.003,0.017-0.006,0.026-0.008
						c0.296-0.05,0.701,0.12,0.767,0.037c0.044-0.063,0.072-0.101-0.619-0.236C2.674,45.581,2.35,45.522,2.448,45.658z"/>
					<path d="M1912.804,30.979c0.107-0.042,0.084-0.092,0.072-0.112c-0.045-0.008-0.094-0.014-0.154-0.02
						c-0.309-0.028-0.578,0.04-0.885,0.017c-0.043,0.023-0.08,0.047-0.053,0.075C1911.874,31.025,1912.569,31.07,1912.804,30.979z"/>
					<path d="M1909.522,34.379c0.164-0.052,0.234-0.155,0.27-0.207c-0.791-0.04-0.717,0.12-0.705,0.141
						C1909.13,34.382,1909.321,34.441,1909.522,34.379z"/>
					<path d="M1817.087,28.618c0.016-0.045,0.094-0.187-0.469-0.241c-0.26-0.018-0.506-0.008-0.781,0.026
						c-0.018,0.037-0.023,0.071,0.006,0.109C1815.96,28.642,1816.515,28.687,1817.087,28.618z"/>
					<path d="M1813.118,28.59l0.406-0.063c0.176-0.092-0.174-0.136-0.34-0.149c-0.449-0.034-0.865,0.012-0.768,0.144
						c0.006,0.006,0.012,0.012,0.02,0.015C1812.634,28.55,1812.909,28.576,1813.118,28.59z"/>
					<path d="M1284.741,36.257c-0.027-0.003-0.064-0.003-0.104-0.003c-1.117-0.031-1.279,0.149-1.553,0.419
						c0.025-0.002,0.049-0.005,0.072-0.008C1284.618,36.475,1284.702,36.464,1284.741,36.257z"/>
					<path d="M1279.798,36.478c-0.686,0.041-0.84,0.133-0.863,0.262c0.369,0.012,0.863,0.028,1.227,0.041L1279.798,36.478
						z"/>
					<path d="M1281.813,37.302c-0.836-0.018-1.037,0.253-0.746,0.385c0.285,0.124,0.9,0.093,1.1,0.081
						c-0.328-0.081-0.307-0.127-0.152-0.222C1282.159,37.454,1282.167,37.396,1281.813,37.302z"/>
					<path d="M1238.339,39.329c0.736,0,0.482-0.298,1.236-0.246c-0.08-0.139-0.457-0.201-1.391-0.23
						c-0.213-0.005-0.416-0.008-0.623-0.011c-0.273,0.224-0.273,0.224,0,0.465C1237.798,39.312,1238.101,39.326,1238.339,39.329z"/>
					<path d="M1258.567,40.856c0.223-0.02,0.33-0.028,0.33-0.073c0-0.075-0.246-0.13-0.33-0.196
						c0.543,0.037,0.641,0.047,1.143,0.184c0.365,0.092,0.744,0.196,1.758,0.173c0.117-0.163,0.529-0.31,0.529-0.482
						c0.004-0.126-0.082-0.167-0.512-0.345c-1.41-0.006-2.678,0.181-4.096,0.152c-1.369-0.025-2.477-0.21-3.732-0.302
						c-0.006,0.058,0,0.126,0,0.181c-0.111,0.026-0.219,0.021-0.779-0.129c-0.906-0.241-0.906-0.241-0.906,0.275c0.018,0,0.039,0,0.061,0
						C1253.032,40.306,1256.587,40.47,1258.567,40.856z"/>
					<path d="M1251.196,40.073c-0.373-0.008-0.871-0.026-1.234-0.037v0.289c0,0,0.01,0,0.025,0
						C1250.435,40.341,1251.271,40.363,1251.196,40.073z"/>
					<path d="M1231.329,40.047c1.006,0.006,0.951-0.212,0.385-0.35c-0.914,0.012-0.791,0.195-0.59,0.281
						C1231.181,40.008,1231.253,40.026,1231.329,40.047z"/>
					<polygon points="1264.323,40.76 1263.542,40.736 1263.542,40.915 1264.317,40.94 "/>
					<path d="M731.453,36.836c-0.154-0.005-0.3-0.011-0.454-0.014c-0.365,0-0.737,0.009-0.966,0.115
						c-0.308,0.146-0.129,0.302-0.249,0.456c0.036-0.002,0.076-0.005,0.106-0.008C731.128,37.308,731.907,37.233,731.453,36.836z"/>
					<path d="M730.893,39.02c0.023,0,0.042,0,0.057,0c1.057-0.046,1.471,0.264,2.501,0.229
						c-0.284-1.143-0.355-1.45-1.682-1.93c-0.311,0.003-0.558,0.003-0.924,0.135c-0.348,0.118-0.907,0.078-1.438,0.026
						c0.337,0.315,0.909,0.614,1.214,0.93C730.858,38.651,730.88,38.767,730.893,39.02z"/>
					<path d="M760.457,39.054c1.32,0.006,1.121-0.334,0.583-0.46c-0.018-0.005-0.046-0.008-0.065-0.011
						c-0.801,0.011-0.813,0.16-0.529,0.471C760.446,39.054,760.446,39.054,760.457,39.054z"/>
					<path d="M1180.517,45.968c0.061-0.042,0.055-0.092,0.045-0.14c-0.658-0.021-0.998-0.078-1.27-0.21
						c-0.98,0.018-0.672,0.179-0.494,0.244C1179.233,46.025,1180.282,46.181,1180.517,45.968z"/>
					<path d="M731.341,39.476c0.159,0.055,0.92,0.238,1.479,0.04c-0.313-0.086-0.712-0.197-1.02-0.283
						C730.775,39.27,731.282,39.455,731.341,39.476z"/>
					<path d="M1182.04,47.348c0.869-0.125,0.74-0.199,0.184-0.363c-0.633-0.184-1.012-0.32-0.73-0.579
						c-0.375,0.014-1.529,0.058-0.092,0.688C1181.603,47.181,1181.813,47.261,1182.04,47.348z"/>
					<path d="M1176.181,46.824c-0.389-0.092-0.178-0.281-0.939-0.304c-0.111-0.006-0.234,0-0.346,0.002
						c-0.008,0.037-0.016,0.112,0.146,0.176C1175.317,46.811,1175.933,46.824,1176.181,46.824z"/>
					<path d="M740.104,40.162c0.018-0.146-0.406-0.253-0.642-0.379l-1.148,0.083c0.01,0.037,0.028,0.115,0.234,0.181
						C738.944,40.174,739.721,40.168,740.104,40.162z"/>
					<path d="M722.593,39.794l0.319-0.085c0-0.092-0.355-0.118-0.649-0.121c-0.471-0.006-0.918,0.058-0.529,0.187
						c0.01,0.003,0.022,0.009,0.034,0.014C722.022,39.788,722.345,39.791,722.593,39.794z"/>
					<path d="M1178.54,48.449c-0.156,0.185-0.309,0.379,0.398,0.626c1.369,0.471,1.369,0.471,1.449,0.609
						c0.254,0.006,0.59,0.017,0.848,0.023c1.283-0.149-0.246-0.896-1.811-1.058c-0.229-0.439-1.102-0.912-3.234-1.734
						c-0.029-0.003-0.068-0.006-0.096-0.006C1174.604,46.95,1178.479,48.433,1178.54,48.449z"/>
					<path d="M723.632,40.191c-0.396-0.029-0.78-0.066-1.197-0.075c-0.507,0-0.678,0.065-0.642,0.238
						c0.034,0,0.076,0,0.105,0.003C724.009,40.38,724.009,40.38,723.632,40.191z"/>
					<polygon points="715.415,40.38 715.272,40.196 714.447,40.188 714.589,40.372 "/>
					<path d="M738.997,40.702c0,0,0.089-0.175-0.442-0.181c-0.471,0-0.365,0.129-0.647,0.172
						c-0.012,0.003-0.024,0.003-0.035,0.003c-0.061,0.006-0.113,0.009-0.178,0.009c0.035,0.023,0.07,0.042,0.142,0.065
						C738.17,40.875,738.897,40.831,738.997,40.702z"/>
					<path d="M712.285,40.478c-0.146-0.085-0.429-0.149-0.607-0.227c-0.418,0.055-0.553,0.166-0.473,0.379
						c0.356,0.004,0.839,0.009,1.198,0.012C712.408,40.616,712.414,40.547,712.285,40.478z"/>
					<path d="M722.523,40.841c1.09-0.041,0.612-0.259,0.123-0.34c-0.249-0.04-0.442-0.043-0.531-0.046
						c-0.283,0-0.429,0.022-0.63,0.08C721.804,40.627,722.216,40.747,722.523,40.841z"/>
					<path d="M1184.017,48.478c0.852-0.168,0.73-0.536-0.246-0.82c-0.27,0.006-0.861,0.008-0.83,0.184
						c0.039,0.241,0.75,0.43,0.977,0.654C1183.948,48.49,1183.983,48.484,1184.017,48.478z"/>
					<path d="M719.742,41.376c0.606,0.01,1.231-0.003,0.961-0.28c-0.361-0.006-0.844-0.009-1.203-0.015l0.218,0.295
						C719.724,41.38,719.729,41.376,719.742,41.376z"/>
					<polygon points="716.428,41.25 716.276,41.046 715.456,41.041 715.604,41.242 "/>
					<path d="M735.207,41.727c-0.306,0.003-0.548,0.026-0.772,0.075c0.524,0.037,1.209,0.089,1.733,0.127
						C735.997,41.805,735.678,41.739,735.207,41.727z"/>
					<path d="M1181.493,49.075c0.037,0.028,0.078,0.058,0.148,0.084c0.242,0.094,0.717,0.141,1.582,0.151
						c0.1-0.246-0.656-0.289-0.896-0.299C1181.989,49.007,1181.737,49.024,1181.493,49.075z"/>
					<path d="M735.082,42.276c0.019-0.035-0.04-0.058-0.099-0.087c-0.012-0.002-0.025-0.005-0.042-0.012
						c-0.087-0.029-0.188-0.058-0.289-0.083c-0.418,0.095-0.377,0.158-0.277,0.189C734.546,42.339,735.042,42.345,735.082,42.276z"/>
					<path d="M696.553,42.276c0.119-0.139-0.046-0.19-0.612-0.202c-0.366,0-0.732,0.029-1.097,0
						c0.011,0,0.023,0.006,0.035,0.012C695.269,42.219,695.945,42.256,696.553,42.276z"/>
					<path d="M735.46,42.657c-0.914-0.003-0.925,0.161-0.936,0.385c0.005,0,0.011,0,0.022-0.003
						c0.744-0.008,1.285,0.173,2.076,0.115c-0.272-0.063-0.637-0.144-0.908-0.207l0.176-0.272
						C735.743,42.666,735.608,42.661,735.46,42.657z"/>
					<path d="M695.503,42.447c-0.534,0.029-0.317,0.125-0.199,0.167c0.237,0.078,0.801,0.173,1.249,0.132
						c-0.012-0.103-0.165-0.137-0.542-0.184C695.727,42.531,695.586,42.505,695.503,42.447z"/>
					<path d="M1903.05,32.196c1.252,0.144,1.697,0.112,1.936-0.133c0.232-0.017,0.363-0.017,0.918,0.026
						c0.83,0.064,1.072,0.041,1.279-0.118c-1.154-0.2-1.756-0.1-2.486,0.064c-0.152-0.047-0.369-0.104-0.521-0.149
						c0.693-0.023,1.074-0.173,1.48-0.578c-0.383-0.034-0.885-0.083-1.268-0.123c-0.08,0.222-0.313,0.275-0.783,0.345
						c-0.494,0.068-0.719,0.121-0.801,0.324c0.039,0,0.094,0,0.137,0.003c0.545,0,0.742,0.012,0.748,0.052
						c0.004,0.018-0.055,0.041-0.09,0.058C1903.427,32.044,1903.228,32.118,1903.05,32.196z"/>
					<path d="M1899.985,31.903c0.006,0.006,0.012,0.003,0.027,0.006c0.914,0.109,1.613-0.121,2.492-0.083
						c0.104-0.078,0.246-0.188,0.35-0.267c0.012-0.038,0.154-0.075-0.025-0.109c-0.227,0.022-0.545,0.246-0.615,0.351
						c-0.119-0.073-0.281-0.167-0.402-0.241c-0.436-0.033-0.912,0.034-1.334-0.023c0.123,0.115,0.092,0.135-0.098,0.184
						C1900.153,31.782,1900.087,31.826,1899.985,31.903z"/>
					<path d="M1244.597,40.162c1.428,0.023,2.137,0.012,2.447-0.212c-0.365,0.011-0.914,0.028-1.324,0
						c-0.592-0.034-1.051-0.127-1.592-0.179c-0.426,0.115-1.055,0.187-1.234,0.345c-0.486-0.012-0.502-0.026-0.771-0.218
						c-0.117-0.087-0.365-0.121-0.848-0.121c-0.025,0.462-0.025,0.534,0.389,0.678C1242.04,40.15,1242.89,40.134,1244.597,40.162z"/>
					<path d="M723.13,39.283c0.382,0.012,0.777,0.023,1.155,0.052c-0.135-0.068-0.359-0.181-1.363-0.166
						c-0.894,0.014-1.308-0.058-1.684-0.141c-0.188,0.037-0.26,0.06-0.212,0.105c0.024,0.003,0.03,0.007,0.036,0.012
						C721.332,39.212,721.897,39.237,723.13,39.283z"/>
					<path d="M1262.056,36.71c-0.092-0.005-0.24-0.011-0.367-0.063c-0.209-0.086-0.221-0.354,0.324-0.351
						c0,0.146,0.066,0.27,0.373,0.391C1262.28,36.699,1262.175,36.71,1262.056,36.71z"/>
					<polygon points="750.155,40.65 750.026,40.467 750.862,40.472 750.991,40.656 "/>
					<path d="M753.644,37.135c-0.095-0.005-0.224-0.005-0.343-0.04c-0.152-0.045-0.245-0.129-0.329-0.215
						c0.966-0.025,1.551,0.043,1.731,0.201C754.351,37.104,754.016,37.135,753.644,37.135z"/>
					<path d="M757.912,43.568c0.118,0.172,0.111,0.249-0.241,0.278c-0.419-0.147-0.501-0.239-0.55-0.405
						c-0.034-0.135-0.093-0.195-0.382-0.279c0.524,0.039,1.213,0.09,1.739,0.128C757.746,43.264,757.775,43.385,757.912,43.568z"/>
					<polygon points="772.353,40.409 773.188,40.414 773.307,40.602 772.469,40.593 "/>
					<path d="M773.154,42.206c-0.054-0.005-0.095-0.014-0.129-0.021c-0.154-0.055-0.262-0.182-0.203-0.245
						c0.043-0.037,0.153-0.074,0.52,0.058c0.012,0.003,0.023,0.009,0.042,0.015c0.005,0.006,0.022,0.008,0.034,0.014
						C773.342,42.08,773.236,42.148,773.154,42.206z"/>
					<polygon points="772.712,41.546 773.813,41.373 773.608,41.739 "/>
					<path d="M775.83,44.323c-0.138-0.003-0.273-0.003-0.389-0.015c-0.024,0-0.059-0.005-0.078-0.005
						c-0.042-0.053-0.089-0.13-0.135-0.185c0.283-0.141,0.672-0.08,0.824-0.046C776.353,44.137,776.736,44.325,775.83,44.323z"/>
					<path d="M775.109,43.938c-0.118-0.181,0.154-0.243,0.638-0.283c0.188,0.089,0.452,0.207,0.649,0.296L775.109,43.938z
						"/>
					<path d="M781.988,43.246c0.831,0.178,0.707,0.487-0.006,0.565c-0.184-0.052-0.366-0.103-0.524-0.16
						C780.745,43.396,781.322,43.304,781.988,43.246z"/>
					<path d="M783.315,44.936c-0.047,0.005-0.108,0.011-0.16,0.014c0.146-0.152-0.064-0.262-0.76-0.506
						c-0.707-0.244-0.866-0.358,0.502-0.425c-0.383,0.136-0.208,0.256,0.359,0.49C783.687,44.693,784.063,44.849,783.315,44.936z"/>
					<path d="M713.492,44.137c-0.016,0-0.04,0-0.059,0.003c-0.088-0.09-0.754-0.224-0.217-0.276
						c0.112,0.072,0.418,0.118,0.494,0.192C713.729,44.076,713.765,44.107,713.492,44.137z"/>
					<path d="M715.545,43.487c-0.12,0-0.294-0.006-0.579-0.061c-0.036-0.006-0.071-0.014-0.106-0.02
						c0.454-0.279,0.454-0.279-0.435-0.569c1.12-0.008,1.12-0.008,0.524-0.378c0.359,0.005,0.836,0.011,1.197,0.011
						c0.241,0.322,0.483,0.638,0.73,0.956C716.417,43.427,716.003,43.484,715.545,43.487z"/>
					<path d="M719.742,43.82c-0.06,0-0.107,0-0.166,0c-0.012,0-0.012,0-0.023,0c0.236-0.261,0.141-0.379-0.507-0.66
						c1.12,0.072,1.731,0.247,2.075,0.583C720.625,43.743,720.225,43.82,719.742,43.82z"/>
					<path d="M1.714,51.391c-0.224-0.09-0.375-0.185-0.599-0.271c0.044,0.037,0.103,0.089,0.147,0.126
						c-0.083,0-0.38-0.137-0.858-0.401C0.359,50.816,0.3,50.781,0.25,50.753c0.249,0.028,1.56,0.591,1.498,0.646
						C1.734,51.396,1.723,51.391,1.714,51.391z"/>
					<path d="M2.571,51.643c-0.144-0.051-0.188-0.118-0.372-0.166c-0.034,0.028,0.078,0.052,0.019,0.08
						C2.058,51.534,2.067,51.493,2,51.459c-0.115-0.063-0.384-0.213-0.313-0.229c0.123-0.025,0.903,0.379,0.89,0.413H2.571z"/>
					<polygon points="1889.911,31.576 1890.507,31.634 1890.274,31.812 1889.683,31.757 "/>
					<path d="M1889.595,31.921c0.016,0,0.037,0,0.055,0.003c0.039,0.006,0.078,0.048,0.078,0.052
						c-0.01,0.037-0.025,0.101,0.381,0.203c0.424,0.104,1.041,0.161,1.4,0.282c0.127,0.04,0.092,0.058-0.029,0.077
						c-1.076-0.146-1.076-0.146-2.213-0.207C1889.229,32.233,1889.401,31.97,1889.595,31.921z"/>
					<path d="M1871.187,30.931c1.686,0.037,2.861,0.318,4.316,0.467c0.756,0.078,0.789,0.07,1.131,0.023
						c0.236-0.034,3.645-0.014,3.664-0.014c0.902,0.061,1.551,0.218,2.365,0.315c0.523-0.21,1.445-0.336,2.098-0.52
						c0.674,0.046,0.996,0.2,1.604,0.261c0.148,0.015,0.295,0.025,0.459,0.025c-0.453,0.377-0.828,0.5-2.002,0.747
						c-0.447-0.092-0.744-0.121-0.844-0.126c-0.723-0.052-0.984-0.052-1.998-0.034c-1.166,0.022-1.326-0.018-1.496-0.058
						c-0.326-0.081-0.652-0.161-1.115-0.184c-0.359-0.018-0.813,0.065-1.166,0.092c-0.682-0.086-0.828-0.302-1.668-0.351
						c-1.008,0.17-1.008,0.17-1.518,0.063c-0.006,0-0.016,0.003-0.021,0.006c0.016-0.006,0.039-0.011,0.012-0.017
						c-0.006-0.003-0.012,0-0.018,0c-0.02,0-0.023,0.003-0.02,0.006c0,0.005,0.014,0.005,0.025,0.011
						c-0.123,0.023-0.254,0.041-0.389,0.058c-0.189-0.017-0.453-0.04-0.648-0.058c-0.543,0.044-0.709,0.058-0.867,0.052
						c-0.08,0-0.1-0.034-0.129-0.052c-0.23-0.16-0.658-0.194-0.75-0.203c-0.734-0.052-1.436,0.203-2.15,0.037
						c-0.41-0.098-0.588-0.133-0.871-0.149c-0.584-0.044-1.148,0.213-1.588,0.068c-0.008-0.005-0.023-0.008-0.039-0.017
						C1867.888,31.261,1868.872,30.879,1871.187,30.931z"/>
					<path d="M1861.403,30.64c0.525,0.063,0.99,0.149,1.539,0.202c0.385,0.034,0.611,0.037,1.031,0.024
						c-0.383,0.235-0.891,0.309-1.697,0.248c-0.207-0.121-0.785-0.19-0.924-0.319C1861.292,30.737,1861.337,30.695,1861.403,30.64z"/>
					<path d="M1859.79,30.496c-0.029,0.069,0.074,0.104,0.48,0.161c0.449,0.055,0.699,0.096,0.5,0.227
						c-0.523-0.095-0.875-0.049-1.096-0.008c-0.506,0.097-0.896,0.051-1.037,0.034c-0.006,0-0.018-0.003-0.018-0.003
						C1858.979,30.767,1859.394,30.635,1859.79,30.496z"/>
					<path d="M1857.36,29.876c-0.1,0.081-0.23,0.187-0.33,0.27c-0.107,0.003-0.225,0.006-0.342,0
						c-0.061-0.005-0.201-0.023-0.25-0.086c-0.012-0.011-0.012-0.028-0.012-0.04C1856.438,29.913,1856.853,29.755,1857.36,29.876z"/>
					<path d="M1855.532,30.227c0.242,0.149,0.146,0.322-0.547,0.265c-0.137-0.013-0.262-0.023-0.371-0.041
						c-0.025-0.006-0.055-0.012-0.07-0.012C1854.733,30.292,1855.058,30.221,1855.532,30.227z"/>
					<path d="M1840.319,29.836c0.078,0.031-0.105,0.087-0.482,0.063c-0.111-0.012-0.406-0.04-0.57-0.149
						c-0.006-0.006-0.012-0.012-0.021-0.018C1839.833,29.761,1840.231,29.799,1840.319,29.836z"/>
					<path d="M1728.3,37.641c0.404,0.028,0.945,0.063,1.346,0.092c-0.387,0.216,0.047,0.448-0.271,0.661
						c-0.619-0.043-1.156-0.081-1.334-0.265C1727.868,37.957,1728.165,37.732,1728.3,37.641z"/>
					<path d="M1725.216,37.802c0.836,0.029,1.529,0.108,1.002,0.465c-0.217-0.022-0.848-0.08-1.025-0.252
						C1725.106,37.925,1725.181,37.842,1725.216,37.802z"/>
					<path d="M1723.788,38.095c0.422,0.029,0.99,0.069,1.41,0.098c-0.006,0.045-0.184,0.232-0.42,0.459
						c-0.152-0.006-0.307-0.006-0.447-0.014c-0.189-0.015-0.611-0.049-0.736-0.176C1723.476,38.336,1723.681,38.175,1723.788,38.095z"/>
					<path d="M1718.896,38.002c1.426-0.014,2.926,0.106,4.002,0.313c-0.516,0.233-1.514,0.503-3.354,0.457
						c-0.625-0.08-0.813-0.271-1.584-0.311c-0.303-0.018-0.627,0-0.904-0.039c-0.047-0.01-0.117-0.018-0.139-0.029
						c-0.025-0.007-0.025-0.018-0.039-0.023C1716.856,38.33,1717.12,38.02,1718.896,38.002z"/>
					<path d="M1713.681,38.009c0.105-0.052,0.375-0.188,1.289-0.018c0.258,0.047,0.258,0.047,0.879,0.416
						c-0.342,0.026-0.627,0.084-0.982,0.104c-0.307,0.018-0.463,0.015-0.727-0.003c-0.158-0.009-0.313-0.022-0.455-0.046
						c-0.021,0-0.047-0.002-0.07-0.005C1713.663,38.308,1713.378,38.151,1713.681,38.009z"/>
					<path d="M1711.8,38.031c0.088,0.115,0.352,0.225,0.391,0.345c0.021,0.106-0.156,0.207-0.232,0.247
						c-0.463-0.029-0.732-0.132-1.168-0.173c-0.027,0-0.076-0.006-0.111-0.006C1710.868,38.146,1711.083,38.012,1711.8,38.031z"/>
					<path d="M1707.733,38.049c-0.338,0.034-0.566,0.04-0.996,0.015c-0.818-0.066-1.104-0.198-1.197-0.268
						c-0.119-0.086-0.061-0.152-0.018-0.195C1706.647,37.478,1708.063,37.71,1707.733,38.049z"/>
					<path d="M1425.616,37.865c-0.613-0.146-0.613-0.146-0.605-0.179c0.281,0.046,0.617,0.043,0.924,0.055
						c0.732,0.012,1.074,0.02,1.037,0.121c-0.422,0.055-0.686,0.155-1.143,0.204c-0.342,0.034-0.447-0.021-0.482-0.041
						c-0.018-0.011-0.037-0.026-0.049-0.034C1425.772,37.974,1425.983,37.948,1425.616,37.865z"/>
					<path d="M1431.771,37.744c-0.371-0.021-0.617-0.075-0.695-0.109c-0.16-0.065,0.096-0.105,0.768-0.114
						C1432.382,37.732,1432.03,37.75,1431.771,37.744z"/>
					<polygon points="1417.071,37.555 1417.813,37.587 1417.765,37.768 1417.024,37.736 "/>
					<path d="M1413.44,37.498c0.297,0.039,0.518,0.063,0.859,0.079c0.396,0.013,0.803-0.005,1.203,0.023
						c0.318,0.023,0.494,0.058,0.705,0.104c-0.789,0.018-0.93,0.098-0.459,0.27c-0.729-0.063-1.148,0-1.461,0.046
						c-0.41,0.058-0.768,0.109-1.658,0.016c-0.031-0.004-0.074-0.01-0.096-0.013c-0.107-0.092-0.254-0.215-0.363-0.304
						c0.363-0.05,0.822-0.003,1.164-0.066C1413.511,37.621,1413.47,37.543,1413.44,37.498z"/>
					<path d="M1412.534,36.516c-0.217,0.003-0.426,0-0.627-0.012c-0.383-0.017-0.846-0.058-1.131-0.213
						c-0.072-0.04-0.119-0.086-0.166-0.129C1411.577,36.005,1412.638,36.246,1412.534,36.516z"/>
					<path d="M1405.39,37.641c-0.119,0.023-0.342,0.061-0.582,0.052c-0.102-0.006-0.201-0.014-0.279-0.052
						c-0.041-0.022-0.082-0.046-0.059-0.068C1404.522,37.522,1404.847,37.446,1405.39,37.641z"/>
					<path d="M1348.181,38.829c-0.195-0.008-0.766-0.028-1.016-0.146c-0.049-0.028-0.08-0.06-0.092-0.092
						c0.043-0.008,0.082-0.02,0.129-0.025c0.578-0.083,1.633-0.017,1.428,0.264C1348.478,38.824,1348.331,38.832,1348.181,38.829z"/>
					<path d="M1327.063,36.464l-0.031,0.184c-0.129,0.021-0.201,0.023-0.387,0.018c-0.074-0.007-0.24-0.013-0.381-0.087
						c-0.057-0.025-0.102-0.052-0.109-0.083c0.008-0.003,0.008-0.123,0.359-0.136C1326.61,36.354,1326.61,36.354,1327.063,36.464z"/>
					<path d="M1312.075,38.482c-0.359-0.015-0.561-0.025-0.863-0.08c-0.209-0.035-0.303-0.052-0.707,0.008
						c-0.031,0.003-0.068,0.013-0.094,0.018c-0.072-0.041-0.23-0.138,0.236-0.178C1311.126,38.209,1312.476,38.273,1312.075,38.482z"/>
					<path d="M1306.644,37.54c-0.068-0.003-0.146-0.005-0.221-0.008c-0.012,0-0.02,0-0.031,0
						c0.025-0.139,0.277-0.21,0.861-0.244c0.111,0.057,0.258,0.138,0.373,0.194C1307.276,37.485,1307.005,37.549,1306.644,37.54z"/>
					<path d="M1307.157,38.135l-0.416,0.348c-0.145-0.096-0.631-0.112-0.832-0.195c-0.156-0.061-0.072-0.129,0.033-0.192
						C1306.312,38.106,1306.79,38.12,1307.157,38.135z"/>
					<path d="M1305.71,36.765c-0.098-0.025-0.178-0.052-0.25-0.08c-0.295-0.132-0.262-0.158,0.324-0.571
						c0.797,0.065,1.232,0.104,1.568,0.178C1307.606,36.349,1308.62,36.76,1305.71,36.765z"/>
					<path d="M1305.183,37.399c-0.623-0.023-1.037-0.034-1.189-0.105c-0.09-0.044-0.039-0.089-0.02-0.118
						c0.256,0.012,0.588,0.023,0.848,0.032L1305.183,37.399z"/>
					<polygon points="1296.171,37.189 1297.009,37.219 1296.991,37.417 1296.153,37.389 "/>
					<path d="M1295.845,36.618c-0.076-0.022-0.145-0.045-0.205-0.068c-0.207-0.098-0.33-0.293,0.627-0.282
						C1296.765,36.412,1296.813,36.63,1295.845,36.618z"/>
					<path d="M1297.317,38.077c0.012,0.006,0.027,0.012,0.043,0.015c0.424,0.127,0.527,0.287-0.27,0.267
						c-0.164-0.006-0.33-0.011-0.484-0.025c-0.021-0.003-0.063-0.003-0.088-0.009C1296.476,38.187,1296.714,38.111,1297.317,38.077z"/>
					<path d="M1294.743,37.328c-0.281-0.009-0.447-0.04-0.504-0.063c-0.152-0.06,0.205-0.112,0.32-0.123
						c0.205,0.028,0.412,0.061,0.564,0.103C1295.347,37.313,1295.101,37.337,1294.743,37.328z"/>
					<path d="M1293.644,38.049c0.359,0.152-0.219,0.188-0.666,0.175c-0.271-0.012-0.447-0.031-0.531-0.065
						c-0.049-0.018-0.049-0.038-0.035-0.058C1292.839,38.106,1293.202,38.035,1293.644,38.049z"/>
					<path d="M1290.95,36.458c-0.025,0.074-0.111,0.111-0.277,0.115c-0.385-0.023-0.725-0.179-0.82-0.225
						c-0.07-0.034-0.137-0.068-0.143-0.103C1289.716,36.165,1289.948,36.223,1290.95,36.458z"/>
					<path d="M1290.692,37.059c0.793-0.055,1.316-0.066,2.197,0.025c-0.078,0.315-0.891,0.305-3.32,0.27
						c-0.309-0.101-0.762-0.172-1.014-0.287c-0.092-0.04-0.141-0.086-0.178-0.132C1289.288,37.13,1289.776,37.121,1290.692,37.059z"/>
					<path d="M1291.567,38.164c-0.336,0.063-0.549,0.071-0.654,0.068c-0.049-0.003-0.164-0.009-0.248-0.043
						c-0.061-0.022-0.082-0.049-0.061-0.078C1290.644,38.072,1290.962,37.971,1291.567,38.164z"/>
					<path d="M1279.47,42.635l-0.451-0.209c2.9,0.24,6.105,0.103,8.977,0.378c0.285-0.065,0.213-0.172,0.531-0.229
						c0.123-0.023,0.459-0.087,2.279,0.263c0.365,0.075,0.391,0.136,0.438,0.265c-3.922-0.049-7.867-0.017-11.787-0.108
						c0.043-0.038,0.045-0.099-0.061-0.133c-0.184-0.063-0.523-0.087-0.752-0.138c-0.035-0.012-0.072-0.025-0.107-0.035
						C1278.755,42.611,1278.995,42.62,1279.47,42.635z"/>
					<path d="M1276.196,42.426c0.49,0.137,1.303,0.2,1.641,0.372c0.246,0.124-0.207,0.199-0.432,0.235
						c0.117-0.131,0.033-0.188-0.695-0.146c-0.908,0.049-1.191-0.05-1.285-0.084C1275.294,42.759,1275.374,42.494,1276.196,42.426z"/>
					<path d="M1274.14,42.27c0.236,0.213,0.41,0.489-0.648,0.463c-0.566-0.021-1.014-0.109-1.168-0.164
						c-0.023-0.006-0.045-0.014-0.051-0.022c-0.092-0.041-0.072-0.104,1.031-0.018C1273.323,42.379,1273.552,42.308,1274.14,42.27z"/>
					<path d="M1270.872,42.609c-0.104,0.16-1.424,0.134-1.984,0.114c-0.047,0-4.203-0.175-4.861-0.351
						c-0.391-0.109,0.045-0.293,0.885-0.299c1.436-0.017,2.604,0.189,3.959,0.242c0.578,0.014,1.182-0.029,1.721,0.052
						C1270.827,42.399,1270.989,42.426,1270.872,42.609z"/>
					<path d="M1258.065,38.457c2.137,0.105,2.137,0.105,3.273-0.07c2.229,0.294,4.879,0.199,7.248,0.359
						c-2.619,0.066-5.232,0.127-7.863,0.106c-0.111,0.081-0.264,0.187-0.379,0.268c-2.346-0.164-2.346-0.164-3.256-0.472
						C1257.378,38.591,1257.767,38.515,1258.065,38.457z"/>
					<path d="M1229.251,39.186c2.998,0.086,3.607-0.293,4.449-0.827c0.076,0.173,0.307,0.402,0.537,0.565
						c0.482-0.171,1.125-0.401,1.596-0.573c1.014,0.055,1.014,0.055,3.35-0.113c1.736,0.346,1.779,0.386,2.086,0.713
						c0.455-0.149,0.455-0.149,3.318-0.557c2.014,0.227,2.227,0.252,2.328,0.74c4.604,0.741,10.746,0.167,15.352,0.913
						c1.936-0.166,3.885,0.081,5.814-0.018c-0.094,0.107-0.225,0.251-0.318,0.356c-0.402,0.023-0.934,0.052-1.32,0.078
						c-0.014,0.08-0.014,0.189-0.023,0.267c2.004,0.373,2.004,0.373,2.238,0.672c-3.83-0.074-4.926-0.247-5.955-0.601
						c-0.646,0.251-0.646,0.563-1.455,0.802c-5.268-0.579-11.232-0.603-16.66-1.062c-0.125,0.074-0.297,0.177-0.42,0.252
						c-0.158-0.086-0.355-0.189-0.512-0.272c-1.592,0.123-3.326,0.065-4.895,0.209c-0.486,0.635-0.486,0.635,0.191,1.071
						c4.631,0.204,5.01,0.192,6.424,0.149c0.424,0.101,0.967,0.233,1.387,0.336c-0.162,0.075-0.373,0.173-0.525,0.247
						c-4.693-0.258-4.693-0.258-6.99-0.104c2.15,0.265,2.15,0.265,3.322,0.655c-0.301,0.037-0.707,0.086-1.002,0.12
						c43.904,1.332,69.951,2.148,97.232,3.139c-0.063-0.003-0.139-0.003-0.201-0.006c-29.615-0.947-69.48-1.736-98.705-3.179
						c-0.678-0.069-2.088-0.207-3.936-0.643c-0.932,0.071-1.664,0.235-2.664,0.27c-0.625,0.026-1.223-0.075-1.475-0.115
						c0.613-0.071,0.693-0.089,0.73-0.299c0.029-0.212,0.254-0.235,0.926-0.304c-0.371,0.017-0.857,0.04-1.232,0.058
						c0.195-0.371-0.729-0.696-0.879-1.052c0.395-0.006,1.008-0.017,1.264-0.086c0.867-0.242-0.637-0.735-2.523-0.686
						c-0.09-0.325-0.006-0.445,0.371-0.55c-0.26-0.068-0.449-0.097-1.055-0.154l-0.182-0.016l0.131,3.271
						c-0.111-0.987-0.256-2.303-0.369-3.29c-0.264-0.026-0.611-0.063-0.879-0.087c0.055-0.06,0.137-0.141,0.197-0.204
						c0.271-0.025,0.637-0.063,0.908-0.089c-0.025-0.123-0.014-0.262,0.018-0.401L1229.251,39.186z"/>
					<path d="M1261.845,42.447c-0.27,0.053-0.604,0.07-1.082,0.058c-0.156-0.005-0.627-0.022-0.863-0.12
						c-0.059-0.029-0.096-0.061-0.119-0.092C1260.331,42.195,1261.737,42.212,1261.845,42.447z"/>
					<path d="M1248.7,42.89c-0.039,0.109-0.158,0.438-1.992,0.394c-0.201-0.008-0.627-0.022-1.145-0.095
						c-0.047-0.003-0.105-0.011-0.15-0.017C1245.917,42.937,1246.966,42.919,1248.7,42.89z"/>
					<polygon points="782.385,51.022 783.22,51.028 783.355,51.209 782.525,51.201 "/>
					<polygon points="784.793,51.511 783.739,51.212 785.012,51.226 "/>
					<path d="M892.957,48.231c-0.213,0.167-0.259,0.301-0.302,0.626c-0.028,0.256-0.064,0.545-0.507,0.735
						c-0.023,0.011-0.064,0.023-0.088,0.031C891.017,49.153,890.564,48.269,892.957,48.231z"/>
					<path d="M891.753,47.382c0.224-0.089,0.926-0.096,1.179,0.115c-0.364,0.021-0.849,0.051-1.208,0.073
						C891.694,47.539,891.59,47.45,891.753,47.382z"/>
					<path d="M892.403,50.833c0.007,0.109,0.111,0.172,0.341,0.276c0.071,0.028,0.178,0.06,0.166,0.1
						c-0.011,0.05-0.283,0.066-0.619,0.087c-0.1-0.021-0.194-0.044-0.277-0.073C891.636,51.094,891.436,50.845,892.403,50.833z"/>
					<path d="M892.579,49.725c0.141,0.109,0.26,0.232-0.047,0.238c-0.276-0.009-0.454-0.063-0.5-0.077
						C891.954,49.86,891.624,49.73,892.579,49.725z"/>
					<path d="M1182.894,44.872l-0.836,0.065c0.063-0.222,0.08-0.301,0.807-0.25
						C1182.874,44.745,1182.88,44.814,1182.894,44.872z"/>
					<path d="M1180.63,44.171c-0.254-0.115-0.701-0.197-0.984-0.31c-0.248-0.092-0.113-0.136,0.221-0.179
						c0.344,0.104,0.154,0.287,0.947,0.322c0.109,0.003,0.217-0.007,0.33-0.007c-0.117,0.109-0.283,0.248-0.408,0.351
						C1180.765,44.32,1180.825,44.251,1180.63,44.171z"/>
					<path d="M1227.351,47.557c-0.398-0.018-0.799-0.035-1.211-0.049c-0.029,0-0.072,0-0.102,0
						c-0.043-0.256,0.275-0.267,1.361-0.178C1227.368,47.404,1227.376,47.479,1227.351,47.557z"/>
					<path d="M1224.237,48.157c-0.057-0.003-0.092-0.018-0.115-0.023c-0.051-0.023-0.082-0.04-0.094-0.061
						c-0.029-0.095,0.141-0.246,0.318-0.215C1224.581,47.903,1224.499,48.145,1224.237,48.157z"/>
					<path d="M1221.86,46.927c0.424,0,0.77-0.085,1.223-0.054c0.078,0.52,0.086,0.54-0.328,0.629
						c-1.426-0.038-1.889-0.167-1.957-0.19c-0.236-0.079,0.148-0.108,0.318-0.12c0.111,0.029,0.381,0.109,0.66,0.115
						C1222.177,47.314,1222.478,47.141,1221.86,46.927z"/>
					<path d="M1212.958,47.318c-0.104,0.006-0.502,0.022-0.801-0.08c-0.023-0.009-0.047-0.023-0.072-0.029
						c0.813-0.097,1.158-0.31,1.959-0.408c0-0.028-0.006-0.063-0.012-0.092c1.52,0.092,2.145,0.251,2.557,0.356
						c-0.033-0.299,0.377-0.281,3.006-0.187c0.223,0.006,0.436,0,0.65,0.003c0.016,0.184,0.033,0.367,0.059,0.551
						c-2.6-0.098-3.023-0.132-5.779-0.333C1214.009,47.175,1213.585,47.283,1212.958,47.318z"/>
					<polygon points="1214.173,47.909 1212.946,47.875 1212.923,47.694 1214.149,47.729 "/>
					<path d="M1234.448,42.999c0.066-0.095,0.146-0.109,0.293-0.138c0.109,0.049,0.184,0.101,0.254,0.155
						c-0.135,0.086-0.322,0.195-0.457,0.278C1234.509,43.206,1234.472,43.089,1234.448,42.999z"/>
					<path d="M1261.485,45.032c0.184,0.018,0.398,0.012,0.795-0.011c1.752-0.109,1.676,0.079,1.648,0.174
						c-0.373-0.068-0.646-0.079-1.227-0.054c-0.344,0.017-0.711,0.034-1.117-0.08C1261.548,45.053,1261.517,45.038,1261.485,45.032z"/>
					<path d="M1270.438,48.501c-1.025,0.058-1.24-0.028-1.438-0.115c-0.566-0.229-0.289-0.511,0.67-0.7
						c-0.025,0.077-0.02,0.155,0.203,0.17c0.646,0.009,1.367-0.153,1.943,0.009c0.307,0.089,0.313,0.109,0.307,0.629
						C1271.493,48.44,1271.146,48.461,1270.438,48.501z"/>
					<path d="M1278.456,46.035c-1.088-0.044-1.555-0.141-1.746-0.214c-0.143-0.054-0.154-0.089-0.164-0.134
						c1.334-0.075,2.666-0.029,4.09,0.025C1280.776,46.063,1279.007,46.049,1278.456,46.035z"/>
					<path d="M1280.187,46.91c-0.17-0.114-0.338-0.117-0.711-0.075c-0.295,0.032-0.598,0.055-0.842-0.042
						c-0.006,0-0.275-0.216,0.787-0.278c0.049,0.034,0.189,0.063,0.572,0.135C1280.704,46.778,1280.917,46.854,1280.187,46.91z"/>
					<path d="M1228.817,38.209c0.156,0.248,0.092,0.388-0.713,0.374c-0.152-0.006-0.307-0.012-0.447-0.023
						c-0.021-0.003-0.045-0.006-0.068-0.011c0-0.112,0-0.265-0.006-0.377L1228.817,38.209z"/>
					<path d="M1224.642,37.997c0.658,0.215,0.223,0.229,0,0.227c-0.383-0.015-0.674-0.065-0.754-0.097
						C1223.687,38.06,1223.944,38.015,1224.642,37.997z"/>
					<path d="M1071.159,38.887c-0.07-0.017-0.129-0.031-0.189-0.052c-0.113-0.04-0.119-0.074-0.006-0.097
						c0.262-0.058,1.461-0.04,1.434,0.068C1072.022,38.829,1071.526,38.864,1071.159,38.887z"/>
					<path d="M1001.851,41.099c-0.207-0.227,0.021-0.345,0.734-0.368c-0.006,0.146-0.086,0.305-0.684,0.365
						C1001.89,41.096,1001.868,41.099,1001.851,41.099z"/>
					<path d="M1018.407,42.185c-0.52-0.087-0.613-0.104-0.543-0.256c0.695-0.066,1.285-0.199,2.119-0.184
						c0.652,0.011,1.041,0.148,1.299,0.243c-0.824,0.061-1.402,0.132-1.77,0.31c-0.51,0.245-0.307,0.516-0.461,0.771
						c-0.504-0.021-0.896-0.04-1.205-0.108c-0.324-0.075-0.361-0.17-0.385-0.299c-0.033-0.207-0.105-0.259-0.34-0.365
						c0.148-0.012,0.34-0.018,0.783,0.037c0.207,0.029,0.359,0.074,0.594,0.093c0.146,0.008,0.191-0.013,0.232-0.036
						C1018.946,42.284,1018.536,42.206,1018.407,42.185z"/>
					<path d="M1021.87,39.763c0.336,0.153,0.545,0.204,1.313,0.279c-0.332,0.074-0.508,0.098-0.781,0.095
						c-0.252-0.016-0.393-0.037-0.789-0.21c-0.141-0.061-0.564-0.247-1.484-0.213c-0.02,0.003-0.037,0.003-0.047,0.003
						c-0.602-0.738-0.602-0.738,0.176-0.942c-0.201-0.082-0.219-0.089-0.641-0.131c-0.826-0.087-0.85-0.118-0.82-0.273
						c0.494-0.094,0.908-0.089,1.625,0.023c0.793,0.121,0.961,0.126,1.436,0.132c-0.025,0.339-1.191,0.586-1.398,0.907
						C1021.247,39.533,1021.495,39.594,1021.87,39.763z"/>
					<path d="M1019.833,39.835c0.211,0.071,0.43,0.081,0.643,0.086c0.184,0.003,0.361,0.003,0.527-0.005
						c-0.109,0.344,0.787,0.683,0.211,1.033c-0.119,0.077-0.498,0.311-2.301,0.253c-0.012,0-0.023,0-0.029,0
						c-0.254-0.259-0.254-0.374-0.217-0.66c0.051-0.356-0.027-0.534-0.273-0.856C1019.126,39.651,1019.433,39.702,1019.833,39.835z"/>
					<path d="M1018.782,43.441c-0.131,0.022-0.193,0.029-0.395,0.022c-0.066,0-0.238-0.005-0.428-0.074
						c-0.357-0.133-0.055-0.243,0.324-0.241c0.129,0.032,0.299,0.081,0.428,0.108L1018.782,43.441z"/>
					<path d="M1017.368,40.3c-0.023,0.063-0.225,0.096-0.293,0.106c-0.273,0.043-0.615,0.049-0.896,0.089
						c-0.02,0-0.043,0.006-0.057,0.006c-0.049-0.195-0.756-0.322-1.023-0.488c0.236-0.005,0.736-0.012,1.27,0.023
						C1017.452,40.11,1017.429,40.174,1017.368,40.3z"/>
					<path d="M1016.644,40.875c-0.123,0.021-0.211,0.025-0.393,0.021c-0.072-0.002-0.25-0.005-0.424-0.076
						c-0.084-0.032-0.16-0.061-0.16-0.095c-0.008-0.244,0.688-0.087,0.918-0.034L1016.644,40.875z"/>
					<polygon points="1015.14,43.852 1014.269,43.838 1014.194,43.64 1015.071,43.654 "/>
					<path d="M1014.704,43.936c0.137,0.264-0.146,0.442-0.965,0.617c-0.018,0.006-0.047,0.009-0.066,0.014
						C1013.71,43.995,1013.71,43.936,1014.704,43.936z"/>
					<path d="M1030.767,39.995c0.545,0.021,0.688,0.023,1.184,0.09c0.531,0.065,0.934,0.175,1.449,0.246
						c-0.166,0.342,0.33,0.688,0.018,1.034c-0.195,0.212-0.885,0.296-1.252,0.342l-0.904-0.109
						C1031.142,41.063,1030.876,40.529,1030.767,39.995z"/>
					<path d="M1164.694,49.488c0.627,0.006,1.371,0.058,1.359,0.302c-0.111,0.01-0.213,0.01-0.324,0.01
						c-0.123-0.006-0.354-0.013-0.537-0.087C1165.003,49.644,1164.966,49.552,1164.694,49.488z"/>
					<polygon points="1036.931,37.761 1036.585,37.939 1035.651,37.739 "/>
					<path d="M1019.396,37.448c2.088-0.151,2.088-0.151,2.973-0.146c0.061,0.139,0.398,0.253,0.514,0.391
						c-0.67,0.068-0.787,0.081-1.057,0.419c0.43,0.013,0.93,0.018,1.381,0.029c-0.838,0.04-1.643,0.092-2.355,0.184
						c-0.117-0.068-0.264-0.16-0.375-0.235C1019.608,37.63,1019.608,37.63,1019.396,37.448z"/>
					<path d="M892.744,44.868c0.041,0.01,0.095,0.021,0.129,0.032c0.526,0.126,0.377,0.2-0.07,0.195
						c-0.224-0.003-0.335-0.026-0.372-0.04C892.272,45.009,892.379,44.946,892.744,44.868z"/>
					<path d="M982.11,47.422c1.496,0.025,3.055,0.052,4.58,0.08c-3.355-0.052-6.742-0.104-10.16-0.151
						C978.392,47.372,980.192,47.398,982.11,47.422z"/>
					<path d="M792.203,51.678c-1.473-0.092-1.473-0.092-1.686-0.156c-0.16-0.054-0.183-0.114-0.2-0.149
						C791.525,51.367,792.073,51.453,792.203,51.678z"/>
					<path d="M789.839,50.253c0.549,0.187,1.067,0.362,0.377,0.38c-0.028,0.002-0.065,0-0.087,0.002
						c-0.025-0.015-0.055-0.022-0.083-0.034c-0.012-0.004-0.024-0.009-0.036-0.012c-0.006-0.003-0.025-0.009-0.035-0.014
						c-0.024-0.007-0.048-0.018-0.071-0.023c-0.018-0.006-0.023-0.012-0.048-0.018C789.338,50.345,789.327,50.264,789.839,50.253z"/>
					<path d="M788.915,49.038c-0.584-0.003-0.879-0.008-1.097-0.065c-0.224-0.063-0.2-0.142-0.166-0.311
						c0.04-0.185,0.083-0.355-1.208-0.298c-0.029-0.038-0.076-0.094-0.071-0.128c0.055-0.204,1.067-0.151,1.08-0.149
						c0.507,0.093,0.642,0.248,0.813,0.498C788.429,48.814,788.537,48.936,788.915,49.038z"/>
					<path d="M785.625,46.101c0.671,0.534,0.459,1.125,1.927,1.611c-0.5,0.238-0.676,0.313-1.219,0.333
						c-0.107-0.003-0.295-0.009-0.531-0.049c-0.012-0.003-0.695-0.155,0.19-0.204c0.541-0.029,0.518-0.043,0.218-0.224
						c-1.48-0.88-1.48-0.88-1.551-0.968c-0.036-0.052-0.06-0.109-0.06-0.161C784.576,46.188,785.341,46.124,785.625,46.101z"/>
					<path d="M783.539,50.385c0.07,0.021,0.14,0.041,0.205,0.063c0.019,0.01,0.043,0.019,0.064,0.023
						c0.343,0.133,0.425,0.235,0.461,0.374c-0.313-0.006-1.145-0.015-1.602-0.154c-0.355-0.115-0.355-0.259-0.343-0.316
						C782.683,50.374,783.173,50.379,783.539,50.385z"/>
					<path d="M760.15,49.3c-0.046,0.08-0.11,0.188-0.165,0.27l-0.447-0.095C759.426,49.325,759.62,49.271,760.15,49.3z"/>
					<path d="M757.416,47.109c0.071,0.034,0.183,0.065,0.171,0.108c-0.019,0.049-0.366,0.072-0.571,0.083
						c-0.106-0.018-0.19-0.046-0.273-0.071c-0.021-0.009-0.058-0.021-0.081-0.026c-0.036-0.018-0.932-0.358,0.448-0.278
						C757.175,46.987,757.285,47.049,757.416,47.109z"/>
					<path d="M756.433,45.762c0.016,0.006,0.029,0.012,0.041,0.018c0.119,0.052,0.111,0.08,0.036,0.167
						c-0.114,0.108-0.12,0.184,0.099,0.32c-0.323,0-0.595,0.047-0.914,0.052c-0.07-0.002-0.141-0.011-0.188-0.022
						c-0.047-0.012-0.072-0.029-0.106-0.04c0.112-0.047,0.059-0.092-0.154-0.207c-0.129-0.081-0.281-0.17-0.224-0.232
						C755.07,45.75,755.913,45.604,756.433,45.762z"/>
					<polygon points="751.604,47.065 751.746,47.249 750.544,47.238 750.401,47.055 "/>
					<path d="M748.988,45.438c0.342-0.161,0.937-0.075,0.943-0.072c0.235,0.04,0.2,0.282-0.795,0.282
						c-0.153-0.007-0.408-0.012-0.609-0.069c-0.036-0.012-0.082-0.035-0.116-0.046C748.734,45.532,748.846,45.504,748.988,45.438z"/>
					<path d="M231.698,43.573c-0.377,0.029-0.672,0.018-1.886-0.092c-0.517-0.052-1.032-0.095-1.58-0.12
						c-0.519,0.212-1.145,0.224-3.364,0.167c-1.311-0.033-1.716-0.013-2.171,0.057c-0.046-0.221-0.11-0.232-0.216-0.253
						c-0.259,0.018-0.342,0.087-0.614,0.098c-0.164,0.007-0.271-0.006-0.399-0.055c0.755-0.428-2.382-0.376-3.313-0.629
						c-0.059-0.02-0.131-0.045-0.178-0.063c0.991,0.009,6.095,0.08,8.7,0.379c0.167-0.063,0.396-0.155,1.379-0.149
						c1.31,0.006,2.523,0.12,3.784,0.173C232,43.255,232.264,43.531,231.698,43.573z"/>
					<path d="M215.066,42.626c-0.024-0.006-0.049-0.012-0.07-0.015c0.67-0.106,1.896-0.036,2.711,0.244
						C216.773,42.821,215.878,42.774,215.066,42.626z"/>
					<path d="M233.991,40.856c0.019-0.022,0.089-0.086,0.63,0.069c-0.059,0.035-0.142,0.072-0.294,0.069
						c-0.094,0-0.165-0.018-0.218-0.038C234.02,40.929,233.985,40.88,233.991,40.856z"/>
					<path d="M724.397,51.169c-0.312,0.407-0.312,0.407,0.579,0.654c-0.426,0.015-0.844,0.032-1.273,0.032
						c-0.343-0.007-0.621-0.021-1.014-0.149c-0.089-0.028-0.165-0.057-0.243-0.089C723.573,51.574,723.343,51.226,724.397,51.169z"/>
					<path d="M719.021,46.565c0.266-0.051,0.408-0.08,0.583-0.08c0.294,0.006,0.513,0.111,0.631,0.172
						c-0.365,0.035-0.683,0.092-1.108,0.096c-0.094-0.004-0.27-0.01-0.395-0.044c-0.078-0.023-0.099-0.045-0.135-0.068
						C718.75,46.617,718.892,46.595,719.021,46.565z"/>
					<path d="M715.272,44.596c1.108-0.068,3.95,0.477,3.147,0.813c-0.177-0.081-0.447-0.201-1.16,0.058
						c-0.237,0.089-0.425,0.146-0.644,0.076c-0.045-0.014-0.082-0.028-0.116-0.045c0.542-0.035,0.471-0.058-0.024-0.139
						c-0.496-0.08-0.572-0.104-0.59-0.16c0.814,0.029,0.973-0.106,1.049-0.173c-0.849-0.08-1.19-0.29-1.932-0.399
						C715.084,44.613,715.168,44.603,715.272,44.596z"/>
					<path d="M715.227,45.848c-0.224,0.044-0.353,0.052-0.577,0.052c-0.685-0.011-1.338-0.201-2.052-0.431
						c-0.017-0.006-0.042-0.012-0.047-0.015C713.858,45.469,714.766,45.604,715.227,45.848z"/>
					<path d="M711.459,51.597c-0.902-0.068-1.921,0.233-2.692,0.006c-0.03-0.009-0.066-0.023-0.095-0.028
						c0.66-0.038,1.249-0.142,1.968-0.135C711.195,51.447,711.359,51.542,711.459,51.597z"/>
					<polygon points="709.614,50 709.786,50.198 708.602,50.185 708.437,49.989 "/>
					<path d="M710.364,50.851c-0.578-0.029-0.684,0.112-1.02,0.169c-0.414-0.06-0.896-0.135-1.239-0.25
						c-0.472-0.16-0.501-0.33-0.517-0.413C709.367,50.296,709.975,50.561,710.364,50.851z"/>
					<polygon points="695.558,44.906 695.481,44.889 695.469,44.797 "/>
					<path d="M635.906,43.55c-3.41-0.034-6.77-0.068-10.103-0.103C629.109,43.481,632.526,43.516,635.906,43.55z"/>
					<path d="M622.226,43.413c-93.73-0.939-157.455-1.608-208.651-2.24C465.42,41.811,529.933,42.488,622.226,43.413z"/>
					<path d="M393.935,18.163c-0.326,0.08-0.985,0.215-1.852,0.215c-0.207-0.005-0.689-0.018-1.096-0.167
						c-0.159-0.06-0.254-0.126-0.343-0.188C390.991,17.962,393.633,17.792,393.935,18.163z"/>
					<path d="M386.625,19.722c0.047,0.216-0.159,0.294-1.408,0.288c-0.59-0.012-1.173-0.034-1.75-0.058
						c-0.491-0.018-0.95-0.034-1.279-0.028c-0.237,0.008-0.501,0.068-0.909,0.165c-0.359,0.09-0.463,0.104-0.825,0.147
						c-0.271,0.031-0.753,0.028-0.955,0.025c-0.194-0.103-0.589-0.166-0.895-0.246c-0.26-0.069-0.294-0.121-0.366-0.219
						c0.573-0.141,1.12-0.253,2.559-0.264c0.83-0.01,2.122,0.063,2.604,0.086C384.863,19.696,385.475,19.704,386.625,19.722z"/>
					<path d="M377.105,17.729c0.56,0,3.383,0.026,4.208,0.435c-1.237,0.299-2.623,0.445-4.113,0.439
						c-0.573-0.018-1.626-0.046-2.712-0.339c-0.118-0.029-0.248-0.074-0.354-0.106C376.021,17.755,376.139,17.729,377.105,17.729z"/>
					<path d="M359.105,19.429c0.565,0.127,0.772,0.219,0.801,0.351c0.048,0.23-0.636,0.425-0.602,0.655
						c-0.335-0.023-1.037-0.072-1.521-0.253C356.358,19.659,358.822,19.449,359.105,19.429z"/>
					<path d="M355.499,21.956c0.306-0.025,0.583-0.005,0.788,0.012c0.089,0.109,0.219,0.259,0.308,0.371
						c-1.179-0.018-1.532-0.026-1.845-0.13c-0.169-0.061-0.218-0.127-0.241-0.172C354.883,22.037,355.167,21.985,355.499,21.956z"/>
					<path d="M317.681,18.074c0.371-0.181,1.144-0.29,1.531-0.466c1.239,0.115,1.416,0.081,3.597-0.327
						c2.233,0.175,3.979-0.2,5.987-0.272c0.862,0.16,1.363,0.416,2.5,0.505c2.976,0.003,2.976,0.003,4.066-0.112
						c0.638,0.156,1.097,0.225,2.052,0.305c0.082,0.232,0.118,0.331,1.145,0.505c0.859,0.149,0.907,0.173,0.753,0.356
						c-1.91-0.045-3.661,0.144-5.517,0.184c-4.417-0.836-4.417-0.836-6.437-0.93c-2.471-0.121-4.079,0.141-4.998,0.382l-1.498-0.026
						c-0.696,0.092-1.138,0.265-1.974,0.311c-0.266,0.017-0.691,0.02-1.255-0.13C317.287,18.266,317.681,18.074,317.681,18.074z"/>
					<path d="M336.017,20.003c-0.342,0.041-0.571,0.052-1.053,0.047c-0.19-0.003-0.578-0.012-1.263-0.074
						c-0.036-0.004-0.082-0.007-0.119-0.013c-0.07-0.052-0.211-0.154,0.095-0.232C334.162,19.61,335.94,19.653,336.017,20.003z"/>
					<path d="M325.686,21.132l-1.196-0.02c-0.065-0.046-0.23-0.167,0.017-0.238
						C324.784,20.796,325.598,20.851,325.686,21.132z"/>
					<path d="M306.424,17.525c0.896-0.339,3.831-0.528,4.797,0.316c-0.401,0.111-1.114,0.232-3.147,0.203
						c-0.33-0.005-1.097-0.022-1.792-0.092c-0.065-0.005-0.141-0.018-0.194-0.022C306.046,17.839,305.988,17.689,306.424,17.525z"/>
					<path d="M298.359,21.04c-0.96,0.405-3.417,0.21-4.279,0.061c-0.076-0.012-0.164-0.029-0.234-0.04
						c1.2-0.489,5.55-0.104,5.592-0.098c0.471-0.447,2.823-0.392,4.296-0.021c-0.782,0.17-1.272,0.21-2.367,0.199
						C300.363,21.118,299.369,21.063,298.359,21.04z"/>
					<path d="M299.799,21.7c-0.596,0.089-0.992,0.112-1.634,0.102c-0.418-0.01-0.818-0.029-1.23-0.047
						c-0.061-0.003-0.142-0.006-0.203-0.008c0-0.015-0.01-0.029-0.01-0.037C296.687,21.33,298.814,21.477,299.799,21.7z"/>
					<path d="M292.384,18.887c0.022-0.241,0.235-0.29,0.736-0.348c0.377,0.127,0.377,0.127,0.189,0.563
						c2.64,0.442,4.768,0.575,9.918,0.908c-0.306,0.356-0.877,0.425-3.217,0.388c-1.551-0.021-1.886,0.008-2.434,0.071
						c-1.739-0.45-4.62-0.574-6.118-1.097c-0.101-0.035-0.213-0.084-0.302-0.115C292.207,19.24,292.349,19.165,292.384,18.887z"/>
					<path d="M290.909,19.943c0.531,0.049,0.813,0.055,1.087-0.038c0.353,0.294-0.501,0.371-1.063,0.369
						c-0.689-0.021-1.049-0.127-1.196-0.186c-0.1-0.039-0.165-0.086-0.207-0.129C289.685,19.929,290.003,19.86,290.909,19.943z"/>
					<path d="M254.203,18.731c-1.157,0.066-1.157,0.066-1.469-0.126c0.862,0.009,1.232-0.028,1.503-0.146
						c-0.112-0.012-0.271-0.023-0.378-0.034c-1.461-0.173-4.833-1.615,1.12-1.987c0.2,0.06,0.483,0.144,0.784,0.178
						c0.951,0.103,2.046,0.081,3.012,0.173c0.802,0.074,1.302,0.252,2.145,0.314c0.241,0.019,1.273,0.006,0.861-0.255
						c-0.294-0.188-1.313-0.154-1.746-0.301c1.05,0.054,2.335-0.179,3.183,0.108c1.433,0.482,1.433,0.482,2.859,0.514
						c1.893,0.026,3.766-0.111,5.67-0.031l4.426,0.311c0.448,0.04,0.53,0.08,0.673,0.154c-1.852,0.107-2.77,0.165-7.026,0.098
						c-5.199-0.08-8.954-0.135-10.845,0.293c1.201,0.164,2.77,0.123,3.865,0.351c-0.118,0.265-0.955,0.472-1.201,0.729
						c-1.828-0.061-3.29-0.365-5.164-0.399c-0.877-0.018-0.885,0.199-1.439,0.271c-0.194-0.026-0.341-0.071-0.482-0.112
						c-0.131,0.028-0.325,0.058-0.461,0.086l0.431,0.189c3.62,0.109,7.256-0.017,10.882,0.035c0.029-0.193,0.052-0.201,0.718-0.448
						c2.428,0.143,2.428,0.143,2.965,0.232c-0.143,0.117-0.448,0.227-0.389,0.353c2.179,0.34,7.061,0.408,9.141,0.438
						c7.585,0.108,7.829,0.201,8.464,0.459c-0.548,0.379-2.128,0.228-3.354,0.031c-0.235,0.044-0.235,0.044-3.708,0.204
						c-0.359-0.083-1.114-0.252-2.056-0.259c-1.02-0.011-1.97,0.109-3.002,0.086c-1.691-0.039-3.328-0.16-5.044-0.165
						c-3.908-0.019-7.803-0.075-11.711-0.063c-1.439,0.006-2.005,0.126-2.464,0.224c0.524,0.204,0.524,0.204,1.19,1.025
						c-6.312-0.015-6.312-0.015-7.008-0.046c-0.607-0.405-1.137-0.606-2.352-0.595c-0.012,0.003-0.036,0-0.051,0.003
						c-0.12-0.262,0.876-0.469,0.682-0.738c-0.029-0.037-0.294-0.058-0.429-0.086c-0.759-0.155-0.873-0.264-1.403-0.778
						C250.766,19.32,252.723,19.133,254.203,18.731z"/>
					<path d="M265.036,18.384c-0.144-0.02-0.144-0.02-0.531,0.075c-0.171,0.04-0.248,0.037-0.4-0.018
						c-0.013-0.006-0.023-0.012-0.047-0.021c-0.03-0.017-0.071-0.04-0.101-0.057C264.793,18.252,264.882,18.237,265.036,18.384z"/>
					<polygon points="266.249,27.148 265.742,27.136 265.566,26.958 266.071,26.971 "/>
					<path d="M257.225,23.314c-0.289-0.037-0.619-0.032-1.143-0.02c-0.537,0.011-0.968,0.017-1.243-0.078
						c-0.129-0.043-0.178-0.095-0.224-0.146c0.248,0.063,0.412,0.086,0.712,0.095c0.448,0.006,0.866-0.054,1.327-0.02
						C256.937,23.169,257.119,23.261,257.225,23.314z"/>
					<path d="M252.193,23.119c0.459,0.003,0.872-0.078,1.348-0.043c0.36,0.022,0.524,0.093,0.708,0.178
						c-1.025-0.058-2.251,0.075-3.1-0.155c0.53-0.114,0.2-0.166-0.661-0.275c-0.437-0.057-1.037-0.135-1.357-0.246
						c-0.199-0.075-0.224-0.133-0.234-0.176c1.267-0.043,4.349-0.089,5.463,0.396c-1.032-0.009-1.238,0.039-2.399,0.318
						C252.045,23.116,252.115,23.116,252.193,23.119z"/>
					<path d="M244.902,24.618c0.14,0.123,0.199,0.27-0.326,0.262c-0.064,0-0.122-0.003-0.194-0.003
						c-0.012-0.003-0.023,0-0.03-0.003C244.063,24.621,244.488,24.595,244.902,24.618z"/>
					<path d="M240.834,33.736c0.389,0.017,1.203,0.187,0.706,0.263l-1-0.206
						C240.551,33.771,240.563,33.724,240.834,33.736z"/>
					<path d="M234.28,36.271c-0.189-0.003-0.378-0.008-0.566-0.014c-0.023,0.003-0.061,0-0.082,0
						c-0.083-0.061-0.195-0.146-0.173-0.218c0.065-0.219,1.41-0.023,1.422-0.018C234.893,36.021,235.563,36.291,234.28,36.271z"/>
					<path d="M232.429,29.554c-0.482-0.068-0.884,0.023-0.884,0.023c-0.182,0.047-0.325,0.068-0.501,0.006
						c-0.057-0.02-0.1-0.04-0.146-0.063C231.002,29.479,232.04,29.331,232.429,29.554z"/>
					<path d="M230.041,29.595c-0.124-0.005-0.289-0.052-0.412-0.092c-0.006-0.003-0.025-0.006-0.041-0.012
						c0.283-0.111,0.464-0.089,0.578-0.049c0,0,0.005,0.003,0.011,0.006C230.33,29.522,230.201,29.595,230.041,29.595z"/>
					<path d="M238.169,22.462c-2.533-0.058-3.212-0.075-3.855-0.333c-0.094-0.038-0.175-0.081-0.248-0.121
						C237.639,22.318,237.639,22.318,238.169,22.462z"/>
					<path d="M233.053,18.844c0.152,0.087,0.367,0.197,0.52,0.286l-0.542-0.014c-0.065-0.022-0.143-0.049-0.189-0.072
						C232.488,18.89,232.901,18.857,233.053,18.844z"/>
					<path d="M412.142,41.155c-1.74-0.022-3.47-0.042-5.182-0.063C408.686,41.113,410.386,41.133,412.142,41.155z"/>
					<path d="M192.421,43.723c0.465,0.275-0.391,0.278-0.566,0.275c-0.626-0.024-0.966-0.126-1.099-0.171
						c-0.164-0.064-0.199-0.115-0.228-0.156C191.158,43.688,191.789,43.706,192.421,43.723z"/>
					<path d="M187.258,50.833c-5.389-0.229-8.713-0.551-9.036-0.62c-0.184-0.04-0.361-0.109-0.478-0.161
						c0.602,0.058,0.913,0.063,2.652,0.086C185.399,50.201,186.656,50.626,187.258,50.833z"/>
					<path d="M176.884,41.871c-0.013,0.003-0.024,0.003-0.036,0.008c-0.237-0.413-0.237-0.413-0.118-0.448
						C177.52,41.655,177.172,41.828,176.884,41.871z"/>
					<path d="M168.3,40.831c2.57,0.095,4.51,0.225,7.411,0.497c0.212,0.189,0.169,0.241-0.184,0.235
						c-0.925-0.028-0.925-0.028-0.931,0.08c-0.201-0.138-0.272-0.166-0.708-0.261c-0.171-0.038-0.317-0.078-0.436-0.123
						c0,0.017-0.006,0.037-0.012,0.051c-0.083,0.167-0.667,0.136-0.978,0.115c-0.602-0.029-1.085-0.118-1.657-0.166
						c-0.301-0.026-0.625-0.023-0.924-0.05c-0.095-0.008-0.235-0.022-0.33-0.031c-0.226-0.023-0.484-0.078-0.649-0.12
						C168.672,41.001,168.46,40.903,168.3,40.831z"/>
					<path d="M159,49.386c0.013,0,0.414,0.144-0.154,0.129c-0.435-0.017-1.095-0.126-1.373-0.226
						c-0.04-0.016-0.076-0.029-0.11-0.047C158.318,49.271,158.711,49.282,159,49.386z"/>
					<path d="M150.759,41.776c-0.211-0.006-0.423,0.005-0.634,0.003c-0.078-0.003-0.213-0.009-0.326-0.055
						c-0.052-0.018-0.082-0.04-0.111-0.063C150.006,41.695,150.444,41.742,150.759,41.776z"/>
					<path d="M147.555,41.271c0.129,0.034,0.342,0.16,0.141,0.158c-0.095-0.006-0.2-0.023-0.484-0.106
						c-0.01-0.005-0.034-0.012-0.046-0.018C147.271,41.244,147.401,41.233,147.555,41.271z"/>
					<path d="M151.469,46.873c-1.657,0.037-3.06,0.009-6.143-0.278c-0.094-0.009-0.212-0.022-0.307-0.029
						c-0.27-0.224-0.124-0.241,0.685-0.235c0.104,0.081,0.258,0.19,0.365,0.271c0-0.028-0.012-0.063,0.013-0.086
						c0.027-0.041,0.11-0.092,0.469-0.081c0.744,0.026,1.308,0.161,2.063,0.184c0.554,0.021,1.109,0.003,1.651,0.034
						c0.059,0.006,0.141,0.01,0.199,0.013C151.008,46.701,151.31,46.813,151.469,46.873z"/>
					<path d="M144.358,46.376c0.173,0.081,0.402,0.189,0.579,0.275l-0.425-0.017c-0.071-0.023-0.141-0.049-0.2-0.069
						C143.948,46.416,144.242,46.388,144.358,46.376z"/>
					<path d="M142.213,46.287c0,0,0.801-0.021,0.496,0.192l-0.417-0.012l-0.03-0.014
						C142.014,46.353,142.084,46.302,142.213,46.287z"/>
					<path d="M13.681,51.175c-0.709-0.167-1.836-0.188-2.52-0.358c-0.129-0.035-0.129-0.035-0.824-0.609
						c0.173,0.089,0.406,0.206,0.586,0.298l-0.58-0.367c0.007,0,0.017,0,0.025-0.003c1.083,0.078,0.745,0.391,1.633,0.5
						c0.005-0.009,0.021-0.015,0.033-0.02c0.003-0.006,0-0.006,0.003-0.012c0.042-0.219,0.042-0.219-0.215-0.405
						c0.305,0.181,0.351,0.187,0.486,0.198c0.043-0.012,0.099-0.022,0.144-0.034c0.124-0.006,0.167-0.004,0.35,0.061
						c-0.138-0.102,0.065-0.216-0.229-0.308c-1.068-0.345-1.426-0.281-1.541-0.258c-0.342-0.201-0.769-0.391-1.1-0.587
						c0.068,0.026,0.121,0.058,0.271,0.069c-0.062-0.063-0.177-0.121-0.148-0.189c0.284,0.109,0.349,0.115,0.484,0.123
						c0.062-0.021,0.062-0.021-0.171-0.49c0.499,0.045,0.86,0.178,2.061,0.614c-0.064-0.115-0.489-0.213-0.372-0.339
						c0.019,0.006,0.048,0.011,0.065,0.017c0.333-0.037,1.509-0.092,2.182,0.081c0.169,0.046,0.241,0.112,0.562,0.123
						c0.129-0.026,0.172-0.071,0.359-0.086c0.197,0.049,0.178,0.146,0.596,0.146c0.095-0.029,0.153-0.058,0.243-0.087
						c0.812,0.013,1.003,0.214,1.635,0.282c0.043-0.012,0.1-0.023,0.148-0.034c0.032,0.006,0.076,0.006,0.102,0.006
						c0.238,0.074,0.551,0.181,0.789,0.255c0.359,0.072,0.721-0.063,1.081,0c0.442,0.078,0.731,0.192,1.255,0.247
						c0.032,0.003,0.076,0.009,0.108,0.015c0.478,0.034,0.749-0.108,1.228-0.069c0.359,0.026,0.283,0.155,0.745,0.161
						c0.118-0.029,0.182-0.066,0.28-0.098c1.014-0.021,1.603,0.414,2.579,0.221c0.421,0.178,0.667,0.259,1.09,0.358l-0.217-0.258
						c0.891,0.322,2.253,0.557,3.094,0.887c0.009-0.005,0.03-0.014,0.043-0.02c0.027,0,0.069-0.005,0.095-0.005
						c0.189,0.008,1.598,0.364,1.23,0.474c-0.104-0.015-0.234-0.035-0.65-0.225c0.189,0.17,0.218,0.218,0.142,0.265
						c-0.042,0.003-0.099,0.011-0.142,0.008c-0.423-0.017-0.602-0.117-0.989-0.148c-0.602-0.05-1.163,0.086-1.767,0.018
						c-0.638-0.07-1.007-0.288-1.937-0.199c-0.194-0.021-0.2-0.022-0.402-0.083c0.131,0.133,0.122,0.138,0.052,0.192
						c-0.178,0.009-0.21,0.006-0.69-0.089c-0.227-0.043-0.462-0.086-0.715-0.12c-0.347-0.047-0.626,0.079-0.976,0.02
						c-0.427-0.071-0.418-0.221-0.972-0.271c-0.093,0.035-0.255,0.09-0.9,0.016c-0.093-0.013-0.218-0.029-0.304-0.041
						c-0.761-0.108-1.391-0.258-2.169-0.355c-0.391-0.052-0.649-0.069-1.179-0.046c-0.817,0.028-1.213,0.005-2.175-0.38
						c0.136,0.086,0.312,0.201,0.449,0.285c-0.804-0.182-1.268-0.182-1.375-0.006c-0.246-0.164-0.186-0.348-0.544-0.509
						c-0.489-0.02-0.271,0.118-0.017,0.278c-0.054,0.204-0.051,0.207,0.783,0.54l-0.252-0.244c0.498,0.253,1.243,0.472,1.58,0.738
						c-0.154-0.012-0.154-0.012-0.938-0.29c0.175,0.123,0.599,0.227,0.582,0.367c-0.383-0.152-0.52-0.189-0.696-0.218
						c-0.029,0.006-0.068,0.009-0.09,0.011c-0.019,0.029-0.025,0.053-0.012,0.078c-0.258-0.152-0.673-0.29-1.017-0.434
						c0.064,0.154,0.432,0.296,0.354,0.457c-0.249-0.149-0.332-0.308-0.709-0.445c-0.049,0.003-0.113,0.006-0.164,0.006
						C13.463,50.963,13.611,51.068,13.681,51.175z"/>
					<path d="M9.453,49.65c-0.079-0.023-0.271-0.075-0.472-0.081c-0.247-0.006-0.465-0.04-0.908-0.212
						c-0.391-0.152,0.272-0.351,0.303-0.359c0.237,0.118,0.564,0.227,0.836,0.342c-0.081-0.063-0.216-0.173-0.131-0.198
						c0.093-0.025,0.363,0.043,0.363,0.043c0.175,0.058,0.297,0.144,0.427,0.204c0.118,0.078,0.24,0.152,0.291,0.235
						c0.034,0.049-0.06,0.092-0.051,0.142c-0.375-0.122-0.629-0.254-1.003-0.374C9.212,49.47,9.35,49.569,9.453,49.65z"/>
					<path d="M6.841,49.167c0.021,0.007,0.039,0.012,0.077,0.018c0.241-0.04-0.142-0.092-0.027-0.144
						c0.122,0.012,0.177,0.055,0.641,0.391c-0.192-0.034-0.299-0.058-0.5-0.155C6.962,49.242,6.903,49.205,6.841,49.167z"/>
					<polygon points="6.986,49.328 6.759,49.282 6.452,49.093 6.685,49.136 "/>
					<path d="M1.473,45.917c-0.004,0-0.007,0-0.007,0c-0.127-0.075-0.268-0.149-0.341-0.229
						c-0.027-0.029-0.013-0.04,0.043-0.032C1.18,45.658,1.859,45.899,1.473,45.917z"/>
					<path d="M0.788,45.79c0,0-0.003,0-0.008,0c-0.143-0.034-0.186-0.08-0.262-0.12c-0.072-0.037,0.003-0.052,0.003-0.052
						C0.6,45.618,0.841,45.773,0.788,45.79z"/>
					<path d="M3.806,37.652c0.229,0.074,0.297,0.08,0.57,0.115c0.175,0.006,0.24,0.012,0.477,0.103
						c-0.201,0.006-0.191,0.081-0.439,0.069c-0.04,0-0.151-0.012-0.313-0.098C3.979,37.781,3.892,37.716,3.806,37.652z"/>
					<path d="M3.845,37.805c-0.122-0.015-0.23-0.041-0.524-0.21c-0.013-0.002-0.016-0.005-0.021-0.012
						C3.517,37.614,3.649,37.632,3.845,37.805z"/>
					<path d="M2.946,37.856c-0.05-0.009-0.08-0.015-0.116-0.025c-0.071-0.021-0.253-0.162-0.155-0.213
						c0.056-0.035,0.188-0.015,0.3,0.04C3.049,37.698,3.124,37.87,2.946,37.856z"/>
					<path d="M1.74,37.756c-0.145-0.098-0.445-0.308-0.345-0.33c0.003-0.003,0.377,0.008,0.613,0.227
						c0.075,0.074-0.044,0.061-0.137,0.052c-0.104-0.015-0.203-0.025-0.147,0.035C1.728,37.744,1.737,37.75,1.74,37.756z"/>
					<polygon points="1.942,37.546 2.241,37.587 2.509,37.784 2.206,37.741 "/>
					<path d="M19.511,41.046c0.002-0.005,0.012-0.005,0.504,0.139l0.646,0.028l-0.003,0.04
						c0.084-0.037,0.197-0.086,0.289-0.12c0.185,0.066,0.442,0.149,0.625,0.212l-0.525-0.051l-0.388-0.041l-0.002,0.029l-0.266-0.04
						c-0.004-0.003-0.004-0.003-0.007-0.006c-0.002,0-0.002-0.003-0.012-0.003c0-0.003,0-0.003-0.017-0.015h-0.291l-0.224-0.052
						L19.511,41.046z"/>
					<path d="M30.671,45.263c0.013,0,0.031-0.003,0.05-0.007c0.362,0.058,0.332,0.178,0.758,0.219
						c0.026-0.046,0.051-0.109,0.073-0.157l0.918,0.335c0.101,0.023,0.28,0.023,0.356,0.052c0.136,0.058,0.322,0.185,0.366,0.247
						c-0.003,0.003-0.017,0.006-0.023,0.009c-0.209-0.065-0.288-0.152-0.562-0.21c0.008,0.069,0.013,0.163,0.022,0.235
						c-0.524-0.052-0.989-0.166-1.996-0.427c-0.07,0.06-0.208,0.188-1.243,0.117c-0.473-0.035-0.473-0.035-1.184-0.29
						c-0.308-0.044-0.504-0.008-0.695,0.031c-0.437,0.087-0.745,0.098-1.321-0.058c-0.258-0.068-0.228-0.338-0.147-0.396
						c0.221-0.173,0.806-0.121,1.026-0.102c0.289,0.026,0.289,0.026,0.99,0.279l0.066-0.161c0.702-0.034,1.067,0.052,2.607,0.425
						C30.691,45.357,30.604,45.313,30.671,45.263z"/>
					<path d="M34.776,46.692c0.523,0.08,0.847,0.224,1.217,0.401c-0.4-0.08-0.784-0.131-1.456-0.144
						c-1.367-0.017-1.96-0.224-2.435-0.385c0.127,0.086,0.295,0.201,0.423,0.288c-0.24-0.058-0.29-0.061-0.472-0.063
						c-0.212,0.055-0.248,0.16,0.182,0.58c-0.036,0-3.727,0.091-5.779-0.517c0.011,0.034,0.031,0.068-0.036,0.097
						c-0.09,0.047-0.339,0.023-0.682-0.14c-0.159-0.072,0.144-0.133,0.127-0.204c-0.035-0.086-0.34-0.179-0.375-0.19
						c-0.305-0.089-0.351-0.114-0.574-0.275c0.38-0.141,0.389-0.144,1.065-0.132c0.791,0.015,1.377,0.145,2.115,0.187
						c0.583,0.034,0.642,0.021,0.838-0.031c0.065-0.018,0.132-0.034,0.249-0.034c0.049,0,0.11,0.005,0.16,0.011
						c0.344,0.021,0.98,0.126,1.863,0.271c1.05,0.169,1.384,0.2,1.888,0.25C33.647,46.692,34.246,46.611,34.776,46.692z"/>
					<polygon points="33.488,45.831 33.745,45.856 34,46.031 33.748,46.009 "/>
					<path d="M36.299,46.893c0.343,0.007,0.491,0.034,0.672,0.13c-0.205-0.015-0.386,0.04-0.594,0.009
						c-0.143-0.023-0.289-0.071-0.493-0.17c-0.017-0.008-0.036-0.017-0.052-0.026C35.958,46.864,36.133,46.879,36.299,46.893z"/>
					<path d="M35.887,46.055c0.162,0.043,0.286,0.055,0.4-0.026c0.033-0.022,0.079-0.04,0.236,0.026
						c0.334,0.138,0.049,0.195-0.082,0.187c-0.164-0.02-0.382-0.111-0.504-0.166C35.925,46.069,35.906,46.06,35.887,46.055z"/>
					<path d="M39.695,48.699c0.012,0,1.546,0.061,1.913-0.06c2.234,0.398,6.866,0.906,9.39,0.775
						c0.283,0.063,0.235,0.178,0.666,0.223c0.99,0.102,2.104,0.073,3.109,0.156c0.821,0.068,0.821,0.068,6.81,0.37
						c4.703,0.238,4.703,0.238,4.952,0.31c0.512,0.152,0.37,0.343-0.249,0.322c-9.654-0.658-10.167-0.663-11.129-0.163
						c1.262,0.143,1.84,0.255,2.69,0.524c-0.767-0.105-0.767-0.105-1.145-0.252c0.101,0.055,0.189,0.105,0.26,0.16
						c-0.046,0.006-0.118,0.015-0.159,0.021c-0.089-0.009-0.218-0.023-0.325-0.028c-0.029,0.008-0.076,0.02-0.112,0.028
						c0.019,0.014,0.042,0.034,0.053,0.046c-0.849-0.029-1.496-0.093-3.439-0.311c-1.845-0.206-1.988-0.201-2.692-0.172
						c-0.544,0.021-0.693,0.018-1.057-0.012l-6.016-0.497c-0.9-0.083-1.723-0.209-2.71-0.235c0.006,0.026-0.019,0.061-0.052,0.084
						c-0.007-0.003-1.736-0.195-1.763-0.199c-0.53-0.051-1.125-0.008-1.663-0.054c-1.103-0.096-1.986-0.282-3.08-0.382
						c-0.571,0.105-0.958-0.112-1.184-0.316c0.153-0.048,0.24-0.071,0.988,0.021c1.655,0.201,1.686,0.055,1.529-0.213
						c-1.458-0.247-3.312-0.296-4.883-0.488h-0.002c0,0-0.401-0.152-0.177-0.296c0.4-0.031,0.522-0.043,1.45,0.049
						C31.706,48.113,39.518,48.691,39.695,48.699z"/>
					<path d="M37.09,46.95c0.365,0.081,0.518,0.047,0.53,0.044c0.146-0.038,0.238-0.026,0.51,0.134
						c-0.185,0.029-0.3,0.023-0.397,0.019c-0.095-0.006-0.289-0.029-0.592-0.173C37.125,46.968,37.1,46.956,37.09,46.95z"/>
					<path d="M40.732,47.203l0.388,0.189c-0.221-0.022-0.329-0.034-0.473-0.097c-0.081-0.038-0.136-0.075-0.182-0.115
						C40.541,47.186,40.647,47.198,40.732,47.203z"/>
					<path d="M40.706,43.301c0.042,0.029,0.095,0.065,0.137,0.095c0.118,0.052,0.234,0.104,0.351,0.152
						c0.037,0.021,0.153,0.031,0.097,0.055c-0.073-0.012-0.484-0.163-0.616-0.224c-0.019-0.013-0.038-0.018-0.056-0.029
						C40.487,43.28,40.597,43.292,40.706,43.301z"/>
					<path d="M41.313,47.977c0.227,0.157,0.327,0.258,0.07,0.24c-0.023-0.002-0.04-0.002-0.062-0.002l-0.006-0.004
						c-0.123-0.083-0.283-0.189-0.403-0.27L41.313,47.977z"/>
					<path d="M42.217,48.307c-0.043-0.01-0.073-0.021-0.114-0.026c-0.082-0.012-0.257-0.141-0.143-0.187
						c0.076-0.028,0.293-0.028,0.389,0.054C42.034,48.131,42.537,48.323,42.217,48.307z"/>
					<path d="M47.543,48.415c0.857,0.104,1.674-0.092,2.531-0.017c0.613,0.058,1.04,0.16,1.654,0.347
						c0.507-0.268,0.507-0.268,1.143-0.231c-0.648-0.395-0.648-0.395-0.521-0.445c0.255,0.014,0.557,0.031,0.625,0.267
						c0.095,0.327,0.575,0.342,1.523,0.364c2.388,0.063,2.388,0.063,2.664,0.106c0.071,0.012,0.165,0.025,0.236,0.038
						c0.401,0.065,0.767,0.157,1.062,0.235c-0.195-0.13-0.497-0.248-0.684-0.377c1.543-0.044,2.18-0.063,3.542,0.166
						c0.884-0.326,2.404-0.003,3.601-0.003c1.061-0.315,2.229,0.238,3.418,0.313l0.188-0.157c0.347-0.007,0.577,0.074,0.938,0.061
						c0.207,0.111,0.49,0.261,0.689,0.372c0.566,0.104,1.338,0.098,1.898,0.202c0.424,0.074,0.748,0.215,1.002,0.327
						c-3.365,0.115-6.731-0.089-12.401-0.747c-0.259,0.275-1.349,0.132-2.204-0.075c-0.072,0.047-0.165,0.104-0.431,0.104
						c-0.131,0-3.729-0.087-4.009-0.102c-1.406-0.071-1.406-0.071-2.277-0.333l-0.305,0.13c-2.083,0-3.561-0.334-5.348-0.497
						c-0.079-0.008-0.187-0.015-0.266-0.023c-0.076-0.146-0.056-0.151,0.089-0.215c0.062-0.006,0.138-0.011,0.194-0.011
						C46.69,48.236,47.043,48.357,47.543,48.415z"/>
					<path d="M46.358,44.579c0.037-0.047,0.639,0.043,0.642,0.045c0.008,0,0.413,0.21,0.129,0.196
						c-0.232-0.023-0.544-0.115-0.701-0.184C46.39,44.619,46.347,44.603,46.358,44.579z"/>
					<path d="M48.354,44.97c0,0,0.464-0.037,0.445,0.206l-0.289-0.025l-0.027-0.015
						C48.274,45.038,48.271,44.986,48.354,44.97z"/>
					<path d="M56.873,46.175l-0.558-0.293l-0.414-0.103c0.153-0.006,0.271-0.014,0.389-0.071
						c0.106-0.053,0.118-0.058,0.236-0.056c-0.3-0.161-0.718-0.315-0.955-0.481c0.224,0.039,0.513,0.097,0.731,0.137
						c-0.095,0.087,0.042,0.155,0.401,0.29c0.364,0.147,0.542,0.228,0.66,0.356C56.938,46,57.386,46.195,56.873,46.175z"/>
					<path d="M58.229,47.585c-0.243,0.043-0.383,0.058-0.596,0.043c-0.106-0.005-0.294-0.022-0.518-0.12
						c-0.083-0.034-0.218-0.068-0.172-0.118C57.051,47.272,57.799,47.425,58.229,47.585z"/>
					<path d="M55.718,45.839l0.418,0.199c-0.399-0.05-0.399-0.05-0.519-0.096c-0.089-0.04-0.148-0.083-0.199-0.123
						C55.513,45.825,55.629,45.831,55.718,45.839z"/>
					<path d="M56.195,48.433c-0.212,0.034-0.367,0.058-0.59,0.042c-0.129-0.008-0.306-0.036-0.513-0.129
						c-0.064-0.028-0.123-0.057-0.169-0.091C55.17,48.177,55.624,48.239,56.195,48.433z"/>
					<path d="M54.318,45.325c-0.229-0.187-0.135-0.267-0.104-0.29c0.047-0.031,0.236-0.105,0.743,0.178
						C54.767,45.245,54.512,45.291,54.318,45.325z"/>
					<path d="M54.893,48.49c-0.006,0-0.006,0-0.012,0.003c-0.227-0.124-0.529-0.244-0.679-0.377
						c0.125,0.01,0.288,0.023,0.411,0.031C54.798,48.271,54.993,48.427,54.893,48.49z"/>
					<path d="M54.448,48.545c-0.017-0.016-0.261-0.142-0.442-0.204c-0.143-0.047-0.235-0.058-0.264-0.023
						c-0.003,0-0.003,0.003-0.003,0.006c-0.08-0.058-0.257-0.201-0.224-0.247c0.029-0.04,0.175,0,0.297,0.04
						C54.135,48.223,54.847,48.564,54.448,48.545z"/>
					<path d="M53.862,45.813c-0.302,0-0.348-0.068-0.546-0.104c-0.185-0.022-0.158,0.04-0.109,0.121
						c-0.476-0.123-0.653-0.155-1.09-0.207c-0.178-0.018-0.352-0.041-0.51-0.068c-0.184-0.033-0.184-0.033-0.464-0.534
						c0.24,0.132,0.378,0.178,0.59,0.2c0.135,0.007,0.249-0.006,0.365-0.017c0.296-0.034,0.546-0.058,0.915,0.023
						c0.099,0.021,0.891,0.419,0.955,0.487C53.968,45.716,54.012,45.816,53.862,45.813z"/>
					<path d="M59.354,45.256c0.195,0.078,0.195,0.078,0.661,0.466c1.036,0.052,1.905,0.209,2.953,0.259
						c0.542,0.028,0.767-0.034,0.913-0.075c0.348,0.115,1.557,0.66,1.179,0.824c-0.23-0.083-0.623-0.135-0.896-0.212
						c-0.129-0.032-0.141-0.106-0.317-0.124c-0.319-0.038-0.749-0.018-1.31,0.052c-0.949,0.12-1.603-0.034-2.192-0.201
						c-0.036,0.152-0.219,0.155-0.801,0.006c-0.543-0.136-0.795-0.17-0.967-0.133c-0.012,0-0.019,0.003-0.03,0.007
						c-0.431-0.362-0.431-0.466,0.454-0.457C59.826,45.672,59.872,45.612,59.354,45.256z"/>
					<path d="M81.659,46.273c1.366,0.074,2.569,0.241,3.92,0.315c1.219,0.068,2.517-0.029,3.7,0.092
						c0.061,0.005,0.136,0.018,0.195,0.023c0.459,0.06,0.684,0.178,1.143,0.235c0.596,0.074,1.314,0.068,1.91,0.146
						c0.16,0.02,0.355,0.052,0.502,0.077c0.642,0.117,1.09,0.311,1.525,0.488c-2.31,0.02-4.444-0.184-6.672-0.27
						c0.307,0.215,0.229,0.231,0.07,0.264c-0.519-0.018-0.942-0.104-1.478-0.114c-1.021-0.029-2.059,0.022-3.079-0.023
						c-1.691-0.075-4.078-0.247-4.096-0.247c-0.435-0.038-0.318-0.138-0.448-0.206c-0.371-0.217-0.441-0.241-0.708-0.282
						c-0.183,0.072-0.183,0.072-1.591-0.265c-0.418,0.081-0.34,0.265-1.108,0.271c-0.405-0.172-1.172-0.496-0.86-0.675
						c0.201-0.112,1.15-0.173,2.322,0.336c-0.164-0.142,0.272-0.271,0.189-0.408c0.83,0.178,1.416,0.213,2.43,0.136
						c0.742-0.058,1.154-0.055,1.626,0.021c-0.013,0.017-0.037,0.045-0.055,0.068C81.293,46.259,81.481,46.267,81.659,46.273z"/>
					<path d="M108.452,49.478c3.531,0.281,4.551,0.265,5.045,0.259c-0.082-0.061-0.189-0.135-0.271-0.192l0.767,0.284
						c0.423-0.104,0.423-0.104,1.862,0.08c0.106-0.054,0.354-0.184,1.097-0.108c3.159,0.299,3.478,0.428,3.896,0.585
						c0.172-0.022,0.69-0.095,1.728-0.017c1.19,0.092,2.205,0.275,3.466,0.327c0.412,0.014,0.83-0.038,1.238,0.006
						c0.307,0.028,0.565,0.163,0.701,0.228c-0.885-0.053-1.775-0.09-2.681-0.125l-7.438-0.235c-0.778-0.006-0.813,0.127-0.849,0.242
						c1.592,0.247,4.745,0.551,6.795,0.487c1.61-0.055,2.487,0,3.766,0.472c-2.87,0.138-5.577-0.13-8.376-0.173
						c0.083,0.053,0.184,0.121,0.184,0.173c-0.16,0.037-0.412,0.034-0.589,0.063c-0.024,0.052,0.046,0.114,0.11,0.16
						c-9.165-0.367-9.165-0.367-11.021-0.563c-0.243,0.09-0.553,0.112-1.384,0.095c-1.78-0.548-2.152-0.714-2.429-0.962
						c2.57-0.037,5.127,0.333,7.716,0.018c1.066,0.149,1.515,0.216,1.395-0.097c-6.471-0.405-6.871-0.483-8.05-0.704l0.059,0.163
						c-0.118,0.023-0.224,0.047-0.519,0.032c-0.767-0.038-1.239-0.192-1.976-0.238c-0.725-0.044-1.473,0.029-2.198-0.018
						c-0.153-0.008-0.471-0.034-0.86-0.106c-0.046-0.009-0.106-0.02-0.154-0.031c0.685-0.022-0.07-0.241,0.52-0.311
						c0.553,0.204,0.553,0.204,1.309,0.328C102.653,49.174,104.32,49.147,108.452,49.478z"/>
					<path d="M105.747,48.44c0.006-0.014,0.019-0.025,0.041-0.04c0.119-0.055,0.461-0.043,0.825,0.169L105.747,48.44z"/>
					<polygon points="107.74,47.767 108.08,47.783 108.323,47.953 107.981,47.938 "/>
					<path d="M113.581,48.157c-0.006,0-0.184,0.079-0.484-0.023c-0.065-0.026-0.148-0.058-0.2-0.083
						c-0.36-0.17-0.336-0.342,0.235-0.296c0.059,0.08,0.27,0.12,0.589,0.178c0.289,0.052,0.378,0.075,0.167,0.104l-0.508-0.109
						C113.467,47.99,113.64,48.105,113.581,48.157z"/>
					<path d="M126.806,49.345c0.237,0.01,0.556,0.023,0.795,0.029c0.29,0.189,0.07,0.235-0.099,0.235
						c-0.059-0.006-0.212-0.014-0.4-0.089C126.959,49.467,126.876,49.405,126.806,49.345z"/>
					<polygon points="99.516,48.234 99.117,47.95 99.476,47.967 100.059,48.26 "/>
					<path d="M128.599,49.46c0.046-0.011,0.105-0.006,0.165,0c0.2,0.021,0.365,0.052,0.553,0.075
						c0.19,0.155,0.2,0.189,0.16,0.212c0,0-0.005,0.006-0.017,0.006c-0.019,0-0.047,0.006-0.072,0.003
						c-0.224-0.011-0.365-0.055-0.564-0.077c-0.013,0-0.037,0-0.047-0.006C128.675,49.604,128.505,49.483,128.599,49.46z"/>
					<polygon points="129.719,49.546 130.084,49.562 130.696,49.84 130.097,49.816 "/>
					<path d="M136.155,49.92c1.45,0.04,2.806,0.169,4.244,0.224c0.694,0.026,0.955,0.034,1.391,0.023
						c1.826,0.388,4.254,0.603,4.638,0.62c1.256,0.055,1.539,0.126,2.082,0.391c-0.224,0.074-0.525,0.178-2.505,0.026
						c-1.632-0.127-2.116-0.072-2.434,0.065c-0.413-0.178-0.731-0.247-1.403-0.319c-0.107,0.021-0.42,0.078-0.955,0.032
						c-0.632-0.054-1.179-0.149-1.811-0.207c-0.744-0.069-1.539-0.095-2.282-0.166c-0.224-0.018-0.519-0.047-0.736-0.069
						c-0.429-0.043-0.96-0.127-1.278-0.206c-0.36-0.093-0.649-0.248-0.837-0.359C134.604,49.942,135.122,49.892,136.155,49.92z"/>
					<path d="M135.152,49.147c0.129-0.092,0.259-0.083,0.353-0.061c0.178,0.046,0.249,0.166,0.054,0.166
						c-0.1-0.005-0.277-0.063-0.372-0.094C135.177,49.156,135.165,49.15,135.152,49.147z"/>
					<path d="M137.593,49.239c0-0.201,0.247-0.212,1.02-0.146c0.92,0.083,1.114,0.011,1.232-0.023
						c0.095,0.044,0.165,0.075,0.448,0.121c0.413,0.069,0.537,0.106,0.672,0.264c-0.123,0.034-0.237,0.047-0.531,0.037
						c-0.989-0.054-1.708-0.261-2.806-0.255C137.618,49.239,137.605,49.236,137.593,49.239z"/>
					<path d="M141.86,49.395c0.472-0.058-0.106-0.268,0.482-0.262c0.696,0.012,0.272,0.229,0.814,0.282
						c0.26-0.018,0.146-0.087,0.306-0.115c0.307-0.055,0.472,0.149,0.461,0.188c-0.083,0.182-1.615,0.013-2.018-0.079
						C141.895,49.402,141.872,49.397,141.86,49.395z"/>
					<path d="M150.087,51.589c0.437,0.123,0.755,0.33,0.319,0.35c-0.076-0.02-0.152-0.043-0.211-0.066
						C149.912,51.758,149.675,51.594,150.087,51.589z"/>
					<path d="M152.434,51.833c0.402-0.102,0.915-0.006,1.645,0.307c-0.353-0.012-0.943-0.032-1.569-0.272
						C152.488,51.855,152.453,51.844,152.434,51.833z"/>
					<path d="M144.865,51.502c0.019-0.025,0.108-0.046,0.525,0.084c-0.03,0.034-0.077,0.071-0.194,0.068
						c-0.094-0.005-0.142-0.023-0.189-0.041C144.903,51.579,144.854,51.528,144.865,51.502z"/>
					<path d="M145.467,51.5c0.532,0.002,0.968,0.021,1.297,0.223c-0.294-0.008-0.79-0.022-1.272-0.212
						C145.486,51.508,145.473,51.505,145.467,51.5z"/>
					<path d="M148.768,51.93c-0.801-0.04-1.566-0.212-1.891-0.321c-0.053-0.017-0.123-0.046-0.172-0.063
						c0.461-0.086,0.786-0.037,1.369,0.061c0.536,0.092,0.776,0.101,1.219,0.117C149.451,51.907,149.098,51.936,148.768,51.93z"/>
					<path d="M131.375,50.141c-0.042-0.008-0.089-0.021-0.129-0.028c0.27-0.071,0.27-0.071-0.431-0.434
						c0.366,0.025,0.742,0.046,1.12,0.061c0.36,0.014,0.719,0.02,1.072,0.026c0.148,0.16,0.636,0.292,0.837,0.447
						C133.467,50.327,132.058,50.287,131.375,50.141z"/>
					<path d="M72.977,49.374c-0.03,0.004-0.054,0.006-0.083,0.012c-0.012-0.021-0.03-0.046-0.042-0.063
						c-0.135-0.312,1.298-0.038,1.98,0.092c-0.188,0.022-0.305,0.025-0.653,0.002C73.195,49.357,73.195,49.357,72.977,49.374z"/>
					<path d="M73.395,50c0,0-0.011,0-0.024,0c-0.218-0.132-0.276-0.2-0.211-0.241c0,0,0.011,0,0.011-0.003
						c0.059-0.017,0.154-0.025,0.412,0C73.901,49.949,73.831,49.954,73.395,50z"/>
					<path d="M75.304,51.014c0.095,0.009,0.188,0.021,0.294,0.025c0.089,0.006,0.165-0.008,0.254-0.011
						c0.017,0.006,0.047,0.011,0.064,0.017c0.006,0,0.017,0.007,0.023,0.013c0.065,0.034,0.119,0.063,0.165,0.1
						c-0.095-0.006-0.224-0.014-0.319-0.02c-0.07,0.051-0.164,0.126-0.547,0.126c-0.731,0-1.25-0.12-1.87-0.181
						c-0.618-0.061-0.672-0.063-1.048,0.003c-0.265,0.043-0.36,0.052-0.732,0.04c-0.788-0.021-1.496-0.104-2.244-0.155
						c-0.289-0.021-0.602-0.015-0.901-0.028c-0.331-0.018-0.685-0.053-1.122-0.21c-0.129-0.042-0.264-0.109-0.37-0.157
						c0.484-0.061,0.985-0.092,3.084,0.017C71.12,50.654,73.335,50.819,75.304,51.014z"/>
					<polygon points="75.033,49.269 75.35,49.289 75.611,49.467 75.286,49.443 "/>
					<path d="M75.657,49.392c0.224,0.037,0.532,0.086,0.767,0.12c-0.024,0.052-0.082,0.063-0.235,0.058
						c-0.118-0.008-0.237-0.037-0.354-0.086C75.771,49.454,75.706,49.423,75.657,49.392z"/>
					<path d="M82.483,48.532c0.177,0.152,0.376,0.359,0.106,0.354c-0.142-0.011-0.283-0.045-0.425-0.103
						C82.012,48.72,81.6,48.487,82.483,48.532z"/>
					<path d="M83.237,48.731c0.106,0.021,0.212,0.028,0.331,0.034c0.313,0.018,0.483,0.025,0.625,0.195
						c-0.129,0.003-0.424,0.009-0.76-0.133C83.356,48.797,83.297,48.766,83.237,48.731z"/>
					<path d="M88.06,48.607c0.519,0.009,0.743,0.129,1.202,0.164c0.078,0,0.154,0,0.213-0.015
						c0-0.003,0.011-0.005,0.019-0.009c0.004,0,0.01-0.006,0.016-0.009c0.184,0.129,0.507,0.244,0.697,0.371
						c-0.944-0.028-0.991-0.025-1.792,0.08c-0.167-0.08-0.391-0.195-0.555-0.275c0.013,0.04,0.053,0.12-0.036,0.12
						c-0.308,0.015-0.218-0.092-0.482-0.1v0.002c-0.03,0.04,0.035,0.074,0.076,0.112c-0.254-0.038-0.643-0.095-1.426-0.089
						c-0.348,0.006-0.772,0.009-1.416-0.127c-0.051-0.011-0.104-0.022-0.159-0.034c0.66-0.286,1.416-0.23,3.679-0.048
						C88.035,48.702,87.893,48.604,88.06,48.607z"/>
					<path d="M89.886,48.674c0.036-0.006,0.065,0,0.095,0.003c0.329,0.037,1.154,0.456,0.918,0.471
						c-0.129-0.117-0.495-0.207-0.742-0.307C90.027,48.788,89.945,48.731,89.886,48.674z"/>
					<path d="M89.592,50.69c-0.083-0.007-0.283-0.019-0.672-0.122c-0.023-0.006-0.042-0.014-0.059-0.017
						c0.288-0.003,0.689,0.011,0.859,0.068C89.803,50.644,89.846,50.701,89.592,50.69z"/>
					<path d="M88.589,49.954c-0.571-0.068-0.778-0.037-1.156,0.017c-0.01,0-0.034,0.007-0.047,0.007
						c-0.034-0.035-0.116-0.109-0.034-0.161C87.494,49.716,88.111,49.739,88.589,49.954z"/>
					<path d="M86.255,50c-0.07-0.006-0.258-0.017-0.482-0.104c-0.237-0.092-0.213-0.114-0.201-0.126
						c0.072-0.069,0.401-0.072,0.714,0.037C86.868,50.012,86.267,50,86.255,50z"/>
					<path d="M85.212,49.874c-0.241-0.017-0.395-0.08-0.419-0.087c-0.035-0.011-0.059-0.028-0.083-0.045
						c0.177-0.021,0.349-0.102,0.542-0.052C85.294,49.695,85.753,49.896,85.212,49.874z"/>
					<path d="M75.164,47.936c1.997,0.112,3.695,0.391,5.67,0.521c0.224,0.011,0.448,0.019,0.678,0.019
						c0.053,0.095,0.11,0.21,0.053,0.285c-0.154,0.166-0.708,0.103-1.486,0.012c-0.872-0.101-0.872-0.101-3.159-0.115
						c-1.355-0.006-4.992-0.229-7.816-0.413c-1.921-0.127-3.795-0.293-5.752-0.392c-0.482-0.022-0.913,0.064-1.403,0.038
						c-0.218-0.015-0.673-0.066-1.213-0.296c-0.059-0.025-0.136-0.063-0.189-0.089c0.023,0,0.065,0.003,0.095,0.003
						c0.353-0.081-0.025-0.189,0.199-0.275c0.141,0.031,0.141,0.079,0.236,0.115c1.097-0.036,1.645-0.058,5.434,0.209
						c1.473,0.101,2.925,0.224,4.444,0.29C72.339,47.909,73.778,47.858,75.164,47.936z"/>
					<path d="M72.474,49.199c0.154,0.216-0.046,0.227-0.522,0.198c-0.254-0.018-0.502-0.032-0.632,0.025
						c-0.024,0.009-0.035,0.021-0.047,0.029C70.878,49.024,71.314,49.075,72.474,49.199z"/>
					<path d="M54.599,51.718c-0.301-0.023-0.607-0.047-0.906-0.068c-0.021-0.003-0.046-0.007-0.064-0.007
						c-0.087-0.057-0.203-0.132-0.292-0.189c0.322,0.023,0.649,0.052,0.977,0.075C54.399,51.586,54.515,51.663,54.599,51.718z"/>
					<path d="M50.502,51.393c-0.207-0.037-0.343-0.049-0.622-0.021c-0.159,0.019-0.274,0.029-0.487-0.057
						c-0.162-0.069-0.269-0.144-0.38-0.213c0.15,0.023,0.321,0.041,0.495,0.058C49.981,51.172,50.221,51.229,50.502,51.393z"/>
					<path d="M32.645,49.874c-0.055-0.014-0.119-0.04-0.176-0.058c1.271,0.173,2.685-0.051,3.966,0.075
						c0.512,0.051,0.987,0.12,1.527,0.154c1.825,0.121,3.404,0.386,5.27,0.482c0.315,0.018,0.319-0.074,0.495-0.109
						c1.361,0.023,4.315,0.445,4.747,0.639c0.007,0.002,0.342,0.204-0.376,0.148c-2.008-0.172-4.124-0.281-6.095-0.477
						c-0.542-0.052-0.542-0.052-0.712,0.052c-0.08,0.052-0.198,0.046-0.823-0.072c-0.192-0.037-0.359-0.079-0.613-0.1
						c-0.246-0.015-0.501-0.018-0.752-0.023c-1.084-0.023-1.621-0.058-2.565-0.293c-0.164,0.086-0.24,0.109-0.443,0.12
						c-0.655-0.181-1.049-0.24-1.836-0.28C33.702,50.106,33.26,50.072,32.645,49.874z"/>
					<path d="M32.357,51.487l0.517,0.282c-0.013,0.034-0.125,0.063-0.332,0.04c-0.091-0.009-0.163-0.029-0.219-0.047
						c-0.131-0.054-0.143-0.116-0.152-0.149c0.146,0.041,0.342,0.093,0.49,0.13L32.357,51.487z"/>
					<polygon points="32.051,49.92 31.79,49.747 32.253,49.794 32.523,49.971 "/>
					<path d="M31.446,49.13c-0.062,0.052-0.389-0.011-0.737-0.169c-0.024-0.012-0.062-0.028-0.086-0.046
						c0.089,0.028,0.215,0.04,0.337,0.052C31.491,48.983,31.452,49.127,31.446,49.13z"/>
					<path d="M29.688,48.346c-0.05-0.002-0.16-0.017-0.326-0.091c-0.197-0.093-0.326-0.184-0.452-0.281
						c0.109,0.024,0.255,0.027,0.388,0.04c0.166,0.017,0.343,0.045,0.516,0.12C30.259,48.335,29.742,48.354,29.688,48.346z"/>
					<path d="M28.843,48.194c-0.18-0.021-0.359-0.037-0.542-0.058c-0.011-0.003-0.024-0.003-0.039-0.003
						c-0.083-0.058-0.2-0.136-0.28-0.189l-0.006-0.069c0.047,0.023,0.122,0.044,0.208,0.058C28.375,47.97,28.521,48.008,28.843,48.194z"
						/>
					<path d="M25.825,43.324c0.075-0.003,0.127,0.006,0.167,0.02c0.165,0.043,0.152,0.106,0.306,0.155
						c0.202,0.063,0.537,0.098,0.733,0.166c0.209,0.068,0.342,0.149,0.472,0.225c-0.386-0.104-0.658-0.127-1.111-0.101
						c-0.269,0.018-0.513,0.009-0.865-0.083c-0.02-0.007-0.047-0.015-0.067-0.021c0.05-0.12,0.103-0.184,0.575-0.095
						C26,43.502,25.779,43.419,25.825,43.324z"/>
					<path d="M27.477,44.603c-0.118,0.027-0.168,0.036-0.254,0.027c-0.041-0.006-0.132-0.017-0.315-0.103
						c-0.1-0.053-0.189-0.107-0.271-0.161C26.934,44.383,27.194,44.412,27.477,44.603z"/>
					<path d="M25.426,45.276c-0.077-0.014-0.116-0.031-0.15-0.052c-0.015-0.009-0.03-0.015-0.042-0.02
						c-0.025-0.018-0.062-0.038-0.084-0.052c0.02-0.009,0.032-0.018,0.037-0.029c0.047-0.034,0.119-0.068,0.267-0.008
						C25.796,45.26,25.432,45.276,25.426,45.276z"/>
					<path d="M25.329,43.82c-0.143-0.017-0.209-0.048-0.286-0.08c-0.112-0.046-0.305-0.19-0.28-0.238
						c0.04-0.061,0.442,0.006,0.448,0.009C25.225,43.511,25.659,43.849,25.329,43.82z"/>
					<path d="M24.735,42.648c-0.172-0.089-0.3-0.184-0.418-0.275c0.11,0,0.098-0.028,0.135-0.043
						c0.075-0.034,0.24,0.012,0.24,0.012c0.25,0.135,0.457,0.327,0.65,0.465C25.122,42.787,24.978,42.77,24.735,42.648z"/>
					<path d="M24.612,46.244c-0.046-0.022-0.092-0.049-0.127-0.072c0.059,0.016,0.143,0.029,0.231,0.037
						c0.218,0.007,0.356,0.058,0.508,0.204C25.089,46.405,24.88,46.379,24.612,46.244z"/>
					<path d="M24.556,48.634c-0.186-0.029-0.552-0.207-0.656-0.259c-0.013-0.009-0.022-0.011-0.03-0.018
						c-0.024-0.012-0.047-0.022-0.073-0.034c0.262,0.015,0.471,0.052,0.721,0.184C24.784,48.645,24.556,48.634,24.556,48.634z"/>
					<polygon points="24.981,46.698 24.906,46.525 25.449,46.824 25.237,46.801 "/>
					<path d="M25.199,48.708l-0.221-0.026c-0.019-0.008-0.033-0.02-0.053-0.025c-0.16-0.08-0.224-0.141-0.157-0.155
						C24.777,48.501,25.169,48.507,25.199,48.708z"/>
					<path d="M26.109,48.587c0.185,0.133,0.227,0.201-0.082,0.176c0,0-0.604-0.101-0.682-0.129
						C25.192,48.576,25.844,48.569,26.109,48.587z"/>
					<path d="M26.191,48.516c0.879,0.129,1.188,0.29,1.19,0.292c0.022,0.016-0.005,0.09-0.323,0.055
						c-0.067-0.005-0.283-0.034-0.534-0.148C26.381,48.65,26.28,48.585,26.191,48.516z"/>
					<path d="M25.891,41.781l-0.799-0.077l-1.34-0.135l-2.173-0.225c0.758,0.004,1.765,0.007,2.517,0.007
						c0.012,0.077,0.03,0.181,0.041,0.258l1.2,0.117c0.141-0.057,0.325-0.134,0.462-0.194c0.077,0.08,0.177,0.187,0.252,0.265
						L25.891,41.781z"/>
					<path d="M12.622,44.498c-0.491-0.08-1.136-0.1-1.586-0.198c-0.675-0.146-0.989-0.33-1.047-0.364
						c-0.062-0.043-0.121-0.098-0.05-0.138c0.175,0.006,0.249,0.046,0.415,0.051c0.189,0.013,0.363-0.017,0.55-0.011
						c0.055,0.006,0.129,0.009,0.178,0.011c0.122,0.007,0.279,0.021,0.391,0.032c0.739,0.083,1.374,0.198,2.044,0.302
						c-0.015-0.009-0.02-0.028-0.015-0.038c0.003,0,0.704,0.222,0.76,0.359c-0.317-0.022-0.574-0.074-0.869-0.115
						c-0.823,0.139,0.073,0.437,0.33,0.491c0.248,0.05,0.593,0.009,0.866,0.04c0.955,0.112,1.822,0.262,2.783,0.368
						c0.051,0.006,0.126,0.015,0.176,0.02c0.176,0.021,0.351,0.037,0.531,0.052c0.787,0.074,1.459,0.196,2.245,0.271
						c0.233,0.018,0.328,0.022,0.555-0.018c0.141-0.022,0.28-0.046,0.471-0.012c0.386,0.075,0.877,0.316,0.88,0.322
						c0.122,0.077-0.11,0.155-0.024,0.235c-0.528-0.133-0.85-0.155-1.371-0.152c-0.437,0-0.817,0-2.3-0.206
						c-1.23-0.176-2.533-0.316-3.779-0.479c-0.224,0.011-0.264,0.12-0.537,0.085c-0.464-0.057-0.744-0.16-1.154-0.234
						c-0.254-0.041-0.609-0.013-0.863-0.061c-0.169-0.031-0.37-0.12-0.44-0.159c-0.013-0.005-0.944-0.477,0.532-0.24
						c0.579,0.092,0.636,0.052,0.688,0.022C12.98,44.731,13.18,44.596,12.622,44.498z"/>
					<polygon points="8.117,45.205 7.979,45.256 7.74,44.998 "/>
					<path d="M7.734,44.584c-0.092-0.018-0.132-0.036-0.174-0.057c-0.045-0.023-0.083-0.05-0.118-0.074
						c0.038-0.018,0.095-0.041,0.135-0.055l0.03,0.014c0.006,0.003,0.015,0.006,0.021,0.012c0.05,0.029,0.092,0.054,0.127,0.083
						C7.812,44.556,7.829,44.596,7.734,44.584z"/>
					<path d="M7.393,43.74c-0.036-0.012-0.073-0.028-0.101-0.041c0.375-0.042,0.741-0.079,1.268,0.016
						c0.262,0.048,0.262,0.048,0.593,0.33c-0.195-0.037-0.652-0.098-0.744-0.104C8.112,43.921,7.779,43.881,7.393,43.74z"/>
					<path d="M9.288,43.987c-0.254-0.155-0.235-0.179-0.153-0.189c0.07-0.012,0.056-0.028,0.047-0.041
						c0.079,0.05,0.179,0.099,0.204,0.155c0.013,0.023-0.106,0.044-0.104,0.069C9.282,43.984,9.288,43.987,9.288,43.987z"/>
					<path d="M9.45,45.325c0.013,0.012,0.022,0.089-0.319,0.043c-0.176-0.029-0.333-0.077-0.478-0.146
						c-0.004-0.006-0.02-0.012-0.031-0.017C8.864,45.202,9.26,45.193,9.45,45.325z"/>
					<path d="M7.714,41.902c-0.198-0.026-0.207-0.115-0.318-0.16c-0.183-0.07-0.437-0.133-0.606-0.207
						c-0.578-0.247-0.458-0.456,1.034-0.098c0.544,0.132,0.701,0.16,0.81,0.149c0.248,0.114,0.571,0.229,0.897,0.339
						c0.013-0.058,0.022-0.115,0.083-0.173c0.307-0.272,1.166,0.086,1.489,0.218c-0.053-0.042-0.169-0.085-0.096-0.132
						c0,0,0.135-0.078,0.798,0.145c0.265,0.086,0.396,0.131,0.695,0.184c0.414,0.074,0.972,0.06,1.397,0.131
						c0.05,0.003,0.109,0.019,0.146,0.023c0.472,0.102,0.782,0.244,1.077,0.385C14.663,42.706,13.438,42.706,7.714,41.902z"/>
					<path d="M5.8,41.596c-0.167,0.146-1.298-0.296-1.938-0.581c-0.029-0.014-0.075-0.031-0.104-0.043
						c0.162,0.026,0.646,0.121,1.073,0.121c0.184,0.006,0.739,0.008,1.414,0.167c0.114,0.022,0.099,0.079,0.139,0.113
						c0.059,0.05,0.165,0.115,0.251,0.159c0.16,0.084,0.533,0.138,0.564,0.238c0,0-0.006,0.045-0.236,0.017
						c-0.307-0.058-0.515-0.12-1.216-0.378C5.792,41.472,5.877,41.532,5.8,41.596z"/>
					<path d="M6.08,44.814c-0.076,0.04-0.149,0.034-0.227,0.026c-0.056-0.016-0.197-0.038-0.491-0.199
						c-0.022-0.005-0.034-0.018-0.053-0.022c0.031,0.005,0.062,0.011,0.092,0.02c0.218,0.043,0.244,0.015,0.237-0.031
						C5.772,44.671,5.948,44.752,6.08,44.814z"/>
					<path d="M2.525,44.188c0.167,0.008,0.126,0.051,0.167,0.074c0.008,0.003,0.014,0.006,0.02,0.012
						c0.137,0.077,0.251,0.158,0.313,0.241c0.006,0.003,0.01,0.009,0.013,0.012C2.692,44.331,2.5,44.202,2.525,44.188z"/>
					<path d="M2.439,44.412c-0.143-0.029-0.316-0.115-0.411-0.166c-0.087-0.052-0.166-0.099-0.241-0.149
						c0.207,0.068,0.235,0.058,0.293,0.037c0.079-0.021,0.253,0.011,0.408,0.17C2.531,44.344,2.608,44.436,2.439,44.412z"/>
					<path d="M2.835,44.191c0.019-0.009,0.491,0.003,0.755,0.29c0.07,0.08-0.062,0.061-0.132,0.048
						c-0.094-0.017-0.191-0.036-0.286-0.048C3.049,44.458,2.83,44.191,2.835,44.191z"/>
					<path d="M3.024,40.501c-0.275-0.074-0.347-0.213-0.494-0.305c0.029,0.032,0.093,0.101,0.019,0.129
						c-0.084,0.026-0.281-0.002-0.534-0.14c-0.114-0.058-0.2-0.12-0.284-0.185c0.607,0.007,1.192,0.058,1.816,0.049
						c0.227,0.118,0.742,0.411,0.653,0.469c-0.208-0.078-0.347-0.084-0.504-0.018C3.523,40.569,3.296,40.569,3.024,40.501z"/>
					<path d="M1.374,40.317c-0.233-0.103-0.341-0.123-0.513-0.132c-0.272-0.015-0.272-0.015-0.396-0.075
						c-0.069-0.034-0.116-0.065-0.162-0.098c0.242,0.006,0.3,0.069,0.5,0.087c0.279,0.025-0.136-0.139-0.315-0.207
						c0.257-0.029,0.118-0.086,0.201-0.13c0.11-0.054,0.344,0.078,0.765,0.348c-0.05-0.009-0.105-0.021-0.18-0.025
						C1.196,40.104,1.192,40.134,1.374,40.317z"/>
					<polygon points="1.277,39.933 1.463,39.961 1.734,40.156 1.548,40.128 "/>
					<path d="M9.509,41.081c0.095-0.055,0.277-0.149,1.219,0.006c0.022-0.018,0.034-0.041,0.058-0.063
						c0.17-0.139,1.051-0.346,3.024,0.361c0.007-0.021,0.013-0.041,0.046-0.058c0.109-0.055,0.31,0.105,0.419,0.192
						c-0.906-0.037-1.761,0.111-2.674,0.043c-0.283-0.022-0.892-0.104-1.812-0.391C9.706,41.145,9.595,41.11,9.509,41.081z"/>
					<polygon points="15.809,44.475 16.125,44.513 16.404,44.705 16.086,44.665 "/>
					<path d="M17.041,44.545c0.106,0.077,0.238,0.148,0.416,0.218c0.08,0.034,0.19,0.06,0.217,0.098
						c0,0,0.016,0.052-0.106,0.04c-0.565-0.08-0.647-0.242-1.093-0.342c-0.007-0.003-0.025-0.003-0.028-0.009
						c0,0-0.043-0.043,0.051-0.034c0.175,0.022,0.254,0.063,0.402,0.089C17.094,44.639,17.061,44.584,17.041,44.545z"/>
					<path d="M17.908,44.733c0.119-0.037,0.389,0.115,0.386,0.121c0.01,0.04-0.125,0.086-0.175,0.12
						C17.85,44.831,17.85,44.752,17.908,44.733z"/>
					<path d="M22.052,43.41c-0.224-0.063-0.184-0.153-0.334-0.222c-0.141-0.068-0.351-0.126-0.533-0.184
						c0.039,0.04,0.098,0.101,0.033,0.104c-0.261,0.022-0.224-0.077-0.479-0.069c-0.087,0.095,0.233,0.19,0.018,0.288
						c-0.018,0.005-0.049,0.011-0.073,0.017c-0.221-0.126-0.464-0.253-0.639-0.382c0.218,0.046,0.224,0.046,0.353,0.046
						c0.024-0.166-0.442-0.302-0.545-0.462c0.292,0.123,0.451,0.166,0.705,0.2c0.319,0.028,0.624-0.042,0.942-0.006
						c0.249,0.034,0.414,0.081,0.699,0.21c-0.17,0.055-0.192,0.061,0.085,0.23c0.13,0.076,0.38,0.146,0.34,0.232
						C22.581,43.508,22.061,43.413,22.052,43.41z"/>
					<polygon points="22.868,44.986 23.145,45.182 22.896,45.153 22.618,44.961 "/>
					<path d="M23.106,48.398c-0.041-0.018-0.088-0.047-0.164-0.032c-0.108,0.02-0.033,0.054-0.083,0.077
						c-0.015,0.013-0.047,0.015-0.192-0.058c-0.129-0.063-0.132-0.068-0.07-0.1C22.635,48.263,22.792,48.202,23.106,48.398z"/>
					<polygon points="20.889,48.194 20.675,48.165 20.412,47.99 20.628,48.019 "/>
					<polygon points="13.509,47.293 13.803,47.335 14.092,47.524 13.803,47.484 "/>
					<polygon points="13.706,47.474 13.515,47.444 13.219,47.249 13.417,47.277 "/>
					<path d="M13.091,47.396c-0.046-0.006-0.088-0.014-0.122-0.025c-0.231-0.066-0.201-0.187-0.271-0.271
						c0.161,0.081,0.317,0.155,0.424,0.235C13.216,47.41,13.128,47.401,13.091,47.396z"/>
					<path d="M12.329,47.348l-0.174-0.026l-0.027-0.015c-0.212-0.108-0.247-0.16-0.199-0.173
						C11.928,47.134,12.192,47.131,12.329,47.348z"/>
					<path d="M10.422,47.134c-0.072,0.052-0.271-0.011-0.854-0.194C9.543,46.934,9.52,46.922,9.5,46.919
						C9.617,46.778,10.05,47.076,10.422,47.134z"/>
					<polygon points="10.251,46.963 10.528,47.002 10.792,47.181 10.513,47.134 "/>
					<path d="M9.848,50.327c0.312-0.08,1.012,0.354,1.015,0.363c0,0-0.081,0.082-0.365,0.034
						c-0.096-0.021-0.323-0.063-0.722-0.274c-0.079-0.042-0.149-0.082-0.224-0.123C9.677,50.356,9.736,50.351,9.848,50.327z"/>
					<path d="M22.902,52.039c-0.284-0.046-0.55-0.154-0.724-0.241c-0.033-0.018-0.081-0.04-0.115-0.06
						c0.096,0.024,0.342,0.092,0.512,0.048c0.216-0.055,0.483,0.083,0.49,0.086C23.065,51.872,23.351,52.091,22.902,52.039z"/>
					<polygon points="20.941,51.795 21.113,51.82 21.417,52.011 21.235,51.984 "/>
					<path d="M21.321,51.563c0.226,0.126,0.494,0.247,0.673,0.376l-0.297-0.037
						C21.143,51.563,21.275,51.563,21.321,51.563z"/>
					<path d="M37.906,41.179c0.505,0.201,0.53,0.434,0.879,0.643c-0.127-0.011-0.282-0.021-0.508-0.132
						C37.917,41.521,37.578,41.167,37.906,41.179z"/>
					<path d="M39.9,41.756c-0.69-0.126-0.755-0.503-0.624-0.551c0.533,0.129,1.139,0.238,1.633,0.375
						c-0.227-0.097-0.227-0.097-0.204-0.27c0.149-0.006,0.215,0.003,0.431,0.158c0.067,0.054,0.135,0.104,0.258,0.152
						c0.024,0,0.05,0.003,0.075,0.006c-0.325-0.385-0.325-0.385-0.21-0.435c2.843,0.276,2.843,0.276,3.297,0.181
						c-0.2-0.079-0.2-0.079-0.626-0.151c-0.629-0.101-0.923-0.365-0.043-0.327c1.08,0.043,1.889,0.272,1.839,0.399
						c-0.073,0.221,0.896,0.224,0.909,0.227c0.163-0.072,0.174-0.077,0.23-0.244c0.076-0.241,0.129-0.252,0.415-0.291
						c1.559,0.642,1.559,0.642,1.948,0.736c0.029,0,0.059-0.003,0.083-0.003c0.073-0.092-0.308-0.17-0.083-0.259
						c0.026,0,0.071,0,0.098,0.006c0.683,0.098,1.231,0.241,1.932,0.339c0.675,0.098,1.548,0.105,2.093,0.259
						c0.875,0.241,1.053,0.479,0.383,0.517c-0.326,0.021-0.623,0.006-1.147-0.037c-0.016,0-2.254-0.175-3.999-0.204
						c-0.122,0.074,0.115,0.155-0.073,0.229c-0.013,0-0.634-0.014-1.271-0.155c0,0.013,0,0.029-0.005,0.041
						c-0.025,0.085-0.16,0.092-0.201,0.098c-0.095,0.003-0.095,0.003-1.023-0.149c-0.351-0.058-0.539-0.066-0.892,0.086
						c-0.162,0.071-0.342,0.149-0.616,0.138c-0.504-0.025-0.709-0.149-1.179-0.184c-0.731-0.053-1.518-0.012-2.237-0.074
						c-0.314-0.029-0.908-0.081-1.748-0.279c-0.092-0.022-0.207-0.051-0.294-0.074c0.257-0.102,0.395-0.155,0.948-0.009
						C39.882,41.926,39.916,41.842,39.9,41.756z"/>
					<path d="M43.418,41.202c-1.08-0.081-1.08-0.081-1.351-0.196c-0.064-0.031-0.126-0.063-0.181-0.097
						c-0.337-0.201,0.221-0.144,0.86-0.075c0.062,0.007,0.113-0.006,0.168-0.003C43.065,40.943,43.268,41.09,43.418,41.202z"/>
					<path d="M56.391,41.8c0.283,0.108,0.625,0.298,0.264,0.28c-0.065-0.006-0.116-0.011-0.165-0.022
						c-0.012,0-0.022-0.003-0.041-0.006C56.431,41.978,56.408,41.874,56.391,41.8z"/>
					<path d="M68.857,42.426c0.583-0.047,0.718-0.055,1.271-0.029c0.679,0.029,1.594,0.108,2.194,0.16
						c3.007,0.262,3.007,0.262,3.891,0.155c0.246-0.034,0.246-0.034,1.756,0.121c0.258,0.025,0.542,0.046,0.825,0.063
						c3.641,0.138,3.641,0.138,4.761,0.345c-0.2,0.247-0.578,0.305-2.434,0.181c-0.925-0.063-1.879-0.129-2.033,0.023
						c0.053,0.015,0.118,0.034,0.188,0.049c0.319,0.049,0.672-0.083,0.955-0.003c0.301,0.083,0.141,0.272,0.813,0.267
						c0.19-0.005,0.254,0,0.425,0.052c-0.465,0.05-1.238,0.129-2.828,0.053c-1.391-0.069-2.711-0.193-4.079-0.265
						c-3.172-0.173-6.473-0.178-9.625-0.374c-1.079-0.063-1.079-0.063-2.121-0.333c-0.726-0.068-1.622-0.063-2.158-0.224
						c-0.047,0.315-0.047,0.315-0.437,0.305c-0.354-0.253-1.138-0.46-1.65-0.689c-0.013,0.017-0.019,0.046-0.047,0.063
						c-0.201,0.16-0.69,0.028-1.049-0.133c-0.206-0.092-0.359-0.189-0.513-0.286c0.319-0.029,0.849-0.081,1.774-0.05
						c1.726,0.061,3.294,0.256,5.028,0.313c0.966,0.034,2.003-0.141,2.94,0.04C68.066,42.491,68.066,42.491,68.857,42.426z"/>
					<path d="M119.363,45.521c-0.167-0.095-0.207-0.126-0.159-0.189c0.165,0.006,0.389,0.018,0.554,0.023
						c0.377,0.224,0.319,0.286,0.034,0.355c-0.194,0.046-0.283,0.074-0.252,0.161c0.112-0.012,0.159,0.011,0.218,0.028
						c0.16,0.037,0.771,0.247,0.342,0.247c-0.129-0.087-0.501-0.121-0.719-0.187c-0.166-0.05-0.166-0.05-0.395-0.382
						c0.254,0.022,0.429,0.031,0.454,0.003C119.463,45.559,119.399,45.538,119.363,45.521z"/>
					<path d="M120.996,45.621c0.116,0.031,0.211,0.135-0.013,0.126c-0.07-0.002-0.165-0.008-0.412-0.092
						c-0.023-0.005-0.036-0.012-0.047-0.015C120.707,45.59,120.866,45.583,120.996,45.621z"/>
					<path d="M111.812,44.59c0.565,0.296,2.169,0.4,2.583,0.718c-1.204-0.058-2.153,0.302-3.432,0.109
						c-0.019,0.098-0.029,0.181-0.496,0.201c-0.718,0.025-1.26-0.08-1.89-0.127c-0.767-0.058-1.344,0.092-2.059,0.099
						c-0.965,0.006-2.339-0.081-2.886-0.118c-1.793-0.13-2.287-0.106-2.678-0.075c-1.498-0.623-2.604-0.307-2.617-0.301
						c-1.33-0.281-1.861-0.253-3.454-0.166c-0.277-0.153-0.442-0.162-0.742-0.146c-0.165-0.044-0.106-0.102-0.218-0.146
						c-1.409,0.028-1.444-0.316-2.221-0.458c-0.648,0.204-1.416,0.159-2.099-0.129c-0.053-0.022-0.118-0.052-0.165-0.073
						c1.992,0.103,2.587,0.131,2.534-0.303c-1.143,0.028-1.143,0.028-1.509-0.163c1.049-0.003,2.01,0.172,3.1,0.078
						c0.744,0.231,1.179,0.255,1.451,0.068c0.329,0.204,0.437,0.212,0.801,0.175c2.387-0.27,3.512,0.074,3.996,0.218
						c0.235-0.073,0.767-0.097,0.743-0.218c0.271,0.084,0.153,0.207,0.554,0.281c0.437,0.075,0.979,0.058,1.48,0.081
						c2.493,0.097,3,0.092,6.944,0.042C110.269,44.603,111.447,44.711,111.812,44.59z"/>
					<path d="M101.633,46.626l-0.548-0.025c-0.372-0.271-0.106-0.259,0.17-0.245
						C101.367,46.437,101.521,46.549,101.633,46.626z"/>
					<path d="M100.744,46.586c-0.86-0.043-0.86-0.043-0.966-0.086c-0.118-0.046-0.161-0.095-0.207-0.147
						C100.001,46.376,100.354,46.423,100.744,46.586z"/>
					<path d="M83.792,40.596c-0.172-0.012-0.402-0.037-0.66-0.158c-0.049-0.021-0.083-0.039-0.119-0.06
						C83.544,40.433,83.62,40.438,83.792,40.596z"/>
					<path d="M83.539,43.921c-0.619,0.066-0.619,0.066-0.867,0.056c-0.095-0.007-0.376-0.023-0.653-0.145
						c-0.053-0.025-0.101-0.049-0.148-0.075c0.294-0.123,0.442-0.184,1.038-0.126C83.485,43.688,83.343,43.823,83.539,43.921z"/>
					<path d="M122.438,46.06c0.148-0.063,0.608-0.06,0.885,0.128c-0.289-0.007-0.289,0.089-0.572,0.079
						c-0.083,0-0.176-0.008-0.242-0.017C122.38,46.229,122.315,46.109,122.438,46.06z"/>
					<path d="M138.442,40.656c0.389,0.13,0.672,0.305,0.207,0.295c-0.083-0.002-0.16-0.011-0.22-0.02
						c-0.021,0-0.04-0.006-0.046-0.006C138.395,40.843,138.419,40.736,138.442,40.656z"/>
					<polygon points="137.175,40.61 137.415,40.802 136.787,40.776 136.544,40.587 "/>
					<path d="M133.161,45.727c0.776,0.035,1.59,0.019,2.344,0.075c0.131,0.012,0.308,0.023,0.431,0.035
						c1.197,0.094,2.188,0.283,3.413,0.367c0.442,0.028,0.92-0.017,1.351,0.034c0.482,0.06,0.688,0.178,0.891,0.293
						c-3.008,0.025-5.861-0.428-8.942-0.146c0.629,0.106,0.913,0.284,1.513,0.399c-1.731,0.012-3.193-0.33-5.021-0.189
						c-0.296-0.087-0.684-0.207-0.978-0.293c-0.012,0.051-0.036,0.121-0.165,0.132c-0.342,0.037-0.661-0.028-0.997-0.011
						c-0.207-0.408-0.207-0.408-0.96-0.563c0.083,0.092-0.343,0.169-0.143,0.265c0.484,0.04,0.632,0.215,0.672,0.287
						c-0.541,0.071-0.63-0.145-0.972-0.207c-0.748,0.339-3.813-0.546-3.943-0.583c-0.118-0.031-0.271-0.083-0.39-0.117
						c1.049-0.07,2.188-0.023,3.219-0.121c0.755-0.075,0.802-0.099,1.237-0.313c0.083,0.058,0.183,0.133,0.259,0.187
						c0.202,0.026,0.402,0.047,0.615,0.058c0.883,0.025,1.78-0.029,2.663,0.023C130.661,45.414,131.74,45.658,133.161,45.727z"/>
					<path d="M3.131,49.11c-0.158-0.08-0.096-0.178-0.209-0.265c0.2,0.127,0.402,0.255,0.652,0.383
						C3.45,49.185,3.226,49.159,3.131,49.11z"/>
					<path d="M7.618,50.023c-0.021-0.006-0.055-0.012-0.083-0.018c-0.016,0.083,0.197,0.155,0.267,0.235
						c-0.017,0-0.037,0.004-0.051,0.006c-0.529-0.154-0.543-0.355-0.968-0.517c0.021,0.022,0.042,0.055,0.047,0.077
						c-0.021,0.006-0.041,0.012-0.062,0.014c-0.025,0-0.062,0-0.083,0c-0.015,0-0.032,0.007-0.043,0.007
						c-0.399-0.146-0.772-0.276-1.375-0.351c-0.887-0.112-1.464-0.379-1.929-0.592c0.363,0.221,0.356,0.225,0.326,0.271
						c-0.022,0-0.049,0.005-0.07,0.005c-0.003,0.006-0.006,0.013-0.015,0.018c-0.427-0.27-1.022-0.525-1.231-0.813
						c0.064,0.037,0.059,0.083,0.229,0.108c-0.014-0.019-0.049-0.042,0.01-0.06c0.371,0.152,0.533,0.33,1.019,0.468
						c-0.242-0.169-0.237-0.181-0.215-0.215c0.082,0.011,0.156,0.017,0.482,0.146c-0.09-0.106-0.099-0.13-0.005-0.146
						c0.324,0.011,0.408,0.092,0.689,0.118c0.021-0.003,0.042-0.006,0.056-0.01c0.019-0.037-0.073-0.074,0.052-0.108
						c0.614,0.089,1.289,0.362,1.421,0.417c0.323,0.134,0.298,0.295,0.574,0.433c0.178,0.089,0.508,0.149,0.75,0.228
						c0.497,0.154,1.129,0.29,1.513,0.462c0.006,0.006,0.475,0.313,0.292,0.365c-0.05-0.004-0.113-0.01-0.157-0.015
						C8.146,50.356,8.146,50.356,7.618,50.023z"/>
					<path d="M748.988,44.699c-0.571,0-0.655,0.106-0.571,0.252c0.437-0.005,0.857-0.014,1.287-0.021
						C749.464,44.852,749.17,44.786,748.988,44.699z"/>
					<path d="M704.777,42.845c-0.089-0.007-0.196-0.012-0.279-0.018c0.083,0.126,0.202,0.321,1.863,0.311
						c-0.177,0.043-0.418,0.068-0.507,0.126c0.182,0.063,0.477,0.101,0.719,0.149c-0.064,0.137-0.248,0.132-0.754,0.051
						c-0.535-0.079-0.896-0.103-1.25-0.068c-0.053,0.272,0.019,0.511,0.26,0.839l4.728,0.049c-0.873-0.155-1.262-0.325-2.004-0.698
						C706.679,43.141,706.102,42.937,704.777,42.845z M705.305,43.729c-0.051-0.017-0.099-0.034-0.141-0.051
						c0.985,0.028,1.35,0.04,1.35,0.209C705.961,43.878,705.606,43.832,705.305,43.729z"/>
					<path d="M43.472,43.439c0.039-0.061,0.1-0.09,0.326-0.084c0.194,0.006,0.343,0.034,0.503,0.058
						c0.366,0.055,0.604,0.061,1.416,0.086c-0.844-0.066-1.961-0.155-2.806-0.219c0.026,0.006,0.052,0.015,0.073,0.021
						C43.132,43.348,43.273,43.401,43.472,43.439z"/>
					<path d="M52.201,44.183c-0.04-0.069-0.117-0.138-0.07-0.206c-0.27-0.019-0.629-0.047-0.897-0.067
						c0.009,0.003,0.021,0.003,0.026,0.007C51.743,43.998,51.922,44.027,52.201,44.183z"/>
					<path d="M112.01,47.232c-0.072-0.007-0.154-0.01-0.224-0.012c0.052,0.018,0.129,0.034,0.168,0.052
						C112.008,47.255,111.995,47.243,112.01,47.232z"/>
					<path d="M85.101,45.975c-0.129,0.011-0.259,0.017-0.39,0.022l0.62,0.034c-0.07-0.017-0.135-0.031-0.207-0.048
						C85.124,45.983,85.106,45.978,85.101,45.975z"/>
					<path d="M1768.022,29.991c0.105-0.053,0.355-0.173,0.129-0.259c-0.324-0.121-0.982-0.146-1.418-0.241
						c-0.049,0.069-0.107,0.167-0.043,0.253C1766.856,29.957,1767.675,29.979,1768.022,29.991z"/>
					<path d="M1764.958,29.761c0.285-0.154-0.043-0.187-0.83-0.27c0.01,0.018,0.016,0.041,0.025,0.058
						C1764.269,29.687,1764.622,29.735,1764.958,29.761z"/>
					<path d="M1055.021,1.459c0.307,0.126,1.158,0.063,1.242-0.034c0.137-0.139-0.404-0.149-1.299-0.167
						C1054.919,1.304,1054.845,1.39,1055.021,1.459z"/>
					<path d="M1722.964,29.802c0.023-0.044,0.08-0.173-0.701-0.235c-0.385-0.023-0.717-0.018-0.986,0.023
						c-0.012,0.036-0.023,0.074,0.037,0.108C1721.515,29.842,1722.415,29.894,1722.964,29.802z"/>
					<path d="M1044.972,2.685c0.098,0.241,0.088,0.371-0.232,0.531c0.039-0.005,0.078-0.011,0.109-0.018
						c1-0.184,1.418-0.533,1.248-1.045C1044.907,2.234,1044.843,2.372,1044.972,2.685z"/>
					<path d="M1711.175,30.87c0.713,0.006,0.484-0.201,0.131-0.282c-0.09-0.022-0.201-0.039-0.318-0.049
						c-0.096-0.009-0.189-0.009-0.279-0.006c-0.066,0.034-0.109,0.066-0.098,0.104c0,0.002,0,0.005,0.012,0.008
						C1710.728,30.732,1711.198,30.767,1711.175,30.87z"/>
					<path d="M1673.345,29.577c-0.021-0.155-0.15-0.163-0.582-0.189c-1.668-0.086-2.139,0.356-2.078,0.396
						c0.309,0.207,0.717,0.391,2.217,0.413C1673.042,29.991,1673.38,29.79,1673.345,29.577z"/>
					<path d="M1667.739,29.569c-0.051-0.331-0.057-0.383-0.627-0.425c-0.381-0.021-0.615,0.1-0.486,0.191
						C1666.669,29.365,1666.896,29.509,1667.739,29.569z"/>
					<path d="M1080.712,6.372c0.035,0,0.078-0.003,0.113-0.003c1.578-0.069,1.625-0.431,1.637-0.546
						c-0.682-0.022-1.037-0.08-1.295-0.224c-0.566,0.037-0.535,0.189-0.443,0.437C1080.79,6.197,1080.813,6.283,1080.712,6.372z"/>
					<path d="M1662.901,29.848c0.012,0.005,0.035,0.009,0.047,0.015c0.402,0.123,1.051,0.157,1.369,0.169
						c0.057-0.08,0.146-0.189,0.211-0.271c-0.283,0.018-0.486-0.028-0.736-0.045C1662.638,29.644,1662.878,29.825,1662.901,29.848z"/>
					<path d="M1574.815,25.195c0.076-0.114,0.176-0.268,0.246-0.379c0.236,0.098,0.455,0.179,0.992,0.224
						c0.879,0.075,1.838,0.015,2.711,0.087c-0.166-0.322-0.383-0.322-1.422-0.189c-0.244-0.193-0.551-0.276-1.215-0.322
						c-1.318-0.058-2.393,0.196-2.066,0.394C1574.208,25.104,1574.606,25.161,1574.815,25.195z"/>
					<path d="M1056.571,5.835c-0.393-0.005-0.916-0.018-1.314-0.028l-0.008,0.398c0.014,0,0.029,0.003,0.039,0.003
						C1055.741,6.231,1056.767,6.242,1056.571,5.835z"/>
					<path d="M1660.298,29.882c0.01,0,0.027,0,0.047-0.003c0.205-0.014,0.67-0.074,0.473-0.255
						c-0.061-0.013-0.127-0.018-0.189-0.023c-0.525-0.023-0.525,0.16-1.043,0.135c0,0.02,0.006,0.038,0.029,0.058
						C1659.677,29.848,1659.89,29.899,1660.298,29.882z"/>
					<path d="M1054.597,6.622c0.26,0.184,0.307,0.264,0.15,0.447c0.033,0,0.072-0.005,0.098-0.011
						c0.896-0.126,1.129,0.065,1.213,0.138c1.875-0.144,0.721-0.522-0.402-0.884c-0.389-0.013-0.914-0.023-1.307-0.032
						C1054.343,6.412,1054.378,6.462,1054.597,6.622z M1055.243,6.702l0.826,0.018v0.189l-0.83-0.018L1055.243,6.702z"/>
					<polygon points="1564.489,24.639 1563.353,24.578 1563.224,24.775 1564.366,24.839 "/>
					<path d="M1071.337,6.96c-0.436-0.034-0.68-0.056-0.781-0.131l-0.422,0.385l1.721,0.039
						C1072.233,7.064,1072.011,7.013,1071.337,6.96z"/>
					<path d="M1510.165,22.548c0,0,0.02,0,0.025,0.003c0.691,0.055,1.152,0.003,1.305-0.015
						c0.506-0.061,0.764-0.089,1.49,0.058c0.082-0.138-0.738-0.25-1.525-0.293C1510.429,22.258,1509.993,22.341,1510.165,22.548z"/>
					<path d="M1626.737,29.106c-0.117-0.092-0.117-0.138-0.098-0.218c0.049-0.087,0-0.155-0.316-0.294
						c-0.637,0.026-0.695,0.236-0.543,0.351C1625.97,29.084,1626.392,29.118,1626.737,29.106z"/>
					<path d="M1575.044,25.993c-0.053-0.005-0.119-0.011-0.166-0.011c-0.729-0.038-1.07,0.029-1.143,0.224
						c0,0,0.018,0,0.023,0C1574.368,26.243,1574.95,26.24,1575.044,25.993z"/>
					<path d="M1541.567,24.374c0.088-0.04,0.119-0.092,0.143-0.141c-0.656-0.031-1.299-0.065-1.953-0.101
						c0,0.035,0.031,0.066,0.063,0.095C1540.114,24.414,1541.175,24.569,1541.567,24.374z"/>
					<path d="M1572.604,26.143c0.236-0.16-0.213-0.201-0.791-0.232c-0.068-0.003-0.16-0.009-0.24-0.014
						c0.018,0.011,0.029,0.022,0.035,0.034C1571.8,26.077,1572.218,26.12,1572.604,26.143z"/>
					<path d="M1538.585,24.747c-0.688-0.281-0.779-0.35-0.834-0.619c-0.469-0.023-1.107-0.058-1.578-0.081
						c-0.043,0.068-0.123,0.23,0.086,0.38C1536.649,24.689,1537.769,24.736,1538.585,24.747z"/>
					<path d="M1498.788,22.24c-0.084-0.043-0.084-0.043-0.361-0.058c-0.773-0.031-1.102,0.067-1.125,0.342
						c0.014,0,0.029,0.006,0.047,0.006C1498.431,22.638,1499.106,22.415,1498.788,22.24z"/>
					<path d="M1060.868,8.589c0.037-0.249-0.836-0.283-1.014-0.29c-0.314-0.003-0.496,0.012-0.701,0.046
						c0.008,0.029,0.041,0.055,0.082,0.081c0.006,0.003,0.018,0.006,0.029,0.011C1059.495,8.534,1059.96,8.581,1060.868,8.589z"/>
					<path d="M1522.151,25.658c-0.107-0.061-0.236-0.144-0.33-0.204l-0.732-0.034c-0.059,0.025-0.135,0.074-0.064,0.114
						C1521.099,25.585,1521.099,25.585,1522.151,25.658z"/>
					<path d="M1511.093,25.305c-0.059,0.132-0.566,0.225-0.578,0.358c0.037-0.003,0.084-0.005,0.119-0.008
						c0.691-0.063,1.197-0.052,1.779-0.034c0.426,0.011,0.639,0.008,0.896-0.01c-0.211-0.152-0.725-0.235-1.814-0.289
						C1511.354,25.311,1511.222,25.308,1511.093,25.305z"/>
					<path d="M1506.942,25.37c-1.082-0.111-2.273-0.149-3.395-0.232c0.15,0.099,0.246,0.161,0.309,0.331
						c0.021,0.065,0.045,0.135,0.168,0.194c0.174,0.09,0.504,0.152,0.787,0.21c0.896-0.12,0.959-0.109,1.748,0.021
						c0.611,0.1,1.027,0.118,1.377,0.129c0.35-0.155,0.434-0.241,0.344-0.359c-0.018-0.014-0.031-0.025-0.051-0.037
						C1508.065,25.546,1507.839,25.462,1506.942,25.37z"/>
					<path d="M1513.157,26.758c0.422,0.037,0.777-0.052,1.201-0.034c-0.082-0.064-0.188-0.149-0.266-0.214
						c-0.588,0.026-0.854,0.096-0.949,0.248C1513.144,26.758,1513.157,26.761,1513.157,26.758z"/>
					<path d="M1396.907,22.077c0.088-0.003,0.203-0.006,0.289-0.006c1.137-0.031,2.32,0.135,3.432-0.046
						c0.197-0.322-1.252-0.367-1.818-0.554c-1.035,0.181-1.203,0.209-2.119,0.113c-0.213,0.13-0.158,0.176,0.086,0.279
						C1396.995,21.956,1396.987,21.996,1396.907,22.077z"/>
					<path d="M1392.843,21.808c-0.055-0.006-0.115-0.012-0.178-0.012c-0.604-0.023-0.639,0.095-0.693,0.272
						c0.246-0.021,0.568-0.043,0.805-0.063L1392.843,21.808z"/>
					<path d="M1394.979,22.95c0.99-0.179,0-0.454-0.908-0.498c-0.635-0.019-0.9,0.07-1.049,0.142
						c0.02,0,0.035,0.005,0.053,0.012C1394.321,22.921,1394.321,22.921,1394.979,22.95z"/>
					<path d="M1390.101,22.74c0.109,0.037,0.109,0.037,1.613,0.078c-0.094-0.136-0.426-0.207-1.148-0.236
						c-0.154-0.008-0.301-0.012-0.453-0.012C1390.052,22.614,1389.944,22.688,1390.101,22.74z"/>
					<path d="M1398.005,23.68c1.123,0.02,2.188-0.075,3.293-0.083c-1.031-0.142-1.916-0.216-2.869-0.259
						c-1.209-0.043-2.057-0.009-2.846,0.117c0.08,0.018,0.201,0.034,0.281,0.047C1396.933,23.659,1397.601,23.673,1398.005,23.68z"/>
					<path d="M1389.849,23.622c0.668,0.063,1.076,0.04,1.436,0.017c0.412-0.028,0.582-0.028,0.939-0.02
						c-0.027-0.078-0.701-0.146-1.359-0.175c-0.906-0.032-1.277,0.025-1.104,0.168C1389.778,23.615,1389.815,23.619,1389.849,23.622z"/>
					<polygon points="1023.397,13.496 1023.394,13.307 1022.497,13.29 1022.503,13.479 "/>
					<path d="M1325.771,22.563c0.047-0.043-0.033-0.09-0.07-0.112c-0.584-0.012-1.129,0.074-1.715,0.035
						c-0.018,0.017-0.006,0.037,0.031,0.051C1324.286,22.648,1325.618,22.692,1325.771,22.563z"/>
					<path d="M1242.183,21.322c0.607-0.055,0.615-0.248,0.615-0.33c0.01-0.309-0.475-0.598-0.584-0.903
						c-0.508,0.312-0.328,0.911-0.174,1.241C1242.079,21.327,1242.14,21.325,1242.183,21.322z"/>
					<polygon points="1253.433,21.401 1253.063,21.187 1252.188,21.271 1252.626,21.472 "/>
					<path d="M1401.212,26.878c-0.02-0.012-0.045-0.028-0.066-0.04c-0.248-0.114-0.549-0.161-1.225-0.195
						c-0.955-0.034-1.936,0.009-2.877-0.052c-0.484,0.115-0.621,0.218-0.604,0.454c0.152-0.052,0.357-0.114,0.508-0.167
						c0.426,0.189,0.848,0.207,1.688,0.179c0.682-0.029,1.004-0.041,1.047,0.118c0.52-0.07,0.957-0.063,1.615-0.026
						C1401.329,27.016,1401.312,26.971,1401.212,26.878z"/>
					<path d="M1289.853,22.656c-0.057-0.034-0.154-0.063-0.246-0.092c-0.57,0.018-0.873,0.099-0.91,0.251
						c0.025,0.003,0.061,0.003,0.086,0.008C1289.911,22.927,1290.089,22.783,1289.853,22.656z"/>
					<path d="M765.096,12.228c-0.028-0.187-0.595-0.265-1.114-0.27c-0.317-0.003-0.525,0.016-0.689,0.057
						c0.01,0.006,0.018,0.012,0.035,0.012C763.699,12.17,764.512,12.21,765.096,12.228z"/>
					<path d="M759.213,12.232c0.182,0.069,0.442,0.087,0.767,0.05c-0.031-0.089-0.066-0.213-0.089-0.305
						c-0.107-0.012-0.224-0.02-0.336-0.022C758.95,11.958,758.996,12.159,759.213,12.232z"/>
					<path d="M1395.55,26.617c-0.381-0.009-0.668,0.065-1.047,0.055c-0.031,0.034-0.09,0.115,0.039,0.188
						c0.178,0.095,0.639,0.145,1.521,0.167c0.119-0.138-0.211-0.264-0.316-0.396C1395.687,26.625,1395.616,26.619,1395.55,26.617z"/>
					<path d="M1385.468,26.731c0.137,0.056,0.412,0.084,0.623,0.095c0.596,0.04,1.221,0.04,1.828,0.063
						c0.16-0.31-1.676-0.224-2.406-0.373C1385.421,26.583,1385.302,26.663,1385.468,26.731z"/>
					<path d="M1321.372,25.152c0.154,0.081,0.637,0.192,1.168,0.167c0.107-0.106-0.033-0.144-0.375-0.192
						c-0.277-0.043-0.383-0.069-0.408-0.129C1321.163,25.012,1321.286,25.108,1321.372,25.152z"/>
					<path d="M1013.44,17.878c1.754-0.021,2.584-0.267,2.465-0.723c-0.746-0.023-1.09-0.074-1.391-0.213
						c-1.32,0.078-1.324,0.438-1.195,0.936C1013.349,17.878,1013.396,17.878,1013.44,17.878z"/>
					<path d="M1232.228,23.237c0.145,0.071,0.547,0.135,0.682,0.04c0.078-0.061,0.023-0.149-0.012-0.201
						C1231.952,23.07,1232.144,23.196,1232.228,23.237z"/>
					<path d="M1316.497,26.345c0.01,0.008,0.057,0.016,0.078,0.022c0.492,0.121,1.377,0.108,2.24,0.087
						c1.889-0.047,2.105,0.017,2.229,0.051c1.197-0.333-1.107-0.517-2.104-0.557C1315.976,25.862,1316.483,26.339,1316.497,26.345z"/>
					<path d="M1282.888,25.127c0.762,0.086,0.781-0.015,0.801-0.104c0.021-0.118,0.066-0.164,0.422-0.155
						c-0.092-0.069-0.199-0.098-0.422-0.109c-0.885-0.02-1.063,0.305-0.873,0.356C1282.827,25.121,1282.864,25.121,1282.888,25.127z"/>
					<path d="M1242.22,23.803c0.092,0.046,0.326,0.111,0.775,0.061c0.109-0.149-0.297-0.267-0.42-0.402
						C1242.159,23.461,1241.933,23.677,1242.22,23.803z"/>
					<path d="M1014.476,18.57c0.064,0.089-0.066,0.219-0.145,0.303c0.043-0.007,0.092-0.018,0.139-0.023
						c0.541-0.092,0.73-0.271,1.451-0.325c0.471-0.034,1.182,0.066,1.447,0.107c-0.354-0.122-0.871-0.222-1.172-0.356
						c-0.201-0.089-0.195-0.188-0.195-0.253c-0.756,0.034-1.338,0.184-2.168,0.167C1014.003,18.32,1014.374,18.433,1014.476,18.57z"/>
					<path d="M1316.075,26.146c-0.371-0.014-0.865-0.031-1.23-0.043l-0.061,0.276c0,0,0.012,0,0.023,0
						C1315.575,26.41,1316.079,26.384,1316.075,26.146z"/>
					<path d="M1311.519,25.988c-0.082-0.006-0.166-0.012-0.246-0.018c-0.473-0.012-0.508,0.041-0.658,0.264
						c0.266-0.017,0.609-0.045,0.871-0.063L1311.519,25.988z"/>
					<path d="M1286.175,25.135c-0.588,0.009-0.604,0.306-0.258,0.377c0.223,0.046,0.465,0.018,0.588,0.005
						c-0.129,0.084-0.307,0.196-0.447,0.279c-0.627-0.164-2.266-0.164-2.279-0.167c-0.443,0.003-0.639-0.008-1.043-0.037
						c0.068,0.143,0.08,0.166-0.238,0.281c-0.33,0.115-0.314,0.139-0.242,0.278c0.043,0,0.096,0.004,0.135,0.007
						c0.531,0.024,0.896,0.14,1.488,0.137c0.129-0.1,0.258-0.135,0.836-0.16c0.637-0.023,0.891-0.049,1.32-0.152
						c0.611,0.003,0.848,0.092,1.025,0.187c0.27,0.141,0.41,0.21,1.037,0.083c-0.141-0.077-0.395-0.135-0.529-0.206
						c0.258-0.078,0.658-0.109,0.988-0.167c0.086-0.184-0.092-0.236-0.848-0.35c-0.713-0.109-0.848-0.185-0.684-0.368
						C1286.774,25.155,1286.431,25.144,1286.175,25.135z"/>
					<path d="M1397.774,29.291c-0.191,0.045-0.787,0.178-0.357,0.396c0.404,0.204,1.959,0.491,3.408,0.299
						c-0.17-0.275-0.646-0.333-1.613-0.396C1398.351,29.535,1397.964,29.479,1397.774,29.291z"/>
					<path d="M1308.548,26.459c0.133-0.112,0.318-0.262,0.459-0.373l-1.234-0.04c-0.109,0.06-0.213,0.131-0.055,0.197
						C1307.919,26.326,1308.419,26.355,1308.548,26.459z"/>
					<path d="M1006.089,19.114c0.041-0.003,0.1-0.007,0.141-0.013c0.566-0.063,0.531-0.171,0.482-0.286
						c-0.059-0.162,0.023-0.245,1.086-0.251c-0.152-0.095-0.369-0.218-0.521-0.313l-1.303-0.022
						C1005.38,18.539,1005.649,18.792,1006.089,19.114z"/>
					<path d="M1290.229,26.832c0.008-0.006,0.084-0.103-0.293-0.12c-0.215-0.006-0.418,0.018-0.68,0.055
						c0.018,0.005,0.043,0.011,0.055,0.014C1289.827,26.947,1290.169,26.907,1290.229,26.832z"/>
					<path d="M1103.103,22.278c0.074,0.034,0.178,0.063,0.283,0.089c0.84-0.018,0.867-0.17,0.639-0.29
						c-0.012-0.006-0.025-0.012-0.037-0.018c-0.059-0.029-0.129-0.052-0.217-0.074C1102.833,22.002,1102.864,22.175,1103.103,22.278z"/>
					<path d="M1286.304,27.269c0.318,0.164,0.93,0.187,1.141,0.195c0.227-0.16-0.195-0.189-1.209-0.241
						C1286.253,27.237,1286.28,27.254,1286.304,27.269z"/>
					<polygon points="1282.077,27.285 1282.933,27.314 1282.962,27.117 1282.108,27.085 "/>
					<path d="M1421.024,32.702c-0.6-0.078-0.982-0.112-1.559-0.139c-1.537-0.051-2.998,0.092-4.514,0.092
						c0.141,0.099,0.258,0.184,0.049,0.432c-0.158,0.184-0.266,0.304,0.061,0.411c0.188,0.06,0.49,0.094,0.775,0.126
						c-0.191-0.066-0.346-0.123-0.26-0.193c0.145-0.105,0.574-0.16,0.848-0.244c0.539,0.047,0.566,0.216,1.154,0.244
						c0.564,0.034,0.738-0.098,0.689-0.137c-0.111-0.095-0.633-0.145-0.588-0.254c0.004-0.022,0.092-0.076,0.691-0.06
						c1.234,0.031,1.234,0.031,1.375-0.037c0.012,0.057,0.049,0.112,0.111,0.167c0.035,0.021,0.066,0.039,0.102,0.063
						c0.258,0.126,0.354,0.158,0.813,0.287c0.508-0.104,0.412-0.161,0.037-0.339C1420.347,32.896,1420.583,32.814,1421.024,32.702z"/>
					<path d="M1231.442,26.567c0.213,0.09,0.715,0.139,1.514,0.149c0.01-0.085,0.018-0.207,0.031-0.292
						c-0.129-0.012-0.26-0.018-0.402-0.023c-0.453-0.008-0.838,0.049-1.26,0.063C1231.337,26.505,1231.358,26.533,1231.442,26.567z"/>
					<path d="M1266.479,27.835c-0.107-0.061-0.248-0.146-0.367-0.21l-0.863-0.028c-0.021,0.034-0.068,0.086,0.033,0.131
						C1265.405,27.78,1265.405,27.78,1266.479,27.835z"/>
					<path d="M1234.544,27.183c0.197,0.098,0.537,0.195,0.885,0.178c0.02-0.08-0.023-0.129-0.201-0.225
						c-0.207-0.113-0.344-0.191-0.156-0.355c-0.059-0.006-0.113-0.009-0.174-0.012C1234.036,26.758,1234.177,27.01,1234.544,27.183z"/>
					<polygon points="1062.872,23.116 1062.048,23.099 1062.071,23.288 1062.882,23.306 "/>
					<path d="M1234.612,27.613c-0.637-0.098-1.449-0.077-2.109-0.152c0.037,0.021,0.082,0.046,0.125,0.063
						c0.27,0.125,0.605,0.162,0.91,0.199c0.51,0.063,0.75,0.104,0.572,0.355C1235.099,28.11,1234.386,27.765,1234.612,27.613z"/>
					<path d="M1225.312,28.005c0.117-0.023,0.275-0.058,0.402-0.081l0.012-0.184l-0.402,0.079l-1.246-0.131
						c-0.217,0.045-0.557,0.117-0.369,0.166C1224.134,27.969,1224.946,27.863,1225.312,28.005z"/>
					<path d="M1280.905,30.091c0.248-0.089,0.414-0.129,1.191-0.048c0.342-0.058,0.217-0.089-0.4-0.115
						c-0.908-0.025-2.006,0.021-1.643,0.155c0.092,0.037,0.238,0.063,0.387,0.092C1280.636,30.169,1280.716,30.158,1280.905,30.091z"/>
					<polygon points="1276.677,29.865 1275.894,29.842 1275.872,30.025 1276.655,30.052 "/>
					<path d="M1225.255,28.957l1.26-0.058c0.012-0.003,0.27-0.471-0.756-0.505c-0.471-0.009-0.885,0.046-1.332,0.063
						C1224.673,28.607,1225.005,28.808,1225.255,28.957z"/>
					<path d="M1051.495,24.914c0.838-0.006,0.502-0.149-0.047-0.391c-0.236,0-0.848,0-0.25,0.271
						C1051.296,24.833,1051.403,24.87,1051.495,24.914z"/>
					<polygon points="975.435,24.679 975.392,24.475 974.501,24.461 974.544,24.661 "/>
					<path d="M1277.657,32.168c0.033,0.034,0.066,0.063,0.135,0.092c0.32,0.132,1.098,0.146,1.545,0.146
						c0.242-0.152-0.012-0.181-0.709-0.207C1278.306,32.19,1277.97,32.196,1277.657,32.168z"/>
					<path d="M975.886,26.625c0.25,0.089,1.135,0.162,1.258,0.029c0.123-0.145-0.178-0.281-0.08-0.42
						c-0.115-0.011-0.234-0.019-0.352-0.022C975.769,26.212,975.546,26.493,975.886,26.625z"/>
					<path d="M1040.013,28.102c0.258,0.101,0.602,0.063,0.756,0.046c-0.014-0.063-0.025-0.143-0.037-0.2l-0.42-0.104
						C1039.815,27.84,1039.767,28.005,1040.013,28.102z"/>
					<path d="M975.976,27.085c0.018,0.012,0.063,0.017,0.088,0.022c0.729,0.146,2.133,0.093,2.031-0.191
						c-0.016-0.032-0.039-0.061-0.082-0.093c-0.18-0.002-0.371-0.008-0.557-0.015C975.386,26.78,975.968,27.085,975.976,27.085z"/>
					<path d="M1038.114,29.721c0.596,0.034,1.064-0.097,1.652-0.063c-0.141-0.253-0.648-0.377-1.77-0.42
						c0.039,0.161,0.061,0.322,0.096,0.482C1038.104,29.721,1038.11,29.721,1038.114,29.721z"/>
					<path d="M1280.8,35.706c0.07,0.027,0.178,0.051,0.295,0.068c0.252-0.052,0.602-0.12,0.848-0.172
						c-0.104-0.069-0.221-0.098-0.459-0.11C1280.997,35.481,1280.587,35.607,1280.8,35.706z"/>
					<path d="M964.567,28.149c-1.023,0.032-0.08,0.417-0.068,0.424c0.053,0.021,0.113,0.045,0.199,0.063
						C965.749,28.618,964.817,28.21,964.567,28.149z"/>
					<path d="M1038.919,29.828c-0.215,0.002-0.607,0.002-0.744,0.134c-0.178,0.173,0.059,0.346,0.07,0.517
						c0.012-0.003,0.043-0.005,0.061-0.005c0.766-0.104,1.137-0.184,1.521-0.535C1039.554,29.904,1039.188,29.859,1038.919,29.828z"/>
					<path d="M1037.622,31.427c1.07,0.068,1.236-0.061,0.941-0.178c-0.08-0.035-0.248-0.08-0.518-0.093
						c-0.545,0-0.531,0.05-0.496,0.265C1037.573,31.424,1037.604,31.427,1037.622,31.427z"/>
					<path d="M1037.856,32.438c0.125,0.04,0.248-0.034,0.291-0.098c0.063-0.104-0.043-0.206-0.172-0.212
						C1037.679,32.136,1037.646,32.38,1037.856,32.438z"/>
					<polygon points="1038.765,32.972 1039.577,32.985 1039.53,32.785 1038.724,32.771 "/>
					<polygon points="759.939,34.941 760.788,34.953 760.675,34.767 759.833,34.758 "/>
					<path d="M752.96,35.499c0.012,0.006,0.023,0.009,0.035,0.014c0.33,0.106,0.648,0.061,0.761,0.047
						c-0.053-0.089-0.129-0.207-0.183-0.296c-0.106-0.013-0.214-0.018-0.332-0.023C752.748,35.243,752.729,35.396,752.96,35.499z"/>
					<path d="M1309.62,28.223c0.32,0.131,1.109,0,1.309-0.149c0.154-0.115-0.08-0.173-0.17-0.196
						c-0.279,0.128-0.512,0.173-1.268,0.128C1309.487,28.056,1309.46,28.152,1309.62,28.223z"/>
					<polygon points="1310.765,27.86 1310.759,27.877 1310.831,27.863 "/>
					<path d="M1311.942,28.196c0.59,0.011,1.109-0.089,1.711-0.049c0.129-0.149-0.141-0.187-0.66-0.244
						c-0.537-0.061-0.732-0.112-0.555-0.262c-1.002,0-1.313,0.072-1.607,0.222c0.049,0.003,0.111,0.003,0.152,0.003
						C1312.052,27.924,1311.979,28.113,1311.942,28.196z"/>
					<path d="M1500.53,22.632c1.369-0.062,1.369-0.062,7.498,0.111c0.957-0.299,0.957-0.299,1.77-0.213
						c-0.432-0.232-0.578-0.31-1.463-0.354c0.432-0.191,0.873-0.267,1.816-0.301c-0.473-0.046-0.969-0.08-1.469-0.104
						c-1.943-0.083-1.943-0.083-9.059,0.08c0.129,0.268,0.336,0.534,0.398,0.804C1500.177,22.646,1500.378,22.635,1500.53,22.632z"/>
					<path d="M1489.438,22.215c0.006,0.028-0.283,0.104-0.59,0.192c0.049,0,0.109-0.003,0.158-0.006
						c0.951-0.028,2.176,0.006,3.863,0.101c0.24-0.095,0.295-0.142,0.262-0.241c-0.021-0.068,0-0.089,0.303-0.121
						c-0.354-0.068-0.766-0.106-1.697-0.151c-0.918-0.044-1.908-0.066-3.029-0.071c0.104,0.12,0.225,0.194,0.588,0.255
						C1489.356,22.183,1489.431,22.192,1489.438,22.215z"/>
					<path d="M1490.452,25.233c0.568,0.134,1.396,0.221,2.492,0.261c0.221-0.046,0.533-0.052,0.732-0.104
						c0.176-0.044,0.184-0.065,0.207-0.138c0.814,0.172,1.473,0.253,3.012,0.229c1.371-0.018,1.955,0.052,2.711,0.327
						c1.018,0.019,1.797-0.209,2.859-0.146c0.057-0.083,0.141-0.198,0.199-0.283c-0.848-0.112-1.451-0.162-2.605-0.222
						c-1.996-0.089-4.127-0.037-5.986-0.284c-0.934,0.234-1.83,0.308-3.82,0.305C1490.312,25.195,1490.394,25.213,1490.452,25.233z"/>
					<path d="M1284.915,23.335c0.139,0.052,0.424,0.018,0.846-0.047c0.426-0.054,0.555-0.065,0.744-0.065
						c-0.08-0.077-0.152-0.101-0.33-0.111c-0.107,0-0.234,0-0.652,0.079c-0.215,0.041-0.479,0.095-0.68,0.07
						C1284.854,23.285,1284.86,23.312,1284.915,23.335z"/>
					<path d="M767.318,13.936c0.041-0.005,0.095-0.008,0.129-0.017c1.19-0.17,0.365-0.633-0.79-0.775
						c-0.354,0.054-0.249,0.126,0.153,0.305C767.26,13.649,767.448,13.775,767.318,13.936z"/>
					<path d="M1270.812,28.495c-0.766,0.042-1.088,0.049-1.441-0.089c-0.051,0-0.135,0.005-0.193,0.005
						c-0.041,0.006-0.082,0.006-0.129,0.013c-0.059,0.011-0.098,0.017-0.025,0.045c0.201,0.063,0.566,0.098,0.732,0.173
						c0.141,0.063,0.068,0.095-0.031,0.144c1.729-0.023,2.082-0.012,3.791,0.121c0.117-0.121,0.023-0.155-0.389-0.236
						c-0.361-0.065-0.402-0.092-0.412-0.161c-0.197-0.022-0.404-0.04-0.625-0.048C1271.733,28.452,1271.438,28.455,1270.812,28.495z"/>
					<path d="M1276.485,31.473c-0.076,0.145,0.287,0.265,0.422,0.396c0.014,0,0.039-0.006,0.055-0.012
						c0.359-0.08,1.182-0.132,1.188-0.075c-0.006,0.029-0.285,0.081-0.459,0.113c0.129,0.151,0.809,0.031,1.084-0.055
						c0.303-0.095,0.27-0.161,0.252-0.196C1278.067,31.671,1277.368,31.508,1276.485,31.473z"/>
					<path d="M1038.429,28.969c0.502,0.089,1.113,0.112,1.705,0.126c-0.16-0.141-0.178-0.212,0.068-0.344
						c0.207-0.115,0.225-0.144,0.229-0.225c-0.629-0.034-0.781-0.215-1.441-0.241c-0.537-0.006-0.623,0.046-0.592,0.061
						c0.092,0.031,0.662,0.061,1.139,0.055c-0.088,0.089-0.262,0.126-0.637,0.189C1037.776,28.785,1038.423,28.964,1038.429,28.969z"/>
					<path d="M1029.581,27.935c0.232,0.07,0.447,0.144,0.674,0.213c0.016,0.005,0.037,0.012,0.059,0.018
						c0.758,0.229,1.428,0.341,2.369,0.401c-0.506-0.244-0.35-0.281,0.225-0.373c-0.381-0.006-0.822-0.013-1.266-0.021
						c1.375,0.022,1.457,0.006,1.824-0.071c-0.49-0.488-0.643-0.784-0.631-1.255c-1.381-0.158-1.709-0.198-2.682-0.253
						c-0.137-0.197,0.193-0.404-0.07-0.601c-0.055-0.039-0.289-0.097-0.855-0.086c-0.051-0.04-0.105-0.103-0.051-0.146
						c0.264-0.034,0.623-0.006,0.852-0.065c0.131-0.032,0-0.104-0.049-0.145c-0.32-0.034-0.646-0.06-0.986-0.074
						c-0.842-0.021-1.574,0.104-2.402,0.104c-0.111,0.075-0.252,0.173-0.32,0.25c-0.402,0.434-0.178,0.882-0.625,1.313
						c-0.32,0.31-0.875,0.413-0.932,0.425c-0.377,0.063-0.738,0.126-0.258,0.308c0.152,0.057,0.33,0.109,0.416,0.172
						c1.16,0.021,2.719,0.049,3.873,0.071C1028.78,27.986,1028.962,27.947,1029.581,27.935z"/>
					<path d="M977.118,30.826c0.996-0.681,0.996-0.681,1.174-0.893c0.061-0.068,0.117-0.163,0.129-0.235
						c0.141-0.655-0.395-0.729-1.068-0.824c-1.598-0.227-0.947-0.413-0.941-0.416c0.225-0.061,1.209,0.043,1.23,0.194
						c0.236-0.068,0.285-0.079,0.201-0.2c-0.166-0.225,0.014-0.235,0.975-0.259c-0.268-0.175-0.408-0.228-1.607-0.46
						c-0.092-0.017-0.197-0.04-0.289-0.054c-0.785,0.082-1.676,0.333-0.645,0.657c-0.225-0.04-0.385-0.06-0.699-0.08
						c0.273,1.024,0.633,2.395,0.902,3.423c0.092-0.012,0.221-0.023,0.303-0.041C978.032,31.393,976.724,31.091,977.118,30.826z"/>
					<polygon points="965.405,31.231 965.401,31.234 965.405,31.237 "/>
					<path d="M747.396,33.759c-1.71,0.052-2.069,0.329-2.493,0.651c0.023,0.009,0.052,0.015,0.071,0.021
						c0.159,0.045,0.288,0.092,0.417,0.141c1.049,0.012,2.464,0.025,3.514,0.037c-0.419-0.172-0.807-0.361-1.414-0.79
						C747.454,33.799,747.426,33.775,747.396,33.759z"/>
					<path d="M1101.46,18.37c-0.158-0.013-0.471-0.058-0.617-0.084c-0.604-0.109-0.049-0.126,0.215-0.131
						c-0.063-0.013-0.129-0.019-0.203-0.023c-0.072,0-0.146,0-0.213,0c-0.756,0.037-2.605,0.511-0.855,0.775
						c-0.195-0.01-0.701-0.034-0.822,0.034c-0.068,0.037-0.063,0.074-0.02,0.188c0.033,0.075,0.057,0.152,0.041,0.23l2.104,0.049
						C1101.077,19.06,1101.796,18.724,1101.46,18.37z"/>
					<path d="M1294.958,29.81h-0.01c-0.037,0.003-0.061,0.009-0.061,0.021l0.123-0.022
						C1294.991,29.808,1294.972,29.808,1294.958,29.81z"/>
					<path d="M0.997,5.422c0.238-0.087-0.311-0.225-0.603-0.299c-0.016,0.014-0.043,0.052,0.08,0.132
						C0.62,5.347,0.917,5.45,0.997,5.422z"/>
					<path d="M3.437,12.359c0.056-0.04,0.113-0.04,0.195-0.034c-0.106-0.179-0.244-0.227-0.511-0.287
						c-0.206-0.046-0.286-0.075-0.385-0.149c-0.435,0.046,0.33,0.482,0.339,0.482C3.308,12.429,3.378,12.4,3.437,12.359z"/>
					<path d="M2.344,12.749c0.411,0.058,0.801,0.125,1.193,0.19c1.809,0.293,2.676,0.373,2.688,0.373
						c0.472,0.031,0.573-0.028,0.439-0.27c-0.892-0.115-1.739-0.253-2.7-0.345c-0.857-0.069-1.262-0.063-1.789,0.035
						C2.224,12.735,2.294,12.744,2.344,12.749z"/>
					<path d="M0.858,12.785c0.125-0.016,0.105-0.052,0.21-0.067c-0.091-0.111-0.329-0.146-0.395-0.152
						c-0.406-0.036-0.047,0.202-0.044,0.202S0.753,12.796,0.858,12.785z"/>
					<path d="M2.445,15.371C0.624,15.2,0.624,15.2,0.099,15.225c0.062,0.07,0.124,0.139,0.246,0.204
						c0.323,0.176,0.792,0.204,0.969,0.115c0.067-0.031,0.053-0.068,0.047-0.103c1.063,0.243,1.807,0.249,2.744,0.26
						C3.615,15.547,3.229,15.452,2.445,15.371z"/>
					<path d="M4.923,15.639c-0.033-0.006-0.324-0.017-0.04,0.144c0.267,0.157,0.612,0.259,0.718,0.213
						C5.707,15.949,5.74,15.73,4.923,15.639z"/>
					<path d="M1.003,16.477c0.059,0.07,0.125,0.139,0.227,0.202c0.243,0.148,0.494,0.148,0.588,0.148
						C1.648,16.641,1.567,16.621,1.003,16.477z"/>
					<polygon points="6.376,17.354 6.077,17.052 5.678,17.017 6.113,17.327 "/>
					<polygon points="5.046,17.833 5.253,18.033 5.78,18.082 5.58,17.881 "/>
					<path d="M4.088,17.925c0.015,0.014,0.036,0.031,0.061,0.046c0.138,0.08,0.401,0.12,0.479,0.074
						c0.03-0.018,0.014-0.167-0.249-0.192C4.195,17.842,4.192,17.901,4.088,17.925z"/>
					<path d="M0.726,17.595c0.186,0.045,0.428,0.105,0.613,0.152c-0.192-0.145-0.257-0.17-0.318-0.182
						C0.891,17.561,0.847,17.598,0.726,17.595z"/>
					<path d="M4.966,19.208c0.195-0.06,0.383-0.04,1.422,0.061c-0.407-0.319-0.995-0.408-1.168-0.425
						c-0.462-0.035-0.555,0.092-0.286,0.373C4.947,19.217,4.959,19.211,4.966,19.208z"/>
					<path d="M6.585,25.805c-0.162-0.115-0.238-0.149-0.34-0.167c-0.238-0.012-0.194,0.063-0.329,0.086
						c-0.125,0.023-0.251-0.006-0.303-0.017c0.021,0.011,0.062,0.027,0.084,0.04c0.277,0.126,0.388,0.132,0.446,0.137
						C6.399,25.901,6.405,25.821,6.585,25.805z"/>
					<path d="M2.703,27.234c0.016,0.011,0.033,0.02,0.049,0.029c0.172,0.097,0.332,0.154,0.507,0.184
						c0.208,0.034,0.423-0.006,0.629,0.005c-0.203-0.094-0.448-0.195-0.76-0.232C2.97,27.203,2.845,27.209,2.703,27.234z"/>
					<path d="M1.411,23.104l1.382,0.144c-0.157-0.034-0.316-0.063-0.504-0.092C1.949,23.116,1.641,23.107,1.411,23.104z"
						/>
					<path d="M23.212,4.741c0.027,0.015,0.056,0.025,0.081,0.037c0.804,0.373,1.958-0.04,1.971-0.087
						c0,0-0.243-0.378-1.898-0.501c-0.151-0.01-0.307-0.021-0.467-0.029c0.033,0.086,0.117,0.169,0.201,0.255
						C23.344,4.675,23.366,4.732,23.212,4.741z"/>
					<path d="M12.995,7.104c0.922,0.148,1.721,0.276,2.399,0.284c0.774,0.009,0.626-0.241,0.63-0.244
						c-0.006-0.002-0.312-0.276-1.205-0.522c-0.572-0.158-1.375-0.253-2.055-0.38c-0.171,0.173-0.135,0.346,0.148,0.851
						C12.942,7.099,12.972,7.099,12.995,7.104z"/>
					<path d="M16.083,8.063c0.012,0,0.029-0.003,0.045-0.006c0.165-0.006,0.324,0.003,0.48,0.015
						c0.102,0.009,0.226,0.04,0.318,0.011c0.1-0.028,0.014-0.16-0.035-0.24c-0.175,0.008-0.299,0.075-0.5,0.039
						c-0.138-0.024-0.253-0.117-0.332-0.187C15.904,7.704,15.796,7.753,16.083,8.063z"/>
					<path d="M15.038,7.793c0.009,0.003,0.014,0.007,0.021,0.013c0.265,0.114,0.439,0.16,0.485,0.132
						c0.047-0.029-0.085-0.167-0.3-0.189C15.19,7.748,15.12,7.751,15.038,7.793z"/>
					<path d="M7.095,7.242C7.253,7.337,7.47,7.46,7.625,7.555C7.823,7.449,7.993,7.357,7.501,7.09
						C7.467,7.082,7.424,7.075,7.375,7.069C7.003,7.047,7.474,7.266,7.095,7.242z"/>
					<path d="M24.579,13.944c-0.073-0.012-0.146-0.017-0.221-0.022c-0.388-0.029-0.415,0.048-0.114,0.275
						c0.009,0.006,0.012,0.003,0.02,0.006C24.724,14.249,24.812,14.174,24.579,13.944z"/>
					<path d="M25.143,14.252c0.065,0.034,0.25,0.031,0.25,0.031c0.153-0.018,0.146-0.058,0.274-0.075
						c-0.082-0.103-0.357-0.131-0.413-0.137C25.033,14.06,24.906,14.111,25.143,14.252z"/>
					<path d="M22.055,14.3c-0.061-0.113-0.134-0.258-0.189-0.372c-0.593,0.097-0.919,0.149-1.338-0.104
						c-0.356,0.204-0.717,0.271-2.003,0.149c-1.236-0.12-1.403-0.1-1.63-0.074c0.076,0.029,0.169,0.063,0.25,0.087
						c0.648,0.218,1.141,0.28,1.535,0.314c0.26,0.023,0.26,0.023,1.736-0.024C21.178,14.255,21.503,14.252,22.055,14.3z"/>
					<path d="M14.442,13.789c-0.097,0-0.175,0.003-0.713-0.103c-0.95-0.187-1.403-0.244-1.411,0.028
						c0.019,0,0.047,0,0.067,0.003c0.143,0.003,0.561,0.014,1.146,0.105c0.926,0.144,1.26,0.127,1.699,0.035
						c-0.153-0.132-0.231-0.175-0.342-0.192C14.569,13.677,14.771,13.783,14.442,13.789z"/>
					<path d="M15.378,13.873c0.021,0.015,0.049,0.031,0.07,0.046c0.095,0.054,0.319,0.189,0.855,0.141
						c0.062-0.003,0.296-0.018,0.627,0.028c-0.209-0.092-0.485-0.195-0.933-0.235C15.753,13.836,15.55,13.841,15.378,13.873z"/>
					<path d="M9.93,13.681c0.202-0.164,0.555-0.127,1.249-0.031c0.584,0.077,0.795,0.077,0.998,0.054
						c-0.466-0.184-0.755-0.255-1.236-0.302c-0.544-0.042-1.125,0.015-1.662-0.031c-0.617-0.058-1.105-0.166-1.747-0.215
						c-0.03-0.003-0.071-0.003-0.101-0.009c-0.274-0.012-0.437,0-0.534,0.011c0.041,0.019,0.094,0.044,0.132,0.061
						c0.521,0.216,0.929,0.222,1.486,0.23C9.125,13.456,9.436,13.496,9.93,13.681z"/>
					<path d="M21.255,15.047c0.014,0.007,0.027,0.009,0.042,0.015c0.307,0.129,0.46,0.139,0.501,0.104
						c0.033-0.032-0.081-0.141-0.274-0.158C21.414,14.999,21.329,15.024,21.255,15.047z"/>
					<path d="M20.692,15.082c0.062-0.035,0.019-0.096-0.132-0.185l-0.347,0.069c0.01,0.017,0.034,0.04,0.067,0.058
						C20.4,15.094,20.616,15.122,20.692,15.082z"/>
					<path d="M18.715,14.771c-1.193-0.126-1.521-0.086-1.738-0.061c0.019,0.009,0.052,0.021,0.073,0.031
						c0.721,0.265,2.569,0.5,2.88,0.254c0.061-0.047,0.049-0.095,0.033-0.145C19.351,14.829,18.715,14.771,18.715,14.771z"/>
					<path d="M15.986,15.788c0.044,0.049,0.083,0.098,0.175,0.146c0.105,0.055,0.221,0.072,0.365,0.1
						c0.32,0.062,0.409,0.122,0.51,0.282c0.177-0.058,0.299-0.098,0.692-0.115c0.459-0.022,0.915,0.026,1.374,0.018
						c-0.294-0.198-0.489-0.27-0.855-0.308C18.01,15.9,18.01,15.9,17.248,15.979C16.339,15.742,16.339,15.742,15.986,15.788z"/>
					<polygon points="15.384,15.829 15.674,15.851 15.495,15.67 15.21,15.647 "/>
					<path d="M13.519,15.523c0.003,0.007,0.012,0.01,0.018,0.013c0.136,0.086,0.323,0.184,0.555,0.188
						c-0.098-0.149-0.254-0.188-0.509-0.212c-0.03-0.003-0.064-0.006-0.098-0.009C13.496,15.51,13.509,15.518,13.519,15.523z"/>
					<polygon points="24.391,16.44 24.085,16.417 24.282,16.615 24.582,16.639 "/>
					<polygon points="19.941,16.55 19.667,16.265 19.249,16.23 19.519,16.511 "/>
					<path d="M21.549,16.959c-0.409-0.021-0.574,0.081-0.498,0.306c0.016,0,0.04,0.003,0.056,0.006
						c0.287,0.014,1.203,0.086,1.734,0.131C22.337,17.092,21.862,16.994,21.549,16.959z"/>
					<path d="M18.674,16.891c-0.437-0.108-1.095-0.166-1.494-0.286c0.067,0.113,0.163,0.263,0.23,0.372
						c0.017,0,0.034,0.003,0.05,0c0.191,0.006,0.636,0.023,1.633,0.192c0.828,0.138,1.167,0.153,1.513,0.062
						c-0.386-0.288-0.653-0.395-1.107-0.442C19.272,16.775,19.004,16.772,18.674,16.891z"/>
					<path d="M27.56,17.729c0.107-0.057-0.092-0.194-0.175-0.249c-0.146,0.065-0.347,0.078-0.682,0.026
						c0.029,0.031,0.059,0.058,0.11,0.086C27.037,17.718,27.443,17.789,27.56,17.729z"/>
					<path d="M22.942,17.224c0.029,0.055,0.073,0.109,0.169,0.156c0.195,0.103,0.448,0.113,0.537,0.063
						c0.062-0.031,0.07-0.104-0.188-0.256L22.942,17.224z"/>
					<polygon points="25.941,17.448 26.135,17.649 26.746,17.694 26.549,17.493 "/>
					<path d="M23.792,17.385c0.016,0.022,0.042,0.046,0.086,0.069c0.129,0.063,0.336,0.086,0.404,0.039
						c0.053-0.034,0.008-0.092-0.142-0.178L23.792,17.385z"/>
					<path d="M8.459,16.272c-0.003-0.048-0.107-0.146-0.342-0.266l0.018,0.275c0.006,0,0.02,0.006,0.03,0.006
						C8.355,16.327,8.462,16.325,8.459,16.272z"/>
					<path d="M7.903,16.167c-0.169-0.112-0.423-0.241-1.029-0.299c-0.619-0.052-1.028,0.006-1.104,0.018
						c0.021,0.006,0.052,0.018,0.073,0.022C6.418,16.063,7.628,16.219,7.903,16.167z"/>
					<path d="M20.652,18.269c0.572-0.143-0.38-0.447-0.799-0.493c-0.314-0.023-0.63,0.017-0.943-0.006
						c-0.25-0.018-0.454-0.077-0.55-0.104c-0.089,0.075-0.199,0.176-0.286,0.249c-0.854-0.243-0.854-0.243-1.185-0.277
						c0.129,0.091,0.297,0.206,0.42,0.295c-0.933-0.388-1.226-0.348-1.316-0.283c-0.119,0.079-0.056,0.114,0.105,0.2
						c0.249,0.141,0.638,0.259,0.781,0.207c0.078-0.031,0.032-0.108,0.003-0.16c0.578,0.355,0.845,0.517,1.162,0.369
						c0.083,0.01,0.083,0.01,0.258,0.271c0.075,0.109,0.192,0.146,0.392,0.133c-0.144-0.142-0.34-0.337-0.485-0.479
						c0.301-0.055,0.602-0.063,1.314,0.04C20.303,18.341,20.459,18.318,20.652,18.269z"/>
					<polygon points="15.414,17.608 15.069,17.396 15.081,17.672 "/>
					<path d="M12.211,18.132c0.518-0.013,0.419-0.403,0.036-0.472c-0.027-0.005-0.059-0.008-0.089-0.011
						c-0.31-0.018-0.488,0.12-0.745,0.063c0.068,0.068,0.146,0.137,0.27,0.206C11.816,17.993,12.017,18.062,12.211,18.132z"/>
					<path d="M8.33,17.915c0.294,0.122,0.501,0.153,0.599,0.159c0.515,0.04,0.666-0.092,1.048-0.115
						c0.778-0.044,0.686,0.218,1.335,0.241c0.123,0,0.168-0.043,0.168-0.043c0.002,0-0.025-0.164-0.458-0.232
						c-0.541-0.086-0.491-0.27-0.485-0.27c0.206,0.017,0.165,0.086,0.4,0.097c0.003,0,0.304-0.224-1.453-0.393
						c-0.544-0.044-0.908-0.055-1.44-0.037c0.19,0.188,0.274,0.275,0.209,0.447C8.211,17.867,8.211,17.867,8.33,17.915z"/>
					<path d="M15.944,18.577c0.414-0.026,0.604-0.026,0.858,0.031c-0.402-0.195-0.634-0.248-1.114-0.259
						c-0.359-0.009-0.553-0.046-0.879-0.167c0.095,0.096,0.183,0.19,0.342,0.276C15.414,18.608,15.648,18.594,15.944,18.577z"/>
					<path d="M14.129,18.384l-0.14-0.27c-0.035-0.009-0.075-0.017-0.121-0.023C13.868,18.091,13.515,18.098,14.129,18.384
						z"/>
					<path d="M21.62,20.366c0.111,0.057,0.246,0.068,0.417,0.079c0.068-0.008,0.136-0.005,0.204,0
						c-0.163-0.132-0.336-0.194-0.602-0.224c-0.053-0.003-0.112-0.005-0.17-0.005C21.499,20.268,21.532,20.316,21.62,20.366z"/>
					<path d="M24.889,20.738c0.098,0.058,0.227,0.101,0.266,0.081c0.053-0.028-0.154-0.19-0.221-0.241
						C24.625,20.578,24.846,20.71,24.889,20.738z"/>
					<path d="M17.844,20.016c0.024,0.019,0.057,0.045,0.096,0.06c0.159,0.084,0.338,0.084,0.532,0.089
						c0.151,0.003,0.319-0.012,0.461,0.018c-0.103-0.069-0.194-0.098-0.399-0.118C18.302,20.047,18.043,20.055,17.844,20.016z"/>
					<path d="M26.881,23.708c-0.111,0-0.2-0.012-0.282-0.025c0.02,0.014,0.051,0.031,0.076,0.045
						c0.3,0.152,0.719,0.233,0.854,0.164c0.131-0.072-0.25-0.206-0.33-0.215C27.064,23.667,26.997,23.702,26.881,23.708z"/>
					<path d="M8.61,23.357c0.006,0,0.018,0,0.021,0.003c0.298,0.05,0.406,0.021,0.333-0.089
						c-0.05-0.081-0.12-0.189-0.389-0.225C8.281,23.03,8.6,23.353,8.61,23.357z"/>
					<path d="M6.735,23.013c0.042,0.052,0.086,0.106,0.18,0.156c0.053,0.027,0.118,0.056,0.237,0.068
						c0.132,0.017,0.289,0.008,0.423,0.017c-0.168-0.138-0.337-0.194-0.636-0.229C6.871,23.019,6.808,23.019,6.735,23.013z"/>
					<path d="M21.604,25.066c0.175,0.015,0.347,0.003,0.562-0.017c0.498-0.041,0.602-0.026,1.51,0.103
						c1.213,0.176,1.95,0.281,2.271,0.129c0.121-0.063,0.121-0.16,0.123-0.235c-0.089-0.017-0.179-0.032-0.286-0.04
						c-0.313-0.011-0.38,0.026-0.488,0.155c-0.903-0.247-1.533-0.281-2.606-0.281c-0.507,0-1.273,0.005-1.94-0.086
						c0.039,0.02,0.089,0.045,0.128,0.063C21.04,24.935,21.293,25.04,21.604,25.066z"/>
					<path d="M18.37,24.744c0.127-0.071-0.03-0.191-0.097-0.249c-0.869,0.034-0.869,0.034-1.022,0.08
						c0.021,0.017,0.046,0.037,0.086,0.058C17.606,24.778,18.203,24.846,18.37,24.744z"/>
					<path d="M17.041,24.942c0.183-0.092-0.198-0.557-1.017-0.637c-0.171-0.018-0.345-0.015-0.643,0.028
						c0.089,0.095,0.209,0.189,0.369,0.281C16.212,24.877,16.848,25.04,17.041,24.942z"/>
					<polygon points="13.072,24.202 12.867,24.019 12.6,23.995 12.799,24.179 "/>
					<path d="M20.516,24.896c0.029-0.012,0.042-0.026,0.044-0.04c-0.194-0.043-0.451-0.092-0.65-0.132
						c0.043,0.034,0.092,0.063,0.146,0.098C20.235,24.914,20.428,24.948,20.516,24.896z"/>
					<path d="M25.303,26.643c0.182,0.092,0.317,0.104,0.423,0.034c0.048-0.028,0.073-0.06,0.099-0.094
						c0.122,0.036,0.279,0.089,0.399,0.123c-0.041-0.139-0.243-0.225-0.593-0.259C25.438,26.438,24.842,26.413,25.303,26.643z"/>
					<path d="M24.066,26.52c0.042-0.038-0.056-0.136-0.265-0.155c-0.118-0.009-0.194,0.009-0.259,0.037
						c0.014,0.003,0.03,0.012,0.036,0.012C23.837,26.522,24.021,26.56,24.066,26.52z"/>
					<path d="M13.288,26.122c0.043,0.01,0.102,0.016,0.146,0.019c0.592,0.065,1.094-0.104,1.686-0.038
						c0.304,0.038,0.602,0.127,0.98,0.242c0.54,0.16,0.84,0.238,1.317,0.229c0.133-0.093-0.086-0.178-0.086-0.27
						c0.184,0.065,0.316,0.108,0.547,0.149c0.459,0.082,0.757-0.075,1.137-0.112c0.134-0.016,0.542-0.056,1.355,0.442
						c0.266,0.157,0.266,0.157,0.532,0.154c0.128-0.089,0.128-0.089-0.563-0.807c-1.704-0.109-3.127-0.351-4.739-0.5
						c-1.839-0.144-2.852-0.176-3.631,0.021c0.072,0.037,0.159,0.08,0.227,0.115C12.726,26.017,13.054,26.086,13.288,26.122z"/>
					<path d="M20.863,26.24c0.007,0.007,0.016,0.01,0.019,0.012c0.228,0.127,0.455,0.152,0.655,0.161
						c-0.108-0.161-0.237-0.201-0.483-0.221c-0.099-0.006-0.216-0.006-0.3-0.026C20.784,26.192,20.824,26.218,20.863,26.24z"/>
					<path d="M23.142,26.709c-0.269-0.015-0.347,0.003-0.064,0.222c0.202,0.154-0.033,0.131-0.187,0.116
						c0.03,0.021,0.073,0.044,0.111,0.064c0.07,0.034,0.236,0.118,0.438,0.065c0.215-0.06,0.434,0.04,0.725,0.224
						c0.297,0.023,0.297,0.023,0.77-0.111c-0.221-0.192-0.411-0.216-0.846-0.235C23.557,27.033,23.377,26.971,23.142,26.709z"/>
					<path d="M18.761,26.588c-0.043-0.003-0.085,0-0.116,0.009c0.027,0.028,0.064,0.061,0.116,0.092
						c0.156,0.08,0.494,0.135,0.608,0.222C19.587,26.86,19.09,26.625,18.761,26.588z"/>
					<polygon points="12.015,26.924 12.37,27.131 12.63,27.156 12.309,26.878 "/>
					<path d="M10.04,27.751c-0.105,0.029-0.007,0.104,0.092,0.158c0.119,0.066,0.45,0.204,0.618,0.164
						c-0.095-0.144-0.181-0.167-0.369-0.184C10.248,27.875,10.153,27.857,10.04,27.751z"/>
					<path d="M11.262,28.032c0.009,0.007,0.022,0.012,0.025,0.012c0.356,0.201,0.715,0.247,0.958,0.258
						c-0.168-0.188-0.21-0.188-0.715-0.226C11.418,28.067,11.333,28.056,11.262,28.032z"/>
					<path d="M16.287,29.021c0.273,0.229,0.513,0.431,0.761,0.56c0.013,0.01,0.031,0.018,0.046,0.026
						c0.16-0.092,0.913-0.063,0.842-0.185c-0.005-0.014-0.056-0.028-0.082-0.039c-0.192-0.092-0.377-0.179-0.57-0.271
						c-0.221-0.104-0.439-0.206-0.667-0.311c-0.013,0-0.029,0-0.043,0c-0.07,0.013-0.062,0.034-0.008,0.133
						c0.057,0.098,0.046,0.115-0.019,0.129C16.422,29.058,16.358,29.037,16.287,29.021z"/>
					<path d="M15.065,29.233c0.092-0.058,0.517,0.017,0.556-0.047c0.035-0.068-0.126-0.209-0.396-0.241
						c-0.155-0.008-0.159,0.04-0.267,0.05c-0.138,0.011-0.283-0.026-0.361-0.044c0.14,0.086,0.32,0.201,0.459,0.287
						C15.06,29.238,15.06,29.236,15.065,29.233z"/>
					<path d="M19.198,29.525c0.002,0,0.119-0.149-0.338-0.194c-0.207-0.016-0.442,0.031-0.298,0.103
						C18.727,29.52,19.107,29.574,19.198,29.525z"/>
					<path d="M16.462,29.46c0.07-0.135-0.289-0.25-0.432-0.376c-0.115-0.012-0.271-0.026-0.388-0.034
						c0.096,0.098,0.202,0.194,0.376,0.289C16.168,29.417,16.319,29.46,16.462,29.46z"/>
					<path d="M153.041,36.671c0.243,0.1,0.667,0.191,0.795,0.114c0.042-0.025,0.042-0.025-0.741-0.316
						C152.611,36.481,152.931,36.624,153.041,36.671z"/>
					<path d="M19.255,29.796c0.099-0.046,0.029-0.13-0.006-0.172c-0.064,0.074-0.086,0.068-0.534-0.01
						c-0.31-0.054-0.499-0.024-0.345,0.052C18.647,29.808,19.104,29.876,19.255,29.796z"/>
					<path d="M1.653,13.7c0.117,0.063,0.231,0.083,0.273,0.089c0.101,0.015,0.232,0.013,0.342,0.018
						c0.308,0.017,0.561,0.063,0.839,0.098c0.612,0.072,0.841,0.126,1.397,0.282c0.065-0.052,0.146-0.115,0.211-0.167
						c0.548,0.212,1.744,0.462,1.906,0.264c0.022-0.025,0.01-0.063,0.006-0.092c0.169-0.022,0.248,0.034,0.388,0.145
						c0.149,0.12,0.242,0.131,0.334,0.108c0.013,0,0.025,0,0.036,0.003c0.042,0.009,0.081,0.017,0.14,0.02
						c0.037-0.011,0.079-0.022-0.007-0.148c-0.025-0.053-0.232-0.101-0.022-0.149c0.067,0,0.112,0.006,0.151,0.015
						c-0.354-0.099-0.618-0.157-0.914-0.188c-0.394-0.026-0.526,0.015-0.514,0.161c-0.32-0.086-0.551-0.19-0.94-0.265
						c-0.27-0.052-0.303,0.012-0.313,0.029c-0.016,0.043,0.003,0.083,0.027,0.123c-0.229-0.123-0.645-0.353-2.171-0.358
						c-0.837,0-1.176-0.092-1.338-0.139C1.53,13.6,1.573,13.652,1.653,13.7z"/>
					<path d="M22.383,26.474c-0.002,0-0.008,0.002-0.008,0.002c-0.006-0.051,0.006-0.103,0.212-0.058
						c0.192,0.041,0.214,0.115,0.51,0.136c0.165,0.011,0.133-0.089,0.133-0.089c-0.033-0.052-0.156-0.098-0.363-0.146
						c-0.21-0.049-0.275-0.089-0.352-0.17c-0.317-0.011-0.202,0.095-0.326,0.138c-0.1,0.035-0.275,0.003-0.459-0.034
						c0.046,0.053,0.079,0.104,0.188,0.152c0.165,0.077,0.557,0.112,0.708,0.187c0.02,0,0.04,0,0.062,0
						C22.734,26.545,22.411,26.476,22.383,26.474z"/>
					<path d="M3.826,25.023c0.182,0.003,0.277,0.014,0.385,0.114c0.248-0.135,0.561-0.166,1.487,0.08
						c0.538,0.145,0.742,0.162,0.866,0.075c0.51,0.184,0.876,0.386,1.416,0.566c0,0,0.152,0.045,0.362,0.024
						c0.48-0.045,0.527-0.048,0.89,0.185c0.003-0.144-0.313-0.281-0.111-0.426c0.176-0.005,0.176-0.005,0.691,0.285
						c0.126,0.071,0.239,0.146,0.445,0.204c0.042-0.084-0.254-0.146-0.292-0.225c-0.03-0.063,0.167-0.115,0.244-0.169
						c0.033,0.012,0.076,0.025,0.1,0.037c0.228,0.101,0.289,0.218,0.513,0.322c0.126,0.061,0.218,0.079,0.332,0.068
						c-0.359-0.336-0.319-0.396,0.223-0.348c0.5,0.044,0.61,0.015,0.352-0.275c-1.931-0.232-2.388-0.284-3.023-0.126
						c-0.767-0.222-1.263-0.296-2.321-0.364c-1.117-0.07-1.649-0.147-2.576-0.466c-0.698,0.195-0.607,0.238-0.329,0.373
						C3.517,24.978,3.609,25.023,3.826,25.023z"/>
					<path d="M7.974,26.921c0,0,0.104-0.008,0.332,0.021c0.271,0.04,0.498,0.092,0.764,0.129
						c0.504,0.072,0.636,0.015,0.798-0.058c0.121-0.055,0.207-0.086,0.339-0.089c0.788-0.022,1.209,0.156,1.905,0.181
						c-0.234-0.134-0.414-0.207-0.855-0.27c-0.24-0.032-0.525-0.037-0.784-0.055c-1.058-0.077-1.97-0.221-2.968-0.326
						C3.735,26.071,2.4,26.02,1.521,26.025c0.022,0.075,0.055,0.178,0.081,0.256c-0.003-0.003-0.269-0.259-0.747-0.33
						c-0.28,0.014-0.129,0.089,0.08,0.194c0.473,0.23,0.843,0.302,1.05,0.343c0.052,0.011,0.132,0.021,0.19,0.031
						c0.319,0.043,0.675,0.071,1.019,0.105c0.281,0.029,0.464,0.092,0.676,0.142c0.521,0.126,0.663,0.131,0.807,0.106
						c0.442,0.149,0.613,0.231,0.915,0.514c0.246,0,0.389,0.055,0.575,0.221c0.318,0.009,0.528,0.028,1.268,0.133
						c0.108,0.017,0.221,0.031,0.331,0.045c0.271,0.029,0.591,0.041,0.859,0.075c0.274,0.04,0.488,0.098,0.801,0.124
						c0.146,0.008,0.336,0.025,0.367-0.058c0.002-0.016-0.054-0.199-0.207-0.221c-0.266-0.047-0.289,0.079-0.465,0.113
						c-0.204-0.218-0.237-0.235-0.669-0.355c-0.504-0.141-0.685-0.284-1.05-0.571c0.183,0.097,0.417,0.227,0.592,0.321
						C7.855,27.073,7.74,26.952,7.974,26.921z M7.829,27.355l0.344,0.298l-0.251-0.025L7.458,27.32L7.829,27.355z M7.238,27.35
						c-0.061,0.022-0.138,0.04-0.206,0.057c-0.059,0.018-0.107,0.038-0.151,0.058c-0.004,0-0.007,0.006-0.01,0.006
						c-0.017,0.012-0.036,0.022-0.047,0.034c-0.002,0.003-0.007,0.009-0.01,0.012c-0.175-0.184-0.303-0.367-0.421-0.551
						c0.411-0.018,0.937,0.339,0.94,0.341C7.354,27.326,7.275,27.335,7.238,27.35z"/>
					<path d="M18.205,29.425c0.029,0.016,0.073,0.032,0.097,0.016c0.044-0.029-0.038-0.202-0.277-0.351l0.081,0.27
						C18.132,29.383,18.161,29.405,18.205,29.425z"/>
					<path d="M17.021,16.854c-0.425-0.146-1.418-0.491-3.549-0.555c-1.114-0.425-0.739-0.603-0.524-0.66
						c0.042,0,0.104,0,0.144,0c-0.624-0.247-1.107-0.325-2.333-0.38c-0.86-0.039-1.305-0.068-1.961-0.221
						c-0.049-0.011-0.114-0.028-0.167-0.042c-0.386,0.169-0.929,0.2-2.947-0.07c-1.253-0.171-1.758-0.2-2.169-0.131
						c0.02,0.014,0.049,0.034,0.076,0.052c0.086,0.051,0.34,0.207,0.655,0.166c0.5-0.063,0.743,0.12,0.955,0.287
						c0.014-0.043,0.011-0.086,0.115-0.126c0.02,0,0.05,0,0.07-0.003c0.469,0.088,0.593,0.232,0.994,0.33
						c0.07-0.046,0.162-0.104,0.229-0.148c0.653,0.255,0.936,0.234,1.325,0.209c0.78-0.052,1.105,0.14,1.162,0.181
						c0.134,0.087,0.134,0.087-0.431,0.311c0.917,0.364,0.985,0.373,4.709,0.683c0.071-0.049,0.163-0.114,0.231-0.164
						c0.689,0.089,0.869,0.322,1.848,0.325C15.982,16.896,16.455,16.782,17.021,16.854z M11.049,16.007
						c-0.062-0.038-0.179-0.067-0.144-0.109c0-0.003,0.362-0.213,0.427-0.222c0.221,0.17,0.626,0.331,0.752,0.509
						C11.234,16.112,11.234,16.112,11.049,16.007z"/>
					<path d="M6.645,23.599c-0.691-0.097-1.344-0.206-2.063-0.293c-0.541-0.058-0.541-0.058-0.905,0.037l4.043,0.399
						c-0.083-0.034-0.237-0.109-0.403-0.132C7.1,23.578,6.862,23.631,6.645,23.599z"/>
					<path d="M158.411,6.96h0.005c0.82,0.064,0.596-0.184,0.26-0.562c-0.055-0.003-0.112-0.007-0.16-0.012
						c-0.566-0.006-0.448,0.148-0.129,0.571C158.399,6.96,158.411,6.96,158.411,6.96z"/>
					<path d="M187.374,11.516c0.013,0,0.024,0.005,0.024,0.005c0.755,0.069,0.647-0.212,0.3-0.391
						c-0.177-0.086-0.211-0.092-0.448-0.103c-0.135,0-0.229,0.017-0.205,0.092C187.08,11.257,187.314,11.384,187.374,11.516z"/>
					<path d="M118.843,9.579c0.654,0.044,1.032,0.047,0.59-0.27c-0.059-0.003-0.123-0.006-0.182-0.009
						c-0.519-0.015-0.648,0.061-0.459,0.278C118.814,9.579,118.826,9.579,118.843,9.579z"/>
					<path d="M75.722,7.779c-0.07-0.164-0.14-0.173-0.747-0.229c0.016,0.008,0.041,0.022,0.058,0.031
						C75.298,7.735,75.528,7.769,75.722,7.779z"/>
					<path d="M107.964,9.915c0.116,0.106-0.102,0.233,0.3,0.327c0.777,0.183,1.58,0.204,2.346,0.207
						c1.308,0.003,1.686,0.044,2.099,0.109c0-0.083-0.013-0.191-0.019-0.275c-0.205-0.101-0.631-0.308-1.562-0.463
						c-1.133-0.184-2.523-0.243-3.714-0.401c0.036,0.043,0.072,0.098,0.113,0.138C107.651,9.677,107.828,9.792,107.964,9.915z"/>
					<path d="M31.152,6.116c-0.363-0.194-0.685-0.278-1.176-0.315c-0.304-0.018-0.62-0.012-0.932-0.018
						c0.032,0.012,0.064,0.029,0.092,0.04C29.509,5.973,30.259,6.214,31.152,6.116z"/>
					<path d="M31.799,6.15c0.042-0.034-0.093-0.149-0.32-0.171c-0.095-0.004-0.165,0.011-0.246,0.045
						c0.013,0.006,0.03,0.012,0.048,0.018C31.603,6.165,31.762,6.18,31.799,6.15z"/>
					<path d="M129.317,11.162c-0.046-0.207-0.27-0.244-0.776-0.284c-0.343-0.028-0.507-0.055-0.649-0.136
						c-0.118,0.021-0.425,0.066-0.146,0.187C128.057,11.067,128.852,11.185,129.317,11.162z"/>
					<path d="M143.18,12.013c0,0,0.584,0.048,0.769,0.025c0.064-0.007,0.364-0.141-0.19-0.225
						c-0.353-0.049-0.565-0.058-0.66-0.06c-0.448-0.009-0.625,0.057-0.566,0.227c0.012,0,0.019-0.003,0.023-0.003
						C142.72,11.969,142.986,11.992,143.18,12.013z"/>
					<path d="M141.766,11.857c0,0-0.105-0.178-0.79-0.207c-0.012,0-0.942-0.021-0.543,0.163
						C140.875,12.018,141.743,11.918,141.766,11.857z"/>
					<path d="M158.447,12.848c-0.577-0.391-2.029-0.494-2.841-0.522c-0.554-0.015-0.874-0.006-1.226,0.025
						c0.012,0.011,0.047,0.026,0.064,0.034C155.229,12.749,156.372,12.788,158.447,12.848z"/>
					<path d="M29.626,6.826c0.188,0.112,0.456,0.154,0.585,0.089c0.124-0.068-0.257-0.244-0.66-0.272
						c-0.042-0.003-0.076-0.003-0.118-0.006C29.472,6.702,29.524,6.763,29.626,6.826z"/>
					<polygon points="27.895,6.817 27.728,6.616 27.403,6.593 27.571,6.794 "/>
					<path d="M22.036,6.98c1.506,0.228,2.595,0.38,3.956,0.438C26.65,7.68,26.813,8,27.875,8.21
						c0.021,0,0.049,0,0.067-0.003c0.1-0.026,0.11-0.061,0.117-0.092c0.492,0.161,0.786,0.293,1.216,0.539
						c1.777-0.456,3.803,0.139,5.713,0.019c-0.304-0.219-0.426-0.308-1.17-0.442c-0.775-0.147-0.857-0.179-1.228-0.365
						c-0.202,0-0.674,0.003-1.881-0.227c-0.927-0.179-1.282-0.202-1.45-0.092c-0.408-0.145-0.77-0.299-1.067-0.465
						c-0.157-0.087-0.157-0.087-0.348-0.089c-0.182,0.037-0.178,0.117,0.041,0.364c-0.035,0.006-0.091,0.014-0.129,0.02
						c-0.622-0.077,0.03-0.396-0.755-0.353c-0.083-0.012-0.172-0.021-0.267-0.018c0.042,0.092,0.348,0.172,0.322,0.272
						c-0.095,0.009-0.218,0.026-0.334-0.014c-0.041-0.015-0.085-0.031-0.114-0.047c-0.27-0.123,0.026-0.313-0.79-0.369
						c-1.103-0.078-1.463-0.078-1.74,0.065c-0.896-0.23-1.213-0.27-1.562-0.305c-0.037-0.003-0.096-0.005-0.141-0.005
						c-0.05,0.051-0.118,0.123-0.167,0.178c-0.322,0.006-0.448-0.081-0.767-0.078C21.241,6.86,21.715,6.933,22.036,6.98z"/>
					<path d="M148.756,14.008c1.58,0.127,3.265,0.143,4.88,0.238c7.403,0.428,7.403,0.428,8.759,1.046
						c7.238,0.361,7.238,0.361,8.063,0.134c-1.357-0.321-1.214-0.718-1.145-0.833c0.061-0.083,0.171-0.257-1.801-0.607
						c-2.837-0.5-6.52-0.472-9.656-0.788c-0.294,0.23,0.59,0.437,0.295,0.673c-0.744-0.184-1.898-0.275-2.263-0.54
						c-3.361-0.018-3.561-0.018-4.421,0.428c-1.587-0.238-3.49-0.158-5.212-0.262c0.154,0.062,0.319,0.149,0.507,0.204
						C147.413,13.898,148.062,13.953,148.756,14.008z"/>
					<path d="M95.297,11.449c0.283,0.026,1.13,0.105,2.582,0.141c3.052,0.077,4.055,0.35,4.715,0.533
						c0.164-0.021,0.377-0.054,0.542-0.079c-0.1-0.235-0.129-0.316-0.754-0.422c-0.478-0.084-0.478-0.084-0.877-0.302
						c-0.502-0.086-0.89-0.13-1.562-0.161c-1.333-0.037-2.253,0.021-2.8,0.175c-1.632-0.181-2.241-0.249-2.104,0.089
						C95.114,11.429,95.214,11.441,95.297,11.449z"/>
					<path d="M110.263,11.911c0.064-0.046-0.03-0.111-0.078-0.149c-0.311-0.031-0.542-0.101-0.907-0.12
						c-0.078,0-0.561,0.022-0.249,0.158C109.337,11.929,110.128,12.021,110.263,11.911z"/>
					<path d="M103.832,12.348c0.329,0.012,0.647,0.026,0.979,0.037c-0.366-0.215-0.709-0.31-1.186-0.33
						c-0.094-0.003-0.182-0.003-0.283,0c0.124,0.087,0.29,0.201,0.419,0.288C103.785,12.346,103.808,12.348,103.832,12.348z"/>
					<path d="M77.508,11.806c0.249-0.01,0.584-0.026,0.831-0.01c0.809,0.047,1.315,0.13,2.34,0.293
						c0.577,0.099,0.942,0.144,1.185,0.139c0.359-0.018,0.488-0.139,0.949-0.106c0.154,0.012,0.294,0.055,0.359,0.075
						c-0.135-0.129-0.229-0.184-0.73-0.25c-0.342-0.052-0.636-0.115-0.995-0.158c-0.055-0.009-0.12-0.014-0.166-0.02
						c-0.707-0.081-1.498-0.069-2.247-0.112c-1.697-0.095-2.457-0.514-4.178-0.601c-0.989-0.046-2.033-0.021-2.971-0.13
						c0.071,0.034,0.143,0.084,0.212,0.118C73.702,11.854,77.474,11.809,77.508,11.806z"/>
					<path d="M35.299,9.474c0.03,0.014,0.07,0.034,0.1,0.049c0.129-0.018,0.129-0.018,0.049-0.247
						c0.004,0,0.007,0,0.013,0c0.135,0.055,0.19,0.12,0.345,0.178c0.008,0.003,0.092,0.015,0.116-0.014
						c0.046-0.038-0.08-0.158-0.197-0.271c-0.064-0.061-0.14-0.124-0.165-0.192c-0.013,0-0.026,0-0.04,0
						C34.935,8.948,34.899,9.241,35.299,9.474z"/>
					<path d="M102.93,12.953c-0.861-0.028-1.321-0.028-2.021,0.013c0.082,0.061,0.212,0.14,0.342,0.2
						c0.334,0.144,0.753,0.222,1.16,0.296c1.127,0.212,1.48,0.33,1.811,0.756c0.525,0.04,0.879,0.101,1.874,0.313
						c0.684,0.146,1.333,0.287,1.827,0.299c0.567,0.011,0.855-0.135,0.99-0.207c0.402-0.194,0.473-0.21,0.874-0.281
						c-0.619-0.345-1.438-0.672-2.123-1.011C103.632,12.985,103.632,12.985,102.93,12.953z"/>
					<path d="M110.333,13.804l-0.159-0.181c-0.046-0.005-0.095-0.012-0.148-0.015c-0.289-0.009-0.182,0.112-0.03,0.279
						C110.098,13.861,110.233,13.83,110.333,13.804z"/>
					<path d="M46.594,10.946c0.317,0.018,0.633,0.037,0.949,0.055c-0.362-0.25-0.632-0.419-1.07-0.45
						c-0.093-0.003-0.19,0-0.277,0.008c0.101,0.115,0.232,0.268,0.333,0.383C46.55,10.944,46.574,10.946,46.594,10.946z"/>
					<path d="M41.214,10.823c0.006,0.003,0.009,0.008,0.013,0.011c0.033,0.021,0.06,0.041,0.086,0.061
						c0.103-0.045,0.244-0.108,0.349-0.152c-0.211-0.126-0.455-0.197-0.853-0.243C40.871,10.622,40.904,10.643,41.214,10.823z"/>
					<path d="M28.131,9.763c-0.112-0.082-0.169-0.108-0.263-0.12c-0.238-0.006-0.342,0.115-0.533,0.063
						c0.043,0.04,0.089,0.075,0.146,0.109c0.121,0.072,0.207,0.075,0.263,0.068C27.995,9.867,27.961,9.799,28.131,9.763z"/>
					<path d="M74.374,12.531c0.021,0.013,0.052,0.023,0.082,0.034c0.312,0.139,0.695,0.184,0.955,0.21
						c0.701,0.067,1.456,0.049,2.182,0.084c-0.308-0.11-0.826-0.241-2.088-0.311C74.975,12.526,74.668,12.526,74.374,12.531z"/>
					<path d="M44.846,11.371c0.144-0.079,0.144-0.178,0.355-0.258c0.146-0.058,0.262-0.055,0.446-0.049
						c0.003-0.037,0-0.078-0.173-0.101c-0.014-0.004-0.039-0.006-0.059-0.009c-0.306-0.031-0.653-0.009-0.967-0.037
						c-0.531-0.052-0.872-0.17-1.43-0.213c-0.098-0.003-0.188,0-0.283,0.006c0.101,0.075,0.207,0.149,0.33,0.218
						C43.661,11.271,44.407,11.636,44.846,11.371z"/>
					<path d="M36.668,10.499c0.065-0.035,0.036-0.092-0.106-0.173l-0.417,0.065c0.016,0.021,0.038,0.044,0.072,0.061
						C36.348,10.524,36.583,10.538,36.668,10.499z"/>
					<path d="M35.377,10.47c0.026,0.018,0.064,0.037,0.106,0.052c0.121-0.018,0.283-0.046,0.403-0.063
						c-0.055-0.089-0.3-0.115-0.367-0.121C35.307,10.326,35.195,10.37,35.377,10.47z"/>
					<path d="M83.132,13.227c0.135,0.069,0.27,0.075,0.377,0.021c0.058-0.032,0.082-0.069,0.104-0.106
						c-0.229-0.069-0.366-0.098-0.495-0.104C82.794,13.026,83.132,13.227,83.132,13.227z"/>
					<path d="M84.971,13.761c0.27,0,0.824,0.034,0.93,0.046c0.448,0.046,1.12,0.026,1.304-0.005
						c0.158-0.023,0.617-0.168-0.195-0.362c-0.378-0.093-0.897-0.155-1.521-0.185c-0.507-0.02-0.779-0.014-0.991,0.023
						c0.131,0.144,0.295,0.336,0.425,0.482C84.941,13.761,84.953,13.761,84.971,13.761z"/>
					<path d="M177.833,17.315c0.23,0.015,0.454,0,0.678,0.007c-0.249-0.11-0.607-0.176-1.145-0.21
						c0.012,0.031,0.024,0.095,0.129,0.143C177.59,17.296,177.72,17.307,177.833,17.315z"/>
					<path d="M125.109,15.788c0.383,0.052,0.459-0.026,0.459-0.026c0-0.003-0.058-0.187-0.942-0.221
						c-0.249-0.008-0.507-0.008-0.761-0.018c0.011,0.003,0.03,0.01,0.042,0.01C124.308,15.619,124.638,15.725,125.109,15.788z"/>
					<polygon points="67.347,14.295 66.982,14.082 66.88,14.364 "/>
					<path d="M76.4,16.055c0.107-0.068-0.365-0.151-0.365-0.151c-0.153-0.003-0.07,0.097,0.03,0.149
						C76.159,16.099,76.295,16.124,76.4,16.055z"/>
					<path d="M139.03,19.918c0.283,0.063,0.549-0.041,0.809-0.067c-0.078-0.1-0.454-0.123-0.56-0.129
						C138.607,19.702,138.984,19.905,139.03,19.918z"/>
					<path d="M73.335,17.281c0.59,0.27,1.262,0.264,2.371,0.259c-0.214-0.144-0.461-0.204-0.973-0.233
						c-0.49-0.021-1.014,0.006-1.467-0.06C73.288,17.259,73.312,17.271,73.335,17.281z"/>
					<path d="M24.868,15.316c0.063,0.023,0.141,0.058,0.202,0.081c0.737,0.282,1.305,0.29,1.967,0.299
						c0.501,0.008,1.274,0.052,1.397,0.063c0.07,0.006,0.163,0.018,0.237,0.023c1.233,0.139,2.474,0.271,3.705,0.408
						c0.676,0.077,1.333,0.166,1.994,0.247c0.064-0.047,0.18-0.126,0.448-0.132c0.465-0.018,0.797,0.079,1.249,0.076
						c-0.363-0.22-0.529-0.327-4.491-0.681C29.041,15.53,27.261,15.432,24.868,15.316z"/>
					<path d="M45.766,17.618c-0.163,0.048-0.343,0.1-0.77,0.071c-0.81-0.052-1.393-0.207-2.218-0.254
						c-0.757-0.039-1.503,0.122-2.263,0.01c-1.959-0.285-1.959-0.285-3.789-0.382c-1.908-0.104-2.724-0.161-3.809-0.275
						C32.348,16.988,32.321,17,32.14,17c-0.645,0.021-0.943-0.141-1.539-0.149c-0.462-0.006-0.75,0.307-0.06,0.439
						c0.647,0.124,1.206,0.172,1.443,0.192c0.073,0.006,0.171,0.011,0.244,0.018c1.002,0.074,2.063,0.068,3.091,0.108
						c1.274,0.047,1.37,0.063,2.098,0.213c0.531,0.104,0.798,0.158,1.133,0.151c0.341,0.296,1.108,0.429,1.694,0.486
						c0.361,0.04,0.745,0.043,1.125,0.058c1.289,0.054,2.104,0.31,3.321,0.394c0.163,0.014,0.227-0.037,0.257-0.063
						c0.132-0.109,0.181-0.152,1.91,0.061c1.415,0.171,1.949,0.241,2.761,0.212c0.069-0.246-0.227-0.485-0.238-0.729
						c1.06-0.003,2.089,0.086,3.159,0.069c0.86-0.021,1.005-0.055,1.435-0.155c-2.18-0.185-4.193-0.454-6.336-0.654
						C46.073,17.534,46.073,17.534,45.766,17.618z M39.53,17.878c-0.003-0.005-0.012-0.008-0.02-0.011
						c0.099,0.023,0.185,0.026,0.247,0.014c0.339,0.023,0.53,0.034,0.583,0.21C40.202,18.074,39.821,18.027,39.53,17.878z M45.188,18.502
						c-0.044-0.003-0.082-0.009-0.118-0.015c-0.333-0.058-0.327-0.206-0.465-0.296c0.145,0.032,0.329,0.026,0.365,0.023
						c0.428-0.023,0.517,0.071,0.551,0.111C45.128,18.31,45.581,18.52,45.188,18.502z"/>
					<path d="M28.277,17.098c0.817,0.114,1.091,0.338,1.769,0.479c0.064-0.02,0.154-0.055,0.212-0.074l-0.468-0.486
						c-0.206-0.058-0.478-0.132-0.777-0.154c-0.373-0.026-0.718,0.034-1.087,0.022c-0.462-0.201-0.772-0.275-1.316-0.327
						c-0.61-0.028-1.215,0.026-1.819,0.006c0.076,0.052,0.171,0.117,0.284,0.167c0.34,0.146,0.739,0.175,1.299,0.221
						c0.853,0.065,1.11,0.146,1.487,0.284C27.986,17.195,28.154,17.138,28.277,17.098z"/>
					<path d="M53.882,19.372c0.013,0,0.022,0.005,0.031,0.005c0.405,0.047,0.573,0.007,0.629-0.011
						c0.006,0,0.012-0.006,0.026-0.006c0.254-0.095-0.366-0.23-0.471-0.241C53.908,19.114,53.652,19.159,53.882,19.372z"/>
					<path d="M31.626,17.836c-0.379-0.078-0.886-0.098-1.328-0.146c0.639,0.209,0.69,0.468,1.101,0.694
						c0.075,0.041,0.162,0.081,0.283,0.112c0.041-0.081,0.006-0.16-0.03-0.238c-0.062-0.126-0.093-0.207-0.031-0.25
						c0.106-0.066,0.479,0.032,0.685,0.083C32.213,18.033,32.026,17.915,31.626,17.836z"/>
					<path d="M66.84,19.992c0.035,0.028,0.083,0.058,0.129,0.083c0.307,0.163,0.666,0.158,0.795,0.155
						C67.595,20.139,67.36,20.047,66.84,19.992z"/>
					<path d="M64.501,20.606c-0.289-0.017-0.289-0.017-0.855-0.235c-0.317-0.012-0.423,0.09-0.755,0.074
						c-0.188-0.011-0.369-0.089-0.494-0.144c0.036,0.102,0.095,0.195,0.19,0.293c0.152,0.149,0.211,0.305,0.393,0.457
						c0.03,0.025,0.171,0.049,0.243,0.066c0.022,0.008,1.938,0.477,3.023,0.154c0.194-0.055,0.371-0.109,0.613-0.109
						c0.219,0,0.661,0.063,0.842,0.087c0.626,0.086,1.203,0.12,1.287,0.126c0.672,0.023,1.179-0.2,1.902-0.08
						c-0.159-0.144-0.27-0.235-0.642-0.333c-0.567-0.149-1.42-0.101-2.134-0.149c-0.736-0.055-0.855-0.195-1.036-0.477
						c-0.143-0.232-0.377-0.345-1.333-0.402c-0.354-0.017-0.731-0.017-1.05-0.055c0.543,0.324,0.796,0.399,1.403,0.434
						c0.437,0.023,0.613,0.058,0.955,0.241C66.311,20.676,65.132,20.642,64.501,20.606z"/>
					<path d="M29.442,17.941c0.16-0.092-0.28-0.16-0.28-0.16c-0.121-0.006-0.056,0.086,0.03,0.132
						C29.262,17.953,29.362,17.982,29.442,17.941z"/>
					<path d="M83.144,21.808c0.283,0.025,0.565,0.002,0.277-0.257c-0.178-0.008-0.407-0.02-0.577-0.025l0.283,0.282
						H83.144z"/>
					<path d="M48.691,19.74c-1.163-0.067-2.369-0.09-3.509-0.179c0.138,0.179,0.212,0.275,0.536,0.422
						c0.153,0.066,0.33,0.135,0.49,0.204c0.05,0.026,0.067,0.063,0.153,0.083c0.064,0.015,0.24,0.038,0.366-0.066
						c0.095-0.086,0.068-0.175,0.259-0.249c0.067-0.031,0.311-0.037,0.445-0.055c0.35,0.095,0.465,0.224,0.88,0.304
						c0.458,0.092,1.32,0.187,1.592,0.184c0.177-0.045-0.005-0.12,0.171-0.166c0.195,0.012,0.371,0.035,0.53,0.066
						c0.007,0.003,0.642,0.112,0.879,0.08c0.327-0.043-0.008-0.327-0.02-0.33C51.46,20.038,50.439,19.851,48.691,19.74z"/>
					<path d="M82.365,21.732c0.146,0.066,0.473,0.124,0.53,0.08c0.059-0.043-0.224-0.167-0.347-0.221
						C82.194,21.623,82.253,21.684,82.365,21.732z"/>
					<polygon points="51.832,20.245 52.179,20.268 51.983,20.067 51.636,20.05 "/>
					<path d="M28.8,18.727c0.248,0.14,0.546,0.14,0.669,0.137c-0.201-0.112-0.455-0.184-0.795-0.227
						C28.708,18.666,28.747,18.697,28.8,18.727z"/>
					<path d="M33.642,19.441c-0.158-0.01-0.154,0.065-0.062,0.114c0.039,0.022,0.227,0.109,0.475,0
						C33.824,19.463,33.712,19.446,33.642,19.441z"/>
					<polygon points="81.988,22.301 81.447,22.275 81.634,22.45 82.177,22.479 "/>
					<path d="M59.19,21.233c0.129,0.068,0.289,0.073,0.577,0.092c-0.119-0.058-0.254-0.133-0.364-0.19l-0.354-0.02
						C59.083,21.155,59.12,21.192,59.19,21.233z"/>
					<polygon points="31.735,19.562 32.045,19.584 31.862,19.403 31.549,19.381 "/>
					<path d="M29.153,19.481c0.153,0.083,0.254,0.08,0.395,0.052c0.075-0.021,0.191-0.034,0.451,0
						c-0.084-0.087-0.198-0.199-0.283-0.282c-0.094,0.061-0.112,0.061-0.392,0.031C29.316,19.279,28.694,19.234,29.153,19.481z"/>
					<path d="M41.831,21.681c0.036,0.017,0.077,0.046,0.117,0.066c0.841,0.398,2.854,0.246,3.048,0.16
						c0.101-0.043,0.006-0.118-0.129-0.215C42.813,21.583,42.324,21.561,41.831,21.681z"/>
					<path d="M37.385,21.517c0.16,0.084,0.353,0.089,0.624,0.095c0.165,0.007,0.348-0.008,0.497,0.018
						c-0.058-0.052-0.129-0.126-0.19-0.184c-0.187-0.133-0.329-0.184-0.571-0.207C37.567,21.23,36.917,21.278,37.385,21.517z"/>
					<path d="M40.367,21.663c0.243,0.133,0.516,0.136,0.684,0.139c-0.168-0.196-0.401-0.296-0.745-0.322
						c-0.053,0-0.109-0.003-0.165-0.003C40.192,21.54,40.255,21.604,40.367,21.663z"/>
					<path d="M34.862,21.21c0.043,0.034,0.086,0.061,0.138,0.089c0.188,0.098,0.401,0.135,0.542,0.152
						c0.382,0.042,0.817,0.034,1.215,0.06c-0.172-0.129-0.45-0.284-1.106-0.335C35.251,21.152,35,21.181,34.862,21.21z"/>
					<path d="M32.313,21.255c0.858,0.007,1.282,0.023,1.648,0.064c-0.434-0.207-0.767-0.313-1.934-0.4
						c-0.931-0.065-1.921-0.052-2.856-0.117c0.086,0.028,0.191,0.068,0.28,0.092C30.503,21.213,31.44,21.247,32.313,21.255z"/>
					<path d="M39.118,21.5c0.046,0.037,0.094,0.074,0.167,0.105c0.247,0.124,0.536,0.121,0.663,0.121
						c-0.051-0.105-0.135-0.181-0.41-0.201C39.404,21.514,39.237,21.525,39.118,21.5z"/>
					<path d="M28.959,20.951c0.079-0.04-0.036-0.126-0.092-0.166c-0.024,0.028-0.059,0.074-0.218,0.063
						c-0.311-0.023-0.448-0.093-0.69-0.133c0.027,0.028,0.06,0.058,0.116,0.086C28.308,20.917,28.83,21.021,28.959,20.951z"/>
					<path d="M50.958,26.071c0.007-0.003,0.463-0.301-0.736-0.391c-0.448-0.025-0.942-0.015-1.337-0.083
						c0.023,0.011,0.05,0.028,0.076,0.04C49.509,25.91,50.673,26.218,50.958,26.071z"/>
					<path d="M41.3,25.362c-0.034-0.023-0.068-0.05-0.111-0.071c-0.003-0.004-0.01-0.01-0.019-0.013
						c-0.124-0.065-0.283-0.126-0.599-0.151c-0.037,0-0.082-0.003-0.119-0.006c0.04,0.034,0.085,0.063,0.138,0.092
						C40.848,25.345,41.109,25.356,41.3,25.362z"/>
					<path d="M28.784,24.472c-0.029-0.021-0.056-0.037-0.084-0.055c-0.006-0.003-0.009-0.009-0.014-0.009
						c-0.131-0.074-0.301-0.149-0.56-0.172c0.017,0.012,0.036,0.022,0.052,0.034C28.45,24.427,28.644,24.458,28.784,24.472z"/>
					<path d="M54.248,26.177c-0.165-0.011-0.35,0.01-0.515-0.011l0.835,0.132C54.495,26.224,54.413,26.195,54.248,26.177z
						"/>
					<path d="M111.264,29.904c-0.23-0.108-0.442-0.218-0.607-0.33c-0.082,0.021-0.247,0.066-0.524,0.044
						c-0.524-0.044-0.879-0.146-1.361-0.198l0.106,0.267c0.029,0.003,0.072,0.006,0.106,0.006c1.426,0.115,1.369,0.574,2.922,0.657
						C111.954,30.247,111.812,30.169,111.264,29.904z"/>
					<path d="M103.183,29.187l0.308,0.275c-0.638-0.103-1.009-0.131-1.798-0.134c-0.654-0.003-1.019-0.037-1.486-0.098
						c0.046,0.011,0.101,0.028,0.148,0.043c1.562,0.393,3.867,0.407,5.499,0.29c-0.207-0.086-0.459-0.193-0.884-0.251
						C104.42,29.233,103.737,29.256,103.183,29.187z"/>
					<polygon points="106.837,29.417 107.168,29.71 107.769,29.732 107.245,29.434 "/>
					<path d="M59.75,27.393c0.265-0.026,0.146-0.112,0.017-0.184c-0.011-0.006-0.011-0.009-0.024-0.016
						c-0.058-0.028-0.116-0.058-0.175-0.079c-0.101-0.01-0.237-0.018-0.343-0.023l0.501,0.304C59.731,27.395,59.743,27.395,59.75,27.393z
						"/>
					<path d="M27.397,25.401c0,0,0.006,0,0.009,0c0.174-0.011,0.242,0.023,0.347,0.041
						c0.969,0.155,1.233,0.195,0.917-0.109c-0.685-0.011-1.033-0.106-1.359-0.373C27.017,25.012,26.961,25.089,27.397,25.401z"/>
					<path d="M141.023,31.447c0.294,0.022,0.684,0.055,0.985,0.074c1.868,0.106,3.8,0.135,5.676,0.238
						c1.078,0.061,1.915,0.27,3.113,0.247c0.152-0.052,0.135-0.12,0.317-0.169c0.047-0.003,0.106-0.006,0.146-0.003
						c1.233,0.089,2.234,0.28,3.46,0.37c1.767,0.13,3.612,0.181,5.411,0.281c0.473,0.026,0.93,0.049,1.403,0.066
						c2.616,0.095,2.627,0.092,3.17-0.115c0.578,0.021,0.565,0.218,1.231,0.213c0.076-0.026,0.076-0.026-0.759-0.383
						c1.261,0.17,2.181,0.435,3.464,0.592c0.567,0.066,1.251,0.021,1.469,0.003c-0.313-0.247-1.58-0.173-2.17-0.327
						c0.053-0.08,0.111-0.184,0.16-0.261c-0.507-0.207-0.85-0.144-1.302,0.04c-0.23-0.084-0.537-0.199-0.772-0.288
						c-3.042-0.076-3.042-0.076-3.843-0.286c-5.304,0.065-9.919-0.565-14.972-0.756c-1.486-0.043-2.923,0.123-4.421,0.049
						c-1.414-0.071-2.757-0.21-4.218-0.244c-0.083,0-0.178,0-0.255-0.005c-0.725-0.01-1.12,0.024-1.372,0.048
						c0.304,0.065,0.707,0.155,1.037,0.215C139.279,31.289,140.706,31.427,141.023,31.447z"/>
					<path d="M30.33,25.713c0.195,0.014,0.57,0.005,0.57,0.005c0.288-0.011,0.502-0.005,0.922,0.023
						c-0.251-0.104-0.627-0.225-1.364-0.285c-0.579-0.036-0.923-0.008-1.111,0.021c0.046,0.018,0.102,0.04,0.156,0.055
						C29.934,25.672,30.17,25.695,30.33,25.713z"/>
					<path d="M52.796,27.597c0.405,0.048,0.761,0.071,0.408-0.179c-0.097-0.072-0.097-0.072-0.303-0.086
						c-0.124-0.006-0.185,0-0.248,0.014c-0.003,0.004-0.006,0.004-0.015,0.004c-0.087,0.04-0.053,0.108,0.115,0.241
						C52.768,27.594,52.79,27.597,52.796,27.597z"/>
					<path d="M50.27,27.269c0.032,0.012,0.071,0.021,0.099,0.029c0.804,0.218,1.592,0.252,1.887,0.264
						c-0.089-0.072-0.374-0.287-1.252-0.348C50.642,27.19,50.396,27.211,50.27,27.269z"/>
					<path d="M49.22,27.28c-0.157-0.074-0.372-0.145-0.899-0.184c-0.38-0.023-0.768-0.012-1.149-0.023
						c0.024,0.007,0.058,0.015,0.08,0.021C47.991,27.309,48.451,27.298,49.22,27.28z"/>
					<path d="M46.924,27.172c0.051-0.036-0.035-0.096-0.073-0.121c-0.148-0.009-0.339-0.021-0.484-0.028
						c0.018,0.028,0.048,0.063,0.11,0.092C46.617,27.183,46.854,27.214,46.924,27.172z"/>
					<path d="M152.104,32.501c-0.013-0.003-1.968-0.104-4.267-0.179c-6.095-0.201-6.095-0.201-8.334-0.333
						c0.095,0.035,0.199,0.087,0.318,0.115c0.212,0.058,0.777,0.213,10.385,0.715c4.362,0.23,6.248,0.207,7.048,0.198
						c-2.569-0.229-4.172-0.385-4.745-0.462C152.388,32.542,152.234,32.513,152.104,32.501z"/>
					<path d="M158.481,33.018c-0.476-0.006-0.801-0.046-1.108-0.09c0.095,0.05,0.201,0.107,0.319,0.153
						c0.555,0.213,0.831,0.2,2.4,0.143c0.371-0.011,0.777-0.028,1.107,0.013c-0.383-0.179-0.607-0.23-1.067-0.253
						C159.566,32.972,159.036,33.029,158.481,33.018z"/>
					<path d="M164.163,33.236c-0.477-0.018-0.937-0.061-1.424-0.069c-0.107-0.003-0.254-0.006-0.366,0
						c-0.512,0.006-0.567,0.109-0.607,0.178c0.024-0.006,0.053-0.012,0.064-0.017c0.943-0.173,2.134,0.27,2.811,0.008
						c0.194,0.061,0.448,0.145,0.643,0.204c1.544-0.042,2.299-0.055,3.588,0.015c-0.63-0.192-1.16-0.261-2.293-0.308
						C165.778,33.23,164.965,33.265,164.163,33.236z"/>
					<path d="M171.354,33.719c0.512,0.014,1.032,0.031,1.551,0.045c-0.172-0.12-0.75-0.247-1.233-0.27
						c-0.482-0.009-0.447,0.115-0.365,0.225C171.319,33.719,171.343,33.719,171.354,33.719z"/>
					<path d="M169.669,33.373c-0.465-0.008-0.896,0.084-0.459,0.285c0.011-0.003,0.023-0.003,0.035-0.003
						c0.146-0.01,0.335,0,0.577,0.017c0.459,0.038,0.613,0.026,0.662,0.013c0.129-0.044-0.049-0.22-0.484-0.282
						C169.899,33.391,169.792,33.38,169.669,33.373z"/>
					<path d="M176.531,33.815c0.01-0.045-0.036-0.092-0.089-0.137c-0.795,0.224-1.833-0.185-2.711,0.017
						c0.01,0.005,0.029,0.012,0.052,0.018C174.089,33.787,176.476,34.12,176.531,33.815z"/>
					<path d="M49.161,28.556c-0.23-0.009-0.416,0.055-0.006,0.401c0.012-0.006,0.027-0.012,0.046-0.017
						c0.197-0.081,0.378-0.044,0.584,0.005c0.359,0.087,0.53,0.069,0.713,0.006c-0.094-0.006-0.224-0.014-0.321-0.017
						C49.718,28.624,49.282,28.566,49.161,28.556z"/>
					<path d="M44.333,28.372c-0.187-0.041-0.455-0.041-0.659-0.07c-0.071-0.011-0.166-0.027-0.216-0.039
						c-0.034-0.015-0.092-0.029-0.121-0.035c-0.109-0.039-0.084-0.092-0.3-0.114c-0.024,0-0.046,0-0.064,0
						c-0.075,0.022-0.083,0.039,0.04,0.184c0.125,0.132,0.129,0.155,0.056,0.178c-0.078,0-0.139-0.012-0.19-0.022
						c0.04,0.017,0.097,0.037,0.138,0.051c0.251,0.087,0.498,0.139,0.742,0.162c0.411,0.04,0.838,0.011,1.259,0.024
						c-0.184-0.134-0.33-0.224-0.56-0.289C44.432,28.389,44.375,28.377,44.333,28.372z"/>
					<path d="M56.692,29.428c-0.132-0.117-0.307-0.275-0.442-0.394c-0.089-0.008-0.184-0.02-0.273-0.022
						c-0.294-0.014-0.294-0.014-0.955,0.041c0.065,0.04,0.129,0.079,0.218,0.117C55.589,29.336,56.054,29.417,56.692,29.428z"/>
					<path d="M53.971,29.17c0.261,0.017,0.52,0.034,0.778,0.046c-0.126-0.081-0.251-0.109-0.479-0.139
						c-0.293-0.04-0.406-0.082-0.521-0.194l0.167,0.28C53.938,29.166,53.957,29.17,53.971,29.17z"/>
					<polygon points="45.539,28.633 45.746,28.812 46.067,28.834 45.857,28.652 "/>
					<path d="M58.789,31.329c0.089-0.046-0.065-0.154-0.129-0.209c-0.376,0.002-0.564-0.075-0.883-0.102
						c-0.107-0.003-0.167,0.004-0.289,0.032c0.018,0.006,0.027,0.015,0.046,0.02C57.833,31.22,58.617,31.41,58.789,31.329z"/>
					<path d="M50.816,30.663c0.055,0.029,0.148,0.049,0.246,0.063c0.208,0.04,0.306,0.074,0.377,0.207
						c0.392,0.024,0.343-0.107,0.583-0.145c-0.184-0.144-0.359-0.189-0.825-0.222c-0.171-0.008-0.362-0.005-0.519-0.031
						C50.706,30.58,50.73,30.623,50.816,30.663z"/>
					<path d="M48.572,30.646c0.035-0.022,0.035-0.068-0.159-0.167l-0.38,0.052c0.02,0.021,0.046,0.044,0.087,0.063
						C48.274,30.672,48.508,30.686,48.572,30.646z"/>
					<polygon points="47.941,30.703 47.711,30.508 47.23,30.476 47.461,30.675 "/>
					<path d="M45.834,30.53c0.006,0.006,0.011,0.013,0.02,0.016c0.017,0.008,0.038,0.017,0.056,0.024
						c0.089,0.007,0.218,0.013,0.313,0.018l0.016-0.086c-0.076-0.089-0.242-0.115-0.337-0.126C45.757,30.37,45.611,30.404,45.834,30.53z"
						/>
					<polygon points="143.687,35.435 143.487,35.264 143.045,35.246 143.251,35.424 "/>
					<path d="M164.441,16.351c-0.926-0.005-0.938,0.016-1.021,0.092c-0.093,0.087-0.224,0.092-0.605,0.084
						c-0.973-0.021-1.716-0.204-2.735-0.199c-0.319,0.006-0.501,0.053-0.607,0.081c0.07,0.058,0.178,0.132,0.318,0.184
						c0.949,0.367,2.635,0.574,6.017,0.741c1.94,0.095,2.428,0.058,3.497-0.27c0.093,0.028,0.223,0.074,0.329,0.103
						c-0.631-0.626-4.08-0.781-4.761-0.804C164.729,16.356,164.583,16.354,164.441,16.351z"/>
					<path d="M38.981,27.659c0.107,0.23-0.022,0.271-0.642,0.184c-1.368-0.189-0.675,0.235-0.346,0.437
						c0.03,0.003,0.059,0.003,0.081,0.003c0.804,0.026,2.09,0.173,2.099,0.176c1.185,0.137,1.815,0.178,2.661,0.086
						c-0.625-0.355-1.165-0.454-2.148-0.534C39.9,27.947,39.465,27.906,38.981,27.659z"/>
					<path d="M24.931,27.125c0.014,0.092,0.017,0.118,0.191,0.167c0.35,0.095,0.35,0.095,0.464,0.224
						c0.922,0.006,0.976,0.006,0.969-0.17c0.139,0.087,0.323,0.201,0.462,0.285c3.664,0.172,3.664,0.172,4.352,0
						c-0.008,0.083-0.076,0.17,0.024,0.256c0.774,0.005,1.229,0.031,2.5,0.126c2.081,0.152,2.725,0.149,3.634-0.021
						c-0.693-0.218-0.731-0.302-0.915-0.684c0.148,0.092,0.339,0.213,0.481,0.305c0.995,0.006,1.302-0.029,1.42-0.247
						c2.066,0.106,2.066,0.106,3.133,0.385c-0.165-0.12-0.195-0.244-0.266-0.367c1.42-0.175,2.704-0.228,4.892-0.201
						c-0.969-0.644-2.569-0.558-2.755-0.545c-0.158-0.023-0.428-0.063-1.115-0.411c-4.331-0.265-7.044-0.644-8.503-0.847
						c-0.484,0.229-0.74,0.252-2.125,0.189c0.742,0.603,0.742,0.603,4.124,1.252c-0.038-0.003-0.083,0-0.125,0
						c-0.182,0.109-0.028,0.226-0.165,0.338c-0.851,0.095-1.166-0.144-1.753-0.215c-0.072,0.341,0.899,0.598,0.908,0.598
						c0.003,0.002,0.027,0.229-0.995,0.014c-0.218-0.043-0.411-0.092-0.615-0.138c-0.126,0.069-0.283,0.121-0.99,0.023
						c-1.022-0.138-1.325-0.136-1.381,0.143c-0.185-0.097-0.44-0.224-0.63-0.32c-0.106,0.074-0.119,0.079-0.283,0.097
						c-0.505-0.052-0.705-0.201-1.338-0.206c-0.445-0.006-0.891,0.052-1.344,0c-0.362-0.04-0.608-0.121-0.792-0.184
						C26.559,27.266,26.404,27.251,24.931,27.125z"/>
					<path d="M112.979,29.681c-0.012,0-0.024,0-0.036,0c-0.312,0-0.366,0.069-0.553,0.104
						c-0.201,0.037-0.307,0.006-0.408-0.063c-0.229-0.002-0.252,0.034-0.064,0.118c0.141,0.061,0.389,0.123,0.435,0.084
						c0.049-0.032-0.022-0.063-0.058-0.098c0.217,0.085,0.5,0.203,0.718,0.292C113.604,30.054,113.122,29.698,112.979,29.681z"/>
					<path d="M46.35,28.658h-0.002c0.196,0.069,0.537,0.099,0.798,0.149C47.14,28.808,46.58,28.679,46.35,28.658z"/>
					<path d="M58.224,19.412c-0.332-0.012-0.661,0-0.991-0.015c-0.313-0.009-0.554-0.083-0.926-0.058
						c-0.101,0.049-0.112,0.061-0.018,0.17c0.26,0.021,0.608,0.046,0.872,0.065c3.213,0.236,3.997,0.325,6.023,0.679
						c0.203-0.112,0.237-0.133,0.884-0.104c0.526,0.021,0.502-0.071,0.442-0.278c-1.938-0.327-2.067-0.372-2.073-0.379
						c-0.337-0.135,0.406-0.215,0.342-0.339c0.748,0.181,1.583-0.023,2.369,0.029c0.901,0.058,1.68,0.189,2.6,0.235
						c0.059,0.006,0.141,0.006,0.199,0.011c0.23,0.006,0.384-0.017,0.614-0.063c0.306-0.063,0.565-0.121,2.564,0.021
						c0.63,0.045,1.101,0.16,1.75,0.197c1.095,0.063,1.143,0.063,1.166-0.031c0.013-0.032-0.023-0.071-0.046-0.104
						c0.602,0.077,0.542,0.268,1.154,0.342c0.064-0.051,0.154-0.124,0.224-0.179c-0.435-0.231-0.782-0.26-2.069-0.372
						c-0.558-0.047-1.083,0.042-1.632,0.017c-2.487-0.117-4.698-0.413-7.131-0.563c-3.088-0.161-3.372-0.115-3.926-0.021
						c-3.57-0.703-3.866-0.049-3.872-0.042c0.006,0.002,0.2,0.14,0.701,0.218c0.224,0.034,0.224,0.034,1.545,0.092
						c1.055,0.045,1.439,0.286,2.276,0.396C60.775,19.449,60.369,19.47,58.224,19.412z"/>
					<path d="M87.063,20.985c0.171-0.04,0.401-0.028,0.616-0.022c-0.224-0.012-0.437-0.028-0.676-0.035L87.063,20.985z"/>
					<path d="M29.122,28.199c-3.31-0.493-7.263-0.58-10.876-0.876c-0.303,0.032-0.704,0.077-1.01,0.111
						c-1.439-0.166-2.705-0.396-4.129-0.571c0.036,0.095,0.079,0.222,0.118,0.322c6.378,1.071,14.144,1.267,21.593,1.668
						c-1.671-0.178-3.259-0.41-4.682-0.764C29.831,28.125,29.427,28.168,29.122,28.199z"/>
					<path d="M40.453,29.227c-1.842-0.143-3.72-0.272-5.636-0.373C36.61,29.04,38.503,29.155,40.453,29.227z"/>
					<path d="M123.5,24.225c0.218,0.098,0.86,0.259,1.38,0.189c-0.129-0.126-0.302-0.296-0.431-0.422
						c-0.07,0.063-0.199,0.083-0.494,0.109C123.547,24.136,123.399,24.179,123.5,24.225z"/>
					<path d="M852.688,17.336c0.33,0.135,0.885,0.262,1.037,0.152c0.036-0.023,0.042-0.053,0.047-0.074
						c-0.129-0.029-0.306-0.073-0.435-0.102c-0.408-0.095-0.638-0.135-0.78-0.137C852.324,17.181,852.628,17.31,852.688,17.336z"/>
					<path d="M802.752,16.768c0.254,0.092,0.837,0.117,0.909,0.246c0.766-0.031,0.248-0.283-0.318-0.373
						c-0.148-0.022-0.313-0.036-0.49-0.043c-0.064,0.003-0.135,0.007-0.205,0.007C802.637,16.644,802.593,16.707,802.752,16.768z"/>
					<path d="M797.248,22.711c1.167,0.05,1.379-0.16,0.909-0.315c-0.066-0.02-0.144-0.04-0.218-0.055
						c-0.75,0.006-0.96,0.118-0.727,0.367C797.225,22.708,797.242,22.708,797.248,22.711z"/>
					<path d="M805.5,23.292c-0.678-0.296-0.883-0.385-1.096-0.595c-0.437,0.077-0.831,0.098-1.638,0.074
						c0.106,0.155,0.27,0.391,0.636,0.526C804.039,23.533,805.064,23.363,805.5,23.292z"/>
					<path d="M838.473,28.131c0.871-0.018,0.801-0.204,0.647-0.369c-0.146-0.011-0.294-0.021-0.459-0.028
						c-0.108,0-0.313,0-0.366,0.072c-0.071,0.109,0.129,0.215,0.106,0.325C838.424,28.131,838.448,28.131,838.473,28.131z"/>
					<path d="M847.29,33.917c0.028,0.003,0.059,0.003,0.076,0.006c0.75,0.051,1.314-0.095,2.015-0.09
						c-0.206-0.243-0.971-0.439-1.172-0.684c-0.106-0.002-0.224-0.005-0.342-0.008c-0.461,0.003-0.854,0.058-1.287,0.082
						C846.783,33.46,847.313,33.672,847.29,33.917z"/>
					<path d="M850.037,12.969c0.034-0.047,0.07-0.087,0.04-0.133l-0.831,0.282c0.024,0.017,0.049,0.042,0.106,0.063
						C849.564,13.255,849.9,13.105,850.037,12.969z"/>
					<path d="M771.208,34.571c0.14,0.006,0.33,0.015,0.471,0.02c-0.183,0.061-0.435,0.144-0.613,0.207
						c0.095,0.015,0.237,0.034,0.332,0.052c21.748,0.241,50.747,0.563,72.496,0.808c0.059-0.278,0.378-0.549,0.436-0.83
						c-0.389-0.032-0.914-0.074-1.308-0.109c0-0.018-1.864-2.32-2.192-2.539c-1.061-0.677-1.061-0.677-0.979-0.884
						c0.177-0.491,1.58-0.901,1.815-1.391c-0.141-0.011-0.323-0.025-0.466-0.037c-0.264-0.138-0.217-0.301-0.618-0.427
						c-0.235-0.01-0.554-0.019-0.79-0.029c0.266-0.402,0.183-0.604-0.4-0.971c-1.402,0.402-1.486,0.919-2.223,1.378
						c0.243,0.115,0.243,0.115,0.572,0.725c-0.6,0.12-0.6,0.12-0.366,0.37c-1.519-0.104-0.234-0.618-1.91-0.692
						c-0.612-0.028-3.901,0.184-2.899,1.119c-2.9-0.456-3.035-0.568-5.34-2.46c-0.417-0.034-0.784-0.065-1.391-0.364
						c-0.731-0.356-5.452-3.001-5.457-3.004l-1.367-0.396c-0.667-0.19-0.125-0.402-0.289-0.6l-0.95-0.199
						c-0.317-0.824-2.942-1.47-3.396-2.279c-0.589-0.052-0.589-0.052-2.476-0.914l-1.378-0.301c-0.165-0.456-0.165-0.456-0.955-0.608
						c-0.714-0.136-0.696-0.188-0.271-0.389c-1.061-0.092-1.002-0.384-1.851-0.511c-0.165-0.313-0.26-0.595-0.201-0.591
						c-2.05-0.385-2.145-1.018-3.583-1.482c-0.248-0.04-0.59-0.098-0.849-0.144c0.153,0.207,0.377,0.482,0.672,0.678
						c0.555,0.356,1.344,0.689,1.769,1.057c0.177,0.161-0.194,0.396,0.07,0.552c0.343,0.197,0.955,0.212,1.35,0.221
						c3.012,2.656,3.107,2.656,3.979,2.674c-1.031,1.395-1.031,1.395-0.66,1.874c-0.484,0.125-1.32,0.228-1.597,0.055
						c-0.666,0.23-0.938,0.503-0.919,0.67c0.849,0.043,1.644-0.118,2.504-0.031c0.148,0.092,0.148,0.092,0.118,0.166l5.908,0.069
						c-4.991-0.055-5.333-0.047-7.365,0.022c-0.076,0.023-0.182,0.055-0.258,0.078c1.492,0.66,0.501,1.524,3.396,2.063
						c0.371,1.546,0.371,1.546,0.259,1.644c-3.413-0.42-4.827-0.818-6.048-1.727c-1.154-0.864-1.48-0.864-2.246-0.87
						c1.251-0.551-1.39-0.891-1.444-1.367c0.006-0.367,0.006-0.367-0.142-0.505l-0.906-0.104c0.112-0.028,0.258-0.063,0.366-0.092
						c-0.491-0.138-1.209-0.206-1.799-0.321c0.036-0.21-0.543-0.388-0.696-0.589c-0.283-0.022-0.671-0.046-0.942-0.077
						c-0.059-0.006-4.882-0.694-1.121-0.908c-0.942-0.304,0.144-0.671-0.593-0.984c-0.761-0.003-1.528-0.009-2.035-0.072
						c-0.417-0.052-0.801-0.355,0.331-0.442c-0.285-0.031-0.684-0.086-0.797-0.149c-0.488-0.295,0.301-0.592-0.052-0.884
						c-0.212-0.175-1.192-0.182-1.432-0.351c0.065-0.018,0.141-0.046,0.206-0.063c0.083,0.003,0.188,0.005,0.271,0.005
						c0.058-0.012,0.141-0.031,0.2-0.039c-0.731-0.256-2.123-0.328-2.96-0.552c0.048-0.018,0.12-0.04,0.171-0.058
						c0.383,0.028,0.614,0.049,1.214,0.201c0.112-0.015,0.253-0.034,0.367-0.052c0.147-0.351,0.059-0.652-2.683-0.469
						c-0.165-0.191-0.106-0.206,0.165-0.264c1.568,0.037,1.568,0.037,1.397-0.235l-2.682-2.297c-0.106-0.089-0.308-0.213-0.459-0.302
						c-0.119-0.052-0.285-0.12-0.401-0.173c-0.636,0.247-1.581,0.437-2.321,0.66c0.317,0.339,0.765,0.669,1.143,0.999
						c0.235,0.214-0.938,0.233-1.139,0.388c-0.118,0.096,0.112,0.228,0.229,0.316c0.012,0.006,0.802,0.526,3.172,0.805
						c-1.097,0.468,0.549,0.861,0.708,1.294c0.023,0.081-0.201,0.185-0.142,0.265c0.106,0.157,0.235,0.21,0.695,0.377
						c0.602,0.209,0.497,0.283,0.277,0.43c-0.029-0.003-3.482-0.168-4.207-0.296c-0.755-0.131,0-0.304-0.138-0.453
						c-1.519-0.115-2.097-0.327-2.462-0.896c-1.274-0.173-1.486-0.259-2.83-0.815c-1.225,0.459,0.455,0.993-0.718,1.453
						c0.761,0.247,1.225,1.159,1.225,1.169c-1.166,0.226-1.166,0.226-1.108,0.307c-3.011-0.552-3.436-1.441-5.467-2.119
						c-1.327,0.293-1.91,0.545-1.511,1.551c-3.548-0.563-2.935-1.632-5.476-2.315c0.208-0.092-1.561-1.826-1.584-1.843
						c-0.436-0.287-1.097-0.365-1.857-0.454c0.237-0.441,0.159-0.511-1.479-0.608c-0.79,0.241,0.459,0.413,0.647,0.62
						c-0.566,0.158-0.854,0.144-1.143,0.126c-0.018-0.021-0.036-0.046-0.059-0.068c-0.659,0.16-0.289,0.265,1.484,0.608
						c0.036,0.494-0.452,0.982-0.306,1.477c0.848,0.045,2.593-0.182,2.576,0.098c-0.005,0.141-1.255,0.419-2.056,0.194
						c-0.661,0.621,1.839,0.937,2.668,1.407c-0.324,0.793,1.126,1.557,0.583,2.35c-0.022,0.031-0.271,0.298-2.392,0.259
						c-0.154,0.694,0.305,1.378,0.377,2.069c0.035,1.082,0.035,1.082,0.188,1.221c0.376,0.351,1.678,0.589,2.157,0.925
						c0.108-0.017,0.224-0.046,0.341-0.058c1.245-0.109,4.841,0.402,2.453,1.178c-0.471-0.028-1.507-0.209-0.86-0.405
						c0.148-0.003,0.353-0.008,0.507-0.011c-2.76-0.457-2.76-0.457-2.794-0.612c-0.484-0.017-1.139-0.046-1.633-0.066
						c0.053-0.065,0.065-0.151,0.041-0.215c-0.24,0.003-0.559,0.012-0.802,0.017c-0.342-0.464-0.347-0.482-1.674-0.453
						c-0.294,0.133-0.376,0.522,1.929,0.597c-1.238,0.247-0.359,0.561-0.519,0.839c-0.03,0.049-0.043,0.115-0.059,0.161
						c-0.077,0.311,0.082,0.546,0.146,0.646l1.002,0.309c-0.613,0.545,2.133,0.946,1.249,1.504c-0.989,0.029-0.989,0.029-1.627,0.132
						c-0.289,0.718-0.105,0.925,1.004,1.163c-0.531,0.934,0.665,1.852,0.329,2.789c1.627,0.385,1.627,0.385,1.581,0.647l3.039,0.033
						C770.796,34.659,770.796,34.659,771.208,34.571z M827.333,34.539c-0.503-0.006-0.891-0.022-1.327-0.192
						c-0.006-0.002-0.018-0.005-0.031-0.008C826.865,34.35,827.402,34.355,827.333,34.539z M814.295,29.216
						c0.081,0.16,0.152,0.321,0.229,0.484c-0.388-0.005-0.795-0.014-1.033-0.079C813.068,29.503,813.54,29.268,814.295,29.216z
						 M804.84,31.415l-0.095-0.189l0.86,0.012l0.094,0.189L804.84,31.415z M808.458,33.661l0.1,0.188l-0.794-0.011l-0.095-0.189
						L808.458,33.661z M806.703,30.08c0.04,0.089,0.094,0.21,0.142,0.299c-0.178,0.008-0.349,0.008-0.526,0.008
						c-0.423-0.006-0.772-0.037-1.119-0.166c-0.225-0.083-0.384-0.172-0.602-0.259C805.218,29.957,805.924,29.957,806.703,30.08z
						 M794.323,21.382c0.467,0.109,0.472,0.328-0.629,0.321c-0.077,0-0.147,0-0.218,0c-0.012,0-0.036,0-0.047,0
						c-0.047-0.12-0.106-0.278-0.152-0.398C793.818,21.291,794.148,21.339,794.323,21.382z M790.505,19.612
						c1.621-0.021,2.169,0.118,2.175,0.118c0.006,0.003,0.258,0.188-0.114,0.276c-0.27,0.068-0.659,0.085-1.413,0.103
						c-0.083-0.022-0.159-0.046-0.224-0.071C790.469,19.874,790.492,19.688,790.505,19.612z M788.407,20.759
						c-0.113,0.058-0.147,0.149-0.059,0.21c0.471,0.04,1.014,0.034,1.443,0.108c0.112,0.279,1.078,0.46,1.54,0.695
						c0.294,0.046,0.683,0.105,0.978,0.149c0.437,0.56,0.437,0.56,0.59,0.643c0.913,0.104,0.913,0.104,1.909,1.585
						c1.166,0.156,1.443,0.293,1.415,0.707c-0.095,0.425-0.082,0.442,0.023,0.66c-0.571,0.018-1.173,0.037-2.81-0.694
						c-0.407-0.198-0.749-0.405-1.114-0.608c-1.799-0.753-2.242-1.637-4.386-2.361c-0.089-0.034-0.177-0.068-0.259-0.104
						c-0.054-0.034-0.13-0.08-0.189-0.114C789.009,21.411,787.44,21.017,788.407,20.759z M770.594,27.947
						c3.367,2.066,3.367,2.066,3.733,2.48c0.03,0.04,0.03,0.04-0.501,0.339c-0.307,0.175,0.507,0.304,0.365,0.471
						c-0.058,0.074-0.205,0.087-0.602,0.115c2.312,0.184,2.312,0.184,2.641,0.32c-1.302,0.047-1.449,0.133-2.173,0.553
						c-0.279,0.011-0.562,0.011-0.843,0.005c-1.155-0.045-1.433-0.055-1.934-0.224c-0.701-0.235-0.655-0.528-1.079-0.787
						c-0.901-0.003-1.91,0.23-2.705,0.003c-0.131-0.037-0.213-0.083-0.294-0.129c1.532,0.058,2.393-0.235,3.583-0.351
						c-1.126-0.557-2.11-1.132-3.336-1.674c0.342-0.055,0.801-0.124,1.144-0.176C767.306,28.573,767.807,28.478,770.594,27.947z
						 M766.305,27.711c-0.36-0.127-0.825-0.235-1.167-0.361c-0.131-0.046-0.236-0.096-0.318-0.144c0.482-0.052,1.125-0.121,1.615-0.167
						l-0.325,0.275c-0.087,0.069-0.011,0.12,0.348,0.222c0.282,0.08,0.389,0.117,0.176,0.152c-0.023,0-0.046,0-0.059,0.005
						C766.48,27.699,766.393,27.706,766.305,27.711z M766.446,27.992c0.647-0.135,1.826-0.065,1.803,0.225
						c-0.835-0.01-1.296-0.018-1.638-0.139C766.541,28.05,766.486,28.021,766.446,27.992z M765.808,30.798l-0.104-0.204
						c0.082-0.095,0.353-0.112,0.813-0.048c0.59,0.077,1.416,0.317,0.577,0.358L765.808,30.798z M769.734,33.331l-0.141-0.05
						c-1.308-0.465-1.95-1.125-2.517-1.705c0.725-0.029,1.22,0.109,1.886,0.126c0.089,0,0.164-0.011,0.253-0.011
						c-0.212,0.278-0.212,0.278,0.872,0.882c-0.224,0.024-0.513,0.06-0.729,0.082c0.425,0.106,0.425,0.106,1.555,0.592
						c-0.253-0.003-0.589-0.005-0.848-0.008L769.734,33.331z"/>
					<path d="M848.273,35.372c-0.207-0.252-0.418-0.37-1.162-0.407c-0.071,0-0.129,0-0.188,0
						c0.106,0.063,0.33,0.195,0.177,0.333c-0.17,0.149-0.744,0.247-0.983,0.385l2.563,0.029C848.469,35.617,848.415,35.55,848.273,35.372
						z"/>
					<path d="M1427.052,15.518c0.037,0.023,0.088,0.047,0.145,0.069c0.256,0.012,0.58,0.025,0.832,0.038l-0.252-0.312
						C1427.272,15.329,1426.802,15.368,1427.052,15.518z"/>
					<path d="M1430.915,22.146c0.277,0.115,2.092,0.311,2.234-0.108c1,0.118,4.18,0.396,5.68,0.149
						c0.619,0.132,0.619,0.132,4.758,0.302c-0.109,0.229-1.006,0.39-1.043,0.626c0.367,0.014,0.846,0.037,1.203,0.048
						c0.936-0.071-0.154-0.339,0.578-0.456c0.549,0.095,0.756,0.256,1.367,0.335c0.402,0.058,0.766-0.005,0.945-0.034
						c0.008-0.238-1.379-0.299-1.367-0.542c5.592-0.04,5.592-0.04,6.965-0.084c-1.227-0.33-3.129-0.43-4.574-0.684
						c-1.387,0.354-5.326,0.385-5.584-0.338c-1.787,0.037-3.615-0.095-5.379,0.063c0.342,0.127,1.063,0.167,1.35,0.305
						c0.258,0.12,0.203,0.167-0.006,0.333c-0.539-0.009-0.801-0.087-1.238-0.236c-0.861-0.292-1.488-0.113-1.502,0.01
						c-0.721-0.089-1.107-0.268-1.846-0.348c-0.307-0.034-0.518-0.023-0.93,0.04c-0.035,0.086-0.084,0.207-0.119,0.293
						c-0.83,0.034-1.461-0.149-2.297-0.104c-0.557,0.029-0.592,0.118-0.607,0.258c0.025,0,0.051,0,0.074,0
						C1430.116,21.973,1430.544,21.999,1430.915,22.146z"/>
					<path d="M1427.827,22.088c0.697-0.017,0.842-0.137,0.891-0.241c-0.604,0.029-0.861,0.098-0.941,0.241
						C1427.796,22.088,1427.815,22.088,1427.827,22.088z"/>
					<path d="M1425.806,22.135c0.086-0.053-0.006-0.104-0.061-0.133c-0.031,0-0.068-0.006-0.117-0.006
						c-0.41-0.011-0.723,0.066-1.129,0.063c-0.014,0.021-0.014,0.041,0.023,0.063C1424.708,22.215,1425.604,22.237,1425.806,22.135z"/>
					<path d="M1489.794,25.345c0.307-0.146-1.008-0.138-1.02-0.138c-0.963,0.011-0.902-0.086-0.873-0.138
						c-0.129,0.012-0.484,0.043-0.307,0.123C1487.907,25.333,1489.521,25.469,1489.794,25.345z"/>
					<path d="M1452.175,23.536c-1.084-0.029-1.602,0.061-1.791,0.31c0.023,0,0.061,0,0.092,0.003
						C1451.923,23.88,1452.114,23.619,1452.175,23.536z"/>
					<path d="M1460.052,25.815c0.027-0.061,0.064-0.137,0.088-0.197l-0.332-0.106c-0.465-0.018-0.613,0.144-0.43,0.243
						C1459.501,25.83,1459.728,25.847,1460.052,25.815z"/>
					<path d="M1428.622,24.427c0.213,0.113,0.873,0.178,1.475,0.086c-0.012-0.144-0.371-0.225-1.195-0.259
						c-0.1-0.006-0.209-0.006-0.303-0.013C1428.563,24.277,1428.493,24.352,1428.622,24.427z"/>
					<path d="M1427.999,24.544c0.082-0.055-0.184-0.112-0.301-0.136l-0.867,0.058c0.02,0.012,0.037,0.029,0.061,0.037
						C1427.126,24.626,1427.882,24.621,1427.999,24.544z"/>
					<path d="M1457.317,26.172c-1.268-0.05-2.643,0.034-3.777-0.16c-0.67,0.246-0.67,0.246-1.705,0.108
						c0.033,0.06,0.07,0.127,0.205,0.178c0.186,0.075,0.443,0.109,0.75,0.146c0.695,0.086,0.93,0.141,1.178,0.343
						c0.426-0.007,0.5-0.058,0.598-0.242c0.027-0.063,0.086-0.189,0.416-0.195c0.043,0,0.285,0.006,0.891,0.098
						c0.537,0.086,0.818,0.109,1.445,0.101c0.162-0.074,0.389-0.178,0.559-0.253l0.746,0.031
						C1458.206,26.24,1457.899,26.203,1457.317,26.172z"/>
					<path d="M1450.524,26.342c0.117-0.099-0.35-0.13-0.494-0.136c-0.477-0.02-1.002,0.028-0.766,0.178
						c0.014,0,0.025,0.01,0.031,0.013c0.24,0.011,0.566,0.024,0.813,0.037L1450.524,26.342z"/>
					<polygon points="1447.368,26.108 1446.624,26.08 1446.542,26.275 1447.288,26.31 "/>
					<path d="M1443.667,26.336c1.088,0.068,1.258-0.093,1.289-0.238c-0.361-0.018-0.836-0.038-1.197-0.052l-0.117,0.287
						C1443.642,26.333,1443.653,26.336,1443.667,26.336z"/>
					<path d="M1457.327,26.993c-0.01-0.006-0.023-0.018-0.037-0.022c-0.146-0.129-0.49-0.152-0.611-0.162
						c-0.082-0.006-0.152-0.006-0.236-0.006c-0.033,0.035-0.117,0.099-0.01,0.165c0.105,0.065,0.379,0.105,0.674,0.149
						c0.527,0.076,0.863,0.14,0.658,0.324c0.152-0.112,0.373-0.259,0.533-0.368C1457.618,27.107,1457.446,27.054,1457.327,26.993z"/>
					<path d="M1453.497,27.206c-0.555-0.018-0.861-0.013-1.328,0.077c0.045,0.034,0.078,0.066,0.137,0.101
						c0.246,0.143,0.625,0.181,1.18,0.192c0.717,0.015,1.119,0.025,1.754,0.123c0.207-0.315,0.168-0.454-0.197-0.585
						C1454.464,27.234,1454.108,27.229,1453.497,27.206z"/>
					<path d="M1446.413,27.51c0.045,0,0.115,0.003,0.164,0.006c0.625,0.008,1.26-0.021,1.896,0.006
						c0.471,0.022,0.805,0.075,1.121,0.127c-0.068-0.276-1.004-0.472-1.35-0.725l-0.525,0.351c-0.012,0.086-0.189,0.095-0.684,0.075
						C1446.472,27.326,1446.177,27.323,1446.413,27.51z"/>
					<path d="M1457.856,28.107c-1.213-0.023-1.184,0.023-0.953,0.439c0.014,0.003,0.031,0.003,0.037,0.003
						c1.26,0.103,1.424-0.213,1.094-0.377C1457.987,28.152,1457.923,28.131,1457.856,28.107z"/>
					<path d="M1426.948,29.256c-0.086,0-0.178-0.003-0.258-0.006c0.012,0.009,0.037,0.018,0.049,0.028
						c0.232,0.144,0.676,0.184,1.076,0.201C1428.007,29.331,1427.655,29.288,1426.948,29.256z"/>
					<path d="M1426.938,29.629c-0.555,0.006-0.967,0.012-1.305-0.018c-0.535-0.037-0.93-0.134-1.424-0.189
						c-0.135,0.047-0.391,0.127-0.213,0.189c0.146,0.053,0.514,0.075,0.854,0.096c0.283,0.017,0.57,0.031,0.826,0.071
						c-0.023,0.052-0.049,0.126-0.072,0.179l2.004,0.086L1426.938,29.629z"/>
					<path d="M1424.132,29.888c-0.861,0.029-1.271-0.035-1.691-0.155c0,0.041-0.006,0.098,0.111,0.158
						c0.18,0.095,0.529,0.146,0.805,0.178c0.824,0.09,1.742,0.118,2.584,0.198C1425.728,29.931,1425.323,29.848,1424.132,29.888z"/>
					<path d="M1414.854,25.333c1.303,0.121,2.67,0.155,3.588,0.17c1.104,0.014,2.391,0.02,3.449,0.014
						c1.092-0.002,2.688,0.003,4.125,0.063c1.412,0.058,1.029,0.474,2.215,0.575c0.014,0.051-0.08,0.126-0.203,0.171
						c-0.367,0.016-0.736,0.029-1.096,0.053c0.508,0.318,1.76,0.511,2.586,0.775c3.053-0.546,8.629,0.16,8.867,0.191
						c0.172-0.169,0.172-0.169-0.41-0.364c-0.65-0.221,0.598-0.81,5.289-0.663c-0.33-0.38-2.262-0.21-3.084-0.428
						c0.324-0.069,0.762-0.158,1.092-0.228c0.447,0.032,0.773,0.052,1.51,0.061c1.566,0.018,2.979-0.173,4.549-0.16
						c1.203,0.006,2.141,0.235,3.383,0.212c1.311-0.022,2.547-0.161,3.891-0.117c0.979,0.031,1.898,0.154,2.93,0.1
						c1.094-0.058,1.277-0.27,1.406-0.413c-0.57-0.138-0.617-0.149-0.527-0.287c-2.363,0.023-2.363,0.023-2.748-0.041
						c-1.557-0.234-1.557-0.234-2.498-0.082c-1.883-0.359-1.883-0.359-2.297-0.302c-0.443-0.305-1.205-0.586-1.27-0.916
						c-1.703-0.015-3.564-0.044-6.02-0.17c-0.111,0.23,0.25,0.288,1.086,0.327c-1.215,0.351-1.215,0.351-1.797,0.311
						c0.502-0.477-0.309-0.661-2.082-0.85c0.129-0.201,0.969-0.33,1.061-0.534c-1.203-0.138-2.652-0.081-3.813-0.247
						c-0.055-0.011-0.129-0.023-0.184-0.034c-2.676,0.844-3.572,1.132-6.895,0.967c0.393,0.478-0.957,0.945-0.189,1.425
						c-5.445,0.152-5.717-0.1-5.857-0.238c-0.271-0.259-0.438-0.327-1.303-0.345c-0.143,0.172,0.623,0.264,0.676,0.416
						c-0.146,0.052-0.338,0.118-0.484,0.17c-1.225-0.049-1.537-0.123-1.916-0.268c-1.148-0.014-1.148-0.014-3.781,0.339
						c-1.34,0.176-2.836,0-4.207,0.089c-0.314,0.023-0.656,0.092-0.854,0.149c-0.037-0.003-3.775-0.41-4.932,0.092
						c0.297,0.013,0.695,0.023,0.992,0.029C1411.022,25.401,1412.933,25.163,1414.854,25.333z M1452.636,25.284
						c-1.037,0.052-1.668,0.081-2.48,0.049c-0.207-0.011-0.584-0.028-1.043-0.097c-0.049-0.006-0.109-0.013-0.146-0.021
						C1449.134,24.685,1452.202,25.195,1452.636,25.284z M1446.731,24.744c0.275,0.015,0.729,0.031,1.049,0.133
						c0.412,0.129,0.496,0.286,0.76,0.428c-0.436,0.008-0.844,0.061-1.303,0.042c-0.316-0.014-0.389-0.017-0.549-0.105
						C1446.386,25.074,1447.349,24.914,1446.731,24.744z M1444.019,25.053c0.557,0.021,0.871,0.021,1.365,0.005
						c-0.045,0.115-0.109,0.271-0.164,0.385c-1.242-0.206-2.145-0.195-3.701-0.092c-1.029,0.069-1.955,0.105-2.9-0.149
						c-0.061-0.018-0.129-0.04-0.189-0.055c0.297-0.146,0.67-0.33,1.604-0.345C1441.489,24.775,1442.671,24.988,1444.019,25.053z
						 M1438.489,23.903c0.543,0.129,0.813,0.241,1.215,0.505c0.025,0.019,0.047,0.029,0.064,0.043c0.043,0.026,0.092,0.064,0.111,0.089
						c-0.012,0-0.027,0-0.047,0c-1.059-0.057-1.686-0.304-1.846-0.393C1437.812,24.047,1437.761,23.921,1438.489,23.903z
						 M1431.323,25.621l0.76,0.034l-0.076,0.178l-0.748-0.028L1431.323,25.621z"/>
					<path d="M1327.905,16.698c0.07,0.04,0.484,0.239,1.338,0.29c0.158-0.187-0.031-0.271-0.383-0.428
						c-0.129-0.058-0.242-0.115-0.307-0.176C1327.479,16.411,1327.737,16.615,1327.905,16.698z"/>
					<polygon points="1331.347,17.063 1330.485,17.034 1330.435,17.235 1331.288,17.268 "/>
					<path d="M1340.987,18.981c0.145,0.075,0.508,0.13,0.686,0.022c0.107-0.06,0.082-0.157,0.07-0.198
						C1340.681,18.806,1340.956,18.967,1340.987,18.981z"/>
					<path d="M1377.532,20.547c0.053,0.024,0.396,0.157,1.301-0.061c-0.357-0.075-0.627-0.115-0.885-0.127
						C1377.323,20.343,1377.452,20.509,1377.532,20.547z"/>
					<path d="M1375.897,20.469c-0.148-0.011-0.295-0.023-0.451-0.028c-0.955-0.032-1.367,0.08-1.297,0.351
						c0.023,0.002,0.049,0.005,0.072,0.005C1375.47,20.877,1375.972,20.778,1375.897,20.469z"/>
					<path d="M1357.417,21.445c0.053,0.058,0.148,0.115,0.258,0.166c0.68,0.034,0.91-0.026,1.596-0.2
						c0.639-0.161,0.945-0.136,1.322,0.108c0.428-0.092,1-0.138,1.369-0.241c0.365-0.103,0.389-0.181,0.41-0.27
						c-0.174-0.012-0.365-0.023-0.555-0.029c-1.029-0.022-1.484,0.029-1.99,0.23C1358.235,20.966,1357.21,21.176,1357.417,21.445z"/>
					<path d="M1354.085,20.899c-0.092-0.006-0.186-0.017-0.295-0.022c-0.303-0.007-0.445,0.028-0.512,0.126
						c-0.029,0.052-0.029,0.052,0.338,0.16L1354.085,20.899z"/>
					<path d="M1328.554,21.032c0.018,0.002,0.037,0.005,0.051,0.008c0.59,0.13,2.143,0.021,2.135-0.321
						C1329.501,20.728,1328.599,20.733,1328.554,21.032z"/>
					<path d="M1327.507,20.704c-0.516-0.011-0.523,0.012-0.578,0.265c0.012,0.006,0.033,0.006,0.055,0.009
						c1.074,0.083,1.217-0.066,1.006-0.176C1327.868,20.744,1327.71,20.716,1327.507,20.704z"/>
					<path d="M1377.929,23.243c-0.006,0.034,0,0.065,0.063,0.097c0.16,0.087,0.16,0.087,2.314,0.196
						c-0.031-0.155-0.373-0.213-1.461-0.262C1378.536,23.266,1378.229,23.254,1377.929,23.243z"/>
					<path d="M1327.087,25.479c-0.049-0.262-0.426-0.371-1.404-0.41c-0.523-0.017-0.859-0.012-1.844,0.002
						c-0.035,0.061-0.09,0.139,0.117,0.21C1324.226,25.38,1324.226,25.38,1327.087,25.479z"/>
					<path d="M1373.106,27.343c0.078,0.044,0.158,0.084,0.236,0.125c0.818,0.011,0.51-0.193,0.1-0.366
						C1373.077,27.091,1372.698,27.107,1373.106,27.343z"/>
					<polygon points="1325.888,27.062 1325.843,27.245 1327.468,27.301 1326.751,26.999 "/>
					<path d="M1330.759,25.608c0.389,0.006,0.441-0.126,0.459-0.166c-0.408-0.006-0.709-0.038-0.906-0.098
						c-0.355-0.098-0.363-0.236-0.639-0.347c-0.057,0.005-0.129,0.011-0.193,0.016c-0.023,0.003-0.047,0.003-0.064,0.007
						c-0.75,0.063-1.154,0.152-1.08,0.41c0.029,0,0.066,0,0.09,0c1.002,0.006,1.592,0.086,1.898,0.152
						C1330.38,25.598,1330.452,25.608,1330.759,25.608z"/>
					<path d="M1329.938,19.619c1.053-0.052,1.053-0.052,2.322,0.092l1.686-0.141c0.777,0.008,1.502,0.071,2.271,0.1
						c1.307,0.047,2.283-0.264,3.641-0.168c-0.117-0.204-1.197-0.118-1.602-0.245c0.33-0.184,1.27-0.032,1.756-0.141
						c-0.014-0.005-0.023-0.015-0.023-0.022c0-0.003-0.016-0.009-0.027-0.009c-0.068-0.028-0.141-0.028-0.361-0.012
						c-0.518,0.043-0.775,0.012-0.895-0.006c-0.119-0.144-0.016-0.173,0.576-0.149c0.453,0.018,0.836,0.028,0.807-0.081
						c-0.066-0.218-0.605-0.246-0.906-0.263c-0.816-0.013-1.588,0.068-2.402,0.051c-0.795-0.017-1.521-0.095-2.273-0.149
						c-1.402-0.098-2.182-0.144-3.119-0.155c-0.605,0.254-1.064,0.403-1.893,0.621c-0.375-0.006-0.375-0.063-0.346-0.173
						c0.031-0.112,0.051-0.212-0.814-0.166c0.277,0.786,0.277,0.786-1.467,0.821c0.029,0.028,0.078,0.075,0.141,0.1
						C1327.499,19.742,1328.856,19.677,1329.938,19.619z"/>
					<path d="M1364.655,27.521c0.662-0.018,1.26-0.087,1.898-0.127c-0.793-0.031-1.846-0.068-2.637-0.103
						c0.025,0.012,0.057,0.017,0.096,0.028C1364.235,27.384,1364.448,27.452,1364.655,27.521z"/>
					<path d="M942.951,4.753c0.813-0.032,0.858-0.216,0.802-0.388c-0.771,0.022-1.037,0.138-0.873,0.388
						C942.902,4.753,942.925,4.749,942.951,4.753z"/>
					<path d="M941.65,5.428c0.368,0.011,0.557,0.008,0.827-0.012c0.037-0.003,0.063-0.006,0.095-0.009
						c0.933-0.117,0.755-0.367,1.214-0.543c-0.401-0.006-0.918-0.014-1.321-0.023c0.201,0.19,0.017,0.248-0.405,0.328
						c-0.373,0.077-0.525,0.121-0.447,0.256C941.618,5.422,941.635,5.428,941.65,5.428z"/>
					<path d="M938.859,7.938c0.568-0.08,1.304-0.058,1.649-0.046c-0.707-0.201-0.492-0.293,0.252-0.497
						c0.482-0.129,0.517-0.178,0.562-0.262c0.118-0.241-0.355-0.482,0.05-0.724c0.588-0.351,0.646-0.388,0.258-0.775
						c-0.107-0.005-0.213-0.008-0.308-0.008c-0.178,0-0.405,0.008-0.551,0.025c-0.08,0.132,0.411,0.229,0.4,0.359
						c-1.359,0.283-1.875,0.502-2.064,0.864c0.522,0.068,1.229,0.155,1.751,0.218c-0.552,0.181-1.479,0.281-1.965,0.474
						c-0.304,0.127-0.21,0.297-0.16,0.391C938.764,7.949,938.819,7.939,938.859,7.938z"/>
					<path d="M936.832,9.026c0.356,0.082,1.063,0.055,1.201,0.197c1.24-0.179,0.591-0.703,2.55-0.74
						c-0.369-0.115-0.492-0.207-0.529-0.408c-0.063,0-0.12-0.003-0.178-0.003c-2.292-0.021-2.007,0.577-3.193,0.83
						C936.676,8.951,936.676,8.987,936.832,9.026z"/>
					<path d="M938.112,9.941c0.041-0.04,0.029-0.08-0.005-0.121c-0.615-0.005-1.155,0.099-1.792,0.063
						c0.023,0.041,0.058,0.075,0.14,0.104C936.843,10.131,937.928,10.129,938.112,9.941z"/>
					<path d="M938.21,10.714c-0.011-0.061-0.017-0.146-0.023-0.21l-0.494-0.1c-0.459-0.003-0.588,0.146-0.33,0.255
						C937.469,10.705,937.733,10.774,938.21,10.714z"/>
					<path d="M934.701,12.099c0.305,0.118,0.775,0.129,1.022,0.137c0.011-0.008,0.025-0.022,0.025-0.031
						c0.049-0.103-0.06-0.16-0.278-0.246c-0.241-0.104-0.224-0.113-0.165-0.139c0.187-0.08,0.687-0.08,0.865-0.16
						c0.132-0.058,0.025-0.139-0.069-0.199c-0.015,0-0.035-0.002-0.057-0.002C934.569,11.458,934.179,11.903,934.701,12.099z"/>
					<path d="M934.649,12.733c0.196,0.073,0.592,0.111,0.721,0.008c0.078-0.071,0.011-0.17-0.014-0.21
						C934.238,12.561,934.604,12.715,934.649,12.733z"/>
					<path d="M933.811,13.169c0.158,0.055,0.494,0.063,1.017,0.062c0.35-0.004,0.688-0.029,1.039-0.004
						c-0.011-0.049-0.069-0.189-1.008-0.21c-0.601-0.006-0.951,0.041-1.14,0.078C933.73,13.123,933.741,13.146,933.811,13.169z"/>
					<path d="M955.187,13.632c-0.129-0.078-0.308-0.112-0.666-0.121c-0.632-0.005-1.367,0.112-1.034,0.299
						C953.995,13.755,954.672,13.687,955.187,13.632z"/>
					<path d="M934.179,13.391c-0.058-0.003-0.125-0.003-0.179-0.003c-0.821-0.012-1.174,0.08-1.088,0.286
						c0.009,0,0.02,0,0.026,0C934.305,13.721,934.213,13.479,934.179,13.391z"/>
					<path d="M932.989,14.169c0.011,0,0.023,0,0.034,0c1.026,0.034,1.404-0.084,1.215-0.38
						C933.153,13.944,932.932,13.977,932.989,14.169z"/>
					<path d="M953.389,14.496c0.356,0.141,0.97,0.244,1.149,0.408c0.649-0.075,0.557-0.17,0.201-0.351
						c-0.333-0.167-0.425-0.241-0.302-0.346c-0.048-0.002-0.092-0.005-0.14-0.005c-0.442-0.003-0.735,0.083-1.149,0.092
						C953.16,14.341,953.177,14.409,953.389,14.496z"/>
					<path d="M934.747,14.384c-0.072-0.077-0.235-0.105-0.661-0.12c-0.718-0.006-1.37,0.065-1.488,0.089
						c0.049,0.041,0.101,0.083,0.201,0.12C933.259,14.64,934.115,14.49,934.747,14.384z"/>
					<path d="M927.591,21.993c0.962,0.05,1.545-0.215,2.51-0.154c0.503-1.197,2.251-2.363,1.834-3.581
						c0.405-0.052,0.934-0.121,1.339-0.173c-0.368-0.304-0.347-0.358,0.258-0.801c0.668-0.496,0.542-0.655,0.221-1.043
						c0.259-0.028,0.609-0.068,0.873-0.098c-0.375-0.74-0.375-0.74-1.473-0.987c-0.752,0.031-1.352,0.167-2.174,0.155
						c1.473,0.12,1.398,0.502,2.326,0.718c-0.557,0.078-0.864,0.12-1.054,0.327c-0.242,0.275,0.083,0.552-0.041,0.827
						c-0.134,0.299-1.797,0.534-0.723,0.873c-1.338,0.259-1.338,0.259-2.142,0.27c-1.591,1.637-1.979,2.424-1.803,3.665
						C927.56,21.991,927.579,21.991,927.591,21.993z"/>
					<path d="M924.809,21.367c-1.143,0.003-1.663,0.124-1.623,0.371c0.032,0,0.069-0.004,0.095-0.004
						C924.421,21.687,924.702,21.514,924.809,21.367z"/>
					<path d="M938.928,9.833c0.928-0.156,0.546-0.22-0.351-0.328c-0.867-0.109-1.096-0.172-1.024-0.287
						c-0.106,0.04-0.17,0.065-0.575,0.121c-0.595,0.08-0.713,0.126-0.701,0.259c0.061-0.006,0.129-0.013,0.19-0.016
						C938.517,9.419,938.813,9.709,938.928,9.833z"/>
					<path d="M928.558,22.921c0.486,0.195,1.648,0.333,1.844,0.178c0.295-0.229-1.521-0.103-1.774-0.304
						C928.544,22.801,928.298,22.815,928.558,22.921z"/>
					<path d="M934.712,26.358c0,0.035-0.012,0.092,0.138,0.146c0.236,0.092,0.608,0.109,1.711,0.161
						c-0.671-0.075-0.884-0.29-1.746-0.306C934.781,26.358,934.747,26.358,934.712,26.358z"/>
					<path d="M923.243,26.396l-0.296-0.003l0.012,0.003C923.054,26.396,923.146,26.396,923.243,26.396z"/>
					<path d="M922.947,26.394c-0.085,0-0.181-0.001-0.259-0.004c0.029,0.002,0.055,0,0.093,0.004
						c0.046,0,0.095,0,0.152,0.003L922.947,26.394z"/>
					<path d="M953.4,24.998c0.086-0.142,1.057-0.225,0.615-0.391c-0.657-0.032-0.657-0.032-2.372,0.157
						c-2.774-0.54-2.774-0.54-3.612-0.617c0.341-0.276,0.341-0.276,1.579-2.691c0.118,0,0.285,0.016,0.414,0.006
						c0.83-0.04,0.259-0.275-0.977-0.407c3.107-3.352,3.107-3.352,3.475-4.531c-0.235-0.006-0.517-0.013-0.792-0.018l0.822,0.015
						c0.005-0.031,0.019-0.063,0.019-0.095c0.675-0.069,0.675-0.069,1.649-0.447c-0.548-0.179-0.623-0.265-0.658-0.521
						c-0.026-0.235-0.167-0.302-0.543-0.425c-0.083-0.021-0.184-0.044-0.255-0.061c-1.02,0.055-0.207,0.511,0.092,0.586
						c-0.523-0.035-0.689,0.04-0.993,0.2c-0.448,0.23-0.732,0.311-1.534,0.346c0.378,0.166,0.506,0.255,0.581,0.391h0.025l-1.217,1.26
						c-0.341,0.17-1.166,0.089-1.685,0.164c0.284,0.278,0.378,0.37-0.718,0.608c-0.92,0.196-0.937,0.228-0.386,0.448
						c-0.594,0.213-1.749,0.144-2.552,0.262c0.841,0.37,1.074,0.623,1.031,1.085c-0.235,0.025-0.557,0.058-0.792,0.083
						c0,0.026-0.262,2.677-2.9,2.677c0.201,0.506-1.243,0.957-1.005,1.468c-0.046,0.008-0.098,0.028-0.145,0.037
						c-0.792-0.066-0.792-0.066-1.068-0.003c0.896,0.324,0.896,0.324-0.603,1.163c1.953,0.141,1.993,0.778,1.982,0.907l13.981,0.206
						C955.239,25.296,955.239,25.296,953.4,24.998z M945.518,24.483c0.083,0.074,0.368,0.132,0.405,0.206
						c0.011,0.018,0.023,0.058-0.259,0.089c-0.026,0.004-0.051,0.004-0.063,0.007c-0.083-0.078-0.416-0.133-0.442-0.219
						C945.154,24.521,945.389,24.497,945.518,24.483z M948.53,26.172c-1.699-0.098-1.699-0.098-2.158,0.063
						c0.151,0.118,0.35,0.275,0.504,0.4c-0.743,0.054-1.507,0.031-2.262,0.048c-0.098,0-0.213,0.003-0.302,0.006
						c-0.124-0.114-0.134-0.155-0.066-0.321c0.092-0.235,0.061-0.371-0.19-0.652c0.919-0.052,1.063-0.135,1.671-0.497
						c-0.031,0.189,0.891,0.271,1.502,0.322c0.744,0.063,1.333,0.115,1.602,0.247C949.053,25.894,948.62,26.057,948.53,26.172z"/>
					<path d="M928.303,25.014c-0.93,0.044-0.93,0.044-1.103,0.016c-0.017-0.115-0.248-0.218-0.27-0.33
						c-0.012-0.044,0.005-0.05,0.175-0.084c0.687-0.144,1.321,0.046,1.982,0.021c-0.221-0.565-0.213-0.807,0.061-1.367
						c-0.85-0.075-1.729-0.028-2.597-0.037c-0.511,0.224-0.221,0.543-1.528,0.672c-1.327-0.149-0.322-0.864-1.958-0.721
						c0.247-0.268,1.011-0.49,1.172-0.768c0.049-0.089-0.33-0.197-0.571-0.27c-0.27-0.04-0.626-0.092-0.885-0.132
						c-0.66,0.207,0.236,0.391,0.141,0.585c-0.095,0.196-1,0.288-1.177,0.472c-0.023,0.021-0.035,0.046-0.043,0.065
						c-0.092,0.245,0.267,0.486,0.032,0.73c-0.614,0.617-0.614,0.617-0.023,0.933c0.6,0.319,0.623,0.385,0.232,0.595
						c0.468,0.021,0.864,0.101,1.375,0.078c0.109-0.003,0.158-0.031,0.321-0.146c1.157,0.014,0.638,0.456,1.864,0.416
						c-0.152,0.092-0.21,0.126-1.02,0.146c-1.608,0.037-1.125,0.221-0.936,0.272c0.31,0.071,0.64-0.028,0.948,0.006
						c0.212,0.026,0.631,0.213-0.288,0.247c0.864,0.012,2.014,0.028,2.877,0.037c-0.048-0.066-0.097-0.135-0.143-0.2
						C928.084,26.037,928.084,26.037,928.303,25.014z"/>
					<path d="M884.599,12.738c0.448,0.189,0.636,0.293,0.512,0.435c0.034-0.01,0.078-0.016,0.106-0.021
						c0.99-0.213,0.677-0.574-0.661-0.771C884.01,12.46,884.151,12.549,884.599,12.738z"/>
					<path d="M906.472,16.201c0.342,0.115,0.854,0.139,1.103,0.146c0.076-0.146-0.024-0.209-0.307-0.341
						c-0.258-0.127-0.353-0.207-0.249-0.368C906.142,15.733,905.971,16.034,906.472,16.201z"/>
					<path d="M890.464,16.207c-0.391,0-0.501,0.149-0.207,0.256c0.317,0.115,0.695,0.058,0.82,0.037
						c-0.006-0.058-0.03-0.132-0.043-0.191l-0.5-0.102C890.51,16.204,890.487,16.207,890.464,16.207z"/>
					<path d="M880.756,18.137c0.211,0.072,0.571,0.109,0.659,0.019c0.072-0.07-0.03-0.162-0.076-0.214
						C880.309,17.965,880.708,18.119,880.756,18.137z"/>
					<path d="M879.664,18.594c0.073-0.066-0.289-0.155-0.405-0.181c-0.396,0.077-0.525,0.138-0.378,0.189
						C879.058,18.663,879.589,18.666,879.664,18.594z"/>
					<path d="M867.695,18.694c0.206,0.061,0.577,0.068,0.777,0.074c-0.578-0.144-0.437-0.172,0.082-0.218
						c0.614-0.052,0.873-0.106,0.684-0.265c-0.07-0.008-0.148-0.015-0.229-0.015C868.014,18.271,867.246,18.57,867.695,18.694z"/>
					<polygon points="879.43,19.094 880.326,19.102 880.25,18.815 878.946,18.803 "/>
					<path d="M861.058,20.136c0.024-0.012,0.047-0.028,0.076-0.04c0.078-0.028,0.161-0.058,0.271-0.08
						c0.573-0.107,1.587,0.068,1.468,0.539c2.729-0.287,2.895-0.304,3.496,0.04c0.63-0.034,1.302-0.025,1.904-0.089
						c0.448-0.043,0.471-0.065,0.619-0.163c-1.12-0.463-1.12-0.463-1.845-0.518c0.104-0.057,0.247-0.14,0.353-0.2
						c0.271,0.031,0.308,0.04,0.584,0.137c0.34,0.128,0.702,0.13,1.255,0.092c0.03-0.103-0.011-0.151-0.507-0.212
						c-0.565-0.074-0.731-0.111-0.512-0.292c-0.195,0.063-0.408,0.082-1.084,0.027c-0.737-0.057-0.932-0.005-1.061,0.139
						c-0.283-0.063-0.661-0.144-0.943-0.204c0.019-0.095,0.019-0.095,1.108-0.084c0.783,0.013,0.896-0.022,0.602-0.194
						c-0.172-0.006-0.666-0.006-1.185,0.028c-0.142,0.012-0.284,0.029-0.449,0.012c-0.201-0.012-0.201-0.104-0.211-0.184
						c0-0.023,0.006-0.049,0.006-0.069C861.647,18.946,859.878,19.538,861.058,20.136z M867.175,20.319
						c-0.377-0.006-1.273-0.023-1.826-0.241c-0.343-0.132-0.473-0.304-0.531-0.388C865.742,19.677,867.27,19.745,867.175,20.319z"/>
					<path d="M880.22,19.492c0.194,0.069,0.583,0.106,0.69,0.018c0.07-0.063-0.013-0.155-0.061-0.207
						C879.778,19.32,880.178,19.476,880.22,19.492z"/>
					<path d="M901.173,20.756c-1.286,0-1.381-0.025-1.492-0.057c-0.076-0.029-0.041-0.093,0.006-0.165
						c0.034-0.065,0.07-0.129,0.083-0.194c-0.372,0.014-0.66,0.04-0.92,0.135c-0.366,0.132-0.388,0.287-0.647,0.429
						c0.035,0.008,0.083,0.019,0.129,0.024C899.021,21.043,901.303,21.112,901.173,20.756z"/>
					<path d="M865.524,20.621c-0.304-0.061-0.617-0.066-0.782-0.069c-0.194,0.003-0.384,0.006-0.56,0.018
						c0.005,0.057,0.022,0.117,0.247,0.209c0.254,0.099,0.613,0.185,0.778,0.29C866.35,21.037,866.139,20.738,865.524,20.621z"/>
					<polygon points="861.152,22.098 861.094,21.904 860.281,21.898 860.327,22.088 "/>
					<path d="M894.325,22.792c0.029,0.006,0.059,0.009,0.081,0.014c0.838,0.179,1.846,0.34,3.491,0.334
						c-0.543-0.127-1.864-0.365-2.93-0.385C894.707,22.755,894.549,22.761,894.325,22.792z"/>
					<path d="M898.338,23.237c0.017,0,0.042,0,0.059,0c0.566-0.018,0.807,0.011,1.267,0.074
						c0.348,0.049,0.501,0.069,0.884,0.049c0.237-0.244-0.642-0.376-1.332-0.388C898.727,22.973,898.185,23.016,898.338,23.237z"/>
					<path d="M900.413,24.334c-0.019-0.057-0.034-0.132-0.053-0.189l-0.507-0.115c-0.473,0-0.555,0.161-0.254,0.268
						C899.747,24.352,900.011,24.397,900.413,24.334z"/>
					<path d="M862.065,26.231c0.011-0.002,1.463-0.277,1.94,0.463c0.849,0.052,1.331,0.012,1.526-0.12
						c0.406-0.285-0.165-0.558-0.17-0.84c-0.985,0.202-1.286,0.207-1.781,0.036c-0.637-0.22-0.896-0.23-1.746-0.265
						c0.237-0.222,0.214-0.285-0.135-0.417c-0.371-0.141-0.43-0.204-0.528-0.361c-0.03-0.003-0.073-0.003-0.107-0.006
						c-0.726-0.015-0.849,0.661-0.006,1.077c-0.826,0.152-0.849,0.27-0.507,0.66c0.252,0.287,0.188,0.379,0.106,0.493
						c0.106-0.005,0.26-0.011,0.366-0.017C862.485,26.826,861.229,26.431,862.065,26.231z M862.849,25.91l0.072,0.19l-0.884-0.01
						l-0.064-0.189L862.849,25.91z"/>
					<path d="M880.792,25.83c-0.532-0.031-0.885-0.052-0.838-0.296c0.849,0.092,1.853,0.026,2.688,0.132
						c0.024,0.104-0.024,0.13-0.143,0.198c3.161,0.043,7.369,0.093,10.539,0.135c-1.851-1.079-2.229-1.303-1.838-1.973
						c-1.532-0.215-1.51-0.548-1.287-0.688c1.51-0.021,2.659-0.262,4.062-0.349c-0.053-0.281-1.315-0.444-1.355-0.729
						c1.285-0.092,1.285-0.092,1.526-0.149c0.743,0.345,1.498,0.469,3.212,0.528c0.878-0.429,1.038-0.505,1.604-0.531
						c0.253,0.049,0.253,0.049,0.406,0.167c0.826-0.273-0.188-0.546-0.012-0.819c0.083-0.011,0.19-0.031,0.272-0.045
						c-0.236-0.081-0.236-0.081-1.304-0.018c-0.016-0.063-0.04-0.144-0.051-0.207c-1.781-0.327-2.676-0.844-4.656-1.134
						c2.688-0.315-0.042-0.975,0.542-1.447c-1.729-0.153-1.839-0.225-2.913-0.911c-0.895,0.092-1.826,0.092-2.386,0
						c-0.743-0.12-0.03-0.293-0.283-0.43c-0.719-0.107-0.719-0.107-1.939-1.017c0.007-0.133,0.142-0.432,1.22-0.377
						c-0.395-0.034-0.932-0.083-1.327-0.117c0.236-0.127,0.308-0.158,0.85-0.192c-0.845-0.01-1.969-0.025-2.818-0.038
						c0.159,0.563-0.761,1.117-0.319,1.681c0.019,0.022,0.061,0.051,0.095,0.071c0.271,0.144,1.038,0.187,1.308,0.327
						c0.224,0.126-0.218,0.256,0.024,0.38c0.046,0.025,0.107,0.058,0.166,0.083c0.154,0.061,0.56,0.105,0.831,0.141
						c-0.489,0.195-1.514,0.603-0.607,0.93c0.118,0.041,0.407,0.092,0.388,0.142c-0.057,0.169-0.281,0.388-0.328,0.555
						c-0.025,0.071-0.012,0.168-0.012,0.241c0.017,0.419,1.214,0.77,1.319,1.177c0.129,0.465-0.701,0.91-0.612,1.378
						c0.169,0.861,0.1,0.977-0.343,1.528c0.767,0.121,1.004,0.252,1.063,0.591c-0.189,0.058-0.449,0.136-0.645,0.195
						c-1.136,0.018-2.067-0.198-3.223-0.146c-1.197,0.05-1.284,0.58-2.705,0.435c-0.046-0.035-0.065-0.093-0.036-0.133
						c-0.053-0.011-0.124-0.034-0.17-0.048c-0.318-0.01-0.638-0.01-0.955-0.004c0.304-0.104,1.048-0.694-0.62-0.684
						c0.418,0.494,0.359,0.861-0.254,1.459l2.004,0.022C880.892,25.842,880.744,25.83,880.792,25.83z M897.588,21.968
						c-0.435-0.009-0.942-0.034-1.284-0.179c-0.024-0.005-0.048-0.017-0.07-0.028C897.059,21.77,897.708,21.775,897.588,21.968z
						 M888.76,18.04c0.408,0.005,0.955,0.014,1.368,0.02c-0.06,0.149-0.136,0.192-0.497,0.198c-0.116-0.006-0.235-0.015-0.354-0.018
						c0.685,0.385,1.315,0.505,3.208,0.833c-0.803,0.77,0.647,1.571-0.708,2.326c-1.156,0.012-1.733-0.08-2.014-0.155
						c-0.108-0.028-0.427-0.118-0.526-0.339c-0.1-0.235,0.135-0.471,0.04-0.706c-0.14-0.362-0.364-0.729-0.473-1.098
						C888.642,18.599,888.659,18.36,888.76,18.04z"/>
					<path d="M855.428,24.359c-0.547-0.353,0.808-0.829-1.231-1.082c0.589-0.945-0.447-1.89,0.006-2.826
						c-0.389-0.009-0.909-0.011-1.297-0.017c0.017-0.244,1.538-0.232,1.561-0.475c-0.517,0.032-0.522,0.029-0.731,0
						c0.307-0.261,1.304-0.474,0.991-0.771c-0.313-0.009-0.731-0.018-1.037-0.029c-0.013-0.009-0.03-0.023-0.035-0.034
						c0.494-0.098,0.494-0.139,0.507-0.247c-0.88,0.053-1.108-0.167-1.746-0.219c-0.165-0.003-0.33-0.003-0.495,0
						c0.107,0.402,0.697,0.787,0.814,1.184c0.146,0.525-2.263,1.017-0.418,1.564c-0.896,0.248-0.727,0.586-1.427,0.851
						c0.507,0.439,0.224,0.898,0.712,1.333c0.229,0.2,1.228,0.296,1.362,0.508c0.089,0.138,0.099,0.271-0.549,0.557
						c-0.694,0.308-0.907,0.399-0.283,0.845l3.208,0.037C853.89,24.687,854.592,24.489,855.428,24.359z"/>
					<path d="M908.099,25.503c-0.042-0.031-0.112-0.078-0.331-0.099c-0.288-0.024-1.256,0.055-0.913,0.271
						c-0.579-0.126-0.803-0.175-1.285-0.598c-0.566-0.485-0.672-0.54-1.285-0.783c0.376-0.026,0.883-0.058,1.272-0.08
						c-0.012-0.626-1.101-0.787-2.015-0.816c-0.601-0.005-0.813,0.066-1.085,0.158c-0.294,0.101-0.471,0.161-1.461,0.146
						c-1.12-0.017-1.998-0.229-3.17-0.195c-0.695,0.017-0.725,0.023-0.943,0.066c0.342,0.191,1.296,0.313,1.291,0.542
						c0.266-0.126,0.383-0.181,0.801-0.229c0.677-0.087,1.469-0.058,2.164-0.127c0.095,0.127,0.095,0.161-0.035,0.178
						c-0.332,0.052-0.46-0.08-0.779-0.055c-0.07,0.038-0.082,0.043,0,0.153c0.602,0.074,0.85,0.286,1.774,0.226
						c-0.019,0.275-0.019,0.275,1.515,0.791c-1.752-0.044-2.688-0.145-4.001-0.432c-1.244,0.522-1.244,0.522-0.219,0.672
						c-0.224,0.006-0.224,0.006-1.805-0.117c-0.169-0.136-0.199-0.159,0.389-0.19c0.596-0.031,0.566-0.054,0.391-0.191
						c-0.289-0.216-1.569-0.219-1.851-0.438c-0.048-0.034-0.083-0.079-0.123-0.115c-0.043-0.039,0.051-0.103,0.064-0.148
						c-0.945,0.213-0.85,0.348,0.006,0.724c0.807,0.359,0.707,0.477-0.497,0.62c0.125,0.083,0.289,0.195,0.632,0.284
						c0.625,0.17,1.526,0.213,2.109,0.238c0.089,0.034,0.167,0.074,0.212,0.112c2.983,0.037,6.968,0.095,9.95,0.129
						C906.525,25.789,907.704,25.574,908.099,25.503z"/>
					<path d="M887.918,15.57c0.217,0.011,0.417,0.031,0.642,0.04c0.129,0.002,0.129-0.006,0.129-0.015
						c0.494,0.012,0.5,0.04,0.53,0.233c0.036,0.157,0.077,0.234,0.86,0.166c-0.205-0.109-0.34-0.221-0.329-0.402
						c0.124-0.382,0.9-0.738,0.884-1.126c-0.013-0.212-0.65-0.361-0.955-0.437c-0.731,0.007-1.004,0.012-1.097,0.066
						c-0.059,0.038,0,0.09,0.047,0.124c0.123,0.098,0.212,0.194,0.252,0.293c-1.342-0.089-1.303-0.592-3.129-0.534
						c0.146-0.069,0.465-0.099,0.712-0.144c0.011-0.023-0.046-0.058-0.099-0.081c-0.07-0.021-0.184-0.052-0.26-0.074
						c-1.71,0.063-1.803,0.27-1.373,0.74c0.393,0.437,0.464,0.646-0.514,0.816c0.183,0.103,0.266,0.169,0.348,0.286l2.813,0.038
						c0.165-0.003,0.329-0.003,0.488,0.009C887.888,15.57,887.905,15.57,887.918,15.57z M889.42,14.806l0.041,0.21l-0.89-0.012
						l-0.042-0.209L889.42,14.806z"/>
					<path d="M1156.446,9.33c0.133,0.089,0.156,0.268,0.164,0.27c-0.014,0.071-0.283,0.081-0.553,0.089
						c-0.512,0.012-0.658,0.046-0.461,0.184c0,0,0.023,0,0.035,0.003c1.91,0.115,2.758-0.594,1.861-0.909
						c-0.387-0.133-0.916-0.156-1.203-0.167c-0.389-0.009-0.787-0.017-0.857,0.104c-0.014,0.011-0.02,0.025-0.023,0.034
						c0.018,0.061,0.234,0.126,0.471,0.189C1156.079,9.184,1156.327,9.255,1156.446,9.33z"/>
					<path d="M1157.364,9.922c-0.35-0.007-0.471,0.014-0.701,0.082c-0.213,0.064-0.404,0.122-1.092,0.058
						c-0.01,0.092-0.006,0.144,0.104,0.219c0.012,0.006,0.027,0.015,0.037,0.02c0.121,0.05,0.229,0.072,0.559,0.099
						c0.492,0.037,0.666,0.071,0.543,0.284C1158.237,10.7,1157.866,10.085,1157.364,9.922z"/>
					<path d="M1144.187,11.429c-0.17-0.052-0.377-0.103-0.637-0.115c-0.367-0.005-0.473,0.089-0.326,0.145
						C1143.304,11.492,1143.55,11.552,1144.187,11.429z"/>
					<polygon points="1143.22,12.477 1144.517,12.417 1144.528,12.228 1143.251,12.102 "/>
					<path d="M1204.478,14.135c0.006-0.056,0.014-0.13,0.027-0.187l-0.461-0.11c-0.02,0-0.043-0.002-0.068-0.002
						c-0.377-0.003-0.539,0.144-0.281,0.252C1203.812,14.14,1204.05,14.191,1204.478,14.135z"/>
					<path d="M1177.358,13.674l0.438-0.286c-0.084-0.003-0.158-0.006-0.238-0.012c-0.73-0.012-0.602,0.195-0.602,0.195
						C1177.017,13.611,1177.233,13.646,1177.358,13.674z"/>
					<path d="M1203.792,15.455c0.344,0.123,0.977,0.146,1.314,0.16c0.381-0.258,0.078-0.591-0.635-1.384
						c-0.166-0.018-0.342-0.031-0.52-0.04c-0.068,0.003-0.166,0.006-0.236,0.006c-0.139,0.046-0.15,0.058,0.07,0.215
						c0.207,0.146,0.215,0.152,0.061,0.343c-0.117,0.143-0.27,0.286-0.295,0.43c0,0.012,0,0.029,0,0.038
						C1203.56,15.368,1203.739,15.432,1203.792,15.455z"/>
					<path d="M1136.325,12.768c0.123,0.052,0.369,0.103,0.799,0.046c0-0.058,0.008-0.136,0.012-0.19l-0.402-0.103
						c-0.021-0.006-0.047-0.006-0.078-0.006C1136.306,12.515,1136.005,12.636,1136.325,12.768z"/>
					<path d="M1137.054,14.071c0.037-0.003,0.082-0.006,0.105-0.01c1.109-0.095,1.227-0.163,0.805-0.456
						c-0.117-0.011-0.25-0.021-0.385-0.026C1136.534,13.568,1137.231,13.91,1137.054,14.071z"/>
					<path d="M1181.743,15.156c0.178,0.068,0.529,0.115,0.646,0.023c0.078-0.058,0.021-0.149-0.008-0.201
						C1181.343,14.979,1181.71,15.133,1181.743,15.156z"/>
					<path d="M1148.37,14.663c-0.043-0.044-0.178-0.115-0.59-0.133c-0.111-0.003-0.223,0-0.33,0.008
						c-0.004,0.087-0.016,0.199-0.016,0.285c0.016,0.003,0.033,0.003,0.051,0.006C1148.183,14.929,1148.468,14.761,1148.37,14.663z"/>
					<path d="M1172.399,16.839c0.799-0.022,0.873-0.195,0.844-0.367c-0.752,0-1.039,0.114-0.912,0.367
						C1172.356,16.839,1172.382,16.839,1172.399,16.839z"/>
					<path d="M1205.712,19.4c1.92,0.006,1.803-0.265,1.611-0.307c-0.24-0.055-0.639-0.037-0.861-0.098
						c-0.141-0.047-0.033-0.106,0.039-0.146c-0.119-0.013-0.24-0.018-0.357-0.023c-0.625-0.011-0.617,0.115-0.539,0.333
						c0.049,0.133,0.033,0.184-0.039,0.241C1205.614,19.4,1205.673,19.4,1205.712,19.4z"/>
					<path d="M1203.327,13.598c0.619-0.17-0.176-0.738-1.23-0.885c0.357,0.304,0.736,0.606,1.166,0.901
						C1203.28,13.611,1203.31,13.603,1203.327,13.598z"/>
					<path d="M1127.942,13.561c0.154-0.087,0.346-0.201,0.49-0.288l-0.881-0.115c-0.305,0.006-0.469,0.023-0.27,0.115
						C1127.493,13.367,1127.979,13.434,1127.942,13.561z"/>
					<path d="M1154.786,31.002c-0.004,0.011,0,0.023-0.004,0.037c0.408,0.012,0.799,0.021,1.215,0.031
						c-0.166-0.045-0.313-0.086-0.426-0.108C1155.319,30.962,1154.972,30.971,1154.786,31.002z"/>
					<path d="M1056.317,28.601c0.047-0.057,0.098-0.132,0.143-0.189c0.279-0.008,0.65-0.017,0.936-0.025
						c0.041-0.058,0.105-0.132,0.146-0.189c-0.248-0.008-0.582-0.021-0.836-0.031c2.18-0.646,0.236-1.391,0.979-2.074l-0.531-0.396
						c1.289-0.425,1.545-0.951,2.549-1.401c0.889,0,1.658,0.104,2.502,0.151c-0.039-0.071-0.076-0.163-0.107-0.235
						c-0.26-0.037-0.592-0.085-0.842-0.126c-0.189,0.037-0.434,0.095-0.621,0.136c-0.307-0.006-0.723-0.013-1.031-0.016
						c0.055-0.065,0.133-0.149,0.18-0.212c-0.18-0.043-0.418-0.101-0.602-0.141c-0.271,0.009-0.629,0.02-0.904,0.028
						c0.303-0.126,0.928-0.27,1.488-0.339c0.43-0.597-0.203-1.194-0.102-1.792c0.225-0.046,0.531-0.104,0.756-0.148
						c0.025,0.005,3.527,1.275,4.328,1.769c-0.238,0.109-0.607,0.246-0.934,0.345c0.201,0.108,0.689,0.241,1.143,0.299
						c0,0.003-0.318,1.076-1.836,2.599c1.143,0.359,0.826,0.469-0.508,0.915c1.074,0.309,1.561,0.449,1.521,1.285
						c20.357,0.433,47.504,1.014,67.863,1.449c0.139-0.049,0.318-0.115,0.459-0.16c0.539,0.045,1.197,0.151,1.539,0.258l95.26,2.521
						c-0.004-0.012-1.855-1.872-2.813-2.459c0.244-0.017,0.57-0.04,0.811-0.051c-0.209-0.304,0.053-0.603-0.078-0.908
						c-0.342-0.028-0.801-0.068-1.145-0.097l0.441,0.487c-0.27,0.067-0.625,0.153-0.891,0.219c0.049,0.058,0.109,0.132,0.156,0.189
						c-0.377,0.106-0.873,0.249-1.244,0.356c0.105,0.12,0.045,0.293-0.184,0.401c-0.766-0.092-1.189-0.148-1.615-0.511
						c0.191-0.049,0.443-0.108,0.633-0.155c0.24,0.023,0.561,0.047,0.795,0.063c0.072-0.132,0.059-0.308,0.012-0.438
						c0.4-0.078,0.801-0.223,1-0.337c-0.447-0.087-1.105-0.192-1.619-0.258c-1.867-2.659-1.867-2.659-2.551-2.792
						c-0.307,0.021-0.723,0.047-1.037,0.063c0.141,0.133,0.258,0.313,0.334,0.447c-0.316-0.057-0.746-0.134-1.066-0.188
						c0.176-0.592-0.803-1.189,0.129-1.775c0.082-0.006,0.168-0.011,0.813-0.046c0.084-0.055,0.191-0.126,0.271-0.178
						c-2.465-0.367-1.377-1.166-3.67-1.551c0.352-0.212,0.352-0.212-0.52-0.977c-0.383-0.011-0.789-0.022-1.197-0.034l1.205,0.034
						c-0.025-0.098,0.188-0.181,0.221-0.275c0.037-0.146-0.834-0.21-1.211-0.235c-1.004-0.074-1.074-0.092-1.355-0.213
						c-0.117,0.009-0.117,0.009-0.109,0.146c-0.068,0.018-0.215,0.026-0.311,0.032c-2.229-0.435-1.209-1.074-1.998-1.604
						c-2.141,0.152-2.141,0.152-2.57,0.225c-0.287-0.046-0.33-0.058-0.447-0.195c-0.102-0.12-0.262-0.207-1.189-0.146
						c0.164-0.313-0.074-0.434-1.002-0.52c-0.361-0.018-0.734-0.026-1.096-0.023c0.361,0.256,0.059,0.526,0.33,0.788
						c-0.438,0.108-0.969,0.24-0.996,0.568c-0.008,0.391,0.605,0.76,0.896,1.143h0.016c0.191,0.597-0.141,0.678-2.275,0.896
						c-0.195-0.095-0.195-0.095-1.27-0.996c-0.83,0.015-1.938,0.031-2.775,0.043c-0.176,0.049-0.412,0.112-0.59,0.157
						c-0.348-0.095-0.791-0.226-1.111-0.324c-3.502-0.092-8.166-0.218-11.658-0.307c-0.055,0.129-0.195,0.301-0.34,0.427
						c1.053,0.277,1.252,0.645,2.012,0.954c-4.492-0.7-4.828-0.801-6.535-1.502c-0.254-0.014-0.59-0.037-0.844-0.049
						c-0.605-0.017-1.408-0.037-2.018-0.054c4.568,0.904,5.973,1.26,7.234,2.027c-5.092-0.337-7.252-1.451-11.059-2.132
						c-0.342-0.008-0.719-0.021-1.063-0.028c0.338,0.008,0.709,0.021,1.039,0.026c-8.215-1.321-8.215-1.321-8.604-1.362
						c-4.617-0.487-9.727-0.637-14.43-1.062c5.447-0.497,6.424-0.106,6.896,0.081c8.475-0.179,16.59,1.486,16.668,1.501
						c0.463,0.361,0.463,0.361,3.336,0.948c0.559,0,1.301,0,1.855,0c-0.117-0.055-0.32-0.112-0.525-0.152
						c0.178-0.242,0.285-0.271,0.898-0.351c1.805,0.33,3.021,0.493,5.232,0.706c3.572,0.096,8.348,0.227,11.92,0.327
						c-4.494-1.85-4.494-1.85-6.389-2.096c0.135-0.5-2.844-0.775-3.561-0.775c-1.77-0.015-1.77-0.015-2.746-1.321l-0.805-0.022
						c0.029-0.448,0.029-0.448-1.369-0.862c0.049-0.04,0.121-0.097,0.166-0.14c-1.701,0.157-2.051,0.467-0.947,0.835
						c-1.729-0.091-1.729-0.091-3.498-0.96c-2.855-0.005-2.555,0.475-1.982,0.696c0.135-0.018,0.313-0.041,0.447-0.058
						c0.117,0.017,0.277,0.037,0.398,0.052c0.408,0.401-0.238,0.801-0.158,1.206c-0.766-0.081-1.785-0.184-2.549-0.259
						c0.154-0.385-0.541-0.775,0.014-1.16c-1.648-0.071-1.648-0.071-2.309,0.807c-1.541-0.017-1.867-0.187-2.383-0.536
						c-0.707-0.047-0.707-0.047-2.971-1.149c-0.57,0.189-1,0.196-2.566,0.029c-0.508,1.092-0.508,1.092-0.695,1.146
						c-0.793-0.095-0.367-0.417-1.521-0.437c-1.277-1.651-1.369-3.334-2.609-4.984c-0.15-0.19-0.369-0.233-1.346-0.268
						c0.467-0.136,0.572-0.178,0.535-0.568c-0.891-0.069-1.721-0.167-2.568-0.259c-1.105,0.49-1.105,0.49-1.43,0.523
						c-0.551-0.34-0.387-0.391,0.131-0.558c-0.105-0.023-0.254-0.052-0.357-0.071c-0.012-0.004-0.031-0.004-0.049-0.004
						c-0.891,0.156-0.947,0.408-1.418,0.612c0.334,0.06,0.334,0.06,1.732,0.537c-1.08,0.499-1.08,0.499-1.83,0.534
						c0.121,0.071,0.637,0.536-0.197,2.911c0.369,0.178,0.867,0.431,0.883,0.626c0,0.012-0.307,2.017-0.307,2.045
						c-0.029,0.101-0.207,0.23-0.318,0.327c-2.521-0.195-3.102-0.396-3.809-1.347c-0.99-0.515-0.313-1.08-1-1.6
						c-0.461-0.344-1.934-0.555-2.336-0.907c-0.15-0.133-0.15-0.238-0.021-0.479c0.01-0.015,0.719-1.517-2.336-1.307
						c0.195,0.135,0.238,0.16,1.107,0.382l0.039,0.006c-1.141,0.382-1.141,0.382-0.732,1.014c0.363,0.563,0.33,0.694-0.176,2.274
						c-0.238,0.74,0.959,1.511-0.738,2.229c-0.891,0.375-2.111-0.377-3.33-0.506c0.955-0.77-1.414-1.548,0.07-2.32
						c-0.896-0.485,0.578-1.143-2.104-1.499c-0.039,0.195-0.045,0.224-0.033,0.58c-0.123-0.063-0.275-0.149-0.398-0.213
						c-1.391,0.367-1.521,0.75-0.459,1.355c-0.506,0.219-0.506,0.219-0.807,2.205c-0.109,0.707-1.871,1.287-3.518,0.92
						c0.092-0.155,0.539-0.284,0.633-0.44c-0.117-0.02-0.281-0.048-0.398-0.071c-0.246,0.012-0.576,0.031-0.824,0.047
						c-0.195,0.126-0.135,0.275-0.502,0.391c-1.689-0.19-0.48-0.707-2.039-0.911c0.605-0.195,0.713-0.451,1.441-0.629
						c0.232,0.003,0.523,0.006,0.738,0.006c-1.574-0.853-2.174-1.367-2.93-2.505c-1.803,0.118-2.088,0.115-4.775,0.087
						c0.725,0.46,0.725,0.46,1.238,0.521c0.105-0.023,0.242-0.055,0.344-0.078c0.047,0.028,0.107,0.065,0.152,0.097
						c-0.428,0.173-0.715,0.162-1.338,0.147c0.117,0.29-1.242,0.546-0.428,0.853c-0.457,0.089-0.457,0.089-2.174,0.155
						c0.424,0.545-0.08,1.105,0.393,1.653c-0.119-0.057-0.355-0.126-0.568-0.166c-0.783,0.145-0.813,0.299-0.525,0.718
						c-0.539-0.011-1.086-0.022-1.631-0.039c-0.49-0.153-0.387-0.526,0.342-0.639c0.08,0.023,0.199,0.052,0.285,0.075
						c0.141-0.028,0.324-0.069,0.459-0.099c-3.551-0.775,1.215-1.923-2.357-2.698c-0.201,0.005-0.475,0.008-0.676,0.011
						c-0.068,0.491-0.068,0.491,0.412,0.601c-2.898,0.669-0.416,1.881-4.764,2.398c-1.104-0.362-1.104-0.362-0.785-1.692
						c-1.439-0.313-1.439-0.313-2.285-0.313c0.785-0.241,0.785-0.241,0.404-0.477c-0.777,0.012-2.598,0.031-2.105,0.925
						c2.381,0.878-0.813,1.729-0.27,2.596l11.07,0.261c-3.432-0.071-7.75-0.16-11.053-0.231c0.086,0.057,0.205,0.126,0.297,0.181
						c-1.121,0.416-0.723,0.925-1.641,1.35c0.111,0.057,0.252,0.131,0.361,0.186c-0.215,0.035-0.508,0.081-0.721,0.115
						c0.432,0.066,0.941,0.173,1.248,0.265c-0.166,0.058-0.398,0.135-0.57,0.194c-0.453-0.048-1.16-0.073-1.656-0.054
						c0.258,0.479-1.355,0.842-1.543,1.292c-0.313-0.083-0.896-0.175-1.381-0.204c-0.717-1.134-0.879-1.797-1.037-3.491v-0.015
						c-0.631-0.003-1.473-0.003-2.104-0.009c-0.455,0.371-1.764,0.667-1.811,1.074c-0.525,0.052-1.27,0.097-1.826,0.12
						c-1.039,0.411-0.871,0.894-1.486,1.327c-0.313,0.006-0.719,0.017-1.025,0.022c-2.063-0.394-2.559-0.488-4.615-0.588
						c1.549-2.04,1.551-2.042,2.053-2.191h0.041l-4.322-3.515c0,0,0.029-0.124,0.299-0.379c0.121-0.018,0.281-0.034,0.404-0.052
						c-0.215-0.132-0.215-0.132-1.309-0.425c0.414-0.587,0.408-0.718-0.488-1.08c0.971-0.371,1.24-0.709,1.373-1.723
						c-1.264-0.319-0.201-0.825-1.77-1.117c0.695-1.097-0.732-2.168-0.813-3.253c-0.637-0.064-0.637-0.064-1.678-1.029
						c-1.154,0.146-1.154,0.146-2.207,0.047c0.141,0.166,0.141,0.166-0.92,0.677c0.107,0.021,0.254,0.047,0.359,0.064
						c0.129-0.007,0.309-0.013,0.441-0.018c0.029-0.037,0.066-0.087,0.096-0.121c0.148,0.043,3.494,1.027,0.371,1.373
						c0.355,0.293,0.424,0.355,0.814,0.885c0.494,0.671,0.281,1.354,0.469,2.032c0.201,0.692-1.813,1.284-1.744,1.971
						c-1.621-0.293-2.771-0.689-4.396-0.982c-0.27-0.589-1.854-1.071-2.604-1.623c-0.318,0.089-0.471,0.207-0.896,0.279
						c-2.109-0.288-2.369-0.547-3.432-1.646c-1.51-0.521,1.025-1.255-1.762-1.709c0.949-0.087,1.332-0.391,2.621-0.339
						c-0.713-0.241-1.258-0.511-2.107-0.732c2.273-0.302,0.4-0.842,0.861-1.255c-0.896-0.063-0.896-0.063-1.758-0.934
						c-1.416-0.092-1.131-0.474-2.111-0.637c0.512-1.008-2.547-1.8-3.254-2.734c0.092-0.025,0.211-0.058,0.309-0.083
						c0.135,0,0.318,0.002,0.465,0.006c-0.699-0.178-1.98-0.167-2.48-0.402c-0.035-0.052-0.084-0.117-0.121-0.166
						c-0.928,0.976-0.928,0.976-0.553,1.077c-0.381-0.038-0.381-0.038-3.537,0.034c0.443,1.777,0.443,1.777,0.805,2.085
						c1.789-0.445,1.789-0.445,1.824-0.649c-0.412,0.021-0.977,0.043-1.387,0.065c0.016-0.367,0.016-0.367,0.113-0.493
						c2.453,0.144,2.471,0.305,2.549,1.545c3.488,0.385,3.488,0.385,3.869,1.854c-0.264,0.081-0.604,0.188-0.863,0.268
						c0.717,0.431,0.717,0.431-0.047,0.508c-1.381-0.275-0.738-0.683-1.285-1.013c-0.225,0.024-0.555,0.051-0.756,0.088
						c-0.801,0.144-1.66,0.667-0.234,0.748c0.984,0.564,0.984,0.564,1.848,0.551c-0.873,0.551,0.891,0.979,1.301,1.47
						c-0.104,0.028-0.232,0.072-0.332,0.104c-0.17,0.003-0.398,0.009-0.578,0.012c1.072,0.241,1.586,0.391,2.207,0.637
						c-1.475,0.282-1.475,0.282-1.316,0.676c-0.771-0.066-0.807-0.33-1.785-0.346c0,0.256,0,0.518,0,0.775
						c-0.613-0.092-0.613-0.092-1.436-0.123c-0.18-0.063-0.959-0.499,1.023-0.471c-1.068-0.25-1.051-0.444-0.414-1.089
						c-1.627,0.228-2.182-0.369-3.514-0.462c0.006-0.04,0.006-0.098,0-0.144c0.41-0.06,0.885-0.08,1.32-0.126
						c-0.941-0.229-0.482-0.572-1.309-0.811c-1.496,0.518-2.197,2.872-2.203,2.895l0.006,0.494c1.965,0.666,0.43,1.87,0.039,1.95
						c1.205,0.391-0.352,0.784,0.021,1.175c0.164,0.175,1.229,0.137,1.406,0.305c0.084,0.086-1.082,0.468-2.676,0.057
						c0.27-0.022,0.625-0.052,0.896-0.075c-0.732-0.172-1.037-0.232-2.205-0.235c0.809,0.38-0.07,0.799,0.602,1.184
						c0.742-0.018,1.355-0.112,2.045-0.163c0.396,0.065,0.914,0.16,1.313,0.231c-0.381,0.609,0.049,1.224-0.305,1.836
						c-1.131,0.487-1.131,0.487-0.721,1.43l35.398,0.767c-10.623-0.181-24.719-0.425-35.313-0.601c0.32,0.618,0.371,0.744,0.326,1.112
						c-0.234,0.022-0.553,0.054-0.773,0.077c1.332,0.646,0.781,0.79,0.08,0.974c1.135,0.425,0.873,0.922,1.434,1.373
						c-1.023,0.272-1.244,0.634-2.068,0.927c1.508,0.543,0.258,1.206,1.494,1.761c-0.373,0.108-0.865,0.252-1.236,0.361
						c0.354,0.327,1.426,0.621,1.016,0.985c-0.012,0.014-2.262,0.684-3.973-0.377c-1.734,0.905-0.385,1.31,0.568,1.468
						c0.371-0.08,0.844-0.192,1.174-0.278c1.357,0.338,1.322,0.364,0.344,1.108c0.211,0.04,0.492,0.104,0.705,0.148
						c-0.057,0.121-0.291,0.282-0.531,0.391l2.928,0.058C1056.331,28.636,1056.253,28.604,1056.317,28.601z M1223.882,31.955
						c-0.086,0.108,0.029,0.149,0.24,0.23c0.236,0.085,0.271,0.143,0.143,0.255l-1.711-0.049
						C1222.79,32.139,1223.071,31.995,1223.882,31.955z M1210.157,32.193c-0.205-0.008-0.334-0.055-0.375-0.075
						c-0.041-0.017-0.379-0.171,0.641-0.178C1210.54,32.128,1210.46,32.199,1210.157,32.193z M1211.29,31.691
						c-0.174,0.008-0.354,0.018-0.535,0.015c-0.604-0.023-0.922-0.115-1.051-0.167c-0.049-0.021-0.471-0.204,0.336-0.268
						c0.063,0.068,0.23,0.098,0.604,0.144C1211.155,31.479,1211.446,31.524,1211.29,31.691z M1210.778,24.268
						c-0.018-0.009-0.037-0.014-0.049-0.022c0.318-0.009,0.609-0.052,0.939-0.061c0.383-0.012,0.723,0.018,0.723,0.018
						c0.488,0.12,0.531,0.298,0.438,0.583c-0.309-0.01-0.768-0.021-1.145-0.118C1211.226,24.553,1211.075,24.4,1210.778,24.268z
						 M1210.767,23.673c0.023-0.445,0.035-0.611,1.307-0.537c0.072,0.061,0.145,0.089,0.441,0.164c0.42,0.104,0.572,0.179,0.389,0.339
						c-0.521,0.063-0.922,0.081-1.535,0.066c-0.18-0.009-0.354-0.022-0.527-0.025C1210.817,23.677,1210.79,23.673,1210.767,23.673z
						 M1213.372,30.135c0.07,0.132,0.098,0.265-0.207,0.259c-0.256-0.013-0.396-0.075-0.422-0.086
						C1212.651,30.267,1212.45,30.143,1213.372,30.135z M1213.019,31.353c-0.023,0-0.055,0-0.072,0c0.082-0.112-0.195-0.235,0.082-0.345
						c0.166-0.066,0.598-0.017,0.779,0C1213.923,31.234,1213.665,31.353,1213.019,31.353z M1214.087,22.325
						c-1.432-0.041-2.953-0.084-4.453-0.128L1214.087,22.325z M1209.649,21.729l-0.02,0.278c-0.115,0-0.227,0.009-0.336,0.006
						c-0.129-0.003-0.344-0.012-0.486-0.075c-0.178-0.076-0.146-0.175-0.424-0.244C1208.759,21.703,1209.267,21.718,1209.649,21.729z
						 M1208.007,20.624l0.867,0.022l-0.016,0.189l-0.875-0.026L1208.007,20.624z M1202.319,23.062c0.502,0.015,1.174,0.034,1.668,0.05
						c0.619,0.737,0.604,1.108-0.098,1.717c-0.412-0.04-0.551-0.055-0.879-0.173c-0.465-0.172-0.918-0.543-0.994-0.7
						C1201.888,23.653,1202.271,23.36,1202.319,23.062z M1197.954,24.754l-0.402-0.104c0.008-0.163,0.252-0.218,0.807-0.178
						C1198.241,24.558,1198.069,24.67,1197.954,24.754z M1197.604,22.646c0.289-0.184,0.404-0.241,0.877-0.265
						c2.088,0.54,0.152,1.172,0.768,1.744c-0.377-0.021-1.02-0.052-1.473-0.245c-0.684-0.278-0.469-0.632-1.402-0.891
						C1196.868,22.933,1197.222,22.881,1197.604,22.646z M1177.948,25.063c0.117,0.034,0.277,0.08,0.395,0.118v0.186
						c-0.123,0.023-0.193,0.023-0.406,0.019c-0.072-0.003-0.184-0.006-0.305-0.056C1177.323,25.207,1177.499,25.058,1177.948,25.063z
						 M1160.937,29.006c0.025,0.006,0.049,0.009,0.061,0.015c0.592,0.161,0.283,0.221-0.119,0.216c-0.223-0.01-0.314-0.037-0.354-0.05
						C1160.396,29.142,1160.524,29.077,1160.937,29.006z M1161.183,29.716c0.627-0.109,0.873-0.139,1.512-0.19
						c0.355,0.185,0.355,0.185,0.412,0.488c0-0.012,0-0.028-0.031-0.04c-0.041,0.012-0.301,0.426,0.525,0.719
						c-0.865-0.026-1.725-0.047-2.596-0.069c-0.258-0.195-0.836-0.352-1.252-0.528c-0.295-0.121-0.371-0.192-0.441-0.267
						C1160.313,29.859,1160.644,29.81,1161.183,29.716z M1157.542,29.21c0,0.178,0.842,0.16,1.227,0.252
						c0.342,0.081,0.242,0.236-0.402,0.236c-0.566-0.023-0.947-0.182-0.99-0.198C1157.224,29.434,1156.927,29.278,1157.542,29.21z
						 M1152.071,25.965c0.107,0.018,0.168,0.047,0.285,0.058c0.373,0.046,0.896,0.089,1.283,0.126c0.072,0.306,0.514,0.466,1.521,0.729
						c0.896,0.227,1.301,0.354,1.523,0.601h-0.068c-1.279-0.044-1.773-0.187-2.408-0.485c-0.424-0.206-0.799-0.379-1.639-0.468
						c-0.061-0.009-0.143-0.016-0.201-0.021c0.141-0.184-0.225-0.35-0.359-0.528C1152.022,25.973,1152.048,25.971,1152.071,25.965z
						 M1164.222,17.755c0.6-0.095,1.736-0.031,1.537,0.259c-0.152-0.003-0.309,0.003-0.467,0.003c-0.203-0.006-0.813-0.023-1.082-0.139
						c-0.078-0.031-0.107-0.063-0.123-0.097C1164.132,17.77,1164.173,17.764,1164.222,17.755z M1156.487,14.567
						c0.197,0.178,0.902,0.313,0.854,0.511c-0.252-0.005-1.008-0.024-1.461-0.209C1155.788,14.823,1155.325,14.611,1156.487,14.567z
						 M1131.608,29.055c-0.307-0.009-0.732-0.018-0.996-0.127c-0.213-0.085-0.256-0.197-0.318-0.384
						C1131.7,28.578,1132.235,28.923,1131.608,29.055z M1125.757,15.837c-0.012,0.262-0.09,0.322-0.146,0.325
						c-0.125-0.006-0.223-0.044-0.738-0.251c-0.127-0.003-0.287-0.008-0.414-0.011C1124.911,15.905,1125.271,15.806,1125.757,15.837z
						 M1124.86,16.696c0.006,0.073,0.135,0.108,0.441,0.16c0.389,0.065,0.555,0.112,0.426,0.235c-0.092,0-0.178,0.011-0.266,0.011
						c-0.359-0.017-0.65-0.068-0.859-0.154C1124.452,16.885,1124.187,16.713,1124.86,16.696z M1118.802,19.446
						c0.572-0.052,0.572-0.052,1.123-0.298c0.178-0.003,0.418-0.006,0.596-0.013c0.137,0.109,0.137,0.109,0.891,0.253
						c-0.1,0.058-0.195,0.145-0.225,0.207c0.156,0.003,0.361,0.009,0.514,0.017c0.109,0.109,0.109,0.109-0.26,0.277
						c1.471,0.034,3.025,0.073,4.582,0.113c-2.076-0.017-4.107-0.027-6.055-0.017c-0.158-0.046-0.389-0.106-0.547-0.149
						c0,0-0.012,0-0.014,0c0.049-0.021,0.086-0.061,0.178-0.058C1118.769,19.602,1118.769,19.602,1118.802,19.446z M1119.323,20.521
						c-0.031-0.003-0.068,0-0.092,0l0.467-0.379C1120.257,20.291,1120.196,20.497,1119.323,20.521z M1112.677,27.175
						c0.402,0.243,0.637,0.243,0.967,0.215c0.902-0.075,0.824-0.343,1.646-0.435c2.057,0.515,4.58,0.756,8.988,0.877
						c0.037,0.244,1.338,0.35,1.32,0.6c-0.357,0.061-0.715,0.071-1.533,0.058c-0.242-0.009-0.475-0.012-0.709-0.021
						c-0.104,0-0.244-0.003-0.354-0.006c-0.105,0-0.248-0.005-0.354-0.008c-0.072-0.055-0.176-0.136-0.275-0.188
						c-1.152-0.603-2.877-0.562-4.027,0.086c-0.529-0.275-1.492-0.191-1.498-0.188c-1.215,0.132-3.389,0.005-5.063-0.29
						c-0.102-0.021-0.23-0.043-0.322-0.063C1111.853,27.597,1112.228,27.384,1112.677,27.175z M1079.538,16.115
						c-0.059,0-0.115-0.003-0.176-0.006c-0.014,0-0.02,0-0.029,0c-0.162-0.315-0.004-0.511,1.279-0.442
						C1080.54,15.942,1080.493,16.127,1079.538,16.115z M1070.653,26.545c-0.143,0.08-0.318,0.189-0.449,0.271l-0.414-0.104
						C1069.851,26.583,1069.944,26.505,1070.653,26.545z M1066.479,27.699l0.031,0.188c-0.078,0.089-0.201,0.111-0.527,0.111
						c-0.541-0.017-1.027-0.121-1.186-0.184C1064.417,27.656,1065.058,27.671,1066.479,27.699z M1063.231,21.738
						c0.184,0.043,0.205,0.14-0.35,0.132c-0.313-0.006-0.613-0.047-0.906-0.115c-0.016-0.003-0.041-0.008-0.057-0.011
						C1062.581,21.689,1063.024,21.689,1063.231,21.738z M1060.53,20.032c0.303,0.08,0.449,0.259-0.453,0.247
						c-0.129,0-0.27-0.005-0.398-0.018c-0.025,0-0.049-0.005-0.076-0.005c-0.01-0.061-0.014-0.145-0.02-0.207
						C1060.009,19.918,1060.392,19.995,1060.53,20.032z M1060.089,20.733c0.166,0.017,0.33,0.037,0.514,0.042
						c0.313,0.003,0.549-0.014,1.211-0.082c0.418,0.234,0.326,0.341-0.051,0.504c-0.248,0.109-0.324,0.162-0.354,0.254
						c-0.203,0-2.051-0.018-2.414-0.052c-0.049,0-0.121,0-0.168-0.003c0.188-0.396,0.188-0.396-0.482-0.778
						C1059.069,20.639,1059.495,20.658,1060.089,20.733z M1053.06,26.855l-0.928-0.316c0.496-0.114,0.955-0.074,1.252-0.022
						C1053.849,26.603,1054.22,26.826,1053.06,26.855z"/>
					<path d="M1199.329,21.904l2.553,0.072c-0.436-0.264-1.064-0.388-2.186-0.434c-0.092-0.006-0.189-0.006-0.281-0.012
						C1199.491,21.669,1199.507,21.784,1199.329,21.904z"/>
					<path d="M1354.134,26.832l-0.025,0.092c1.016,0.034,2.371,0.075,3.383,0.109c0.133-0.046,0.307-0.109,0.441-0.155
						c0.352,0.009,0.352,0.009,1.537,0.161c0.215-0.029,0.439-0.098,0.563-0.149c0.279,0.006,0.658,0.012,0.939,0.018
						c0.057-0.029,0.129-0.063,0.184-0.089c1.195,0.112,1.814,0.221,2.762,0.474c1.162,0.046,2.357,0.034,3.473,0.132
						c0.006,0,0.016,0.006,0.029,0.006c0.324,0.038,0.625,0.086,0.914,0.138l-0.111-0.109c0.047-0.063,0.119-0.149,0.17-0.213
						c2.918-0.103,3-0.314,3.119-0.607c2.25,0.464,4.791,0.289,6.104,0.143c1.086,0.086,1.262,0.402,2.379,0.483
						c-0.16-0.087-0.285-0.219-0.156-0.306c0.721-0.074,1.014-0.103,2.248-0.003c0.553-0.973-6.053-0.255-8.891-0.548
						c-2.816,0.218-9.359,0.028-8.887-0.345c0.791-0.086,1.754-0.051,2.486-0.175c1.08,0.152,2.883,0.417,4.529,0.083
						c0-0.029,0.014-0.069,0.014-0.098c0.012,0,0.023,0,0.035-0.003c1.584,0.049,2.795,0.33,4.406,0.359l0.432-0.167l1.609,0.063
						c0.398-0.046,0.926-0.106,1.33-0.153c0.223,0.026,0.504,0.061,0.725,0.084c1.385,0.175,5.158,0.018,6.441-0.098
						c0.33-0.034,0.33-0.034,4.939,0.584c-0.246,0.054-0.576,0.116-0.824,0.169c1.674,0.304,1.977,0.358,3.182,0.315
						c-0.105-0.052-0.145-0.13-0.076-0.181c0.16,0.003,0.363,0.009,0.523,0.009c-0.154-0.155-0.375-0.192-1.006-0.224
						c-0.131,0.045-0.219,0.12-0.205,0.174c-0.533-0.168-0.859-0.272-2.326-0.385c0.59-0.095,1.381-0.215,1.971-0.31
						c1.002,0.063,1.236,0.092,1.713,0.27c1.953-0.324,3.908-0.369,6.172-0.138c-0.348-0.175-0.348-0.175-2.992-0.646
						c0.092-0.028,0.215-0.063,0.307-0.092c0.768,0.003,1.408,0.098,2.119,0.14l0.443-0.169c0.342,0.069,0.795,0.164,1.145,0.233
						c1.75-0.072,3.361-0.262,5.098-0.348c-0.668-0.377-2.027-0.354-2.418-0.305c-1.154-0.235-1.154-0.256-1.32-0.827
						c-0.787-0.061-0.787-0.061-11.113-0.061c-0.098,0.107-0.098,0.107,0.701,0.417c-0.096,0.023-0.229,0.058-0.32,0.08
						c-0.686-0.012-1.197-0.08-1.664-0.164c0.445,0,0.852-0.055,0.867-0.255c-0.365-0.018-0.848-0.034-1.213-0.052l-0.074,0.23
						c-0.74-0.162-1.395-0.349-2.393-0.42c0.744-0.253,0.744-0.253,0.598-0.371c-0.229-0.188-1.703-0.427-2.48,0.003
						c-0.801-0.284-1.936-0.394-4.855-0.47c-0.18,0.28,0.189,0.367,1.932,0.464c0.072-0.065,0.178-0.16,0.246-0.227
						c1.006,0.311,1.006,0.311,2.891,0.371c-0.213,0.132-0.789,0.221-0.803,0.372c0.215,0.035,0.537,0.061,0.779,0.073
						c-1.309,0.218-3.076-0.124-4.322,0.178c-0.18-0.003-0.418-0.006-0.594-0.01c0.018-0.116,0.348-0.223,0.318-0.338
						c-0.213-0.017-0.5-0.029-0.721-0.04c-0.176,0.37-0.135,0.414,0.273,0.585c-2.582,0.121-3.502,0.081-4.402-0.045
						c0.006-0.053,0.158-0.126,0.33-0.165c0.393,0.032,0.777,0.073,1.189,0.096c-0.084-0.558-2.775-0.483-4.051-0.753
						c0.014-0.058,0.035-0.137,0.061-0.194c2.959-0.053,3.076-0.058,3.535-0.312c-2.385-0.223-2.385-0.223-3.307-0.034
						c-2.93-0.542-4.496-0.375-5.244-0.295c0.873-0.281,2.906-0.311,3.096-0.738c-1.229,0.077-2.502-0.006-3.738,0.043
						c-0.438-0.537-0.438-0.537-0.652-0.6c0.436-0.075,0.436-0.075,7.09-0.118c0.246,0.139,0.246,0.139,2.32,0.531
						c-1.025,0.327-2.48-0.069-3.73-0.008c-0.148,0.26-0.117,0.313,0.301,0.493c1.289-0.215,2.275-0.228,6.281,0.104
						c1.381,0.111,4.246,0.35,4.801-0.232c-2.17,0.074-3.256-0.586-5.559-0.419c-0.078-0.021-0.17-0.05-0.256-0.07
						c0.473-0.143,1.594-0.126,1.693-0.355c3.254,0.518,6.902-0.229,7.066-0.261c-0.219-0.049-1.109-0.184-1.662,0.082
						c-1.229-0.539-4.076-0.034-5.504-0.441c-0.035-0.018-0.084-0.046-0.133-0.063c-0.436,0.097-2.707,0.554-4.574,0.011
						c-3.311,0.431-7.238-0.149-10.523,0.333c0.447,0.29,1.627,0.506,1.725,0.833c-1.055,0.178-7.287,0.327-8.141-0.083
						c-0.199,0.111-0.447,0.261-0.646,0.37c-0.453,0.006-0.453,0.006-1.484-0.247c-3.959,0.161-7.486-0.744-11.592-0.247
						c-0.859-0.272-0.197-0.603-0.602-0.894c0.006,0.003,1.387,0.383,2.125,0.543c0.75-0.187,0.75-0.187,1.496-0.111
						c0.072-0.17,0.072-0.17-0.502-0.486c0.279-0.042,0.725-0.076,1.057-0.086c-1.215-0.212-2.119,0.225-3.305,0.081
						c-0.006-0.058,0.16-0.132,0.322-0.173c0.086-0.006,0.166-0.011,0.484-0.042c0.061-0.038,0.152-0.081,0.213-0.115
						c-0.072-0.04-0.174-0.095-0.25-0.135c-0.635-0.038-0.635-0.038-2.096,0.292c-1.58-0.16-3.547-0.103-4.811-0.445
						c-2.004,0.222-2.924,0.34-4.293,0.532c-3.076-0.167-3.076-0.167-3.781-0.132c-0.129,0.218,0.52,0.613,1.295,0.688
						c0.842-0.092,0.842-0.092,1.18-0.092c0.094,0.026,0.213,0.053,0.307,0.074c-2.328,0.655-5.01,0.288-5.895,0.164
						c-1.197,0.216-1.197,0.216-1.16,1.221c0.977,0.034,1.957,0.069,2.934,0.104c0.662-0.253,1.01-0.244,3.332-0.179
						c-0.426,0.066-0.914,0.104-1.373,0.149c-0.043,0.029-0.1,0.063-0.148,0.089c0.313,0.029,0.313,0.029,2.217,0.364
						c1.357-0.091,1.967-0.2,2.609-0.481c-0.123,0.246-0.123,0.246,2.34,0.848c-1.014,0.123-2.291,0.065-3.229,0.238
						c-1.371-0.225-1.861-0.173-3.514,0c-2.828-0.253-5.826-0.133-8.734-0.201c0.072,0.063,0.178,0.154,0.318,0.218
						c1.438,0.615,4.738,0.195,6.57,0.597c0.207-0.028,0.207-0.028,8.391,0.053c-0.072,0.028-0.166,0.068-0.232,0.1
						c-0.135,0.003-0.313,0.003-0.441,0.003c-0.07-0.022-0.152-0.058-0.211-0.085c-0.949,0.126-0.52,0.286,0.248,0.582
						c-2.1,0.075-4.363-0.123-6.344,0.181c-0.023,0.05-0.047,0.115-0.072,0.161c1.842,0.012,3.191,0.351,5.004,0.379
						c-0.061,0.068-0.061,0.068-2.646,0.371l18.533,0.677l0.023-0.095L1354.134,26.832z M1394.815,24.575
						c-0.625-0.018-0.732,0.184-1.357,0.166c-0.316-0.02-0.34-0.022-0.5-0.103c-0.123-0.063-0.055-0.099,0.01-0.126
						c0.113-0.062,0.146-0.099-0.139-0.201C1394.138,24.346,1394.767,24.391,1394.815,24.575z M1390.825,25.475
						c0.404-0.112,0.711-0.055,0.857-0.016c0.303,0.087,0.379,0.273-0.486,0.244c-0.123-0.003-0.248-0.011-0.367-0.024
						c-0.021,0-0.045-0.007-0.068-0.01C1390.784,25.608,1390.808,25.534,1390.825,25.475z M1388.372,25.472l0.766,0.028l-0.064,0.198
						l-0.768-0.029L1388.372,25.472z M1384.04,25.571c0.023-0.002,0.047-0.002,0.07-0.002c0.52-0.053,0.721-0.213,1.385-0.213
						c0.289,0.235-0.486,0.378-1.148,0.356c-0.113-0.006-0.34-0.018-0.506-0.078c-0.035-0.014-0.072-0.037-0.1-0.055
						C1383.847,25.58,1383.948,25.577,1384.04,25.571z M1380.091,25.437c0.264,0.185-0.377,0.201-0.959,0.182
						c-0.795-0.038-1.02-0.106-1.068-0.124c-0.035-0.018-0.047-0.029-0.047-0.046C1378.583,25.391,1379.126,25.37,1380.091,25.437z
						 M1374.009,25.201c0.459,0.046,0.943,0.092,1.393,0.098c0.648,0.006,1.26-0.049,1.898-0.063c0.092,0.089,0.223,0.206,0.303,0.293
						c-1.479,0.085-1.742,0.097-2.133,0.212c-0.197-0.178-1.143-0.167-1.49-0.308C1373.778,25.351,1373.929,25.259,1374.009,25.201z
						 M1379.519,22.155c0.396-0.112,0.715-0.058,0.867-0.016c0.242,0.069,0.465,0.265-0.484,0.23c-0.129-0.006-0.26-0.012-0.377-0.023
						c-0.023-0.006-0.045-0.008-0.072-0.011C1379.479,22.278,1379.501,22.209,1379.519,22.155z M1359.396,26.35
						c-0.439-0.017-1.771-0.068-2.82-0.255c-0.049-0.009-0.109-0.021-0.152-0.026c0.695,0.018,0.965-0.018,1.271-0.155
						c1.273,0.144,1.68,0.127,2.576,0.08c0.549-0.025,1.131-0.045,2.34,0.013c-0.049,0.092-0.049,0.103,0.092,0.16
						c0.156,0.068,0.475,0.101,0.664,0.16C1361.868,26.39,1360.679,26.394,1359.396,26.35z M1360.899,25.218
						c0.012,0,0.25-0.045,0.195,0.155c0.232,0.042,0.643,0.139,0.678,0.149c-0.219-0.006-0.537-0.054-0.752-0.172
						C1360.899,25.287,1360.858,25.23,1360.899,25.218z M1371.038,25.383c0.064-0.124,0.07-0.142,0.457-0.182
						c0.547-0.052,1.123-0.006,1.678-0.028c-0.068,0.187-0.068,0.187-0.141,0.47c-0.586,0.081-1.057,0.096-2.027,0.064
						c-1.191-0.049-2.314-0.167-3.525-0.201c-0.846-0.026-1.227,0.028-1.434,0.058c-0.113-0.087-0.254-0.207-0.371-0.293l-0.078,0.275
						c-0.627-0.012-1.789-0.077-2.549-0.391c-0.061-0.023-0.121-0.058-0.18-0.086c1.805,0.058,3.607-0.069,5.412,0
						C1369.694,25.124,1370.501,25.278,1371.038,25.383z M1365.155,24.38c0.213,0.065,0.502,0.149,0.715,0.215
						c-0.094,0.038-0.256,0.078-0.537,0.072c-0.348-0.018-0.52-0.092-0.566-0.114C1364.702,24.521,1364.532,24.408,1365.155,24.38z
						 M1362.497,23.427c0.479-0.032,1.01-0.066,1.779-0.074c1.109-0.013,2.031,0.068,2.332,0.097c0.48,0.043,0.48,0.043,0.65,0.034
						c0.326-0.016,0.504-0.097,0.844-0.111c0.037,0,0.082-0.003,0.125,0c0.275,0.015,0.523,0.089,0.523,0.096
						c0.088,0.079-0.066,0.199-0.094,0.286c-0.697,0.075-2.551,0.229-4.861,0.157c-0.264-0.008-0.803-0.031-1.258-0.095
						c-0.045-0.005-0.1-0.011-0.154-0.02C1362.421,23.686,1362.47,23.538,1362.497,23.427z M1360.063,22.425
						c0.377,0,0.791,0.014,1.025,0.037c0.848,0.086,1.074,0.246,1.166,0.477c-0.518-0.065-0.953-0.102-2.002-0.117
						c-1.852-0.032-2.289-0.038-2.643-0.213c-0.094-0.049-0.141-0.099-0.184-0.146C1358.306,22.456,1359.179,22.425,1360.063,22.425z
						 M1359.841,25.437c-0.914,0.152-1.713,0.195-2.84,0.158c-0.297-0.015-0.75-0.031-1.506-0.118c-0.066-0.008-0.146-0.018-0.213-0.022
						c0.029-0.118,0.078-0.271,0.102-0.385C1356.423,25.017,1359.409,25.012,1359.841,25.437z M1353.138,23.357
						c0.582-0.146,2.15,0,2.26,0.271c-0.406,0.063-0.848,0.074-1.902,0.037c-0.168-0.009-0.34-0.014-0.516-0.021
						c-0.02,0-0.049-0.003-0.07-0.003C1352.872,23.57,1352.813,23.441,1353.138,23.357z M1329.534,22.105l-0.803-0.215
						c0.457,0.014,0.848-0.083,1.326-0.047C1329.897,21.922,1329.69,22.03,1329.534,22.105z M1335.397,22.536
						c-0.09-0.006-0.291-0.017-0.408-0.063c-0.049-0.022-0.066-0.042-0.08-0.065c0.264,0,0.35-0.026,0.516-0.089
						c0.342-0.139,0.768-0.066,0.768-0.066C1336.388,22.295,1336.427,22.563,1335.397,22.536z M1337.653,22.373
						c-0.098-0.055-0.166-0.112-0.201-0.17c1.215,0.008,1.764,0.115,2.063,0.17c-0.141,0.083-0.328,0.194-0.469,0.278
						C1338.562,22.611,1337.972,22.536,1337.653,22.373z M1339.288,24.771c0.227,0.092,0.533,0.218,0.771,0.307l-1.668,0.127
						C1338.384,24.928,1338.433,24.762,1339.288,24.771z M1339.128,26.189c-0.051-0.003-0.107-0.003-0.164-0.007c-0.016,0-0.02,0-0.025,0
						c-0.059-0.074-0.119-0.146-0.018-0.224c0.453-0.338,3.555-0.206,4.221,0.098C1341.774,26.057,1340.528,26.234,1339.128,26.189z
						 M1348.251,22.505c-0.012,0.083-0.047,0.198-0.07,0.278l-0.85-0.028l-0.4-0.204C1347.392,22.564,1347.78,22.47,1348.251,22.505z
						 M1345.14,22.434c0.131,0.165,0.061,0.235-0.721,0.212c-0.033-0.014-0.08-0.034-0.104-0.047c-0.318-0.154-0.258-0.298-0.166-0.43
						c0.365,0.04,0.848,0.097,1.215,0.138C1345.103,22.301,1345.058,22.329,1345.14,22.434z M1347.661,26.224l-0.836-0.034l0.047-0.181
						l0.838,0.031L1347.661,26.224z M1348.294,25.287c-0.785-0.028-1.254-0.046-1.48-0.149c-0.154-0.068-0.098-0.149-0.061-0.187
						C1348.522,24.963,1348.351,25.207,1348.294,25.287z M1351.13,26.148c-0.086-0.006-0.287-0.014-0.521-0.101
						c-0.012-0.002-0.029-0.008-0.035-0.011c0.654-0.089,0.895-0.061,0.984-0.038C1351.739,26.051,1351.497,26.158,1351.13,26.148z"/>
					<path d="M1.53,28.429c2.511,0.271,8.667,0.882,11.613,0.732c0.309,0.055,0.72,0.12,1.028,0.175
						c0.318-0.037,0.745-0.083,1.07-0.117c-3.111-1.346-10.441-0.965-15.186-1.639v1.341c0.131,0.024,0.26,0.048,0.404,0.074
						C0.68,28.816,1.122,28.587,1.53,28.429z"/>
					<path d="M128.758,28.503c-9.171-0.668-9.171-0.668-9.201-0.814c0.73-0.075,3.531-0.275,8.882,0.301
						c-0.53-0.348-1.238-0.813-1.77-1.163c-2.145-0.011-3.979-0.528-6.336-0.191c-1.101-0.096-2.033-0.265-3.058-0.388
						c-0.235,0.014-0.543,0.028-0.767,0.042c-0.978-0.172-2.227-0.229-3.257-0.382c-0.037-0.058-0.078-0.135-0.114-0.194
						c0.461-0.058,1.167-0.092,1.686-0.104c-0.053-0.011-5.182-0.996-5.918-1.645c0.413,0.065,1.098,0.117,1.592,0.109
						c0.112-0.044,0.272-0.107,0.384-0.152c0.336,0.092,0.784,0.215,1.114,0.307c2.486-0.055,4.873-0.33,7.462-0.167
						c-1.445-0.708-1.445-0.708-1.598-0.97c3.19-0.112,4.845-0.068,6.271,0.78c-0.843-0.634-1.963-1.478-2.8-2.11
						c-6-0.178-6-0.178-10.78-0.764c-0.194,0.037-0.466,0.087-0.66,0.121c-1.296-0.149-2.923-0.029-4.114-0.265
						c0.053-0.112,0.418-0.262,0.784-0.345c-0.059-0.071-0.137-0.166-0.201-0.241c2.158,0.023,2.357,0.046,3.208,0.138
						c0.199-0.049,0.471-0.114,0.66-0.167c0.224,0.023,0.529,0.055,0.753,0.081c-0.234-0.195-0.847-0.348-1.012-0.545
						c1.473-0.018,1.473-0.018,2.711-0.133c0.211,0.028,0.507,0.058,0.73,0.08c0.047-0.052,0.112-0.12,0.152-0.172
						c-2.935-0.833-2.935-0.867-2.905-1.258c1.262,0,4.633,0.068,8.707,0.718c-0.29-0.304-0.672-0.712-0.962-1.02
						c-5.44,0.342-6.467-0.318-8.187-1.412c0.166-0.049,0.378-0.115,0.536-0.164c-0.04-0.058-0.099-0.135-0.146-0.192
						c2.329,0.015,5.457,0.296,5.476,0.302c1.779,0.398,0.712,1.034,2.305,1.449c-0.697-0.697-1.627-1.627-2.329-2.328
						c-0.082,0.063-0.188,0.144-0.271,0.201c-7.468,0.018-27.177-1.536-27.336-1.554c-0.165,0.046-0.383,0.104-0.547,0.146
						c-5.347-0.453-11.041-0.592-16.462-0.971c-0.49-0.015-1.162,0.006-1.627,0.04c0.536,0.149,0.536,0.149,7.927,0.944
						c0.059-0.054,0.141-0.129,0.207-0.181c0.76,0.242,0.667,0.563,1.386,0.811c0.199-0.028,0.459-0.069,0.659-0.102
						c-0.036-0.117-0.294-0.267-0.594-0.358c0.146-0.061,0.354-0.141,0.5-0.201c4.645,0.563,8.629,1.338,12.96,2.001
						c-0.205,0.058-0.488,0.13-0.694,0.185c-4.444,0.072-8.411-0.457-12.749-0.52c0.895,0.444,2.475,0.78,3.678,1.184
						c-0.207,0.052-0.485,0.12-0.685,0.172c-0.837-0.018-1.661-0.063-2.511-0.055c2.907,0.83,2.907,0.83,1.427,1.111
						c-3.253-0.092-5.583-0.956-9.402-0.586c-0.112-0.129-0.087-0.315,0.07-0.442c0.208,0.038,0.484,0.083,0.691,0.118
						c-1.168-1.014-12.089-0.835-12.19-0.83c0.207,0.108,0.573,0.247,0.884,0.339c-0.012,0.005-2.54,0.264-9.428-0.179
						c-1.105,0.149-11.325-0.631-11.538-1.039c2.457-0.017,4.462,0.373,6.891,0.379c0.153-0.04,0.365-0.097,0.519-0.141
						c2.334,0.009,4.38,0.45,6.873,0.229c-0.377-0.221-0.725-0.295-1.928-0.28c-6.489-0.79-6.489-0.79-13.741-0.715
						c-4.79,0.051-7.515-0.925-11.65-1.199c-0.475-0.031-1.096,0.078-1.544,0.125c0.267,0.143,0.618,0.33,0.877,0.473
						c4.026,0.324,5.096,0.437,10.232,0.969c-0.065,0.138-0.362,0.327-0.774,0.43c3.678,1.212,10.343,0.73,15.047,1.361
						c-0.083-0.086-0.188-0.195-0.271-0.28c5.354,0.637,11.591,0.537,17.114,1.035c0.112-0.051,0.252-0.117,0.36-0.168
						c1.801-0.007,2.993,0.034,6.447,0.27c9.856,0.674,9.856,0.674,9.973,0.646c0.207,0.092,0.672,0.192,1.078,0.235
						c0.055-0.06,0.125-0.141,0.172-0.204c5.533,0.587,11.764,0.718,17.169,1.376c0.146,0.093,0.347,0.213,0.488,0.305
						c0.448-0.031,1.091-0.049,1.556-0.031c-0.124,0.061-0.283,0.143-0.412,0.203l-10.609-0.399c-0.359-0.074-0.944-0.149-1.403-0.184
						c-0.129,0.053-0.289,0.127-0.412,0.184c-0.061-0.011-6.731-0.919-8.794-0.396c-0.838-0.086-0.838-0.086-2.547-0.106
						c0.478,0.353,0.478,0.371,0.483,0.666c1.308,0.198,3.416,0.198,5.204,0.267l-0.217-0.224l-0.093,0.092
						c-0.154-0.126-0.202-0.206,0.021-0.246c0.108-0.018,0.307-0.016,0.615,0.005c0.159,0.012,0.448,0.026,0.628,0.017
						c0.114,0.093,0.308,0.271,0.138,0.354c-0.094,0.044-0.254,0.041-0.416,0.038c1.518,0.08,2.679,0.244,2.621,0.695
						c-3.773-0.058-5.854,0.218-5.878,0.223c0.249,0.007,0.573,0.018,0.82,0.023c-0.07,0.063-0.175,0.146-0.258,0.207
						c-0.501,0.006-1.179-0.003-1.686-0.023c-0.19,0.038-0.438,0.087-0.632,0.127c0.135,0.057,0.319,0.132,0.454,0.189
						c1.699,0.029,3.16,0.235,4.763,0.333c0.201-0.034,0.472-0.081,0.672-0.115c0.308,0.018,0.308,0.018,3.361,0.396
						c0.371,0,0.371,0,2.415,0.195c0.579-0.098,0.579-0.098,11.895,1.326c0.178,0.112,0.414,0.265,0.588,0.38
						c-0.181,0.052-0.429,0.12-0.612,0.167l-9.779-0.773c-3.66,0.434-5.581-0.479-8.563-0.571c-0.26-0.091-0.607-0.212-0.867-0.304
						c-5.097,0.947-10.026-0.442-15.083-0.058c0.884,0.25,1.226,0.241,2.133,0.213c2.029,0.367,6.496,0.017,6.754,0.835
						c-0.075,0.009-8.178,0.161-9.052-0.474c-0.129,0.058-0.305,0.126-0.435,0.178c-1.981-0.253-1.675-0.58-1.568-0.688
						c0.53-0.01,1.238-0.023,1.769-0.047c-1.203-0.465-3.925-0.646-4.504-1.229c-0.365,0.063-0.778,0.175-0.978,0.27
						c-3.261-0.27-6.655-0.031-9.95-0.141c-3.545-0.118-6.831-0.451-10.308-0.623c-0.189,0.04-0.445,0.086-0.634,0.127
						c0.797,0.367,3.032,0.304,3.891,0.654c-1.894,0.221-15.181-0.448-16.315-0.953c-3.381,0.305-6.284-0.546-9.683-0.207
						c-0.424-0.063-0.951-0.17-1.255-0.264c-2.657-0.044-3.856-0.461-5.083-0.87c0.099,0.008,0.186,0.008,0.284,0
						c0.165-0.01,0.32-0.021,0.486-0.01c-0.251-0.177-0.761-0.31-1.111-0.347c-0.36-0.026-0.311,0.089-0.237,0.17
						c-0.533-0.167-1.107-0.322-1.837-0.438l-0.695-0.063c-0.184,0.04-0.423,0.086-0.599,0.126c-0.227-0.018-0.528-0.034-0.755-0.052
						c0.503,0.361,2.693,0.448,2.735,0.879c-1.543-0.267-1.543-0.267-4.322-0.426c-0.119-0.103-0.075-0.252,0.104-0.35
						c0.228,0.02,0.525,0.049,0.751,0.068c0.18-0.034,0.418-0.08,0.596-0.117c-0.138-0.103-0.59-0.228-1.011-0.284
						c-1.725,0.114-3.032-0.204-4.63-0.227c0.649,0.232,1.842,0.33,2.587,0.537c-0.043,0.063-0.1,0.151-0.144,0.218
						c-2.959-0.026-4.9-0.402-5.95-0.605c0.049-0.061,0.11-0.147,0.165-0.21c0.212,0.026,0.498,0.063,0.712,0.086
						c0.154-0.041,0.366-0.095,0.523-0.138c-0.76-0.393-2.71-0.473-4.093-0.702v0.495C0.49,18.869,1.078,18.97,1.6,19.013
						c-0.03,0.055-0.066,0.13-0.089,0.188c-0.49-0.041-0.968-0.088-1.455-0.13v3.435c0.16,0.011,0.326,0.015,0.478,0.031
						c0.216-0.02,0.501-0.051,0.717-0.071c-0.013-0.121-0.274-0.285-0.613-0.377c0.094-0.051,0.216-0.117,0.309-0.166
						c2.86,0.218,5.488,0.598,8.597,0.638c0.118,0.052,0.277,0.12,0.401,0.172c1.058-0.092,5.938,0.046,5.355,0.862
						c-0.213,0.025-0.505,0.058-0.721,0.073l-0.918-0.172c-0.945-0.292-2.587-0.396-3.601-0.666c0.012,0.068,0.034,0.164,0.05,0.235
						c-0.245-0.014-0.568-0.034-0.814-0.046c-0.037,0.117,0.17,0.284,0.456,0.385c0.253-0.011,0.588-0.029,0.84-0.043
						c0.177,0.058,0.41,0.129,0.583,0.187c0.969,0.006,0.969,0.006,3.083,0.27l-0.082-0.184c0.153,0.04,0.362,0.098,0.516,0.136
						c4.086-0.416,6.499,0.864,10.499,0.528c1.109,0.209,1.551,0.144,2.428,0.009c-2.093-0.213-3.288-0.67-5.161-0.942
						c-0.127-0.139-0.278-0.322-0.364-0.466c0.181-0.042,0.419-0.103,0.602-0.149c0.201,0.035,0.47,0.087,0.669,0.121
						c0.243-0.009,0.57-0.02,0.807-0.028c0.197,0.035,0.448,0.08,0.642,0.111c0.076-0.06,0.172-0.14,0.251-0.204
						c0.237-0.011,0.553-0.028,0.785-0.04c1.532,0.498,5.016,0.566,5.531,1.287c-1.048-0.081-2.086-0.181-3.173-0.241
						c-0.207,0.031-0.484,0.075-0.683,0.106c2.743,0.321,2.969,0.347,4.189,0.844c2.582,0.063,4.81,0.537,7.624,0.336
						c-0.952-0.089-0.972-0.092-1.282-0.414c10.973,0.896,23.065,0.689,33.862,1.761c2.723-0.375,11.222,0.531,12.083,0.942
						c-0.618,0.262-1.32,0.554-17.881-0.701L55.129,26.24c0.107,0.052,0.236,0.12,0.336,0.173c6.647,0.204,6.647,0.204,15.331,1.148
						c-0.142,0.04-0.332,0.101-0.472,0.145c-0.277-0.007-0.649-0.021-0.921-0.026c-0.854-0.262-8.263-0.411-8.817-0.348
						c-0.011,0.058-0.034,0.126-0.046,0.181c-0.479,0.021-1.157,0.014-1.628-0.011c-0.023-0.055-0.058-0.128-0.082-0.182
						c-0.236-0.012-0.542-0.031-0.78-0.046c-0.07,0.058-0.15,0.132-0.211,0.189c-0.482-0.022-1.143-0.043-1.632-0.051
						c11.841,0.61,27.626,1.423,39.473,2.029c0.4-0.098,0.896-0.238,1.219-0.348c-0.96-0.293-1.078-0.321-2.952-0.657
						c-0.136,0.058-0.306,0.136-0.446,0.195c-0.602,0.003-1.41,0.025-2.004,0.049c-1.108-1.155-1.108-1.155-1.48-1.247
						c2.889-1.274,13.544,0.222,14.311,0.435c-0.065,0.058-0.146,0.136-0.201,0.198c7.204,0.747,8.47,0.614,9.578,0.499
						c-0.111-0.108-0.028-0.27,0.154-0.376c0.022,0,6.565,0.376,15.56,0.709C129.218,28.778,128.958,28.621,128.758,28.503z
						 M113.751,23.027c0.248,0.197,0.165,0.284-0.271,0.272c-0.07-0.005-0.142-0.018-0.218-0.022c-0.016,0-0.028-0.003-0.04-0.006
						C112.72,22.962,113.174,22.989,113.751,23.027z M37.961,15.958c-0.034-0.003-0.113-0.012-0.224-0.075
						c-0.037-0.022-0.132-0.077-0.079-0.106h0.008c0.081-0.018,0.246,0.023,0.516,0.118C38.106,15.942,38.045,15.96,37.961,15.958z
						 M39.633,16.063c-0.088-0.006-0.115-0.022-0.148-0.04c-0.081-0.045-0.119-0.103-0.086-0.126c0.019-0.023,0.097-0.018,0.211,0.023
						C40.031,16.063,39.639,16.063,39.633,16.063z M71.021,17.867l-0.461-0.29l0.56,0.025L71.021,17.867z M98.857,17.012
						c-0.607-0.035-0.973-0.161-1.526-0.219c-0.024,0-0.061-0.005-0.083-0.005c0-0.013,0.011-0.026,0.022-0.034
						c0.207-0.168,1.458-0.073,2.111,0.218C99.206,17.012,99.099,17.021,98.857,17.012z M98.192,16.558
						c-1.08-0.065-1.893-0.259-2.984-0.319c0.201,0.199,0.909,0.366,0.743,0.589c-0.411-0.018-0.813-0.034-1.219-0.055
						c-0.277-0.232-0.277-0.267-0.052-0.413c0.117-0.074,0.1-0.111,0.046-0.221c-0.224,0-0.389-0.034-0.402-0.034
						c-0.766-0.196-0.807-0.492-1.72-0.673c-0.312-0.061-0.826-0.028-1.072-0.115c-0.148-0.051-0.177-0.108-0.224-0.166
						c2.169-0.097,3.365-0.151,5.353-0.005c1.278,0.097,1.278,0.097,1.532,0.258c0.199,0.127,0.283,0.148,0.482,0.155
						c0.349-0.144,1.02-0.007,1.522-0.032c0.388,0.13,0.471,0.158,1.071,0.245c1.216,0.184,1.297,0.258,1.569,0.517
						C101.09,16.201,99.959,16.667,98.192,16.558z M84.877,20.722c-0.349-0.018-0.59-0.075-0.727-0.115
						c-0.022-0.006-0.034-0.012-0.047-0.015c0,0-0.217-0.175,0.025-0.226c0.17-0.035,0.252-0.029,1.019,0.005
						C85.694,20.722,85.142,20.733,84.877,20.722z M88.997,21.003c-0.025,0-0.042,0-0.061-0.003c-0.059-0.068-0.2-0.215-0.141-0.296
						c0.06-0.08,0.284-0.052,0.448,0C89.593,20.808,89.856,21.032,88.997,21.003z M86.491,22.237c-0.465-0.028-0.742-0.132-0.867-0.191
						c-0.087-0.038-0.141-0.081-0.188-0.124c0.577,0.009,0.979,0.055,1.262,0.144C87.305,22.255,86.499,22.237,86.491,22.237z
						 M90.417,21.537c-0.008-0.003-0.012-0.006-0.017-0.006c-0.061-0.038-0.089-0.075-0.106-0.109c0.112,0.006,0.254,0.012,0.365,0.014
						l0.412,0.193C90.776,21.618,90.563,21.611,90.417,21.537z M92.021,21.768c-0.324-0.021-0.666-0.115-0.837-0.196
						c-0.006-0.006-0.019-0.011-0.03-0.018c0.165,0.012,0.235,0.018,0.33-0.005c0.013,0,0.024-0.003,0.035-0.006
						c0.165-0.058,0.307-0.104,0.52-0.043C92.049,21.503,92.521,21.778,92.021,21.768z M93.158,21.83
						c-0.425-0.021-0.602-0.078-0.713-0.127c-0.006-0.006-0.017-0.009-0.03-0.011c0.202,0.022,0.461,0.04,0.744-0.053
						c0.146-0.045,0.3-0.086,0.507-0.034C94.62,21.864,93.169,21.833,93.158,21.83z M105.181,16.756c-0.03-0.002-0.059-0.009-0.082-0.012
						c0.423-0.144,1.773-0.123,2.775,0.207C106.986,16.88,106.02,16.862,105.181,16.756z M104.816,22.56
						c-0.047-0.023-0.07-0.043-0.095-0.066c0.306,0.034,0.708,0.084,1.014,0.118C105.43,22.594,105.022,22.651,104.816,22.56z
						 M106.136,22.727l-0.181-0.184l0.405,0.017l0.188,0.184L106.136,22.727z M9.391,19.607c0.112-0.055,0.395,0.025,0.672,0.189
						c0.01,0.006,0.015,0.012,0.026,0.018c0.092,0.057,0.162,0.117,0.224,0.178c-0.388-0.034-0.564-0.052-0.755-0.167
						C9.447,19.762,9.287,19.653,9.391,19.607z M10.812,21.658c-0.156-0.019-0.579-0.063-1.094-0.356
						c-0.263-0.149-0.263-0.149-0.328-0.345c0.194,0.052,0.431,0.091,0.676,0.127c0.343,0.045,0.733,0.103,1.065,0.267
						c0.221,0.105,0.351,0.232,0.354,0.232C11.485,21.583,11.3,21.697,10.812,21.658z M11.852,21.347
						c0.106,0.104,0.106,0.104,0.913,0.518c-0.092,0.017-0.211,0.04-0.306,0.063c-0.106-0.139-0.215-0.187-0.458-0.253
						c-0.114-0.032-0.208-0.066-0.28-0.104c-0.084-0.052-0.132-0.109-0.172-0.16C11.636,21.394,11.758,21.364,11.852,21.347z
						 M12.577,22.301c-0.244,0.009-0.496,0.018-0.742-0.074c-0.014-0.003-0.039-0.012-0.044-0.018c-0.013,0-0.315-0.315-0.151-0.35
						c0.042-0.013,0.141,0.005,0.144,0.005c0.187,0.138,0.326,0.189,0.601,0.218c0.221,0.019,0.491-0.017,0.672,0.035
						c0.169,0.046,0.198,0.138,0.218,0.227C13.13,22.289,12.953,22.292,12.577,22.301z M13.573,22.24
						c-0.16-0.083-0.086-0.114-0.056-0.129c0.159,0.126,0.683,0.201,0.851,0.33C13.924,22.398,13.682,22.298,13.573,22.24z
						 M37.261,24.751l-0.214-0.198l0.312,0.022l0.214,0.198L37.261,24.751z M60.97,23.427c-0.778-0.023-1.421-0.139-2.181-0.166
						c-0.317-0.013-0.336-0.013-0.514,0.057c-0.164,0.063-0.199,0.063-0.364,0.069c-0.452,0.023-0.329-0.139-0.76-0.139
						c-0.425,0-0.229,0.158-0.66,0.149c-0.961-0.034-1.409-0.249-2.265-0.321c-0.6-0.046-1.208,0.022-1.812-0.012
						c-0.667-0.034-0.875-0.204-1.471-0.259c-0.318-0.031-0.677,0.003-0.99-0.034c-0.041-0.005-0.088-0.011-0.127-0.017
						c0,0-0.188-0.031-0.353-0.109c-0.015-0.006-0.688-0.354-0.089-0.367c0.016,0,2.208,0.011,2.505,0.026
						c0.991,0.048,1.863,0.174,2.849,0.231c5.795,0.319,6.272,0.345,7.257,0.813C61.712,23.415,61.494,23.438,60.97,23.427z
						 M72.386,25.069c-0.017-0.02-0.036-0.037-0.046-0.056c-0.095-0.123-0.036-0.151,0.212-0.108c0.034,0.08,0.082,0.187,0.116,0.271
						L72.386,25.069z M80.863,25.695c-0.202,0.114-0.55,0.164-1.097,0.154c-1.279-0.021-2.251-0.221-3.419-0.313
						c-0.423-0.031-0.565-0.043-1.072,0.014c-0.205,0.023-0.389,0.047-0.589,0.034c-0.013,0-0.036,0-0.048,0
						c-0.211-0.016-0.388-0.068-0.388-0.068c-0.331-0.103-0.532-0.224-0.862-0.333c-0.034-0.011-0.093-0.028-0.118-0.046
						c-0.306-0.121-0.27-0.146-0.235-0.166c0.159-0.115,0.955,0.095,1.467,0.299c0.047-0.109,0.159-0.139,0.484-0.127
						c0.536,0.018,0.93,0.121,1.48,0.135c0.971,0.029,1.962-0.02,2.941,0.029c0.82,0.037,1.319,0.135,1.615,0.192
						C80.992,25.558,80.958,25.638,80.863,25.695z M72.481,27.788c-0.152,0.095-0.837-0.026-1.226-0.218
						c-0.112-0.055-0.188-0.112-0.241-0.17c0.525,0.003,0.677,0.133,1.114,0.167c0.087,0.006,0.171,0.009,0.259,0
						C72.445,27.619,72.574,27.73,72.481,27.788z M73.595,27.814c-0.136-0.009-0.266-0.017-0.395-0.021
						c-0.024-0.003-0.036-0.003-0.059-0.003c-0.4-0.296-0.024-0.289,0.547-0.249C74.119,27.798,73.977,27.832,73.595,27.814z
						 M79.466,28.176c-0.69-0.011-4.156-0.086-4.933-0.35c-0.142-0.046-0.271-0.115-0.366-0.167c0.649-0.015,1.221-0.138,1.934-0.081
						c0.824,0.063,1.06,0.273,1.803,0.362l0.518-0.16c0.884-0.006,3.878,0.018,5.222,0.61C82.501,28.285,81.406,28.217,79.466,28.176z
						 M83.739,28.319l-0.218-0.194l0.372,0.017l0.224,0.195L83.739,28.319z M84.658,28.334c-0.129-0.052-0.17-0.124-0.199-0.164
						c0.542,0.047,0.784,0.139,0.972,0.23C84.74,28.362,84.74,28.362,84.658,28.334z M88.785,27.384c0.011-0.006,0.022-0.015,0.047-0.023
						c0.118-0.055,0.507-0.068,0.837,0.155L88.785,27.384z M101.157,25.772c-0.786-0.243-2.458-0.198-3.119-0.485
						c-0.224-0.098-0.289-0.203-0.331-0.287c0.459,0.095,0.843,0.092,1.675,0.081c1.391-0.018,1.992,0.061,2.592,0.557
						C101.504,25.611,101.479,25.741,101.157,25.772z M108.417,22.771c-0.148,0.146-1.149-0.011-1.563-0.178
						c-0.083-0.034-0.142-0.074-0.177-0.115c0.395-0.034,0.413-0.034,1.173,0.222l0.537-0.058
						C108.423,22.686,108.463,22.727,108.417,22.771z M109.638,22.692c0.082,0.082,0.188,0.194,0.283,0.277
						c-0.082-0.003-0.154,0.009-0.224,0.009c-0.129-0.009-0.378-0.023-0.638-0.138c-0.07-0.032-0.123-0.063-0.169-0.098
						C109.143,22.731,109.313,22.651,109.638,22.692z M112.52,25.876l-0.418-0.014l-0.024-0.013c-0.224-0.108-0.142-0.16-0.004-0.175
						C112.083,25.675,112.88,25.66,112.52,25.876z M118.762,27.835c-0.036-0.009-0.059-0.021-0.089-0.034
						c-0.171-0.073-0.277-0.179-0.248-0.248c0.048-0.105,0.353-0.077,0.359-0.077C118.796,27.479,119.328,27.822,118.762,27.835z"/>
					<path d="M73.801,15.625c-1.103-0.095-2.163,0.097-3.265,0.02c-1.126-0.083-1.746-0.402-3.165-0.35
						c-0.408-0.167-0.697-0.351-1.168-0.506c-0.848-0.028-0.966-0.012-1.309,0.105c-0.849-0.14-2.133-0.347-5.788-0.479
						c-2.069-0.079-2.069-0.079-4.954-1.194c-0.182,0.351-0.182,0.351-0.423,0.432c-2.203-0.075-4.243-0.282-6.376-0.408
						c-1.882-0.112-3.568,0.201-5.43,0.132c-1.351-0.052-2.505-0.224-3.813-0.293c-0.132,0.037-0.289,0.093-0.384,0.138
						c-0.25-0.068-0.577-0.158-0.825-0.224c-0.755,0-1.19,0.25-2.09,0.138c-0.955-0.121-0.415-0.401-1.179-0.546
						c0.117,0.069,0.234,0.145,0.349,0.215c-0.076,0.21-1.293,0.233-1.43,0.435c-1.729-0.368-6.777,0.034-6.118-0.675
						c0.107-0.015,0.248-0.029,0.353-0.04c-0.229-0.354-5.23-0.689-5.282-0.692c0-0.022-0.004-0.055-0.01-0.08
						c0.186-0.023,0.483-0.029,0.688-0.021c0.008-0.003,0.008-0.009,0.064-0.031c-0.237-0.229-0.982-0.407-1.276-0.627
						c3.191-0.063,6.224,0.23,9.401,0.213c0.795,0.235,1.51,0.354,2.738,0.445c2.076,0.158,4.415-0.058,6.398,0.232
						c1.91,0.275,1.91,0.275,6.048,0.472c2.744,0.643,7.18,0.278,10.016,0.867c2.511-0.368,4.326,0.591,6.849,0.178
						c2.192,0.993,2.287,1.034,3.884,0.799c0.043-0.053,0.053-0.13-0.018-0.185c-0.099,0.006-0.228,0.012-0.33,0.018
						c0.03-0.023,0.066-0.052,0.095-0.074c-0.095-0.013-0.216-0.029-0.312-0.041c-0.007,0.021-0.019,0.052-0.019,0.075
						c-0.095,0.008-0.224,0.017-0.323,0.025c-0.136-0.095-0.33-0.221-0.478-0.318c0.283,0.005,0.648,0.011,0.924,0.014
						c0.16-0.048,0.343-0.118,0.442-0.169c0.16,0.04,0.389,0.092,0.589,0.121c1.281-0.107,1.281-0.107,1.722-0.035
						c-0.577-0.512-1.838-0.353-2.216-0.29c-0.024-0.008-4.62-1.021-5.163-1.094c0.26-0.118,0.384-0.241,0.555-0.365
						c0.124-0.014,0.294-0.037,0.43-0.052c1.136,0.115,1.149,0.509,2.622,0.543c1.498-0.299,1.498-0.299-3.719-1.421L60.77,11.01
						l-0.176-0.197c-0.083,0.024-0.196,0.054-0.279,0.079c-2.062-0.428-5.108-0.577-6.515-1.186c-0.82,0.109-1.259-0.127-1.968-0.108
						c-0.036,0.259,1.211,0.474,0.526,0.757c-0.424,0.173-0.583,0.162-2.501,0.053c0.022,0.166,0.134,0.206,1.083,0.367
						c1.449,0.253,3.417,1.681,3.42,1.694c-0.07,0.011-0.17,0.034-0.24,0.052L35.51,11.441c-0.704-0.05-0.85-0.21-1.271-0.319
						c-0.071,0.021-0.167,0.042-0.233,0.063c-0.385-0.021-1.23-0.154-1.238-0.157c0.033-0.023,0.081-0.055,0.119-0.075
						c0.655-0.074,1.199,0.031,1.796,0.058c0.072-0.017,0.164-0.046,0.229-0.063c0.002-0.218,0.002-0.218-4.083-1.094
						c-0.324-0.069-0.324-0.069-1.396-1.014c-0.238-0.015-0.566-0.035-0.806-0.052c-0.639-0.293-1.87-0.471-2.698-0.724
						c-0.445,0.12-0.266,0.276-0.399,0.413c-1.731,0.007-3.073-0.364-4.903-0.258c0.795,0.42,3.201,0.588,3.382,1.105
						c-1.263,0.115-2.331-0.095-3.521-0.112c0.85,0.546,1.387,0.741,2.283,0.833c1.456,0.155,2.063-0.253,3.29-0.253
						c-0.053-0.046-0.145-0.108-0.231-0.149c-0.196-0.014-0.466-0.029-0.676-0.034c-0.333-0.155-0.328-0.173-0.238-0.293
						c1.42-0.203,1.762-0.083,2.672,0.229c0.195,0,0.459-0.025,0.607-0.052c0.101,0.007,0.229,0.021,0.327,0.029
						c0.482,0.355,2.22,0.488,2.817,0.821c-0.481,0.04-0.996,0.006-1.476,0.04c-0.104,0.06-0.116,0.149-0.101,0.215
						c0.804,0.118,1.621,0.232,2.411,0.354c-1.677,0.184-3.166,0.126-6.926-0.258c-1.025-0.109-2.587-0.267-4.07-0.348
						c-0.977-0.052-1.993,0.095-2.964-0.026c-2.479-0.31-2.861-0.358-3.819-0.209c0.462,0.232,0.462,0.232,2.363,0.64
						c-0.454,0.299-1.299,0.855-5.52,0.471C9.776,11.09,9.776,11.09,6.01,9.772c0.092-0.023,0.209-0.055,0.3-0.075
						C7.21,9.694,8.022,9.919,8.983,9.746C8.362,9.04,11.341,7.942,7.051,7.622c-0.075,0.017-0.18,0.034-0.255,0.051
						C5.804,7.145,5.8,6.553,4.745,6.03c-0.9-0.451-0.9-0.451-2.6-0.677C1.74,5.324,1.74,5.324,1.144,5.39
						c0.456,0.325,0.456,0.325,0.352,0.417c-0.224,0.006-0.53,0-0.751-0.006C0.664,5.815,0.558,5.835,0.478,5.852
						c0.553,0.331,3.484,0.478,2.36,0.896c-0.224-0.006-0.521-0.02-0.743-0.031c0.546,0.284,0.923,0.46,2.309,0.79
						C4.853,7.615,6.181,8.374,5.74,8.54c-0.207,0.006-0.498,0-0.688-0.02C5.285,8.804,6.42,9,6.564,9.293
						C6.466,9.315,6.347,9.344,6.255,9.361C5.332,9.169,5.332,9.169,5.023,9.144C2.772,8.973,1.173,8.852,0,8.766v0.327
						c1.702,0.234,1.776,0.226,2.25,0.159C2.35,9.29,2.46,9.344,2.574,9.378c0.688,0.207,2.045,0.127,2.738,0.334
						c0.802,0.235,0.313,0.56,1.112,0.792c0.012,0.006,1.165,0.42,0.871,0.649c-0.42,0.043-0.898,0.006-1.331,0.034
						c-0.047,0.026-0.11,0.063-0.16,0.086c1.286,0.262,2.585,0.457,5.102,0.621c-0.237-0.213-0.237-0.213-0.1-0.351
						c0.454,0.301,0.454,0.301,0.689,0.385c0.021-0.184-0.182-0.364-0.257-0.548c1.038,0.191,2.511,0.191,3.499,0.404
						c0.599,0.133,0.308,0.31,0.496,0.463c12.257,1.079,12.257,1.079,12.558,0.943c7.137,0.874,11.413,1.017,16.825,1.202
						c3.441,0.113,17.158,1.064,17.241,1.072c1.107,0.104,2.044,0.285,3.229,0.354c1.219,0.072,2.31-0.123,3.506-0.089
						c1.74,0.052,3.213,0.304,4.982,0.33c0.931,0.015,1.295-0.02,1.91-0.08C75.104,15.857,74.585,15.69,73.801,15.625z M57.653,12.395
						c0.7,0.034,1.255,0.14,1.891,0.206c0.207,0.262-0.423,0.287-0.991,0.259c-0.989-0.061-1.42-0.241-1.532-0.294
						c-0.07-0.034-0.118-0.074-0.16-0.114C56.973,12.417,57.14,12.361,57.653,12.395z M28.552,9.324
						c-0.081-0.009-0.104-0.025-0.132-0.041c-0.078-0.042-0.112-0.1-0.089-0.128c0.019-0.019,0.069-0.035,0.236,0.02
						C28.979,9.319,28.558,9.321,28.552,9.324z M19.096,11.257c-0.117-0.009-0.419-0.04-0.752-0.242
						c-0.221-0.131-0.324-0.257-0.415-0.361c0.989,0.068,0.989,0.068,1.21,0.144C19.561,10.946,19.913,11.294,19.096,11.257z
						 M19.597,10.97c-0.013-0.034-0.036-0.098,0.092-0.139c0.217-0.068,0.931-0.005,1.198,0.312L19.597,10.97z"/>
					<path d="M1920.116,52.042V36.853c-0.545-0.085-1.064-0.178-1.729-0.297c-0.535,0.115-1.258,0.265-1.793,0.379
						c-0.723-0.052-1.691-0.12-2.42-0.172c0.322-0.333,1.277-0.758,2.26-1.022c0.715,0.04,1.682,0.092,2.4,0.132
						c-0.111-0.146-0.27-0.344-0.389-0.493c-3.264,0.021-6.414-0.276-9.707-0.176c-0.371-0.158-0.867-0.365-1.238-0.521
						c0.297-0.154,0.689-0.361,0.984-0.517c-0.637-0.298-2.199-0.626-3.543-0.758c-3.248-0.315-6.748-0.442-10.119-0.661
						c-0.201-0.166-0.471-0.391-0.672-0.554c1.502-0.187,3.482-0.442,4.949-0.641c-0.162-0.353,0.408-0.855,1.256-1.159
						c8.201,0.459,8.201,0.459,10.414,0.27c-7.391-1.034-7.391-1.034-7.715-1.351c-5.91,0.592-9.484-0.893-14.771-0.854
						c-0.098-0.012-10.719-0.851-18.705,0.074c-4.127-0.325-5.184-0.339-8.303-0.247c-0.945-0.319-2.934-0.987-8.832-0.977
						c-0.365,0.155-0.844,0.356-1.207,0.506c-2.967,0.632-7.361,0.505-10.529,1.028c0.301,0.169,0.695,0.396,0.99,0.563
						c-1.412,0.031-3.4-0.077-4.611-0.247c0.232,0.167,0.539,0.391,0.764,0.555c-5.381,0.468-11.068-0.095-16.486,0.249
						c-0.186,0.164-0.43,0.385-0.625,0.552c-0.537-0.114-1.256-0.267-1.783-0.382l-30.715-1.2c-1.875,0.732-1.875,0.732-6.215,1.025
						l-1.332-0.101c-3.592,0.037-7.143-0.245-10.746-0.061c0.096,0.166,0.242,0.385,0.352,0.551c-7.084,0.087-9.139,0.092-13.203-0.872
						c0.65,0.055,0.84-0.063,0.711-0.164c-0.068-0.074-0.246-0.089-0.305-0.095c-0.406-0.026-0.49,0.028-0.666,0.201
						c-1.564-0.383-3.42-0.891-5.986-1.608c-0.781,0.04-1.813,0.092-2.59,0.132c-0.217-0.077-0.506-0.181-0.713-0.261
						c0.404-0.141,0.936-0.324,1.338-0.463c-1.271,0.196-3.273,0.367-4.801,0.425c-0.842,0.578-3.322,0.864-4.689,1.351
						c-1.52,0.006-3.539-0.047-5.021-0.109c-0.193,0.172-0.457,0.41-0.652,0.586c-2.955,0.218-3.264,0.241-7.424-0.026
						c-1.053,0.222-2.84,0.434-4.23,0.502c-2.561,0.599-2.561,0.599-9.656,0.932c3.018,0.338,3.75,0.396,7.25,0.464
						c0.432,0.147,1,0.343,1.422,0.489c-7.646,0.391-15.674,0.152-23.217,0.709c0.141,0.175,0.33,0.405,0.471,0.577
						c-6.754-0.426-12.996-1.223-20.074-1.422c0.129-0.163,0.285-0.388,0.41-0.551c-3.279-0.715-8.51-0.497-11.717-1.246
						c-0.637,0.105-1.479,0.244-2.111,0.348c-0.705-0.099-1.65-0.23-2.357-0.327c-0.34,0.103-0.785,0.234-1.131,0.333
						c-5.834-0.394-11.957-0.204-17.875-0.438c0.381-0.201,0.885-0.471,1.264-0.671c-9.922-0.822-9.922-0.822-11.725-1.063
						c-0.52,0.118-1.203,0.275-1.715,0.396c-0.441-0.135-1.033-0.31-1.469-0.442c-0.143,0.33-0.943,0.77-1.865,1.028
						c4.727,0.333,10.303-0.178,14.43,0.744c-1.535,0.043-3.6,0.089-5.15,0.118c-0.199-0.041-0.475-0.093-0.684-0.133
						c-0.051,0-6.826,0.098-13.816-0.037c-2.527,0.164-5.094,0.021-7.639,0.046c-0.342,0.172-0.789,0.404-1.131,0.577
						c-0.365-0.152-0.85-0.354-1.211-0.506c-0.725,0.068-1.689,0.155-2.408,0.225c0.389,0.138,0.896,0.326,1.279,0.471
						c-0.756,0-1.752,0.012-2.504,0.018c-0.273-0.155-0.627-0.362-0.904-0.521c-1.469-0.092-3.418-0.221-4.875-0.318
						c-1.371,0.2-3.111,0.508-4.336,0.755c-0.178-0.065-0.412-0.154-0.576-0.221c0.41-0.144,0.977-0.337,1.395-0.479
						c-6.479-0.222-12.75-0.661-19.207-0.902c-0.379,0.086-0.875,0.201-1.252,0.287c-0.691-0.055-1.625-0.129-2.314-0.184
						c0.641-0.106,1.504-0.246,2.139-0.353c4.23,0.364,8.586,0.005,12.861,0.114c-0.014-0.175-0.025-0.408-0.041-0.58
						c1.072,0.235,2.887,0.466,4.32,0.563c0.141-0.361,0.35-0.844,0.533-1.205c0.609,0.105,1.41,0.246,2.025,0.353
						c-0.262,0.187-0.604,0.439-0.859,0.629c0.621-0.092,1.453-0.212,2.072-0.304c-0.4-0.158-0.938-0.368-1.34-0.526
						c0.504-0.131,1.172-0.307,1.68-0.439c-0.74,0.003-1.719,0.006-2.459,0.013c-0.475-0.124-1.113-0.293-1.59-0.42
						c0.096-0.181,0.219-0.426,0.314-0.609c-1.545,0.003-3.607-0.022-5.141-0.058c-0.33-0.16-0.785-0.372-1.121-0.534
						c1.605,0.041,3.736,0.099,5.342,0.146c-0.201-0.178-0.465-0.416-0.666-0.594c-0.785,0.031-1.822,0.069-2.598,0.101
						c-0.486-0.146-1.123-0.342-1.592-0.484c-2.945-0.023-2.945-0.023-9.662,0.647c1.516,0.035,3.537,0.066,5.059,0.081
						c0.205,0.126,0.477,0.293,0.676,0.419c-13.643,0.815-13.979,0.818-17.203,0.856c0.596,0.327,2.139,0.688,3.471,0.867
						c0.33,0.356,1.086,0.818,1.934,1.122c-0.461,0.003-1.084,0.007-1.543,0.01c-0.385-0.182-0.896-0.426-1.281-0.61
						c-0.824-0.025-1.92-0.057-2.744-0.083c0.545,0.118,1.271,0.273,1.814,0.388c0.182,0.092,0.424,0.219,0.607,0.313
						c-1.486,0.026-3.543-0.086-4.813-0.262c-0.123-0.166-0.295-0.385-0.416-0.554c-15.297-0.299-15.297-0.299-17.43-0.888
						c1.551-0.12,3.455-0.413,4.506-0.701c1.031,0.248,2.908,0.479,4.381,0.529c0.496-0.124,1.164-0.29,1.666-0.414
						c-0.346-0.16-0.793-0.375-1.135-0.54c-9.74,0.098-9.74,0.098-11.98-0.43c-0.08,0.108-0.184,0.255-0.27,0.361
						c-4.701-0.379-15.721-1.28-20.934-0.092c-0.277-0.161-0.646-0.374-0.924-0.531c-0.549,0.324-1.457,0.744-2.258,1.043
						c-4.623-0.228-7.252,0.798-11.328,0.916c-0.383,0.163-0.908,0.384-1.297,0.548c-0.697-0.081-1.627-0.184-2.316-0.265
						c0.068,0.179,0.164,0.42,0.236,0.604c-0.799-0.022-1.852-0.046-2.648-0.063c-0.324-0.152-0.762-0.356-1.084-0.511
						c-0.742-0.009-1.721-0.023-2.463-0.034c0.129,0.178,0.305,0.413,0.449,0.597c-1.164,0.032-1.164,0.032-6.432-0.45
						c0.082,0.169,0.193,0.393,0.283,0.56c-0.807-0.018-1.895-0.041-2.705-0.057c-0.217-0.168-0.496-0.388-0.695-0.553
						c-0.738-0.017-1.717-0.037-2.455-0.055c-0.35,0.146-0.818,0.34-1.166,0.486c-0.646-0.099-1.504-0.225-2.15-0.321
						c-0.736,0.097-1.729,0.235-2.461,0.332c-1.377-0.135-3.262-0.287-4.701-0.379c0.219,0.167,0.508,0.379,0.729,0.54
						c-1.479-0.129-3.34-0.385-4.498-0.632c-0.58,0.118-1.334,0.272-1.912,0.391c-0.682-0.068-0.682-0.068-0.932-0.126
						c0.084-0.012,0.201-0.029,0.281-0.043c-0.166-0.021-0.41-0.047-0.6-0.061c-1.867-0.098-3.961,0.342-5.68-0.12
						c-0.279,0.261-0.592,0.393-1.475,0.614c-1.174-0.104-2.086-0.342-3.451-0.356c-1.229-0.438-1.229-0.438-1.828-0.454
						c0.152,0.207,0.293,0.241,1.412,0.529c-1.633,0.218-2.676,0.608-4.49,0.77c-0.779,0.068-0.566-0.268-1.367-0.259
						c-0.33,0.333-1.971,0.448-2.43,0.758c-1.025-0.074-2.121,0.123-3.127-0.043c-0.031-0.003-3.09-0.555-3.986-1.131
						c-0.879-0.009-1.467-0.187-2.34-0.199c0.047-0.126-0.072-0.338,0.363-0.419c1.512,0.031,1.512,0.031,1.861-0.058
						c-0.227-0.511-3.182-0.184-4.324-0.482c-0.877,0.021-0.826,0.299-1.721,0.316c0.908,0.379,1.043,0.437,2.238,0.468
						c-0.174,0.311-2.014,0.287-2.266,0.58c-0.551-0.112-1.287-0.262-1.836-0.373c-0.783,0.043-0.594,0.295-1.4,0.33
						c0.975,0.227,0.699,0.557,1.34,0.815c-2.064,0.256-4.709,0.022-6.639,0.396c-0.35-0.132-1.32-0.084-1.494-0.268
						c-0.354,0.035-0.354,0.035-0.303,0.313c-0.168,0.022-0.373,0.052-0.916,0.012c-0.018-0.018-0.029-0.04-0.041-0.055
						c0.107-0.032,0.23-0.078,0.252-0.118c-0.229-0.017-0.459-0.023-0.699-0.023c-0.26,0.225-0.268,0.356-0.041,0.558l10.131,0.431
						c2.309,0.038,4.633,0.075,6.943,0.106c0.354-0.157,0.578-0.191,1.215-0.123l0.635,0.396l3.463,0.152l-3.496-0.152
						c0.021,0.006,0.039,0.013,0.057,0.018c-5.904,0.311-8.049,0.261-11.15-0.034c-0.135-0.08-0.305-0.189-0.434-0.276
						c0.809-0.031,1.916-0.068,2.744-0.086c-2.934-0.074-6.846-0.166-9.773-0.241c0.227,0.173,0.221,0.419,0.047,0.595
						c-2.449-0.031-2.449-0.031-3.742,0.232c-0.455-0.115-1.248-0.235-1.904-0.283c-1.479,0.317-2.83,0.422-6.932,0.186
						c-0.412,0.145-0.859,0.351-1.057,0.512c1.18,0.272,1.18,0.272,4.746,0.413c0.42-0.097,0.982-0.227,1.393-0.324
						c0.885,0.189,1.51,0.439,2.582,0.58c-0.084,0.373-0.084,0.373-1.91,0.767c0.402,0.351,1.613,0.646,1.344,1.039
						c-0.861,0.046-1.99,0.138-2.795,0.224c-2.395-0.221-2.395-0.221-4.207-0.258c-0.238,0.074-0.551,0.172-0.777,0.247
						c-1.314-0.04-2.475-0.213-3.82-0.235c-0.264,0.058-0.619,0.129-0.883,0.184c-1.309-0.063-2.666-0.04-3.971-0.104
						c0.152-0.262,0.152-0.262-0.438-0.977c3.08,0.023,3.08,0.023,3.371-0.002c-0.049-0.081-0.117-0.189-0.166-0.271
						c-2.336-0.089-2.336-0.089-3.271-0.293c-0.936,0.015-2.313-0.003-3.084-0.123c-0.092,0.025-0.197,0.049-0.342,0.063
						c-0.006,0-0.014,0-0.014,0c-0.055,0.003-0.104,0.006-0.156,0.006h-0.006h-0.01c0.139-0.051,0.318-0.077,0.527-0.068
						c-0.021-0.173-0.055-0.401-0.061-0.574c0.598,0.108,1.264,0.286,1.672,0.433c0.359-0.008,0.832-0.025,1.184-0.037
						c-0.352-0.138-0.646-0.351-0.67-0.505c1.447-0.204,3.145-0.235,4.721-0.351c0.275,0.063,0.646,0.149,0.922,0.212
						c0.201-0.063,0.459-0.149,0.664-0.212c0.637,0.058,1.59,0.077,2.273,0.052c-3.172-1.017-8.512,0.187-11.908-0.592
						c-1.143,0.015-2.297-0.04-3.42,0.044c-0.592-0.107-1.324-0.259-1.834-0.383c0.123-0.092,0.279-0.218,0.404-0.313
						c-0.309-0.042-0.713-0.103-1.02-0.148c-0.061,0.158-0.092,0.376-0.074,0.536c-0.455-0.113-0.799-0.327-0.762-0.481
						c-1.289-0.179-2.436-0.407-3.678-0.604c-0.203,0.161-0.533,0.367-0.828,0.517c-0.338-0.034-0.787-0.074-1.129-0.108
						c-0.094-0.152-0.541-0.348-1.039-0.453c-0.377,0.146-0.623,0.372-0.68,0.545c-0.449-0.167-0.857-0.419-1.035-0.612
						c-1.68,0.078-1.744,0.081-3.824-0.031c-0.324-0.144-0.568-0.354-0.578-0.514c-0.6,0.393-0.6,0.393-17.01-0.244
						c-0.508,0.138-1.203,0.313-1.732,0.442c-0.484-0.127-1.275-0.265-1.92-0.345c-0.516,0.109-1.074,0.293-1.371,0.437
						c-0.885-0.46-3.182-0.54-4.514-0.882c-3.494-0.014-3.494-0.014-4.066,0.003c2.033-0.598,2.033-0.598,3.191-0.715
						c0.252,0.063,0.594,0.146,0.84,0.209c0.365-0.149,1.037-0.327,1.592-0.445l-3.279-0.123l-0.023,0.109l-1.672-0.063l0.023-0.107
						c-28.301-0.984-28.951-0.933-30.52-0.807c0.873,0.469,0.873,0.469,5.135,0.561c0.383,0.17,0.953,0.393,1.418,0.558
						c-1.535,1.014-7.232,0.1-9.076,0.984c-1.604-0.241-4.031,0-5.26-0.46c-0.268,0.638,1.295,1.022,3.982,0.985
						c-0.17,0.083-0.396,0.192-0.574,0.272c-3.004,0.242-3.004,0.242-3.582,0.327c-0.578-0.103-1.473-0.2-2.168-0.25
						c-0.148,0.285,0.246,0.566,0.139,0.85c-0.836,0.029-1.924,0.165-2.428,0.319c-1.742-0.27-3.924-0.327-5.711-0.579
						c-4.678,0.299-4.678,0.299-5.893,0.235c-0.361-0.136-1.129-0.282-1.775-0.34c-0.295,0.145-0.471,0.364-0.4,0.521
						c-0.254-0.061-0.592-0.144-0.852-0.207l-1.127,0.21c-4.871-0.453-4.834-0.942-3.938-1.27c-0.799-0.098-0.799-0.098-4.775-0.224
						c-0.217-0.063-0.508-0.155-0.727-0.225c2.814-0.046,2.814-0.046,3.473-0.123c-0.225-0.071-0.518-0.163-0.744-0.236
						c-3.643-0.1-3.643-0.1-5.043-0.019c0.447,0.131,0.92,0.335,1.059,0.499c-1.373,0.111-2.873,0.146-4.146,0.321
						c0.422,0.132,0.91,0.316,1.197,0.456c3.102,0.104,2.844,0.914,5.006,1.215c1.512,0.21,3.297-0.022,4.83,0.152
						c-0.43,0.123-1.264,0.241-1.92,0.288c0.656,0.238,1.965,0.313,2.707,0.531c-0.281,0.058-0.674,0.132-0.965,0.188
						c-1.35-0.253-1.674-0.315-3.449-0.074c-1.154-0.074-2.387-0.057-3.531-0.138c-0.232,0.166-0.822,0.376-1.414,0.488
						c0.34,0.218,0.836,0.505,1.262,0.718c1.135,0.086,3.061,0.164,5.832,0.046c-0.043,0.195-0.318,0.459-0.658,0.643
						c-0.611-0.063-1.57-0.086-2.232-0.051c0.322,0.022,0.766,0.061,1.096,0.085c-2.256,0.265-5.191-0.092-7.193,0.408
						c-0.334-0.034-0.781-0.078-1.111-0.109c-0.117,0.078-0.291,0.182-0.41,0.259c-2.076-0.224-2.076-0.224-4.184-0.982
						c-2.984-0.126-6.033-0.149-9.02-0.275c-0.225,0.012-0.51,0.023-0.725,0.029c-1.172-0.218-1.172-0.218-4.463-0.196
						c-0.189,0.081-0.447,0.185-0.643,0.262c-2.918-0.666-2.918-0.666-5.203-0.548c-0.268-0.047-0.627-0.115-0.885-0.161
						c0.99-0.114,0.99-0.114,3.445-0.146c0.453-0.121,1.045-0.284,1.494-0.404c3.365,0.12,3.365,0.12,6.035,0.574
						c0.342-0.018,0.791-0.04,1.129-0.058c0.201,0.06,0.484,0.144,0.703,0.206c5.676-0.321,3.926-0.861,1.02-1.763
						c-3.066,0.167-3.303,0.16-5.469,0.052c-0.338-0.152-0.662-0.374-0.785-0.539c0.373-0.032,0.867-0.07,1.238-0.104
						c0.973,0.144,2.211,0.13,3.164,0.279c0.201-0.066,0.459-0.153,0.664-0.222c-0.688-0.08-1.51-0.224-2.076-0.344
						c-2.027,0.188-4.48-0.099-6.33,0.286c0.232,0.149,0.563,0.351,0.799,0.5c-2.143-0.265-4.051-0.615-6.152-0.898
						c-0.258-0.768,1.211-0.894,2.387-0.991c-0.867-0.46-0.49-0.597,0.732-0.939c0.383,0,0.891,0,1.277,0
						c1.879,0.571,1.879,0.571,4.094,0.624c0.092-0.108,0.209-0.253,0.305-0.362c0.941-0.034,2.158-0.144,2.969-0.256
						c0.059-0.077,0.117-0.187,0.166-0.266c0,0,0,0,0.012,0.005c-0.209-0.963-0.209-0.963-1.559-1.223
						c-0.303,0.057-0.705,0.129-1.01,0.184c-0.643-0.098-1.275-0.316-1.463-0.488c-0.857-0.072-0.857-0.072-3.43-0.729
						c-0.699,0.031-1.662,0.063-2.379,0.068c-0.453-1.039-0.438-1.108-0.205-1.524c0.691,0.037,1.627,0.083,2.328,0.106
						c0.207,0.068,0.479,0.166,0.693,0.235c0.18-0.072,0.43-0.173,0.611-0.244c-0.006,0-0.012,0-0.018,0
						c0.117-0.279-0.184-0.518-1.006-0.796c-1.299,0.118-2.652,0.238-4.162-0.005c-0.602-0.102-0.822-0.262-0.885-0.316
						c-0.25-0.179-0.119-0.362-0.26-0.546c-0.016-0.018-0.053-0.039-0.076-0.06c-0.523,0.071-1.166,0.163-1.488,0.433
						c-0.404,0.34-0.146,0.693-0.264,1.034l3.236,0.104c-1.111-0.036-2.246-0.07-3.205-0.099c-0.385,0.466-0.385,0.466-1.787,0.614
						c-0.33-0.13-1.078-0.27-1.717-0.318c-0.074,0.164-0.164,0.382-0.229,0.542c0.264,0.07,0.615,0.164,0.873,0.235
						c-0.365,0.078-0.842,0.182-1.203,0.265c0.227,0.058,0.525,0.139,0.754,0.201c-0.301,0.339-0.744,0.666-0.965,1.005
						c0,0.006,0.854,1.896,1.014,2.516c0.676,0.074,1.486,0.219,1.979,0.348c0.354-0.02,0.828-0.052,1.178-0.071
						c0.297,0.039,0.68,0.097,0.967,0.141c-0.129,0.077-0.309,0.187-0.447,0.261c-2.02,0.052-2.02,0.052-4.139-0.017
						c-0.174-0.075-0.408-0.173-0.582-0.247c0.361-0.015,0.842-0.038,1.203-0.052c-0.561-0.109-1.49-0.21-2.223-0.241
						c-1.166-1.517,0.695-3.096-1.908-4.584c-0.332,0.142-0.975,0.312-1.557,0.403c0.082,0.092,0.189,0.212,0.271,0.304
						c-0.271,0.052-0.625,0.121-0.885,0.173c-0.453-0.54-0.482-0.547-2.25-0.765c-0.039-0.04-0.072-0.098-0.107-0.141
						c-0.178,0.354-0.178,0.354,0.471,0.882l-1.578,3.133c-0.592,0.095-1.273,0.255-1.65,0.394c-0.35-0.006-0.814-0.009-1.17-0.018
						c0.086,0.093,0.178,0.213,0.252,0.305c5.066,0.462-0.119,1.814,2.955,2.533c0.402-0.021,0.939-0.044,1.338-0.064
						c0.865-0.912,0.795-1.211,0.682-1.754c2.719,0.182,2.719,0.182,8.297-0.025c0.021,0.166-0.035,0.391-0.156,0.554
						c0.693,0.038,1.594,0.106,2.254,0.164c-0.277,0.063-0.635,0.149-0.908,0.212c-1.852-0.293-2.096-0.332-7.965,0.305
						c-0.215,0.178-0.197,0.437-0.043,0.617c1.941,0.138,2.033,0.291,2.18,0.566c-0.783,0.011-1.848,0.011-2.623-0.006
						c-1.344,0.37-1.344,0.37-4.229,0.441c-0.658,0.311-0.658,0.311-0.83,0.856c0.355,1.332,0.355,1.332-2.074,1.406
						c-0.807-0.938-0.656-1.31-0.598-1.487c0.352-0.339,0.438-0.428,1.518-0.35c-0.141-0.259-1.379-0.414-1.227-0.695
						c0.043-0.077,0.389-0.111,0.477-0.182c0.219-0.146,0.254-0.301,0.408-0.45c0.293-0.281,1.264-0.351,1.271-0.351
						c-0.363-0.321-1.719-0.49-2.365-0.769c-0.049-0.044-0.115-0.104-0.154-0.146c-2.977,0.221-0.023,1.082-2.57,1.386l-0.055,1.482
						c0.018,0.694,0.049,1.628,0.064,2.329c0.346,0.017,0.793,0.037,1.133,0.055c0.379,0.474,0.379,0.474-1.25,0.993l0.006,0.361
						c-0.27-0.229-0.697-0.43-1.41-0.579c0.275-0.265,0.275-0.265-0.492-0.728c0.541-0.055,1.314-0.1,1.902-0.105l0.047-2.326
						c-21.717-0.54-48.926-1.212-73.258-1.81c1.242,0.34,3.857,1.189,3.879,1.197c0.59,0.21,0.541,0.282,0.455,0.422
						c0.924-0.017,1.148,0.268,2.066,0.254c0.084,0.259,1.045,0.484,0.523,0.76c-1.775-0.1-2.484-0.234-3.986-0.755
						c-0.428-0.144-0.945-0.324-1.605-0.453c-0.117-0.023-0.283-0.052-0.406-0.075c0.041-0.218,0.037-0.258-0.486-0.488
						c-0.16-0.065-0.535-0.223-0.496-0.333c0.01-0.043,0.135-0.109,0.051-0.151c-0.279-0.146-0.947-0.23-1.211-0.377
						c-0.014-0.011,0-0.02,0.002-0.031c-7.139-0.176-14.057-0.347-20.451-0.503c0.672,0.356,0.756,0.359,2.104,0.435
						c0.055,0.055,0.055,0.055,4.016,1.708c-2.016-0.052-2.271-0.58-3.891-0.738c0.119-0.058,0.281-0.135,0.412-0.192
						c-0.447-0.021-1.047-0.046-1.496-0.068c-1.238-0.442-2.205-0.916-3.371-1.367c-20.393-0.45-47.578-1.051-67.971-1.501
						c-0.113,0.65-0.527,2.833-1.201,3.49c-0.381,0.021-0.885,0.047-1.266,0.067c-1.041,0.901-1.041,0.901-2.732,1.082
						c-1.031-0.474-1.533-0.996-2.438-1.479c0.031-0.063,0.092-0.149,0.141-0.212c-0.189-0.048-0.438-0.115-0.615-0.163
						c0.623-0.904,0.684-1.482,0.309-2.944c-0.881-0.017-2.051-0.04-2.928-0.058c0.012,0.526,0.012,0.526-2.107,2.481
						c0.221,0.044,0.529,0.104,0.756,0.144l-0.744,0.374l0.465,0.286c-2.787,1.281,4.615,3.002-2.539,4.032
						c0.4,0.093,0.934,0.213,1.34,0.298c-2.367,1.316-1.6,2.105-1.316,2.404c19.498,0.37,42.885,0.881,65.465,1.387
						c-22.566-0.471-45.953-0.931-65.414-1.337c0.125,0.129,0.041,0.313-0.133,0.436c-0.566,0.034-1.299,0.097-1.811,0.157
						c-0.148,0.146-0.537,0.343-0.955,0.46c0.1,0.077,0.229,0.184,0.324,0.259c-0.52,0.061-1.086,0.192-1.391,0.305
						c-0.535-0.052-1.26-0.106-1.809-0.144c2.09,0.629-0.832,1.215-1.775,1.381c-0.26-0.023-0.605-0.055-0.873-0.077
						c-0.246,0.025-0.584,0.061-0.838,0.089c0.184,0.379,0.184,0.379-1.613,1.32c-2.439-0.345-2.439-0.345-0.26-2.158
						c0.342,0.021,0.799,0.056,1.154,0.082c-0.064-0.065-0.141-0.152-0.201-0.215c-0.295,0.011-0.688,0.028-0.99,0.04
						c0.119-0.077,0.285-0.185,0.402-0.258c1.158-0.121,2.453-0.162,3.547-0.316c-0.281-0.029-0.67-0.068-0.953-0.098
						c-0.52,0.049-1.295,0.063-1.846,0.04c0.107-0.058,0.242-0.138,0.344-0.192c-1.045-0.319-2.33-0.712-0.75-1.352
						c0.018-0.196-0.896-0.285-1.025-0.466c-0.16-0.218,0.438-0.425,0.23-0.649c-0.041-0.043-0.252-0.092-0.359-0.132
						c-0.654-0.241-1.086-0.58,0.578-0.81c-0.168-0.454-0.191-0.523,0.662-0.552c-0.025-0.17-1.039-0.218-0.898-0.401
						c0.135-0.179,0.354-0.222,1.557-0.448c-0.939-0.477-0.652-1.061-2.475-1.456c-0.084,0.364-1.344,2.13-1.355,2.146
						c-0.061,0.068-0.408,0.132-0.639,0.178c0.09,0.229,0.521,0.287,1.379,0.407c-2.816,0.661-0.816,0.876-0.152,0.948
						c-0.367,0.089-0.99,0.065-1.344,0.157c-0.459-0.071-0.381-0.197-0.555-0.299c-0.207-0.008-0.486-0.008-0.684-0.003
						c-0.111,0.265,1.189,0.429,0.941,0.701c-0.227,0.241-1.438,0.247-1.975,0.414c-0.275-0.133-2.633-1.31,0.434-1.597
						c-1.227-0.294-0.438-2.872,0.506-3.116c-0.934-0.301-1.557-0.445-2.703-0.617c0.205-0.356,0.205-0.356-0.91-0.738
						c1.225-0.152,1.225-0.152,1.078-0.308c-0.389-0.036-0.906-0.08-1.297-0.12c0.564-0.152,0.32-0.37,0.785-0.534
						c0.111-0.003,0.264-0.008,0.369-0.011c-1.744-0.311-1.744-0.311-2.316-0.592c-0.795,0.103-1.43,0.023-2.115-0.265
						c0.383-0.021,0.889-0.052,1.273-0.068c-0.717-0.713,1.137-1.373,0.873-2.074c-1.154-0.017-2.699-0.04-3.861-0.055
						c-0.066,0.018-0.158,0.038-0.229,0.055c-0.215-0.014-0.479-0.051-0.637-0.089c-0.012-0.003-0.721-1.156-0.689-1.357
						c0.021-0.179,0.523-0.322,0.67-0.489c0.525-0.585-0.611-1.15-0.336-1.728c0.061-0.153,0.557-0.327,0.908-0.457
						c-0.484-0.417-0.484-0.417-0.961-0.503c0.855-0.545,0.879-0.775,0.723-1.303c-0.15-0.495,0.107-0.54,0.779-0.604
						c-0.611-0.138-0.611-0.138-0.094-0.678c-0.277-0.092-0.646-0.207-0.92-0.299c0.873-0.778,0.934-1.292,0.969-2.809
						c0.002,0,0.008,0,0.008,0c0.049-0.971,0.049-0.971,0.648-2.113c-0.906,0-0.619-0.265-1.289-0.327
						c0.303-0.293,0.678-0.66-0.689-1.344c-0.094-0.04-0.223-0.092-0.318-0.127c-1.631,0.448-1.932,0.532-2.369,0.781
						c-0.416,0.235,0.119,0.488-0.156,0.724c-0.211,0.178-1.047,0.275-1.221,0.46c-0.035,0.034,0.07,0.074,0.1,0.108
						c0.016,0.018,1.148,1.394-2.117,1.603c0.023,0.003,0.051,0.009,0.068,0.012c0.139,0.028,0.275,0.058,0.381,0.092
						c0.154,0.003,0.33,0.007,0.494,0.01c-0.174-0.003-0.361-0.007-0.525-0.01c0.736,0.281-0.73,0.437-0.742,0.678
						c-0.012,0.154,0.701,0.341,0.678,0.5c-0.01,0.065-0.1,0.154-0.146,0.221c-0.877,1.148-1.496,1.194-1.785,1.218
						c-0.744,0.055-0.803,0.078-0.66,0.256c-0.129-0.021-0.129-0.021-0.918-0.402c-0.123-0.003-0.297-0.012-0.426-0.018
						c-0.059-0.278,1.656-0.437,0.998-0.752c-1.148-0.046-2.338-0.087-4.377,0.481c-0.654,0.188,1.049,0.254,1.08,0.442
						c-0.082,0.013-0.184,0.026-0.262,0.035c-0.045,0.006-0.082,0.012-0.246,0.022c-1.314,0.029-1.709-0.258-2.064-0.6
						c-1.424-0.021-2.557-0.244-3.961-0.278c-0.582,0.35-0.6,0.729-1.24,1.076c-0.586,0.313-0.775,0.336-1.541,0.428
						c0.492,0.351-0.26,0.692-0.098,1.04c0.037,0.109,0.674,0.224,0.723,0.333c0.012,0.034,0.006,0.081,0.012,0.115
						c-0.012,0.075-0.402,0.138-0.682,0.186c-0.65,0.11-0.613,0.173-0.514,0.352c-1.072-0.05-1.963-0.207-3.037-0.259
						c-0.27-0.821,0.543-1.634,0.428-2.455c-0.049-0.37-0.951-0.7-0.934-1.074c0.012-0.195,0.164-0.224,0.719-0.339
						c-0.836-0.098-1.861-0.098-2.627-0.235c-0.072,0.023-0.201,0.052-0.232,0.081c-0.383,0.327,0.338,0.653-0.021,0.98
						c-0.26,0.23-1.42,0.322-1.668,0.553c-0.049,0.036-0.096,0.089-0.129,0.129c-0.072,0.077,0.068,0.186,0.164,0.267
						c-2.063,0.718-3.186,1.54-4.822,2.303c-0.213,0.096-0.666,0.204-0.789,0.311c-0.281,0.224,1.076,0.29,0.979,0.499
						c-0.273,0.575-2.223,1.086-1.369,1.712c-1.391,0.592-1.008,1.295-2.369,1.89c-0.555,0.157-0.738,0.184-1.488,0.253
						c0.016,0.034,0.025,0.08,0.043,0.114c0.373,0.069,0.373,0.069,1.295,0.096c-0.307,0.35-0.445,0.45-1.596,0.456
						c1.014,0.401,1.014,0.401-0.959,1.315c-0.707,0.333,0.396,0.644,0.252,0.965c-0.063,0.141-0.309,0.321-0.506,0.457
						c-0.424,0.302-1.102,0.582-1.455,0.889c-0.168,0.159,0.207,0.4-0.164,0.537c-0.945,0.354-2.713,0.461-4.051,0.693
						c0.07,0.101,0.154,0.231,0.221,0.33c-0.238,0.029-0.541,0.068-0.762,0.103l1.201,3.819c-37.133-0.568-75.148,2.292-111.468-1.473
						c0.224-0.411,0.224-0.411-0.171-0.542c1.508,0.097,1.726,0.16,1.94,0.565c32.924,0.387,76.793,1.013,109.699,1.449
						c-0.414-1.137-0.959-2.659-1.379-3.796c-0.477,0.04-1.154,0.071-1.662,0.074c-0.08-0.04-0.184-0.092-0.252-0.132
						c2.83-0.398-0.098-1.103,1.633-1.556c0-0.006,0.006-0.006,0.012-0.006c0.209-0.069,0.191-0.13-0.055-0.219l-0.025-0.006
						l-0.023-0.074c-0.344-1.031-0.803-2.406-1.154-3.44c-0.18,0.028-0.432,0.063-0.611,0.092c0.637,0.305,0.549,0.339-0.059,0.552
						c-1.061-0.161-1.834-0.414-3.111-0.511c-0.096,0.333-1.014,0.643-0.633,0.995c0.281,0.032,0.672,0.075,0.957,0.107
						c0.221-0.023,0.516-0.053,0.734-0.081c0.336,0.052,0.689,0.155,0.795,0.241c-0.178,0.026-0.424,0.061-0.607,0.086
						c-0.76-0.063-1.482-0.149-2.242-0.218c-0.143,0.224-0.572,0.431-0.699,0.655c-2.357,0.082-2.357,0.082-3.01,0.137
						c0.658,0.397,0.658,0.397,0.008,0.626c-0.473-0.005-1.104-0.034-1.547-0.074c0.59,0.522,0.596,0.534-0.252,0.771
						c-0.242-0.053-0.561-0.115-0.803-0.167c0.285-0.081,0.762-0.165,1.156-0.216c-3.1-0.83,0.004-1.74-0.703-2.599
						c-2.154-0.222-2.381-0.245-3.923-0.253c-1.023,0.721-1.818,1.453-2.7,2.177c-2.49-0.105-2.49-0.105-2.717-0.086
						c0.299,0.104,0.646,0.24,0.873,0.35c-0.16,0.035-0.339,0.093-0.528,0.115c-2.488,0.302-3.665,0.046-3.519-0.772
						c0.348-0.06,0.845-0.129,1.244-0.167l-0.459-0.191c2.262-0.713,1.898-2.927,1.886-2.947c-4.223-0.022-9.866-0.052-14.096-0.073
						c-0.241,0.086-0.707,0.184-1.118,0.223c-0.252,0.609-0.252,0.609-1.903,1.706c-0.012,0-1.108-0.598-1.672-1.125
						c0.216-0.015,0.517-0.031,0.741-0.044c-1.66-0.163-1.66-0.163-2.476-0.163c0.023,0.098,0.164,0.227,0.342,0.315
						c-1.792,0.155-2.298,0.408-2.254,1.123c-0.368,0.055-0.858,0.129-1.224,0.187c0.253,0.46-1.792,0.839-0.953,1.32
						c-0.953,0.173-1.8,0.38-2.809,0.537c-0.505-0.06-1.355-0.163-1.333-0.499c0.086-1.307,1.77-2.596,0.982-3.917
						c-1.117-0.009-2.602-0.025-3.704-0.049h-0.069c-0.474-0.008-1.12,0.012-1.557,0.053c0.942,0.412,1.02,0.47,0.236,0.786
						c-1.861-0.17-2.194-0.385-2.789-0.896c-0.56-0.485-1.019-0.621-2.432-0.724c0.641-0.679-1.618-1.173-2.189-1.77
						c-0.182-0.195,0.09-0.391-0.154-0.586c-0.277-0.225-1.179-0.373-1.442-0.6c-0.313-0.262,0.083-0.531-0.2-0.79
						c-0.146-0.138-0.685-0.221-0.907-0.347c-0.75-0.424-0.042-0.908-0.974-1.327c-0.254-0.113-1.15-0.187-1.255-0.311
						c-0.129-0.141,0.589-0.146,0.771-0.241c0.013-0.003-0.494-1.002-1.738-1.474c-0.224-0.048-0.531-0.111-0.755-0.16
						c-0.437,0.775,1.314,1.476,1.486,2.237c0.052,0.272-0.979,0.487-0.844,0.767c0.07,0.152,0.879,0.195,0.974,0.339
						c-0.584,0.149-0.719,0.184-0.755,0.367c0.165,0.092,0.579,0.207,0.555,0.304c-0.048,0.162-0.625,0.274-0.754,0.426
						c-0.495,0.643,1.532,1.154,1.756,1.761c0.06,0.154,0.06,0.154-0.631,0.657c-0.229,0.166,0.507,0.272,0.513,0.425
						c0.011,0.144-0.872,0.166-0.801,0.315c0.083,0.195,1.208,0.279,1.025,0.5l-0.484,0.104c-0.129,0.017-0.306,0.043-0.437,0.066
						c-0.199-0.026-0.458-0.058-0.659-0.084c-2.971-0.011-6.933-0.023-9.902-0.034c-0.531,0.448-0.531,0.448,0.01,0.676
						c-0.376,0.054-0.871,0.12-1.249,0.174c0.459,0.139,1.061,0.253,1.425,0.405c-1.513,1.152-0.448,2.421-3.159,3.521
						c-1.756-0.264-1.756-0.264-2.21-0.31c1.149-1.152-1.003-2.33,0.537-3.473c-1.15-0.351-0.685-0.786-1.286-1.16
						c-3.195-0.031-7.451-0.068-10.644-0.092c-0.573,0.213-0.573,0.213,0.465,0.861c-0.218,0.019-0.512,0.034-0.736,0.053
						c-0.919-0.213-0.974-0.225-1.192-0.978c-0.636,0.023-1.483,0.053-2.121,0.075c-0.495,0.362-0.495,0.362-1.179,0.549
						c-0.484-0.265-0.755-0.411-2.748-0.618c0.296,0.127,0.685,0.291,0.979,0.414c-0.389,0.154-1.055,0.246-1.602,0.364
						c0.153,0.549-0.402,1.095-0.249,1.64c-0.655-0.071-0.655-0.071-2.865-0.521c-0.194,0.016-0.448,0.034-0.636,0.052
						c0.035,0.372-1.461,0.626-1.509,0.99c-0.042,0.336,1.378,0.565,1.273,0.904c-0.013,0.058-0.283,0.12-0.402,0.173
						c-0.364-0.053-0.824-0.124-1.167-0.185c-0.181,0.02-0.435,0.046-0.623,0.063c2.287,0.571-0.178,1.347,1.626,1.938
						c-1.993,0.887-0.249,1.854-1.108,2.765c-0.884-0.045-1.538-0.227-2.517-0.218c0.006-0.589,1.397-1.116,1.421-1.706
						c0.01-0.385-1.245-0.691-1.311-1.073l0.249-0.385l0.755-0.288c-2.724-0.804,0.766-2.084-4.062-2.73
						c0.808-0.152,0.913-0.201,0.63-0.681c-1.615-0.178-1.615-0.178-2.352-0.146c-0.334,0.164-0.583,0.33-0.826,0.5
						c-1.13-0.055-1.13-0.055-5.25-2.183c-0.915,0.026-2.133,0.052-3.054,0.071c0.707,0.673-0.909,1.342-0.013,2.011
						c-0.365,0.052-0.847,0.121-1.208,0.179c0.017,0.014,1.503,1.918-0.607,2.688c1.621,1.091,1.162,1.315-1.061,1.441
						c0.005,0.181,0.005,0.181,1.014,0.49c-0.354,0.133-0.354,0.133,0.96,1.255c-0.458,0.035-1.065,0.081-1.532,0.115
						c0.313,0.072,0.831,0.149,1.262,0.172c-4.603,0.322-4.603,0.322-3.908,0.689c0.89,0.031,0.926,0.034,2.039-0.134
						c0,0.065,0,0.157,0,0.226c-0.471,0.049-1.037,0.139-1.407,0.222c0.229,0.037,0.534,0.089,0.758,0.129
						c0.326-0.068,0.674-0.181,0.826-0.27c1.097,0.105,1.875,0.634,1.781,0.85c-0.49,0.009-1.142,0.028-1.631,0.051l-0.88-0.01
						c-0.754,0.045-1.768,0.103-2.529,0.149c0.03,0.086,0.076,0.2,0.114,0.289c-0.372,0.038-0.862,0.083-1.234,0.124
						c-0.489-0.17-0.983-0.419-1.137-0.617c-21.62-0.21-50.442-0.492-72.056-0.699c0.355,0.17,0.667,0.414,0.773,0.604
						c-0.354,0.051-0.839,0.117-1.198,0.169c-0.559-0.365-0.689-0.48-0.737-0.89c-0.918-0.01-2.127-0.021-3.039-0.033
						c-1.004,0.521,3.051,3.748,4.785,5.124c-0.178,0.086-0.408,0.201-0.584,0.287l-6.389-2.878c-2.775-2.085-2.775-2.085-5.665-2.016
						c0.578,0.948-2.057,1.897,0.048,2.841c0.376-0.012,0.867-0.032,1.238-0.043c-0.283-0.173-0.549-0.414-0.696-0.598
						c0.354,0.022,0.825,0.051,1.186,0.074c0.594,0.382,5.777,3.772,4.951,4.741c-0.148,0.163,0.69,0.37,1.268,0.477
						c-0.685,0.049-1.722,0.037-2.394-0.021c-0.059-0.341-0.607-2.096-4.973-3.195c-0.078,0.198-0.09,0.468-0.06,0.675
						c-0.367-0.034-0.85-0.072-1.215-0.104c-1.385-0.982-2.499-1.991-3.973-2.969c0.188-0.07,0.448-0.167,0.636-0.236
						c-1.119-0.631-1.119-0.631-2.375-0.814c0.042,0.11,0.094,0.258,0.135,0.367c-0.271,0.06-0.63,0.137-0.896,0.191
						c-1.196-0.175-1.638-0.238-1.531-0.758c-0.365-0.021-0.849-0.046-1.215-0.065c0.731-0.592-0.99-1.275-1.013-1.281
						c-0.966,0.032-2.251,0.074-3.219,0.106c0.019,0.015,1.475,1.604,0.389,2.182c0.525,0.201,0.525,0.201,1.019,3.449
						c1.9,0.228,2.895,0.401,0.691,0.972c0.178,0.079,0.424,0.184,0.602,0.263c-1.733,0.604,0.313,1.327-1.19,1.941
						c-0.013-0.006-1.934-1.261-2.835-1.892c-0.79-0.084-1.757-0.25-2.311-0.405c-0.242,0.158-0.711,0.358-1.15,0.494
						c0.36,0.061,0.832,0.138,1.185,0.194c0.065,0.09,0.148,0.214,0.218,0.303c0.294,0.045,0.697,0.105,1.002,0.152
						c-0.607,0.117-1.438,0.264-2.085,0.37c-0.826-0.417-0.808-0.445-0.578-0.842c-0.696-0.063-1.609-0.154-2.269-0.235
						c1.749,2.059,1.749,2.059,1.031,2.279c-1.308-0.197-1.993-0.593-3.849-0.613c0.254,0.406-0.488,0.807-0.219,1.218l23.141,0.238
						c0.046-0.121,0.718-0.248,1.209-0.293c0.135,0.094,0.312,0.215,0.447,0.307c2.446,0,5.711-0.003,8.152-0.006
						c-0.078-0.188-0.19-0.439-0.283-0.629c0.317-0.06,0.743-0.141,1.066-0.198c1.491,0.311,1.793,0.408,2.27,0.953
						c1.325,0.013,3.1,0.032,4.426,0.047c0.006-0.086,0.03-0.196,0.042-0.276c0.377,0.004,0.879,0.012,1.262,0.015
						c0.188,0.086,0.435,0.198,0.623,0.278c49.137,0.521,67.397,0.712,105.542,1.184c-29.599-0.343-63.847-0.721-105.571-1.181
						c2.381,1.576,3.472,3.225,5.429,4.821c-3.301-0.798-7.333-4.81-7.344-4.841c-2.223,0.086-5.188,0.373-6.756,0.74
						c-0.199-0.247-0.482-0.574-0.695-0.821l-9.819-0.1c-2.621,0.014-5.653,0.085-8.774,0.146c0.083,0.027,0.186,0.051,0.24,0.079
						c0.123,0.075-0.059,0.127-0.166,0.155l-1.203-0.014c-0.07-0.071-0.124-0.136-0.158-0.199c-5.966,0.104-12.137,0.128-16.434-0.442
						c-0.547-0.258-1.103-0.511-1.714-0.763c0.118,0.003,0.271,0.003,0.382,0.006c0.502-0.273-1.014-0.684,0.619-0.85
						c-0.961-0.374-0.948-0.856-2.545-1.16c0,0-0.485-0.063-1.032,0.146c-0.279,0.103-0.465,0.149-1.102,0.126
						c1.02,0.318,1.308,0.508,0.942,0.962c-0.319,0.39-0.319,0.487-0.046,0.743c-0.92,0.04-1.676-0.095-2.535-0.12
						c0.229-0.144,0.825-0.244,0.943-0.401c0.064-0.09-0.296-0.274-0.402-0.331c-0.069-0.029-0.141-0.052-0.213-0.074
						c-1.071-0.316-1.071-0.316-1.283-0.425c-0.177-0.013-0.537-0.029-0.684,0.082c-0.154,0.112-0.26,0.161-1.109,0.084
						c-0.07-0.04-0.159-0.104-0.129-0.146c0.218-0.043,0.518-0.043,0.731-0.083c0.023-0.046-0.059-0.106-0.129-0.149
						c-0.915-0.063-1.292-0.144-1.851-0.483c-0.049-0.028-0.107-0.071-0.153-0.103c-0.16,0.023-0.308,0.049-0.448,0.074
						c-0.884,0.259-0.436,0.58-0.867,0.861c-0.684-0.137-1.232-0.246-2.411-0.712c-0.795-0.31-0.795-0.31-1.308-0.281
						c-0.183,0.078,0.022,0.155,0.005,0.23c-0.005,0.005-0.59,0.327-2.033-0.466c-0.459-0.247-0.602-0.275-1.203-0.399
						c-0.211-0.018-0.482-0.04-0.689-0.055c-0.425,1.326-0.524,1.643,0.985,2.379l-0.089,0.367l-0.679,0.175
						c0.203,0.089,0.473,0.207,0.673,0.296c-0.47,0.126-1.482,0.061-1.743,0.258l-1.309-0.014c-1.332,0.081-3.113,0.187-4.445,0.265
						c4.338,4.238,4.303,4.255,2.417,5.137c-2.163-0.861-2.369-0.979-3.984-1.901c-0.012-0.009-0.034-0.017-0.247-0.123
						c-1.108-0.374-1.108-0.374-3.113-1.858l-1-0.77l-1.799-0.872c-0.07-0.196-0.165-0.461-0.241-0.655
						c-0.695,0.103-1.626,0.235-2.321,0.342c-0.213-0.173-0.49-0.399-0.708-0.571l-0.142-0.265L652,29.365
						c-6.448,0.304-10.001-0.299-18.589-1.764l-4.267-0.313c-0.053-0.072-0.118-0.17-0.172-0.242
						c-26.275-2.868-26.275-2.868-59.554-4.045c-43.545-4.278-48.154-3.228-50.631-2.665c-1.296-0.178-2.675-0.568-3.147-0.893
						c-24.914-1.658-51.284-0.808-76.292-2.289c-15.571-0.109-15.571-0.109-17.53,0.459c-0.448-0.149-1.049-0.342-1.498-0.488
						c-5.41-0.157-5.41-0.157-7.933-0.063c-0.248,0.379-1.108,0.861-2.02,1.183c-9.91-2.526-45.321-1.528-49.86-0.454
						c-0.766-0.068-1.803-0.166-2.582-0.238c0.112-0.197,0.249-0.459,0.354-0.657c-1.791,0.092-1.791,0.092-8.481-0.046
						c-0.891,0.305-1.445,0.813-1.362,1.177c-0.859,0.092-2.004,0.213-2.864,0.305c-0.625-0.117-1.452-0.272-2.075-0.391
						c0.623-0.149,1.462-0.347,2.086-0.499c-0.165-0.184-0.383-0.431-0.554-0.617c-1.898,0.022-1.898,0.022-54.673-0.438
						c-0.389,0.176-0.902,0.405-1.285,0.578c2.688,0.574,6.625,0.485,9.561,0.933c-0.613,0.146-1.438,0.342-2.058,0.485
						c-11.913-0.511-11.913-0.511-14.429-0.506c-0.429-0.154-0.995-0.355-1.426-0.511c0.701-0.117,1.633-0.27,2.334-0.388
						c-0.258-0.175-0.607-0.411-0.859-0.585c-13.946-0.561-28.428,0.261-42.174-0.827c0.083,0.191,0.201,0.456,0.277,0.646
						c-0.76,0.049-1.781,0.109-2.541,0.155c1.622,0.163,3.514,0.517,4.658,0.821c-0.472,0.17-1.098,0.396-1.562,0.563
						c-1.716-0.333-1.716-0.333-7.739-0.666c0.141-0.195,0.323-0.454,0.464-0.648c-3.577-1.121-3.577-1.121-16.154-1.367
						c-0.601,0.123-1.397,0.287-1.999,0.413c-4.734-0.077-8.6-0.735-13.067-0.993c-0.66,0.132-1.539,0.305-2.198,0.431
						c-6.277-0.281-12.702-0.367-18.885-0.764c0.046-0.092,0.112-0.213,0.152-0.305c-1.433,0.146-3.736,0.158-5.251,0.063
						c-0.16,0.38,0.217,0.905,0.862,1.259c-0.85,0.009-1.976,0.022-2.819,0.034c0.354,0.16,0.826,0.379,1.179,0.54
						c-0.807,0.058-1.875,0.132-2.683,0.187c7.635,0.726,7.635,0.726,13.361,2.223c-0.647,0.132-1.509,0.308-2.156,0.445
						c-0.083-0.015-9.348-1.172-16.416-0.586c1.486,0.154,3.132,0.54,3.878,0.873c-0.076-0.009-8.516-0.938-14.422-1.447
						c-0.354,0.16-0.82,0.373-1.167,0.534c0.777-0.052,1.815-0.12,2.593-0.173c-0.005,0.179-0.012,0.423-0.024,0.601
						c-1.709-0.044-3.966-0.152-5.611-0.268c-0.625-0.333-2.027-0.74-3.371-0.933c-0.177,0.181-0.413,0.422-0.589,0.603
						c-5.118-0.783-5.118-0.783-7.08-0.807c-0.478,0.166-1.126,0.385-1.597,0.551c2.204,0.741,6.371,0.62,9.218,1.081
						c-0.094,0.194-0.207,0.453-0.301,0.647c-1.598-0.063-3.731-0.154-5.333-0.223c0.129,0.35-0.178,0.838-0.731,1.165
						c1.437,0.138,3.083,0.482,3.901,0.781c-0.666,0.103-1.556,0.244-2.215,0.344c-3.159-0.263-6.247-0.573-9.4-0.844
						c-0.602,0.123-1.404,0.288-2.012,0.405c5.923,0.333,5.923,0.333,7.633,0.588c-0.612,0.156-1.432,0.363-2.051,0.518
						c-1.431-0.212-3.449-0.463-5.003-0.626c-1.403-0.172-3.396-0.345-4.916-0.453c-0.932-1.472-0.932-1.472-2.063-1.815
						c0.695-0.101,1.615-0.235,2.31-0.333c-2.486-0.89-7.185-0.977-10.673-1.502c0.347-0.187,0.813-0.431,1.16-0.617
						c2.676,0.284,4.445,0.876,7.315,1.085c0.184-0.191,0.423-0.447,0.602-0.644c0.748,0.089,1.75,0.207,2.492,0.293
						c0.224,0.198,0.513,0.466,0.731,0.664c-0.577,0.124-1.344,0.284-1.921,0.41c0.813,0.023,1.887,0.063,2.693,0.086
						c0.336,0.162,0.795,0.38,1.137,0.543c0.778,0.046,1.822,0.106,2.606,0.155c-0.778-0.124-1.815-0.29-2.594-0.413
						c1.127-1.071,1.127-1.071,5.907-1.982c-0.814-0.313-1.437-0.795-1.515-1.16c3.172,0.254,3.826,0.303,8.305,0.038
						c0.325-0.184,0.755-0.426,1.078-0.603c-1.467-0.178-3.024-0.586-3.73-0.929c0.689-0.089,1.614-0.209,2.304-0.301
						c-0.235-0.192-0.548-0.445-0.785-0.632c-1.59-0.061-3.843-0.017-5.344,0.115c0.712,0.092,1.656,0.212,2.363,0.304
						c-0.626,0.319-2.228,0.687-3.666,0.816c0.129,0.143,0.294,0.333,0.423,0.479c-1.503-0.112-1.503-0.112-8.293-0.282
						c1.42,0.247,3.388,0.558,4.926,0.762c-0.07,0.181-0.169,0.419-0.246,0.597c-0.731,0.058-1.704,0.132-2.435,0.189
						c0.471,0.189,1.09,0.442,1.562,0.626c-2.517-0.083-5.123-0.172-11.664-0.746c0.129-0.351-0.408-0.844-1.308-1.132
						c-0.814,0.047-1.899,0.109-2.701,0.158c0.313,0.164,0.731,0.382,1.05,0.543c-0.767-0.041-1.792-0.098-2.558-0.141l2.257,2.423
						h-0.036c0.524,0.342,1.221,0.796,1.75,1.135c0.814,0.018,1.91,0.043,2.724,0.063c0,0.195,0,0.453,0,0.654
						c-0.78-0.037-1.815-0.083-2.595-0.118l0.019,0.268c-0.002,0-0.002-0.003-0.005-0.006c-0.56-0.034-1.114-0.068-1.674-0.097
						c-4.25-0.179-2.24,0.723-2.215,0.734c0.435,0.164,1.135,0.284,1.485,0.465c1.266-0.167,2.445,0.161,4.077,0.624
						c-0.166-0.176-0.368-0.383-0.564-0.584l0.653,0.673l2.211,2.17l-0.019,0.015c1.314,0.561,1.314,0.561,6.49,1.454
						c-0.809-0.021-1.885-0.055-2.688-0.078c1.061,0.27,2.528,0.626,3.654,0.885c-1.543-0.078-3.665-0.127-5.251-0.127
						c-0.002-0.002-0.004-0.004-0.006-0.006c-0.317,0.023-0.624,0.049-0.919,0.081c0.013,0.005,0.025,0.011,0.041,0.011
						c0.408,0.144,0.876,0.19,1.197,0.209l0.408,0.388c1.225,0.581,2.852,1.367,4.544,1.887c-0.814-0.048-1.893-0.116-2.699-0.163
						c6.948,1.781,17.458,1.098,25.814,1.907c2.778,0.582,3.679,0.597,7.503,0.416l0.844,0.195c0.448-0.061,1.049-0.141,1.498-0.198
						c21.359,1.271,21.359,1.271,23.834,1.703c-2.948,0.388-2.948,0.388-13.667-0.055c-0.497,0.155-1.162,0.361-1.657,0.517
						c8.917,0.977,19.115,1.137,27.843,2.234c-14.015-0.218-27.23-1.562-41.435-1.517c-2.08-0.356-24.401-0.85-25.699-0.826l3.065,2.492
						c1.061-0.063,2.559,0.023,3.654,0.052c5.132-1.006,5.132-1.006,6.106-1.092c3.867,1.416,11.317,1.052,16.692,1.718
						c0.129-0.003,15.596,0.241,20.817,1.014c6.86,0.132,15.997,0.307,22.856,0.436c-0.448-0.169-1.031-0.393-1.473-0.559
						c14.63,0.453,15.831,0.49,20.004,1.145c0.042,0.003,0.081,0.003,0.121,0.003c-0.156-0.003-0.306-0.005-0.462-0.008
						c-0.342-0.055-0.613-0.141-1.048-0.164h-0.036l-0.035,0.138c-10.01,0.38-10.01,0.38-16.493-0.388
						c-26.69-0.439-26.69-0.439-32.265-0.634c-0.282,0.097-0.659,0.229-0.947,0.327c-4.28-0.374-8.907-0.385-13.293-0.655
						c-2.309,0.247-4.702,0.04-7.06,0.069c-0.183,0.188-0.437,0.442-0.625,0.629c1.627,0.106,3.56,0.463,4.427,0.786
						c-9.62-0.048-9.62-0.048-18.621-0.784l-0.035-0.002c1.084,0.537,2.535,1.255,3.614,1.794c7.62,0.368,7.62,0.368,8.381,0.385
						c4.472,0.5,10.007,0.396,13.902,1.236c-2.379-0.107-2.379-0.107-8.77-0.535c-0.777,0.104-1.81,0.244-2.582,0.351
						c2.215,0.626,2.735,0.774,7.437,0.574c0.03-0.012,0.061-0.018,1.845-0.109c0.962,0.293,1.824,0.758,2.058,1.114
						c-4.178,0.012-8.163-0.307-12.294-0.37c-0.83-1.174-1.891-1.229-10.114-1.663h-0.036l1.486,1.178l0.318,0.227
						c-0.601-0.166-1.181-0.342-1.899-0.479c0.343-0.028,0.795-0.068,1.133-0.101c-0.636-0.24-1.486-0.565-2.122-0.804
						c-2.984-0.061-2.984-0.061-9.489-1.111c0.023-0.083,0.059-0.192,0.082-0.276c5.854,0.13,6.289,0.149,9.128,0.282
						c-0.925-0.528-2.149-1.235-3.081-1.769c-2.081-0.018-3.832-0.345-5.941-0.34c-0.408-0.293,0.047-0.614-0.488-0.904
						c0.076-0.049,0.194-0.112,0.275-0.16c3.514,0.143,3.75,0.014,4.734-0.537c-0.915-0.753-2.116-1.752-3.024-2.508
						c-2.882-0.181-2.882-0.181-3.394-0.192c-0.237,0.061-0.544,0.139-0.769,0.196c-1.249-0.46-1.249-0.46-6.676-0.655
						c0.07,0.074,0.159,0.172,0.224,0.247c-3.248-0.684-7.847-0.833-11.254-1.456c0.189,0.175,0.326,0.422,0.307,0.6
						c-1.167-0.04-2.299-0.108-3.46-0.154c-2.419,0.283-4.519,0.339-6.437,0.265c-0.113-0.007-0.228-0.011-0.341-0.017
						c-5.145-0.245-8.967-1.435-13.953-1.794c0.19-0.073,0.45-0.171,0.638-0.246c0.33,0.018,0.778,0.046,1.108,0.068
						c0.801-0.045,1.993-0.031,2.758,0.047c0.336-0.034,0.791-0.081,1.126-0.115c0.229,0.058,0.537,0.133,0.772,0.189
						c0.023-0.121,0.048-0.275,0.066-0.396c0.346-0.011,0.807-0.031,1.16-0.043c-40.457-2.048-40.457-2.048-42.134-1.893
						c4.364,0.928,11.391,0.471,15.504,1.524c0.106-0.042,0.249-0.103,0.349-0.146c0.218,0.061,0.512,0.142,0.723,0.201
						c-0.094-0.074-0.211-0.175-0.306-0.252c14.965,0.534,14.965,0.534,16.037,0.956c-0.289,0.043-0.659,0.101-0.937,0.145
						c0.254,0.065,0.589,0.157,0.849,0.226c-0.082,0.081-0.207,0.196-0.296,0.275c-0.141-0.005-14.474-0.534-16.325-1.036
						c-0.626-0.169-10.18-1.893-12.814-0.318c0.896,0.367,0.896,0.367,0.849,0.684c-2.063-0.144-2.063-0.144-3.393-0.018
						c-4.219-0.394-8.997-0.391-13.528-0.563c2.325,0.188,4.592,0.408,6.698,0.73c3.11-0.241,16.2,0.869,16.33,0.881
						c0.754,0.405,0.425,1.1,0.419,1.105c-0.242-0.149-0.736-0.333-1.184-0.459c-0.154,0.075-0.367,0.178-0.52,0.253
						c-0.276-0.046-0.653-0.115-0.93-0.161c0.034-0.087,0.087-0.204,0.129-0.291c-0.33,0.023-0.761,0.055-1.08,0.078
						c-0.294-0.049-0.688-0.114-0.983-0.16c0.023,0.092,0.072,0.218,0.101,0.31c-2.445,0.055-7.07-0.267-8.364-0.482
						c-1.483,0.201-2.093,0.281-6.628-0.327c0.041-0.08,0.102-0.187,0.151-0.267c-1.516-0.308-2.25-0.359-13.004-0.896
						c-0.218,0.061-0.51,0.135-0.725,0.192c-0.219-0.054-0.518-0.132-0.736-0.189c0.955,0.388,0.977,0.416,1.345,0.933
						c-7.696-0.731-9.737-0.64-11.091-0.576c4.58,0.419,12.243,1.123,15.485,2.291c-1.329,0.149-1.329,0.149-4.86-0.034
						c-0.258,0.049-0.613,0.114-0.876,0.166c-1.616-0.108-3.293-0.166-4.874-0.304c-0.221-0.058-0.516-0.144-0.74-0.204
						c-7.445,0.083-11.337-1.554-17.902-1.892c0.126,0.144,0.628,0.329,1.15,0.419c-0.137,0.074-0.319,0.166-0.457,0.235
						c-2.288-0.284-4.794-0.462-7.249-0.666v21.105l1.742,1.025h2.618L1.717,50.96c1.111,0.367,2.263,0.729,3.375,1.082H1920.116z
						 M1236.958,36.896c0.143,0.078,0.33,0.179,0.48,0.256c8.008-0.355,16.012,0.608,24.029,0c-0.113-0.073-0.258-0.175-0.367-0.252
						c1.393-0.041,2.461-0.282,3.842-0.331c0.238-0.071,0.545-0.175,0.781-0.25c-0.236-0.034-0.543-0.089-0.781-0.128
						c0.627,0.071,1.449,0.166,2.064,0.241c0.119-0.078,0.287-0.179,0.412-0.257c-0.34-0.017-0.793-0.04-1.129-0.055
						c-0.027-0.076-0.059-0.181-0.084-0.255c1.473,0.109,1.473,0.109,2.998,0.615c0.266-0.058,0.619-0.13,0.885-0.188
						c-0.113-0.071-0.27-0.173-0.383-0.247c2.838,0.043,5.422,0.537,8.461,0.25c-0.008-0.08-0.008-0.192-0.008-0.271
						c-0.73-0.028-1.768-0.02-2.477,0.029c-0.426-0.092-0.977-0.218-1.402-0.315c0.719,0.011,1.703-0.069,2.297-0.161
						c-0.424-0.098-0.424-0.098-3.24-0.281c-0.223,0.058-0.529,0.137-0.752,0.201c0.088,0.074,0.217,0.175,0.309,0.252
						c-0.215,0.061-0.5,0.146-0.723,0.207c-1.721-0.092-2.219-0.126-4.314-0.511c0.141-0.075,0.316-0.17,0.457-0.241
						c-0.275-0.092-0.641-0.213-0.916-0.304c0.322-0.05,0.768-0.118,1.082-0.168c0.666,0.053,1.557,0.11,2.24,0.149
						c0.27-0.052,0.627-0.123,0.902-0.172c-1.008-0.155-2.24-0.213-3.236-0.376c0.014-0.083,0.025-0.192,0.025-0.276
						c-4.662-0.141-10.043-0.305-15.479-0.47l15.479,0.47c0.365-0.077,1.197-0.082,1.66-0.043l20.842,0.311
						c0.566,0.109,1.51,0.212,2.24,0.241c-0.072-0.147-0.104-0.21,0.375-0.296c0.498-0.086,0.521-0.106,0.535-0.238
						c-0.688-0.138-1.398-0.247-3.371-0.229c-1.047,0.011-1.748-0.018-2.229-0.195c-0.049-0.012-0.098-0.038-0.135-0.058
						c2.455-0.098,5.031,0.144,7.422-0.132c0.785,0.16,1.387,0.218,2.826,0.272c4.689,0.136,4.689,0.136,4.975,0.184
						c0.021,0.003,1.164,0.457-0.078,0.561c-0.254-0.087-0.299-0.104-0.141-0.225c0.129-0.092-0.078-0.121-0.584-0.181
						c-0.336,0.117-0.613,0.132-1.975,0.112c-1.629-0.026-1.973,0.034-1.838,0.327c0.824,0.058,1.725,0.023,2.537,0.098
						c0.576,0.049,0.676,0.089,0.729,0.189c-2.023-0.12-4.412,0.152-6.125-0.293c0.189-0.089,0.424-0.164,1.244-0.086
						c0.973,0.097,1.113-0.006,1.248-0.104c-0.238-0.098-0.566-0.224-0.805-0.318c-0.891,0.025-1.807-0.026-2.676,0.055
						c-0.652,0.061-0.738,0.108-1.063,0.293c0.564,0.16,1.461,0.234,1.99,0.401c0.391,0.121,0.379,0.121,0.006,0.23
						c-0.475-0.225-1.068-0.265-2.869-0.368l-0.035,0.287c-2.498,0.391-2.498,0.391-3.748,0.517c-0.059-0.092-0.119-0.215-0.172-0.305
						c-2.256-0.27-4.824-0.144-7.172-0.298c-0.26,0.06-0.613,0.138-0.873,0.201c0.207,0.074,0.482,0.166,0.686,0.241
						c0.35,0.005,0.824,0.014,1.188,0.021c0.215,0.143,0.26,0.361,0.096,0.508c0.012,0.006,3.291,1.011,4.697,1.493
						c-1.174,0.307-1.174,0.307-3.732,0.304c0.59,0.359,0.59,0.359,1.35,0.535c0.307-0.037,0.713-0.092,1.02-0.127
						c0.285,0.046,0.664,0.106,0.945,0.152c-1.068,0.289-2.783,0.315-4.078,0.514c-2.063-0.151-2.271-0.129-5.684,0.262
						c-0.105,0.009-0.223,0.017-0.33,0.026c-0.684,0.011-1.615-0.05-2.193-0.13c0.346,0.012,0.805,0.025,1.143,0.034
						c0.262-0.049,0.609-0.118,0.871-0.169c-1.518-0.012-3.023,0-4.529,0.029l-0.375-0.182l-0.842-0.025l-0.012,0.231
						c-0.352,0.007-0.701,0.015-1.045,0.021c0.064-0.063,0.139-0.126,0.197-0.184c-0.229-0.061-0.533-0.149-0.752-0.213
						c-5.156,0.081-10.111-0.437-15.297-0.264c-0.152,0.075-0.352,0.178-0.5,0.256c-0.691-0.052-1.527-0.164-2.066-0.27
						c-0.352,0.021-0.805,0.054-1.143,0.076c0.492,0.124,1.105,0.299,1.504,0.44c-0.682,0.022-1.613,0.025-2.299,0.002
						c-0.01-0.16,0.07-0.379,0.219-0.539c-12.453-0.102-13.361-0.581-13.902-0.867C1236.487,37.072,1236.757,36.972,1236.958,36.896z
						 M1015.589,27.882c-3.736-0.065-7.645-0.134-11.541-0.202L1015.589,27.882z M962.423,29.072c0.07-0.046,0.201-0.098,0.615-0.077
						c0.447,0.218-0.029,0.398-0.572,0.396c-0.094-0.003-0.313-0.008-0.514-0.075c-0.047-0.014-0.092-0.039-0.135-0.06
						C962.147,29.256,962.147,29.256,962.423,29.072z M953.056,31.28c0.603-0.095,1.148-0.031,1.148-0.031
						c0.528,0.12,0.558,0.246,0.675,0.678c-0.796-0.047-1.191-0.012-1.559,0.023c-0.271,0.028-0.492,0.048-0.833,0.048
						c-0.046,0-0.106-0.003-0.16-0.003c0.324-0.281,0.292-0.385-0.204-0.684C952.583,31.346,952.804,31.317,953.056,31.28z
						 M952.924,32.578c-0.1,0.084-0.224,0.192-0.321,0.273l-0.506-0.098C952.134,32.61,952.186,32.529,952.924,32.578z M942.672,30.028
						l0.063,0.201l-0.884-0.012l-0.058-0.204L942.672,30.028z M941.288,32.503c-0.364,0.066-0.603,0.162-1.002,0.216
						c-0.387,0.055-0.648,0.052-0.944,0.052c-0.161-0.003-0.31-0.017-0.469-0.023c-0.025,0-0.061,0-0.083,0
						c-0.058-0.174-0.132-0.404-0.179-0.577C941.036,32.489,941.036,32.489,941.288,32.503z M931.031,31.306l0.495,0.288l-1.281-0.018
						l-0.095-0.281L931.031,31.306z M927.653,36.314c-0.333,0.077-0.556,0.086-0.643,0.086c-0.045,0-0.174-0.006-0.28-0.041
						c-0.073-0.021-0.092-0.048-0.092-0.079C926.643,36.28,926.694,36.09,927.653,36.314z M921.962,29.83
						c-0.144-0.212-0.772-0.402-0.597-0.628c0.115-0.147,0.879-0.133,1.172-0.13c0.568,0.453,0.827,0.663-0.437,0.746
						C922.063,29.825,922.003,29.825,921.962,29.83z M922.511,32.911l-0.061-0.186l0.879,0.011l0.066,0.184L922.511,32.911z
						 M923.217,31.2l0.885,0.009l0.057,0.188l-0.884-0.011L923.217,31.2z M923.938,33.315l-0.074-0.2l0.873,0.012l0.077,0.201
						L923.938,33.315z M925.245,26.505c0.434,0.152-0.095,0.215-0.626,0.212c-0.29-0.008-0.479-0.024-0.583-0.06
						c-0.052-0.018-0.063-0.038-0.058-0.061C924.426,26.585,924.765,26.499,925.245,26.505z M920.602,27.366
						c0.14-0.109,0.186-0.118,0.565-0.137c2.05,0.548,2.05,0.548,3.167,0.619c-0.126,0.287-0.6,0.316-1.436,0.34
						c-0.724,0.021-1.08,0.057-1.378,0.2l-0.953-0.219c0.448,0.006,1.375,0.006,1.235-0.131c-0.106-0.099-0.672-0.233-1.224-0.362
						c-0.252-0.058-0.511-0.112-0.694-0.185C920.418,27.516,920.51,27.438,920.602,27.366z M890.575,31.312
						c0.131-0.16,1.145-0.143,1.592,0.023c0.005,0.005,0.019,0.011,0.024,0.011c0.081,0.041,0.129,0.081,0.141,0.124l-1.697-0.02
						C890.58,31.403,890.54,31.358,890.575,31.312z M892.083,33.161c-0.294-0.009-0.553-0.055-0.789-0.141
						c-0.072-0.022-0.13-0.046-0.166-0.072c-0.023-0.017-0.513-0.353,1.704-0.117C892.755,32.983,892.604,33.161,892.083,33.161z
						 M891.924,32.521c-0.027,0-0.057,0-0.087,0.002c-0.56-0.287-0.353-0.358,0.703-0.477C892.674,32.26,892.827,32.503,891.924,32.521z
						 M892.638,31.194c-0.636-0.009-1.373-0.029-1.85-0.179c-0.343-0.105-0.402-0.238-0.396-0.238c-0.046-0.172,0.094-0.35,0.077-0.522
						c-0.013-0.129-0.053-0.259,0.012-0.39c0.105-0.201,0.388-0.312,1.131-0.432C892.403,30.06,892.45,30.255,892.638,31.194z
						 M890.51,26.043c0.235,0.258,0.218,0.404-0.553,0.401c-0.184-0.003-0.367-0.006-0.537-0.014c-0.024-0.006-0.059-0.01-0.083-0.01
						C889.616,26.051,889.625,26.033,890.51,26.043z M884.911,27.159c0.218-0.614,0.548-0.731,1.427-0.775
						c0.199,0.102,0.501,0.254,1.103,0.336c1.042,0.146,2.333,0.153,3.376,0.303c-0.041,0.231-0.041,0.231,1.102,0.684
						c-1.938,0.166-1.938,0.166-2.493,0.263c-0.242-0.527-0.242-0.536-1.078-0.591c-0.944,1.039-0.944,1.039-2.169,1.223
						c1.133,0.195,0.006,0.457,0.229,0.678c-0.406,0.01-0.771-0.028-0.771-0.028c-0.702-0.08-1.015-0.391-0.343-0.655
						c0.124,0,0.283,0,0.408,0.003c-0.814-0.16-0.791-0.425-1.492-0.597C884.606,27.809,884.716,27.711,884.911,27.159z M878.263,28.228
						l0.064,0.187l-0.883-0.008l-0.064-0.189L878.263,28.228z M878.469,29.074c0.602,0.07,0.813,0.053,0.942-0.068
						c-1.473-0.042-2.016-0.184-1.932-0.508c0.529,0.008,1.231,0.015,1.762,0.022c0.159,0.287,0.478,0.574,0.483,0.867
						c0.006,0.23-0.294,0.391-0.473,0.491c-0.552-0.006-0.977-0.098-1.497-0.124c-0.075-0.002-0.169-0.002-0.234-0.005
						c-0.254-0.129-0.395-0.235,0.094-0.439c0.125-0.055,0.402-0.092,0.319-0.166c-0.095-0.084-0.454-0.112-0.691-0.165
						C877.549,28.975,877.549,28.975,878.469,29.074z M868.02,34.824c-0.043,0.063,0.004,0.12,0.116,0.232
						c0.172,0.184,0.172,0.262-0.3,0.262c-0.124-0.004-0.249-0.004-0.359-0.015c-0.012,0-0.03-0.003-0.047-0.006
						C867.259,35.045,867.434,34.902,868.02,34.824z M860.385,28.186c-0.347-0.099-0.471-0.142,0.184-0.17
						c0.094,0.058,0.2,0.086,0.513,0.154c0.412,0.087,0.66,0.155,0.541,0.339c-0.129,0.018-0.258,0.018-0.4,0.018
						c-0.595-0.011-1.096-0.089-1.249-0.138c-0.224-0.071,0.165-0.09,0.294-0.098c0.129,0.031,0.308,0.071,0.437,0.104
						C860.809,28.331,860.739,28.282,860.385,28.186z M861.281,29.899c-0.27-0.006-0.524-0.023-0.767-0.047
						c-0.04-0.003-0.093-0.011-0.129-0.011c0.414-0.213,0.2-0.348-0.389-0.604c-0.591-0.267-0.836-0.419-0.496-0.657
						c0.826-0.018,1.45,0.077,1.745,0.141C862.708,29.015,863.315,29.888,861.281,29.899z M722.641,44.82
						c-0.004-0.006-0.004-0.006-0.007-0.009l-0.31-0.399L722.641,44.82z"/>
					';
			$svg_top_output .= '</svg>';

			$svg_bottom_output = '';
			$svg_bottom_output .= '<svg class="qodef-grunge-effect qodef-grunge-effect-bottom" preserveAspectRatio="none" width="1920px" height="52px" viewBox="0 0 1920 52" enable-background="new 0 0 1920 52" <# if( settings.grunge_effect_background !== "" ){ #> fill=" {{{settings.grunge_effect_background}}} "  <# } #> >';
			$svg_bottom_output    .= '<polygon points="406.54,13.503 406.398,13.307 405.751,13.302 405.88,13.496 "/>
				<polygon points="241.93,10.933 241.795,10.751 241.246,10.74 241.382,10.918 "/>
				<path d="M268.944,15.952c1.75-0.069,0.83-0.479,0.252-0.568c-0.142-0.021-0.296-0.031-0.461-0.038
					c-0.247-0.003-0.412,0.007-0.653,0.035c0.017,0.21,0.566,0.378,0.742,0.577C268.861,15.955,268.901,15.955,268.944,15.952z"/>
				<path d="M255.257,17.744c-1.162-0.021-2.01-0.006-1.551,0.416c0.019,0,0.036,0,0.049,0
					C255.363,18.252,255.287,17.867,255.257,17.744z"/>
				<path d="M675.027,28.849c-0.917-0.167-2.096-0.133-3.134-0.204c-0.011,0.063-0.024,0.175,0.283,0.267
					C672.859,29.106,674.628,29.037,675.027,28.849z"/>
				<path d="M45.177,41.515c0.15,0.018,0.321,0.003,0.477,0.015c-0.161-0.109-0.339-0.185-0.726-0.219
					c-0.067-0.006-0.138-0.006-0.218-0.011c0.052,0.052,0.108,0.103,0.209,0.151C44.982,41.478,45.057,41.501,45.177,41.515z"/>
				<polygon points="132.24,46.371 131.982,46.181 131.576,46.164 131.84,46.353 "/>
				<path d="M40.624,41.96c0.429-0.052,1.232-0.04,2.054,0.104c-0.372-0.276-1.105-0.365-1.404-0.394
					c-0.409-0.026-1.04-0.022-0.708,0.295C40.585,41.965,40.605,41.96,40.624,41.96z"/>
				<path d="M45.389,42.27c-0.123-0.061-0.28-0.138-0.402-0.2l-0.289-0.023c0.039,0.043,0.092,0.081,0.168,0.121
					C44.982,42.219,44.996,42.219,45.389,42.27z"/>
				<path d="M114.323,50.784c-0.176-0.055-0.271-0.112-0.389-0.175c-0.2-0.092-0.313-0.112-0.437-0.121
					c-0.047,0-0.088,0-0.129,0.003c0.082,0.061,0.177,0.121,0.306,0.176C113.935,50.767,114.141,50.775,114.323,50.784z"/>
				<path d="M69.304,49.443c0.101-0.031,0.342-0.018,0.389-0.018c-0.218-0.086-0.501-0.201-0.719-0.286
					c-0.041,0.051,0.095,0.197-0.188,0.154c0.072,0.037,0.137,0.071,0.219,0.105C69.175,49.478,69.232,49.467,69.304,49.443z"/>
				<path d="M36.533,49.119c-0.274-0.182-0.602-0.268-0.814-0.291c-0.218-0.017-0.206,0.034-0.165,0.055
					C36.014,49.104,36.403,49.113,36.533,49.119z"/>
				<path d="M16.978,47.404c0.302,0.144,0.553,0.172,0.638,0.13c0.066-0.034,0.025-0.107-0.129-0.21
					c-0.33-0.018-0.4-0.099-0.648-0.136c-0.262-0.025-0.121,0.066-0.062,0.102C16.831,47.327,16.904,47.367,16.978,47.404z"/>
				<polygon points="18.989,47.657 18.724,47.484 18.307,47.427 18.577,47.605 "/>
				<path d="M16.687,47.468c0.06-0.049-0.013-0.141-0.221-0.276c-0.151,0.029-0.003,0.095-0.24,0.115
					c-0.111,0.012-0.301-0.037-0.386-0.058c0.043,0.023,0.092,0.049,0.135,0.072C16.316,47.49,16.603,47.524,16.687,47.468z"/>
				<path d="M15.353,47.461c0,0,0.002,0,0.006,0c0.044-0.036-0.174-0.2-0.336-0.229c-0.002,0-0.002,0-0.002,0
					c-0.041,0.009,0.205,0.175,0.286,0.212C15.314,47.45,15.33,47.459,15.353,47.461z"/>
				<path d="M3.569,45.781c0.055,0.032,0.122,0.073,0.184,0.101c0.294,0.156,0.344,0.146,0.489,0.121
					c0.084-0.018,0.144-0.022,0.295,0.021c-0.183-0.093-0.407-0.198-0.658-0.247C3.747,45.75,3.646,45.756,3.569,45.781z"/>
				<path d="M2.448,45.658c0.034,0.052,0.102,0.098,0.171,0.149c0.011-0.003,0.017-0.006,0.026-0.008
					c0.296-0.05,0.701,0.12,0.767,0.037c0.044-0.063,0.072-0.101-0.619-0.236C2.674,45.581,2.35,45.522,2.448,45.658z"/>
				<path d="M1912.804,30.979c0.107-0.042,0.084-0.092,0.072-0.112c-0.045-0.008-0.094-0.014-0.154-0.02
					c-0.309-0.028-0.578,0.04-0.885,0.017c-0.043,0.023-0.08,0.047-0.053,0.075C1911.874,31.025,1912.569,31.07,1912.804,30.979z"/>
				<path d="M1909.522,34.379c0.164-0.052,0.234-0.155,0.27-0.207c-0.791-0.04-0.717,0.12-0.705,0.141
					C1909.13,34.382,1909.321,34.441,1909.522,34.379z"/>
				<path d="M1817.087,28.618c0.016-0.045,0.094-0.187-0.469-0.241c-0.26-0.018-0.506-0.008-0.781,0.026
					c-0.018,0.037-0.023,0.071,0.006,0.109C1815.96,28.642,1816.515,28.687,1817.087,28.618z"/>
				<path d="M1813.118,28.59l0.406-0.063c0.176-0.092-0.174-0.136-0.34-0.149c-0.449-0.034-0.865,0.012-0.768,0.144
					c0.006,0.006,0.012,0.012,0.02,0.015C1812.634,28.55,1812.909,28.576,1813.118,28.59z"/>
				<path d="M1284.741,36.257c-0.027-0.003-0.064-0.003-0.104-0.003c-1.117-0.031-1.279,0.149-1.553,0.419
					c0.025-0.002,0.049-0.005,0.072-0.008C1284.618,36.475,1284.702,36.464,1284.741,36.257z"/>
				<path d="M1279.798,36.478c-0.686,0.041-0.84,0.133-0.863,0.262c0.369,0.012,0.863,0.028,1.227,0.041L1279.798,36.478
					z"/>
				<path d="M1281.813,37.302c-0.836-0.018-1.037,0.253-0.746,0.385c0.285,0.124,0.9,0.093,1.1,0.081
					c-0.328-0.081-0.307-0.127-0.152-0.222C1282.159,37.454,1282.167,37.396,1281.813,37.302z"/>
				<path d="M1238.339,39.329c0.736,0,0.482-0.298,1.236-0.246c-0.08-0.139-0.457-0.201-1.391-0.23
					c-0.213-0.005-0.416-0.008-0.623-0.011c-0.273,0.224-0.273,0.224,0,0.465C1237.798,39.312,1238.101,39.326,1238.339,39.329z"/>
				<path d="M1258.567,40.856c0.223-0.02,0.33-0.028,0.33-0.073c0-0.075-0.246-0.13-0.33-0.196
					c0.543,0.037,0.641,0.047,1.143,0.184c0.365,0.092,0.744,0.196,1.758,0.173c0.117-0.163,0.529-0.31,0.529-0.482
					c0.004-0.126-0.082-0.167-0.512-0.345c-1.41-0.006-2.678,0.181-4.096,0.152c-1.369-0.025-2.477-0.21-3.732-0.302
					c-0.006,0.058,0,0.126,0,0.181c-0.111,0.026-0.219,0.021-0.779-0.129c-0.906-0.241-0.906-0.241-0.906,0.275c0.018,0,0.039,0,0.061,0
					C1253.032,40.306,1256.587,40.47,1258.567,40.856z"/>
				<path d="M1251.196,40.073c-0.373-0.008-0.871-0.026-1.234-0.037v0.289c0,0,0.01,0,0.025,0
					C1250.435,40.341,1251.271,40.363,1251.196,40.073z"/>
				<path d="M1231.329,40.047c1.006,0.006,0.951-0.212,0.385-0.35c-0.914,0.012-0.791,0.195-0.59,0.281
					C1231.181,40.008,1231.253,40.026,1231.329,40.047z"/>
				<polygon points="1264.323,40.76 1263.542,40.736 1263.542,40.915 1264.317,40.94 "/>
				<path d="M731.453,36.836c-0.154-0.005-0.3-0.011-0.454-0.014c-0.365,0-0.737,0.009-0.966,0.115
					c-0.308,0.146-0.129,0.302-0.249,0.456c0.036-0.002,0.076-0.005,0.106-0.008C731.128,37.308,731.907,37.233,731.453,36.836z"/>
				<path d="M730.893,39.02c0.023,0,0.042,0,0.057,0c1.057-0.046,1.471,0.264,2.501,0.229
					c-0.284-1.143-0.355-1.45-1.682-1.93c-0.311,0.003-0.558,0.003-0.924,0.135c-0.348,0.118-0.907,0.078-1.438,0.026
					c0.337,0.315,0.909,0.614,1.214,0.93C730.858,38.651,730.88,38.767,730.893,39.02z"/>
				<path d="M760.457,39.054c1.32,0.006,1.121-0.334,0.583-0.46c-0.018-0.005-0.046-0.008-0.065-0.011
					c-0.801,0.011-0.813,0.16-0.529,0.471C760.446,39.054,760.446,39.054,760.457,39.054z"/>
				<path d="M1180.517,45.968c0.061-0.042,0.055-0.092,0.045-0.14c-0.658-0.021-0.998-0.078-1.27-0.21
					c-0.98,0.018-0.672,0.179-0.494,0.244C1179.233,46.025,1180.282,46.181,1180.517,45.968z"/>
				<path d="M731.341,39.476c0.159,0.055,0.92,0.238,1.479,0.04c-0.313-0.086-0.712-0.197-1.02-0.283
					C730.775,39.27,731.282,39.455,731.341,39.476z"/>
				<path d="M1182.04,47.348c0.869-0.125,0.74-0.199,0.184-0.363c-0.633-0.184-1.012-0.32-0.73-0.579
					c-0.375,0.014-1.529,0.058-0.092,0.688C1181.603,47.181,1181.813,47.261,1182.04,47.348z"/>
				<path d="M1176.181,46.824c-0.389-0.092-0.178-0.281-0.939-0.304c-0.111-0.006-0.234,0-0.346,0.002
					c-0.008,0.037-0.016,0.112,0.146,0.176C1175.317,46.811,1175.933,46.824,1176.181,46.824z"/>
				<path d="M740.104,40.162c0.018-0.146-0.406-0.253-0.642-0.379l-1.148,0.083c0.01,0.037,0.028,0.115,0.234,0.181
					C738.944,40.174,739.721,40.168,740.104,40.162z"/>
				<path d="M722.593,39.794l0.319-0.085c0-0.092-0.355-0.118-0.649-0.121c-0.471-0.006-0.918,0.058-0.529,0.187
					c0.01,0.003,0.022,0.009,0.034,0.014C722.022,39.788,722.345,39.791,722.593,39.794z"/>
				<path d="M1178.54,48.449c-0.156,0.185-0.309,0.379,0.398,0.626c1.369,0.471,1.369,0.471,1.449,0.609
					c0.254,0.006,0.59,0.017,0.848,0.023c1.283-0.149-0.246-0.896-1.811-1.058c-0.229-0.439-1.102-0.912-3.234-1.734
					c-0.029-0.003-0.068-0.006-0.096-0.006C1174.604,46.95,1178.479,48.433,1178.54,48.449z"/>
				<path d="M723.632,40.191c-0.396-0.029-0.78-0.066-1.197-0.075c-0.507,0-0.678,0.065-0.642,0.238
					c0.034,0,0.076,0,0.105,0.003C724.009,40.38,724.009,40.38,723.632,40.191z"/>
				<polygon points="715.415,40.38 715.272,40.196 714.447,40.188 714.589,40.372 "/>
				<path d="M738.997,40.702c0,0,0.089-0.175-0.442-0.181c-0.471,0-0.365,0.129-0.647,0.172
					c-0.012,0.003-0.024,0.003-0.035,0.003c-0.061,0.006-0.113,0.009-0.178,0.009c0.035,0.023,0.07,0.042,0.142,0.065
					C738.17,40.875,738.897,40.831,738.997,40.702z"/>
				<path d="M712.285,40.478c-0.146-0.085-0.429-0.149-0.607-0.227c-0.418,0.055-0.553,0.166-0.473,0.379
					c0.356,0.004,0.839,0.009,1.198,0.012C712.408,40.616,712.414,40.547,712.285,40.478z"/>
				<path d="M722.523,40.841c1.09-0.041,0.612-0.259,0.123-0.34c-0.249-0.04-0.442-0.043-0.531-0.046
					c-0.283,0-0.429,0.022-0.63,0.08C721.804,40.627,722.216,40.747,722.523,40.841z"/>
				<path d="M1184.017,48.478c0.852-0.168,0.73-0.536-0.246-0.82c-0.27,0.006-0.861,0.008-0.83,0.184
					c0.039,0.241,0.75,0.43,0.977,0.654C1183.948,48.49,1183.983,48.484,1184.017,48.478z"/>
				<path d="M719.742,41.376c0.606,0.01,1.231-0.003,0.961-0.28c-0.361-0.006-0.844-0.009-1.203-0.015l0.218,0.295
					C719.724,41.38,719.729,41.376,719.742,41.376z"/>
				<polygon points="716.428,41.25 716.276,41.046 715.456,41.041 715.604,41.242 "/>
				<path d="M735.207,41.727c-0.306,0.003-0.548,0.026-0.772,0.075c0.524,0.037,1.209,0.089,1.733,0.127
					C735.997,41.805,735.678,41.739,735.207,41.727z"/>
				<path d="M1181.493,49.075c0.037,0.028,0.078,0.058,0.148,0.084c0.242,0.094,0.717,0.141,1.582,0.151
					c0.1-0.246-0.656-0.289-0.896-0.299C1181.989,49.007,1181.737,49.024,1181.493,49.075z"/>
				<path d="M735.082,42.276c0.019-0.035-0.04-0.058-0.099-0.087c-0.012-0.002-0.025-0.005-0.042-0.012
					c-0.087-0.029-0.188-0.058-0.289-0.083c-0.418,0.095-0.377,0.158-0.277,0.189C734.546,42.339,735.042,42.345,735.082,42.276z"/>
				<path d="M696.553,42.276c0.119-0.139-0.046-0.19-0.612-0.202c-0.366,0-0.732,0.029-1.097,0
					c0.011,0,0.023,0.006,0.035,0.012C695.269,42.219,695.945,42.256,696.553,42.276z"/>
				<path d="M735.46,42.657c-0.914-0.003-0.925,0.161-0.936,0.385c0.005,0,0.011,0,0.022-0.003
					c0.744-0.008,1.285,0.173,2.076,0.115c-0.272-0.063-0.637-0.144-0.908-0.207l0.176-0.272
					C735.743,42.666,735.608,42.661,735.46,42.657z"/>
				<path d="M695.503,42.447c-0.534,0.029-0.317,0.125-0.199,0.167c0.237,0.078,0.801,0.173,1.249,0.132
					c-0.012-0.103-0.165-0.137-0.542-0.184C695.727,42.531,695.586,42.505,695.503,42.447z"/>
				<path d="M1903.05,32.196c1.252,0.144,1.697,0.112,1.936-0.133c0.232-0.017,0.363-0.017,0.918,0.026
					c0.83,0.064,1.072,0.041,1.279-0.118c-1.154-0.2-1.756-0.1-2.486,0.064c-0.152-0.047-0.369-0.104-0.521-0.149
					c0.693-0.023,1.074-0.173,1.48-0.578c-0.383-0.034-0.885-0.083-1.268-0.123c-0.08,0.222-0.313,0.275-0.783,0.345
					c-0.494,0.068-0.719,0.121-0.801,0.324c0.039,0,0.094,0,0.137,0.003c0.545,0,0.742,0.012,0.748,0.052
					c0.004,0.018-0.055,0.041-0.09,0.058C1903.427,32.044,1903.228,32.118,1903.05,32.196z"/>
				<path d="M1899.985,31.903c0.006,0.006,0.012,0.003,0.027,0.006c0.914,0.109,1.613-0.121,2.492-0.083
					c0.104-0.078,0.246-0.188,0.35-0.267c0.012-0.038,0.154-0.075-0.025-0.109c-0.227,0.022-0.545,0.246-0.615,0.351
					c-0.119-0.073-0.281-0.167-0.402-0.241c-0.436-0.033-0.912,0.034-1.334-0.023c0.123,0.115,0.092,0.135-0.098,0.184
					C1900.153,31.782,1900.087,31.826,1899.985,31.903z"/>
				<path d="M1244.597,40.162c1.428,0.023,2.137,0.012,2.447-0.212c-0.365,0.011-0.914,0.028-1.324,0
					c-0.592-0.034-1.051-0.127-1.592-0.179c-0.426,0.115-1.055,0.187-1.234,0.345c-0.486-0.012-0.502-0.026-0.771-0.218
					c-0.117-0.087-0.365-0.121-0.848-0.121c-0.025,0.462-0.025,0.534,0.389,0.678C1242.04,40.15,1242.89,40.134,1244.597,40.162z"/>
				<path d="M723.13,39.283c0.382,0.012,0.777,0.023,1.155,0.052c-0.135-0.068-0.359-0.181-1.363-0.166
					c-0.894,0.014-1.308-0.058-1.684-0.141c-0.188,0.037-0.26,0.06-0.212,0.105c0.024,0.003,0.03,0.007,0.036,0.012
					C721.332,39.212,721.897,39.237,723.13,39.283z"/>
				<path d="M1262.056,36.71c-0.092-0.005-0.24-0.011-0.367-0.063c-0.209-0.086-0.221-0.354,0.324-0.351
					c0,0.146,0.066,0.27,0.373,0.391C1262.28,36.699,1262.175,36.71,1262.056,36.71z"/>
				<polygon points="750.155,40.65 750.026,40.467 750.862,40.472 750.991,40.656 "/>
				<path d="M753.644,37.135c-0.095-0.005-0.224-0.005-0.343-0.04c-0.152-0.045-0.245-0.129-0.329-0.215
					c0.966-0.025,1.551,0.043,1.731,0.201C754.351,37.104,754.016,37.135,753.644,37.135z"/>
				<path d="M757.912,43.568c0.118,0.172,0.111,0.249-0.241,0.278c-0.419-0.147-0.501-0.239-0.55-0.405
					c-0.034-0.135-0.093-0.195-0.382-0.279c0.524,0.039,1.213,0.09,1.739,0.128C757.746,43.264,757.775,43.385,757.912,43.568z"/>
				<polygon points="772.353,40.409 773.188,40.414 773.307,40.602 772.469,40.593 "/>
				<path d="M773.154,42.206c-0.054-0.005-0.095-0.014-0.129-0.021c-0.154-0.055-0.262-0.182-0.203-0.245
					c0.043-0.037,0.153-0.074,0.52,0.058c0.012,0.003,0.023,0.009,0.042,0.015c0.005,0.006,0.022,0.008,0.034,0.014
					C773.342,42.08,773.236,42.148,773.154,42.206z"/>
				<polygon points="772.712,41.546 773.813,41.373 773.608,41.739 "/>
				<path d="M775.83,44.323c-0.138-0.003-0.273-0.003-0.389-0.015c-0.024,0-0.059-0.005-0.078-0.005
					c-0.042-0.053-0.089-0.13-0.135-0.185c0.283-0.141,0.672-0.08,0.824-0.046C776.353,44.137,776.736,44.325,775.83,44.323z"/>
				<path d="M775.109,43.938c-0.118-0.181,0.154-0.243,0.638-0.283c0.188,0.089,0.452,0.207,0.649,0.296L775.109,43.938z
					"/>
				<path d="M781.988,43.246c0.831,0.178,0.707,0.487-0.006,0.565c-0.184-0.052-0.366-0.103-0.524-0.16
					C780.745,43.396,781.322,43.304,781.988,43.246z"/>
				<path d="M783.315,44.936c-0.047,0.005-0.108,0.011-0.16,0.014c0.146-0.152-0.064-0.262-0.76-0.506
					c-0.707-0.244-0.866-0.358,0.502-0.425c-0.383,0.136-0.208,0.256,0.359,0.49C783.687,44.693,784.063,44.849,783.315,44.936z"/>
				<path d="M713.492,44.137c-0.016,0-0.04,0-0.059,0.003c-0.088-0.09-0.754-0.224-0.217-0.276
					c0.112,0.072,0.418,0.118,0.494,0.192C713.729,44.076,713.765,44.107,713.492,44.137z"/>
				<path d="M715.545,43.487c-0.12,0-0.294-0.006-0.579-0.061c-0.036-0.006-0.071-0.014-0.106-0.02
					c0.454-0.279,0.454-0.279-0.435-0.569c1.12-0.008,1.12-0.008,0.524-0.378c0.359,0.005,0.836,0.011,1.197,0.011
					c0.241,0.322,0.483,0.638,0.73,0.956C716.417,43.427,716.003,43.484,715.545,43.487z"/>
				<path d="M719.742,43.82c-0.06,0-0.107,0-0.166,0c-0.012,0-0.012,0-0.023,0c0.236-0.261,0.141-0.379-0.507-0.66
					c1.12,0.072,1.731,0.247,2.075,0.583C720.625,43.743,720.225,43.82,719.742,43.82z"/>
				<path d="M1.714,51.391c-0.224-0.09-0.375-0.185-0.599-0.271c0.044,0.037,0.103,0.089,0.147,0.126
					c-0.083,0-0.38-0.137-0.858-0.401C0.359,50.816,0.3,50.781,0.25,50.753c0.249,0.028,1.56,0.591,1.498,0.646
					C1.734,51.396,1.723,51.391,1.714,51.391z"/>
				<path d="M2.571,51.643c-0.144-0.051-0.188-0.118-0.372-0.166c-0.034,0.028,0.078,0.052,0.019,0.08
					C2.058,51.534,2.067,51.493,2,51.459c-0.115-0.063-0.384-0.213-0.313-0.229c0.123-0.025,0.903,0.379,0.89,0.413H2.571z"/>
				<polygon points="1889.911,31.576 1890.507,31.634 1890.274,31.812 1889.683,31.757 "/>
				<path d="M1889.595,31.921c0.016,0,0.037,0,0.055,0.003c0.039,0.006,0.078,0.048,0.078,0.052
					c-0.01,0.037-0.025,0.101,0.381,0.203c0.424,0.104,1.041,0.161,1.4,0.282c0.127,0.04,0.092,0.058-0.029,0.077
					c-1.076-0.146-1.076-0.146-2.213-0.207C1889.229,32.233,1889.401,31.97,1889.595,31.921z"/>
				<path d="M1871.187,30.931c1.686,0.037,2.861,0.318,4.316,0.467c0.756,0.078,0.789,0.07,1.131,0.023
					c0.236-0.034,3.645-0.014,3.664-0.014c0.902,0.061,1.551,0.218,2.365,0.315c0.523-0.21,1.445-0.336,2.098-0.52
					c0.674,0.046,0.996,0.2,1.604,0.261c0.148,0.015,0.295,0.025,0.459,0.025c-0.453,0.377-0.828,0.5-2.002,0.747
					c-0.447-0.092-0.744-0.121-0.844-0.126c-0.723-0.052-0.984-0.052-1.998-0.034c-1.166,0.022-1.326-0.018-1.496-0.058
					c-0.326-0.081-0.652-0.161-1.115-0.184c-0.359-0.018-0.813,0.065-1.166,0.092c-0.682-0.086-0.828-0.302-1.668-0.351
					c-1.008,0.17-1.008,0.17-1.518,0.063c-0.006,0-0.016,0.003-0.021,0.006c0.016-0.006,0.039-0.011,0.012-0.017
					c-0.006-0.003-0.012,0-0.018,0c-0.02,0-0.023,0.003-0.02,0.006c0,0.005,0.014,0.005,0.025,0.011
					c-0.123,0.023-0.254,0.041-0.389,0.058c-0.189-0.017-0.453-0.04-0.648-0.058c-0.543,0.044-0.709,0.058-0.867,0.052
					c-0.08,0-0.1-0.034-0.129-0.052c-0.23-0.16-0.658-0.194-0.75-0.203c-0.734-0.052-1.436,0.203-2.15,0.037
					c-0.41-0.098-0.588-0.133-0.871-0.149c-0.584-0.044-1.148,0.213-1.588,0.068c-0.008-0.005-0.023-0.008-0.039-0.017
					C1867.888,31.261,1868.872,30.879,1871.187,30.931z"/>
				<path d="M1861.403,30.64c0.525,0.063,0.99,0.149,1.539,0.202c0.385,0.034,0.611,0.037,1.031,0.024
					c-0.383,0.235-0.891,0.309-1.697,0.248c-0.207-0.121-0.785-0.19-0.924-0.319C1861.292,30.737,1861.337,30.695,1861.403,30.64z"/>
				<path d="M1859.79,30.496c-0.029,0.069,0.074,0.104,0.48,0.161c0.449,0.055,0.699,0.096,0.5,0.227
					c-0.523-0.095-0.875-0.049-1.096-0.008c-0.506,0.097-0.896,0.051-1.037,0.034c-0.006,0-0.018-0.003-0.018-0.003
					C1858.979,30.767,1859.394,30.635,1859.79,30.496z"/>
				<path d="M1857.36,29.876c-0.1,0.081-0.23,0.187-0.33,0.27c-0.107,0.003-0.225,0.006-0.342,0
					c-0.061-0.005-0.201-0.023-0.25-0.086c-0.012-0.011-0.012-0.028-0.012-0.04C1856.438,29.913,1856.853,29.755,1857.36,29.876z"/>
				<path d="M1855.532,30.227c0.242,0.149,0.146,0.322-0.547,0.265c-0.137-0.013-0.262-0.023-0.371-0.041
					c-0.025-0.006-0.055-0.012-0.07-0.012C1854.733,30.292,1855.058,30.221,1855.532,30.227z"/>
				<path d="M1840.319,29.836c0.078,0.031-0.105,0.087-0.482,0.063c-0.111-0.012-0.406-0.04-0.57-0.149
					c-0.006-0.006-0.012-0.012-0.021-0.018C1839.833,29.761,1840.231,29.799,1840.319,29.836z"/>
				<path d="M1728.3,37.641c0.404,0.028,0.945,0.063,1.346,0.092c-0.387,0.216,0.047,0.448-0.271,0.661
					c-0.619-0.043-1.156-0.081-1.334-0.265C1727.868,37.957,1728.165,37.732,1728.3,37.641z"/>
				<path d="M1725.216,37.802c0.836,0.029,1.529,0.108,1.002,0.465c-0.217-0.022-0.848-0.08-1.025-0.252
					C1725.106,37.925,1725.181,37.842,1725.216,37.802z"/>
				<path d="M1723.788,38.095c0.422,0.029,0.99,0.069,1.41,0.098c-0.006,0.045-0.184,0.232-0.42,0.459
					c-0.152-0.006-0.307-0.006-0.447-0.014c-0.189-0.015-0.611-0.049-0.736-0.176C1723.476,38.336,1723.681,38.175,1723.788,38.095z"/>
				<path d="M1718.896,38.002c1.426-0.014,2.926,0.106,4.002,0.313c-0.516,0.233-1.514,0.503-3.354,0.457
					c-0.625-0.08-0.813-0.271-1.584-0.311c-0.303-0.018-0.627,0-0.904-0.039c-0.047-0.01-0.117-0.018-0.139-0.029
					c-0.025-0.007-0.025-0.018-0.039-0.023C1716.856,38.33,1717.12,38.02,1718.896,38.002z"/>
				<path d="M1713.681,38.009c0.105-0.052,0.375-0.188,1.289-0.018c0.258,0.047,0.258,0.047,0.879,0.416
					c-0.342,0.026-0.627,0.084-0.982,0.104c-0.307,0.018-0.463,0.015-0.727-0.003c-0.158-0.009-0.313-0.022-0.455-0.046
					c-0.021,0-0.047-0.002-0.07-0.005C1713.663,38.308,1713.378,38.151,1713.681,38.009z"/>
				<path d="M1711.8,38.031c0.088,0.115,0.352,0.225,0.391,0.345c0.021,0.106-0.156,0.207-0.232,0.247
					c-0.463-0.029-0.732-0.132-1.168-0.173c-0.027,0-0.076-0.006-0.111-0.006C1710.868,38.146,1711.083,38.012,1711.8,38.031z"/>
				<path d="M1707.733,38.049c-0.338,0.034-0.566,0.04-0.996,0.015c-0.818-0.066-1.104-0.198-1.197-0.268
					c-0.119-0.086-0.061-0.152-0.018-0.195C1706.647,37.478,1708.063,37.71,1707.733,38.049z"/>
				<path d="M1425.616,37.865c-0.613-0.146-0.613-0.146-0.605-0.179c0.281,0.046,0.617,0.043,0.924,0.055
					c0.732,0.012,1.074,0.02,1.037,0.121c-0.422,0.055-0.686,0.155-1.143,0.204c-0.342,0.034-0.447-0.021-0.482-0.041
					c-0.018-0.011-0.037-0.026-0.049-0.034C1425.772,37.974,1425.983,37.948,1425.616,37.865z"/>
				<path d="M1431.771,37.744c-0.371-0.021-0.617-0.075-0.695-0.109c-0.16-0.065,0.096-0.105,0.768-0.114
					C1432.382,37.732,1432.03,37.75,1431.771,37.744z"/>
				<polygon points="1417.071,37.555 1417.813,37.587 1417.765,37.768 1417.024,37.736 "/>
				<path d="M1413.44,37.498c0.297,0.039,0.518,0.063,0.859,0.079c0.396,0.013,0.803-0.005,1.203,0.023
					c0.318,0.023,0.494,0.058,0.705,0.104c-0.789,0.018-0.93,0.098-0.459,0.27c-0.729-0.063-1.148,0-1.461,0.046
					c-0.41,0.058-0.768,0.109-1.658,0.016c-0.031-0.004-0.074-0.01-0.096-0.013c-0.107-0.092-0.254-0.215-0.363-0.304
					c0.363-0.05,0.822-0.003,1.164-0.066C1413.511,37.621,1413.47,37.543,1413.44,37.498z"/>
				<path d="M1412.534,36.516c-0.217,0.003-0.426,0-0.627-0.012c-0.383-0.017-0.846-0.058-1.131-0.213
					c-0.072-0.04-0.119-0.086-0.166-0.129C1411.577,36.005,1412.638,36.246,1412.534,36.516z"/>
				<path d="M1405.39,37.641c-0.119,0.023-0.342,0.061-0.582,0.052c-0.102-0.006-0.201-0.014-0.279-0.052
					c-0.041-0.022-0.082-0.046-0.059-0.068C1404.522,37.522,1404.847,37.446,1405.39,37.641z"/>
				<path d="M1348.181,38.829c-0.195-0.008-0.766-0.028-1.016-0.146c-0.049-0.028-0.08-0.06-0.092-0.092
					c0.043-0.008,0.082-0.02,0.129-0.025c0.578-0.083,1.633-0.017,1.428,0.264C1348.478,38.824,1348.331,38.832,1348.181,38.829z"/>
				<path d="M1327.063,36.464l-0.031,0.184c-0.129,0.021-0.201,0.023-0.387,0.018c-0.074-0.007-0.24-0.013-0.381-0.087
					c-0.057-0.025-0.102-0.052-0.109-0.083c0.008-0.003,0.008-0.123,0.359-0.136C1326.61,36.354,1326.61,36.354,1327.063,36.464z"/>
				<path d="M1312.075,38.482c-0.359-0.015-0.561-0.025-0.863-0.08c-0.209-0.035-0.303-0.052-0.707,0.008
					c-0.031,0.003-0.068,0.013-0.094,0.018c-0.072-0.041-0.23-0.138,0.236-0.178C1311.126,38.209,1312.476,38.273,1312.075,38.482z"/>
				<path d="M1306.644,37.54c-0.068-0.003-0.146-0.005-0.221-0.008c-0.012,0-0.02,0-0.031,0
					c0.025-0.139,0.277-0.21,0.861-0.244c0.111,0.057,0.258,0.138,0.373,0.194C1307.276,37.485,1307.005,37.549,1306.644,37.54z"/>
				<path d="M1307.157,38.135l-0.416,0.348c-0.145-0.096-0.631-0.112-0.832-0.195c-0.156-0.061-0.072-0.129,0.033-0.192
					C1306.312,38.106,1306.79,38.12,1307.157,38.135z"/>
				<path d="M1305.71,36.765c-0.098-0.025-0.178-0.052-0.25-0.08c-0.295-0.132-0.262-0.158,0.324-0.571
					c0.797,0.065,1.232,0.104,1.568,0.178C1307.606,36.349,1308.62,36.76,1305.71,36.765z"/>
				<path d="M1305.183,37.399c-0.623-0.023-1.037-0.034-1.189-0.105c-0.09-0.044-0.039-0.089-0.02-0.118
					c0.256,0.012,0.588,0.023,0.848,0.032L1305.183,37.399z"/>
				<polygon points="1296.171,37.189 1297.009,37.219 1296.991,37.417 1296.153,37.389 "/>
				<path d="M1295.845,36.618c-0.076-0.022-0.145-0.045-0.205-0.068c-0.207-0.098-0.33-0.293,0.627-0.282
					C1296.765,36.412,1296.813,36.63,1295.845,36.618z"/>
				<path d="M1297.317,38.077c0.012,0.006,0.027,0.012,0.043,0.015c0.424,0.127,0.527,0.287-0.27,0.267
					c-0.164-0.006-0.33-0.011-0.484-0.025c-0.021-0.003-0.063-0.003-0.088-0.009C1296.476,38.187,1296.714,38.111,1297.317,38.077z"/>
				<path d="M1294.743,37.328c-0.281-0.009-0.447-0.04-0.504-0.063c-0.152-0.06,0.205-0.112,0.32-0.123
					c0.205,0.028,0.412,0.061,0.564,0.103C1295.347,37.313,1295.101,37.337,1294.743,37.328z"/>
				<path d="M1293.644,38.049c0.359,0.152-0.219,0.188-0.666,0.175c-0.271-0.012-0.447-0.031-0.531-0.065
					c-0.049-0.018-0.049-0.038-0.035-0.058C1292.839,38.106,1293.202,38.035,1293.644,38.049z"/>
				<path d="M1290.95,36.458c-0.025,0.074-0.111,0.111-0.277,0.115c-0.385-0.023-0.725-0.179-0.82-0.225
					c-0.07-0.034-0.137-0.068-0.143-0.103C1289.716,36.165,1289.948,36.223,1290.95,36.458z"/>
				<path d="M1290.692,37.059c0.793-0.055,1.316-0.066,2.197,0.025c-0.078,0.315-0.891,0.305-3.32,0.27
					c-0.309-0.101-0.762-0.172-1.014-0.287c-0.092-0.04-0.141-0.086-0.178-0.132C1289.288,37.13,1289.776,37.121,1290.692,37.059z"/>
				<path d="M1291.567,38.164c-0.336,0.063-0.549,0.071-0.654,0.068c-0.049-0.003-0.164-0.009-0.248-0.043
					c-0.061-0.022-0.082-0.049-0.061-0.078C1290.644,38.072,1290.962,37.971,1291.567,38.164z"/>
				<path d="M1279.47,42.635l-0.451-0.209c2.9,0.24,6.105,0.103,8.977,0.378c0.285-0.065,0.213-0.172,0.531-0.229
					c0.123-0.023,0.459-0.087,2.279,0.263c0.365,0.075,0.391,0.136,0.438,0.265c-3.922-0.049-7.867-0.017-11.787-0.108
					c0.043-0.038,0.045-0.099-0.061-0.133c-0.184-0.063-0.523-0.087-0.752-0.138c-0.035-0.012-0.072-0.025-0.107-0.035
					C1278.755,42.611,1278.995,42.62,1279.47,42.635z"/>
				<path d="M1276.196,42.426c0.49,0.137,1.303,0.2,1.641,0.372c0.246,0.124-0.207,0.199-0.432,0.235
					c0.117-0.131,0.033-0.188-0.695-0.146c-0.908,0.049-1.191-0.05-1.285-0.084C1275.294,42.759,1275.374,42.494,1276.196,42.426z"/>
				<path d="M1274.14,42.27c0.236,0.213,0.41,0.489-0.648,0.463c-0.566-0.021-1.014-0.109-1.168-0.164
					c-0.023-0.006-0.045-0.014-0.051-0.022c-0.092-0.041-0.072-0.104,1.031-0.018C1273.323,42.379,1273.552,42.308,1274.14,42.27z"/>
				<path d="M1270.872,42.609c-0.104,0.16-1.424,0.134-1.984,0.114c-0.047,0-4.203-0.175-4.861-0.351
					c-0.391-0.109,0.045-0.293,0.885-0.299c1.436-0.017,2.604,0.189,3.959,0.242c0.578,0.014,1.182-0.029,1.721,0.052
					C1270.827,42.399,1270.989,42.426,1270.872,42.609z"/>
				<path d="M1258.065,38.457c2.137,0.105,2.137,0.105,3.273-0.07c2.229,0.294,4.879,0.199,7.248,0.359
					c-2.619,0.066-5.232,0.127-7.863,0.106c-0.111,0.081-0.264,0.187-0.379,0.268c-2.346-0.164-2.346-0.164-3.256-0.472
					C1257.378,38.591,1257.767,38.515,1258.065,38.457z"/>
				<path d="M1229.251,39.186c2.998,0.086,3.607-0.293,4.449-0.827c0.076,0.173,0.307,0.402,0.537,0.565
					c0.482-0.171,1.125-0.401,1.596-0.573c1.014,0.055,1.014,0.055,3.35-0.113c1.736,0.346,1.779,0.386,2.086,0.713
					c0.455-0.149,0.455-0.149,3.318-0.557c2.014,0.227,2.227,0.252,2.328,0.74c4.604,0.741,10.746,0.167,15.352,0.913
					c1.936-0.166,3.885,0.081,5.814-0.018c-0.094,0.107-0.225,0.251-0.318,0.356c-0.402,0.023-0.934,0.052-1.32,0.078
					c-0.014,0.08-0.014,0.189-0.023,0.267c2.004,0.373,2.004,0.373,2.238,0.672c-3.83-0.074-4.926-0.247-5.955-0.601
					c-0.646,0.251-0.646,0.563-1.455,0.802c-5.268-0.579-11.232-0.603-16.66-1.062c-0.125,0.074-0.297,0.177-0.42,0.252
					c-0.158-0.086-0.355-0.189-0.512-0.272c-1.592,0.123-3.326,0.065-4.895,0.209c-0.486,0.635-0.486,0.635,0.191,1.071
					c4.631,0.204,5.01,0.192,6.424,0.149c0.424,0.101,0.967,0.233,1.387,0.336c-0.162,0.075-0.373,0.173-0.525,0.247
					c-4.693-0.258-4.693-0.258-6.99-0.104c2.15,0.265,2.15,0.265,3.322,0.655c-0.301,0.037-0.707,0.086-1.002,0.12
					c43.904,1.332,69.951,2.148,97.232,3.139c-0.063-0.003-0.139-0.003-0.201-0.006c-29.615-0.947-69.48-1.736-98.705-3.179
					c-0.678-0.069-2.088-0.207-3.936-0.643c-0.932,0.071-1.664,0.235-2.664,0.27c-0.625,0.026-1.223-0.075-1.475-0.115
					c0.613-0.071,0.693-0.089,0.73-0.299c0.029-0.212,0.254-0.235,0.926-0.304c-0.371,0.017-0.857,0.04-1.232,0.058
					c0.195-0.371-0.729-0.696-0.879-1.052c0.395-0.006,1.008-0.017,1.264-0.086c0.867-0.242-0.637-0.735-2.523-0.686
					c-0.09-0.325-0.006-0.445,0.371-0.55c-0.26-0.068-0.449-0.097-1.055-0.154l-0.182-0.016l0.131,3.271
					c-0.111-0.987-0.256-2.303-0.369-3.29c-0.264-0.026-0.611-0.063-0.879-0.087c0.055-0.06,0.137-0.141,0.197-0.204
					c0.271-0.025,0.637-0.063,0.908-0.089c-0.025-0.123-0.014-0.262,0.018-0.401L1229.251,39.186z"/>
				<path d="M1261.845,42.447c-0.27,0.053-0.604,0.07-1.082,0.058c-0.156-0.005-0.627-0.022-0.863-0.12
					c-0.059-0.029-0.096-0.061-0.119-0.092C1260.331,42.195,1261.737,42.212,1261.845,42.447z"/>
				<path d="M1248.7,42.89c-0.039,0.109-0.158,0.438-1.992,0.394c-0.201-0.008-0.627-0.022-1.145-0.095
					c-0.047-0.003-0.105-0.011-0.15-0.017C1245.917,42.937,1246.966,42.919,1248.7,42.89z"/>
				<polygon points="782.385,51.022 783.22,51.028 783.355,51.209 782.525,51.201 "/>
				<polygon points="784.793,51.511 783.739,51.212 785.012,51.226 "/>
				<path d="M892.957,48.231c-0.213,0.167-0.259,0.301-0.302,0.626c-0.028,0.256-0.064,0.545-0.507,0.735
					c-0.023,0.011-0.064,0.023-0.088,0.031C891.017,49.153,890.564,48.269,892.957,48.231z"/>
				<path d="M891.753,47.382c0.224-0.089,0.926-0.096,1.179,0.115c-0.364,0.021-0.849,0.051-1.208,0.073
					C891.694,47.539,891.59,47.45,891.753,47.382z"/>
				<path d="M892.403,50.833c0.007,0.109,0.111,0.172,0.341,0.276c0.071,0.028,0.178,0.06,0.166,0.1
					c-0.011,0.05-0.283,0.066-0.619,0.087c-0.1-0.021-0.194-0.044-0.277-0.073C891.636,51.094,891.436,50.845,892.403,50.833z"/>
				<path d="M892.579,49.725c0.141,0.109,0.26,0.232-0.047,0.238c-0.276-0.009-0.454-0.063-0.5-0.077
					C891.954,49.86,891.624,49.73,892.579,49.725z"/>
				<path d="M1182.894,44.872l-0.836,0.065c0.063-0.222,0.08-0.301,0.807-0.25
					C1182.874,44.745,1182.88,44.814,1182.894,44.872z"/>
				<path d="M1180.63,44.171c-0.254-0.115-0.701-0.197-0.984-0.31c-0.248-0.092-0.113-0.136,0.221-0.179
					c0.344,0.104,0.154,0.287,0.947,0.322c0.109,0.003,0.217-0.007,0.33-0.007c-0.117,0.109-0.283,0.248-0.408,0.351
					C1180.765,44.32,1180.825,44.251,1180.63,44.171z"/>
				<path d="M1227.351,47.557c-0.398-0.018-0.799-0.035-1.211-0.049c-0.029,0-0.072,0-0.102,0
					c-0.043-0.256,0.275-0.267,1.361-0.178C1227.368,47.404,1227.376,47.479,1227.351,47.557z"/>
				<path d="M1224.237,48.157c-0.057-0.003-0.092-0.018-0.115-0.023c-0.051-0.023-0.082-0.04-0.094-0.061
					c-0.029-0.095,0.141-0.246,0.318-0.215C1224.581,47.903,1224.499,48.145,1224.237,48.157z"/>
				<path d="M1221.86,46.927c0.424,0,0.77-0.085,1.223-0.054c0.078,0.52,0.086,0.54-0.328,0.629
					c-1.426-0.038-1.889-0.167-1.957-0.19c-0.236-0.079,0.148-0.108,0.318-0.12c0.111,0.029,0.381,0.109,0.66,0.115
					C1222.177,47.314,1222.478,47.141,1221.86,46.927z"/>
				<path d="M1212.958,47.318c-0.104,0.006-0.502,0.022-0.801-0.08c-0.023-0.009-0.047-0.023-0.072-0.029
					c0.813-0.097,1.158-0.31,1.959-0.408c0-0.028-0.006-0.063-0.012-0.092c1.52,0.092,2.145,0.251,2.557,0.356
					c-0.033-0.299,0.377-0.281,3.006-0.187c0.223,0.006,0.436,0,0.65,0.003c0.016,0.184,0.033,0.367,0.059,0.551
					c-2.6-0.098-3.023-0.132-5.779-0.333C1214.009,47.175,1213.585,47.283,1212.958,47.318z"/>
				<polygon points="1214.173,47.909 1212.946,47.875 1212.923,47.694 1214.149,47.729 "/>
				<path d="M1234.448,42.999c0.066-0.095,0.146-0.109,0.293-0.138c0.109,0.049,0.184,0.101,0.254,0.155
					c-0.135,0.086-0.322,0.195-0.457,0.278C1234.509,43.206,1234.472,43.089,1234.448,42.999z"/>
				<path d="M1261.485,45.032c0.184,0.018,0.398,0.012,0.795-0.011c1.752-0.109,1.676,0.079,1.648,0.174
					c-0.373-0.068-0.646-0.079-1.227-0.054c-0.344,0.017-0.711,0.034-1.117-0.08C1261.548,45.053,1261.517,45.038,1261.485,45.032z"/>
				<path d="M1270.438,48.501c-1.025,0.058-1.24-0.028-1.438-0.115c-0.566-0.229-0.289-0.511,0.67-0.7
					c-0.025,0.077-0.02,0.155,0.203,0.17c0.646,0.009,1.367-0.153,1.943,0.009c0.307,0.089,0.313,0.109,0.307,0.629
					C1271.493,48.44,1271.146,48.461,1270.438,48.501z"/>
				<path d="M1278.456,46.035c-1.088-0.044-1.555-0.141-1.746-0.214c-0.143-0.054-0.154-0.089-0.164-0.134
					c1.334-0.075,2.666-0.029,4.09,0.025C1280.776,46.063,1279.007,46.049,1278.456,46.035z"/>
				<path d="M1280.187,46.91c-0.17-0.114-0.338-0.117-0.711-0.075c-0.295,0.032-0.598,0.055-0.842-0.042
					c-0.006,0-0.275-0.216,0.787-0.278c0.049,0.034,0.189,0.063,0.572,0.135C1280.704,46.778,1280.917,46.854,1280.187,46.91z"/>
				<path d="M1228.817,38.209c0.156,0.248,0.092,0.388-0.713,0.374c-0.152-0.006-0.307-0.012-0.447-0.023
					c-0.021-0.003-0.045-0.006-0.068-0.011c0-0.112,0-0.265-0.006-0.377L1228.817,38.209z"/>
				<path d="M1224.642,37.997c0.658,0.215,0.223,0.229,0,0.227c-0.383-0.015-0.674-0.065-0.754-0.097
					C1223.687,38.06,1223.944,38.015,1224.642,37.997z"/>
				<path d="M1071.159,38.887c-0.07-0.017-0.129-0.031-0.189-0.052c-0.113-0.04-0.119-0.074-0.006-0.097
					c0.262-0.058,1.461-0.04,1.434,0.068C1072.022,38.829,1071.526,38.864,1071.159,38.887z"/>
				<path d="M1001.851,41.099c-0.207-0.227,0.021-0.345,0.734-0.368c-0.006,0.146-0.086,0.305-0.684,0.365
					C1001.89,41.096,1001.868,41.099,1001.851,41.099z"/>
				<path d="M1018.407,42.185c-0.52-0.087-0.613-0.104-0.543-0.256c0.695-0.066,1.285-0.199,2.119-0.184
					c0.652,0.011,1.041,0.148,1.299,0.243c-0.824,0.061-1.402,0.132-1.77,0.31c-0.51,0.245-0.307,0.516-0.461,0.771
					c-0.504-0.021-0.896-0.04-1.205-0.108c-0.324-0.075-0.361-0.17-0.385-0.299c-0.033-0.207-0.105-0.259-0.34-0.365
					c0.148-0.012,0.34-0.018,0.783,0.037c0.207,0.029,0.359,0.074,0.594,0.093c0.146,0.008,0.191-0.013,0.232-0.036
					C1018.946,42.284,1018.536,42.206,1018.407,42.185z"/>
				<path d="M1021.87,39.763c0.336,0.153,0.545,0.204,1.313,0.279c-0.332,0.074-0.508,0.098-0.781,0.095
					c-0.252-0.016-0.393-0.037-0.789-0.21c-0.141-0.061-0.564-0.247-1.484-0.213c-0.02,0.003-0.037,0.003-0.047,0.003
					c-0.602-0.738-0.602-0.738,0.176-0.942c-0.201-0.082-0.219-0.089-0.641-0.131c-0.826-0.087-0.85-0.118-0.82-0.273
					c0.494-0.094,0.908-0.089,1.625,0.023c0.793,0.121,0.961,0.126,1.436,0.132c-0.025,0.339-1.191,0.586-1.398,0.907
					C1021.247,39.533,1021.495,39.594,1021.87,39.763z"/>
				<path d="M1019.833,39.835c0.211,0.071,0.43,0.081,0.643,0.086c0.184,0.003,0.361,0.003,0.527-0.005
					c-0.109,0.344,0.787,0.683,0.211,1.033c-0.119,0.077-0.498,0.311-2.301,0.253c-0.012,0-0.023,0-0.029,0
					c-0.254-0.259-0.254-0.374-0.217-0.66c0.051-0.356-0.027-0.534-0.273-0.856C1019.126,39.651,1019.433,39.702,1019.833,39.835z"/>
				<path d="M1018.782,43.441c-0.131,0.022-0.193,0.029-0.395,0.022c-0.066,0-0.238-0.005-0.428-0.074
					c-0.357-0.133-0.055-0.243,0.324-0.241c0.129,0.032,0.299,0.081,0.428,0.108L1018.782,43.441z"/>
				<path d="M1017.368,40.3c-0.023,0.063-0.225,0.096-0.293,0.106c-0.273,0.043-0.615,0.049-0.896,0.089
					c-0.02,0-0.043,0.006-0.057,0.006c-0.049-0.195-0.756-0.322-1.023-0.488c0.236-0.005,0.736-0.012,1.27,0.023
					C1017.452,40.11,1017.429,40.174,1017.368,40.3z"/>
				<path d="M1016.644,40.875c-0.123,0.021-0.211,0.025-0.393,0.021c-0.072-0.002-0.25-0.005-0.424-0.076
					c-0.084-0.032-0.16-0.061-0.16-0.095c-0.008-0.244,0.688-0.087,0.918-0.034L1016.644,40.875z"/>
				<polygon points="1015.14,43.852 1014.269,43.838 1014.194,43.64 1015.071,43.654 "/>
				<path d="M1014.704,43.936c0.137,0.264-0.146,0.442-0.965,0.617c-0.018,0.006-0.047,0.009-0.066,0.014
					C1013.71,43.995,1013.71,43.936,1014.704,43.936z"/>
				<path d="M1030.767,39.995c0.545,0.021,0.688,0.023,1.184,0.09c0.531,0.065,0.934,0.175,1.449,0.246
					c-0.166,0.342,0.33,0.688,0.018,1.034c-0.195,0.212-0.885,0.296-1.252,0.342l-0.904-0.109
					C1031.142,41.063,1030.876,40.529,1030.767,39.995z"/>
				<path d="M1164.694,49.488c0.627,0.006,1.371,0.058,1.359,0.302c-0.111,0.01-0.213,0.01-0.324,0.01
					c-0.123-0.006-0.354-0.013-0.537-0.087C1165.003,49.644,1164.966,49.552,1164.694,49.488z"/>
				<polygon points="1036.931,37.761 1036.585,37.939 1035.651,37.739 "/>
				<path d="M1019.396,37.448c2.088-0.151,2.088-0.151,2.973-0.146c0.061,0.139,0.398,0.253,0.514,0.391
					c-0.67,0.068-0.787,0.081-1.057,0.419c0.43,0.013,0.93,0.018,1.381,0.029c-0.838,0.04-1.643,0.092-2.355,0.184
					c-0.117-0.068-0.264-0.16-0.375-0.235C1019.608,37.63,1019.608,37.63,1019.396,37.448z"/>
				<path d="M892.744,44.868c0.041,0.01,0.095,0.021,0.129,0.032c0.526,0.126,0.377,0.2-0.07,0.195
					c-0.224-0.003-0.335-0.026-0.372-0.04C892.272,45.009,892.379,44.946,892.744,44.868z"/>
				<path d="M982.11,47.422c1.496,0.025,3.055,0.052,4.58,0.08c-3.355-0.052-6.742-0.104-10.16-0.151
					C978.392,47.372,980.192,47.398,982.11,47.422z"/>
				<path d="M792.203,51.678c-1.473-0.092-1.473-0.092-1.686-0.156c-0.16-0.054-0.183-0.114-0.2-0.149
					C791.525,51.367,792.073,51.453,792.203,51.678z"/>
				<path d="M789.839,50.253c0.549,0.187,1.067,0.362,0.377,0.38c-0.028,0.002-0.065,0-0.087,0.002
					c-0.025-0.015-0.055-0.022-0.083-0.034c-0.012-0.004-0.024-0.009-0.036-0.012c-0.006-0.003-0.025-0.009-0.035-0.014
					c-0.024-0.007-0.048-0.018-0.071-0.023c-0.018-0.006-0.023-0.012-0.048-0.018C789.338,50.345,789.327,50.264,789.839,50.253z"/>
				<path d="M788.915,49.038c-0.584-0.003-0.879-0.008-1.097-0.065c-0.224-0.063-0.2-0.142-0.166-0.311
					c0.04-0.185,0.083-0.355-1.208-0.298c-0.029-0.038-0.076-0.094-0.071-0.128c0.055-0.204,1.067-0.151,1.08-0.149
					c0.507,0.093,0.642,0.248,0.813,0.498C788.429,48.814,788.537,48.936,788.915,49.038z"/>
				<path d="M785.625,46.101c0.671,0.534,0.459,1.125,1.927,1.611c-0.5,0.238-0.676,0.313-1.219,0.333
					c-0.107-0.003-0.295-0.009-0.531-0.049c-0.012-0.003-0.695-0.155,0.19-0.204c0.541-0.029,0.518-0.043,0.218-0.224
					c-1.48-0.88-1.48-0.88-1.551-0.968c-0.036-0.052-0.06-0.109-0.06-0.161C784.576,46.188,785.341,46.124,785.625,46.101z"/>
				<path d="M783.539,50.385c0.07,0.021,0.14,0.041,0.205,0.063c0.019,0.01,0.043,0.019,0.064,0.023
					c0.343,0.133,0.425,0.235,0.461,0.374c-0.313-0.006-1.145-0.015-1.602-0.154c-0.355-0.115-0.355-0.259-0.343-0.316
					C782.683,50.374,783.173,50.379,783.539,50.385z"/>
				<path d="M760.15,49.3c-0.046,0.08-0.11,0.188-0.165,0.27l-0.447-0.095C759.426,49.325,759.62,49.271,760.15,49.3z"/>
				<path d="M757.416,47.109c0.071,0.034,0.183,0.065,0.171,0.108c-0.019,0.049-0.366,0.072-0.571,0.083
					c-0.106-0.018-0.19-0.046-0.273-0.071c-0.021-0.009-0.058-0.021-0.081-0.026c-0.036-0.018-0.932-0.358,0.448-0.278
					C757.175,46.987,757.285,47.049,757.416,47.109z"/>
				<path d="M756.433,45.762c0.016,0.006,0.029,0.012,0.041,0.018c0.119,0.052,0.111,0.08,0.036,0.167
					c-0.114,0.108-0.12,0.184,0.099,0.32c-0.323,0-0.595,0.047-0.914,0.052c-0.07-0.002-0.141-0.011-0.188-0.022
					c-0.047-0.012-0.072-0.029-0.106-0.04c0.112-0.047,0.059-0.092-0.154-0.207c-0.129-0.081-0.281-0.17-0.224-0.232
					C755.07,45.75,755.913,45.604,756.433,45.762z"/>
				<polygon points="751.604,47.065 751.746,47.249 750.544,47.238 750.401,47.055 "/>
				<path d="M748.988,45.438c0.342-0.161,0.937-0.075,0.943-0.072c0.235,0.04,0.2,0.282-0.795,0.282
					c-0.153-0.007-0.408-0.012-0.609-0.069c-0.036-0.012-0.082-0.035-0.116-0.046C748.734,45.532,748.846,45.504,748.988,45.438z"/>
				<path d="M231.698,43.573c-0.377,0.029-0.672,0.018-1.886-0.092c-0.517-0.052-1.032-0.095-1.58-0.12
					c-0.519,0.212-1.145,0.224-3.364,0.167c-1.311-0.033-1.716-0.013-2.171,0.057c-0.046-0.221-0.11-0.232-0.216-0.253
					c-0.259,0.018-0.342,0.087-0.614,0.098c-0.164,0.007-0.271-0.006-0.399-0.055c0.755-0.428-2.382-0.376-3.313-0.629
					c-0.059-0.02-0.131-0.045-0.178-0.063c0.991,0.009,6.095,0.08,8.7,0.379c0.167-0.063,0.396-0.155,1.379-0.149
					c1.31,0.006,2.523,0.12,3.784,0.173C232,43.255,232.264,43.531,231.698,43.573z"/>
				<path d="M215.066,42.626c-0.024-0.006-0.049-0.012-0.07-0.015c0.67-0.106,1.896-0.036,2.711,0.244
					C216.773,42.821,215.878,42.774,215.066,42.626z"/>
				<path d="M233.991,40.856c0.019-0.022,0.089-0.086,0.63,0.069c-0.059,0.035-0.142,0.072-0.294,0.069
					c-0.094,0-0.165-0.018-0.218-0.038C234.02,40.929,233.985,40.88,233.991,40.856z"/>
				<path d="M724.397,51.169c-0.312,0.407-0.312,0.407,0.579,0.654c-0.426,0.015-0.844,0.032-1.273,0.032
					c-0.343-0.007-0.621-0.021-1.014-0.149c-0.089-0.028-0.165-0.057-0.243-0.089C723.573,51.574,723.343,51.226,724.397,51.169z"/>
				<path d="M719.021,46.565c0.266-0.051,0.408-0.08,0.583-0.08c0.294,0.006,0.513,0.111,0.631,0.172
					c-0.365,0.035-0.683,0.092-1.108,0.096c-0.094-0.004-0.27-0.01-0.395-0.044c-0.078-0.023-0.099-0.045-0.135-0.068
					C718.75,46.617,718.892,46.595,719.021,46.565z"/>
				<path d="M715.272,44.596c1.108-0.068,3.95,0.477,3.147,0.813c-0.177-0.081-0.447-0.201-1.16,0.058
					c-0.237,0.089-0.425,0.146-0.644,0.076c-0.045-0.014-0.082-0.028-0.116-0.045c0.542-0.035,0.471-0.058-0.024-0.139
					c-0.496-0.08-0.572-0.104-0.59-0.16c0.814,0.029,0.973-0.106,1.049-0.173c-0.849-0.08-1.19-0.29-1.932-0.399
					C715.084,44.613,715.168,44.603,715.272,44.596z"/>
				<path d="M715.227,45.848c-0.224,0.044-0.353,0.052-0.577,0.052c-0.685-0.011-1.338-0.201-2.052-0.431
					c-0.017-0.006-0.042-0.012-0.047-0.015C713.858,45.469,714.766,45.604,715.227,45.848z"/>
				<path d="M711.459,51.597c-0.902-0.068-1.921,0.233-2.692,0.006c-0.03-0.009-0.066-0.023-0.095-0.028
					c0.66-0.038,1.249-0.142,1.968-0.135C711.195,51.447,711.359,51.542,711.459,51.597z"/>
				<polygon points="709.614,50 709.786,50.198 708.602,50.185 708.437,49.989 "/>
				<path d="M710.364,50.851c-0.578-0.029-0.684,0.112-1.02,0.169c-0.414-0.06-0.896-0.135-1.239-0.25
					c-0.472-0.16-0.501-0.33-0.517-0.413C709.367,50.296,709.975,50.561,710.364,50.851z"/>
				<polygon points="695.558,44.906 695.481,44.889 695.469,44.797 "/>
				<path d="M635.906,43.55c-3.41-0.034-6.77-0.068-10.103-0.103C629.109,43.481,632.526,43.516,635.906,43.55z"/>
				<path d="M622.226,43.413c-93.73-0.939-157.455-1.608-208.651-2.24C465.42,41.811,529.933,42.488,622.226,43.413z"/>
				<path d="M393.935,18.163c-0.326,0.08-0.985,0.215-1.852,0.215c-0.207-0.005-0.689-0.018-1.096-0.167
					c-0.159-0.06-0.254-0.126-0.343-0.188C390.991,17.962,393.633,17.792,393.935,18.163z"/>
				<path d="M386.625,19.722c0.047,0.216-0.159,0.294-1.408,0.288c-0.59-0.012-1.173-0.034-1.75-0.058
					c-0.491-0.018-0.95-0.034-1.279-0.028c-0.237,0.008-0.501,0.068-0.909,0.165c-0.359,0.09-0.463,0.104-0.825,0.147
					c-0.271,0.031-0.753,0.028-0.955,0.025c-0.194-0.103-0.589-0.166-0.895-0.246c-0.26-0.069-0.294-0.121-0.366-0.219
					c0.573-0.141,1.12-0.253,2.559-0.264c0.83-0.01,2.122,0.063,2.604,0.086C384.863,19.696,385.475,19.704,386.625,19.722z"/>
				<path d="M377.105,17.729c0.56,0,3.383,0.026,4.208,0.435c-1.237,0.299-2.623,0.445-4.113,0.439
					c-0.573-0.018-1.626-0.046-2.712-0.339c-0.118-0.029-0.248-0.074-0.354-0.106C376.021,17.755,376.139,17.729,377.105,17.729z"/>
				<path d="M359.105,19.429c0.565,0.127,0.772,0.219,0.801,0.351c0.048,0.23-0.636,0.425-0.602,0.655
					c-0.335-0.023-1.037-0.072-1.521-0.253C356.358,19.659,358.822,19.449,359.105,19.429z"/>
				<path d="M355.499,21.956c0.306-0.025,0.583-0.005,0.788,0.012c0.089,0.109,0.219,0.259,0.308,0.371
					c-1.179-0.018-1.532-0.026-1.845-0.13c-0.169-0.061-0.218-0.127-0.241-0.172C354.883,22.037,355.167,21.985,355.499,21.956z"/>
				<path d="M317.681,18.074c0.371-0.181,1.144-0.29,1.531-0.466c1.239,0.115,1.416,0.081,3.597-0.327
					c2.233,0.175,3.979-0.2,5.987-0.272c0.862,0.16,1.363,0.416,2.5,0.505c2.976,0.003,2.976,0.003,4.066-0.112
					c0.638,0.156,1.097,0.225,2.052,0.305c0.082,0.232,0.118,0.331,1.145,0.505c0.859,0.149,0.907,0.173,0.753,0.356
					c-1.91-0.045-3.661,0.144-5.517,0.184c-4.417-0.836-4.417-0.836-6.437-0.93c-2.471-0.121-4.079,0.141-4.998,0.382l-1.498-0.026
					c-0.696,0.092-1.138,0.265-1.974,0.311c-0.266,0.017-0.691,0.02-1.255-0.13C317.287,18.266,317.681,18.074,317.681,18.074z"/>
				<path d="M336.017,20.003c-0.342,0.041-0.571,0.052-1.053,0.047c-0.19-0.003-0.578-0.012-1.263-0.074
					c-0.036-0.004-0.082-0.007-0.119-0.013c-0.07-0.052-0.211-0.154,0.095-0.232C334.162,19.61,335.94,19.653,336.017,20.003z"/>
				<path d="M325.686,21.132l-1.196-0.02c-0.065-0.046-0.23-0.167,0.017-0.238
					C324.784,20.796,325.598,20.851,325.686,21.132z"/>
				<path d="M306.424,17.525c0.896-0.339,3.831-0.528,4.797,0.316c-0.401,0.111-1.114,0.232-3.147,0.203
					c-0.33-0.005-1.097-0.022-1.792-0.092c-0.065-0.005-0.141-0.018-0.194-0.022C306.046,17.839,305.988,17.689,306.424,17.525z"/>
				<path d="M298.359,21.04c-0.96,0.405-3.417,0.21-4.279,0.061c-0.076-0.012-0.164-0.029-0.234-0.04
					c1.2-0.489,5.55-0.104,5.592-0.098c0.471-0.447,2.823-0.392,4.296-0.021c-0.782,0.17-1.272,0.21-2.367,0.199
					C300.363,21.118,299.369,21.063,298.359,21.04z"/>
				<path d="M299.799,21.7c-0.596,0.089-0.992,0.112-1.634,0.102c-0.418-0.01-0.818-0.029-1.23-0.047
					c-0.061-0.003-0.142-0.006-0.203-0.008c0-0.015-0.01-0.029-0.01-0.037C296.687,21.33,298.814,21.477,299.799,21.7z"/>
				<path d="M292.384,18.887c0.022-0.241,0.235-0.29,0.736-0.348c0.377,0.127,0.377,0.127,0.189,0.563
					c2.64,0.442,4.768,0.575,9.918,0.908c-0.306,0.356-0.877,0.425-3.217,0.388c-1.551-0.021-1.886,0.008-2.434,0.071
					c-1.739-0.45-4.62-0.574-6.118-1.097c-0.101-0.035-0.213-0.084-0.302-0.115C292.207,19.24,292.349,19.165,292.384,18.887z"/>
				<path d="M290.909,19.943c0.531,0.049,0.813,0.055,1.087-0.038c0.353,0.294-0.501,0.371-1.063,0.369
					c-0.689-0.021-1.049-0.127-1.196-0.186c-0.1-0.039-0.165-0.086-0.207-0.129C289.685,19.929,290.003,19.86,290.909,19.943z"/>
				<path d="M254.203,18.731c-1.157,0.066-1.157,0.066-1.469-0.126c0.862,0.009,1.232-0.028,1.503-0.146
					c-0.112-0.012-0.271-0.023-0.378-0.034c-1.461-0.173-4.833-1.615,1.12-1.987c0.2,0.06,0.483,0.144,0.784,0.178
					c0.951,0.103,2.046,0.081,3.012,0.173c0.802,0.074,1.302,0.252,2.145,0.314c0.241,0.019,1.273,0.006,0.861-0.255
					c-0.294-0.188-1.313-0.154-1.746-0.301c1.05,0.054,2.335-0.179,3.183,0.108c1.433,0.482,1.433,0.482,2.859,0.514
					c1.893,0.026,3.766-0.111,5.67-0.031l4.426,0.311c0.448,0.04,0.53,0.08,0.673,0.154c-1.852,0.107-2.77,0.165-7.026,0.098
					c-5.199-0.08-8.954-0.135-10.845,0.293c1.201,0.164,2.77,0.123,3.865,0.351c-0.118,0.265-0.955,0.472-1.201,0.729
					c-1.828-0.061-3.29-0.365-5.164-0.399c-0.877-0.018-0.885,0.199-1.439,0.271c-0.194-0.026-0.341-0.071-0.482-0.112
					c-0.131,0.028-0.325,0.058-0.461,0.086l0.431,0.189c3.62,0.109,7.256-0.017,10.882,0.035c0.029-0.193,0.052-0.201,0.718-0.448
					c2.428,0.143,2.428,0.143,2.965,0.232c-0.143,0.117-0.448,0.227-0.389,0.353c2.179,0.34,7.061,0.408,9.141,0.438
					c7.585,0.108,7.829,0.201,8.464,0.459c-0.548,0.379-2.128,0.228-3.354,0.031c-0.235,0.044-0.235,0.044-3.708,0.204
					c-0.359-0.083-1.114-0.252-2.056-0.259c-1.02-0.011-1.97,0.109-3.002,0.086c-1.691-0.039-3.328-0.16-5.044-0.165
					c-3.908-0.019-7.803-0.075-11.711-0.063c-1.439,0.006-2.005,0.126-2.464,0.224c0.524,0.204,0.524,0.204,1.19,1.025
					c-6.312-0.015-6.312-0.015-7.008-0.046c-0.607-0.405-1.137-0.606-2.352-0.595c-0.012,0.003-0.036,0-0.051,0.003
					c-0.12-0.262,0.876-0.469,0.682-0.738c-0.029-0.037-0.294-0.058-0.429-0.086c-0.759-0.155-0.873-0.264-1.403-0.778
					C250.766,19.32,252.723,19.133,254.203,18.731z"/>
				<path d="M265.036,18.384c-0.144-0.02-0.144-0.02-0.531,0.075c-0.171,0.04-0.248,0.037-0.4-0.018
					c-0.013-0.006-0.023-0.012-0.047-0.021c-0.03-0.017-0.071-0.04-0.101-0.057C264.793,18.252,264.882,18.237,265.036,18.384z"/>
				<polygon points="266.249,27.148 265.742,27.136 265.566,26.958 266.071,26.971 "/>
				<path d="M257.225,23.314c-0.289-0.037-0.619-0.032-1.143-0.02c-0.537,0.011-0.968,0.017-1.243-0.078
					c-0.129-0.043-0.178-0.095-0.224-0.146c0.248,0.063,0.412,0.086,0.712,0.095c0.448,0.006,0.866-0.054,1.327-0.02
					C256.937,23.169,257.119,23.261,257.225,23.314z"/>
				<path d="M252.193,23.119c0.459,0.003,0.872-0.078,1.348-0.043c0.36,0.022,0.524,0.093,0.708,0.178
					c-1.025-0.058-2.251,0.075-3.1-0.155c0.53-0.114,0.2-0.166-0.661-0.275c-0.437-0.057-1.037-0.135-1.357-0.246
					c-0.199-0.075-0.224-0.133-0.234-0.176c1.267-0.043,4.349-0.089,5.463,0.396c-1.032-0.009-1.238,0.039-2.399,0.318
					C252.045,23.116,252.115,23.116,252.193,23.119z"/>
				<path d="M244.902,24.618c0.14,0.123,0.199,0.27-0.326,0.262c-0.064,0-0.122-0.003-0.194-0.003
					c-0.012-0.003-0.023,0-0.03-0.003C244.063,24.621,244.488,24.595,244.902,24.618z"/>
				<path d="M240.834,33.736c0.389,0.017,1.203,0.187,0.706,0.263l-1-0.206
					C240.551,33.771,240.563,33.724,240.834,33.736z"/>
				<path d="M234.28,36.271c-0.189-0.003-0.378-0.008-0.566-0.014c-0.023,0.003-0.061,0-0.082,0
					c-0.083-0.061-0.195-0.146-0.173-0.218c0.065-0.219,1.41-0.023,1.422-0.018C234.893,36.021,235.563,36.291,234.28,36.271z"/>
				<path d="M232.429,29.554c-0.482-0.068-0.884,0.023-0.884,0.023c-0.182,0.047-0.325,0.068-0.501,0.006
					c-0.057-0.02-0.1-0.04-0.146-0.063C231.002,29.479,232.04,29.331,232.429,29.554z"/>
				<path d="M230.041,29.595c-0.124-0.005-0.289-0.052-0.412-0.092c-0.006-0.003-0.025-0.006-0.041-0.012
					c0.283-0.111,0.464-0.089,0.578-0.049c0,0,0.005,0.003,0.011,0.006C230.33,29.522,230.201,29.595,230.041,29.595z"/>
				<path d="M238.169,22.462c-2.533-0.058-3.212-0.075-3.855-0.333c-0.094-0.038-0.175-0.081-0.248-0.121
					C237.639,22.318,237.639,22.318,238.169,22.462z"/>
				<path d="M233.053,18.844c0.152,0.087,0.367,0.197,0.52,0.286l-0.542-0.014c-0.065-0.022-0.143-0.049-0.189-0.072
					C232.488,18.89,232.901,18.857,233.053,18.844z"/>
				<path d="M412.142,41.155c-1.74-0.022-3.47-0.042-5.182-0.063C408.686,41.113,410.386,41.133,412.142,41.155z"/>
				<path d="M192.421,43.723c0.465,0.275-0.391,0.278-0.566,0.275c-0.626-0.024-0.966-0.126-1.099-0.171
					c-0.164-0.064-0.199-0.115-0.228-0.156C191.158,43.688,191.789,43.706,192.421,43.723z"/>
				<path d="M187.258,50.833c-5.389-0.229-8.713-0.551-9.036-0.62c-0.184-0.04-0.361-0.109-0.478-0.161
					c0.602,0.058,0.913,0.063,2.652,0.086C185.399,50.201,186.656,50.626,187.258,50.833z"/>
				<path d="M176.884,41.871c-0.013,0.003-0.024,0.003-0.036,0.008c-0.237-0.413-0.237-0.413-0.118-0.448
					C177.52,41.655,177.172,41.828,176.884,41.871z"/>
				<path d="M168.3,40.831c2.57,0.095,4.51,0.225,7.411,0.497c0.212,0.189,0.169,0.241-0.184,0.235
					c-0.925-0.028-0.925-0.028-0.931,0.08c-0.201-0.138-0.272-0.166-0.708-0.261c-0.171-0.038-0.317-0.078-0.436-0.123
					c0,0.017-0.006,0.037-0.012,0.051c-0.083,0.167-0.667,0.136-0.978,0.115c-0.602-0.029-1.085-0.118-1.657-0.166
					c-0.301-0.026-0.625-0.023-0.924-0.05c-0.095-0.008-0.235-0.022-0.33-0.031c-0.226-0.023-0.484-0.078-0.649-0.12
					C168.672,41.001,168.46,40.903,168.3,40.831z"/>
				<path d="M159,49.386c0.013,0,0.414,0.144-0.154,0.129c-0.435-0.017-1.095-0.126-1.373-0.226
					c-0.04-0.016-0.076-0.029-0.11-0.047C158.318,49.271,158.711,49.282,159,49.386z"/>
				<path d="M150.759,41.776c-0.211-0.006-0.423,0.005-0.634,0.003c-0.078-0.003-0.213-0.009-0.326-0.055
					c-0.052-0.018-0.082-0.04-0.111-0.063C150.006,41.695,150.444,41.742,150.759,41.776z"/>
				<path d="M147.555,41.271c0.129,0.034,0.342,0.16,0.141,0.158c-0.095-0.006-0.2-0.023-0.484-0.106
					c