<?php
class SelectCoreElementorImageWithText extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_image_with_text'; 
	}

	public function get_title() {
		return esc_html__( 'Image With Text', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-image-with-text';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Link Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_blank' => esc_html__( 'New Window', 'select-core'),
					'_self' => esc_html__( 'Same Window', 'select-core')
				),
				'default' => '_blank',
				'condition' => [
					'link!' => ''
				]
			]
		);

		$this->add_control(
			'bottom_buttons',
			[
				'label'     => esc_html__( 'Enable Bottom Double Custom Link Functionality', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default'   => 'no'
			]
		);
		$this->add_control(
			'bottom_button_one_link',
			[
				'label'     => esc_html__( 'First Bottom Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'bottom_buttons' => 'yes'
				],
			]
		);
		$this->add_control(
			'bottom_button_one_label',
			[
				'label'     => esc_html__( 'First Bottom Link Label', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'bottom_buttons' => 'yes'
				],
			]
		);
		$this->add_control(
			'bottom_button_two_link',
			[
				'label'     => esc_html__( 'Second Bottom Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'bottom_buttons' => 'yes'
				],
			]
		);
		$this->add_control(
			'bottom_button_two_label',
			[
				'label'     => esc_html__( 'Second Bottom Link Label', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'bottom_buttons' => 'yes'
				],
			]
		);

		$this->add_control(
			'loading_animation',
			[
				'label'     => esc_html__( 'Enable Loading Animation', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'loading_animation_delay',
			[
				'label'     => esc_html__( 'Loading Animation Delay', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Specify loading animation delay time in miliseconds.', 'select-core' ),
				'condition' => [
					'loading_animation' => array( 'yes' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['image']     = !empty($params['image']) ? $params['image']['id'] : $params['image'];
		$params['holder_classes'] = $this->getHolderClasses($params);
        $params['holder_data'] = $this->getHolderData($params);
        $params['title_styles'] = $this->getTitleStyles($params);

		echo qodef_core_get_shortcode_template_part('templates/image-with-text-template', 'image-with-text', '', $params);

	}

    private function getHolderClasses($params) {
        $classes = array();

        $classes[] = 'qodef-image-with-text';

        if ($params['loading_animation'] == 'yes') {
            $classes[] = 'qodef-loading-animation';
        }

	    $classes[] = $params['bottom_buttons'] === 'yes' ? 'qodef-has-bottom-buttons' : '';

        return implode(' ', $classes);
    }

    private function getHolderData($params) {
        $data = array();

        if (!empty($params['loading_animation_delay']) && ($params['loading_animation'] == 'yes')) {
            $data['data-loading-animation-delay'] = $params['loading_animation_delay'];
        }

        return $data;
    }

    private function getTitleStyles($params) {
        $title_styles = array();

        if ($params['title_color'] !== '') {
            $title_styles[] = 'color:' . $params['title_color'];
        }

        return implode(';', $title_styles);
    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorImageWithText() );