<?php
class SelectCoreElementorAudioPlaylist extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_audio_playlist'; 
	}

	public function get_title() {
		return esc_html__( 'Audio Playlist', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-audio-playlist';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'playlist_type',
			[
				'label'     => esc_html__( 'Playlist Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'sound-cloud' => esc_html__( 'SoundCloud', 'select-core'),
					'spotify' => esc_html__( 'Spotify', 'select-core'),
					'bandcamp' => esc_html__( 'Bandcamp', 'select-core')
				),
				'default' => 'sound-cloud'
			]
		);

		$this->add_control(
			'playlist_url',
			[
				'label'     => esc_html__( 'Playlist URL', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'playlist_type' => array( 'spotify' )
				]
			]
		);

		$this->add_control(
			'playlist_skin',
			[
				'label'     => esc_html__( 'Playlist Skin', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'dark' => esc_html__( 'Dark', 'select-core'),
					'light' => esc_html__( 'Light', 'select-core')
				),
				'default' => 'dark',
				'condition' => [
					'playlist_type' => array( 'spotify', 'bandcamp' )
				]
			]
		);

		$this->add_control(
			'playlist_id',
			[
				'label'     => esc_html__( 'Playlist ID', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'playlist_type' => array( 'sound-cloud', 'bandcamp' )
				]
			]
		);

		$this->add_control(
			'playlist_color',
			[
				'label'     => esc_html__( 'Playlist Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'playlist_type' => array( 'sound-cloud', 'bandcamp' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();


        $playlist_type = $params['playlist_type'];
        $playlist_id = $params['playlist_id'];
        $playlist_color = $params['playlist_color'];
        $playlist_skin = $params['playlist_skin'];
        $playlist_url = $params['playlist_url'];

        if ($playlist_type == "sound-cloud") {
            $playlist_id_url = "https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/playlists/";
            if ($playlist_id !== '') {
                $playlist_id_url .= $playlist_id;
            }
            if ($playlist_color !== '') {
                $playlist_color = substr($playlist_color, 1);
                $playlist_id_url .= "&amp;color=".$playlist_color;
            }

            $params['playlist_id_url'] = $playlist_id_url;
        }


        if ($playlist_type == "spotify") {
            if ($playlist_skin == "light"){
                $playlist_url .= "&theme=white";
                $params['playlist_url'] = $playlist_url;
            }
        }

        if ($playlist_type == "bandcamp") {
            $playlist_id_url = "https://bandcamp.com/EmbeddedPlayer/album=";
            if ($playlist_id !== '') {
                $playlist_id_url .= $playlist_id;
            }
            if ($playlist_skin == "light"){
                $playlist_id_url .= "/bgcol=ffffff";
            }
            else {
                $playlist_id_url .= "/bgcol=333333";
            }

            $playlist_id_url .= "/size=large";

            if ($playlist_color !== '') {
                $playlist_color = substr($playlist_color, 1);
                $playlist_id_url .= "/linkcol=".$playlist_color;
            }

            $params['playlist_id_url'] = $playlist_id_url."/artwork=small/transparent=true/";
        }

        echo qodef_core_get_shortcode_template_part('templates/'.$playlist_type.'-playlist-template', 'audio-playlist', '', $params);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorAudioPlaylist() );