<?php
class SelectCoreElementorAlbumDisc extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_album_disc'; 
	}

	public function get_title() {
		return esc_html__( 'Album Disc', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-album-disc';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'cd_case_image',
			[
				'label'     => esc_html__( 'CD Case Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA
			]
		);

		$this->add_control(
			'cd_image',
			[
				'label'     => esc_html__( 'CD Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Set an image to be placed upon the CD template', 'select-core' )
			]
		);

		$this->add_control(
			'cd_image_outer_border_color',
			[
				'label'     => esc_html__( 'CD Image Outer Border Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Link Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Same Window', 'select-core'),
					'_blank' => esc_html__( 'New Window', 'select-core')
				),
				'default' => '_self'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'behavior',
			[
				'label' => esc_html__( 'Behavior', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'animate',
			[
				'label'     => esc_html__( 'Animate', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'appear' => esc_html__( 'On Appear', 'select-core'),
					'hover' => esc_html__( 'On Hover', 'select-core')
				),
				'default' => 'appear'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		$params['cd_case_image']    = !empty($params['cd_case_image']) ? $params['cd_case_image']['id'] : $params['cd_case_image'];
		$params['cd_image']         = !empty($params['cd_image']) ? $params['cd_image']['id'] : $params['cd_image'];

		$params['holder_classes'] = $this->getHolderClasses($params);
        $params['cd_image_styles'] = $this->getCDImageStyles($params);

		echo qodef_core_get_shortcode_template_part('templates/album-disc-template', 'album-disc', '', $params);

	}

    private function getHolderClasses($params) {
        $holder_classes = array();

        if ($params['animate'] !== '') {
            $holder_classes[] = 'qodef-animate-on-'. $params['animate'];
        }

        return implode(' ', $holder_classes);
    }

    private function getCDImageStyles($params) {
        $styles = array();

        if(!empty($params['cd_image_outer_border_color'])) {
            $styles[] = 'border-color: '.$params['cd_image_outer_border_color'];
        }

        return $styles;
    }

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorAlbumDisc() );