<?php
class SelectCoreElementorCarousel extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_carousel'; 
	}

	public function get_title() {
		return esc_html__( 'Carousel', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-carousel';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'carousel',
			[
				'label'     => esc_html__( 'Carousel Slider', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'carousel-white' => esc_html__( 'Carousel White', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'     => esc_html__( 'Order By', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'title' => esc_html__( 'Title', 'select-core'),
					'date' => esc_html__( 'Date', 'select-core')
				),
				'default' => 'date'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'ASC' => esc_html__( 'ASC', 'select-core'),
					'DESC' => esc_html__( 'DESC', 'select-core')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'number_of_items',
			[
				'label'     => esc_html__( 'Number of items showing', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'3' => esc_html__( '3', 'select-core'),
					'4' => esc_html__( '4', 'select-core'),
					'5' => esc_html__( '5', 'select-core'),
					'6' => esc_html__( '6', 'select-core'),
					'8' => esc_html__( '8', 'select-core')
				),
				'default' => '5'
			]
		);

		$this->add_control(
			'image_animation',
			[
				'label'     => esc_html__( 'Image Animation', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Note: Only on &quot;Image Change&quot; zoom image will be used', 'select-core' ),
				'options' => array(
					'image-change' => esc_html__( 'Image Change', 'select-core'),
					'image-zoom' => esc_html__( 'Image Zoom', 'select-core')
				),
				'default' => 'image-change'
			]
		);

		$this->add_control(
			'show_arrows_navigation',
			[
				'label'     => esc_html__( 'Show Arrows navigation?', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'show_dots_navigation',
			[
				'label'     => esc_html__( 'Show Dots navigation?', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		$params['carousel_data_attributes'] = $this->getCarouselDataAttributes($params);


        if ($params['carousel'] !== '') { ?>

            <div class="qodef-carousel-holder clearfix">
                <div class="qodef-carousel qodef-slick-slider-navigation-style" <?php echo mixtape_qodef_get_inline_attrs($params['carousel_data_attributes']); ?>>
					<?php
						$args = array(
							'post_type' => 'carousels',
							'carousels_category' => $params['carousel'],
							'orderby' => $params['orderby'],
							'order' => $params['order'],
							'posts_per_page' => '-1'
						);
			            $query = new \WP_Query($args);

			            if ($query->have_posts()) {
			                while($query->have_posts()) {
			                    $query->the_post();
			                    $carousel_item = $this->getCarouselItemData(get_the_ID(), $params);
			                    echo qodef_core_get_cpt_shortcode_template_part('carousels', 'carousel-template', '', $carousel_item);
			                }
			            }
						wp_reset_postdata();
					?>
                </div>
            </div>
<?php
        }
	}

    private function getCarouselItemData($item_id, $params) {

        $carousel_item = array();

        if (($meta_temp = get_post_meta($item_id, 'qodef_carousel_image', true)) !== '') {
            $carousel_item['image'] = $meta_temp;
        } else {
            $carousel_item['image'] = '';
        }

        if ($params['image_animation'] == 'image-change' && ($meta_temp = get_post_meta($item_id, 'qodef_carousel_hover_image', true)) !== '') {
            $carousel_item['hover_image'] = $meta_temp;
            $carousel_item['hover_class'] = 'qodef-has-hover-image';
        } else {
            $carousel_item['hover_image'] = '';
            $carousel_item['hover_class'] = '';
        }

        if (($meta_temp = get_post_meta($item_id, 'qodef_carousel_item_link', true)) != '') {
            $carousel_item['link'] = $meta_temp;
        } else {
            $carousel_item['link'] = '';
        }

        if (($meta_temp = get_post_meta($item_id, 'qodef_carousel_item_target', true)) != '') {
            $carousel_item['target'] = $meta_temp;
        } else {
            $carousel_item['target'] = '_self';
        }

        $carousel_item['title'] = get_the_title();

        $carousel_item['carousel_image_classes'] = $this->getCarouselImageClasses($params);

        return $carousel_item;

    }

	private function getCarouselImageClasses($params) {

		$carousel_image_classes = array();
		if($params['image_animation'] !== '') {
			$carousel_image_classes[] = 'qodef-' . $params['image_animation'];
		}

		return implode(' ', $carousel_image_classes);

	}

	private function getCarouselDataAttributes($params) {

		$carousel_data = array();

		if ($params['number_of_items'] !== '') {
			$carousel_data['data-items'] = $params['number_of_items'];
		}
		if ($params['show_arrows_navigation'] !== '') {
			$carousel_data['data-arrows-navigation'] = $params['show_arrows_navigation'];
		}
		if ($params['show_dots_navigation'] !== '') {
			$carousel_data['data-dots-navigation'] = $params['show_dots_navigation'];
		}

		return $carousel_data;

	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorCarousel() );